#ifndef _KGR_PATCH_BSC1099306_KVM_INTEL_H
#define _KGR_PATCH_BSC1099306_KVM_INTEL_H

#if IS_ENABLED(CONFIG_X86_64) && IS_ENABLED(CONFIG_KVM)

int __kgr_patch_bsc1099306_kvm_intel_init(void);
void __kgr_patch_bsc1099306_kvm_intel_cleanup(void);


struct kvm_vcpu;
void kgr_vmx_save_host_state(struct kvm_vcpu *vcpu);
void kgr_vmx_handle_external_intr(struct kvm_vcpu *vcpu);
int kgr_handle_vmlaunch(struct kvm_vcpu *vcpu);
int kgr_handle_vmresume(struct kvm_vcpu *vcpu);

#define __KGR_PATCH_BSC1099306_KVM_INTEL_FUNCS				\
	KGR_PATCH_OBJ(vmx_save_host_state,			\
			kgr_vmx_save_host_state, "kvm_intel"),	\
	KGR_PATCH_OBJ(vmx_handle_external_intr,			\
			kgr_vmx_handle_external_intr, "kvm_intel"),	\
	KGR_PATCH_OBJ(handle_vmlaunch,					\
			kgr_handle_vmlaunch, "kvm_intel"),		\
	KGR_PATCH_OBJ(handle_vmresume,					\
			kgr_handle_vmresume, "kvm_intel"),		\


#endif /* IS_ENABLED(CONFIG_X86_64) && IS_ENABLED(CONFIG_KVM) */

#endif /* _KGR_PATCH_BSC1099306_KVM_INTEL_H */
