/*
 * kgraft_patch_bsc1099306
 *
 * Fix for CVE-2018-3646, bsc#1099306
 *
 *  Upstream commit:
 *  none yet
 *
 *  SLE12 commit:
 *  none yet
 *
 *  SLE12-SP1 commit
 *  none yet
 *
 *  SLE12-SP2 commit:
 *  none yet
 *
 *  SLE12-SP3 commits:
 *  aa543fea2fef31c3c74941162f618172c3ecdce7
 *  3d1482acbe6776b27c687c0b5f50e5930119ee9b
 *  3eea10e53b60be7e52b4c63374744787ecb97076
 *  9c2cd4dbd4f1c173392730e3b7da6cde3bcff086
 *  68a781200780b424c97fd1f44f900c81adf810f9
 *
 *  SLE15 commits:
 *  bc19bc75fbb7400a0c4f8b2d85f4371b32c030c1
 *  e3ea7f331bdd5b9e582cf225efb1890cee2d85e3
 *  7ffd8ffea589eb271069de635a78d3efa28c4264
 *  e9c295528cd8681eb60ffae07fbc287f3b10ba31
 *  4a9535617e62a37dd477fd5e2b51f86c1f0dcfc5
 *  85644246fb14317688b1d5a4048d6936e1f5dfb9
 *  (4b6a8a97cf42cd6008ec782b43461180cf80019c)
 *  (251e13546c70bb432f98319f4f39f3125a30f725)
 *  (4c4aea41570747f6f30cf11ddcb341b554d93fa2)
 *  (6af910f2646c32fd521bc780c4d252c341e22274)
 *  (0c0fd378df4f4ed5a575b3a4eec0bed7996a35ba)
 *
 *  Copyright (c) 2018 SUSE
 *  Author: Nicolai Stange <nstange@suse.de>
 *
 *  Based on the original Linux kernel code. Other copyrights apply.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#if IS_ENABLED(CONFIG_X86_64) && IS_ENABLED(CONFIG_KVM)

#include <linux/kernel.h>
#include "shadow.h"
#include "kgr_patch_bsc1099306.h"
#include "bsc1099306.h"

#define KGR_BSC1099306_SHADOW_VCPU_UNCONFINED_ID	\
	KGR_SHADOW_ID(1099306, 0)


void kgr_set_vcpu_unconfined(struct kvm_vcpu *vcpu, gfp_t gfp_flags)
{
	bool *unconfined;

	if (kgr_never_needs_l1d_flush())
		return;

	unconfined = klp_shadow_get_or_alloc
			(vcpu, KGR_BSC1099306_SHADOW_VCPU_UNCONFINED_ID,
			 NULL, sizeof(bool), gfp_flags);
	if (!unconfined)
		return;
	*unconfined = true;
}

bool kgr_get_and_clear_vcpu_unconfined(struct kvm_vcpu *vcpu, gfp_t gfp_flags)
{
	bool *unconfined;
	bool val = true;

	if (kgr_never_needs_l1d_flush())
		return false;

	/*
	 * If there's no shadow variable yet or if the allocation
	 * fails, default to 'unconfined'.
	 */
	unconfined = klp_shadow_get_or_alloc
			(vcpu, KGR_BSC1099306_SHADOW_VCPU_UNCONFINED_ID,
			 &val, sizeof(bool), gfp_flags);
	if (!unconfined)
		return true;

	val = *unconfined;
	*unconfined = false;
	return val;
}

void kgr_free_vcpu_unconfined_shadow(struct kvm_vcpu *vcpu)
{
	if (kgr_never_needs_l1d_flush())
		return;
	klp_shadow_free(vcpu, KGR_BSC1099306_SHADOW_VCPU_UNCONFINED_ID);
}



int kgr_patch_bsc1099306_init(void)
{
	int ret;

	ret = __kgr_patch_bsc1099306_irq_init();
	if (ret)
		return ret;

	ret = __kgr_patch_bsc1099306_kvm_init();
	if (ret)
		return ret;

	ret = __kgr_patch_bsc1099306_kvm_intel_init();
	if (ret) {
		__kgr_patch_bsc1099306_kvm_cleanup();
		return ret;
	}

	if (!kgr_never_needs_l1d_flush()) {
		ret = kgr_shadow_init();
		if (ret) {
			__kgr_patch_bsc1099306_kvm_cleanup();
			__kgr_patch_bsc1099306_kvm_intel_cleanup();
			return ret;
		}
	}

	return 0;
}

void kgr_patch_bsc1099306_cleanup(void)
{
	if (!kgr_never_needs_l1d_flush())
		kgr_shadow_cleanup();
	__kgr_patch_bsc1099306_kvm_intel_cleanup();
	__kgr_patch_bsc1099306_kvm_cleanup();
}

#endif /* IS_ENABLED(CONFIG_X86_64) && IS_ENABLED(CONFIG_KVM) */
