/*
 * kgraft_patch_bsc1025013
 *
 * Fix for CVE-2017-5970, bsc#1025013
 *
 *  SLE12(-SP1) commit:
 *  e8246928ba2f9294fc56c23d2ba9c67e2537f501
 *
 *  Copyright (c) 2016 SUSE
 *  Author: Miroslav Benes <mbenes@suse.cz>
 *
 *  Based on the original Linux kernel code. Other copyrights apply.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/kallsyms.h>
#include <linux/skbuff.h>
#include <linux/in.h>
#include <net/route.h>
#include <net/ip.h>

static __be32 (*kgr_fib_compute_spec_dst)(struct sk_buff *skb);

static struct {
	char *name;
	void **addr;
} kgr_funcs[] = {
	{ "fib_compute_spec_dst", (void *)&kgr_fib_compute_spec_dst },
};

#define PKTINFO_SKB_CB(__skb) ((struct in_pktinfo *)((__skb)->cb))

/* patched function */
void kgr_ipv4_pktinfo_prepare(struct sk_buff *skb)
{
	struct in_pktinfo *pktinfo = PKTINFO_SKB_CB(skb);

	if (skb_rtable(skb)) {
		pktinfo->ipi_ifindex = inet_iif(skb);
		pktinfo->ipi_spec_dst.s_addr = kgr_fib_compute_spec_dst(skb);
	} else {
		pktinfo->ipi_ifindex = 0;
		pktinfo->ipi_spec_dst.s_addr = 0;
	}
	/*
	 * Fix CVE-2017-5970
	 *  -skb_dst_drop(skb);
	 *  +8 lines
	 */
	/* We need to keep the dst for __ip_options_echo()
	 * We could restrict the test to opt.ts_needtime || opt.srr,
	 * but the following is good enough as IP options are not often used.
	 */
	if (unlikely(IPCB(skb)->opt.optlen))
		skb_dst_force(skb);
	else
		skb_dst_drop(skb);
}

static int kgr_patch_bsc1025013_kallsyms(void)
{
	unsigned long addr;
	int i;

	for (i = 0; i < ARRAY_SIZE(kgr_funcs); i++) {
		addr = kallsyms_lookup_name(kgr_funcs[i].name);
		if (!addr) {
			pr_err("kgraft-patch: symbol %s not resolved\n",
				kgr_funcs[i].name);
			return -ENOENT;
		}

		*(kgr_funcs[i].addr) = (void *)addr;
	}

	return 0;
}

int kgr_patch_bsc1025013_init(void)
{
	return kgr_patch_bsc1025013_kallsyms();
}
