#ifndef _LIVEPATCH_BSC1251983_H
#define _LIVEPATCH_BSC1251983_H

#include <linux/types.h>

#if IS_ENABLED(CONFIG_BT)

int livepatch_bsc1251983_init(void);
void livepatch_bsc1251983_cleanup(void);

struct hci_dev;
struct sk_buff;

typedef void (*hci_req_complete_t)(struct hci_dev *hdev, u8 status, u16 opcode);
typedef void (*hci_req_complete_skb_t)(struct hci_dev *hdev, u8 status,
				       u16 opcode, struct sk_buff *skb);

void klpp_hci_cmd_status_evt(struct hci_dev *hdev, struct sk_buff *skb, u16 *opcode, u8 *status, hci_req_complete_t *req_complete, hci_req_complete_skb_t *req_complete_skb);
#else /* !IS_ENABLED(CONFIG_BT) */

static inline int livepatch_bsc1251983_init(void) { return 0; }
static inline void livepatch_bsc1251983_cleanup(void) {}


#endif /* IS_ENABLED(CONFIG_BT) */

#endif /* _LIVEPATCH_BSC1251983_H */
