/*
 * livepatch_bsc1249455
 *
 * Fix for CVE-2025-38111, bsc#1249455
 *
 *  Copyright (c) 2026 SUSE
 *  Author: Ali Abdallah <ali.abdallah@suse.de>
 *
 *  Based on the original Linux kernel code. Other copyrights apply.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */


#include <linux/delay.h>
#include <linux/device.h>
#include <linux/errno.h>
#include <linux/etherdevice.h>
#include <linux/ethtool.h>

/* klp-ccp: from drivers/net/phy/mdio_bus.c */
#include <linux/gpio/consumer.h>
#include <linux/init.h>
#include <linux/interrupt.h>
#include <linux/io.h>
#include <linux/kernel.h>
#include <linux/mii.h>
#include <linux/mm.h>
#include <linux/module.h>
#include <linux/netdevice.h>

#include <linux/of_mdio.h>

/* klp-ccp: from drivers/net/phy/mdio_bus.c */
#include <linux/phy.h>

#include <linux/skbuff.h>
#include <linux/slab.h>
#include <linux/spinlock.h>
#include <linux/string.h>
#include <linux/uaccess.h>
#include <linux/unistd.h>

/* klp-ccp: from include/trace/events/mdio.h */
#if !defined(_TRACE_MDIO_H) || defined(TRACE_HEADER_MULTI_READ)

#include <linux/tracepoint.h>

/* klp-ccp: from include/trace/events/mdio.h */
#include "klp_trace.h"

KLPR_TRACE_EVENT_CONDITION(mdio_access,
	TP_PROTO(struct mii_bus *bus, char read,
		 u8 addr, unsigned regnum, u16 val, int err),
	TP_ARGS(bus, read, addr, regnum, val, err),
	TP_CONDITION(err >= 0))

#else
#error "klp-ccp: a preceeding branch should have been taken"
#endif /* if !defined(_TRACE_MDIO_H) || defined(TRACE_HEADER_MULTI_READ) */

/* klp-ccp: from drivers/net/phy/mdio-boardinfo.h */
#include <linux/phy.h>
#include <linux/mutex.h>

/* klp-ccp: from drivers/net/phy/mdio_bus.c */
static void mdiobus_stats_acct(struct mdio_bus_stats *stats, bool op, int ret)
{
	preempt_disable();
	u64_stats_update_begin(&stats->syncp);

	u64_stats_inc(&stats->transfers);
	if (ret < 0) {
		u64_stats_inc(&stats->errors);
		goto out;
	}

	if (op)
		u64_stats_inc(&stats->reads);
	else
		u64_stats_inc(&stats->writes);
out:
	u64_stats_update_end(&stats->syncp);
	preempt_enable();
}

int klpp___mdiobus_read(struct mii_bus *bus, int addr, u32 regnum)
{
	int retval;

	lockdep_assert_held_once(&bus->mdio_lock);

	if (addr >= PHY_MAX_ADDR)
		return -ENXIO;

	retval = bus->read(bus, addr, regnum);

	klpr_trace_mdio_access(bus, 1, addr, regnum, retval, retval);
	mdiobus_stats_acct(&bus->stats[addr], true, retval);

	return retval;
}

typeof(klpp___mdiobus_read) klpp___mdiobus_read;

int klpp___mdiobus_write(struct mii_bus *bus, int addr, u32 regnum, u16 val)
{
	int err;

	lockdep_assert_held_once(&bus->mdio_lock);

	if (addr >= PHY_MAX_ADDR)
		return -ENXIO;

	err = bus->write(bus, addr, regnum, val);

	klpr_trace_mdio_access(bus, 0, addr, regnum, val, err);
	mdiobus_stats_acct(&bus->stats[addr], false, err);

	return err;
}

typeof(klpp___mdiobus_write) klpp___mdiobus_write;


#include "livepatch_bsc1249455.h"

#include <linux/kernel.h>
#include <linux/module.h>
#include "../kallsyms_relocs.h"

#define LP_MODULE "libphy"

static struct klp_kallsyms_reloc klp_funcs[] = {
	{ "__traceiter_mdio_access", (void *)&klpe___traceiter_mdio_access,
	  "libphy" },
	{ "__tracepoint_mdio_access", (void *)&klpe___tracepoint_mdio_access,
	  "libphy" },
};

static int module_notify(struct notifier_block *nb,
			unsigned long action, void *data)
{
	struct module *mod = data;
	int ret;

	if (action != MODULE_STATE_COMING || strcmp(mod->name, LP_MODULE))
		return 0;
	ret = klp_resolve_kallsyms_relocs(klp_funcs, ARRAY_SIZE(klp_funcs));

	WARN(ret, "%s: delayed kallsyms lookup failed. System is broken and can crash.\n",
		__func__);

	return ret;
}

static struct notifier_block module_nb = {
	.notifier_call = module_notify,
	.priority = INT_MIN+1,
};

int livepatch_bsc1249455_init(void)
{
	int ret;
	struct module *mod;

	ret = klp_kallsyms_relocs_init();
	if (ret)
		return ret;

	ret = register_module_notifier(&module_nb);
	if (ret)
		return ret;

	rcu_read_lock_sched();
	mod = (*klpe_find_module)(LP_MODULE);
	if (!try_module_get(mod))
		mod = NULL;
	rcu_read_unlock_sched();

	if (mod) {
		ret = klp_resolve_kallsyms_relocs(klp_funcs,
						ARRAY_SIZE(klp_funcs));
	}

	if (ret)
		unregister_module_notifier(&module_nb);
	module_put(mod);

	return ret;
}

void livepatch_bsc1249455_cleanup(void)
{
	unregister_module_notifier(&module_nb);
}

