/*
 * livepatch_bsc1239096
 *
 * Fix for CVE-2024-58013, bsc#1239096
 *
 *  Upstream commit:
 *  26fbd3494a7d ("Bluetooth: MGMT: Fix slab-use-after-free Read in mgmt_remove_adv_monitor_sync")
 *
 *  SLE12-SP5 commit:
 *  Not affected
 *
 *  SLE15-SP3 commit:
 *  Not affected
 *
 *  SLE15-SP4 and -SP5 commit:
 *  Not affected
 *
 *  SLE15-SP6 commit:
 *  8a1abea9f99bca9381b8904f5416f57fe176d22c
 *
 *  SLE MICRO-6-0 commit:
 *  8a1abea9f99bca9381b8904f5416f57fe176d22c
 *
 *  Copyright (c) 2025 SUSE
 *  Author: Vincenzo Mezzela <vincenzo.mezzela@suse.com>
 *
 *  Based on the original Linux kernel code. Other copyrights apply.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#if IS_ENABLED(CONFIG_BT)

#if !IS_MODULE(CONFIG_BT)
#error "Live patch supports only CONFIG=m"
#endif

/* klp-ccp: from net/bluetooth/mgmt.c */
#include <linux/module.h>

/* klp-ccp: from include/asm-generic/unaligned.h */
#define __ASM_GENERIC_UNALIGNED_H

/* klp-ccp: from net/bluetooth/mgmt.c */
#include <net/bluetooth/bluetooth.h>
#include <net/bluetooth/hci_core.h>
#include <net/bluetooth/hci_sock.h>

#include <net/bluetooth/mgmt.h>

/* klp-ccp: from net/bluetooth/hci_request.h */
#include <asm/unaligned.h>

/* klp-ccp: from net/bluetooth/mgmt_util.h */
struct mgmt_pending_cmd {
	struct list_head list;
	u16 opcode;
	int index;
	void *param;
	size_t param_len;
	struct sock *sk;
	struct sk_buff *skb;
	void *user_data;
	int (*cmd_complete)(struct mgmt_pending_cmd *cmd, u8 status);
};

int mgmt_cmd_complete(struct sock *sk, u16 index, u16 cmd, u8 status,
		      void *rp, size_t rp_len);

struct mgmt_pending_cmd *mgmt_pending_find(unsigned short channel, u16 opcode,
					   struct hci_dev *hdev);

void mgmt_pending_remove(struct mgmt_pending_cmd *cmd);

/* klp-ccp: from net/bluetooth/eir.h */
#include <asm/unaligned.h>

/* klp-ccp: from net/bluetooth/mgmt.c */
extern const u8 mgmt_status_table[64];

extern u8 mgmt_errno_status(int err);

static u8 mgmt_status(int err)
{
	if (err < 0)
		return mgmt_errno_status(err);

	if (err < ARRAY_SIZE(mgmt_status_table))
		return mgmt_status_table[err];

	return MGMT_STATUS_FAILED;
}

static struct mgmt_pending_cmd *pending_find(u16 opcode, struct hci_dev *hdev)
{
	return mgmt_pending_find(HCI_CHANNEL_CONTROL, opcode, hdev);
}

void klpp_mgmt_remove_adv_monitor_complete(struct hci_dev *hdev,
					     void *data, int status)
{
	struct mgmt_rp_remove_adv_monitor rp;
	struct mgmt_pending_cmd *cmd = data;
	struct mgmt_cp_remove_adv_monitor *cp;

	if (status == -ECANCELED ||
	    cmd != pending_find(MGMT_OP_REMOVE_ADV_MONITOR, hdev))
		return;

	hci_dev_lock(hdev);

	cp = cmd->param;

	rp.monitor_handle = cp->monitor_handle;

	if (!status)
		hci_update_passive_scan(hdev);

	mgmt_cmd_complete(cmd->sk, cmd->index, cmd->opcode,
			  mgmt_status(status), &rp, sizeof(rp));
	mgmt_pending_remove(cmd);

	hci_dev_unlock(hdev);
	bt_dev_dbg(hdev, "remove monitor %d complete, status %d",
		   rp.monitor_handle, status);
}

int klpp_mgmt_remove_adv_monitor_sync(struct hci_dev *hdev, void *data)
{
	struct mgmt_pending_cmd *cmd = data;

	if (cmd != pending_find(MGMT_OP_REMOVE_ADV_MONITOR, hdev))
		return -ECANCELED;

	struct mgmt_cp_remove_adv_monitor *cp = cmd->param;
	u16 handle = __le16_to_cpu(cp->monitor_handle);

	if (!handle)
		return hci_remove_all_adv_monitor(hdev);

	return hci_remove_single_adv_monitor(hdev, handle);
}


#include "livepatch_bsc1239096.h"

#include <linux/livepatch.h>

extern typeof(hci_remove_all_adv_monitor) hci_remove_all_adv_monitor
	 KLP_RELOC_SYMBOL(bluetooth, bluetooth, hci_remove_all_adv_monitor);
extern typeof(hci_remove_single_adv_monitor) hci_remove_single_adv_monitor
	 KLP_RELOC_SYMBOL(bluetooth, bluetooth, hci_remove_single_adv_monitor);
extern typeof(hci_update_passive_scan) hci_update_passive_scan
	 KLP_RELOC_SYMBOL(bluetooth, bluetooth, hci_update_passive_scan);
extern typeof(mgmt_cmd_complete) mgmt_cmd_complete
	 KLP_RELOC_SYMBOL(bluetooth, bluetooth, mgmt_cmd_complete);
extern typeof(mgmt_errno_status) mgmt_errno_status
	 KLP_RELOC_SYMBOL(bluetooth, bluetooth, mgmt_errno_status);
extern typeof(mgmt_pending_find) mgmt_pending_find
	 KLP_RELOC_SYMBOL(bluetooth, bluetooth, mgmt_pending_find);
extern typeof(mgmt_pending_remove) mgmt_pending_remove
	 KLP_RELOC_SYMBOL(bluetooth, bluetooth, mgmt_pending_remove);
extern typeof(mgmt_status_table) mgmt_status_table
	 KLP_RELOC_SYMBOL(bluetooth, bluetooth, mgmt_status_table);

#endif /* IS_ENABLED(CONFIG_BT) */
