# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

## [0.19.4] - 2025-11-16

### Added
 - Support `try_into` keyword in field definition to use `TryInto` instead of `Into`

### Fixed
  - Print the correct error message on incorrect use of the `impl` in `no_std` crates, thanks to @stop5 for reporting and proposing the fix

## [0.19.3] - 2025-10-10

### Added
 - In debug mode, check that msb >= lsb in the default `BitRange`/`BitRangeMut` implementations and show a more helpful
   message than before if this is the case, thanks to @blaine-dodson for reporting
 - Mention MSB and LSB ordering in the readme
 - Explain sign extension and valid range of signed field in the readme

## [0.19.2] - 2025-08-24

### Fixed
- Allow usage of a signed int types for the base of newtype, thanks to @FeeeeK

## [0.19.1] - 2025-05-14

### Fixed
- Allow to use `impl new` with `#[deny(missing_docs)]`.

## [0.19.0] - 2025-02-23

### Fixed
- Allow to specify an array of bools.

### Breaking Changes
- If the type of an array field is exactly `bool`, then the `Bit`/`BitMut` traits are used instead of
  `BitRange`/`BitRangeMut`. In some very unlikely case where the traits are implemented manually, this may break
  existing code.

## [0.18.1] - 2025-01-29

### Fixed
- Don't use `__bitfield_*` macros from the code generated by the proc-macros. Otherwise, they need to be imported by 
  the calling code.
- Allow `mask`, `from` and `ìnto` as getter names.

## [0.18.0] - 2025-01-27

### Fixed
- With the new proc macro implementation some corner-cases that were not handled are now handled correctly.

### Breaking Changes
- The syntax to create a constructor by specifying individual fields has been removed.
- Some syntax that was supposed to be internal and implementation details are now rejected.

## [0.17.0] - 2024-09-08

### Breaking Changes
- Changes published as 0.16.2 (version now yanked) was breaking

## [0.16.2] - 2024-09-07

### Added
- Allow creating bitfield structs with arbitrary visibilities, thanks to @ADSteele916

## [0.16.1] - 2024-07-25

### Added
- Implement bitwise operations for all array-Like inner types, using `AsRef`/`AsMut`, thanks to @PokeJofeJr4th
- Allow to derive constructors, thanks to @PokeJofeJr4th

## [0.16.0] - 2024-07-22

### Added
 - Easily Derive Bitwise Operations, thanks to @PokeJofeJr4th

### Breaking Changes
 - The minimum rustc version is now 1.79.0

## [0.15.0] - 2024-04-09

### Added
 - Allow to generate mask for a field

### Breaking Changes
 - The minimum rustc version is now 1.46.0

## [0.14.0] - 2022-07-11

### Added
 - Getters work with immutable Data

### Breaking Changes
 - The minimum rustc version is now 1.31.0
 - The setters of the `BitRange` and `Bit` has been separated in the `BitRangeMut` and `BitMut` traits.

## [0.13.2] - 2019-05-28

### Added
- `from into` can be used in place of `from` to change the input type of the setter. Thanks to @roblabla

[Unreleased]: https://github.com/dzamlo/rust-bitfield/compare/v0.19.4...HEAD
[0.19.4]: https://github.com/dzamlo/rust-bitfield/compare/v0.19.3...v0.19.4
[0.19.3]: https://github.com/dzamlo/rust-bitfield/compare/v0.19.2...v0.19.3
[0.19.2]: https://github.com/dzamlo/rust-bitfield/compare/v0.19.1...v0.19.2
[0.19.1]: https://github.com/dzamlo/rust-bitfield/compare/v0.19.0...v0.19.1
[0.19.0]: https://github.com/dzamlo/rust-bitfield/compare/v0.18.1...v0.19.0
[0.18.1]: https://github.com/dzamlo/rust-bitfield/compare/v0.18.0...v0.18.1
[0.18.0]: https://github.com/dzamlo/rust-bitfield/compare/v0.17.0...v0.18.0
[0.17.0]: https://github.com/dzamlo/rust-bitfield/compare/v0.16.2...v0.17.0
[0.16.2]: https://github.com/dzamlo/rust-bitfield/compare/v0.16.0...v0.16.2
[0.16.1]: https://github.com/dzamlo/rust-bitfield/compare/v0.16.0...v0.16.1
[0.16.0]: https://github.com/dzamlo/rust-bitfield/compare/v0.15.0...v0.16.0
[0.15.0]: https://github.com/dzamlo/rust-bitfield/compare/v0.14.0...v0.15.0
[0.14.0]: https://github.com/dzamlo/rust-bitfield/compare/v0.13.2...v0.14.0
[0.13.2]: https://github.com/dzamlo/rust-bitfield/compare/v0.13.1...v0.13.2

