//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by conversion-gen. DO NOT EDIT.

package api

import (
	unsafe "unsafe"

	corev1 "k8s.io/api/core/v1"
	v1 "k8s.io/api/resource/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(s *runtime.Scheme) error {
	if err := s.AddGeneratedConversionFunc((*CounterSet)(nil), (*v1.CounterSet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_api_CounterSet_To_v1_CounterSet(a.(*CounterSet), b.(*v1.CounterSet), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.CounterSet)(nil), (*CounterSet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_CounterSet_To_api_CounterSet(a.(*v1.CounterSet), b.(*CounterSet), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Device)(nil), (*v1.Device)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_api_Device_To_v1_Device(a.(*Device), b.(*v1.Device), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.Device)(nil), (*Device)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_Device_To_api_Device(a.(*v1.Device), b.(*Device), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*DeviceCounterConsumption)(nil), (*v1.DeviceCounterConsumption)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_api_DeviceCounterConsumption_To_v1_DeviceCounterConsumption(a.(*DeviceCounterConsumption), b.(*v1.DeviceCounterConsumption), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DeviceCounterConsumption)(nil), (*DeviceCounterConsumption)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DeviceCounterConsumption_To_api_DeviceCounterConsumption(a.(*v1.DeviceCounterConsumption), b.(*DeviceCounterConsumption), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ResourcePool)(nil), (*v1.ResourcePool)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_api_ResourcePool_To_v1_ResourcePool(a.(*ResourcePool), b.(*v1.ResourcePool), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.ResourcePool)(nil), (*ResourcePool)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ResourcePool_To_api_ResourcePool(a.(*v1.ResourcePool), b.(*ResourcePool), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ResourceSlice)(nil), (*v1.ResourceSlice)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_api_ResourceSlice_To_v1_ResourceSlice(a.(*ResourceSlice), b.(*v1.ResourceSlice), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.ResourceSlice)(nil), (*ResourceSlice)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ResourceSlice_To_api_ResourceSlice(a.(*v1.ResourceSlice), b.(*ResourceSlice), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ResourceSliceSpec)(nil), (*v1.ResourceSliceSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_api_ResourceSliceSpec_To_v1_ResourceSliceSpec(a.(*ResourceSliceSpec), b.(*v1.ResourceSliceSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.ResourceSliceSpec)(nil), (*ResourceSliceSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ResourceSliceSpec_To_api_ResourceSliceSpec(a.(*v1.ResourceSliceSpec), b.(*ResourceSliceSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*UniqueString)(nil), (*string)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_api_UniqueString_To_string(a.(*UniqueString), b.(*string), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*string)(nil), (*UniqueString)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_string_To_api_UniqueString(a.(*string), b.(*UniqueString), scope)
	}); err != nil {
		return err
	}
	return nil
}

func autoConvert_api_CounterSet_To_v1_CounterSet(in *CounterSet, out *v1.CounterSet, s conversion.Scope) error {
	if err := Convert_api_UniqueString_To_string(&in.Name, &out.Name, s); err != nil {
		return err
	}
	out.Counters = *(*map[string]v1.Counter)(unsafe.Pointer(&in.Counters))
	return nil
}

// Convert_api_CounterSet_To_v1_CounterSet is an autogenerated conversion function.
func Convert_api_CounterSet_To_v1_CounterSet(in *CounterSet, out *v1.CounterSet, s conversion.Scope) error {
	return autoConvert_api_CounterSet_To_v1_CounterSet(in, out, s)
}

func autoConvert_v1_CounterSet_To_api_CounterSet(in *v1.CounterSet, out *CounterSet, s conversion.Scope) error {
	if err := Convert_string_To_api_UniqueString(&in.Name, &out.Name, s); err != nil {
		return err
	}
	out.Counters = *(*map[string]v1.Counter)(unsafe.Pointer(&in.Counters))
	return nil
}

// Convert_v1_CounterSet_To_api_CounterSet is an autogenerated conversion function.
func Convert_v1_CounterSet_To_api_CounterSet(in *v1.CounterSet, out *CounterSet, s conversion.Scope) error {
	return autoConvert_v1_CounterSet_To_api_CounterSet(in, out, s)
}

func autoConvert_api_Device_To_v1_Device(in *Device, out *v1.Device, s conversion.Scope) error {
	if err := Convert_api_UniqueString_To_string(&in.Name, &out.Name, s); err != nil {
		return err
	}
	out.Attributes = *(*map[v1.QualifiedName]v1.DeviceAttribute)(unsafe.Pointer(&in.Attributes))
	out.Capacity = *(*map[v1.QualifiedName]v1.DeviceCapacity)(unsafe.Pointer(&in.Capacity))
	if in.ConsumesCounters != nil {
		in, out := &in.ConsumesCounters, &out.ConsumesCounters
		*out = make([]v1.DeviceCounterConsumption, len(*in))
		for i := range *in {
			if err := Convert_api_DeviceCounterConsumption_To_v1_DeviceCounterConsumption(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.ConsumesCounters = nil
	}
	out.NodeName = (*string)(unsafe.Pointer(in.NodeName))
	out.NodeSelector = (*corev1.NodeSelector)(unsafe.Pointer(in.NodeSelector))
	out.AllNodes = (*bool)(unsafe.Pointer(in.AllNodes))
	out.Taints = *(*[]v1.DeviceTaint)(unsafe.Pointer(&in.Taints))
	if err := metav1.Convert_bool_To_Pointer_bool(&in.BindsToNode, &out.BindsToNode, s); err != nil {
		return err
	}
	out.BindingConditions = *(*[]string)(unsafe.Pointer(&in.BindingConditions))
	out.BindingFailureConditions = *(*[]string)(unsafe.Pointer(&in.BindingFailureConditions))
	out.AllowMultipleAllocations = (*bool)(unsafe.Pointer(in.AllowMultipleAllocations))
	return nil
}

// Convert_api_Device_To_v1_Device is an autogenerated conversion function.
func Convert_api_Device_To_v1_Device(in *Device, out *v1.Device, s conversion.Scope) error {
	return autoConvert_api_Device_To_v1_Device(in, out, s)
}

func autoConvert_v1_Device_To_api_Device(in *v1.Device, out *Device, s conversion.Scope) error {
	if err := Convert_string_To_api_UniqueString(&in.Name, &out.Name, s); err != nil {
		return err
	}
	out.Attributes = *(*map[v1.QualifiedName]v1.DeviceAttribute)(unsafe.Pointer(&in.Attributes))
	out.Capacity = *(*map[v1.QualifiedName]v1.DeviceCapacity)(unsafe.Pointer(&in.Capacity))
	if in.ConsumesCounters != nil {
		in, out := &in.ConsumesCounters, &out.ConsumesCounters
		*out = make([]DeviceCounterConsumption, len(*in))
		for i := range *in {
			if err := Convert_v1_DeviceCounterConsumption_To_api_DeviceCounterConsumption(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.ConsumesCounters = nil
	}
	out.NodeName = (*string)(unsafe.Pointer(in.NodeName))
	out.NodeSelector = (*corev1.NodeSelector)(unsafe.Pointer(in.NodeSelector))
	out.AllNodes = (*bool)(unsafe.Pointer(in.AllNodes))
	out.Taints = *(*[]v1.DeviceTaint)(unsafe.Pointer(&in.Taints))
	if err := metav1.Convert_Pointer_bool_To_bool(&in.BindsToNode, &out.BindsToNode, s); err != nil {
		return err
	}
	out.BindingConditions = *(*[]string)(unsafe.Pointer(&in.BindingConditions))
	out.BindingFailureConditions = *(*[]string)(unsafe.Pointer(&in.BindingFailureConditions))
	out.AllowMultipleAllocations = (*bool)(unsafe.Pointer(in.AllowMultipleAllocations))
	return nil
}

// Convert_v1_Device_To_api_Device is an autogenerated conversion function.
func Convert_v1_Device_To_api_Device(in *v1.Device, out *Device, s conversion.Scope) error {
	return autoConvert_v1_Device_To_api_Device(in, out, s)
}

func autoConvert_api_DeviceCounterConsumption_To_v1_DeviceCounterConsumption(in *DeviceCounterConsumption, out *v1.DeviceCounterConsumption, s conversion.Scope) error {
	if err := Convert_api_UniqueString_To_string(&in.CounterSet, &out.CounterSet, s); err != nil {
		return err
	}
	out.Counters = *(*map[string]v1.Counter)(unsafe.Pointer(&in.Counters))
	return nil
}

// Convert_api_DeviceCounterConsumption_To_v1_DeviceCounterConsumption is an autogenerated conversion function.
func Convert_api_DeviceCounterConsumption_To_v1_DeviceCounterConsumption(in *DeviceCounterConsumption, out *v1.DeviceCounterConsumption, s conversion.Scope) error {
	return autoConvert_api_DeviceCounterConsumption_To_v1_DeviceCounterConsumption(in, out, s)
}

func autoConvert_v1_DeviceCounterConsumption_To_api_DeviceCounterConsumption(in *v1.DeviceCounterConsumption, out *DeviceCounterConsumption, s conversion.Scope) error {
	if err := Convert_string_To_api_UniqueString(&in.CounterSet, &out.CounterSet, s); err != nil {
		return err
	}
	out.Counters = *(*map[string]v1.Counter)(unsafe.Pointer(&in.Counters))
	return nil
}

// Convert_v1_DeviceCounterConsumption_To_api_DeviceCounterConsumption is an autogenerated conversion function.
func Convert_v1_DeviceCounterConsumption_To_api_DeviceCounterConsumption(in *v1.DeviceCounterConsumption, out *DeviceCounterConsumption, s conversion.Scope) error {
	return autoConvert_v1_DeviceCounterConsumption_To_api_DeviceCounterConsumption(in, out, s)
}

func autoConvert_api_ResourcePool_To_v1_ResourcePool(in *ResourcePool, out *v1.ResourcePool, s conversion.Scope) error {
	if err := Convert_api_UniqueString_To_string(&in.Name, &out.Name, s); err != nil {
		return err
	}
	out.Generation = in.Generation
	out.ResourceSliceCount = in.ResourceSliceCount
	return nil
}

// Convert_api_ResourcePool_To_v1_ResourcePool is an autogenerated conversion function.
func Convert_api_ResourcePool_To_v1_ResourcePool(in *ResourcePool, out *v1.ResourcePool, s conversion.Scope) error {
	return autoConvert_api_ResourcePool_To_v1_ResourcePool(in, out, s)
}

func autoConvert_v1_ResourcePool_To_api_ResourcePool(in *v1.ResourcePool, out *ResourcePool, s conversion.Scope) error {
	if err := Convert_string_To_api_UniqueString(&in.Name, &out.Name, s); err != nil {
		return err
	}
	out.Generation = in.Generation
	out.ResourceSliceCount = in.ResourceSliceCount
	return nil
}

// Convert_v1_ResourcePool_To_api_ResourcePool is an autogenerated conversion function.
func Convert_v1_ResourcePool_To_api_ResourcePool(in *v1.ResourcePool, out *ResourcePool, s conversion.Scope) error {
	return autoConvert_v1_ResourcePool_To_api_ResourcePool(in, out, s)
}

func autoConvert_api_ResourceSlice_To_v1_ResourceSlice(in *ResourceSlice, out *v1.ResourceSlice, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_api_ResourceSliceSpec_To_v1_ResourceSliceSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_api_ResourceSlice_To_v1_ResourceSlice is an autogenerated conversion function.
func Convert_api_ResourceSlice_To_v1_ResourceSlice(in *ResourceSlice, out *v1.ResourceSlice, s conversion.Scope) error {
	return autoConvert_api_ResourceSlice_To_v1_ResourceSlice(in, out, s)
}

func autoConvert_v1_ResourceSlice_To_api_ResourceSlice(in *v1.ResourceSlice, out *ResourceSlice, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_ResourceSliceSpec_To_api_ResourceSliceSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_ResourceSlice_To_api_ResourceSlice is an autogenerated conversion function.
func Convert_v1_ResourceSlice_To_api_ResourceSlice(in *v1.ResourceSlice, out *ResourceSlice, s conversion.Scope) error {
	return autoConvert_v1_ResourceSlice_To_api_ResourceSlice(in, out, s)
}

func autoConvert_api_ResourceSliceSpec_To_v1_ResourceSliceSpec(in *ResourceSliceSpec, out *v1.ResourceSliceSpec, s conversion.Scope) error {
	if err := Convert_api_UniqueString_To_string(&in.Driver, &out.Driver, s); err != nil {
		return err
	}
	if err := Convert_api_ResourcePool_To_v1_ResourcePool(&in.Pool, &out.Pool, s); err != nil {
		return err
	}
	out.NodeName = (*string)(unsafe.Pointer(in.NodeName))
	out.NodeSelector = (*corev1.NodeSelector)(unsafe.Pointer(in.NodeSelector))
	if err := metav1.Convert_bool_To_Pointer_bool(&in.AllNodes, &out.AllNodes, s); err != nil {
		return err
	}
	if in.Devices != nil {
		in, out := &in.Devices, &out.Devices
		*out = make([]v1.Device, len(*in))
		for i := range *in {
			if err := Convert_api_Device_To_v1_Device(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Devices = nil
	}
	out.PerDeviceNodeSelection = (*bool)(unsafe.Pointer(in.PerDeviceNodeSelection))
	if in.SharedCounters != nil {
		in, out := &in.SharedCounters, &out.SharedCounters
		*out = make([]v1.CounterSet, len(*in))
		for i := range *in {
			if err := Convert_api_CounterSet_To_v1_CounterSet(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.SharedCounters = nil
	}
	return nil
}

// Convert_api_ResourceSliceSpec_To_v1_ResourceSliceSpec is an autogenerated conversion function.
func Convert_api_ResourceSliceSpec_To_v1_ResourceSliceSpec(in *ResourceSliceSpec, out *v1.ResourceSliceSpec, s conversion.Scope) error {
	return autoConvert_api_ResourceSliceSpec_To_v1_ResourceSliceSpec(in, out, s)
}

func autoConvert_v1_ResourceSliceSpec_To_api_ResourceSliceSpec(in *v1.ResourceSliceSpec, out *ResourceSliceSpec, s conversion.Scope) error {
	if err := Convert_string_To_api_UniqueString(&in.Driver, &out.Driver, s); err != nil {
		return err
	}
	if err := Convert_v1_ResourcePool_To_api_ResourcePool(&in.Pool, &out.Pool, s); err != nil {
		return err
	}
	out.NodeName = (*string)(unsafe.Pointer(in.NodeName))
	out.NodeSelector = (*corev1.NodeSelector)(unsafe.Pointer(in.NodeSelector))
	if err := metav1.Convert_Pointer_bool_To_bool(&in.AllNodes, &out.AllNodes, s); err != nil {
		return err
	}
	if in.Devices != nil {
		in, out := &in.Devices, &out.Devices
		*out = make([]Device, len(*in))
		for i := range *in {
			if err := Convert_v1_Device_To_api_Device(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Devices = nil
	}
	out.PerDeviceNodeSelection = (*bool)(unsafe.Pointer(in.PerDeviceNodeSelection))
	if in.SharedCounters != nil {
		in, out := &in.SharedCounters, &out.SharedCounters
		*out = make([]CounterSet, len(*in))
		for i := range *in {
			if err := Convert_v1_CounterSet_To_api_CounterSet(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.SharedCounters = nil
	}
	return nil
}

// Convert_v1_ResourceSliceSpec_To_api_ResourceSliceSpec is an autogenerated conversion function.
func Convert_v1_ResourceSliceSpec_To_api_ResourceSliceSpec(in *v1.ResourceSliceSpec, out *ResourceSliceSpec, s conversion.Scope) error {
	return autoConvert_v1_ResourceSliceSpec_To_api_ResourceSliceSpec(in, out, s)
}
