/*
 * Copyright IBM Corp. and others 2016
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution and
 * is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.trace.tests.apptrace;

import com.ibm.jvm.Trace;

public class TestGetMicros { 
    
    public static void main(String[] args) {

    	System.out.println("TestGetMicros: started");

    	long startMicroTime = Trace.getMicros();
       	long stopMicroTime = 0;
       
     	/* Wait 10 seconds. */
		try {
			Thread.sleep(10000);
		} catch (InterruptedException e ) {
			// Do nothing.
		}
   		stopMicroTime = Trace.getMicros();

     	long microDuration = stopMicroTime - startMicroTime;
        
     	// Is the duration > 0 and less than a minute?
        if( microDuration > 0 &&  microDuration < 60*(1000000) ) {
        	System.out.println("TestGetMicros: TEST PASSED");
        	System.exit(0);
        } else {
        	System.out.println("TestGetMicros: TEST FAILED");
        	System.out.printf("Start time was %d, end time was %d, duration was %d\n", startMicroTime, stopMicroTime, microDuration);
        	System.exit(1);
        }
    }
}

