/*
 * Copyright IBM Corp. and others 2017
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution and
 * is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package org.openj9.test.java.lang.management.ThreadMXBean;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;

import org.testng.annotations.Optional;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.testng.asserts.SoftAssert;
import org.openj9.test.java.lang.management.ThreadMXBean.ThreadMXBeanTestCaseCommon.TimeoutNotifier;

public class NoBlock extends ThreadMXBeanTestCase implements TimeoutNotifier {
	private SoftAssert softAssert = new SoftAssert();

	@Parameters( {"timeoutPara"} )
	@Test(groups = { "level.extended" })
	public void testNoBlock(@Optional("10") String timeoutPara) {
		int timeout = Integer.parseInt(timeoutPara);

		if (timeout < 0) {
			timeout = 0;
		}

		NeverBlocks th = new NeverBlocks(this);
		th.start();

		VerboseTimeoutThread timer = new VerboseTimeoutThread(timeout, this);
		timer.start();
		
		ThreadMXBean mxb = ManagementFactory.getThreadMXBean();
		boolean done = false;
		while (!done) {
			ThreadInfo ti = mxb.getThreadInfo(th.getId());
			if ((ti == null) ||
				(ti.getThreadId() != th.getId()) ||
				(ti.getBlockedCount() > 0) ||
				(ti.getWaitedCount() > 0) ||
				(ti.getThreadState() != Thread.State.RUNNABLE) ||
				(ti.getLockName() != null) ||
				(ti.getLockOwnerId() != -1)) {
				softAssert.fail();
				done = true;
			}
			synchronized (this) {
				if (this.done) {
					done = true;
				}
			}
		}
		softAssert.assertAll();
	}

	volatile boolean done = false;
	public void timeout() {
		synchronized (this) {
			done = true;
		}
	}

	class NeverBlocks extends Thread {
		Object critsec;
		NeverBlocks(Object sync) {
			critsec = new Object();
		}
		
		public void run() {
			while (true) {
				synchronized (critsec) {
					Thread.yield();
				}
			}
		}
	}
}
