/*
 * Copyright IBM Corp. and others 2017
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution and
 * is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package jit.test.tr.decomposition;

import org.testng.annotations.Test;
import org.testng.AssertJUnit;

@Test(groups = { "level.sanity","component.jit" })
public class IntegerMultiplyDecomposer {

	// The following have been generated by the C program attached at the bottom.  These are motivated by 
	// the codegen/x86/IntegerMultiplyDecomposition file.
	
	
	// it is critical that x is a volatile. Else the JIT will constant fold away the multiply.
	// it is also critical the RHS of the multiply is a constant in the bytecode and the LHS is not.  That's
	// the scenario where the decomposition will kick in.
	volatile long x = 0;
@Test
public void test00001() { x = 0x000000007fffffffl; long result = x * 0x1l; AssertJUnit.assertEquals("multiply", result, 0x000000007fffffffl); }
@Test
public void test00002() { x = 0x0000000080000000l; long result = x * 0x1l; AssertJUnit.assertEquals("multiply", result, 0x0000000080000000l); }
@Test
public void test00003() { x = 0x00000000ffffffffl; long result = x * 0x1l; AssertJUnit.assertEquals("multiply", result, 0x00000000ffffffffl); }
@Test
public void test00004() { x = 0x000000017fffffffl; long result = x * 0x1l; AssertJUnit.assertEquals("multiply", result, 0x000000017fffffffl); }
@Test
public void test00005() { x = 0x0000000180000000l; long result = x * 0x1l; AssertJUnit.assertEquals("multiply", result, 0x0000000180000000l); }
@Test
public void test00006() { x = 0x00000001ffffffffl; long result = x * 0x1l; AssertJUnit.assertEquals("multiply", result, 0x00000001ffffffffl); }
@Test
public void test00007() { x = 0xffffffff7fffffffl; long result = x * 0x1l; AssertJUnit.assertEquals("multiply", result, 0xffffffff7fffffffl); }
@Test
public void test00008() { x = 0xffffffff80000000l; long result = x * 0x1l; AssertJUnit.assertEquals("multiply", result, 0xffffffff80000000l); }
@Test
public void test00009() { x = 0x00000001deadf00dl; long result = x * 0x1l; AssertJUnit.assertEquals("multiply", result, 0x00000001deadf00dl); }
@Test
public void test00010() { x = 0xffffffffdeadf00dl; long result = x * 0x1l; AssertJUnit.assertEquals("multiply", result, 0xffffffffdeadf00dl); }
@Test
public void test00011() { x = 0x7fffffffffffffffl; long result = x * 0x1l; AssertJUnit.assertEquals("multiply", result, 0x7fffffffffffffffl); }
@Test
public void test00012() { x = 0x7fffffff7fffffffl; long result = x * 0x1l; AssertJUnit.assertEquals("multiply", result, 0x7fffffff7fffffffl); }
@Test
public void test00013() { x = 0x7fffffff80000000l; long result = x * 0x1l; AssertJUnit.assertEquals("multiply", result, 0x7fffffff80000000l); }
@Test
public void test00014() { x = 0x7fffffffdeadf00dl; long result = x * 0x1l; AssertJUnit.assertEquals("multiply", result, 0x7fffffffdeadf00dl); }
@Test
public void test00015() { x = 0x8000000000000000l; long result = x * 0x1l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00016() { x = 0xffffffffffffffffl; long result = x * 0x1l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffffl); }
@Test
public void test00017() { x = 0xfffffffffffffffel; long result = x * 0x1l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffffel); }
@Test
public void test00018() { x = 0xefffffffffffffffl; long result = x * 0x1l; AssertJUnit.assertEquals("multiply", result, 0xefffffffffffffffl); }
@Test
public void test00019() { x = 0xdeadf00ddeadf00dl; long result = x * 0x1l; AssertJUnit.assertEquals("multiply", result, 0xdeadf00ddeadf00dl); }
@Test
public void test00020() { x = 0x000000007fffffffl; long result = x * 0x8l; AssertJUnit.assertEquals("multiply", result, 0x00000003fffffff8l); }
@Test
public void test00021() { x = 0x0000000080000000l; long result = x * 0x8l; AssertJUnit.assertEquals("multiply", result, 0x0000000400000000l); }
@Test
public void test00022() { x = 0x00000000ffffffffl; long result = x * 0x8l; AssertJUnit.assertEquals("multiply", result, 0x00000007fffffff8l); }
@Test
public void test00023() { x = 0x000000017fffffffl; long result = x * 0x8l; AssertJUnit.assertEquals("multiply", result, 0x0000000bfffffff8l); }
@Test
public void test00024() { x = 0x0000000180000000l; long result = x * 0x8l; AssertJUnit.assertEquals("multiply", result, 0x0000000c00000000l); }
@Test
public void test00025() { x = 0x00000001ffffffffl; long result = x * 0x8l; AssertJUnit.assertEquals("multiply", result, 0x0000000ffffffff8l); }
@Test
public void test00026() { x = 0xffffffff7fffffffl; long result = x * 0x8l; AssertJUnit.assertEquals("multiply", result, 0xfffffffbfffffff8l); }
@Test
public void test00027() { x = 0xffffffff80000000l; long result = x * 0x8l; AssertJUnit.assertEquals("multiply", result, 0xfffffffc00000000l); }
@Test
public void test00028() { x = 0x00000001deadf00dl; long result = x * 0x8l; AssertJUnit.assertEquals("multiply", result, 0x0000000ef56f8068l); }
@Test
public void test00029() { x = 0xffffffffdeadf00dl; long result = x * 0x8l; AssertJUnit.assertEquals("multiply", result, 0xfffffffef56f8068l); }
@Test
public void test00030() { x = 0x7fffffffffffffffl; long result = x * 0x8l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffff8l); }
@Test
public void test00031() { x = 0x7fffffff7fffffffl; long result = x * 0x8l; AssertJUnit.assertEquals("multiply", result, 0xfffffffbfffffff8l); }
@Test
public void test00032() { x = 0x7fffffff80000000l; long result = x * 0x8l; AssertJUnit.assertEquals("multiply", result, 0xfffffffc00000000l); }
@Test
public void test00033() { x = 0x7fffffffdeadf00dl; long result = x * 0x8l; AssertJUnit.assertEquals("multiply", result, 0xfffffffef56f8068l); }
@Test
public void test00034() { x = 0x8000000000000000l; long result = x * 0x8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00035() { x = 0xffffffffffffffffl; long result = x * 0x8l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffff8l); }
@Test
public void test00036() { x = 0xfffffffffffffffel; long result = x * 0x8l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffff0l); }
@Test
public void test00037() { x = 0xefffffffffffffffl; long result = x * 0x8l; AssertJUnit.assertEquals("multiply", result, 0x7ffffffffffffff8l); }
@Test
public void test00038() { x = 0xdeadf00ddeadf00dl; long result = x * 0x8l; AssertJUnit.assertEquals("multiply", result, 0xf56f806ef56f8068l); }
@Test
public void test00039() { x = 0x000000007fffffffl; long result = x * 0x100l; AssertJUnit.assertEquals("multiply", result, 0x0000007fffffff00l); }
@Test
public void test00040() { x = 0x0000000080000000l; long result = x * 0x100l; AssertJUnit.assertEquals("multiply", result, 0x0000008000000000l); }
@Test
public void test00041() { x = 0x00000000ffffffffl; long result = x * 0x100l; AssertJUnit.assertEquals("multiply", result, 0x000000ffffffff00l); }
@Test
public void test00042() { x = 0x000000017fffffffl; long result = x * 0x100l; AssertJUnit.assertEquals("multiply", result, 0x0000017fffffff00l); }
@Test
public void test00043() { x = 0x0000000180000000l; long result = x * 0x100l; AssertJUnit.assertEquals("multiply", result, 0x0000018000000000l); }
@Test
public void test00044() { x = 0x00000001ffffffffl; long result = x * 0x100l; AssertJUnit.assertEquals("multiply", result, 0x000001ffffffff00l); }
@Test
public void test00045() { x = 0xffffffff7fffffffl; long result = x * 0x100l; AssertJUnit.assertEquals("multiply", result, 0xffffff7fffffff00l); }
@Test
public void test00046() { x = 0xffffffff80000000l; long result = x * 0x100l; AssertJUnit.assertEquals("multiply", result, 0xffffff8000000000l); }
@Test
public void test00047() { x = 0x00000001deadf00dl; long result = x * 0x100l; AssertJUnit.assertEquals("multiply", result, 0x000001deadf00d00l); }
@Test
public void test00048() { x = 0xffffffffdeadf00dl; long result = x * 0x100l; AssertJUnit.assertEquals("multiply", result, 0xffffffdeadf00d00l); }
@Test
public void test00049() { x = 0x7fffffffffffffffl; long result = x * 0x100l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff00l); }
@Test
public void test00050() { x = 0x7fffffff7fffffffl; long result = x * 0x100l; AssertJUnit.assertEquals("multiply", result, 0xffffff7fffffff00l); }
@Test
public void test00051() { x = 0x7fffffff80000000l; long result = x * 0x100l; AssertJUnit.assertEquals("multiply", result, 0xffffff8000000000l); }
@Test
public void test00052() { x = 0x7fffffffdeadf00dl; long result = x * 0x100l; AssertJUnit.assertEquals("multiply", result, 0xffffffdeadf00d00l); }
@Test
public void test00053() { x = 0x8000000000000000l; long result = x * 0x100l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00054() { x = 0xffffffffffffffffl; long result = x * 0x100l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff00l); }
@Test
public void test00055() { x = 0xfffffffffffffffel; long result = x * 0x100l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffe00l); }
@Test
public void test00056() { x = 0xefffffffffffffffl; long result = x * 0x100l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff00l); }
@Test
public void test00057() { x = 0xdeadf00ddeadf00dl; long result = x * 0x100l; AssertJUnit.assertEquals("multiply", result, 0xadf00ddeadf00d00l); }
@Test
public void test00058() { x = 0x000000007fffffffl; long result = x * 0x100000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffff00000000l); }
@Test
public void test00059() { x = 0x0000000080000000l; long result = x * 0x100000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00060() { x = 0x00000000ffffffffl; long result = x * 0x100000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffff00000000l); }
@Test
public void test00061() { x = 0x000000017fffffffl; long result = x * 0x100000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffff00000000l); }
@Test
public void test00062() { x = 0x0000000180000000l; long result = x * 0x100000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00063() { x = 0x00000001ffffffffl; long result = x * 0x100000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffff00000000l); }
@Test
public void test00064() { x = 0xffffffff7fffffffl; long result = x * 0x100000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffff00000000l); }
@Test
public void test00065() { x = 0xffffffff80000000l; long result = x * 0x100000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00066() { x = 0x00000001deadf00dl; long result = x * 0x100000000l; AssertJUnit.assertEquals("multiply", result, 0xdeadf00d00000000l); }
@Test
public void test00067() { x = 0xffffffffdeadf00dl; long result = x * 0x100000000l; AssertJUnit.assertEquals("multiply", result, 0xdeadf00d00000000l); }
@Test
public void test00068() { x = 0x7fffffffffffffffl; long result = x * 0x100000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffff00000000l); }
@Test
public void test00069() { x = 0x7fffffff7fffffffl; long result = x * 0x100000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffff00000000l); }
@Test
public void test00070() { x = 0x7fffffff80000000l; long result = x * 0x100000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00071() { x = 0x7fffffffdeadf00dl; long result = x * 0x100000000l; AssertJUnit.assertEquals("multiply", result, 0xdeadf00d00000000l); }
@Test
public void test00072() { x = 0x8000000000000000l; long result = x * 0x100000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00073() { x = 0xffffffffffffffffl; long result = x * 0x100000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffff00000000l); }
@Test
public void test00074() { x = 0xfffffffffffffffel; long result = x * 0x100000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffffe00000000l); }
@Test
public void test00075() { x = 0xefffffffffffffffl; long result = x * 0x100000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffff00000000l); }
@Test
public void test00076() { x = 0xdeadf00ddeadf00dl; long result = x * 0x100000000l; AssertJUnit.assertEquals("multiply", result, 0xdeadf00d00000000l); }
@Test
public void test00077() { x = 0x000000007fffffffl; long result = x * 0x800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff800000000l); }
@Test
public void test00078() { x = 0x0000000080000000l; long result = x * 0x800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00079() { x = 0x00000000ffffffffl; long result = x * 0x800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff800000000l); }
@Test
public void test00080() { x = 0x000000017fffffffl; long result = x * 0x800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff800000000l); }
@Test
public void test00081() { x = 0x0000000180000000l; long result = x * 0x800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00082() { x = 0x00000001ffffffffl; long result = x * 0x800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff800000000l); }
@Test
public void test00083() { x = 0xffffffff7fffffffl; long result = x * 0x800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff800000000l); }
@Test
public void test00084() { x = 0xffffffff80000000l; long result = x * 0x800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00085() { x = 0x00000001deadf00dl; long result = x * 0x800000000l; AssertJUnit.assertEquals("multiply", result, 0xf56f806800000000l); }
@Test
public void test00086() { x = 0xffffffffdeadf00dl; long result = x * 0x800000000l; AssertJUnit.assertEquals("multiply", result, 0xf56f806800000000l); }
@Test
public void test00087() { x = 0x7fffffffffffffffl; long result = x * 0x800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff800000000l); }
@Test
public void test00088() { x = 0x7fffffff7fffffffl; long result = x * 0x800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff800000000l); }
@Test
public void test00089() { x = 0x7fffffff80000000l; long result = x * 0x800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00090() { x = 0x7fffffffdeadf00dl; long result = x * 0x800000000l; AssertJUnit.assertEquals("multiply", result, 0xf56f806800000000l); }
@Test
public void test00091() { x = 0x8000000000000000l; long result = x * 0x800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00092() { x = 0xffffffffffffffffl; long result = x * 0x800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff800000000l); }
@Test
public void test00093() { x = 0xfffffffffffffffel; long result = x * 0x800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff000000000l); }
@Test
public void test00094() { x = 0xefffffffffffffffl; long result = x * 0x800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff800000000l); }
@Test
public void test00095() { x = 0xdeadf00ddeadf00dl; long result = x * 0x800000000l; AssertJUnit.assertEquals("multiply", result, 0xf56f806800000000l); }
@Test
public void test00096() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffffffl; AssertJUnit.assertEquals("multiply", result, 0xffffffff80000001l); }
@Test
public void test00097() { x = 0x0000000080000000l; long result = x * 0xffffffffffffffffl; AssertJUnit.assertEquals("multiply", result, 0xffffffff80000000l); }
@Test
public void test00098() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffffffl; AssertJUnit.assertEquals("multiply", result, 0xffffffff00000001l); }
@Test
public void test00099() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffffffl; AssertJUnit.assertEquals("multiply", result, 0xfffffffe80000001l); }
@Test
public void test00100() { x = 0x0000000180000000l; long result = x * 0xffffffffffffffffl; AssertJUnit.assertEquals("multiply", result, 0xfffffffe80000000l); }
@Test
public void test00101() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffffffl; AssertJUnit.assertEquals("multiply", result, 0xfffffffe00000001l); }
@Test
public void test00102() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffffffl; AssertJUnit.assertEquals("multiply", result, 0x0000000080000001l); }
@Test
public void test00103() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffffffl; AssertJUnit.assertEquals("multiply", result, 0x0000000080000000l); }
@Test
public void test00104() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffffffl; AssertJUnit.assertEquals("multiply", result, 0xfffffffe21520ff3l); }
@Test
public void test00105() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffffffl; AssertJUnit.assertEquals("multiply", result, 0x0000000021520ff3l); }
@Test
public void test00106() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffffffl; AssertJUnit.assertEquals("multiply", result, 0x8000000000000001l); }
@Test
public void test00107() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffffffl; AssertJUnit.assertEquals("multiply", result, 0x8000000080000001l); }
@Test
public void test00108() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffffffl; AssertJUnit.assertEquals("multiply", result, 0x8000000080000000l); }
@Test
public void test00109() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffffffl; AssertJUnit.assertEquals("multiply", result, 0x8000000021520ff3l); }
@Test
public void test00110() { x = 0x8000000000000000l; long result = x * 0xffffffffffffffffl; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00111() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffffffl; AssertJUnit.assertEquals("multiply", result, 0x0000000000000001l); }
@Test
public void test00112() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffffffl; AssertJUnit.assertEquals("multiply", result, 0x0000000000000002l); }
@Test
public void test00113() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffffffl; AssertJUnit.assertEquals("multiply", result, 0x1000000000000001l); }
@Test
public void test00114() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffffffl; AssertJUnit.assertEquals("multiply", result, 0x21520ff221520ff3l); }
@Test
public void test00115() { x = 0x000000007fffffffl; long result = x * 0xfffffffffffffff8l; AssertJUnit.assertEquals("multiply", result, 0xfffffffc00000008l); }
@Test
public void test00116() { x = 0x0000000080000000l; long result = x * 0xfffffffffffffff8l; AssertJUnit.assertEquals("multiply", result, 0xfffffffc00000000l); }
@Test
public void test00117() { x = 0x00000000ffffffffl; long result = x * 0xfffffffffffffff8l; AssertJUnit.assertEquals("multiply", result, 0xfffffff800000008l); }
@Test
public void test00118() { x = 0x000000017fffffffl; long result = x * 0xfffffffffffffff8l; AssertJUnit.assertEquals("multiply", result, 0xfffffff400000008l); }
@Test
public void test00119() { x = 0x0000000180000000l; long result = x * 0xfffffffffffffff8l; AssertJUnit.assertEquals("multiply", result, 0xfffffff400000000l); }
@Test
public void test00120() { x = 0x00000001ffffffffl; long result = x * 0xfffffffffffffff8l; AssertJUnit.assertEquals("multiply", result, 0xfffffff000000008l); }
@Test
public void test00121() { x = 0xffffffff7fffffffl; long result = x * 0xfffffffffffffff8l; AssertJUnit.assertEquals("multiply", result, 0x0000000400000008l); }
@Test
public void test00122() { x = 0xffffffff80000000l; long result = x * 0xfffffffffffffff8l; AssertJUnit.assertEquals("multiply", result, 0x0000000400000000l); }
@Test
public void test00123() { x = 0x00000001deadf00dl; long result = x * 0xfffffffffffffff8l; AssertJUnit.assertEquals("multiply", result, 0xfffffff10a907f98l); }
@Test
public void test00124() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffffffffffff8l; AssertJUnit.assertEquals("multiply", result, 0x000000010a907f98l); }
@Test
public void test00125() { x = 0x7fffffffffffffffl; long result = x * 0xfffffffffffffff8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000008l); }
@Test
public void test00126() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffffffffffff8l; AssertJUnit.assertEquals("multiply", result, 0x0000000400000008l); }
@Test
public void test00127() { x = 0x7fffffff80000000l; long result = x * 0xfffffffffffffff8l; AssertJUnit.assertEquals("multiply", result, 0x0000000400000000l); }
@Test
public void test00128() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffffffffffff8l; AssertJUnit.assertEquals("multiply", result, 0x000000010a907f98l); }
@Test
public void test00129() { x = 0x8000000000000000l; long result = x * 0xfffffffffffffff8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00130() { x = 0xffffffffffffffffl; long result = x * 0xfffffffffffffff8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000008l); }
@Test
public void test00131() { x = 0xfffffffffffffffel; long result = x * 0xfffffffffffffff8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000010l); }
@Test
public void test00132() { x = 0xefffffffffffffffl; long result = x * 0xfffffffffffffff8l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000008l); }
@Test
public void test00133() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffffffffffff8l; AssertJUnit.assertEquals("multiply", result, 0x0a907f910a907f98l); }
@Test
public void test00134() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffff00l; AssertJUnit.assertEquals("multiply", result, 0xffffff8000000100l); }
@Test
public void test00135() { x = 0x0000000080000000l; long result = x * 0xffffffffffffff00l; AssertJUnit.assertEquals("multiply", result, 0xffffff8000000000l); }
@Test
public void test00136() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffff00l; AssertJUnit.assertEquals("multiply", result, 0xffffff0000000100l); }
@Test
public void test00137() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffff00l; AssertJUnit.assertEquals("multiply", result, 0xfffffe8000000100l); }
@Test
public void test00138() { x = 0x0000000180000000l; long result = x * 0xffffffffffffff00l; AssertJUnit.assertEquals("multiply", result, 0xfffffe8000000000l); }
@Test
public void test00139() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffff00l; AssertJUnit.assertEquals("multiply", result, 0xfffffe0000000100l); }
@Test
public void test00140() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffff00l; AssertJUnit.assertEquals("multiply", result, 0x0000008000000100l); }
@Test
public void test00141() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffff00l; AssertJUnit.assertEquals("multiply", result, 0x0000008000000000l); }
@Test
public void test00142() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffff00l; AssertJUnit.assertEquals("multiply", result, 0xfffffe21520ff300l); }
@Test
public void test00143() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffff00l; AssertJUnit.assertEquals("multiply", result, 0x00000021520ff300l); }
@Test
public void test00144() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffff00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000100l); }
@Test
public void test00145() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffff00l; AssertJUnit.assertEquals("multiply", result, 0x0000008000000100l); }
@Test
public void test00146() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffff00l; AssertJUnit.assertEquals("multiply", result, 0x0000008000000000l); }
@Test
public void test00147() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffff00l; AssertJUnit.assertEquals("multiply", result, 0x00000021520ff300l); }
@Test
public void test00148() { x = 0x8000000000000000l; long result = x * 0xffffffffffffff00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00149() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffff00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000100l); }
@Test
public void test00150() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffff00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000200l); }
@Test
public void test00151() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffff00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000100l); }
@Test
public void test00152() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffff00l; AssertJUnit.assertEquals("multiply", result, 0x520ff221520ff300l); }
@Test
public void test00153() { x = 0x000000007fffffffl; long result = x * 0xffffffff00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000100000000l); }
@Test
public void test00154() { x = 0x0000000080000000l; long result = x * 0xffffffff00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00155() { x = 0x00000000ffffffffl; long result = x * 0xffffffff00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000100000000l); }
@Test
public void test00156() { x = 0x000000017fffffffl; long result = x * 0xffffffff00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000100000000l); }
@Test
public void test00157() { x = 0x0000000180000000l; long result = x * 0xffffffff00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00158() { x = 0x00000001ffffffffl; long result = x * 0xffffffff00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000100000000l); }
@Test
public void test00159() { x = 0xffffffff7fffffffl; long result = x * 0xffffffff00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000100000000l); }
@Test
public void test00160() { x = 0xffffffff80000000l; long result = x * 0xffffffff00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00161() { x = 0x00000001deadf00dl; long result = x * 0xffffffff00000000l; AssertJUnit.assertEquals("multiply", result, 0x21520ff300000000l); }
@Test
public void test00162() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffff00000000l; AssertJUnit.assertEquals("multiply", result, 0x21520ff300000000l); }
@Test
public void test00163() { x = 0x7fffffffffffffffl; long result = x * 0xffffffff00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000100000000l); }
@Test
public void test00164() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffff00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000100000000l); }
@Test
public void test00165() { x = 0x7fffffff80000000l; long result = x * 0xffffffff00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00166() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffff00000000l; AssertJUnit.assertEquals("multiply", result, 0x21520ff300000000l); }
@Test
public void test00167() { x = 0x8000000000000000l; long result = x * 0xffffffff00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00168() { x = 0xffffffffffffffffl; long result = x * 0xffffffff00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000100000000l); }
@Test
public void test00169() { x = 0xfffffffffffffffel; long result = x * 0xffffffff00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000200000000l); }
@Test
public void test00170() { x = 0xefffffffffffffffl; long result = x * 0xffffffff00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000100000000l); }
@Test
public void test00171() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffff00000000l; AssertJUnit.assertEquals("multiply", result, 0x21520ff300000000l); }
@Test
public void test00172() { x = 0x000000007fffffffl; long result = x * 0xfffffff800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000800000000l); }
@Test
public void test00173() { x = 0x0000000080000000l; long result = x * 0xfffffff800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00174() { x = 0x00000000ffffffffl; long result = x * 0xfffffff800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000800000000l); }
@Test
public void test00175() { x = 0x000000017fffffffl; long result = x * 0xfffffff800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000800000000l); }
@Test
public void test00176() { x = 0x0000000180000000l; long result = x * 0xfffffff800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00177() { x = 0x00000001ffffffffl; long result = x * 0xfffffff800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000800000000l); }
@Test
public void test00178() { x = 0xffffffff7fffffffl; long result = x * 0xfffffff800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000800000000l); }
@Test
public void test00179() { x = 0xffffffff80000000l; long result = x * 0xfffffff800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00180() { x = 0x00000001deadf00dl; long result = x * 0xfffffff800000000l; AssertJUnit.assertEquals("multiply", result, 0x0a907f9800000000l); }
@Test
public void test00181() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffff800000000l; AssertJUnit.assertEquals("multiply", result, 0x0a907f9800000000l); }
@Test
public void test00182() { x = 0x7fffffffffffffffl; long result = x * 0xfffffff800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000800000000l); }
@Test
public void test00183() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffff800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000800000000l); }
@Test
public void test00184() { x = 0x7fffffff80000000l; long result = x * 0xfffffff800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00185() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffff800000000l; AssertJUnit.assertEquals("multiply", result, 0x0a907f9800000000l); }
@Test
public void test00186() { x = 0x8000000000000000l; long result = x * 0xfffffff800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00187() { x = 0xffffffffffffffffl; long result = x * 0xfffffff800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000800000000l); }
@Test
public void test00188() { x = 0xfffffffffffffffel; long result = x * 0xfffffff800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001000000000l); }
@Test
public void test00189() { x = 0xefffffffffffffffl; long result = x * 0xfffffff800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000800000000l); }
@Test
public void test00190() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffff800000000l; AssertJUnit.assertEquals("multiply", result, 0x0a907f9800000000l); }
@Test
public void test00191() { x = 0x000000007fffffffl; long result = x * 0x3l; AssertJUnit.assertEquals("multiply", result, 0x000000017ffffffdl); }
@Test
public void test00192() { x = 0x0000000080000000l; long result = x * 0x3l; AssertJUnit.assertEquals("multiply", result, 0x0000000180000000l); }
@Test
public void test00193() { x = 0x00000000ffffffffl; long result = x * 0x3l; AssertJUnit.assertEquals("multiply", result, 0x00000002fffffffdl); }
@Test
public void test00194() { x = 0x000000017fffffffl; long result = x * 0x3l; AssertJUnit.assertEquals("multiply", result, 0x000000047ffffffdl); }
@Test
public void test00195() { x = 0x0000000180000000l; long result = x * 0x3l; AssertJUnit.assertEquals("multiply", result, 0x0000000480000000l); }
@Test
public void test00196() { x = 0x00000001ffffffffl; long result = x * 0x3l; AssertJUnit.assertEquals("multiply", result, 0x00000005fffffffdl); }
@Test
public void test00197() { x = 0xffffffff7fffffffl; long result = x * 0x3l; AssertJUnit.assertEquals("multiply", result, 0xfffffffe7ffffffdl); }
@Test
public void test00198() { x = 0xffffffff80000000l; long result = x * 0x3l; AssertJUnit.assertEquals("multiply", result, 0xfffffffe80000000l); }
@Test
public void test00199() { x = 0x00000001deadf00dl; long result = x * 0x3l; AssertJUnit.assertEquals("multiply", result, 0x000000059c09d027l); }
@Test
public void test00200() { x = 0xffffffffdeadf00dl; long result = x * 0x3l; AssertJUnit.assertEquals("multiply", result, 0xffffffff9c09d027l); }
@Test
public void test00201() { x = 0x7fffffffffffffffl; long result = x * 0x3l; AssertJUnit.assertEquals("multiply", result, 0x7ffffffffffffffdl); }
@Test
public void test00202() { x = 0x7fffffff7fffffffl; long result = x * 0x3l; AssertJUnit.assertEquals("multiply", result, 0x7ffffffe7ffffffdl); }
@Test
public void test00203() { x = 0x7fffffff80000000l; long result = x * 0x3l; AssertJUnit.assertEquals("multiply", result, 0x7ffffffe80000000l); }
@Test
public void test00204() { x = 0x7fffffffdeadf00dl; long result = x * 0x3l; AssertJUnit.assertEquals("multiply", result, 0x7fffffff9c09d027l); }
@Test
public void test00205() { x = 0x8000000000000000l; long result = x * 0x3l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00206() { x = 0xffffffffffffffffl; long result = x * 0x3l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffffdl); }
@Test
public void test00207() { x = 0xfffffffffffffffel; long result = x * 0x3l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffffal); }
@Test
public void test00208() { x = 0xefffffffffffffffl; long result = x * 0x3l; AssertJUnit.assertEquals("multiply", result, 0xcffffffffffffffdl); }
@Test
public void test00209() { x = 0xdeadf00ddeadf00dl; long result = x * 0x3l; AssertJUnit.assertEquals("multiply", result, 0x9c09d0299c09d027l); }
@Test
public void test00210() { x = 0x000000007fffffffl; long result = x * 0x18l; AssertJUnit.assertEquals("multiply", result, 0x0000000bffffffe8l); }
@Test
public void test00211() { x = 0x0000000080000000l; long result = x * 0x18l; AssertJUnit.assertEquals("multiply", result, 0x0000000c00000000l); }
@Test
public void test00212() { x = 0x00000000ffffffffl; long result = x * 0x18l; AssertJUnit.assertEquals("multiply", result, 0x00000017ffffffe8l); }
@Test
public void test00213() { x = 0x000000017fffffffl; long result = x * 0x18l; AssertJUnit.assertEquals("multiply", result, 0x00000023ffffffe8l); }
@Test
public void test00214() { x = 0x0000000180000000l; long result = x * 0x18l; AssertJUnit.assertEquals("multiply", result, 0x0000002400000000l); }
@Test
public void test00215() { x = 0x00000001ffffffffl; long result = x * 0x18l; AssertJUnit.assertEquals("multiply", result, 0x0000002fffffffe8l); }
@Test
public void test00216() { x = 0xffffffff7fffffffl; long result = x * 0x18l; AssertJUnit.assertEquals("multiply", result, 0xfffffff3ffffffe8l); }
@Test
public void test00217() { x = 0xffffffff80000000l; long result = x * 0x18l; AssertJUnit.assertEquals("multiply", result, 0xfffffff400000000l); }
@Test
public void test00218() { x = 0x00000001deadf00dl; long result = x * 0x18l; AssertJUnit.assertEquals("multiply", result, 0x0000002ce04e8138l); }
@Test
public void test00219() { x = 0xffffffffdeadf00dl; long result = x * 0x18l; AssertJUnit.assertEquals("multiply", result, 0xfffffffce04e8138l); }
@Test
public void test00220() { x = 0x7fffffffffffffffl; long result = x * 0x18l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffe8l); }
@Test
public void test00221() { x = 0x7fffffff7fffffffl; long result = x * 0x18l; AssertJUnit.assertEquals("multiply", result, 0xfffffff3ffffffe8l); }
@Test
public void test00222() { x = 0x7fffffff80000000l; long result = x * 0x18l; AssertJUnit.assertEquals("multiply", result, 0xfffffff400000000l); }
@Test
public void test00223() { x = 0x7fffffffdeadf00dl; long result = x * 0x18l; AssertJUnit.assertEquals("multiply", result, 0xfffffffce04e8138l); }
@Test
public void test00224() { x = 0x8000000000000000l; long result = x * 0x18l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00225() { x = 0xffffffffffffffffl; long result = x * 0x18l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffe8l); }
@Test
public void test00226() { x = 0xfffffffffffffffel; long result = x * 0x18l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffd0l); }
@Test
public void test00227() { x = 0xefffffffffffffffl; long result = x * 0x18l; AssertJUnit.assertEquals("multiply", result, 0x7fffffffffffffe8l); }
@Test
public void test00228() { x = 0xdeadf00ddeadf00dl; long result = x * 0x18l; AssertJUnit.assertEquals("multiply", result, 0xe04e814ce04e8138l); }
@Test
public void test00229() { x = 0x000000007fffffffl; long result = x * 0x300l; AssertJUnit.assertEquals("multiply", result, 0x0000017ffffffd00l); }
@Test
public void test00230() { x = 0x0000000080000000l; long result = x * 0x300l; AssertJUnit.assertEquals("multiply", result, 0x0000018000000000l); }
@Test
public void test00231() { x = 0x00000000ffffffffl; long result = x * 0x300l; AssertJUnit.assertEquals("multiply", result, 0x000002fffffffd00l); }
@Test
public void test00232() { x = 0x000000017fffffffl; long result = x * 0x300l; AssertJUnit.assertEquals("multiply", result, 0x0000047ffffffd00l); }
@Test
public void test00233() { x = 0x0000000180000000l; long result = x * 0x300l; AssertJUnit.assertEquals("multiply", result, 0x0000048000000000l); }
@Test
public void test00234() { x = 0x00000001ffffffffl; long result = x * 0x300l; AssertJUnit.assertEquals("multiply", result, 0x000005fffffffd00l); }
@Test
public void test00235() { x = 0xffffffff7fffffffl; long result = x * 0x300l; AssertJUnit.assertEquals("multiply", result, 0xfffffe7ffffffd00l); }
@Test
public void test00236() { x = 0xffffffff80000000l; long result = x * 0x300l; AssertJUnit.assertEquals("multiply", result, 0xfffffe8000000000l); }
@Test
public void test00237() { x = 0x00000001deadf00dl; long result = x * 0x300l; AssertJUnit.assertEquals("multiply", result, 0x0000059c09d02700l); }
@Test
public void test00238() { x = 0xffffffffdeadf00dl; long result = x * 0x300l; AssertJUnit.assertEquals("multiply", result, 0xffffff9c09d02700l); }
@Test
public void test00239() { x = 0x7fffffffffffffffl; long result = x * 0x300l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffd00l); }
@Test
public void test00240() { x = 0x7fffffff7fffffffl; long result = x * 0x300l; AssertJUnit.assertEquals("multiply", result, 0xfffffe7ffffffd00l); }
@Test
public void test00241() { x = 0x7fffffff80000000l; long result = x * 0x300l; AssertJUnit.assertEquals("multiply", result, 0xfffffe8000000000l); }
@Test
public void test00242() { x = 0x7fffffffdeadf00dl; long result = x * 0x300l; AssertJUnit.assertEquals("multiply", result, 0xffffff9c09d02700l); }
@Test
public void test00243() { x = 0x8000000000000000l; long result = x * 0x300l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00244() { x = 0xffffffffffffffffl; long result = x * 0x300l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffd00l); }
@Test
public void test00245() { x = 0xfffffffffffffffel; long result = x * 0x300l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffa00l); }
@Test
public void test00246() { x = 0xefffffffffffffffl; long result = x * 0x300l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffd00l); }
@Test
public void test00247() { x = 0xdeadf00ddeadf00dl; long result = x * 0x300l; AssertJUnit.assertEquals("multiply", result, 0x09d0299c09d02700l); }
@Test
public void test00248() { x = 0x000000007fffffffl; long result = x * 0x300000000l; AssertJUnit.assertEquals("multiply", result, 0x7ffffffd00000000l); }
@Test
public void test00249() { x = 0x0000000080000000l; long result = x * 0x300000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00250() { x = 0x00000000ffffffffl; long result = x * 0x300000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffffd00000000l); }
@Test
public void test00251() { x = 0x000000017fffffffl; long result = x * 0x300000000l; AssertJUnit.assertEquals("multiply", result, 0x7ffffffd00000000l); }
@Test
public void test00252() { x = 0x0000000180000000l; long result = x * 0x300000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00253() { x = 0x00000001ffffffffl; long result = x * 0x300000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffffd00000000l); }
@Test
public void test00254() { x = 0xffffffff7fffffffl; long result = x * 0x300000000l; AssertJUnit.assertEquals("multiply", result, 0x7ffffffd00000000l); }
@Test
public void test00255() { x = 0xffffffff80000000l; long result = x * 0x300000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00256() { x = 0x00000001deadf00dl; long result = x * 0x300000000l; AssertJUnit.assertEquals("multiply", result, 0x9c09d02700000000l); }
@Test
public void test00257() { x = 0xffffffffdeadf00dl; long result = x * 0x300000000l; AssertJUnit.assertEquals("multiply", result, 0x9c09d02700000000l); }
@Test
public void test00258() { x = 0x7fffffffffffffffl; long result = x * 0x300000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffffd00000000l); }
@Test
public void test00259() { x = 0x7fffffff7fffffffl; long result = x * 0x300000000l; AssertJUnit.assertEquals("multiply", result, 0x7ffffffd00000000l); }
@Test
public void test00260() { x = 0x7fffffff80000000l; long result = x * 0x300000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00261() { x = 0x7fffffffdeadf00dl; long result = x * 0x300000000l; AssertJUnit.assertEquals("multiply", result, 0x9c09d02700000000l); }
@Test
public void test00262() { x = 0x8000000000000000l; long result = x * 0x300000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00263() { x = 0xffffffffffffffffl; long result = x * 0x300000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffffd00000000l); }
@Test
public void test00264() { x = 0xfffffffffffffffel; long result = x * 0x300000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffffa00000000l); }
@Test
public void test00265() { x = 0xefffffffffffffffl; long result = x * 0x300000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffffd00000000l); }
@Test
public void test00266() { x = 0xdeadf00ddeadf00dl; long result = x * 0x300000000l; AssertJUnit.assertEquals("multiply", result, 0x9c09d02700000000l); }
@Test
public void test00267() { x = 0x000000007fffffffl; long result = x * 0x1800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe800000000l); }
@Test
public void test00268() { x = 0x0000000080000000l; long result = x * 0x1800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00269() { x = 0x00000000ffffffffl; long result = x * 0x1800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe800000000l); }
@Test
public void test00270() { x = 0x000000017fffffffl; long result = x * 0x1800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe800000000l); }
@Test
public void test00271() { x = 0x0000000180000000l; long result = x * 0x1800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00272() { x = 0x00000001ffffffffl; long result = x * 0x1800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe800000000l); }
@Test
public void test00273() { x = 0xffffffff7fffffffl; long result = x * 0x1800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe800000000l); }
@Test
public void test00274() { x = 0xffffffff80000000l; long result = x * 0x1800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00275() { x = 0x00000001deadf00dl; long result = x * 0x1800000000l; AssertJUnit.assertEquals("multiply", result, 0xe04e813800000000l); }
@Test
public void test00276() { x = 0xffffffffdeadf00dl; long result = x * 0x1800000000l; AssertJUnit.assertEquals("multiply", result, 0xe04e813800000000l); }
@Test
public void test00277() { x = 0x7fffffffffffffffl; long result = x * 0x1800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe800000000l); }
@Test
public void test00278() { x = 0x7fffffff7fffffffl; long result = x * 0x1800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe800000000l); }
@Test
public void test00279() { x = 0x7fffffff80000000l; long result = x * 0x1800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00280() { x = 0x7fffffffdeadf00dl; long result = x * 0x1800000000l; AssertJUnit.assertEquals("multiply", result, 0xe04e813800000000l); }
@Test
public void test00281() { x = 0x8000000000000000l; long result = x * 0x1800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00282() { x = 0xffffffffffffffffl; long result = x * 0x1800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe800000000l); }
@Test
public void test00283() { x = 0xfffffffffffffffel; long result = x * 0x1800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffd000000000l); }
@Test
public void test00284() { x = 0xefffffffffffffffl; long result = x * 0x1800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe800000000l); }
@Test
public void test00285() { x = 0xdeadf00ddeadf00dl; long result = x * 0x1800000000l; AssertJUnit.assertEquals("multiply", result, 0xe04e813800000000l); }
@Test
public void test00286() { x = 0x000000007fffffffl; long result = x * 0xfffffffffffffffdl; AssertJUnit.assertEquals("multiply", result, 0xfffffffe80000003l); }
@Test
public void test00287() { x = 0x0000000080000000l; long result = x * 0xfffffffffffffffdl; AssertJUnit.assertEquals("multiply", result, 0xfffffffe80000000l); }
@Test
public void test00288() { x = 0x00000000ffffffffl; long result = x * 0xfffffffffffffffdl; AssertJUnit.assertEquals("multiply", result, 0xfffffffd00000003l); }
@Test
public void test00289() { x = 0x000000017fffffffl; long result = x * 0xfffffffffffffffdl; AssertJUnit.assertEquals("multiply", result, 0xfffffffb80000003l); }
@Test
public void test00290() { x = 0x0000000180000000l; long result = x * 0xfffffffffffffffdl; AssertJUnit.assertEquals("multiply", result, 0xfffffffb80000000l); }
@Test
public void test00291() { x = 0x00000001ffffffffl; long result = x * 0xfffffffffffffffdl; AssertJUnit.assertEquals("multiply", result, 0xfffffffa00000003l); }
@Test
public void test00292() { x = 0xffffffff7fffffffl; long result = x * 0xfffffffffffffffdl; AssertJUnit.assertEquals("multiply", result, 0x0000000180000003l); }
@Test
public void test00293() { x = 0xffffffff80000000l; long result = x * 0xfffffffffffffffdl; AssertJUnit.assertEquals("multiply", result, 0x0000000180000000l); }
@Test
public void test00294() { x = 0x00000001deadf00dl; long result = x * 0xfffffffffffffffdl; AssertJUnit.assertEquals("multiply", result, 0xfffffffa63f62fd9l); }
@Test
public void test00295() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffffffffffffdl; AssertJUnit.assertEquals("multiply", result, 0x0000000063f62fd9l); }
@Test
public void test00296() { x = 0x7fffffffffffffffl; long result = x * 0xfffffffffffffffdl; AssertJUnit.assertEquals("multiply", result, 0x8000000000000003l); }
@Test
public void test00297() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffffffffffffdl; AssertJUnit.assertEquals("multiply", result, 0x8000000180000003l); }
@Test
public void test00298() { x = 0x7fffffff80000000l; long result = x * 0xfffffffffffffffdl; AssertJUnit.assertEquals("multiply", result, 0x8000000180000000l); }
@Test
public void test00299() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffffffffffffdl; AssertJUnit.assertEquals("multiply", result, 0x8000000063f62fd9l); }
@Test
public void test00300() { x = 0x8000000000000000l; long result = x * 0xfffffffffffffffdl; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00301() { x = 0xffffffffffffffffl; long result = x * 0xfffffffffffffffdl; AssertJUnit.assertEquals("multiply", result, 0x0000000000000003l); }
@Test
public void test00302() { x = 0xfffffffffffffffel; long result = x * 0xfffffffffffffffdl; AssertJUnit.assertEquals("multiply", result, 0x0000000000000006l); }
@Test
public void test00303() { x = 0xefffffffffffffffl; long result = x * 0xfffffffffffffffdl; AssertJUnit.assertEquals("multiply", result, 0x3000000000000003l); }
@Test
public void test00304() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffffffffffffdl; AssertJUnit.assertEquals("multiply", result, 0x63f62fd663f62fd9l); }
@Test
public void test00305() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffffe8l; AssertJUnit.assertEquals("multiply", result, 0xfffffff400000018l); }
@Test
public void test00306() { x = 0x0000000080000000l; long result = x * 0xffffffffffffffe8l; AssertJUnit.assertEquals("multiply", result, 0xfffffff400000000l); }
@Test
public void test00307() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffffe8l; AssertJUnit.assertEquals("multiply", result, 0xffffffe800000018l); }
@Test
public void test00308() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffffe8l; AssertJUnit.assertEquals("multiply", result, 0xffffffdc00000018l); }
@Test
public void test00309() { x = 0x0000000180000000l; long result = x * 0xffffffffffffffe8l; AssertJUnit.assertEquals("multiply", result, 0xffffffdc00000000l); }
@Test
public void test00310() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffffe8l; AssertJUnit.assertEquals("multiply", result, 0xffffffd000000018l); }
@Test
public void test00311() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffffe8l; AssertJUnit.assertEquals("multiply", result, 0x0000000c00000018l); }
@Test
public void test00312() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffffe8l; AssertJUnit.assertEquals("multiply", result, 0x0000000c00000000l); }
@Test
public void test00313() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffffe8l; AssertJUnit.assertEquals("multiply", result, 0xffffffd31fb17ec8l); }
@Test
public void test00314() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffffe8l; AssertJUnit.assertEquals("multiply", result, 0x000000031fb17ec8l); }
@Test
public void test00315() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffffe8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000018l); }
@Test
public void test00316() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffffe8l; AssertJUnit.assertEquals("multiply", result, 0x0000000c00000018l); }
@Test
public void test00317() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffffe8l; AssertJUnit.assertEquals("multiply", result, 0x0000000c00000000l); }
@Test
public void test00318() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffffe8l; AssertJUnit.assertEquals("multiply", result, 0x000000031fb17ec8l); }
@Test
public void test00319() { x = 0x8000000000000000l; long result = x * 0xffffffffffffffe8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00320() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffffe8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000018l); }
@Test
public void test00321() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffffe8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000030l); }
@Test
public void test00322() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffffe8l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000018l); }
@Test
public void test00323() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffffe8l; AssertJUnit.assertEquals("multiply", result, 0x1fb17eb31fb17ec8l); }
@Test
public void test00324() { x = 0x000000007fffffffl; long result = x * 0xfffffffffffffd00l; AssertJUnit.assertEquals("multiply", result, 0xfffffe8000000300l); }
@Test
public void test00325() { x = 0x0000000080000000l; long result = x * 0xfffffffffffffd00l; AssertJUnit.assertEquals("multiply", result, 0xfffffe8000000000l); }
@Test
public void test00326() { x = 0x00000000ffffffffl; long result = x * 0xfffffffffffffd00l; AssertJUnit.assertEquals("multiply", result, 0xfffffd0000000300l); }
@Test
public void test00327() { x = 0x000000017fffffffl; long result = x * 0xfffffffffffffd00l; AssertJUnit.assertEquals("multiply", result, 0xfffffb8000000300l); }
@Test
public void test00328() { x = 0x0000000180000000l; long result = x * 0xfffffffffffffd00l; AssertJUnit.assertEquals("multiply", result, 0xfffffb8000000000l); }
@Test
public void test00329() { x = 0x00000001ffffffffl; long result = x * 0xfffffffffffffd00l; AssertJUnit.assertEquals("multiply", result, 0xfffffa0000000300l); }
@Test
public void test00330() { x = 0xffffffff7fffffffl; long result = x * 0xfffffffffffffd00l; AssertJUnit.assertEquals("multiply", result, 0x0000018000000300l); }
@Test
public void test00331() { x = 0xffffffff80000000l; long result = x * 0xfffffffffffffd00l; AssertJUnit.assertEquals("multiply", result, 0x0000018000000000l); }
@Test
public void test00332() { x = 0x00000001deadf00dl; long result = x * 0xfffffffffffffd00l; AssertJUnit.assertEquals("multiply", result, 0xfffffa63f62fd900l); }
@Test
public void test00333() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffffffffffd00l; AssertJUnit.assertEquals("multiply", result, 0x00000063f62fd900l); }
@Test
public void test00334() { x = 0x7fffffffffffffffl; long result = x * 0xfffffffffffffd00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000300l); }
@Test
public void test00335() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffffffffffd00l; AssertJUnit.assertEquals("multiply", result, 0x0000018000000300l); }
@Test
public void test00336() { x = 0x7fffffff80000000l; long result = x * 0xfffffffffffffd00l; AssertJUnit.assertEquals("multiply", result, 0x0000018000000000l); }
@Test
public void test00337() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffffffffffd00l; AssertJUnit.assertEquals("multiply", result, 0x00000063f62fd900l); }
@Test
public void test00338() { x = 0x8000000000000000l; long result = x * 0xfffffffffffffd00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00339() { x = 0xffffffffffffffffl; long result = x * 0xfffffffffffffd00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000300l); }
@Test
public void test00340() { x = 0xfffffffffffffffel; long result = x * 0xfffffffffffffd00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000600l); }
@Test
public void test00341() { x = 0xefffffffffffffffl; long result = x * 0xfffffffffffffd00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000300l); }
@Test
public void test00342() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffffffffffd00l; AssertJUnit.assertEquals("multiply", result, 0xf62fd663f62fd900l); }
@Test
public void test00343() { x = 0x000000007fffffffl; long result = x * 0xfffffffd00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000300000000l); }
@Test
public void test00344() { x = 0x0000000080000000l; long result = x * 0xfffffffd00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00345() { x = 0x00000000ffffffffl; long result = x * 0xfffffffd00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000300000000l); }
@Test
public void test00346() { x = 0x000000017fffffffl; long result = x * 0xfffffffd00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000300000000l); }
@Test
public void test00347() { x = 0x0000000180000000l; long result = x * 0xfffffffd00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00348() { x = 0x00000001ffffffffl; long result = x * 0xfffffffd00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000300000000l); }
@Test
public void test00349() { x = 0xffffffff7fffffffl; long result = x * 0xfffffffd00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000300000000l); }
@Test
public void test00350() { x = 0xffffffff80000000l; long result = x * 0xfffffffd00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00351() { x = 0x00000001deadf00dl; long result = x * 0xfffffffd00000000l; AssertJUnit.assertEquals("multiply", result, 0x63f62fd900000000l); }
@Test
public void test00352() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffffd00000000l; AssertJUnit.assertEquals("multiply", result, 0x63f62fd900000000l); }
@Test
public void test00353() { x = 0x7fffffffffffffffl; long result = x * 0xfffffffd00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000300000000l); }
@Test
public void test00354() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffffd00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000300000000l); }
@Test
public void test00355() { x = 0x7fffffff80000000l; long result = x * 0xfffffffd00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00356() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffffd00000000l; AssertJUnit.assertEquals("multiply", result, 0x63f62fd900000000l); }
@Test
public void test00357() { x = 0x8000000000000000l; long result = x * 0xfffffffd00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00358() { x = 0xffffffffffffffffl; long result = x * 0xfffffffd00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000300000000l); }
@Test
public void test00359() { x = 0xfffffffffffffffel; long result = x * 0xfffffffd00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000600000000l); }
@Test
public void test00360() { x = 0xefffffffffffffffl; long result = x * 0xfffffffd00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000300000000l); }
@Test
public void test00361() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffffd00000000l; AssertJUnit.assertEquals("multiply", result, 0x63f62fd900000000l); }
@Test
public void test00362() { x = 0x000000007fffffffl; long result = x * 0xffffffe800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001800000000l); }
@Test
public void test00363() { x = 0x0000000080000000l; long result = x * 0xffffffe800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00364() { x = 0x00000000ffffffffl; long result = x * 0xffffffe800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001800000000l); }
@Test
public void test00365() { x = 0x000000017fffffffl; long result = x * 0xffffffe800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001800000000l); }
@Test
public void test00366() { x = 0x0000000180000000l; long result = x * 0xffffffe800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00367() { x = 0x00000001ffffffffl; long result = x * 0xffffffe800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001800000000l); }
@Test
public void test00368() { x = 0xffffffff7fffffffl; long result = x * 0xffffffe800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001800000000l); }
@Test
public void test00369() { x = 0xffffffff80000000l; long result = x * 0xffffffe800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00370() { x = 0x00000001deadf00dl; long result = x * 0xffffffe800000000l; AssertJUnit.assertEquals("multiply", result, 0x1fb17ec800000000l); }
@Test
public void test00371() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffe800000000l; AssertJUnit.assertEquals("multiply", result, 0x1fb17ec800000000l); }
@Test
public void test00372() { x = 0x7fffffffffffffffl; long result = x * 0xffffffe800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001800000000l); }
@Test
public void test00373() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffe800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001800000000l); }
@Test
public void test00374() { x = 0x7fffffff80000000l; long result = x * 0xffffffe800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00375() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffe800000000l; AssertJUnit.assertEquals("multiply", result, 0x1fb17ec800000000l); }
@Test
public void test00376() { x = 0x8000000000000000l; long result = x * 0xffffffe800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00377() { x = 0xffffffffffffffffl; long result = x * 0xffffffe800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001800000000l); }
@Test
public void test00378() { x = 0xfffffffffffffffel; long result = x * 0xffffffe800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000003000000000l); }
@Test
public void test00379() { x = 0xefffffffffffffffl; long result = x * 0xffffffe800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001800000000l); }
@Test
public void test00380() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffe800000000l; AssertJUnit.assertEquals("multiply", result, 0x1fb17ec800000000l); }
@Test
public void test00381() { x = 0x000000007fffffffl; long result = x * 0x5l; AssertJUnit.assertEquals("multiply", result, 0x000000027ffffffbl); }
@Test
public void test00382() { x = 0x0000000080000000l; long result = x * 0x5l; AssertJUnit.assertEquals("multiply", result, 0x0000000280000000l); }
@Test
public void test00383() { x = 0x00000000ffffffffl; long result = x * 0x5l; AssertJUnit.assertEquals("multiply", result, 0x00000004fffffffbl); }
@Test
public void test00384() { x = 0x000000017fffffffl; long result = x * 0x5l; AssertJUnit.assertEquals("multiply", result, 0x000000077ffffffbl); }
@Test
public void test00385() { x = 0x0000000180000000l; long result = x * 0x5l; AssertJUnit.assertEquals("multiply", result, 0x0000000780000000l); }
@Test
public void test00386() { x = 0x00000001ffffffffl; long result = x * 0x5l; AssertJUnit.assertEquals("multiply", result, 0x00000009fffffffbl); }
@Test
public void test00387() { x = 0xffffffff7fffffffl; long result = x * 0x5l; AssertJUnit.assertEquals("multiply", result, 0xfffffffd7ffffffbl); }
@Test
public void test00388() { x = 0xffffffff80000000l; long result = x * 0x5l; AssertJUnit.assertEquals("multiply", result, 0xfffffffd80000000l); }
@Test
public void test00389() { x = 0x00000001deadf00dl; long result = x * 0x5l; AssertJUnit.assertEquals("multiply", result, 0x000000095965b041l); }
@Test
public void test00390() { x = 0xffffffffdeadf00dl; long result = x * 0x5l; AssertJUnit.assertEquals("multiply", result, 0xffffffff5965b041l); }
@Test
public void test00391() { x = 0x7fffffffffffffffl; long result = x * 0x5l; AssertJUnit.assertEquals("multiply", result, 0x7ffffffffffffffbl); }
@Test
public void test00392() { x = 0x7fffffff7fffffffl; long result = x * 0x5l; AssertJUnit.assertEquals("multiply", result, 0x7ffffffd7ffffffbl); }
@Test
public void test00393() { x = 0x7fffffff80000000l; long result = x * 0x5l; AssertJUnit.assertEquals("multiply", result, 0x7ffffffd80000000l); }
@Test
public void test00394() { x = 0x7fffffffdeadf00dl; long result = x * 0x5l; AssertJUnit.assertEquals("multiply", result, 0x7fffffff5965b041l); }
@Test
public void test00395() { x = 0x8000000000000000l; long result = x * 0x5l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00396() { x = 0xffffffffffffffffl; long result = x * 0x5l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffffbl); }
@Test
public void test00397() { x = 0xfffffffffffffffel; long result = x * 0x5l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffff6l); }
@Test
public void test00398() { x = 0xefffffffffffffffl; long result = x * 0x5l; AssertJUnit.assertEquals("multiply", result, 0xaffffffffffffffbl); }
@Test
public void test00399() { x = 0xdeadf00ddeadf00dl; long result = x * 0x5l; AssertJUnit.assertEquals("multiply", result, 0x5965b0455965b041l); }
@Test
public void test00400() { x = 0x000000007fffffffl; long result = x * 0x28l; AssertJUnit.assertEquals("multiply", result, 0x00000013ffffffd8l); }
@Test
public void test00401() { x = 0x0000000080000000l; long result = x * 0x28l; AssertJUnit.assertEquals("multiply", result, 0x0000001400000000l); }
@Test
public void test00402() { x = 0x00000000ffffffffl; long result = x * 0x28l; AssertJUnit.assertEquals("multiply", result, 0x00000027ffffffd8l); }
@Test
public void test00403() { x = 0x000000017fffffffl; long result = x * 0x28l; AssertJUnit.assertEquals("multiply", result, 0x0000003bffffffd8l); }
@Test
public void test00404() { x = 0x0000000180000000l; long result = x * 0x28l; AssertJUnit.assertEquals("multiply", result, 0x0000003c00000000l); }
@Test
public void test00405() { x = 0x00000001ffffffffl; long result = x * 0x28l; AssertJUnit.assertEquals("multiply", result, 0x0000004fffffffd8l); }
@Test
public void test00406() { x = 0xffffffff7fffffffl; long result = x * 0x28l; AssertJUnit.assertEquals("multiply", result, 0xffffffebffffffd8l); }
@Test
public void test00407() { x = 0xffffffff80000000l; long result = x * 0x28l; AssertJUnit.assertEquals("multiply", result, 0xffffffec00000000l); }
@Test
public void test00408() { x = 0x00000001deadf00dl; long result = x * 0x28l; AssertJUnit.assertEquals("multiply", result, 0x0000004acb2d8208l); }
@Test
public void test00409() { x = 0xffffffffdeadf00dl; long result = x * 0x28l; AssertJUnit.assertEquals("multiply", result, 0xfffffffacb2d8208l); }
@Test
public void test00410() { x = 0x7fffffffffffffffl; long result = x * 0x28l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffd8l); }
@Test
public void test00411() { x = 0x7fffffff7fffffffl; long result = x * 0x28l; AssertJUnit.assertEquals("multiply", result, 0xffffffebffffffd8l); }
@Test
public void test00412() { x = 0x7fffffff80000000l; long result = x * 0x28l; AssertJUnit.assertEquals("multiply", result, 0xffffffec00000000l); }
@Test
public void test00413() { x = 0x7fffffffdeadf00dl; long result = x * 0x28l; AssertJUnit.assertEquals("multiply", result, 0xfffffffacb2d8208l); }
@Test
public void test00414() { x = 0x8000000000000000l; long result = x * 0x28l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00415() { x = 0xffffffffffffffffl; long result = x * 0x28l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffd8l); }
@Test
public void test00416() { x = 0xfffffffffffffffel; long result = x * 0x28l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffb0l); }
@Test
public void test00417() { x = 0xefffffffffffffffl; long result = x * 0x28l; AssertJUnit.assertEquals("multiply", result, 0x7fffffffffffffd8l); }
@Test
public void test00418() { x = 0xdeadf00ddeadf00dl; long result = x * 0x28l; AssertJUnit.assertEquals("multiply", result, 0xcb2d822acb2d8208l); }
@Test
public void test00419() { x = 0x000000007fffffffl; long result = x * 0x500l; AssertJUnit.assertEquals("multiply", result, 0x0000027ffffffb00l); }
@Test
public void test00420() { x = 0x0000000080000000l; long result = x * 0x500l; AssertJUnit.assertEquals("multiply", result, 0x0000028000000000l); }
@Test
public void test00421() { x = 0x00000000ffffffffl; long result = x * 0x500l; AssertJUnit.assertEquals("multiply", result, 0x000004fffffffb00l); }
@Test
public void test00422() { x = 0x000000017fffffffl; long result = x * 0x500l; AssertJUnit.assertEquals("multiply", result, 0x0000077ffffffb00l); }
@Test
public void test00423() { x = 0x0000000180000000l; long result = x * 0x500l; AssertJUnit.assertEquals("multiply", result, 0x0000078000000000l); }
@Test
public void test00424() { x = 0x00000001ffffffffl; long result = x * 0x500l; AssertJUnit.assertEquals("multiply", result, 0x000009fffffffb00l); }
@Test
public void test00425() { x = 0xffffffff7fffffffl; long result = x * 0x500l; AssertJUnit.assertEquals("multiply", result, 0xfffffd7ffffffb00l); }
@Test
public void test00426() { x = 0xffffffff80000000l; long result = x * 0x500l; AssertJUnit.assertEquals("multiply", result, 0xfffffd8000000000l); }
@Test
public void test00427() { x = 0x00000001deadf00dl; long result = x * 0x500l; AssertJUnit.assertEquals("multiply", result, 0x0000095965b04100l); }
@Test
public void test00428() { x = 0xffffffffdeadf00dl; long result = x * 0x500l; AssertJUnit.assertEquals("multiply", result, 0xffffff5965b04100l); }
@Test
public void test00429() { x = 0x7fffffffffffffffl; long result = x * 0x500l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffb00l); }
@Test
public void test00430() { x = 0x7fffffff7fffffffl; long result = x * 0x500l; AssertJUnit.assertEquals("multiply", result, 0xfffffd7ffffffb00l); }
@Test
public void test00431() { x = 0x7fffffff80000000l; long result = x * 0x500l; AssertJUnit.assertEquals("multiply", result, 0xfffffd8000000000l); }
@Test
public void test00432() { x = 0x7fffffffdeadf00dl; long result = x * 0x500l; AssertJUnit.assertEquals("multiply", result, 0xffffff5965b04100l); }
@Test
public void test00433() { x = 0x8000000000000000l; long result = x * 0x500l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00434() { x = 0xffffffffffffffffl; long result = x * 0x500l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffb00l); }
@Test
public void test00435() { x = 0xfffffffffffffffel; long result = x * 0x500l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffff600l); }
@Test
public void test00436() { x = 0xefffffffffffffffl; long result = x * 0x500l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffb00l); }
@Test
public void test00437() { x = 0xdeadf00ddeadf00dl; long result = x * 0x500l; AssertJUnit.assertEquals("multiply", result, 0x65b0455965b04100l); }
@Test
public void test00438() { x = 0x000000007fffffffl; long result = x * 0x500000000l; AssertJUnit.assertEquals("multiply", result, 0x7ffffffb00000000l); }
@Test
public void test00439() { x = 0x0000000080000000l; long result = x * 0x500000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00440() { x = 0x00000000ffffffffl; long result = x * 0x500000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffffb00000000l); }
@Test
public void test00441() { x = 0x000000017fffffffl; long result = x * 0x500000000l; AssertJUnit.assertEquals("multiply", result, 0x7ffffffb00000000l); }
@Test
public void test00442() { x = 0x0000000180000000l; long result = x * 0x500000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00443() { x = 0x00000001ffffffffl; long result = x * 0x500000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffffb00000000l); }
@Test
public void test00444() { x = 0xffffffff7fffffffl; long result = x * 0x500000000l; AssertJUnit.assertEquals("multiply", result, 0x7ffffffb00000000l); }
@Test
public void test00445() { x = 0xffffffff80000000l; long result = x * 0x500000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00446() { x = 0x00000001deadf00dl; long result = x * 0x500000000l; AssertJUnit.assertEquals("multiply", result, 0x5965b04100000000l); }
@Test
public void test00447() { x = 0xffffffffdeadf00dl; long result = x * 0x500000000l; AssertJUnit.assertEquals("multiply", result, 0x5965b04100000000l); }
@Test
public void test00448() { x = 0x7fffffffffffffffl; long result = x * 0x500000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffffb00000000l); }
@Test
public void test00449() { x = 0x7fffffff7fffffffl; long result = x * 0x500000000l; AssertJUnit.assertEquals("multiply", result, 0x7ffffffb00000000l); }
@Test
public void test00450() { x = 0x7fffffff80000000l; long result = x * 0x500000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00451() { x = 0x7fffffffdeadf00dl; long result = x * 0x500000000l; AssertJUnit.assertEquals("multiply", result, 0x5965b04100000000l); }
@Test
public void test00452() { x = 0x8000000000000000l; long result = x * 0x500000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00453() { x = 0xffffffffffffffffl; long result = x * 0x500000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffffb00000000l); }
@Test
public void test00454() { x = 0xfffffffffffffffel; long result = x * 0x500000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff600000000l); }
@Test
public void test00455() { x = 0xefffffffffffffffl; long result = x * 0x500000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffffb00000000l); }
@Test
public void test00456() { x = 0xdeadf00ddeadf00dl; long result = x * 0x500000000l; AssertJUnit.assertEquals("multiply", result, 0x5965b04100000000l); }
@Test
public void test00457() { x = 0x000000007fffffffl; long result = x * 0x2800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffd800000000l); }
@Test
public void test00458() { x = 0x0000000080000000l; long result = x * 0x2800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00459() { x = 0x00000000ffffffffl; long result = x * 0x2800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffd800000000l); }
@Test
public void test00460() { x = 0x000000017fffffffl; long result = x * 0x2800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffd800000000l); }
@Test
public void test00461() { x = 0x0000000180000000l; long result = x * 0x2800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00462() { x = 0x00000001ffffffffl; long result = x * 0x2800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffd800000000l); }
@Test
public void test00463() { x = 0xffffffff7fffffffl; long result = x * 0x2800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffd800000000l); }
@Test
public void test00464() { x = 0xffffffff80000000l; long result = x * 0x2800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00465() { x = 0x00000001deadf00dl; long result = x * 0x2800000000l; AssertJUnit.assertEquals("multiply", result, 0xcb2d820800000000l); }
@Test
public void test00466() { x = 0xffffffffdeadf00dl; long result = x * 0x2800000000l; AssertJUnit.assertEquals("multiply", result, 0xcb2d820800000000l); }
@Test
public void test00467() { x = 0x7fffffffffffffffl; long result = x * 0x2800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffd800000000l); }
@Test
public void test00468() { x = 0x7fffffff7fffffffl; long result = x * 0x2800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffd800000000l); }
@Test
public void test00469() { x = 0x7fffffff80000000l; long result = x * 0x2800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00470() { x = 0x7fffffffdeadf00dl; long result = x * 0x2800000000l; AssertJUnit.assertEquals("multiply", result, 0xcb2d820800000000l); }
@Test
public void test00471() { x = 0x8000000000000000l; long result = x * 0x2800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00472() { x = 0xffffffffffffffffl; long result = x * 0x2800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffd800000000l); }
@Test
public void test00473() { x = 0xfffffffffffffffel; long result = x * 0x2800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffb000000000l); }
@Test
public void test00474() { x = 0xefffffffffffffffl; long result = x * 0x2800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffd800000000l); }
@Test
public void test00475() { x = 0xdeadf00ddeadf00dl; long result = x * 0x2800000000l; AssertJUnit.assertEquals("multiply", result, 0xcb2d820800000000l); }
@Test
public void test00476() { x = 0x000000007fffffffl; long result = x * 0xfffffffffffffffbl; AssertJUnit.assertEquals("multiply", result, 0xfffffffd80000005l); }
@Test
public void test00477() { x = 0x0000000080000000l; long result = x * 0xfffffffffffffffbl; AssertJUnit.assertEquals("multiply", result, 0xfffffffd80000000l); }
@Test
public void test00478() { x = 0x00000000ffffffffl; long result = x * 0xfffffffffffffffbl; AssertJUnit.assertEquals("multiply", result, 0xfffffffb00000005l); }
@Test
public void test00479() { x = 0x000000017fffffffl; long result = x * 0xfffffffffffffffbl; AssertJUnit.assertEquals("multiply", result, 0xfffffff880000005l); }
@Test
public void test00480() { x = 0x0000000180000000l; long result = x * 0xfffffffffffffffbl; AssertJUnit.assertEquals("multiply", result, 0xfffffff880000000l); }
@Test
public void test00481() { x = 0x00000001ffffffffl; long result = x * 0xfffffffffffffffbl; AssertJUnit.assertEquals("multiply", result, 0xfffffff600000005l); }
@Test
public void test00482() { x = 0xffffffff7fffffffl; long result = x * 0xfffffffffffffffbl; AssertJUnit.assertEquals("multiply", result, 0x0000000280000005l); }
@Test
public void test00483() { x = 0xffffffff80000000l; long result = x * 0xfffffffffffffffbl; AssertJUnit.assertEquals("multiply", result, 0x0000000280000000l); }
@Test
public void test00484() { x = 0x00000001deadf00dl; long result = x * 0xfffffffffffffffbl; AssertJUnit.assertEquals("multiply", result, 0xfffffff6a69a4fbfl); }
@Test
public void test00485() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffffffffffffbl; AssertJUnit.assertEquals("multiply", result, 0x00000000a69a4fbfl); }
@Test
public void test00486() { x = 0x7fffffffffffffffl; long result = x * 0xfffffffffffffffbl; AssertJUnit.assertEquals("multiply", result, 0x8000000000000005l); }
@Test
public void test00487() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffffffffffffbl; AssertJUnit.assertEquals("multiply", result, 0x8000000280000005l); }
@Test
public void test00488() { x = 0x7fffffff80000000l; long result = x * 0xfffffffffffffffbl; AssertJUnit.assertEquals("multiply", result, 0x8000000280000000l); }
@Test
public void test00489() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffffffffffffbl; AssertJUnit.assertEquals("multiply", result, 0x80000000a69a4fbfl); }
@Test
public void test00490() { x = 0x8000000000000000l; long result = x * 0xfffffffffffffffbl; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00491() { x = 0xffffffffffffffffl; long result = x * 0xfffffffffffffffbl; AssertJUnit.assertEquals("multiply", result, 0x0000000000000005l); }
@Test
public void test00492() { x = 0xfffffffffffffffel; long result = x * 0xfffffffffffffffbl; AssertJUnit.assertEquals("multiply", result, 0x000000000000000al); }
@Test
public void test00493() { x = 0xefffffffffffffffl; long result = x * 0xfffffffffffffffbl; AssertJUnit.assertEquals("multiply", result, 0x5000000000000005l); }
@Test
public void test00494() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffffffffffffbl; AssertJUnit.assertEquals("multiply", result, 0xa69a4fbaa69a4fbfl); }
@Test
public void test00495() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffffd8l; AssertJUnit.assertEquals("multiply", result, 0xffffffec00000028l); }
@Test
public void test00496() { x = 0x0000000080000000l; long result = x * 0xffffffffffffffd8l; AssertJUnit.assertEquals("multiply", result, 0xffffffec00000000l); }
@Test
public void test00497() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffffd8l; AssertJUnit.assertEquals("multiply", result, 0xffffffd800000028l); }
@Test
public void test00498() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffffd8l; AssertJUnit.assertEquals("multiply", result, 0xffffffc400000028l); }
@Test
public void test00499() { x = 0x0000000180000000l; long result = x * 0xffffffffffffffd8l; AssertJUnit.assertEquals("multiply", result, 0xffffffc400000000l); }
@Test
public void test00500() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffffd8l; AssertJUnit.assertEquals("multiply", result, 0xffffffb000000028l); }
@Test
public void test00501() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffffd8l; AssertJUnit.assertEquals("multiply", result, 0x0000001400000028l); }
@Test
public void test00502() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffffd8l; AssertJUnit.assertEquals("multiply", result, 0x0000001400000000l); }
@Test
public void test00503() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffffd8l; AssertJUnit.assertEquals("multiply", result, 0xffffffb534d27df8l); }
@Test
public void test00504() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffffd8l; AssertJUnit.assertEquals("multiply", result, 0x0000000534d27df8l); }
@Test
public void test00505() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffffd8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000028l); }
@Test
public void test00506() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffffd8l; AssertJUnit.assertEquals("multiply", result, 0x0000001400000028l); }
@Test
public void test00507() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffffd8l; AssertJUnit.assertEquals("multiply", result, 0x0000001400000000l); }
@Test
public void test00508() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffffd8l; AssertJUnit.assertEquals("multiply", result, 0x0000000534d27df8l); }
@Test
public void test00509() { x = 0x8000000000000000l; long result = x * 0xffffffffffffffd8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00510() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffffd8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000028l); }
@Test
public void test00511() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffffd8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000050l); }
@Test
public void test00512() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffffd8l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000028l); }
@Test
public void test00513() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffffd8l; AssertJUnit.assertEquals("multiply", result, 0x34d27dd534d27df8l); }
@Test
public void test00514() { x = 0x000000007fffffffl; long result = x * 0xfffffffffffffb00l; AssertJUnit.assertEquals("multiply", result, 0xfffffd8000000500l); }
@Test
public void test00515() { x = 0x0000000080000000l; long result = x * 0xfffffffffffffb00l; AssertJUnit.assertEquals("multiply", result, 0xfffffd8000000000l); }
@Test
public void test00516() { x = 0x00000000ffffffffl; long result = x * 0xfffffffffffffb00l; AssertJUnit.assertEquals("multiply", result, 0xfffffb0000000500l); }
@Test
public void test00517() { x = 0x000000017fffffffl; long result = x * 0xfffffffffffffb00l; AssertJUnit.assertEquals("multiply", result, 0xfffff88000000500l); }
@Test
public void test00518() { x = 0x0000000180000000l; long result = x * 0xfffffffffffffb00l; AssertJUnit.assertEquals("multiply", result, 0xfffff88000000000l); }
@Test
public void test00519() { x = 0x00000001ffffffffl; long result = x * 0xfffffffffffffb00l; AssertJUnit.assertEquals("multiply", result, 0xfffff60000000500l); }
@Test
public void test00520() { x = 0xffffffff7fffffffl; long result = x * 0xfffffffffffffb00l; AssertJUnit.assertEquals("multiply", result, 0x0000028000000500l); }
@Test
public void test00521() { x = 0xffffffff80000000l; long result = x * 0xfffffffffffffb00l; AssertJUnit.assertEquals("multiply", result, 0x0000028000000000l); }
@Test
public void test00522() { x = 0x00000001deadf00dl; long result = x * 0xfffffffffffffb00l; AssertJUnit.assertEquals("multiply", result, 0xfffff6a69a4fbf00l); }
@Test
public void test00523() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffffffffffb00l; AssertJUnit.assertEquals("multiply", result, 0x000000a69a4fbf00l); }
@Test
public void test00524() { x = 0x7fffffffffffffffl; long result = x * 0xfffffffffffffb00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000500l); }
@Test
public void test00525() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffffffffffb00l; AssertJUnit.assertEquals("multiply", result, 0x0000028000000500l); }
@Test
public void test00526() { x = 0x7fffffff80000000l; long result = x * 0xfffffffffffffb00l; AssertJUnit.assertEquals("multiply", result, 0x0000028000000000l); }
@Test
public void test00527() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffffffffffb00l; AssertJUnit.assertEquals("multiply", result, 0x000000a69a4fbf00l); }
@Test
public void test00528() { x = 0x8000000000000000l; long result = x * 0xfffffffffffffb00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00529() { x = 0xffffffffffffffffl; long result = x * 0xfffffffffffffb00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000500l); }
@Test
public void test00530() { x = 0xfffffffffffffffel; long result = x * 0xfffffffffffffb00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000a00l); }
@Test
public void test00531() { x = 0xefffffffffffffffl; long result = x * 0xfffffffffffffb00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000500l); }
@Test
public void test00532() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffffffffffb00l; AssertJUnit.assertEquals("multiply", result, 0x9a4fbaa69a4fbf00l); }
@Test
public void test00533() { x = 0x000000007fffffffl; long result = x * 0xfffffffb00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000500000000l); }
@Test
public void test00534() { x = 0x0000000080000000l; long result = x * 0xfffffffb00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00535() { x = 0x00000000ffffffffl; long result = x * 0xfffffffb00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000500000000l); }
@Test
public void test00536() { x = 0x000000017fffffffl; long result = x * 0xfffffffb00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000500000000l); }
@Test
public void test00537() { x = 0x0000000180000000l; long result = x * 0xfffffffb00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00538() { x = 0x00000001ffffffffl; long result = x * 0xfffffffb00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000500000000l); }
@Test
public void test00539() { x = 0xffffffff7fffffffl; long result = x * 0xfffffffb00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000500000000l); }
@Test
public void test00540() { x = 0xffffffff80000000l; long result = x * 0xfffffffb00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00541() { x = 0x00000001deadf00dl; long result = x * 0xfffffffb00000000l; AssertJUnit.assertEquals("multiply", result, 0xa69a4fbf00000000l); }
@Test
public void test00542() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffffb00000000l; AssertJUnit.assertEquals("multiply", result, 0xa69a4fbf00000000l); }
@Test
public void test00543() { x = 0x7fffffffffffffffl; long result = x * 0xfffffffb00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000500000000l); }
@Test
public void test00544() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffffb00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000500000000l); }
@Test
public void test00545() { x = 0x7fffffff80000000l; long result = x * 0xfffffffb00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00546() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffffb00000000l; AssertJUnit.assertEquals("multiply", result, 0xa69a4fbf00000000l); }
@Test
public void test00547() { x = 0x8000000000000000l; long result = x * 0xfffffffb00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00548() { x = 0xffffffffffffffffl; long result = x * 0xfffffffb00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000500000000l); }
@Test
public void test00549() { x = 0xfffffffffffffffel; long result = x * 0xfffffffb00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000a00000000l); }
@Test
public void test00550() { x = 0xefffffffffffffffl; long result = x * 0xfffffffb00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000500000000l); }
@Test
public void test00551() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffffb00000000l; AssertJUnit.assertEquals("multiply", result, 0xa69a4fbf00000000l); }
@Test
public void test00552() { x = 0x000000007fffffffl; long result = x * 0xffffffd800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002800000000l); }
@Test
public void test00553() { x = 0x0000000080000000l; long result = x * 0xffffffd800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00554() { x = 0x00000000ffffffffl; long result = x * 0xffffffd800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002800000000l); }
@Test
public void test00555() { x = 0x000000017fffffffl; long result = x * 0xffffffd800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002800000000l); }
@Test
public void test00556() { x = 0x0000000180000000l; long result = x * 0xffffffd800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00557() { x = 0x00000001ffffffffl; long result = x * 0xffffffd800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002800000000l); }
@Test
public void test00558() { x = 0xffffffff7fffffffl; long result = x * 0xffffffd800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002800000000l); }
@Test
public void test00559() { x = 0xffffffff80000000l; long result = x * 0xffffffd800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00560() { x = 0x00000001deadf00dl; long result = x * 0xffffffd800000000l; AssertJUnit.assertEquals("multiply", result, 0x34d27df800000000l); }
@Test
public void test00561() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffd800000000l; AssertJUnit.assertEquals("multiply", result, 0x34d27df800000000l); }
@Test
public void test00562() { x = 0x7fffffffffffffffl; long result = x * 0xffffffd800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002800000000l); }
@Test
public void test00563() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffd800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002800000000l); }
@Test
public void test00564() { x = 0x7fffffff80000000l; long result = x * 0xffffffd800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00565() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffd800000000l; AssertJUnit.assertEquals("multiply", result, 0x34d27df800000000l); }
@Test
public void test00566() { x = 0x8000000000000000l; long result = x * 0xffffffd800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00567() { x = 0xffffffffffffffffl; long result = x * 0xffffffd800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002800000000l); }
@Test
public void test00568() { x = 0xfffffffffffffffel; long result = x * 0xffffffd800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000005000000000l); }
@Test
public void test00569() { x = 0xefffffffffffffffl; long result = x * 0xffffffd800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002800000000l); }
@Test
public void test00570() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffd800000000l; AssertJUnit.assertEquals("multiply", result, 0x34d27df800000000l); }
@Test
public void test00571() { x = 0x000000007fffffffl; long result = x * 0x6l; AssertJUnit.assertEquals("multiply", result, 0x00000002fffffffal); }
@Test
public void test00572() { x = 0x0000000080000000l; long result = x * 0x6l; AssertJUnit.assertEquals("multiply", result, 0x0000000300000000l); }
@Test
public void test00573() { x = 0x00000000ffffffffl; long result = x * 0x6l; AssertJUnit.assertEquals("multiply", result, 0x00000005fffffffal); }
@Test
public void test00574() { x = 0x000000017fffffffl; long result = x * 0x6l; AssertJUnit.assertEquals("multiply", result, 0x00000008fffffffal); }
@Test
public void test00575() { x = 0x0000000180000000l; long result = x * 0x6l; AssertJUnit.assertEquals("multiply", result, 0x0000000900000000l); }
@Test
public void test00576() { x = 0x00000001ffffffffl; long result = x * 0x6l; AssertJUnit.assertEquals("multiply", result, 0x0000000bfffffffal); }
@Test
public void test00577() { x = 0xffffffff7fffffffl; long result = x * 0x6l; AssertJUnit.assertEquals("multiply", result, 0xfffffffcfffffffal); }
@Test
public void test00578() { x = 0xffffffff80000000l; long result = x * 0x6l; AssertJUnit.assertEquals("multiply", result, 0xfffffffd00000000l); }
@Test
public void test00579() { x = 0x00000001deadf00dl; long result = x * 0x6l; AssertJUnit.assertEquals("multiply", result, 0x0000000b3813a04el); }
@Test
public void test00580() { x = 0xffffffffdeadf00dl; long result = x * 0x6l; AssertJUnit.assertEquals("multiply", result, 0xffffffff3813a04el); }
@Test
public void test00581() { x = 0x7fffffffffffffffl; long result = x * 0x6l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffffal); }
@Test
public void test00582() { x = 0x7fffffff7fffffffl; long result = x * 0x6l; AssertJUnit.assertEquals("multiply", result, 0xfffffffcfffffffal); }
@Test
public void test00583() { x = 0x7fffffff80000000l; long result = x * 0x6l; AssertJUnit.assertEquals("multiply", result, 0xfffffffd00000000l); }
@Test
public void test00584() { x = 0x7fffffffdeadf00dl; long result = x * 0x6l; AssertJUnit.assertEquals("multiply", result, 0xffffffff3813a04el); }
@Test
public void test00585() { x = 0x8000000000000000l; long result = x * 0x6l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00586() { x = 0xffffffffffffffffl; long result = x * 0x6l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffffal); }
@Test
public void test00587() { x = 0xfffffffffffffffel; long result = x * 0x6l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffff4l); }
@Test
public void test00588() { x = 0xefffffffffffffffl; long result = x * 0x6l; AssertJUnit.assertEquals("multiply", result, 0x9ffffffffffffffal); }
@Test
public void test00589() { x = 0xdeadf00ddeadf00dl; long result = x * 0x6l; AssertJUnit.assertEquals("multiply", result, 0x3813a0533813a04el); }
@Test
public void test00590() { x = 0x000000007fffffffl; long result = x * 0x30l; AssertJUnit.assertEquals("multiply", result, 0x00000017ffffffd0l); }
@Test
public void test00591() { x = 0x0000000080000000l; long result = x * 0x30l; AssertJUnit.assertEquals("multiply", result, 0x0000001800000000l); }
@Test
public void test00592() { x = 0x00000000ffffffffl; long result = x * 0x30l; AssertJUnit.assertEquals("multiply", result, 0x0000002fffffffd0l); }
@Test
public void test00593() { x = 0x000000017fffffffl; long result = x * 0x30l; AssertJUnit.assertEquals("multiply", result, 0x00000047ffffffd0l); }
@Test
public void test00594() { x = 0x0000000180000000l; long result = x * 0x30l; AssertJUnit.assertEquals("multiply", result, 0x0000004800000000l); }
@Test
public void test00595() { x = 0x00000001ffffffffl; long result = x * 0x30l; AssertJUnit.assertEquals("multiply", result, 0x0000005fffffffd0l); }
@Test
public void test00596() { x = 0xffffffff7fffffffl; long result = x * 0x30l; AssertJUnit.assertEquals("multiply", result, 0xffffffe7ffffffd0l); }
@Test
public void test00597() { x = 0xffffffff80000000l; long result = x * 0x30l; AssertJUnit.assertEquals("multiply", result, 0xffffffe800000000l); }
@Test
public void test00598() { x = 0x00000001deadf00dl; long result = x * 0x30l; AssertJUnit.assertEquals("multiply", result, 0x00000059c09d0270l); }
@Test
public void test00599() { x = 0xffffffffdeadf00dl; long result = x * 0x30l; AssertJUnit.assertEquals("multiply", result, 0xfffffff9c09d0270l); }
@Test
public void test00600() { x = 0x7fffffffffffffffl; long result = x * 0x30l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffd0l); }
@Test
public void test00601() { x = 0x7fffffff7fffffffl; long result = x * 0x30l; AssertJUnit.assertEquals("multiply", result, 0xffffffe7ffffffd0l); }
@Test
public void test00602() { x = 0x7fffffff80000000l; long result = x * 0x30l; AssertJUnit.assertEquals("multiply", result, 0xffffffe800000000l); }
@Test
public void test00603() { x = 0x7fffffffdeadf00dl; long result = x * 0x30l; AssertJUnit.assertEquals("multiply", result, 0xfffffff9c09d0270l); }
@Test
public void test00604() { x = 0x8000000000000000l; long result = x * 0x30l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00605() { x = 0xffffffffffffffffl; long result = x * 0x30l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffd0l); }
@Test
public void test00606() { x = 0xfffffffffffffffel; long result = x * 0x30l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffa0l); }
@Test
public void test00607() { x = 0xefffffffffffffffl; long result = x * 0x30l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffd0l); }
@Test
public void test00608() { x = 0xdeadf00ddeadf00dl; long result = x * 0x30l; AssertJUnit.assertEquals("multiply", result, 0xc09d0299c09d0270l); }
@Test
public void test00609() { x = 0x000000007fffffffl; long result = x * 0x600l; AssertJUnit.assertEquals("multiply", result, 0x000002fffffffa00l); }
@Test
public void test00610() { x = 0x0000000080000000l; long result = x * 0x600l; AssertJUnit.assertEquals("multiply", result, 0x0000030000000000l); }
@Test
public void test00611() { x = 0x00000000ffffffffl; long result = x * 0x600l; AssertJUnit.assertEquals("multiply", result, 0x000005fffffffa00l); }
@Test
public void test00612() { x = 0x000000017fffffffl; long result = x * 0x600l; AssertJUnit.assertEquals("multiply", result, 0x000008fffffffa00l); }
@Test
public void test00613() { x = 0x0000000180000000l; long result = x * 0x600l; AssertJUnit.assertEquals("multiply", result, 0x0000090000000000l); }
@Test
public void test00614() { x = 0x00000001ffffffffl; long result = x * 0x600l; AssertJUnit.assertEquals("multiply", result, 0x00000bfffffffa00l); }
@Test
public void test00615() { x = 0xffffffff7fffffffl; long result = x * 0x600l; AssertJUnit.assertEquals("multiply", result, 0xfffffcfffffffa00l); }
@Test
public void test00616() { x = 0xffffffff80000000l; long result = x * 0x600l; AssertJUnit.assertEquals("multiply", result, 0xfffffd0000000000l); }
@Test
public void test00617() { x = 0x00000001deadf00dl; long result = x * 0x600l; AssertJUnit.assertEquals("multiply", result, 0x00000b3813a04e00l); }
@Test
public void test00618() { x = 0xffffffffdeadf00dl; long result = x * 0x600l; AssertJUnit.assertEquals("multiply", result, 0xffffff3813a04e00l); }
@Test
public void test00619() { x = 0x7fffffffffffffffl; long result = x * 0x600l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffa00l); }
@Test
public void test00620() { x = 0x7fffffff7fffffffl; long result = x * 0x600l; AssertJUnit.assertEquals("multiply", result, 0xfffffcfffffffa00l); }
@Test
public void test00621() { x = 0x7fffffff80000000l; long result = x * 0x600l; AssertJUnit.assertEquals("multiply", result, 0xfffffd0000000000l); }
@Test
public void test00622() { x = 0x7fffffffdeadf00dl; long result = x * 0x600l; AssertJUnit.assertEquals("multiply", result, 0xffffff3813a04e00l); }
@Test
public void test00623() { x = 0x8000000000000000l; long result = x * 0x600l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00624() { x = 0xffffffffffffffffl; long result = x * 0x600l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffa00l); }
@Test
public void test00625() { x = 0xfffffffffffffffel; long result = x * 0x600l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffff400l); }
@Test
public void test00626() { x = 0xefffffffffffffffl; long result = x * 0x600l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffa00l); }
@Test
public void test00627() { x = 0xdeadf00ddeadf00dl; long result = x * 0x600l; AssertJUnit.assertEquals("multiply", result, 0x13a0533813a04e00l); }
@Test
public void test00628() { x = 0x000000007fffffffl; long result = x * 0x600000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffffa00000000l); }
@Test
public void test00629() { x = 0x0000000080000000l; long result = x * 0x600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00630() { x = 0x00000000ffffffffl; long result = x * 0x600000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffffa00000000l); }
@Test
public void test00631() { x = 0x000000017fffffffl; long result = x * 0x600000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffffa00000000l); }
@Test
public void test00632() { x = 0x0000000180000000l; long result = x * 0x600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00633() { x = 0x00000001ffffffffl; long result = x * 0x600000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffffa00000000l); }
@Test
public void test00634() { x = 0xffffffff7fffffffl; long result = x * 0x600000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffffa00000000l); }
@Test
public void test00635() { x = 0xffffffff80000000l; long result = x * 0x600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00636() { x = 0x00000001deadf00dl; long result = x * 0x600000000l; AssertJUnit.assertEquals("multiply", result, 0x3813a04e00000000l); }
@Test
public void test00637() { x = 0xffffffffdeadf00dl; long result = x * 0x600000000l; AssertJUnit.assertEquals("multiply", result, 0x3813a04e00000000l); }
@Test
public void test00638() { x = 0x7fffffffffffffffl; long result = x * 0x600000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffffa00000000l); }
@Test
public void test00639() { x = 0x7fffffff7fffffffl; long result = x * 0x600000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffffa00000000l); }
@Test
public void test00640() { x = 0x7fffffff80000000l; long result = x * 0x600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00641() { x = 0x7fffffffdeadf00dl; long result = x * 0x600000000l; AssertJUnit.assertEquals("multiply", result, 0x3813a04e00000000l); }
@Test
public void test00642() { x = 0x8000000000000000l; long result = x * 0x600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00643() { x = 0xffffffffffffffffl; long result = x * 0x600000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffffa00000000l); }
@Test
public void test00644() { x = 0xfffffffffffffffel; long result = x * 0x600000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff400000000l); }
@Test
public void test00645() { x = 0xefffffffffffffffl; long result = x * 0x600000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffffa00000000l); }
@Test
public void test00646() { x = 0xdeadf00ddeadf00dl; long result = x * 0x600000000l; AssertJUnit.assertEquals("multiply", result, 0x3813a04e00000000l); }
@Test
public void test00647() { x = 0x000000007fffffffl; long result = x * 0x3000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffd000000000l); }
@Test
public void test00648() { x = 0x0000000080000000l; long result = x * 0x3000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00649() { x = 0x00000000ffffffffl; long result = x * 0x3000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffd000000000l); }
@Test
public void test00650() { x = 0x000000017fffffffl; long result = x * 0x3000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffd000000000l); }
@Test
public void test00651() { x = 0x0000000180000000l; long result = x * 0x3000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00652() { x = 0x00000001ffffffffl; long result = x * 0x3000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffd000000000l); }
@Test
public void test00653() { x = 0xffffffff7fffffffl; long result = x * 0x3000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffd000000000l); }
@Test
public void test00654() { x = 0xffffffff80000000l; long result = x * 0x3000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00655() { x = 0x00000001deadf00dl; long result = x * 0x3000000000l; AssertJUnit.assertEquals("multiply", result, 0xc09d027000000000l); }
@Test
public void test00656() { x = 0xffffffffdeadf00dl; long result = x * 0x3000000000l; AssertJUnit.assertEquals("multiply", result, 0xc09d027000000000l); }
@Test
public void test00657() { x = 0x7fffffffffffffffl; long result = x * 0x3000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffd000000000l); }
@Test
public void test00658() { x = 0x7fffffff7fffffffl; long result = x * 0x3000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffd000000000l); }
@Test
public void test00659() { x = 0x7fffffff80000000l; long result = x * 0x3000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00660() { x = 0x7fffffffdeadf00dl; long result = x * 0x3000000000l; AssertJUnit.assertEquals("multiply", result, 0xc09d027000000000l); }
@Test
public void test00661() { x = 0x8000000000000000l; long result = x * 0x3000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00662() { x = 0xffffffffffffffffl; long result = x * 0x3000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffd000000000l); }
@Test
public void test00663() { x = 0xfffffffffffffffel; long result = x * 0x3000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffa000000000l); }
@Test
public void test00664() { x = 0xefffffffffffffffl; long result = x * 0x3000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffd000000000l); }
@Test
public void test00665() { x = 0xdeadf00ddeadf00dl; long result = x * 0x3000000000l; AssertJUnit.assertEquals("multiply", result, 0xc09d027000000000l); }
@Test
public void test00666() { x = 0x000000007fffffffl; long result = x * 0xfffffffffffffffal; AssertJUnit.assertEquals("multiply", result, 0xfffffffd00000006l); }
@Test
public void test00667() { x = 0x0000000080000000l; long result = x * 0xfffffffffffffffal; AssertJUnit.assertEquals("multiply", result, 0xfffffffd00000000l); }
@Test
public void test00668() { x = 0x00000000ffffffffl; long result = x * 0xfffffffffffffffal; AssertJUnit.assertEquals("multiply", result, 0xfffffffa00000006l); }
@Test
public void test00669() { x = 0x000000017fffffffl; long result = x * 0xfffffffffffffffal; AssertJUnit.assertEquals("multiply", result, 0xfffffff700000006l); }
@Test
public void test00670() { x = 0x0000000180000000l; long result = x * 0xfffffffffffffffal; AssertJUnit.assertEquals("multiply", result, 0xfffffff700000000l); }
@Test
public void test00671() { x = 0x00000001ffffffffl; long result = x * 0xfffffffffffffffal; AssertJUnit.assertEquals("multiply", result, 0xfffffff400000006l); }
@Test
public void test00672() { x = 0xffffffff7fffffffl; long result = x * 0xfffffffffffffffal; AssertJUnit.assertEquals("multiply", result, 0x0000000300000006l); }
@Test
public void test00673() { x = 0xffffffff80000000l; long result = x * 0xfffffffffffffffal; AssertJUnit.assertEquals("multiply", result, 0x0000000300000000l); }
@Test
public void test00674() { x = 0x00000001deadf00dl; long result = x * 0xfffffffffffffffal; AssertJUnit.assertEquals("multiply", result, 0xfffffff4c7ec5fb2l); }
@Test
public void test00675() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffffffffffffal; AssertJUnit.assertEquals("multiply", result, 0x00000000c7ec5fb2l); }
@Test
public void test00676() { x = 0x7fffffffffffffffl; long result = x * 0xfffffffffffffffal; AssertJUnit.assertEquals("multiply", result, 0x0000000000000006l); }
@Test
public void test00677() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffffffffffffal; AssertJUnit.assertEquals("multiply", result, 0x0000000300000006l); }
@Test
public void test00678() { x = 0x7fffffff80000000l; long result = x * 0xfffffffffffffffal; AssertJUnit.assertEquals("multiply", result, 0x0000000300000000l); }
@Test
public void test00679() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffffffffffffal; AssertJUnit.assertEquals("multiply", result, 0x00000000c7ec5fb2l); }
@Test
public void test00680() { x = 0x8000000000000000l; long result = x * 0xfffffffffffffffal; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00681() { x = 0xffffffffffffffffl; long result = x * 0xfffffffffffffffal; AssertJUnit.assertEquals("multiply", result, 0x0000000000000006l); }
@Test
public void test00682() { x = 0xfffffffffffffffel; long result = x * 0xfffffffffffffffal; AssertJUnit.assertEquals("multiply", result, 0x000000000000000cl); }
@Test
public void test00683() { x = 0xefffffffffffffffl; long result = x * 0xfffffffffffffffal; AssertJUnit.assertEquals("multiply", result, 0x6000000000000006l); }
@Test
public void test00684() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffffffffffffal; AssertJUnit.assertEquals("multiply", result, 0xc7ec5facc7ec5fb2l); }
@Test
public void test00685() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffffd0l; AssertJUnit.assertEquals("multiply", result, 0xffffffe800000030l); }
@Test
public void test00686() { x = 0x0000000080000000l; long result = x * 0xffffffffffffffd0l; AssertJUnit.assertEquals("multiply", result, 0xffffffe800000000l); }
@Test
public void test00687() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffffd0l; AssertJUnit.assertEquals("multiply", result, 0xffffffd000000030l); }
@Test
public void test00688() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffffd0l; AssertJUnit.assertEquals("multiply", result, 0xffffffb800000030l); }
@Test
public void test00689() { x = 0x0000000180000000l; long result = x * 0xffffffffffffffd0l; AssertJUnit.assertEquals("multiply", result, 0xffffffb800000000l); }
@Test
public void test00690() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffffd0l; AssertJUnit.assertEquals("multiply", result, 0xffffffa000000030l); }
@Test
public void test00691() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffffd0l; AssertJUnit.assertEquals("multiply", result, 0x0000001800000030l); }
@Test
public void test00692() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffffd0l; AssertJUnit.assertEquals("multiply", result, 0x0000001800000000l); }
@Test
public void test00693() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffffd0l; AssertJUnit.assertEquals("multiply", result, 0xffffffa63f62fd90l); }
@Test
public void test00694() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffffd0l; AssertJUnit.assertEquals("multiply", result, 0x000000063f62fd90l); }
@Test
public void test00695() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffffd0l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000030l); }
@Test
public void test00696() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffffd0l; AssertJUnit.assertEquals("multiply", result, 0x0000001800000030l); }
@Test
public void test00697() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffffd0l; AssertJUnit.assertEquals("multiply", result, 0x0000001800000000l); }
@Test
public void test00698() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffffd0l; AssertJUnit.assertEquals("multiply", result, 0x000000063f62fd90l); }
@Test
public void test00699() { x = 0x8000000000000000l; long result = x * 0xffffffffffffffd0l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00700() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffffd0l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000030l); }
@Test
public void test00701() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffffd0l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000060l); }
@Test
public void test00702() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffffd0l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000030l); }
@Test
public void test00703() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffffd0l; AssertJUnit.assertEquals("multiply", result, 0x3f62fd663f62fd90l); }
@Test
public void test00704() { x = 0x000000007fffffffl; long result = x * 0xfffffffffffffa00l; AssertJUnit.assertEquals("multiply", result, 0xfffffd0000000600l); }
@Test
public void test00705() { x = 0x0000000080000000l; long result = x * 0xfffffffffffffa00l; AssertJUnit.assertEquals("multiply", result, 0xfffffd0000000000l); }
@Test
public void test00706() { x = 0x00000000ffffffffl; long result = x * 0xfffffffffffffa00l; AssertJUnit.assertEquals("multiply", result, 0xfffffa0000000600l); }
@Test
public void test00707() { x = 0x000000017fffffffl; long result = x * 0xfffffffffffffa00l; AssertJUnit.assertEquals("multiply", result, 0xfffff70000000600l); }
@Test
public void test00708() { x = 0x0000000180000000l; long result = x * 0xfffffffffffffa00l; AssertJUnit.assertEquals("multiply", result, 0xfffff70000000000l); }
@Test
public void test00709() { x = 0x00000001ffffffffl; long result = x * 0xfffffffffffffa00l; AssertJUnit.assertEquals("multiply", result, 0xfffff40000000600l); }
@Test
public void test00710() { x = 0xffffffff7fffffffl; long result = x * 0xfffffffffffffa00l; AssertJUnit.assertEquals("multiply", result, 0x0000030000000600l); }
@Test
public void test00711() { x = 0xffffffff80000000l; long result = x * 0xfffffffffffffa00l; AssertJUnit.assertEquals("multiply", result, 0x0000030000000000l); }
@Test
public void test00712() { x = 0x00000001deadf00dl; long result = x * 0xfffffffffffffa00l; AssertJUnit.assertEquals("multiply", result, 0xfffff4c7ec5fb200l); }
@Test
public void test00713() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffffffffffa00l; AssertJUnit.assertEquals("multiply", result, 0x000000c7ec5fb200l); }
@Test
public void test00714() { x = 0x7fffffffffffffffl; long result = x * 0xfffffffffffffa00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000600l); }
@Test
public void test00715() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffffffffffa00l; AssertJUnit.assertEquals("multiply", result, 0x0000030000000600l); }
@Test
public void test00716() { x = 0x7fffffff80000000l; long result = x * 0xfffffffffffffa00l; AssertJUnit.assertEquals("multiply", result, 0x0000030000000000l); }
@Test
public void test00717() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffffffffffa00l; AssertJUnit.assertEquals("multiply", result, 0x000000c7ec5fb200l); }
@Test
public void test00718() { x = 0x8000000000000000l; long result = x * 0xfffffffffffffa00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00719() { x = 0xffffffffffffffffl; long result = x * 0xfffffffffffffa00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000600l); }
@Test
public void test00720() { x = 0xfffffffffffffffel; long result = x * 0xfffffffffffffa00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000c00l); }
@Test
public void test00721() { x = 0xefffffffffffffffl; long result = x * 0xfffffffffffffa00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000600l); }
@Test
public void test00722() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffffffffffa00l; AssertJUnit.assertEquals("multiply", result, 0xec5facc7ec5fb200l); }
@Test
public void test00723() { x = 0x000000007fffffffl; long result = x * 0xfffffffa00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000600000000l); }
@Test
public void test00724() { x = 0x0000000080000000l; long result = x * 0xfffffffa00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00725() { x = 0x00000000ffffffffl; long result = x * 0xfffffffa00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000600000000l); }
@Test
public void test00726() { x = 0x000000017fffffffl; long result = x * 0xfffffffa00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000600000000l); }
@Test
public void test00727() { x = 0x0000000180000000l; long result = x * 0xfffffffa00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00728() { x = 0x00000001ffffffffl; long result = x * 0xfffffffa00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000600000000l); }
@Test
public void test00729() { x = 0xffffffff7fffffffl; long result = x * 0xfffffffa00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000600000000l); }
@Test
public void test00730() { x = 0xffffffff80000000l; long result = x * 0xfffffffa00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00731() { x = 0x00000001deadf00dl; long result = x * 0xfffffffa00000000l; AssertJUnit.assertEquals("multiply", result, 0xc7ec5fb200000000l); }
@Test
public void test00732() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffffa00000000l; AssertJUnit.assertEquals("multiply", result, 0xc7ec5fb200000000l); }
@Test
public void test00733() { x = 0x7fffffffffffffffl; long result = x * 0xfffffffa00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000600000000l); }
@Test
public void test00734() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffffa00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000600000000l); }
@Test
public void test00735() { x = 0x7fffffff80000000l; long result = x * 0xfffffffa00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00736() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffffa00000000l; AssertJUnit.assertEquals("multiply", result, 0xc7ec5fb200000000l); }
@Test
public void test00737() { x = 0x8000000000000000l; long result = x * 0xfffffffa00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00738() { x = 0xffffffffffffffffl; long result = x * 0xfffffffa00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000600000000l); }
@Test
public void test00739() { x = 0xfffffffffffffffel; long result = x * 0xfffffffa00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000c00000000l); }
@Test
public void test00740() { x = 0xefffffffffffffffl; long result = x * 0xfffffffa00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000600000000l); }
@Test
public void test00741() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffffa00000000l; AssertJUnit.assertEquals("multiply", result, 0xc7ec5fb200000000l); }
@Test
public void test00742() { x = 0x000000007fffffffl; long result = x * 0xffffffd000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000003000000000l); }
@Test
public void test00743() { x = 0x0000000080000000l; long result = x * 0xffffffd000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00744() { x = 0x00000000ffffffffl; long result = x * 0xffffffd000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000003000000000l); }
@Test
public void test00745() { x = 0x000000017fffffffl; long result = x * 0xffffffd000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000003000000000l); }
@Test
public void test00746() { x = 0x0000000180000000l; long result = x * 0xffffffd000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00747() { x = 0x00000001ffffffffl; long result = x * 0xffffffd000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000003000000000l); }
@Test
public void test00748() { x = 0xffffffff7fffffffl; long result = x * 0xffffffd000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000003000000000l); }
@Test
public void test00749() { x = 0xffffffff80000000l; long result = x * 0xffffffd000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00750() { x = 0x00000001deadf00dl; long result = x * 0xffffffd000000000l; AssertJUnit.assertEquals("multiply", result, 0x3f62fd9000000000l); }
@Test
public void test00751() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffd000000000l; AssertJUnit.assertEquals("multiply", result, 0x3f62fd9000000000l); }
@Test
public void test00752() { x = 0x7fffffffffffffffl; long result = x * 0xffffffd000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000003000000000l); }
@Test
public void test00753() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffd000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000003000000000l); }
@Test
public void test00754() { x = 0x7fffffff80000000l; long result = x * 0xffffffd000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00755() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffd000000000l; AssertJUnit.assertEquals("multiply", result, 0x3f62fd9000000000l); }
@Test
public void test00756() { x = 0x8000000000000000l; long result = x * 0xffffffd000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00757() { x = 0xffffffffffffffffl; long result = x * 0xffffffd000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000003000000000l); }
@Test
public void test00758() { x = 0xfffffffffffffffel; long result = x * 0xffffffd000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000006000000000l); }
@Test
public void test00759() { x = 0xefffffffffffffffl; long result = x * 0xffffffd000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000003000000000l); }
@Test
public void test00760() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffd000000000l; AssertJUnit.assertEquals("multiply", result, 0x3f62fd9000000000l); }
@Test
public void test00761() { x = 0x000000007fffffffl; long result = x * 0x7l; AssertJUnit.assertEquals("multiply", result, 0x000000037ffffff9l); }
@Test
public void test00762() { x = 0x0000000080000000l; long result = x * 0x7l; AssertJUnit.assertEquals("multiply", result, 0x0000000380000000l); }
@Test
public void test00763() { x = 0x00000000ffffffffl; long result = x * 0x7l; AssertJUnit.assertEquals("multiply", result, 0x00000006fffffff9l); }
@Test
public void test00764() { x = 0x000000017fffffffl; long result = x * 0x7l; AssertJUnit.assertEquals("multiply", result, 0x0000000a7ffffff9l); }
@Test
public void test00765() { x = 0x0000000180000000l; long result = x * 0x7l; AssertJUnit.assertEquals("multiply", result, 0x0000000a80000000l); }
@Test
public void test00766() { x = 0x00000001ffffffffl; long result = x * 0x7l; AssertJUnit.assertEquals("multiply", result, 0x0000000dfffffff9l); }
@Test
public void test00767() { x = 0xffffffff7fffffffl; long result = x * 0x7l; AssertJUnit.assertEquals("multiply", result, 0xfffffffc7ffffff9l); }
@Test
public void test00768() { x = 0xffffffff80000000l; long result = x * 0x7l; AssertJUnit.assertEquals("multiply", result, 0xfffffffc80000000l); }
@Test
public void test00769() { x = 0x00000001deadf00dl; long result = x * 0x7l; AssertJUnit.assertEquals("multiply", result, 0x0000000d16c1905bl); }
@Test
public void test00770() { x = 0xffffffffdeadf00dl; long result = x * 0x7l; AssertJUnit.assertEquals("multiply", result, 0xffffffff16c1905bl); }
@Test
public void test00771() { x = 0x7fffffffffffffffl; long result = x * 0x7l; AssertJUnit.assertEquals("multiply", result, 0x7ffffffffffffff9l); }
@Test
public void test00772() { x = 0x7fffffff7fffffffl; long result = x * 0x7l; AssertJUnit.assertEquals("multiply", result, 0x7ffffffc7ffffff9l); }
@Test
public void test00773() { x = 0x7fffffff80000000l; long result = x * 0x7l; AssertJUnit.assertEquals("multiply", result, 0x7ffffffc80000000l); }
@Test
public void test00774() { x = 0x7fffffffdeadf00dl; long result = x * 0x7l; AssertJUnit.assertEquals("multiply", result, 0x7fffffff16c1905bl); }
@Test
public void test00775() { x = 0x8000000000000000l; long result = x * 0x7l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00776() { x = 0xffffffffffffffffl; long result = x * 0x7l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffff9l); }
@Test
public void test00777() { x = 0xfffffffffffffffel; long result = x * 0x7l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffff2l); }
@Test
public void test00778() { x = 0xefffffffffffffffl; long result = x * 0x7l; AssertJUnit.assertEquals("multiply", result, 0x8ffffffffffffff9l); }
@Test
public void test00779() { x = 0xdeadf00ddeadf00dl; long result = x * 0x7l; AssertJUnit.assertEquals("multiply", result, 0x16c1906116c1905bl); }
@Test
public void test00780() { x = 0x000000007fffffffl; long result = x * 0x38l; AssertJUnit.assertEquals("multiply", result, 0x0000001bffffffc8l); }
@Test
public void test00781() { x = 0x0000000080000000l; long result = x * 0x38l; AssertJUnit.assertEquals("multiply", result, 0x0000001c00000000l); }
@Test
public void test00782() { x = 0x00000000ffffffffl; long result = x * 0x38l; AssertJUnit.assertEquals("multiply", result, 0x00000037ffffffc8l); }
@Test
public void test00783() { x = 0x000000017fffffffl; long result = x * 0x38l; AssertJUnit.assertEquals("multiply", result, 0x00000053ffffffc8l); }
@Test
public void test00784() { x = 0x0000000180000000l; long result = x * 0x38l; AssertJUnit.assertEquals("multiply", result, 0x0000005400000000l); }
@Test
public void test00785() { x = 0x00000001ffffffffl; long result = x * 0x38l; AssertJUnit.assertEquals("multiply", result, 0x0000006fffffffc8l); }
@Test
public void test00786() { x = 0xffffffff7fffffffl; long result = x * 0x38l; AssertJUnit.assertEquals("multiply", result, 0xffffffe3ffffffc8l); }
@Test
public void test00787() { x = 0xffffffff80000000l; long result = x * 0x38l; AssertJUnit.assertEquals("multiply", result, 0xffffffe400000000l); }
@Test
public void test00788() { x = 0x00000001deadf00dl; long result = x * 0x38l; AssertJUnit.assertEquals("multiply", result, 0x00000068b60c82d8l); }
@Test
public void test00789() { x = 0xffffffffdeadf00dl; long result = x * 0x38l; AssertJUnit.assertEquals("multiply", result, 0xfffffff8b60c82d8l); }
@Test
public void test00790() { x = 0x7fffffffffffffffl; long result = x * 0x38l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffc8l); }
@Test
public void test00791() { x = 0x7fffffff7fffffffl; long result = x * 0x38l; AssertJUnit.assertEquals("multiply", result, 0xffffffe3ffffffc8l); }
@Test
public void test00792() { x = 0x7fffffff80000000l; long result = x * 0x38l; AssertJUnit.assertEquals("multiply", result, 0xffffffe400000000l); }
@Test
public void test00793() { x = 0x7fffffffdeadf00dl; long result = x * 0x38l; AssertJUnit.assertEquals("multiply", result, 0xfffffff8b60c82d8l); }
@Test
public void test00794() { x = 0x8000000000000000l; long result = x * 0x38l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00795() { x = 0xffffffffffffffffl; long result = x * 0x38l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffc8l); }
@Test
public void test00796() { x = 0xfffffffffffffffel; long result = x * 0x38l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff90l); }
@Test
public void test00797() { x = 0xefffffffffffffffl; long result = x * 0x38l; AssertJUnit.assertEquals("multiply", result, 0x7fffffffffffffc8l); }
@Test
public void test00798() { x = 0xdeadf00ddeadf00dl; long result = x * 0x38l; AssertJUnit.assertEquals("multiply", result, 0xb60c8308b60c82d8l); }
@Test
public void test00799() { x = 0x000000007fffffffl; long result = x * 0x700l; AssertJUnit.assertEquals("multiply", result, 0x0000037ffffff900l); }
@Test
public void test00800() { x = 0x0000000080000000l; long result = x * 0x700l; AssertJUnit.assertEquals("multiply", result, 0x0000038000000000l); }
@Test
public void test00801() { x = 0x00000000ffffffffl; long result = x * 0x700l; AssertJUnit.assertEquals("multiply", result, 0x000006fffffff900l); }
@Test
public void test00802() { x = 0x000000017fffffffl; long result = x * 0x700l; AssertJUnit.assertEquals("multiply", result, 0x00000a7ffffff900l); }
@Test
public void test00803() { x = 0x0000000180000000l; long result = x * 0x700l; AssertJUnit.assertEquals("multiply", result, 0x00000a8000000000l); }
@Test
public void test00804() { x = 0x00000001ffffffffl; long result = x * 0x700l; AssertJUnit.assertEquals("multiply", result, 0x00000dfffffff900l); }
@Test
public void test00805() { x = 0xffffffff7fffffffl; long result = x * 0x700l; AssertJUnit.assertEquals("multiply", result, 0xfffffc7ffffff900l); }
@Test
public void test00806() { x = 0xffffffff80000000l; long result = x * 0x700l; AssertJUnit.assertEquals("multiply", result, 0xfffffc8000000000l); }
@Test
public void test00807() { x = 0x00000001deadf00dl; long result = x * 0x700l; AssertJUnit.assertEquals("multiply", result, 0x00000d16c1905b00l); }
@Test
public void test00808() { x = 0xffffffffdeadf00dl; long result = x * 0x700l; AssertJUnit.assertEquals("multiply", result, 0xffffff16c1905b00l); }
@Test
public void test00809() { x = 0x7fffffffffffffffl; long result = x * 0x700l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffff900l); }
@Test
public void test00810() { x = 0x7fffffff7fffffffl; long result = x * 0x700l; AssertJUnit.assertEquals("multiply", result, 0xfffffc7ffffff900l); }
@Test
public void test00811() { x = 0x7fffffff80000000l; long result = x * 0x700l; AssertJUnit.assertEquals("multiply", result, 0xfffffc8000000000l); }
@Test
public void test00812() { x = 0x7fffffffdeadf00dl; long result = x * 0x700l; AssertJUnit.assertEquals("multiply", result, 0xffffff16c1905b00l); }
@Test
public void test00813() { x = 0x8000000000000000l; long result = x * 0x700l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00814() { x = 0xffffffffffffffffl; long result = x * 0x700l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffff900l); }
@Test
public void test00815() { x = 0xfffffffffffffffel; long result = x * 0x700l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffff200l); }
@Test
public void test00816() { x = 0xefffffffffffffffl; long result = x * 0x700l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffff900l); }
@Test
public void test00817() { x = 0xdeadf00ddeadf00dl; long result = x * 0x700l; AssertJUnit.assertEquals("multiply", result, 0xc1906116c1905b00l); }
@Test
public void test00818() { x = 0x000000007fffffffl; long result = x * 0x700000000l; AssertJUnit.assertEquals("multiply", result, 0x7ffffff900000000l); }
@Test
public void test00819() { x = 0x0000000080000000l; long result = x * 0x700000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00820() { x = 0x00000000ffffffffl; long result = x * 0x700000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff900000000l); }
@Test
public void test00821() { x = 0x000000017fffffffl; long result = x * 0x700000000l; AssertJUnit.assertEquals("multiply", result, 0x7ffffff900000000l); }
@Test
public void test00822() { x = 0x0000000180000000l; long result = x * 0x700000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00823() { x = 0x00000001ffffffffl; long result = x * 0x700000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff900000000l); }
@Test
public void test00824() { x = 0xffffffff7fffffffl; long result = x * 0x700000000l; AssertJUnit.assertEquals("multiply", result, 0x7ffffff900000000l); }
@Test
public void test00825() { x = 0xffffffff80000000l; long result = x * 0x700000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00826() { x = 0x00000001deadf00dl; long result = x * 0x700000000l; AssertJUnit.assertEquals("multiply", result, 0x16c1905b00000000l); }
@Test
public void test00827() { x = 0xffffffffdeadf00dl; long result = x * 0x700000000l; AssertJUnit.assertEquals("multiply", result, 0x16c1905b00000000l); }
@Test
public void test00828() { x = 0x7fffffffffffffffl; long result = x * 0x700000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff900000000l); }
@Test
public void test00829() { x = 0x7fffffff7fffffffl; long result = x * 0x700000000l; AssertJUnit.assertEquals("multiply", result, 0x7ffffff900000000l); }
@Test
public void test00830() { x = 0x7fffffff80000000l; long result = x * 0x700000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00831() { x = 0x7fffffffdeadf00dl; long result = x * 0x700000000l; AssertJUnit.assertEquals("multiply", result, 0x16c1905b00000000l); }
@Test
public void test00832() { x = 0x8000000000000000l; long result = x * 0x700000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00833() { x = 0xffffffffffffffffl; long result = x * 0x700000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff900000000l); }
@Test
public void test00834() { x = 0xfffffffffffffffel; long result = x * 0x700000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff200000000l); }
@Test
public void test00835() { x = 0xefffffffffffffffl; long result = x * 0x700000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff900000000l); }
@Test
public void test00836() { x = 0xdeadf00ddeadf00dl; long result = x * 0x700000000l; AssertJUnit.assertEquals("multiply", result, 0x16c1905b00000000l); }
@Test
public void test00837() { x = 0x000000007fffffffl; long result = x * 0x3800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffc800000000l); }
@Test
public void test00838() { x = 0x0000000080000000l; long result = x * 0x3800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00839() { x = 0x00000000ffffffffl; long result = x * 0x3800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffc800000000l); }
@Test
public void test00840() { x = 0x000000017fffffffl; long result = x * 0x3800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffc800000000l); }
@Test
public void test00841() { x = 0x0000000180000000l; long result = x * 0x3800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00842() { x = 0x00000001ffffffffl; long result = x * 0x3800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffc800000000l); }
@Test
public void test00843() { x = 0xffffffff7fffffffl; long result = x * 0x3800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffc800000000l); }
@Test
public void test00844() { x = 0xffffffff80000000l; long result = x * 0x3800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00845() { x = 0x00000001deadf00dl; long result = x * 0x3800000000l; AssertJUnit.assertEquals("multiply", result, 0xb60c82d800000000l); }
@Test
public void test00846() { x = 0xffffffffdeadf00dl; long result = x * 0x3800000000l; AssertJUnit.assertEquals("multiply", result, 0xb60c82d800000000l); }
@Test
public void test00847() { x = 0x7fffffffffffffffl; long result = x * 0x3800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffc800000000l); }
@Test
public void test00848() { x = 0x7fffffff7fffffffl; long result = x * 0x3800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffc800000000l); }
@Test
public void test00849() { x = 0x7fffffff80000000l; long result = x * 0x3800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00850() { x = 0x7fffffffdeadf00dl; long result = x * 0x3800000000l; AssertJUnit.assertEquals("multiply", result, 0xb60c82d800000000l); }
@Test
public void test00851() { x = 0x8000000000000000l; long result = x * 0x3800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00852() { x = 0xffffffffffffffffl; long result = x * 0x3800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffc800000000l); }
@Test
public void test00853() { x = 0xfffffffffffffffel; long result = x * 0x3800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff9000000000l); }
@Test
public void test00854() { x = 0xefffffffffffffffl; long result = x * 0x3800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffc800000000l); }
@Test
public void test00855() { x = 0xdeadf00ddeadf00dl; long result = x * 0x3800000000l; AssertJUnit.assertEquals("multiply", result, 0xb60c82d800000000l); }
@Test
public void test00856() { x = 0x000000007fffffffl; long result = x * 0xfffffffffffffff9l; AssertJUnit.assertEquals("multiply", result, 0xfffffffc80000007l); }
@Test
public void test00857() { x = 0x0000000080000000l; long result = x * 0xfffffffffffffff9l; AssertJUnit.assertEquals("multiply", result, 0xfffffffc80000000l); }
@Test
public void test00858() { x = 0x00000000ffffffffl; long result = x * 0xfffffffffffffff9l; AssertJUnit.assertEquals("multiply", result, 0xfffffff900000007l); }
@Test
public void test00859() { x = 0x000000017fffffffl; long result = x * 0xfffffffffffffff9l; AssertJUnit.assertEquals("multiply", result, 0xfffffff580000007l); }
@Test
public void test00860() { x = 0x0000000180000000l; long result = x * 0xfffffffffffffff9l; AssertJUnit.assertEquals("multiply", result, 0xfffffff580000000l); }
@Test
public void test00861() { x = 0x00000001ffffffffl; long result = x * 0xfffffffffffffff9l; AssertJUnit.assertEquals("multiply", result, 0xfffffff200000007l); }
@Test
public void test00862() { x = 0xffffffff7fffffffl; long result = x * 0xfffffffffffffff9l; AssertJUnit.assertEquals("multiply", result, 0x0000000380000007l); }
@Test
public void test00863() { x = 0xffffffff80000000l; long result = x * 0xfffffffffffffff9l; AssertJUnit.assertEquals("multiply", result, 0x0000000380000000l); }
@Test
public void test00864() { x = 0x00000001deadf00dl; long result = x * 0xfffffffffffffff9l; AssertJUnit.assertEquals("multiply", result, 0xfffffff2e93e6fa5l); }
@Test
public void test00865() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffffffffffff9l; AssertJUnit.assertEquals("multiply", result, 0x00000000e93e6fa5l); }
@Test
public void test00866() { x = 0x7fffffffffffffffl; long result = x * 0xfffffffffffffff9l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000007l); }
@Test
public void test00867() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffffffffffff9l; AssertJUnit.assertEquals("multiply", result, 0x8000000380000007l); }
@Test
public void test00868() { x = 0x7fffffff80000000l; long result = x * 0xfffffffffffffff9l; AssertJUnit.assertEquals("multiply", result, 0x8000000380000000l); }
@Test
public void test00869() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffffffffffff9l; AssertJUnit.assertEquals("multiply", result, 0x80000000e93e6fa5l); }
@Test
public void test00870() { x = 0x8000000000000000l; long result = x * 0xfffffffffffffff9l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00871() { x = 0xffffffffffffffffl; long result = x * 0xfffffffffffffff9l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000007l); }
@Test
public void test00872() { x = 0xfffffffffffffffel; long result = x * 0xfffffffffffffff9l; AssertJUnit.assertEquals("multiply", result, 0x000000000000000el); }
@Test
public void test00873() { x = 0xefffffffffffffffl; long result = x * 0xfffffffffffffff9l; AssertJUnit.assertEquals("multiply", result, 0x7000000000000007l); }
@Test
public void test00874() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffffffffffff9l; AssertJUnit.assertEquals("multiply", result, 0xe93e6f9ee93e6fa5l); }
@Test
public void test00875() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffffc8l; AssertJUnit.assertEquals("multiply", result, 0xffffffe400000038l); }
@Test
public void test00876() { x = 0x0000000080000000l; long result = x * 0xffffffffffffffc8l; AssertJUnit.assertEquals("multiply", result, 0xffffffe400000000l); }
@Test
public void test00877() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffffc8l; AssertJUnit.assertEquals("multiply", result, 0xffffffc800000038l); }
@Test
public void test00878() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffffc8l; AssertJUnit.assertEquals("multiply", result, 0xffffffac00000038l); }
@Test
public void test00879() { x = 0x0000000180000000l; long result = x * 0xffffffffffffffc8l; AssertJUnit.assertEquals("multiply", result, 0xffffffac00000000l); }
@Test
public void test00880() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffffc8l; AssertJUnit.assertEquals("multiply", result, 0xffffff9000000038l); }
@Test
public void test00881() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffffc8l; AssertJUnit.assertEquals("multiply", result, 0x0000001c00000038l); }
@Test
public void test00882() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffffc8l; AssertJUnit.assertEquals("multiply", result, 0x0000001c00000000l); }
@Test
public void test00883() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffffc8l; AssertJUnit.assertEquals("multiply", result, 0xffffff9749f37d28l); }
@Test
public void test00884() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffffc8l; AssertJUnit.assertEquals("multiply", result, 0x0000000749f37d28l); }
@Test
public void test00885() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffffc8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000038l); }
@Test
public void test00886() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffffc8l; AssertJUnit.assertEquals("multiply", result, 0x0000001c00000038l); }
@Test
public void test00887() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffffc8l; AssertJUnit.assertEquals("multiply", result, 0x0000001c00000000l); }
@Test
public void test00888() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffffc8l; AssertJUnit.assertEquals("multiply", result, 0x0000000749f37d28l); }
@Test
public void test00889() { x = 0x8000000000000000l; long result = x * 0xffffffffffffffc8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00890() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffffc8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000038l); }
@Test
public void test00891() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffffc8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000070l); }
@Test
public void test00892() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffffc8l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000038l); }
@Test
public void test00893() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffffc8l; AssertJUnit.assertEquals("multiply", result, 0x49f37cf749f37d28l); }
@Test
public void test00894() { x = 0x000000007fffffffl; long result = x * 0xfffffffffffff900l; AssertJUnit.assertEquals("multiply", result, 0xfffffc8000000700l); }
@Test
public void test00895() { x = 0x0000000080000000l; long result = x * 0xfffffffffffff900l; AssertJUnit.assertEquals("multiply", result, 0xfffffc8000000000l); }
@Test
public void test00896() { x = 0x00000000ffffffffl; long result = x * 0xfffffffffffff900l; AssertJUnit.assertEquals("multiply", result, 0xfffff90000000700l); }
@Test
public void test00897() { x = 0x000000017fffffffl; long result = x * 0xfffffffffffff900l; AssertJUnit.assertEquals("multiply", result, 0xfffff58000000700l); }
@Test
public void test00898() { x = 0x0000000180000000l; long result = x * 0xfffffffffffff900l; AssertJUnit.assertEquals("multiply", result, 0xfffff58000000000l); }
@Test
public void test00899() { x = 0x00000001ffffffffl; long result = x * 0xfffffffffffff900l; AssertJUnit.assertEquals("multiply", result, 0xfffff20000000700l); }
@Test
public void test00900() { x = 0xffffffff7fffffffl; long result = x * 0xfffffffffffff900l; AssertJUnit.assertEquals("multiply", result, 0x0000038000000700l); }
@Test
public void test00901() { x = 0xffffffff80000000l; long result = x * 0xfffffffffffff900l; AssertJUnit.assertEquals("multiply", result, 0x0000038000000000l); }
@Test
public void test00902() { x = 0x00000001deadf00dl; long result = x * 0xfffffffffffff900l; AssertJUnit.assertEquals("multiply", result, 0xfffff2e93e6fa500l); }
@Test
public void test00903() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffffffffff900l; AssertJUnit.assertEquals("multiply", result, 0x000000e93e6fa500l); }
@Test
public void test00904() { x = 0x7fffffffffffffffl; long result = x * 0xfffffffffffff900l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000700l); }
@Test
public void test00905() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffffffffff900l; AssertJUnit.assertEquals("multiply", result, 0x0000038000000700l); }
@Test
public void test00906() { x = 0x7fffffff80000000l; long result = x * 0xfffffffffffff900l; AssertJUnit.assertEquals("multiply", result, 0x0000038000000000l); }
@Test
public void test00907() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffffffffff900l; AssertJUnit.assertEquals("multiply", result, 0x000000e93e6fa500l); }
@Test
public void test00908() { x = 0x8000000000000000l; long result = x * 0xfffffffffffff900l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00909() { x = 0xffffffffffffffffl; long result = x * 0xfffffffffffff900l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000700l); }
@Test
public void test00910() { x = 0xfffffffffffffffel; long result = x * 0xfffffffffffff900l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000e00l); }
@Test
public void test00911() { x = 0xefffffffffffffffl; long result = x * 0xfffffffffffff900l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000700l); }
@Test
public void test00912() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffffffffff900l; AssertJUnit.assertEquals("multiply", result, 0x3e6f9ee93e6fa500l); }
@Test
public void test00913() { x = 0x000000007fffffffl; long result = x * 0xfffffff900000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000700000000l); }
@Test
public void test00914() { x = 0x0000000080000000l; long result = x * 0xfffffff900000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00915() { x = 0x00000000ffffffffl; long result = x * 0xfffffff900000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000700000000l); }
@Test
public void test00916() { x = 0x000000017fffffffl; long result = x * 0xfffffff900000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000700000000l); }
@Test
public void test00917() { x = 0x0000000180000000l; long result = x * 0xfffffff900000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00918() { x = 0x00000001ffffffffl; long result = x * 0xfffffff900000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000700000000l); }
@Test
public void test00919() { x = 0xffffffff7fffffffl; long result = x * 0xfffffff900000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000700000000l); }
@Test
public void test00920() { x = 0xffffffff80000000l; long result = x * 0xfffffff900000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00921() { x = 0x00000001deadf00dl; long result = x * 0xfffffff900000000l; AssertJUnit.assertEquals("multiply", result, 0xe93e6fa500000000l); }
@Test
public void test00922() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffff900000000l; AssertJUnit.assertEquals("multiply", result, 0xe93e6fa500000000l); }
@Test
public void test00923() { x = 0x7fffffffffffffffl; long result = x * 0xfffffff900000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000700000000l); }
@Test
public void test00924() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffff900000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000700000000l); }
@Test
public void test00925() { x = 0x7fffffff80000000l; long result = x * 0xfffffff900000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00926() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffff900000000l; AssertJUnit.assertEquals("multiply", result, 0xe93e6fa500000000l); }
@Test
public void test00927() { x = 0x8000000000000000l; long result = x * 0xfffffff900000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00928() { x = 0xffffffffffffffffl; long result = x * 0xfffffff900000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000700000000l); }
@Test
public void test00929() { x = 0xfffffffffffffffel; long result = x * 0xfffffff900000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000e00000000l); }
@Test
public void test00930() { x = 0xefffffffffffffffl; long result = x * 0xfffffff900000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000700000000l); }
@Test
public void test00931() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffff900000000l; AssertJUnit.assertEquals("multiply", result, 0xe93e6fa500000000l); }
@Test
public void test00932() { x = 0x000000007fffffffl; long result = x * 0xffffffc800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000003800000000l); }
@Test
public void test00933() { x = 0x0000000080000000l; long result = x * 0xffffffc800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00934() { x = 0x00000000ffffffffl; long result = x * 0xffffffc800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000003800000000l); }
@Test
public void test00935() { x = 0x000000017fffffffl; long result = x * 0xffffffc800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000003800000000l); }
@Test
public void test00936() { x = 0x0000000180000000l; long result = x * 0xffffffc800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00937() { x = 0x00000001ffffffffl; long result = x * 0xffffffc800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000003800000000l); }
@Test
public void test00938() { x = 0xffffffff7fffffffl; long result = x * 0xffffffc800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000003800000000l); }
@Test
public void test00939() { x = 0xffffffff80000000l; long result = x * 0xffffffc800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00940() { x = 0x00000001deadf00dl; long result = x * 0xffffffc800000000l; AssertJUnit.assertEquals("multiply", result, 0x49f37d2800000000l); }
@Test
public void test00941() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffc800000000l; AssertJUnit.assertEquals("multiply", result, 0x49f37d2800000000l); }
@Test
public void test00942() { x = 0x7fffffffffffffffl; long result = x * 0xffffffc800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000003800000000l); }
@Test
public void test00943() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffc800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000003800000000l); }
@Test
public void test00944() { x = 0x7fffffff80000000l; long result = x * 0xffffffc800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00945() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffc800000000l; AssertJUnit.assertEquals("multiply", result, 0x49f37d2800000000l); }
@Test
public void test00946() { x = 0x8000000000000000l; long result = x * 0xffffffc800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00947() { x = 0xffffffffffffffffl; long result = x * 0xffffffc800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000003800000000l); }
@Test
public void test00948() { x = 0xfffffffffffffffel; long result = x * 0xffffffc800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000007000000000l); }
@Test
public void test00949() { x = 0xefffffffffffffffl; long result = x * 0xffffffc800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000003800000000l); }
@Test
public void test00950() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffc800000000l; AssertJUnit.assertEquals("multiply", result, 0x49f37d2800000000l); }
@Test
public void test00951() { x = 0x000000007fffffffl; long result = x * 0x9l; AssertJUnit.assertEquals("multiply", result, 0x000000047ffffff7l); }
@Test
public void test00952() { x = 0x0000000080000000l; long result = x * 0x9l; AssertJUnit.assertEquals("multiply", result, 0x0000000480000000l); }
@Test
public void test00953() { x = 0x00000000ffffffffl; long result = x * 0x9l; AssertJUnit.assertEquals("multiply", result, 0x00000008fffffff7l); }
@Test
public void test00954() { x = 0x000000017fffffffl; long result = x * 0x9l; AssertJUnit.assertEquals("multiply", result, 0x0000000d7ffffff7l); }
@Test
public void test00955() { x = 0x0000000180000000l; long result = x * 0x9l; AssertJUnit.assertEquals("multiply", result, 0x0000000d80000000l); }
@Test
public void test00956() { x = 0x00000001ffffffffl; long result = x * 0x9l; AssertJUnit.assertEquals("multiply", result, 0x00000011fffffff7l); }
@Test
public void test00957() { x = 0xffffffff7fffffffl; long result = x * 0x9l; AssertJUnit.assertEquals("multiply", result, 0xfffffffb7ffffff7l); }
@Test
public void test00958() { x = 0xffffffff80000000l; long result = x * 0x9l; AssertJUnit.assertEquals("multiply", result, 0xfffffffb80000000l); }
@Test
public void test00959() { x = 0x00000001deadf00dl; long result = x * 0x9l; AssertJUnit.assertEquals("multiply", result, 0x00000010d41d7075l); }
@Test
public void test00960() { x = 0xffffffffdeadf00dl; long result = x * 0x9l; AssertJUnit.assertEquals("multiply", result, 0xfffffffed41d7075l); }
@Test
public void test00961() { x = 0x7fffffffffffffffl; long result = x * 0x9l; AssertJUnit.assertEquals("multiply", result, 0x7ffffffffffffff7l); }
@Test
public void test00962() { x = 0x7fffffff7fffffffl; long result = x * 0x9l; AssertJUnit.assertEquals("multiply", result, 0x7ffffffb7ffffff7l); }
@Test
public void test00963() { x = 0x7fffffff80000000l; long result = x * 0x9l; AssertJUnit.assertEquals("multiply", result, 0x7ffffffb80000000l); }
@Test
public void test00964() { x = 0x7fffffffdeadf00dl; long result = x * 0x9l; AssertJUnit.assertEquals("multiply", result, 0x7ffffffed41d7075l); }
@Test
public void test00965() { x = 0x8000000000000000l; long result = x * 0x9l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test00966() { x = 0xffffffffffffffffl; long result = x * 0x9l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffff7l); }
@Test
public void test00967() { x = 0xfffffffffffffffel; long result = x * 0x9l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffeel); }
@Test
public void test00968() { x = 0xefffffffffffffffl; long result = x * 0x9l; AssertJUnit.assertEquals("multiply", result, 0x6ffffffffffffff7l); }
@Test
public void test00969() { x = 0xdeadf00ddeadf00dl; long result = x * 0x9l; AssertJUnit.assertEquals("multiply", result, 0xd41d707cd41d7075l); }
@Test
public void test00970() { x = 0x000000007fffffffl; long result = x * 0x48l; AssertJUnit.assertEquals("multiply", result, 0x00000023ffffffb8l); }
@Test
public void test00971() { x = 0x0000000080000000l; long result = x * 0x48l; AssertJUnit.assertEquals("multiply", result, 0x0000002400000000l); }
@Test
public void test00972() { x = 0x00000000ffffffffl; long result = x * 0x48l; AssertJUnit.assertEquals("multiply", result, 0x00000047ffffffb8l); }
@Test
public void test00973() { x = 0x000000017fffffffl; long result = x * 0x48l; AssertJUnit.assertEquals("multiply", result, 0x0000006bffffffb8l); }
@Test
public void test00974() { x = 0x0000000180000000l; long result = x * 0x48l; AssertJUnit.assertEquals("multiply", result, 0x0000006c00000000l); }
@Test
public void test00975() { x = 0x00000001ffffffffl; long result = x * 0x48l; AssertJUnit.assertEquals("multiply", result, 0x0000008fffffffb8l); }
@Test
public void test00976() { x = 0xffffffff7fffffffl; long result = x * 0x48l; AssertJUnit.assertEquals("multiply", result, 0xffffffdbffffffb8l); }
@Test
public void test00977() { x = 0xffffffff80000000l; long result = x * 0x48l; AssertJUnit.assertEquals("multiply", result, 0xffffffdc00000000l); }
@Test
public void test00978() { x = 0x00000001deadf00dl; long result = x * 0x48l; AssertJUnit.assertEquals("multiply", result, 0x00000086a0eb83a8l); }
@Test
public void test00979() { x = 0xffffffffdeadf00dl; long result = x * 0x48l; AssertJUnit.assertEquals("multiply", result, 0xfffffff6a0eb83a8l); }
@Test
public void test00980() { x = 0x7fffffffffffffffl; long result = x * 0x48l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffb8l); }
@Test
public void test00981() { x = 0x7fffffff7fffffffl; long result = x * 0x48l; AssertJUnit.assertEquals("multiply", result, 0xffffffdbffffffb8l); }
@Test
public void test00982() { x = 0x7fffffff80000000l; long result = x * 0x48l; AssertJUnit.assertEquals("multiply", result, 0xffffffdc00000000l); }
@Test
public void test00983() { x = 0x7fffffffdeadf00dl; long result = x * 0x48l; AssertJUnit.assertEquals("multiply", result, 0xfffffff6a0eb83a8l); }
@Test
public void test00984() { x = 0x8000000000000000l; long result = x * 0x48l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test00985() { x = 0xffffffffffffffffl; long result = x * 0x48l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffb8l); }
@Test
public void test00986() { x = 0xfffffffffffffffel; long result = x * 0x48l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff70l); }
@Test
public void test00987() { x = 0xefffffffffffffffl; long result = x * 0x48l; AssertJUnit.assertEquals("multiply", result, 0x7fffffffffffffb8l); }
@Test
public void test00988() { x = 0xdeadf00ddeadf00dl; long result = x * 0x48l; AssertJUnit.assertEquals("multiply", result, 0xa0eb83e6a0eb83a8l); }
@Test
public void test00989() { x = 0x000000007fffffffl; long result = x * 0x900l; AssertJUnit.assertEquals("multiply", result, 0x0000047ffffff700l); }
@Test
public void test00990() { x = 0x0000000080000000l; long result = x * 0x900l; AssertJUnit.assertEquals("multiply", result, 0x0000048000000000l); }
@Test
public void test00991() { x = 0x00000000ffffffffl; long result = x * 0x900l; AssertJUnit.assertEquals("multiply", result, 0x000008fffffff700l); }
@Test
public void test00992() { x = 0x000000017fffffffl; long result = x * 0x900l; AssertJUnit.assertEquals("multiply", result, 0x00000d7ffffff700l); }
@Test
public void test00993() { x = 0x0000000180000000l; long result = x * 0x900l; AssertJUnit.assertEquals("multiply", result, 0x00000d8000000000l); }
@Test
public void test00994() { x = 0x00000001ffffffffl; long result = x * 0x900l; AssertJUnit.assertEquals("multiply", result, 0x000011fffffff700l); }
@Test
public void test00995() { x = 0xffffffff7fffffffl; long result = x * 0x900l; AssertJUnit.assertEquals("multiply", result, 0xfffffb7ffffff700l); }
@Test
public void test00996() { x = 0xffffffff80000000l; long result = x * 0x900l; AssertJUnit.assertEquals("multiply", result, 0xfffffb8000000000l); }
@Test
public void test00997() { x = 0x00000001deadf00dl; long result = x * 0x900l; AssertJUnit.assertEquals("multiply", result, 0x000010d41d707500l); }
@Test
public void test00998() { x = 0xffffffffdeadf00dl; long result = x * 0x900l; AssertJUnit.assertEquals("multiply", result, 0xfffffed41d707500l); }
@Test
public void test00999() { x = 0x7fffffffffffffffl; long result = x * 0x900l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffff700l); }
@Test
public void test01000() { x = 0x7fffffff7fffffffl; long result = x * 0x900l; AssertJUnit.assertEquals("multiply", result, 0xfffffb7ffffff700l); }
@Test
public void test01001() { x = 0x7fffffff80000000l; long result = x * 0x900l; AssertJUnit.assertEquals("multiply", result, 0xfffffb8000000000l); }
@Test
public void test01002() { x = 0x7fffffffdeadf00dl; long result = x * 0x900l; AssertJUnit.assertEquals("multiply", result, 0xfffffed41d707500l); }
@Test
public void test01003() { x = 0x8000000000000000l; long result = x * 0x900l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01004() { x = 0xffffffffffffffffl; long result = x * 0x900l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffff700l); }
@Test
public void test01005() { x = 0xfffffffffffffffel; long result = x * 0x900l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffee00l); }
@Test
public void test01006() { x = 0xefffffffffffffffl; long result = x * 0x900l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffff700l); }
@Test
public void test01007() { x = 0xdeadf00ddeadf00dl; long result = x * 0x900l; AssertJUnit.assertEquals("multiply", result, 0x1d707cd41d707500l); }
@Test
public void test01008() { x = 0x000000007fffffffl; long result = x * 0x900000000l; AssertJUnit.assertEquals("multiply", result, 0x7ffffff700000000l); }
@Test
public void test01009() { x = 0x0000000080000000l; long result = x * 0x900000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test01010() { x = 0x00000000ffffffffl; long result = x * 0x900000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff700000000l); }
@Test
public void test01011() { x = 0x000000017fffffffl; long result = x * 0x900000000l; AssertJUnit.assertEquals("multiply", result, 0x7ffffff700000000l); }
@Test
public void test01012() { x = 0x0000000180000000l; long result = x * 0x900000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test01013() { x = 0x00000001ffffffffl; long result = x * 0x900000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff700000000l); }
@Test
public void test01014() { x = 0xffffffff7fffffffl; long result = x * 0x900000000l; AssertJUnit.assertEquals("multiply", result, 0x7ffffff700000000l); }
@Test
public void test01015() { x = 0xffffffff80000000l; long result = x * 0x900000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test01016() { x = 0x00000001deadf00dl; long result = x * 0x900000000l; AssertJUnit.assertEquals("multiply", result, 0xd41d707500000000l); }
@Test
public void test01017() { x = 0xffffffffdeadf00dl; long result = x * 0x900000000l; AssertJUnit.assertEquals("multiply", result, 0xd41d707500000000l); }
@Test
public void test01018() { x = 0x7fffffffffffffffl; long result = x * 0x900000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff700000000l); }
@Test
public void test01019() { x = 0x7fffffff7fffffffl; long result = x * 0x900000000l; AssertJUnit.assertEquals("multiply", result, 0x7ffffff700000000l); }
@Test
public void test01020() { x = 0x7fffffff80000000l; long result = x * 0x900000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test01021() { x = 0x7fffffffdeadf00dl; long result = x * 0x900000000l; AssertJUnit.assertEquals("multiply", result, 0xd41d707500000000l); }
@Test
public void test01022() { x = 0x8000000000000000l; long result = x * 0x900000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01023() { x = 0xffffffffffffffffl; long result = x * 0x900000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff700000000l); }
@Test
public void test01024() { x = 0xfffffffffffffffel; long result = x * 0x900000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffee00000000l); }
@Test
public void test01025() { x = 0xefffffffffffffffl; long result = x * 0x900000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff700000000l); }
@Test
public void test01026() { x = 0xdeadf00ddeadf00dl; long result = x * 0x900000000l; AssertJUnit.assertEquals("multiply", result, 0xd41d707500000000l); }
@Test
public void test01027() { x = 0x000000007fffffffl; long result = x * 0x4800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffb800000000l); }
@Test
public void test01028() { x = 0x0000000080000000l; long result = x * 0x4800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01029() { x = 0x00000000ffffffffl; long result = x * 0x4800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffb800000000l); }
@Test
public void test01030() { x = 0x000000017fffffffl; long result = x * 0x4800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffb800000000l); }
@Test
public void test01031() { x = 0x0000000180000000l; long result = x * 0x4800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01032() { x = 0x00000001ffffffffl; long result = x * 0x4800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffb800000000l); }
@Test
public void test01033() { x = 0xffffffff7fffffffl; long result = x * 0x4800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffb800000000l); }
@Test
public void test01034() { x = 0xffffffff80000000l; long result = x * 0x4800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01035() { x = 0x00000001deadf00dl; long result = x * 0x4800000000l; AssertJUnit.assertEquals("multiply", result, 0xa0eb83a800000000l); }
@Test
public void test01036() { x = 0xffffffffdeadf00dl; long result = x * 0x4800000000l; AssertJUnit.assertEquals("multiply", result, 0xa0eb83a800000000l); }
@Test
public void test01037() { x = 0x7fffffffffffffffl; long result = x * 0x4800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffb800000000l); }
@Test
public void test01038() { x = 0x7fffffff7fffffffl; long result = x * 0x4800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffb800000000l); }
@Test
public void test01039() { x = 0x7fffffff80000000l; long result = x * 0x4800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01040() { x = 0x7fffffffdeadf00dl; long result = x * 0x4800000000l; AssertJUnit.assertEquals("multiply", result, 0xa0eb83a800000000l); }
@Test
public void test01041() { x = 0x8000000000000000l; long result = x * 0x4800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01042() { x = 0xffffffffffffffffl; long result = x * 0x4800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffb800000000l); }
@Test
public void test01043() { x = 0xfffffffffffffffel; long result = x * 0x4800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff7000000000l); }
@Test
public void test01044() { x = 0xefffffffffffffffl; long result = x * 0x4800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffb800000000l); }
@Test
public void test01045() { x = 0xdeadf00ddeadf00dl; long result = x * 0x4800000000l; AssertJUnit.assertEquals("multiply", result, 0xa0eb83a800000000l); }
@Test
public void test01046() { x = 0x000000007fffffffl; long result = x * 0xfffffffffffffff7l; AssertJUnit.assertEquals("multiply", result, 0xfffffffb80000009l); }
@Test
public void test01047() { x = 0x0000000080000000l; long result = x * 0xfffffffffffffff7l; AssertJUnit.assertEquals("multiply", result, 0xfffffffb80000000l); }
@Test
public void test01048() { x = 0x00000000ffffffffl; long result = x * 0xfffffffffffffff7l; AssertJUnit.assertEquals("multiply", result, 0xfffffff700000009l); }
@Test
public void test01049() { x = 0x000000017fffffffl; long result = x * 0xfffffffffffffff7l; AssertJUnit.assertEquals("multiply", result, 0xfffffff280000009l); }
@Test
public void test01050() { x = 0x0000000180000000l; long result = x * 0xfffffffffffffff7l; AssertJUnit.assertEquals("multiply", result, 0xfffffff280000000l); }
@Test
public void test01051() { x = 0x00000001ffffffffl; long result = x * 0xfffffffffffffff7l; AssertJUnit.assertEquals("multiply", result, 0xffffffee00000009l); }
@Test
public void test01052() { x = 0xffffffff7fffffffl; long result = x * 0xfffffffffffffff7l; AssertJUnit.assertEquals("multiply", result, 0x0000000480000009l); }
@Test
public void test01053() { x = 0xffffffff80000000l; long result = x * 0xfffffffffffffff7l; AssertJUnit.assertEquals("multiply", result, 0x0000000480000000l); }
@Test
public void test01054() { x = 0x00000001deadf00dl; long result = x * 0xfffffffffffffff7l; AssertJUnit.assertEquals("multiply", result, 0xffffffef2be28f8bl); }
@Test
public void test01055() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffffffffffff7l; AssertJUnit.assertEquals("multiply", result, 0x000000012be28f8bl); }
@Test
public void test01056() { x = 0x7fffffffffffffffl; long result = x * 0xfffffffffffffff7l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000009l); }
@Test
public void test01057() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffffffffffff7l; AssertJUnit.assertEquals("multiply", result, 0x8000000480000009l); }
@Test
public void test01058() { x = 0x7fffffff80000000l; long result = x * 0xfffffffffffffff7l; AssertJUnit.assertEquals("multiply", result, 0x8000000480000000l); }
@Test
public void test01059() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffffffffffff7l; AssertJUnit.assertEquals("multiply", result, 0x800000012be28f8bl); }
@Test
public void test01060() { x = 0x8000000000000000l; long result = x * 0xfffffffffffffff7l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test01061() { x = 0xffffffffffffffffl; long result = x * 0xfffffffffffffff7l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000009l); }
@Test
public void test01062() { x = 0xfffffffffffffffel; long result = x * 0xfffffffffffffff7l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000012l); }
@Test
public void test01063() { x = 0xefffffffffffffffl; long result = x * 0xfffffffffffffff7l; AssertJUnit.assertEquals("multiply", result, 0x9000000000000009l); }
@Test
public void test01064() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffffffffffff7l; AssertJUnit.assertEquals("multiply", result, 0x2be28f832be28f8bl); }
@Test
public void test01065() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffffb8l; AssertJUnit.assertEquals("multiply", result, 0xffffffdc00000048l); }
@Test
public void test01066() { x = 0x0000000080000000l; long result = x * 0xffffffffffffffb8l; AssertJUnit.assertEquals("multiply", result, 0xffffffdc00000000l); }
@Test
public void test01067() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffffb8l; AssertJUnit.assertEquals("multiply", result, 0xffffffb800000048l); }
@Test
public void test01068() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffffb8l; AssertJUnit.assertEquals("multiply", result, 0xffffff9400000048l); }
@Test
public void test01069() { x = 0x0000000180000000l; long result = x * 0xffffffffffffffb8l; AssertJUnit.assertEquals("multiply", result, 0xffffff9400000000l); }
@Test
public void test01070() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffffb8l; AssertJUnit.assertEquals("multiply", result, 0xffffff7000000048l); }
@Test
public void test01071() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffffb8l; AssertJUnit.assertEquals("multiply", result, 0x0000002400000048l); }
@Test
public void test01072() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffffb8l; AssertJUnit.assertEquals("multiply", result, 0x0000002400000000l); }
@Test
public void test01073() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffffb8l; AssertJUnit.assertEquals("multiply", result, 0xffffff795f147c58l); }
@Test
public void test01074() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffffb8l; AssertJUnit.assertEquals("multiply", result, 0x000000095f147c58l); }
@Test
public void test01075() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffffb8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000048l); }
@Test
public void test01076() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffffb8l; AssertJUnit.assertEquals("multiply", result, 0x0000002400000048l); }
@Test
public void test01077() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffffb8l; AssertJUnit.assertEquals("multiply", result, 0x0000002400000000l); }
@Test
public void test01078() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffffb8l; AssertJUnit.assertEquals("multiply", result, 0x000000095f147c58l); }
@Test
public void test01079() { x = 0x8000000000000000l; long result = x * 0xffffffffffffffb8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01080() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffffb8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000048l); }
@Test
public void test01081() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffffb8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000090l); }
@Test
public void test01082() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffffb8l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000048l); }
@Test
public void test01083() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffffb8l; AssertJUnit.assertEquals("multiply", result, 0x5f147c195f147c58l); }
@Test
public void test01084() { x = 0x000000007fffffffl; long result = x * 0xfffffffffffff700l; AssertJUnit.assertEquals("multiply", result, 0xfffffb8000000900l); }
@Test
public void test01085() { x = 0x0000000080000000l; long result = x * 0xfffffffffffff700l; AssertJUnit.assertEquals("multiply", result, 0xfffffb8000000000l); }
@Test
public void test01086() { x = 0x00000000ffffffffl; long result = x * 0xfffffffffffff700l; AssertJUnit.assertEquals("multiply", result, 0xfffff70000000900l); }
@Test
public void test01087() { x = 0x000000017fffffffl; long result = x * 0xfffffffffffff700l; AssertJUnit.assertEquals("multiply", result, 0xfffff28000000900l); }
@Test
public void test01088() { x = 0x0000000180000000l; long result = x * 0xfffffffffffff700l; AssertJUnit.assertEquals("multiply", result, 0xfffff28000000000l); }
@Test
public void test01089() { x = 0x00000001ffffffffl; long result = x * 0xfffffffffffff700l; AssertJUnit.assertEquals("multiply", result, 0xffffee0000000900l); }
@Test
public void test01090() { x = 0xffffffff7fffffffl; long result = x * 0xfffffffffffff700l; AssertJUnit.assertEquals("multiply", result, 0x0000048000000900l); }
@Test
public void test01091() { x = 0xffffffff80000000l; long result = x * 0xfffffffffffff700l; AssertJUnit.assertEquals("multiply", result, 0x0000048000000000l); }
@Test
public void test01092() { x = 0x00000001deadf00dl; long result = x * 0xfffffffffffff700l; AssertJUnit.assertEquals("multiply", result, 0xffffef2be28f8b00l); }
@Test
public void test01093() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffffffffff700l; AssertJUnit.assertEquals("multiply", result, 0x0000012be28f8b00l); }
@Test
public void test01094() { x = 0x7fffffffffffffffl; long result = x * 0xfffffffffffff700l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000900l); }
@Test
public void test01095() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffffffffff700l; AssertJUnit.assertEquals("multiply", result, 0x0000048000000900l); }
@Test
public void test01096() { x = 0x7fffffff80000000l; long result = x * 0xfffffffffffff700l; AssertJUnit.assertEquals("multiply", result, 0x0000048000000000l); }
@Test
public void test01097() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffffffffff700l; AssertJUnit.assertEquals("multiply", result, 0x0000012be28f8b00l); }
@Test
public void test01098() { x = 0x8000000000000000l; long result = x * 0xfffffffffffff700l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01099() { x = 0xffffffffffffffffl; long result = x * 0xfffffffffffff700l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000900l); }
@Test
public void test01100() { x = 0xfffffffffffffffel; long result = x * 0xfffffffffffff700l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001200l); }
@Test
public void test01101() { x = 0xefffffffffffffffl; long result = x * 0xfffffffffffff700l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000900l); }
@Test
public void test01102() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffffffffff700l; AssertJUnit.assertEquals("multiply", result, 0xe28f832be28f8b00l); }
@Test
public void test01103() { x = 0x000000007fffffffl; long result = x * 0xfffffff700000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000900000000l); }
@Test
public void test01104() { x = 0x0000000080000000l; long result = x * 0xfffffff700000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test01105() { x = 0x00000000ffffffffl; long result = x * 0xfffffff700000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000900000000l); }
@Test
public void test01106() { x = 0x000000017fffffffl; long result = x * 0xfffffff700000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000900000000l); }
@Test
public void test01107() { x = 0x0000000180000000l; long result = x * 0xfffffff700000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test01108() { x = 0x00000001ffffffffl; long result = x * 0xfffffff700000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000900000000l); }
@Test
public void test01109() { x = 0xffffffff7fffffffl; long result = x * 0xfffffff700000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000900000000l); }
@Test
public void test01110() { x = 0xffffffff80000000l; long result = x * 0xfffffff700000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test01111() { x = 0x00000001deadf00dl; long result = x * 0xfffffff700000000l; AssertJUnit.assertEquals("multiply", result, 0x2be28f8b00000000l); }
@Test
public void test01112() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffff700000000l; AssertJUnit.assertEquals("multiply", result, 0x2be28f8b00000000l); }
@Test
public void test01113() { x = 0x7fffffffffffffffl; long result = x * 0xfffffff700000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000900000000l); }
@Test
public void test01114() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffff700000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000900000000l); }
@Test
public void test01115() { x = 0x7fffffff80000000l; long result = x * 0xfffffff700000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test01116() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffff700000000l; AssertJUnit.assertEquals("multiply", result, 0x2be28f8b00000000l); }
@Test
public void test01117() { x = 0x8000000000000000l; long result = x * 0xfffffff700000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01118() { x = 0xffffffffffffffffl; long result = x * 0xfffffff700000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000900000000l); }
@Test
public void test01119() { x = 0xfffffffffffffffel; long result = x * 0xfffffff700000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001200000000l); }
@Test
public void test01120() { x = 0xefffffffffffffffl; long result = x * 0xfffffff700000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000900000000l); }
@Test
public void test01121() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffff700000000l; AssertJUnit.assertEquals("multiply", result, 0x2be28f8b00000000l); }
@Test
public void test01122() { x = 0x000000007fffffffl; long result = x * 0xffffffb800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000004800000000l); }
@Test
public void test01123() { x = 0x0000000080000000l; long result = x * 0xffffffb800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01124() { x = 0x00000000ffffffffl; long result = x * 0xffffffb800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000004800000000l); }
@Test
public void test01125() { x = 0x000000017fffffffl; long result = x * 0xffffffb800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000004800000000l); }
@Test
public void test01126() { x = 0x0000000180000000l; long result = x * 0xffffffb800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01127() { x = 0x00000001ffffffffl; long result = x * 0xffffffb800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000004800000000l); }
@Test
public void test01128() { x = 0xffffffff7fffffffl; long result = x * 0xffffffb800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000004800000000l); }
@Test
public void test01129() { x = 0xffffffff80000000l; long result = x * 0xffffffb800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01130() { x = 0x00000001deadf00dl; long result = x * 0xffffffb800000000l; AssertJUnit.assertEquals("multiply", result, 0x5f147c5800000000l); }
@Test
public void test01131() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffb800000000l; AssertJUnit.assertEquals("multiply", result, 0x5f147c5800000000l); }
@Test
public void test01132() { x = 0x7fffffffffffffffl; long result = x * 0xffffffb800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000004800000000l); }
@Test
public void test01133() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffb800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000004800000000l); }
@Test
public void test01134() { x = 0x7fffffff80000000l; long result = x * 0xffffffb800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01135() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffb800000000l; AssertJUnit.assertEquals("multiply", result, 0x5f147c5800000000l); }
@Test
public void test01136() { x = 0x8000000000000000l; long result = x * 0xffffffb800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01137() { x = 0xffffffffffffffffl; long result = x * 0xffffffb800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000004800000000l); }
@Test
public void test01138() { x = 0xfffffffffffffffel; long result = x * 0xffffffb800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000009000000000l); }
@Test
public void test01139() { x = 0xefffffffffffffffl; long result = x * 0xffffffb800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000004800000000l); }
@Test
public void test01140() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffb800000000l; AssertJUnit.assertEquals("multiply", result, 0x5f147c5800000000l); }
@Test
public void test01141() { x = 0x000000007fffffffl; long result = x * 0xal; AssertJUnit.assertEquals("multiply", result, 0x00000004fffffff6l); }
@Test
public void test01142() { x = 0x0000000080000000l; long result = x * 0xal; AssertJUnit.assertEquals("multiply", result, 0x0000000500000000l); }
@Test
public void test01143() { x = 0x00000000ffffffffl; long result = x * 0xal; AssertJUnit.assertEquals("multiply", result, 0x00000009fffffff6l); }
@Test
public void test01144() { x = 0x000000017fffffffl; long result = x * 0xal; AssertJUnit.assertEquals("multiply", result, 0x0000000efffffff6l); }
@Test
public void test01145() { x = 0x0000000180000000l; long result = x * 0xal; AssertJUnit.assertEquals("multiply", result, 0x0000000f00000000l); }
@Test
public void test01146() { x = 0x00000001ffffffffl; long result = x * 0xal; AssertJUnit.assertEquals("multiply", result, 0x00000013fffffff6l); }
@Test
public void test01147() { x = 0xffffffff7fffffffl; long result = x * 0xal; AssertJUnit.assertEquals("multiply", result, 0xfffffffafffffff6l); }
@Test
public void test01148() { x = 0xffffffff80000000l; long result = x * 0xal; AssertJUnit.assertEquals("multiply", result, 0xfffffffb00000000l); }
@Test
public void test01149() { x = 0x00000001deadf00dl; long result = x * 0xal; AssertJUnit.assertEquals("multiply", result, 0x00000012b2cb6082l); }
@Test
public void test01150() { x = 0xffffffffdeadf00dl; long result = x * 0xal; AssertJUnit.assertEquals("multiply", result, 0xfffffffeb2cb6082l); }
@Test
public void test01151() { x = 0x7fffffffffffffffl; long result = x * 0xal; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffff6l); }
@Test
public void test01152() { x = 0x7fffffff7fffffffl; long result = x * 0xal; AssertJUnit.assertEquals("multiply", result, 0xfffffffafffffff6l); }
@Test
public void test01153() { x = 0x7fffffff80000000l; long result = x * 0xal; AssertJUnit.assertEquals("multiply", result, 0xfffffffb00000000l); }
@Test
public void test01154() { x = 0x7fffffffdeadf00dl; long result = x * 0xal; AssertJUnit.assertEquals("multiply", result, 0xfffffffeb2cb6082l); }
@Test
public void test01155() { x = 0x8000000000000000l; long result = x * 0xal; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01156() { x = 0xffffffffffffffffl; long result = x * 0xal; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffff6l); }
@Test
public void test01157() { x = 0xfffffffffffffffel; long result = x * 0xal; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffecl); }
@Test
public void test01158() { x = 0xefffffffffffffffl; long result = x * 0xal; AssertJUnit.assertEquals("multiply", result, 0x5ffffffffffffff6l); }
@Test
public void test01159() { x = 0xdeadf00ddeadf00dl; long result = x * 0xal; AssertJUnit.assertEquals("multiply", result, 0xb2cb608ab2cb6082l); }
@Test
public void test01160() { x = 0x000000007fffffffl; long result = x * 0x50l; AssertJUnit.assertEquals("multiply", result, 0x00000027ffffffb0l); }
@Test
public void test01161() { x = 0x0000000080000000l; long result = x * 0x50l; AssertJUnit.assertEquals("multiply", result, 0x0000002800000000l); }
@Test
public void test01162() { x = 0x00000000ffffffffl; long result = x * 0x50l; AssertJUnit.assertEquals("multiply", result, 0x0000004fffffffb0l); }
@Test
public void test01163() { x = 0x000000017fffffffl; long result = x * 0x50l; AssertJUnit.assertEquals("multiply", result, 0x00000077ffffffb0l); }
@Test
public void test01164() { x = 0x0000000180000000l; long result = x * 0x50l; AssertJUnit.assertEquals("multiply", result, 0x0000007800000000l); }
@Test
public void test01165() { x = 0x00000001ffffffffl; long result = x * 0x50l; AssertJUnit.assertEquals("multiply", result, 0x0000009fffffffb0l); }
@Test
public void test01166() { x = 0xffffffff7fffffffl; long result = x * 0x50l; AssertJUnit.assertEquals("multiply", result, 0xffffffd7ffffffb0l); }
@Test
public void test01167() { x = 0xffffffff80000000l; long result = x * 0x50l; AssertJUnit.assertEquals("multiply", result, 0xffffffd800000000l); }
@Test
public void test01168() { x = 0x00000001deadf00dl; long result = x * 0x50l; AssertJUnit.assertEquals("multiply", result, 0x00000095965b0410l); }
@Test
public void test01169() { x = 0xffffffffdeadf00dl; long result = x * 0x50l; AssertJUnit.assertEquals("multiply", result, 0xfffffff5965b0410l); }
@Test
public void test01170() { x = 0x7fffffffffffffffl; long result = x * 0x50l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffb0l); }
@Test
public void test01171() { x = 0x7fffffff7fffffffl; long result = x * 0x50l; AssertJUnit.assertEquals("multiply", result, 0xffffffd7ffffffb0l); }
@Test
public void test01172() { x = 0x7fffffff80000000l; long result = x * 0x50l; AssertJUnit.assertEquals("multiply", result, 0xffffffd800000000l); }
@Test
public void test01173() { x = 0x7fffffffdeadf00dl; long result = x * 0x50l; AssertJUnit.assertEquals("multiply", result, 0xfffffff5965b0410l); }
@Test
public void test01174() { x = 0x8000000000000000l; long result = x * 0x50l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01175() { x = 0xffffffffffffffffl; long result = x * 0x50l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffb0l); }
@Test
public void test01176() { x = 0xfffffffffffffffel; long result = x * 0x50l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff60l); }
@Test
public void test01177() { x = 0xefffffffffffffffl; long result = x * 0x50l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffb0l); }
@Test
public void test01178() { x = 0xdeadf00ddeadf00dl; long result = x * 0x50l; AssertJUnit.assertEquals("multiply", result, 0x965b0455965b0410l); }
@Test
public void test01179() { x = 0x000000007fffffffl; long result = x * 0xa00l; AssertJUnit.assertEquals("multiply", result, 0x000004fffffff600l); }
@Test
public void test01180() { x = 0x0000000080000000l; long result = x * 0xa00l; AssertJUnit.assertEquals("multiply", result, 0x0000050000000000l); }
@Test
public void test01181() { x = 0x00000000ffffffffl; long result = x * 0xa00l; AssertJUnit.assertEquals("multiply", result, 0x000009fffffff600l); }
@Test
public void test01182() { x = 0x000000017fffffffl; long result = x * 0xa00l; AssertJUnit.assertEquals("multiply", result, 0x00000efffffff600l); }
@Test
public void test01183() { x = 0x0000000180000000l; long result = x * 0xa00l; AssertJUnit.assertEquals("multiply", result, 0x00000f0000000000l); }
@Test
public void test01184() { x = 0x00000001ffffffffl; long result = x * 0xa00l; AssertJUnit.assertEquals("multiply", result, 0x000013fffffff600l); }
@Test
public void test01185() { x = 0xffffffff7fffffffl; long result = x * 0xa00l; AssertJUnit.assertEquals("multiply", result, 0xfffffafffffff600l); }
@Test
public void test01186() { x = 0xffffffff80000000l; long result = x * 0xa00l; AssertJUnit.assertEquals("multiply", result, 0xfffffb0000000000l); }
@Test
public void test01187() { x = 0x00000001deadf00dl; long result = x * 0xa00l; AssertJUnit.assertEquals("multiply", result, 0x000012b2cb608200l); }
@Test
public void test01188() { x = 0xffffffffdeadf00dl; long result = x * 0xa00l; AssertJUnit.assertEquals("multiply", result, 0xfffffeb2cb608200l); }
@Test
public void test01189() { x = 0x7fffffffffffffffl; long result = x * 0xa00l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffff600l); }
@Test
public void test01190() { x = 0x7fffffff7fffffffl; long result = x * 0xa00l; AssertJUnit.assertEquals("multiply", result, 0xfffffafffffff600l); }
@Test
public void test01191() { x = 0x7fffffff80000000l; long result = x * 0xa00l; AssertJUnit.assertEquals("multiply", result, 0xfffffb0000000000l); }
@Test
public void test01192() { x = 0x7fffffffdeadf00dl; long result = x * 0xa00l; AssertJUnit.assertEquals("multiply", result, 0xfffffeb2cb608200l); }
@Test
public void test01193() { x = 0x8000000000000000l; long result = x * 0xa00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01194() { x = 0xffffffffffffffffl; long result = x * 0xa00l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffff600l); }
@Test
public void test01195() { x = 0xfffffffffffffffel; long result = x * 0xa00l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffec00l); }
@Test
public void test01196() { x = 0xefffffffffffffffl; long result = x * 0xa00l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffff600l); }
@Test
public void test01197() { x = 0xdeadf00ddeadf00dl; long result = x * 0xa00l; AssertJUnit.assertEquals("multiply", result, 0xcb608ab2cb608200l); }
@Test
public void test01198() { x = 0x000000007fffffffl; long result = x * 0xa00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff600000000l); }
@Test
public void test01199() { x = 0x0000000080000000l; long result = x * 0xa00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01200() { x = 0x00000000ffffffffl; long result = x * 0xa00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff600000000l); }
@Test
public void test01201() { x = 0x000000017fffffffl; long result = x * 0xa00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff600000000l); }
@Test
public void test01202() { x = 0x0000000180000000l; long result = x * 0xa00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01203() { x = 0x00000001ffffffffl; long result = x * 0xa00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff600000000l); }
@Test
public void test01204() { x = 0xffffffff7fffffffl; long result = x * 0xa00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff600000000l); }
@Test
public void test01205() { x = 0xffffffff80000000l; long result = x * 0xa00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01206() { x = 0x00000001deadf00dl; long result = x * 0xa00000000l; AssertJUnit.assertEquals("multiply", result, 0xb2cb608200000000l); }
@Test
public void test01207() { x = 0xffffffffdeadf00dl; long result = x * 0xa00000000l; AssertJUnit.assertEquals("multiply", result, 0xb2cb608200000000l); }
@Test
public void test01208() { x = 0x7fffffffffffffffl; long result = x * 0xa00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff600000000l); }
@Test
public void test01209() { x = 0x7fffffff7fffffffl; long result = x * 0xa00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff600000000l); }
@Test
public void test01210() { x = 0x7fffffff80000000l; long result = x * 0xa00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01211() { x = 0x7fffffffdeadf00dl; long result = x * 0xa00000000l; AssertJUnit.assertEquals("multiply", result, 0xb2cb608200000000l); }
@Test
public void test01212() { x = 0x8000000000000000l; long result = x * 0xa00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01213() { x = 0xffffffffffffffffl; long result = x * 0xa00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff600000000l); }
@Test
public void test01214() { x = 0xfffffffffffffffel; long result = x * 0xa00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffec00000000l); }
@Test
public void test01215() { x = 0xefffffffffffffffl; long result = x * 0xa00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff600000000l); }
@Test
public void test01216() { x = 0xdeadf00ddeadf00dl; long result = x * 0xa00000000l; AssertJUnit.assertEquals("multiply", result, 0xb2cb608200000000l); }
@Test
public void test01217() { x = 0x000000007fffffffl; long result = x * 0x5000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffb000000000l); }
@Test
public void test01218() { x = 0x0000000080000000l; long result = x * 0x5000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01219() { x = 0x00000000ffffffffl; long result = x * 0x5000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffb000000000l); }
@Test
public void test01220() { x = 0x000000017fffffffl; long result = x * 0x5000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffb000000000l); }
@Test
public void test01221() { x = 0x0000000180000000l; long result = x * 0x5000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01222() { x = 0x00000001ffffffffl; long result = x * 0x5000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffb000000000l); }
@Test
public void test01223() { x = 0xffffffff7fffffffl; long result = x * 0x5000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffb000000000l); }
@Test
public void test01224() { x = 0xffffffff80000000l; long result = x * 0x5000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01225() { x = 0x00000001deadf00dl; long result = x * 0x5000000000l; AssertJUnit.assertEquals("multiply", result, 0x965b041000000000l); }
@Test
public void test01226() { x = 0xffffffffdeadf00dl; long result = x * 0x5000000000l; AssertJUnit.assertEquals("multiply", result, 0x965b041000000000l); }
@Test
public void test01227() { x = 0x7fffffffffffffffl; long result = x * 0x5000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffb000000000l); }
@Test
public void test01228() { x = 0x7fffffff7fffffffl; long result = x * 0x5000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffb000000000l); }
@Test
public void test01229() { x = 0x7fffffff80000000l; long result = x * 0x5000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01230() { x = 0x7fffffffdeadf00dl; long result = x * 0x5000000000l; AssertJUnit.assertEquals("multiply", result, 0x965b041000000000l); }
@Test
public void test01231() { x = 0x8000000000000000l; long result = x * 0x5000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01232() { x = 0xffffffffffffffffl; long result = x * 0x5000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffb000000000l); }
@Test
public void test01233() { x = 0xfffffffffffffffel; long result = x * 0x5000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff6000000000l); }
@Test
public void test01234() { x = 0xefffffffffffffffl; long result = x * 0x5000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffb000000000l); }
@Test
public void test01235() { x = 0xdeadf00ddeadf00dl; long result = x * 0x5000000000l; AssertJUnit.assertEquals("multiply", result, 0x965b041000000000l); }
@Test
public void test01236() { x = 0x000000007fffffffl; long result = x * 0xfffffffffffffff6l; AssertJUnit.assertEquals("multiply", result, 0xfffffffb0000000al); }
@Test
public void test01237() { x = 0x0000000080000000l; long result = x * 0xfffffffffffffff6l; AssertJUnit.assertEquals("multiply", result, 0xfffffffb00000000l); }
@Test
public void test01238() { x = 0x00000000ffffffffl; long result = x * 0xfffffffffffffff6l; AssertJUnit.assertEquals("multiply", result, 0xfffffff60000000al); }
@Test
public void test01239() { x = 0x000000017fffffffl; long result = x * 0xfffffffffffffff6l; AssertJUnit.assertEquals("multiply", result, 0xfffffff10000000al); }
@Test
public void test01240() { x = 0x0000000180000000l; long result = x * 0xfffffffffffffff6l; AssertJUnit.assertEquals("multiply", result, 0xfffffff100000000l); }
@Test
public void test01241() { x = 0x00000001ffffffffl; long result = x * 0xfffffffffffffff6l; AssertJUnit.assertEquals("multiply", result, 0xffffffec0000000al); }
@Test
public void test01242() { x = 0xffffffff7fffffffl; long result = x * 0xfffffffffffffff6l; AssertJUnit.assertEquals("multiply", result, 0x000000050000000al); }
@Test
public void test01243() { x = 0xffffffff80000000l; long result = x * 0xfffffffffffffff6l; AssertJUnit.assertEquals("multiply", result, 0x0000000500000000l); }
@Test
public void test01244() { x = 0x00000001deadf00dl; long result = x * 0xfffffffffffffff6l; AssertJUnit.assertEquals("multiply", result, 0xffffffed4d349f7el); }
@Test
public void test01245() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffffffffffff6l; AssertJUnit.assertEquals("multiply", result, 0x000000014d349f7el); }
@Test
public void test01246() { x = 0x7fffffffffffffffl; long result = x * 0xfffffffffffffff6l; AssertJUnit.assertEquals("multiply", result, 0x000000000000000al); }
@Test
public void test01247() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffffffffffff6l; AssertJUnit.assertEquals("multiply", result, 0x000000050000000al); }
@Test
public void test01248() { x = 0x7fffffff80000000l; long result = x * 0xfffffffffffffff6l; AssertJUnit.assertEquals("multiply", result, 0x0000000500000000l); }
@Test
public void test01249() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffffffffffff6l; AssertJUnit.assertEquals("multiply", result, 0x000000014d349f7el); }
@Test
public void test01250() { x = 0x8000000000000000l; long result = x * 0xfffffffffffffff6l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01251() { x = 0xffffffffffffffffl; long result = x * 0xfffffffffffffff6l; AssertJUnit.assertEquals("multiply", result, 0x000000000000000al); }
@Test
public void test01252() { x = 0xfffffffffffffffel; long result = x * 0xfffffffffffffff6l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000014l); }
@Test
public void test01253() { x = 0xefffffffffffffffl; long result = x * 0xfffffffffffffff6l; AssertJUnit.assertEquals("multiply", result, 0xa00000000000000al); }
@Test
public void test01254() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffffffffffff6l; AssertJUnit.assertEquals("multiply", result, 0x4d349f754d349f7el); }
@Test
public void test01255() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffffb0l; AssertJUnit.assertEquals("multiply", result, 0xffffffd800000050l); }
@Test
public void test01256() { x = 0x0000000080000000l; long result = x * 0xffffffffffffffb0l; AssertJUnit.assertEquals("multiply", result, 0xffffffd800000000l); }
@Test
public void test01257() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffffb0l; AssertJUnit.assertEquals("multiply", result, 0xffffffb000000050l); }
@Test
public void test01258() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffffb0l; AssertJUnit.assertEquals("multiply", result, 0xffffff8800000050l); }
@Test
public void test01259() { x = 0x0000000180000000l; long result = x * 0xffffffffffffffb0l; AssertJUnit.assertEquals("multiply", result, 0xffffff8800000000l); }
@Test
public void test01260() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffffb0l; AssertJUnit.assertEquals("multiply", result, 0xffffff6000000050l); }
@Test
public void test01261() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffffb0l; AssertJUnit.assertEquals("multiply", result, 0x0000002800000050l); }
@Test
public void test01262() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffffb0l; AssertJUnit.assertEquals("multiply", result, 0x0000002800000000l); }
@Test
public void test01263() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffffb0l; AssertJUnit.assertEquals("multiply", result, 0xffffff6a69a4fbf0l); }
@Test
public void test01264() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffffb0l; AssertJUnit.assertEquals("multiply", result, 0x0000000a69a4fbf0l); }
@Test
public void test01265() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffffb0l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000050l); }
@Test
public void test01266() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffffb0l; AssertJUnit.assertEquals("multiply", result, 0x0000002800000050l); }
@Test
public void test01267() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffffb0l; AssertJUnit.assertEquals("multiply", result, 0x0000002800000000l); }
@Test
public void test01268() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffffb0l; AssertJUnit.assertEquals("multiply", result, 0x0000000a69a4fbf0l); }
@Test
public void test01269() { x = 0x8000000000000000l; long result = x * 0xffffffffffffffb0l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01270() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffffb0l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000050l); }
@Test
public void test01271() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffffb0l; AssertJUnit.assertEquals("multiply", result, 0x00000000000000a0l); }
@Test
public void test01272() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffffb0l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000050l); }
@Test
public void test01273() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffffb0l; AssertJUnit.assertEquals("multiply", result, 0x69a4fbaa69a4fbf0l); }
@Test
public void test01274() { x = 0x000000007fffffffl; long result = x * 0xfffffffffffff600l; AssertJUnit.assertEquals("multiply", result, 0xfffffb0000000a00l); }
@Test
public void test01275() { x = 0x0000000080000000l; long result = x * 0xfffffffffffff600l; AssertJUnit.assertEquals("multiply", result, 0xfffffb0000000000l); }
@Test
public void test01276() { x = 0x00000000ffffffffl; long result = x * 0xfffffffffffff600l; AssertJUnit.assertEquals("multiply", result, 0xfffff60000000a00l); }
@Test
public void test01277() { x = 0x000000017fffffffl; long result = x * 0xfffffffffffff600l; AssertJUnit.assertEquals("multiply", result, 0xfffff10000000a00l); }
@Test
public void test01278() { x = 0x0000000180000000l; long result = x * 0xfffffffffffff600l; AssertJUnit.assertEquals("multiply", result, 0xfffff10000000000l); }
@Test
public void test01279() { x = 0x00000001ffffffffl; long result = x * 0xfffffffffffff600l; AssertJUnit.assertEquals("multiply", result, 0xffffec0000000a00l); }
@Test
public void test01280() { x = 0xffffffff7fffffffl; long result = x * 0xfffffffffffff600l; AssertJUnit.assertEquals("multiply", result, 0x0000050000000a00l); }
@Test
public void test01281() { x = 0xffffffff80000000l; long result = x * 0xfffffffffffff600l; AssertJUnit.assertEquals("multiply", result, 0x0000050000000000l); }
@Test
public void test01282() { x = 0x00000001deadf00dl; long result = x * 0xfffffffffffff600l; AssertJUnit.assertEquals("multiply", result, 0xffffed4d349f7e00l); }
@Test
public void test01283() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffffffffff600l; AssertJUnit.assertEquals("multiply", result, 0x0000014d349f7e00l); }
@Test
public void test01284() { x = 0x7fffffffffffffffl; long result = x * 0xfffffffffffff600l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000a00l); }
@Test
public void test01285() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffffffffff600l; AssertJUnit.assertEquals("multiply", result, 0x0000050000000a00l); }
@Test
public void test01286() { x = 0x7fffffff80000000l; long result = x * 0xfffffffffffff600l; AssertJUnit.assertEquals("multiply", result, 0x0000050000000000l); }
@Test
public void test01287() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffffffffff600l; AssertJUnit.assertEquals("multiply", result, 0x0000014d349f7e00l); }
@Test
public void test01288() { x = 0x8000000000000000l; long result = x * 0xfffffffffffff600l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01289() { x = 0xffffffffffffffffl; long result = x * 0xfffffffffffff600l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000a00l); }
@Test
public void test01290() { x = 0xfffffffffffffffel; long result = x * 0xfffffffffffff600l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001400l); }
@Test
public void test01291() { x = 0xefffffffffffffffl; long result = x * 0xfffffffffffff600l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000a00l); }
@Test
public void test01292() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffffffffff600l; AssertJUnit.assertEquals("multiply", result, 0x349f754d349f7e00l); }
@Test
public void test01293() { x = 0x000000007fffffffl; long result = x * 0xfffffff600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000a00000000l); }
@Test
public void test01294() { x = 0x0000000080000000l; long result = x * 0xfffffff600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01295() { x = 0x00000000ffffffffl; long result = x * 0xfffffff600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000a00000000l); }
@Test
public void test01296() { x = 0x000000017fffffffl; long result = x * 0xfffffff600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000a00000000l); }
@Test
public void test01297() { x = 0x0000000180000000l; long result = x * 0xfffffff600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01298() { x = 0x00000001ffffffffl; long result = x * 0xfffffff600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000a00000000l); }
@Test
public void test01299() { x = 0xffffffff7fffffffl; long result = x * 0xfffffff600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000a00000000l); }
@Test
public void test01300() { x = 0xffffffff80000000l; long result = x * 0xfffffff600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01301() { x = 0x00000001deadf00dl; long result = x * 0xfffffff600000000l; AssertJUnit.assertEquals("multiply", result, 0x4d349f7e00000000l); }
@Test
public void test01302() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffff600000000l; AssertJUnit.assertEquals("multiply", result, 0x4d349f7e00000000l); }
@Test
public void test01303() { x = 0x7fffffffffffffffl; long result = x * 0xfffffff600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000a00000000l); }
@Test
public void test01304() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffff600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000a00000000l); }
@Test
public void test01305() { x = 0x7fffffff80000000l; long result = x * 0xfffffff600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01306() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffff600000000l; AssertJUnit.assertEquals("multiply", result, 0x4d349f7e00000000l); }
@Test
public void test01307() { x = 0x8000000000000000l; long result = x * 0xfffffff600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01308() { x = 0xffffffffffffffffl; long result = x * 0xfffffff600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000a00000000l); }
@Test
public void test01309() { x = 0xfffffffffffffffel; long result = x * 0xfffffff600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001400000000l); }
@Test
public void test01310() { x = 0xefffffffffffffffl; long result = x * 0xfffffff600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000a00000000l); }
@Test
public void test01311() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffff600000000l; AssertJUnit.assertEquals("multiply", result, 0x4d349f7e00000000l); }
@Test
public void test01312() { x = 0x000000007fffffffl; long result = x * 0xffffffb000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000005000000000l); }
@Test
public void test01313() { x = 0x0000000080000000l; long result = x * 0xffffffb000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01314() { x = 0x00000000ffffffffl; long result = x * 0xffffffb000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000005000000000l); }
@Test
public void test01315() { x = 0x000000017fffffffl; long result = x * 0xffffffb000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000005000000000l); }
@Test
public void test01316() { x = 0x0000000180000000l; long result = x * 0xffffffb000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01317() { x = 0x00000001ffffffffl; long result = x * 0xffffffb000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000005000000000l); }
@Test
public void test01318() { x = 0xffffffff7fffffffl; long result = x * 0xffffffb000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000005000000000l); }
@Test
public void test01319() { x = 0xffffffff80000000l; long result = x * 0xffffffb000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01320() { x = 0x00000001deadf00dl; long result = x * 0xffffffb000000000l; AssertJUnit.assertEquals("multiply", result, 0x69a4fbf000000000l); }
@Test
public void test01321() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffb000000000l; AssertJUnit.assertEquals("multiply", result, 0x69a4fbf000000000l); }
@Test
public void test01322() { x = 0x7fffffffffffffffl; long result = x * 0xffffffb000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000005000000000l); }
@Test
public void test01323() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffb000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000005000000000l); }
@Test
public void test01324() { x = 0x7fffffff80000000l; long result = x * 0xffffffb000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01325() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffb000000000l; AssertJUnit.assertEquals("multiply", result, 0x69a4fbf000000000l); }
@Test
public void test01326() { x = 0x8000000000000000l; long result = x * 0xffffffb000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01327() { x = 0xffffffffffffffffl; long result = x * 0xffffffb000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000005000000000l); }
@Test
public void test01328() { x = 0xfffffffffffffffel; long result = x * 0xffffffb000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000a000000000l); }
@Test
public void test01329() { x = 0xefffffffffffffffl; long result = x * 0xffffffb000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000005000000000l); }
@Test
public void test01330() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffb000000000l; AssertJUnit.assertEquals("multiply", result, 0x69a4fbf000000000l); }
@Test
public void test01331() { x = 0x000000007fffffffl; long result = x * 0xbl; AssertJUnit.assertEquals("multiply", result, 0x000000057ffffff5l); }
@Test
public void test01332() { x = 0x0000000080000000l; long result = x * 0xbl; AssertJUnit.assertEquals("multiply", result, 0x0000000580000000l); }
@Test
public void test01333() { x = 0x00000000ffffffffl; long result = x * 0xbl; AssertJUnit.assertEquals("multiply", result, 0x0000000afffffff5l); }
@Test
public void test01334() { x = 0x000000017fffffffl; long result = x * 0xbl; AssertJUnit.assertEquals("multiply", result, 0x000000107ffffff5l); }
@Test
public void test01335() { x = 0x0000000180000000l; long result = x * 0xbl; AssertJUnit.assertEquals("multiply", result, 0x0000001080000000l); }
@Test
public void test01336() { x = 0x00000001ffffffffl; long result = x * 0xbl; AssertJUnit.assertEquals("multiply", result, 0x00000015fffffff5l); }
@Test
public void test01337() { x = 0xffffffff7fffffffl; long result = x * 0xbl; AssertJUnit.assertEquals("multiply", result, 0xfffffffa7ffffff5l); }
@Test
public void test01338() { x = 0xffffffff80000000l; long result = x * 0xbl; AssertJUnit.assertEquals("multiply", result, 0xfffffffa80000000l); }
@Test
public void test01339() { x = 0x00000001deadf00dl; long result = x * 0xbl; AssertJUnit.assertEquals("multiply", result, 0x000000149179508fl); }
@Test
public void test01340() { x = 0xffffffffdeadf00dl; long result = x * 0xbl; AssertJUnit.assertEquals("multiply", result, 0xfffffffe9179508fl); }
@Test
public void test01341() { x = 0x7fffffffffffffffl; long result = x * 0xbl; AssertJUnit.assertEquals("multiply", result, 0x7ffffffffffffff5l); }
@Test
public void test01342() { x = 0x7fffffff7fffffffl; long result = x * 0xbl; AssertJUnit.assertEquals("multiply", result, 0x7ffffffa7ffffff5l); }
@Test
public void test01343() { x = 0x7fffffff80000000l; long result = x * 0xbl; AssertJUnit.assertEquals("multiply", result, 0x7ffffffa80000000l); }
@Test
public void test01344() { x = 0x7fffffffdeadf00dl; long result = x * 0xbl; AssertJUnit.assertEquals("multiply", result, 0x7ffffffe9179508fl); }
@Test
public void test01345() { x = 0x8000000000000000l; long result = x * 0xbl; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test01346() { x = 0xffffffffffffffffl; long result = x * 0xbl; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffff5l); }
@Test
public void test01347() { x = 0xfffffffffffffffel; long result = x * 0xbl; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffeal); }
@Test
public void test01348() { x = 0xefffffffffffffffl; long result = x * 0xbl; AssertJUnit.assertEquals("multiply", result, 0x4ffffffffffffff5l); }
@Test
public void test01349() { x = 0xdeadf00ddeadf00dl; long result = x * 0xbl; AssertJUnit.assertEquals("multiply", result, 0x917950989179508fl); }
@Test
public void test01350() { x = 0x000000007fffffffl; long result = x * 0x58l; AssertJUnit.assertEquals("multiply", result, 0x0000002bffffffa8l); }
@Test
public void test01351() { x = 0x0000000080000000l; long result = x * 0x58l; AssertJUnit.assertEquals("multiply", result, 0x0000002c00000000l); }
@Test
public void test01352() { x = 0x00000000ffffffffl; long result = x * 0x58l; AssertJUnit.assertEquals("multiply", result, 0x00000057ffffffa8l); }
@Test
public void test01353() { x = 0x000000017fffffffl; long result = x * 0x58l; AssertJUnit.assertEquals("multiply", result, 0x00000083ffffffa8l); }
@Test
public void test01354() { x = 0x0000000180000000l; long result = x * 0x58l; AssertJUnit.assertEquals("multiply", result, 0x0000008400000000l); }
@Test
public void test01355() { x = 0x00000001ffffffffl; long result = x * 0x58l; AssertJUnit.assertEquals("multiply", result, 0x000000afffffffa8l); }
@Test
public void test01356() { x = 0xffffffff7fffffffl; long result = x * 0x58l; AssertJUnit.assertEquals("multiply", result, 0xffffffd3ffffffa8l); }
@Test
public void test01357() { x = 0xffffffff80000000l; long result = x * 0x58l; AssertJUnit.assertEquals("multiply", result, 0xffffffd400000000l); }
@Test
public void test01358() { x = 0x00000001deadf00dl; long result = x * 0x58l; AssertJUnit.assertEquals("multiply", result, 0x000000a48bca8478l); }
@Test
public void test01359() { x = 0xffffffffdeadf00dl; long result = x * 0x58l; AssertJUnit.assertEquals("multiply", result, 0xfffffff48bca8478l); }
@Test
public void test01360() { x = 0x7fffffffffffffffl; long result = x * 0x58l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffa8l); }
@Test
public void test01361() { x = 0x7fffffff7fffffffl; long result = x * 0x58l; AssertJUnit.assertEquals("multiply", result, 0xffffffd3ffffffa8l); }
@Test
public void test01362() { x = 0x7fffffff80000000l; long result = x * 0x58l; AssertJUnit.assertEquals("multiply", result, 0xffffffd400000000l); }
@Test
public void test01363() { x = 0x7fffffffdeadf00dl; long result = x * 0x58l; AssertJUnit.assertEquals("multiply", result, 0xfffffff48bca8478l); }
@Test
public void test01364() { x = 0x8000000000000000l; long result = x * 0x58l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01365() { x = 0xffffffffffffffffl; long result = x * 0x58l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffa8l); }
@Test
public void test01366() { x = 0xfffffffffffffffel; long result = x * 0x58l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff50l); }
@Test
public void test01367() { x = 0xefffffffffffffffl; long result = x * 0x58l; AssertJUnit.assertEquals("multiply", result, 0x7fffffffffffffa8l); }
@Test
public void test01368() { x = 0xdeadf00ddeadf00dl; long result = x * 0x58l; AssertJUnit.assertEquals("multiply", result, 0x8bca84c48bca8478l); }
@Test
public void test01369() { x = 0x000000007fffffffl; long result = x * 0xb00l; AssertJUnit.assertEquals("multiply", result, 0x0000057ffffff500l); }
@Test
public void test01370() { x = 0x0000000080000000l; long result = x * 0xb00l; AssertJUnit.assertEquals("multiply", result, 0x0000058000000000l); }
@Test
public void test01371() { x = 0x00000000ffffffffl; long result = x * 0xb00l; AssertJUnit.assertEquals("multiply", result, 0x00000afffffff500l); }
@Test
public void test01372() { x = 0x000000017fffffffl; long result = x * 0xb00l; AssertJUnit.assertEquals("multiply", result, 0x0000107ffffff500l); }
@Test
public void test01373() { x = 0x0000000180000000l; long result = x * 0xb00l; AssertJUnit.assertEquals("multiply", result, 0x0000108000000000l); }
@Test
public void test01374() { x = 0x00000001ffffffffl; long result = x * 0xb00l; AssertJUnit.assertEquals("multiply", result, 0x000015fffffff500l); }
@Test
public void test01375() { x = 0xffffffff7fffffffl; long result = x * 0xb00l; AssertJUnit.assertEquals("multiply", result, 0xfffffa7ffffff500l); }
@Test
public void test01376() { x = 0xffffffff80000000l; long result = x * 0xb00l; AssertJUnit.assertEquals("multiply", result, 0xfffffa8000000000l); }
@Test
public void test01377() { x = 0x00000001deadf00dl; long result = x * 0xb00l; AssertJUnit.assertEquals("multiply", result, 0x0000149179508f00l); }
@Test
public void test01378() { x = 0xffffffffdeadf00dl; long result = x * 0xb00l; AssertJUnit.assertEquals("multiply", result, 0xfffffe9179508f00l); }
@Test
public void test01379() { x = 0x7fffffffffffffffl; long result = x * 0xb00l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffff500l); }
@Test
public void test01380() { x = 0x7fffffff7fffffffl; long result = x * 0xb00l; AssertJUnit.assertEquals("multiply", result, 0xfffffa7ffffff500l); }
@Test
public void test01381() { x = 0x7fffffff80000000l; long result = x * 0xb00l; AssertJUnit.assertEquals("multiply", result, 0xfffffa8000000000l); }
@Test
public void test01382() { x = 0x7fffffffdeadf00dl; long result = x * 0xb00l; AssertJUnit.assertEquals("multiply", result, 0xfffffe9179508f00l); }
@Test
public void test01383() { x = 0x8000000000000000l; long result = x * 0xb00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01384() { x = 0xffffffffffffffffl; long result = x * 0xb00l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffff500l); }
@Test
public void test01385() { x = 0xfffffffffffffffel; long result = x * 0xb00l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffea00l); }
@Test
public void test01386() { x = 0xefffffffffffffffl; long result = x * 0xb00l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffff500l); }
@Test
public void test01387() { x = 0xdeadf00ddeadf00dl; long result = x * 0xb00l; AssertJUnit.assertEquals("multiply", result, 0x7950989179508f00l); }
@Test
public void test01388() { x = 0x000000007fffffffl; long result = x * 0xb00000000l; AssertJUnit.assertEquals("multiply", result, 0x7ffffff500000000l); }
@Test
public void test01389() { x = 0x0000000080000000l; long result = x * 0xb00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test01390() { x = 0x00000000ffffffffl; long result = x * 0xb00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff500000000l); }
@Test
public void test01391() { x = 0x000000017fffffffl; long result = x * 0xb00000000l; AssertJUnit.assertEquals("multiply", result, 0x7ffffff500000000l); }
@Test
public void test01392() { x = 0x0000000180000000l; long result = x * 0xb00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test01393() { x = 0x00000001ffffffffl; long result = x * 0xb00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff500000000l); }
@Test
public void test01394() { x = 0xffffffff7fffffffl; long result = x * 0xb00000000l; AssertJUnit.assertEquals("multiply", result, 0x7ffffff500000000l); }
@Test
public void test01395() { x = 0xffffffff80000000l; long result = x * 0xb00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test01396() { x = 0x00000001deadf00dl; long result = x * 0xb00000000l; AssertJUnit.assertEquals("multiply", result, 0x9179508f00000000l); }
@Test
public void test01397() { x = 0xffffffffdeadf00dl; long result = x * 0xb00000000l; AssertJUnit.assertEquals("multiply", result, 0x9179508f00000000l); }
@Test
public void test01398() { x = 0x7fffffffffffffffl; long result = x * 0xb00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff500000000l); }
@Test
public void test01399() { x = 0x7fffffff7fffffffl; long result = x * 0xb00000000l; AssertJUnit.assertEquals("multiply", result, 0x7ffffff500000000l); }
@Test
public void test01400() { x = 0x7fffffff80000000l; long result = x * 0xb00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test01401() { x = 0x7fffffffdeadf00dl; long result = x * 0xb00000000l; AssertJUnit.assertEquals("multiply", result, 0x9179508f00000000l); }
@Test
public void test01402() { x = 0x8000000000000000l; long result = x * 0xb00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01403() { x = 0xffffffffffffffffl; long result = x * 0xb00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff500000000l); }
@Test
public void test01404() { x = 0xfffffffffffffffel; long result = x * 0xb00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffea00000000l); }
@Test
public void test01405() { x = 0xefffffffffffffffl; long result = x * 0xb00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff500000000l); }
@Test
public void test01406() { x = 0xdeadf00ddeadf00dl; long result = x * 0xb00000000l; AssertJUnit.assertEquals("multiply", result, 0x9179508f00000000l); }
@Test
public void test01407() { x = 0x000000007fffffffl; long result = x * 0x5800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffa800000000l); }
@Test
public void test01408() { x = 0x0000000080000000l; long result = x * 0x5800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01409() { x = 0x00000000ffffffffl; long result = x * 0x5800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffa800000000l); }
@Test
public void test01410() { x = 0x000000017fffffffl; long result = x * 0x5800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffa800000000l); }
@Test
public void test01411() { x = 0x0000000180000000l; long result = x * 0x5800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01412() { x = 0x00000001ffffffffl; long result = x * 0x5800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffa800000000l); }
@Test
public void test01413() { x = 0xffffffff7fffffffl; long result = x * 0x5800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffa800000000l); }
@Test
public void test01414() { x = 0xffffffff80000000l; long result = x * 0x5800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01415() { x = 0x00000001deadf00dl; long result = x * 0x5800000000l; AssertJUnit.assertEquals("multiply", result, 0x8bca847800000000l); }
@Test
public void test01416() { x = 0xffffffffdeadf00dl; long result = x * 0x5800000000l; AssertJUnit.assertEquals("multiply", result, 0x8bca847800000000l); }
@Test
public void test01417() { x = 0x7fffffffffffffffl; long result = x * 0x5800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffa800000000l); }
@Test
public void test01418() { x = 0x7fffffff7fffffffl; long result = x * 0x5800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffa800000000l); }
@Test
public void test01419() { x = 0x7fffffff80000000l; long result = x * 0x5800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01420() { x = 0x7fffffffdeadf00dl; long result = x * 0x5800000000l; AssertJUnit.assertEquals("multiply", result, 0x8bca847800000000l); }
@Test
public void test01421() { x = 0x8000000000000000l; long result = x * 0x5800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01422() { x = 0xffffffffffffffffl; long result = x * 0x5800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffa800000000l); }
@Test
public void test01423() { x = 0xfffffffffffffffel; long result = x * 0x5800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff5000000000l); }
@Test
public void test01424() { x = 0xefffffffffffffffl; long result = x * 0x5800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffa800000000l); }
@Test
public void test01425() { x = 0xdeadf00ddeadf00dl; long result = x * 0x5800000000l; AssertJUnit.assertEquals("multiply", result, 0x8bca847800000000l); }
@Test
public void test01426() { x = 0x000000007fffffffl; long result = x * 0xfffffffffffffff5l; AssertJUnit.assertEquals("multiply", result, 0xfffffffa8000000bl); }
@Test
public void test01427() { x = 0x0000000080000000l; long result = x * 0xfffffffffffffff5l; AssertJUnit.assertEquals("multiply", result, 0xfffffffa80000000l); }
@Test
public void test01428() { x = 0x00000000ffffffffl; long result = x * 0xfffffffffffffff5l; AssertJUnit.assertEquals("multiply", result, 0xfffffff50000000bl); }
@Test
public void test01429() { x = 0x000000017fffffffl; long result = x * 0xfffffffffffffff5l; AssertJUnit.assertEquals("multiply", result, 0xffffffef8000000bl); }
@Test
public void test01430() { x = 0x0000000180000000l; long result = x * 0xfffffffffffffff5l; AssertJUnit.assertEquals("multiply", result, 0xffffffef80000000l); }
@Test
public void test01431() { x = 0x00000001ffffffffl; long result = x * 0xfffffffffffffff5l; AssertJUnit.assertEquals("multiply", result, 0xffffffea0000000bl); }
@Test
public void test01432() { x = 0xffffffff7fffffffl; long result = x * 0xfffffffffffffff5l; AssertJUnit.assertEquals("multiply", result, 0x000000058000000bl); }
@Test
public void test01433() { x = 0xffffffff80000000l; long result = x * 0xfffffffffffffff5l; AssertJUnit.assertEquals("multiply", result, 0x0000000580000000l); }
@Test
public void test01434() { x = 0x00000001deadf00dl; long result = x * 0xfffffffffffffff5l; AssertJUnit.assertEquals("multiply", result, 0xffffffeb6e86af71l); }
@Test
public void test01435() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffffffffffff5l; AssertJUnit.assertEquals("multiply", result, 0x000000016e86af71l); }
@Test
public void test01436() { x = 0x7fffffffffffffffl; long result = x * 0xfffffffffffffff5l; AssertJUnit.assertEquals("multiply", result, 0x800000000000000bl); }
@Test
public void test01437() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffffffffffff5l; AssertJUnit.assertEquals("multiply", result, 0x800000058000000bl); }
@Test
public void test01438() { x = 0x7fffffff80000000l; long result = x * 0xfffffffffffffff5l; AssertJUnit.assertEquals("multiply", result, 0x8000000580000000l); }
@Test
public void test01439() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffffffffffff5l; AssertJUnit.assertEquals("multiply", result, 0x800000016e86af71l); }
@Test
public void test01440() { x = 0x8000000000000000l; long result = x * 0xfffffffffffffff5l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test01441() { x = 0xffffffffffffffffl; long result = x * 0xfffffffffffffff5l; AssertJUnit.assertEquals("multiply", result, 0x000000000000000bl); }
@Test
public void test01442() { x = 0xfffffffffffffffel; long result = x * 0xfffffffffffffff5l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000016l); }
@Test
public void test01443() { x = 0xefffffffffffffffl; long result = x * 0xfffffffffffffff5l; AssertJUnit.assertEquals("multiply", result, 0xb00000000000000bl); }
@Test
public void test01444() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffffffffffff5l; AssertJUnit.assertEquals("multiply", result, 0x6e86af676e86af71l); }
@Test
public void test01445() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffffa8l; AssertJUnit.assertEquals("multiply", result, 0xffffffd400000058l); }
@Test
public void test01446() { x = 0x0000000080000000l; long result = x * 0xffffffffffffffa8l; AssertJUnit.assertEquals("multiply", result, 0xffffffd400000000l); }
@Test
public void test01447() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffffa8l; AssertJUnit.assertEquals("multiply", result, 0xffffffa800000058l); }
@Test
public void test01448() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffffa8l; AssertJUnit.assertEquals("multiply", result, 0xffffff7c00000058l); }
@Test
public void test01449() { x = 0x0000000180000000l; long result = x * 0xffffffffffffffa8l; AssertJUnit.assertEquals("multiply", result, 0xffffff7c00000000l); }
@Test
public void test01450() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffffa8l; AssertJUnit.assertEquals("multiply", result, 0xffffff5000000058l); }
@Test
public void test01451() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffffa8l; AssertJUnit.assertEquals("multiply", result, 0x0000002c00000058l); }
@Test
public void test01452() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffffa8l; AssertJUnit.assertEquals("multiply", result, 0x0000002c00000000l); }
@Test
public void test01453() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffffa8l; AssertJUnit.assertEquals("multiply", result, 0xffffff5b74357b88l); }
@Test
public void test01454() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffffa8l; AssertJUnit.assertEquals("multiply", result, 0x0000000b74357b88l); }
@Test
public void test01455() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffffa8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000058l); }
@Test
public void test01456() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffffa8l; AssertJUnit.assertEquals("multiply", result, 0x0000002c00000058l); }
@Test
public void test01457() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffffa8l; AssertJUnit.assertEquals("multiply", result, 0x0000002c00000000l); }
@Test
public void test01458() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffffa8l; AssertJUnit.assertEquals("multiply", result, 0x0000000b74357b88l); }
@Test
public void test01459() { x = 0x8000000000000000l; long result = x * 0xffffffffffffffa8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01460() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffffa8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000058l); }
@Test
public void test01461() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffffa8l; AssertJUnit.assertEquals("multiply", result, 0x00000000000000b0l); }
@Test
public void test01462() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffffa8l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000058l); }
@Test
public void test01463() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffffa8l; AssertJUnit.assertEquals("multiply", result, 0x74357b3b74357b88l); }
@Test
public void test01464() { x = 0x000000007fffffffl; long result = x * 0xfffffffffffff500l; AssertJUnit.assertEquals("multiply", result, 0xfffffa8000000b00l); }
@Test
public void test01465() { x = 0x0000000080000000l; long result = x * 0xfffffffffffff500l; AssertJUnit.assertEquals("multiply", result, 0xfffffa8000000000l); }
@Test
public void test01466() { x = 0x00000000ffffffffl; long result = x * 0xfffffffffffff500l; AssertJUnit.assertEquals("multiply", result, 0xfffff50000000b00l); }
@Test
public void test01467() { x = 0x000000017fffffffl; long result = x * 0xfffffffffffff500l; AssertJUnit.assertEquals("multiply", result, 0xffffef8000000b00l); }
@Test
public void test01468() { x = 0x0000000180000000l; long result = x * 0xfffffffffffff500l; AssertJUnit.assertEquals("multiply", result, 0xffffef8000000000l); }
@Test
public void test01469() { x = 0x00000001ffffffffl; long result = x * 0xfffffffffffff500l; AssertJUnit.assertEquals("multiply", result, 0xffffea0000000b00l); }
@Test
public void test01470() { x = 0xffffffff7fffffffl; long result = x * 0xfffffffffffff500l; AssertJUnit.assertEquals("multiply", result, 0x0000058000000b00l); }
@Test
public void test01471() { x = 0xffffffff80000000l; long result = x * 0xfffffffffffff500l; AssertJUnit.assertEquals("multiply", result, 0x0000058000000000l); }
@Test
public void test01472() { x = 0x00000001deadf00dl; long result = x * 0xfffffffffffff500l; AssertJUnit.assertEquals("multiply", result, 0xffffeb6e86af7100l); }
@Test
public void test01473() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffffffffff500l; AssertJUnit.assertEquals("multiply", result, 0x0000016e86af7100l); }
@Test
public void test01474() { x = 0x7fffffffffffffffl; long result = x * 0xfffffffffffff500l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000b00l); }
@Test
public void test01475() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffffffffff500l; AssertJUnit.assertEquals("multiply", result, 0x0000058000000b00l); }
@Test
public void test01476() { x = 0x7fffffff80000000l; long result = x * 0xfffffffffffff500l; AssertJUnit.assertEquals("multiply", result, 0x0000058000000000l); }
@Test
public void test01477() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffffffffff500l; AssertJUnit.assertEquals("multiply", result, 0x0000016e86af7100l); }
@Test
public void test01478() { x = 0x8000000000000000l; long result = x * 0xfffffffffffff500l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01479() { x = 0xffffffffffffffffl; long result = x * 0xfffffffffffff500l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000b00l); }
@Test
public void test01480() { x = 0xfffffffffffffffel; long result = x * 0xfffffffffffff500l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001600l); }
@Test
public void test01481() { x = 0xefffffffffffffffl; long result = x * 0xfffffffffffff500l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000b00l); }
@Test
public void test01482() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffffffffff500l; AssertJUnit.assertEquals("multiply", result, 0x86af676e86af7100l); }
@Test
public void test01483() { x = 0x000000007fffffffl; long result = x * 0xfffffff500000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000b00000000l); }
@Test
public void test01484() { x = 0x0000000080000000l; long result = x * 0xfffffff500000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test01485() { x = 0x00000000ffffffffl; long result = x * 0xfffffff500000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000b00000000l); }
@Test
public void test01486() { x = 0x000000017fffffffl; long result = x * 0xfffffff500000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000b00000000l); }
@Test
public void test01487() { x = 0x0000000180000000l; long result = x * 0xfffffff500000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test01488() { x = 0x00000001ffffffffl; long result = x * 0xfffffff500000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000b00000000l); }
@Test
public void test01489() { x = 0xffffffff7fffffffl; long result = x * 0xfffffff500000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000b00000000l); }
@Test
public void test01490() { x = 0xffffffff80000000l; long result = x * 0xfffffff500000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test01491() { x = 0x00000001deadf00dl; long result = x * 0xfffffff500000000l; AssertJUnit.assertEquals("multiply", result, 0x6e86af7100000000l); }
@Test
public void test01492() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffff500000000l; AssertJUnit.assertEquals("multiply", result, 0x6e86af7100000000l); }
@Test
public void test01493() { x = 0x7fffffffffffffffl; long result = x * 0xfffffff500000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000b00000000l); }
@Test
public void test01494() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffff500000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000b00000000l); }
@Test
public void test01495() { x = 0x7fffffff80000000l; long result = x * 0xfffffff500000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test01496() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffff500000000l; AssertJUnit.assertEquals("multiply", result, 0x6e86af7100000000l); }
@Test
public void test01497() { x = 0x8000000000000000l; long result = x * 0xfffffff500000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01498() { x = 0xffffffffffffffffl; long result = x * 0xfffffff500000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000b00000000l); }
@Test
public void test01499() { x = 0xfffffffffffffffel; long result = x * 0xfffffff500000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001600000000l); }
@Test
public void test01500() { x = 0xefffffffffffffffl; long result = x * 0xfffffff500000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000b00000000l); }
@Test
public void test01501() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffff500000000l; AssertJUnit.assertEquals("multiply", result, 0x6e86af7100000000l); }
@Test
public void test01502() { x = 0x000000007fffffffl; long result = x * 0xffffffa800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000005800000000l); }
@Test
public void test01503() { x = 0x0000000080000000l; long result = x * 0xffffffa800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01504() { x = 0x00000000ffffffffl; long result = x * 0xffffffa800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000005800000000l); }
@Test
public void test01505() { x = 0x000000017fffffffl; long result = x * 0xffffffa800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000005800000000l); }
@Test
public void test01506() { x = 0x0000000180000000l; long result = x * 0xffffffa800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01507() { x = 0x00000001ffffffffl; long result = x * 0xffffffa800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000005800000000l); }
@Test
public void test01508() { x = 0xffffffff7fffffffl; long result = x * 0xffffffa800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000005800000000l); }
@Test
public void test01509() { x = 0xffffffff80000000l; long result = x * 0xffffffa800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01510() { x = 0x00000001deadf00dl; long result = x * 0xffffffa800000000l; AssertJUnit.assertEquals("multiply", result, 0x74357b8800000000l); }
@Test
public void test01511() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffa800000000l; AssertJUnit.assertEquals("multiply", result, 0x74357b8800000000l); }
@Test
public void test01512() { x = 0x7fffffffffffffffl; long result = x * 0xffffffa800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000005800000000l); }
@Test
public void test01513() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffa800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000005800000000l); }
@Test
public void test01514() { x = 0x7fffffff80000000l; long result = x * 0xffffffa800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01515() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffa800000000l; AssertJUnit.assertEquals("multiply", result, 0x74357b8800000000l); }
@Test
public void test01516() { x = 0x8000000000000000l; long result = x * 0xffffffa800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01517() { x = 0xffffffffffffffffl; long result = x * 0xffffffa800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000005800000000l); }
@Test
public void test01518() { x = 0xfffffffffffffffel; long result = x * 0xffffffa800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000b000000000l); }
@Test
public void test01519() { x = 0xefffffffffffffffl; long result = x * 0xffffffa800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000005800000000l); }
@Test
public void test01520() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffa800000000l; AssertJUnit.assertEquals("multiply", result, 0x74357b8800000000l); }
@Test
public void test01521() { x = 0x000000007fffffffl; long result = x * 0xcl; AssertJUnit.assertEquals("multiply", result, 0x00000005fffffff4l); }
@Test
public void test01522() { x = 0x0000000080000000l; long result = x * 0xcl; AssertJUnit.assertEquals("multiply", result, 0x0000000600000000l); }
@Test
public void test01523() { x = 0x00000000ffffffffl; long result = x * 0xcl; AssertJUnit.assertEquals("multiply", result, 0x0000000bfffffff4l); }
@Test
public void test01524() { x = 0x000000017fffffffl; long result = x * 0xcl; AssertJUnit.assertEquals("multiply", result, 0x00000011fffffff4l); }
@Test
public void test01525() { x = 0x0000000180000000l; long result = x * 0xcl; AssertJUnit.assertEquals("multiply", result, 0x0000001200000000l); }
@Test
public void test01526() { x = 0x00000001ffffffffl; long result = x * 0xcl; AssertJUnit.assertEquals("multiply", result, 0x00000017fffffff4l); }
@Test
public void test01527() { x = 0xffffffff7fffffffl; long result = x * 0xcl; AssertJUnit.assertEquals("multiply", result, 0xfffffff9fffffff4l); }
@Test
public void test01528() { x = 0xffffffff80000000l; long result = x * 0xcl; AssertJUnit.assertEquals("multiply", result, 0xfffffffa00000000l); }
@Test
public void test01529() { x = 0x00000001deadf00dl; long result = x * 0xcl; AssertJUnit.assertEquals("multiply", result, 0x000000167027409cl); }
@Test
public void test01530() { x = 0xffffffffdeadf00dl; long result = x * 0xcl; AssertJUnit.assertEquals("multiply", result, 0xfffffffe7027409cl); }
@Test
public void test01531() { x = 0x7fffffffffffffffl; long result = x * 0xcl; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffff4l); }
@Test
public void test01532() { x = 0x7fffffff7fffffffl; long result = x * 0xcl; AssertJUnit.assertEquals("multiply", result, 0xfffffff9fffffff4l); }
@Test
public void test01533() { x = 0x7fffffff80000000l; long result = x * 0xcl; AssertJUnit.assertEquals("multiply", result, 0xfffffffa00000000l); }
@Test
public void test01534() { x = 0x7fffffffdeadf00dl; long result = x * 0xcl; AssertJUnit.assertEquals("multiply", result, 0xfffffffe7027409cl); }
@Test
public void test01535() { x = 0x8000000000000000l; long result = x * 0xcl; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01536() { x = 0xffffffffffffffffl; long result = x * 0xcl; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffff4l); }
@Test
public void test01537() { x = 0xfffffffffffffffel; long result = x * 0xcl; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffe8l); }
@Test
public void test01538() { x = 0xefffffffffffffffl; long result = x * 0xcl; AssertJUnit.assertEquals("multiply", result, 0x3ffffffffffffff4l); }
@Test
public void test01539() { x = 0xdeadf00ddeadf00dl; long result = x * 0xcl; AssertJUnit.assertEquals("multiply", result, 0x702740a67027409cl); }
@Test
public void test01540() { x = 0x000000007fffffffl; long result = x * 0x60l; AssertJUnit.assertEquals("multiply", result, 0x0000002fffffffa0l); }
@Test
public void test01541() { x = 0x0000000080000000l; long result = x * 0x60l; AssertJUnit.assertEquals("multiply", result, 0x0000003000000000l); }
@Test
public void test01542() { x = 0x00000000ffffffffl; long result = x * 0x60l; AssertJUnit.assertEquals("multiply", result, 0x0000005fffffffa0l); }
@Test
public void test01543() { x = 0x000000017fffffffl; long result = x * 0x60l; AssertJUnit.assertEquals("multiply", result, 0x0000008fffffffa0l); }
@Test
public void test01544() { x = 0x0000000180000000l; long result = x * 0x60l; AssertJUnit.assertEquals("multiply", result, 0x0000009000000000l); }
@Test
public void test01545() { x = 0x00000001ffffffffl; long result = x * 0x60l; AssertJUnit.assertEquals("multiply", result, 0x000000bfffffffa0l); }
@Test
public void test01546() { x = 0xffffffff7fffffffl; long result = x * 0x60l; AssertJUnit.assertEquals("multiply", result, 0xffffffcfffffffa0l); }
@Test
public void test01547() { x = 0xffffffff80000000l; long result = x * 0x60l; AssertJUnit.assertEquals("multiply", result, 0xffffffd000000000l); }
@Test
public void test01548() { x = 0x00000001deadf00dl; long result = x * 0x60l; AssertJUnit.assertEquals("multiply", result, 0x000000b3813a04e0l); }
@Test
public void test01549() { x = 0xffffffffdeadf00dl; long result = x * 0x60l; AssertJUnit.assertEquals("multiply", result, 0xfffffff3813a04e0l); }
@Test
public void test01550() { x = 0x7fffffffffffffffl; long result = x * 0x60l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffa0l); }
@Test
public void test01551() { x = 0x7fffffff7fffffffl; long result = x * 0x60l; AssertJUnit.assertEquals("multiply", result, 0xffffffcfffffffa0l); }
@Test
public void test01552() { x = 0x7fffffff80000000l; long result = x * 0x60l; AssertJUnit.assertEquals("multiply", result, 0xffffffd000000000l); }
@Test
public void test01553() { x = 0x7fffffffdeadf00dl; long result = x * 0x60l; AssertJUnit.assertEquals("multiply", result, 0xfffffff3813a04e0l); }
@Test
public void test01554() { x = 0x8000000000000000l; long result = x * 0x60l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01555() { x = 0xffffffffffffffffl; long result = x * 0x60l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffa0l); }
@Test
public void test01556() { x = 0xfffffffffffffffel; long result = x * 0x60l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff40l); }
@Test
public void test01557() { x = 0xefffffffffffffffl; long result = x * 0x60l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffa0l); }
@Test
public void test01558() { x = 0xdeadf00ddeadf00dl; long result = x * 0x60l; AssertJUnit.assertEquals("multiply", result, 0x813a0533813a04e0l); }
@Test
public void test01559() { x = 0x000000007fffffffl; long result = x * 0xc00l; AssertJUnit.assertEquals("multiply", result, 0x000005fffffff400l); }
@Test
public void test01560() { x = 0x0000000080000000l; long result = x * 0xc00l; AssertJUnit.assertEquals("multiply", result, 0x0000060000000000l); }
@Test
public void test01561() { x = 0x00000000ffffffffl; long result = x * 0xc00l; AssertJUnit.assertEquals("multiply", result, 0x00000bfffffff400l); }
@Test
public void test01562() { x = 0x000000017fffffffl; long result = x * 0xc00l; AssertJUnit.assertEquals("multiply", result, 0x000011fffffff400l); }
@Test
public void test01563() { x = 0x0000000180000000l; long result = x * 0xc00l; AssertJUnit.assertEquals("multiply", result, 0x0000120000000000l); }
@Test
public void test01564() { x = 0x00000001ffffffffl; long result = x * 0xc00l; AssertJUnit.assertEquals("multiply", result, 0x000017fffffff400l); }
@Test
public void test01565() { x = 0xffffffff7fffffffl; long result = x * 0xc00l; AssertJUnit.assertEquals("multiply", result, 0xfffff9fffffff400l); }
@Test
public void test01566() { x = 0xffffffff80000000l; long result = x * 0xc00l; AssertJUnit.assertEquals("multiply", result, 0xfffffa0000000000l); }
@Test
public void test01567() { x = 0x00000001deadf00dl; long result = x * 0xc00l; AssertJUnit.assertEquals("multiply", result, 0x0000167027409c00l); }
@Test
public void test01568() { x = 0xffffffffdeadf00dl; long result = x * 0xc00l; AssertJUnit.assertEquals("multiply", result, 0xfffffe7027409c00l); }
@Test
public void test01569() { x = 0x7fffffffffffffffl; long result = x * 0xc00l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffff400l); }
@Test
public void test01570() { x = 0x7fffffff7fffffffl; long result = x * 0xc00l; AssertJUnit.assertEquals("multiply", result, 0xfffff9fffffff400l); }
@Test
public void test01571() { x = 0x7fffffff80000000l; long result = x * 0xc00l; AssertJUnit.assertEquals("multiply", result, 0xfffffa0000000000l); }
@Test
public void test01572() { x = 0x7fffffffdeadf00dl; long result = x * 0xc00l; AssertJUnit.assertEquals("multiply", result, 0xfffffe7027409c00l); }
@Test
public void test01573() { x = 0x8000000000000000l; long result = x * 0xc00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01574() { x = 0xffffffffffffffffl; long result = x * 0xc00l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffff400l); }
@Test
public void test01575() { x = 0xfffffffffffffffel; long result = x * 0xc00l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffe800l); }
@Test
public void test01576() { x = 0xefffffffffffffffl; long result = x * 0xc00l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffff400l); }
@Test
public void test01577() { x = 0xdeadf00ddeadf00dl; long result = x * 0xc00l; AssertJUnit.assertEquals("multiply", result, 0x2740a67027409c00l); }
@Test
public void test01578() { x = 0x000000007fffffffl; long result = x * 0xc00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff400000000l); }
@Test
public void test01579() { x = 0x0000000080000000l; long result = x * 0xc00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01580() { x = 0x00000000ffffffffl; long result = x * 0xc00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff400000000l); }
@Test
public void test01581() { x = 0x000000017fffffffl; long result = x * 0xc00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff400000000l); }
@Test
public void test01582() { x = 0x0000000180000000l; long result = x * 0xc00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01583() { x = 0x00000001ffffffffl; long result = x * 0xc00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff400000000l); }
@Test
public void test01584() { x = 0xffffffff7fffffffl; long result = x * 0xc00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff400000000l); }
@Test
public void test01585() { x = 0xffffffff80000000l; long result = x * 0xc00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01586() { x = 0x00000001deadf00dl; long result = x * 0xc00000000l; AssertJUnit.assertEquals("multiply", result, 0x7027409c00000000l); }
@Test
public void test01587() { x = 0xffffffffdeadf00dl; long result = x * 0xc00000000l; AssertJUnit.assertEquals("multiply", result, 0x7027409c00000000l); }
@Test
public void test01588() { x = 0x7fffffffffffffffl; long result = x * 0xc00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff400000000l); }
@Test
public void test01589() { x = 0x7fffffff7fffffffl; long result = x * 0xc00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff400000000l); }
@Test
public void test01590() { x = 0x7fffffff80000000l; long result = x * 0xc00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01591() { x = 0x7fffffffdeadf00dl; long result = x * 0xc00000000l; AssertJUnit.assertEquals("multiply", result, 0x7027409c00000000l); }
@Test
public void test01592() { x = 0x8000000000000000l; long result = x * 0xc00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01593() { x = 0xffffffffffffffffl; long result = x * 0xc00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff400000000l); }
@Test
public void test01594() { x = 0xfffffffffffffffel; long result = x * 0xc00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe800000000l); }
@Test
public void test01595() { x = 0xefffffffffffffffl; long result = x * 0xc00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff400000000l); }
@Test
public void test01596() { x = 0xdeadf00ddeadf00dl; long result = x * 0xc00000000l; AssertJUnit.assertEquals("multiply", result, 0x7027409c00000000l); }
@Test
public void test01597() { x = 0x000000007fffffffl; long result = x * 0x6000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffa000000000l); }
@Test
public void test01598() { x = 0x0000000080000000l; long result = x * 0x6000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01599() { x = 0x00000000ffffffffl; long result = x * 0x6000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffa000000000l); }
@Test
public void test01600() { x = 0x000000017fffffffl; long result = x * 0x6000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffa000000000l); }
@Test
public void test01601() { x = 0x0000000180000000l; long result = x * 0x6000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01602() { x = 0x00000001ffffffffl; long result = x * 0x6000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffa000000000l); }
@Test
public void test01603() { x = 0xffffffff7fffffffl; long result = x * 0x6000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffa000000000l); }
@Test
public void test01604() { x = 0xffffffff80000000l; long result = x * 0x6000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01605() { x = 0x00000001deadf00dl; long result = x * 0x6000000000l; AssertJUnit.assertEquals("multiply", result, 0x813a04e000000000l); }
@Test
public void test01606() { x = 0xffffffffdeadf00dl; long result = x * 0x6000000000l; AssertJUnit.assertEquals("multiply", result, 0x813a04e000000000l); }
@Test
public void test01607() { x = 0x7fffffffffffffffl; long result = x * 0x6000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffa000000000l); }
@Test
public void test01608() { x = 0x7fffffff7fffffffl; long result = x * 0x6000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffa000000000l); }
@Test
public void test01609() { x = 0x7fffffff80000000l; long result = x * 0x6000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01610() { x = 0x7fffffffdeadf00dl; long result = x * 0x6000000000l; AssertJUnit.assertEquals("multiply", result, 0x813a04e000000000l); }
@Test
public void test01611() { x = 0x8000000000000000l; long result = x * 0x6000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01612() { x = 0xffffffffffffffffl; long result = x * 0x6000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffa000000000l); }
@Test
public void test01613() { x = 0xfffffffffffffffel; long result = x * 0x6000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff4000000000l); }
@Test
public void test01614() { x = 0xefffffffffffffffl; long result = x * 0x6000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffa000000000l); }
@Test
public void test01615() { x = 0xdeadf00ddeadf00dl; long result = x * 0x6000000000l; AssertJUnit.assertEquals("multiply", result, 0x813a04e000000000l); }
@Test
public void test01616() { x = 0x000000007fffffffl; long result = x * 0xfffffffffffffff4l; AssertJUnit.assertEquals("multiply", result, 0xfffffffa0000000cl); }
@Test
public void test01617() { x = 0x0000000080000000l; long result = x * 0xfffffffffffffff4l; AssertJUnit.assertEquals("multiply", result, 0xfffffffa00000000l); }
@Test
public void test01618() { x = 0x00000000ffffffffl; long result = x * 0xfffffffffffffff4l; AssertJUnit.assertEquals("multiply", result, 0xfffffff40000000cl); }
@Test
public void test01619() { x = 0x000000017fffffffl; long result = x * 0xfffffffffffffff4l; AssertJUnit.assertEquals("multiply", result, 0xffffffee0000000cl); }
@Test
public void test01620() { x = 0x0000000180000000l; long result = x * 0xfffffffffffffff4l; AssertJUnit.assertEquals("multiply", result, 0xffffffee00000000l); }
@Test
public void test01621() { x = 0x00000001ffffffffl; long result = x * 0xfffffffffffffff4l; AssertJUnit.assertEquals("multiply", result, 0xffffffe80000000cl); }
@Test
public void test01622() { x = 0xffffffff7fffffffl; long result = x * 0xfffffffffffffff4l; AssertJUnit.assertEquals("multiply", result, 0x000000060000000cl); }
@Test
public void test01623() { x = 0xffffffff80000000l; long result = x * 0xfffffffffffffff4l; AssertJUnit.assertEquals("multiply", result, 0x0000000600000000l); }
@Test
public void test01624() { x = 0x00000001deadf00dl; long result = x * 0xfffffffffffffff4l; AssertJUnit.assertEquals("multiply", result, 0xffffffe98fd8bf64l); }
@Test
public void test01625() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffffffffffff4l; AssertJUnit.assertEquals("multiply", result, 0x000000018fd8bf64l); }
@Test
public void test01626() { x = 0x7fffffffffffffffl; long result = x * 0xfffffffffffffff4l; AssertJUnit.assertEquals("multiply", result, 0x000000000000000cl); }
@Test
public void test01627() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffffffffffff4l; AssertJUnit.assertEquals("multiply", result, 0x000000060000000cl); }
@Test
public void test01628() { x = 0x7fffffff80000000l; long result = x * 0xfffffffffffffff4l; AssertJUnit.assertEquals("multiply", result, 0x0000000600000000l); }
@Test
public void test01629() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffffffffffff4l; AssertJUnit.assertEquals("multiply", result, 0x000000018fd8bf64l); }
@Test
public void test01630() { x = 0x8000000000000000l; long result = x * 0xfffffffffffffff4l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01631() { x = 0xffffffffffffffffl; long result = x * 0xfffffffffffffff4l; AssertJUnit.assertEquals("multiply", result, 0x000000000000000cl); }
@Test
public void test01632() { x = 0xfffffffffffffffel; long result = x * 0xfffffffffffffff4l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000018l); }
@Test
public void test01633() { x = 0xefffffffffffffffl; long result = x * 0xfffffffffffffff4l; AssertJUnit.assertEquals("multiply", result, 0xc00000000000000cl); }
@Test
public void test01634() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffffffffffff4l; AssertJUnit.assertEquals("multiply", result, 0x8fd8bf598fd8bf64l); }
@Test
public void test01635() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffffa0l; AssertJUnit.assertEquals("multiply", result, 0xffffffd000000060l); }
@Test
public void test01636() { x = 0x0000000080000000l; long result = x * 0xffffffffffffffa0l; AssertJUnit.assertEquals("multiply", result, 0xffffffd000000000l); }
@Test
public void test01637() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffffa0l; AssertJUnit.assertEquals("multiply", result, 0xffffffa000000060l); }
@Test
public void test01638() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffffa0l; AssertJUnit.assertEquals("multiply", result, 0xffffff7000000060l); }
@Test
public void test01639() { x = 0x0000000180000000l; long result = x * 0xffffffffffffffa0l; AssertJUnit.assertEquals("multiply", result, 0xffffff7000000000l); }
@Test
public void test01640() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffffa0l; AssertJUnit.assertEquals("multiply", result, 0xffffff4000000060l); }
@Test
public void test01641() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffffa0l; AssertJUnit.assertEquals("multiply", result, 0x0000003000000060l); }
@Test
public void test01642() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffffa0l; AssertJUnit.assertEquals("multiply", result, 0x0000003000000000l); }
@Test
public void test01643() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffffa0l; AssertJUnit.assertEquals("multiply", result, 0xffffff4c7ec5fb20l); }
@Test
public void test01644() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffffa0l; AssertJUnit.assertEquals("multiply", result, 0x0000000c7ec5fb20l); }
@Test
public void test01645() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffffa0l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000060l); }
@Test
public void test01646() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffffa0l; AssertJUnit.assertEquals("multiply", result, 0x0000003000000060l); }
@Test
public void test01647() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffffa0l; AssertJUnit.assertEquals("multiply", result, 0x0000003000000000l); }
@Test
public void test01648() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffffa0l; AssertJUnit.assertEquals("multiply", result, 0x0000000c7ec5fb20l); }
@Test
public void test01649() { x = 0x8000000000000000l; long result = x * 0xffffffffffffffa0l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01650() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffffa0l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000060l); }
@Test
public void test01651() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffffa0l; AssertJUnit.assertEquals("multiply", result, 0x00000000000000c0l); }
@Test
public void test01652() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffffa0l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000060l); }
@Test
public void test01653() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffffa0l; AssertJUnit.assertEquals("multiply", result, 0x7ec5facc7ec5fb20l); }
@Test
public void test01654() { x = 0x000000007fffffffl; long result = x * 0xfffffffffffff400l; AssertJUnit.assertEquals("multiply", result, 0xfffffa0000000c00l); }
@Test
public void test01655() { x = 0x0000000080000000l; long result = x * 0xfffffffffffff400l; AssertJUnit.assertEquals("multiply", result, 0xfffffa0000000000l); }
@Test
public void test01656() { x = 0x00000000ffffffffl; long result = x * 0xfffffffffffff400l; AssertJUnit.assertEquals("multiply", result, 0xfffff40000000c00l); }
@Test
public void test01657() { x = 0x000000017fffffffl; long result = x * 0xfffffffffffff400l; AssertJUnit.assertEquals("multiply", result, 0xffffee0000000c00l); }
@Test
public void test01658() { x = 0x0000000180000000l; long result = x * 0xfffffffffffff400l; AssertJUnit.assertEquals("multiply", result, 0xffffee0000000000l); }
@Test
public void test01659() { x = 0x00000001ffffffffl; long result = x * 0xfffffffffffff400l; AssertJUnit.assertEquals("multiply", result, 0xffffe80000000c00l); }
@Test
public void test01660() { x = 0xffffffff7fffffffl; long result = x * 0xfffffffffffff400l; AssertJUnit.assertEquals("multiply", result, 0x0000060000000c00l); }
@Test
public void test01661() { x = 0xffffffff80000000l; long result = x * 0xfffffffffffff400l; AssertJUnit.assertEquals("multiply", result, 0x0000060000000000l); }
@Test
public void test01662() { x = 0x00000001deadf00dl; long result = x * 0xfffffffffffff400l; AssertJUnit.assertEquals("multiply", result, 0xffffe98fd8bf6400l); }
@Test
public void test01663() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffffffffff400l; AssertJUnit.assertEquals("multiply", result, 0x0000018fd8bf6400l); }
@Test
public void test01664() { x = 0x7fffffffffffffffl; long result = x * 0xfffffffffffff400l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000c00l); }
@Test
public void test01665() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffffffffff400l; AssertJUnit.assertEquals("multiply", result, 0x0000060000000c00l); }
@Test
public void test01666() { x = 0x7fffffff80000000l; long result = x * 0xfffffffffffff400l; AssertJUnit.assertEquals("multiply", result, 0x0000060000000000l); }
@Test
public void test01667() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffffffffff400l; AssertJUnit.assertEquals("multiply", result, 0x0000018fd8bf6400l); }
@Test
public void test01668() { x = 0x8000000000000000l; long result = x * 0xfffffffffffff400l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01669() { x = 0xffffffffffffffffl; long result = x * 0xfffffffffffff400l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000c00l); }
@Test
public void test01670() { x = 0xfffffffffffffffel; long result = x * 0xfffffffffffff400l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001800l); }
@Test
public void test01671() { x = 0xefffffffffffffffl; long result = x * 0xfffffffffffff400l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000c00l); }
@Test
public void test01672() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffffffffff400l; AssertJUnit.assertEquals("multiply", result, 0xd8bf598fd8bf6400l); }
@Test
public void test01673() { x = 0x000000007fffffffl; long result = x * 0xfffffff400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000c00000000l); }
@Test
public void test01674() { x = 0x0000000080000000l; long result = x * 0xfffffff400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01675() { x = 0x00000000ffffffffl; long result = x * 0xfffffff400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000c00000000l); }
@Test
public void test01676() { x = 0x000000017fffffffl; long result = x * 0xfffffff400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000c00000000l); }
@Test
public void test01677() { x = 0x0000000180000000l; long result = x * 0xfffffff400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01678() { x = 0x00000001ffffffffl; long result = x * 0xfffffff400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000c00000000l); }
@Test
public void test01679() { x = 0xffffffff7fffffffl; long result = x * 0xfffffff400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000c00000000l); }
@Test
public void test01680() { x = 0xffffffff80000000l; long result = x * 0xfffffff400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01681() { x = 0x00000001deadf00dl; long result = x * 0xfffffff400000000l; AssertJUnit.assertEquals("multiply", result, 0x8fd8bf6400000000l); }
@Test
public void test01682() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffff400000000l; AssertJUnit.assertEquals("multiply", result, 0x8fd8bf6400000000l); }
@Test
public void test01683() { x = 0x7fffffffffffffffl; long result = x * 0xfffffff400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000c00000000l); }
@Test
public void test01684() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffff400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000c00000000l); }
@Test
public void test01685() { x = 0x7fffffff80000000l; long result = x * 0xfffffff400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01686() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffff400000000l; AssertJUnit.assertEquals("multiply", result, 0x8fd8bf6400000000l); }
@Test
public void test01687() { x = 0x8000000000000000l; long result = x * 0xfffffff400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01688() { x = 0xffffffffffffffffl; long result = x * 0xfffffff400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000c00000000l); }
@Test
public void test01689() { x = 0xfffffffffffffffel; long result = x * 0xfffffff400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001800000000l); }
@Test
public void test01690() { x = 0xefffffffffffffffl; long result = x * 0xfffffff400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000c00000000l); }
@Test
public void test01691() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffff400000000l; AssertJUnit.assertEquals("multiply", result, 0x8fd8bf6400000000l); }
@Test
public void test01692() { x = 0x000000007fffffffl; long result = x * 0xffffffa000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000006000000000l); }
@Test
public void test01693() { x = 0x0000000080000000l; long result = x * 0xffffffa000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01694() { x = 0x00000000ffffffffl; long result = x * 0xffffffa000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000006000000000l); }
@Test
public void test01695() { x = 0x000000017fffffffl; long result = x * 0xffffffa000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000006000000000l); }
@Test
public void test01696() { x = 0x0000000180000000l; long result = x * 0xffffffa000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01697() { x = 0x00000001ffffffffl; long result = x * 0xffffffa000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000006000000000l); }
@Test
public void test01698() { x = 0xffffffff7fffffffl; long result = x * 0xffffffa000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000006000000000l); }
@Test
public void test01699() { x = 0xffffffff80000000l; long result = x * 0xffffffa000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01700() { x = 0x00000001deadf00dl; long result = x * 0xffffffa000000000l; AssertJUnit.assertEquals("multiply", result, 0x7ec5fb2000000000l); }
@Test
public void test01701() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffa000000000l; AssertJUnit.assertEquals("multiply", result, 0x7ec5fb2000000000l); }
@Test
public void test01702() { x = 0x7fffffffffffffffl; long result = x * 0xffffffa000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000006000000000l); }
@Test
public void test01703() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffa000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000006000000000l); }
@Test
public void test01704() { x = 0x7fffffff80000000l; long result = x * 0xffffffa000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01705() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffa000000000l; AssertJUnit.assertEquals("multiply", result, 0x7ec5fb2000000000l); }
@Test
public void test01706() { x = 0x8000000000000000l; long result = x * 0xffffffa000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01707() { x = 0xffffffffffffffffl; long result = x * 0xffffffa000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000006000000000l); }
@Test
public void test01708() { x = 0xfffffffffffffffel; long result = x * 0xffffffa000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000c000000000l); }
@Test
public void test01709() { x = 0xefffffffffffffffl; long result = x * 0xffffffa000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000006000000000l); }
@Test
public void test01710() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffa000000000l; AssertJUnit.assertEquals("multiply", result, 0x7ec5fb2000000000l); }
@Test
public void test01711() { x = 0x000000007fffffffl; long result = x * 0xdl; AssertJUnit.assertEquals("multiply", result, 0x000000067ffffff3l); }
@Test
public void test01712() { x = 0x0000000080000000l; long result = x * 0xdl; AssertJUnit.assertEquals("multiply", result, 0x0000000680000000l); }
@Test
public void test01713() { x = 0x00000000ffffffffl; long result = x * 0xdl; AssertJUnit.assertEquals("multiply", result, 0x0000000cfffffff3l); }
@Test
public void test01714() { x = 0x000000017fffffffl; long result = x * 0xdl; AssertJUnit.assertEquals("multiply", result, 0x000000137ffffff3l); }
@Test
public void test01715() { x = 0x0000000180000000l; long result = x * 0xdl; AssertJUnit.assertEquals("multiply", result, 0x0000001380000000l); }
@Test
public void test01716() { x = 0x00000001ffffffffl; long result = x * 0xdl; AssertJUnit.assertEquals("multiply", result, 0x00000019fffffff3l); }
@Test
public void test01717() { x = 0xffffffff7fffffffl; long result = x * 0xdl; AssertJUnit.assertEquals("multiply", result, 0xfffffff97ffffff3l); }
@Test
public void test01718() { x = 0xffffffff80000000l; long result = x * 0xdl; AssertJUnit.assertEquals("multiply", result, 0xfffffff980000000l); }
@Test
public void test01719() { x = 0x00000001deadf00dl; long result = x * 0xdl; AssertJUnit.assertEquals("multiply", result, 0x000000184ed530a9l); }
@Test
public void test01720() { x = 0xffffffffdeadf00dl; long result = x * 0xdl; AssertJUnit.assertEquals("multiply", result, 0xfffffffe4ed530a9l); }
@Test
public void test01721() { x = 0x7fffffffffffffffl; long result = x * 0xdl; AssertJUnit.assertEquals("multiply", result, 0x7ffffffffffffff3l); }
@Test
public void test01722() { x = 0x7fffffff7fffffffl; long result = x * 0xdl; AssertJUnit.assertEquals("multiply", result, 0x7ffffff97ffffff3l); }
@Test
public void test01723() { x = 0x7fffffff80000000l; long result = x * 0xdl; AssertJUnit.assertEquals("multiply", result, 0x7ffffff980000000l); }
@Test
public void test01724() { x = 0x7fffffffdeadf00dl; long result = x * 0xdl; AssertJUnit.assertEquals("multiply", result, 0x7ffffffe4ed530a9l); }
@Test
public void test01725() { x = 0x8000000000000000l; long result = x * 0xdl; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test01726() { x = 0xffffffffffffffffl; long result = x * 0xdl; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffff3l); }
@Test
public void test01727() { x = 0xfffffffffffffffel; long result = x * 0xdl; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffe6l); }
@Test
public void test01728() { x = 0xefffffffffffffffl; long result = x * 0xdl; AssertJUnit.assertEquals("multiply", result, 0x2ffffffffffffff3l); }
@Test
public void test01729() { x = 0xdeadf00ddeadf00dl; long result = x * 0xdl; AssertJUnit.assertEquals("multiply", result, 0x4ed530b44ed530a9l); }
@Test
public void test01730() { x = 0x000000007fffffffl; long result = x * 0x68l; AssertJUnit.assertEquals("multiply", result, 0x00000033ffffff98l); }
@Test
public void test01731() { x = 0x0000000080000000l; long result = x * 0x68l; AssertJUnit.assertEquals("multiply", result, 0x0000003400000000l); }
@Test
public void test01732() { x = 0x00000000ffffffffl; long result = x * 0x68l; AssertJUnit.assertEquals("multiply", result, 0x00000067ffffff98l); }
@Test
public void test01733() { x = 0x000000017fffffffl; long result = x * 0x68l; AssertJUnit.assertEquals("multiply", result, 0x0000009bffffff98l); }
@Test
public void test01734() { x = 0x0000000180000000l; long result = x * 0x68l; AssertJUnit.assertEquals("multiply", result, 0x0000009c00000000l); }
@Test
public void test01735() { x = 0x00000001ffffffffl; long result = x * 0x68l; AssertJUnit.assertEquals("multiply", result, 0x000000cfffffff98l); }
@Test
public void test01736() { x = 0xffffffff7fffffffl; long result = x * 0x68l; AssertJUnit.assertEquals("multiply", result, 0xffffffcbffffff98l); }
@Test
public void test01737() { x = 0xffffffff80000000l; long result = x * 0x68l; AssertJUnit.assertEquals("multiply", result, 0xffffffcc00000000l); }
@Test
public void test01738() { x = 0x00000001deadf00dl; long result = x * 0x68l; AssertJUnit.assertEquals("multiply", result, 0x000000c276a98548l); }
@Test
public void test01739() { x = 0xffffffffdeadf00dl; long result = x * 0x68l; AssertJUnit.assertEquals("multiply", result, 0xfffffff276a98548l); }
@Test
public void test01740() { x = 0x7fffffffffffffffl; long result = x * 0x68l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff98l); }
@Test
public void test01741() { x = 0x7fffffff7fffffffl; long result = x * 0x68l; AssertJUnit.assertEquals("multiply", result, 0xffffffcbffffff98l); }
@Test
public void test01742() { x = 0x7fffffff80000000l; long result = x * 0x68l; AssertJUnit.assertEquals("multiply", result, 0xffffffcc00000000l); }
@Test
public void test01743() { x = 0x7fffffffdeadf00dl; long result = x * 0x68l; AssertJUnit.assertEquals("multiply", result, 0xfffffff276a98548l); }
@Test
public void test01744() { x = 0x8000000000000000l; long result = x * 0x68l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01745() { x = 0xffffffffffffffffl; long result = x * 0x68l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff98l); }
@Test
public void test01746() { x = 0xfffffffffffffffel; long result = x * 0x68l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff30l); }
@Test
public void test01747() { x = 0xefffffffffffffffl; long result = x * 0x68l; AssertJUnit.assertEquals("multiply", result, 0x7fffffffffffff98l); }
@Test
public void test01748() { x = 0xdeadf00ddeadf00dl; long result = x * 0x68l; AssertJUnit.assertEquals("multiply", result, 0x76a985a276a98548l); }
@Test
public void test01749() { x = 0x000000007fffffffl; long result = x * 0xd00l; AssertJUnit.assertEquals("multiply", result, 0x0000067ffffff300l); }
@Test
public void test01750() { x = 0x0000000080000000l; long result = x * 0xd00l; AssertJUnit.assertEquals("multiply", result, 0x0000068000000000l); }
@Test
public void test01751() { x = 0x00000000ffffffffl; long result = x * 0xd00l; AssertJUnit.assertEquals("multiply", result, 0x00000cfffffff300l); }
@Test
public void test01752() { x = 0x000000017fffffffl; long result = x * 0xd00l; AssertJUnit.assertEquals("multiply", result, 0x0000137ffffff300l); }
@Test
public void test01753() { x = 0x0000000180000000l; long result = x * 0xd00l; AssertJUnit.assertEquals("multiply", result, 0x0000138000000000l); }
@Test
public void test01754() { x = 0x00000001ffffffffl; long result = x * 0xd00l; AssertJUnit.assertEquals("multiply", result, 0x000019fffffff300l); }
@Test
public void test01755() { x = 0xffffffff7fffffffl; long result = x * 0xd00l; AssertJUnit.assertEquals("multiply", result, 0xfffff97ffffff300l); }
@Test
public void test01756() { x = 0xffffffff80000000l; long result = x * 0xd00l; AssertJUnit.assertEquals("multiply", result, 0xfffff98000000000l); }
@Test
public void test01757() { x = 0x00000001deadf00dl; long result = x * 0xd00l; AssertJUnit.assertEquals("multiply", result, 0x0000184ed530a900l); }
@Test
public void test01758() { x = 0xffffffffdeadf00dl; long result = x * 0xd00l; AssertJUnit.assertEquals("multiply", result, 0xfffffe4ed530a900l); }
@Test
public void test01759() { x = 0x7fffffffffffffffl; long result = x * 0xd00l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffff300l); }
@Test
public void test01760() { x = 0x7fffffff7fffffffl; long result = x * 0xd00l; AssertJUnit.assertEquals("multiply", result, 0xfffff97ffffff300l); }
@Test
public void test01761() { x = 0x7fffffff80000000l; long result = x * 0xd00l; AssertJUnit.assertEquals("multiply", result, 0xfffff98000000000l); }
@Test
public void test01762() { x = 0x7fffffffdeadf00dl; long result = x * 0xd00l; AssertJUnit.assertEquals("multiply", result, 0xfffffe4ed530a900l); }
@Test
public void test01763() { x = 0x8000000000000000l; long result = x * 0xd00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01764() { x = 0xffffffffffffffffl; long result = x * 0xd00l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffff300l); }
@Test
public void test01765() { x = 0xfffffffffffffffel; long result = x * 0xd00l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffe600l); }
@Test
public void test01766() { x = 0xefffffffffffffffl; long result = x * 0xd00l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffff300l); }
@Test
public void test01767() { x = 0xdeadf00ddeadf00dl; long result = x * 0xd00l; AssertJUnit.assertEquals("multiply", result, 0xd530b44ed530a900l); }
@Test
public void test01768() { x = 0x000000007fffffffl; long result = x * 0xd00000000l; AssertJUnit.assertEquals("multiply", result, 0x7ffffff300000000l); }
@Test
public void test01769() { x = 0x0000000080000000l; long result = x * 0xd00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test01770() { x = 0x00000000ffffffffl; long result = x * 0xd00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff300000000l); }
@Test
public void test01771() { x = 0x000000017fffffffl; long result = x * 0xd00000000l; AssertJUnit.assertEquals("multiply", result, 0x7ffffff300000000l); }
@Test
public void test01772() { x = 0x0000000180000000l; long result = x * 0xd00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test01773() { x = 0x00000001ffffffffl; long result = x * 0xd00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff300000000l); }
@Test
public void test01774() { x = 0xffffffff7fffffffl; long result = x * 0xd00000000l; AssertJUnit.assertEquals("multiply", result, 0x7ffffff300000000l); }
@Test
public void test01775() { x = 0xffffffff80000000l; long result = x * 0xd00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test01776() { x = 0x00000001deadf00dl; long result = x * 0xd00000000l; AssertJUnit.assertEquals("multiply", result, 0x4ed530a900000000l); }
@Test
public void test01777() { x = 0xffffffffdeadf00dl; long result = x * 0xd00000000l; AssertJUnit.assertEquals("multiply", result, 0x4ed530a900000000l); }
@Test
public void test01778() { x = 0x7fffffffffffffffl; long result = x * 0xd00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff300000000l); }
@Test
public void test01779() { x = 0x7fffffff7fffffffl; long result = x * 0xd00000000l; AssertJUnit.assertEquals("multiply", result, 0x7ffffff300000000l); }
@Test
public void test01780() { x = 0x7fffffff80000000l; long result = x * 0xd00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test01781() { x = 0x7fffffffdeadf00dl; long result = x * 0xd00000000l; AssertJUnit.assertEquals("multiply", result, 0x4ed530a900000000l); }
@Test
public void test01782() { x = 0x8000000000000000l; long result = x * 0xd00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01783() { x = 0xffffffffffffffffl; long result = x * 0xd00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff300000000l); }
@Test
public void test01784() { x = 0xfffffffffffffffel; long result = x * 0xd00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe600000000l); }
@Test
public void test01785() { x = 0xefffffffffffffffl; long result = x * 0xd00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff300000000l); }
@Test
public void test01786() { x = 0xdeadf00ddeadf00dl; long result = x * 0xd00000000l; AssertJUnit.assertEquals("multiply", result, 0x4ed530a900000000l); }
@Test
public void test01787() { x = 0x000000007fffffffl; long result = x * 0x6800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff9800000000l); }
@Test
public void test01788() { x = 0x0000000080000000l; long result = x * 0x6800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01789() { x = 0x00000000ffffffffl; long result = x * 0x6800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff9800000000l); }
@Test
public void test01790() { x = 0x000000017fffffffl; long result = x * 0x6800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff9800000000l); }
@Test
public void test01791() { x = 0x0000000180000000l; long result = x * 0x6800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01792() { x = 0x00000001ffffffffl; long result = x * 0x6800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff9800000000l); }
@Test
public void test01793() { x = 0xffffffff7fffffffl; long result = x * 0x6800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff9800000000l); }
@Test
public void test01794() { x = 0xffffffff80000000l; long result = x * 0x6800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01795() { x = 0x00000001deadf00dl; long result = x * 0x6800000000l; AssertJUnit.assertEquals("multiply", result, 0x76a9854800000000l); }
@Test
public void test01796() { x = 0xffffffffdeadf00dl; long result = x * 0x6800000000l; AssertJUnit.assertEquals("multiply", result, 0x76a9854800000000l); }
@Test
public void test01797() { x = 0x7fffffffffffffffl; long result = x * 0x6800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff9800000000l); }
@Test
public void test01798() { x = 0x7fffffff7fffffffl; long result = x * 0x6800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff9800000000l); }
@Test
public void test01799() { x = 0x7fffffff80000000l; long result = x * 0x6800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01800() { x = 0x7fffffffdeadf00dl; long result = x * 0x6800000000l; AssertJUnit.assertEquals("multiply", result, 0x76a9854800000000l); }
@Test
public void test01801() { x = 0x8000000000000000l; long result = x * 0x6800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01802() { x = 0xffffffffffffffffl; long result = x * 0x6800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff9800000000l); }
@Test
public void test01803() { x = 0xfffffffffffffffel; long result = x * 0x6800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff3000000000l); }
@Test
public void test01804() { x = 0xefffffffffffffffl; long result = x * 0x6800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff9800000000l); }
@Test
public void test01805() { x = 0xdeadf00ddeadf00dl; long result = x * 0x6800000000l; AssertJUnit.assertEquals("multiply", result, 0x76a9854800000000l); }
@Test
public void test01806() { x = 0x000000007fffffffl; long result = x * 0xfffffffffffffff3l; AssertJUnit.assertEquals("multiply", result, 0xfffffff98000000dl); }
@Test
public void test01807() { x = 0x0000000080000000l; long result = x * 0xfffffffffffffff3l; AssertJUnit.assertEquals("multiply", result, 0xfffffff980000000l); }
@Test
public void test01808() { x = 0x00000000ffffffffl; long result = x * 0xfffffffffffffff3l; AssertJUnit.assertEquals("multiply", result, 0xfffffff30000000dl); }
@Test
public void test01809() { x = 0x000000017fffffffl; long result = x * 0xfffffffffffffff3l; AssertJUnit.assertEquals("multiply", result, 0xffffffec8000000dl); }
@Test
public void test01810() { x = 0x0000000180000000l; long result = x * 0xfffffffffffffff3l; AssertJUnit.assertEquals("multiply", result, 0xffffffec80000000l); }
@Test
public void test01811() { x = 0x00000001ffffffffl; long result = x * 0xfffffffffffffff3l; AssertJUnit.assertEquals("multiply", result, 0xffffffe60000000dl); }
@Test
public void test01812() { x = 0xffffffff7fffffffl; long result = x * 0xfffffffffffffff3l; AssertJUnit.assertEquals("multiply", result, 0x000000068000000dl); }
@Test
public void test01813() { x = 0xffffffff80000000l; long result = x * 0xfffffffffffffff3l; AssertJUnit.assertEquals("multiply", result, 0x0000000680000000l); }
@Test
public void test01814() { x = 0x00000001deadf00dl; long result = x * 0xfffffffffffffff3l; AssertJUnit.assertEquals("multiply", result, 0xffffffe7b12acf57l); }
@Test
public void test01815() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffffffffffff3l; AssertJUnit.assertEquals("multiply", result, 0x00000001b12acf57l); }
@Test
public void test01816() { x = 0x7fffffffffffffffl; long result = x * 0xfffffffffffffff3l; AssertJUnit.assertEquals("multiply", result, 0x800000000000000dl); }
@Test
public void test01817() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffffffffffff3l; AssertJUnit.assertEquals("multiply", result, 0x800000068000000dl); }
@Test
public void test01818() { x = 0x7fffffff80000000l; long result = x * 0xfffffffffffffff3l; AssertJUnit.assertEquals("multiply", result, 0x8000000680000000l); }
@Test
public void test01819() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffffffffffff3l; AssertJUnit.assertEquals("multiply", result, 0x80000001b12acf57l); }
@Test
public void test01820() { x = 0x8000000000000000l; long result = x * 0xfffffffffffffff3l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test01821() { x = 0xffffffffffffffffl; long result = x * 0xfffffffffffffff3l; AssertJUnit.assertEquals("multiply", result, 0x000000000000000dl); }
@Test
public void test01822() { x = 0xfffffffffffffffel; long result = x * 0xfffffffffffffff3l; AssertJUnit.assertEquals("multiply", result, 0x000000000000001al); }
@Test
public void test01823() { x = 0xefffffffffffffffl; long result = x * 0xfffffffffffffff3l; AssertJUnit.assertEquals("multiply", result, 0xd00000000000000dl); }
@Test
public void test01824() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffffffffffff3l; AssertJUnit.assertEquals("multiply", result, 0xb12acf4bb12acf57l); }
@Test
public void test01825() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffff98l; AssertJUnit.assertEquals("multiply", result, 0xffffffcc00000068l); }
@Test
public void test01826() { x = 0x0000000080000000l; long result = x * 0xffffffffffffff98l; AssertJUnit.assertEquals("multiply", result, 0xffffffcc00000000l); }
@Test
public void test01827() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffff98l; AssertJUnit.assertEquals("multiply", result, 0xffffff9800000068l); }
@Test
public void test01828() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffff98l; AssertJUnit.assertEquals("multiply", result, 0xffffff6400000068l); }
@Test
public void test01829() { x = 0x0000000180000000l; long result = x * 0xffffffffffffff98l; AssertJUnit.assertEquals("multiply", result, 0xffffff6400000000l); }
@Test
public void test01830() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffff98l; AssertJUnit.assertEquals("multiply", result, 0xffffff3000000068l); }
@Test
public void test01831() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffff98l; AssertJUnit.assertEquals("multiply", result, 0x0000003400000068l); }
@Test
public void test01832() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffff98l; AssertJUnit.assertEquals("multiply", result, 0x0000003400000000l); }
@Test
public void test01833() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffff98l; AssertJUnit.assertEquals("multiply", result, 0xffffff3d89567ab8l); }
@Test
public void test01834() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffff98l; AssertJUnit.assertEquals("multiply", result, 0x0000000d89567ab8l); }
@Test
public void test01835() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffff98l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000068l); }
@Test
public void test01836() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffff98l; AssertJUnit.assertEquals("multiply", result, 0x0000003400000068l); }
@Test
public void test01837() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffff98l; AssertJUnit.assertEquals("multiply", result, 0x0000003400000000l); }
@Test
public void test01838() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffff98l; AssertJUnit.assertEquals("multiply", result, 0x0000000d89567ab8l); }
@Test
public void test01839() { x = 0x8000000000000000l; long result = x * 0xffffffffffffff98l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01840() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffff98l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000068l); }
@Test
public void test01841() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffff98l; AssertJUnit.assertEquals("multiply", result, 0x00000000000000d0l); }
@Test
public void test01842() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffff98l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000068l); }
@Test
public void test01843() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffff98l; AssertJUnit.assertEquals("multiply", result, 0x89567a5d89567ab8l); }
@Test
public void test01844() { x = 0x000000007fffffffl; long result = x * 0xfffffffffffff300l; AssertJUnit.assertEquals("multiply", result, 0xfffff98000000d00l); }
@Test
public void test01845() { x = 0x0000000080000000l; long result = x * 0xfffffffffffff300l; AssertJUnit.assertEquals("multiply", result, 0xfffff98000000000l); }
@Test
public void test01846() { x = 0x00000000ffffffffl; long result = x * 0xfffffffffffff300l; AssertJUnit.assertEquals("multiply", result, 0xfffff30000000d00l); }
@Test
public void test01847() { x = 0x000000017fffffffl; long result = x * 0xfffffffffffff300l; AssertJUnit.assertEquals("multiply", result, 0xffffec8000000d00l); }
@Test
public void test01848() { x = 0x0000000180000000l; long result = x * 0xfffffffffffff300l; AssertJUnit.assertEquals("multiply", result, 0xffffec8000000000l); }
@Test
public void test01849() { x = 0x00000001ffffffffl; long result = x * 0xfffffffffffff300l; AssertJUnit.assertEquals("multiply", result, 0xffffe60000000d00l); }
@Test
public void test01850() { x = 0xffffffff7fffffffl; long result = x * 0xfffffffffffff300l; AssertJUnit.assertEquals("multiply", result, 0x0000068000000d00l); }
@Test
public void test01851() { x = 0xffffffff80000000l; long result = x * 0xfffffffffffff300l; AssertJUnit.assertEquals("multiply", result, 0x0000068000000000l); }
@Test
public void test01852() { x = 0x00000001deadf00dl; long result = x * 0xfffffffffffff300l; AssertJUnit.assertEquals("multiply", result, 0xffffe7b12acf5700l); }
@Test
public void test01853() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffffffffff300l; AssertJUnit.assertEquals("multiply", result, 0x000001b12acf5700l); }
@Test
public void test01854() { x = 0x7fffffffffffffffl; long result = x * 0xfffffffffffff300l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000d00l); }
@Test
public void test01855() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffffffffff300l; AssertJUnit.assertEquals("multiply", result, 0x0000068000000d00l); }
@Test
public void test01856() { x = 0x7fffffff80000000l; long result = x * 0xfffffffffffff300l; AssertJUnit.assertEquals("multiply", result, 0x0000068000000000l); }
@Test
public void test01857() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffffffffff300l; AssertJUnit.assertEquals("multiply", result, 0x000001b12acf5700l); }
@Test
public void test01858() { x = 0x8000000000000000l; long result = x * 0xfffffffffffff300l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01859() { x = 0xffffffffffffffffl; long result = x * 0xfffffffffffff300l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000d00l); }
@Test
public void test01860() { x = 0xfffffffffffffffel; long result = x * 0xfffffffffffff300l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001a00l); }
@Test
public void test01861() { x = 0xefffffffffffffffl; long result = x * 0xfffffffffffff300l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000d00l); }
@Test
public void test01862() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffffffffff300l; AssertJUnit.assertEquals("multiply", result, 0x2acf4bb12acf5700l); }
@Test
public void test01863() { x = 0x000000007fffffffl; long result = x * 0xfffffff300000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000d00000000l); }
@Test
public void test01864() { x = 0x0000000080000000l; long result = x * 0xfffffff300000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test01865() { x = 0x00000000ffffffffl; long result = x * 0xfffffff300000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000d00000000l); }
@Test
public void test01866() { x = 0x000000017fffffffl; long result = x * 0xfffffff300000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000d00000000l); }
@Test
public void test01867() { x = 0x0000000180000000l; long result = x * 0xfffffff300000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test01868() { x = 0x00000001ffffffffl; long result = x * 0xfffffff300000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000d00000000l); }
@Test
public void test01869() { x = 0xffffffff7fffffffl; long result = x * 0xfffffff300000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000d00000000l); }
@Test
public void test01870() { x = 0xffffffff80000000l; long result = x * 0xfffffff300000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test01871() { x = 0x00000001deadf00dl; long result = x * 0xfffffff300000000l; AssertJUnit.assertEquals("multiply", result, 0xb12acf5700000000l); }
@Test
public void test01872() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffff300000000l; AssertJUnit.assertEquals("multiply", result, 0xb12acf5700000000l); }
@Test
public void test01873() { x = 0x7fffffffffffffffl; long result = x * 0xfffffff300000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000d00000000l); }
@Test
public void test01874() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffff300000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000d00000000l); }
@Test
public void test01875() { x = 0x7fffffff80000000l; long result = x * 0xfffffff300000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test01876() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffff300000000l; AssertJUnit.assertEquals("multiply", result, 0xb12acf5700000000l); }
@Test
public void test01877() { x = 0x8000000000000000l; long result = x * 0xfffffff300000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01878() { x = 0xffffffffffffffffl; long result = x * 0xfffffff300000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000d00000000l); }
@Test
public void test01879() { x = 0xfffffffffffffffel; long result = x * 0xfffffff300000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001a00000000l); }
@Test
public void test01880() { x = 0xefffffffffffffffl; long result = x * 0xfffffff300000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000d00000000l); }
@Test
public void test01881() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffff300000000l; AssertJUnit.assertEquals("multiply", result, 0xb12acf5700000000l); }
@Test
public void test01882() { x = 0x000000007fffffffl; long result = x * 0xffffff9800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000006800000000l); }
@Test
public void test01883() { x = 0x0000000080000000l; long result = x * 0xffffff9800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01884() { x = 0x00000000ffffffffl; long result = x * 0xffffff9800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000006800000000l); }
@Test
public void test01885() { x = 0x000000017fffffffl; long result = x * 0xffffff9800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000006800000000l); }
@Test
public void test01886() { x = 0x0000000180000000l; long result = x * 0xffffff9800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01887() { x = 0x00000001ffffffffl; long result = x * 0xffffff9800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000006800000000l); }
@Test
public void test01888() { x = 0xffffffff7fffffffl; long result = x * 0xffffff9800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000006800000000l); }
@Test
public void test01889() { x = 0xffffffff80000000l; long result = x * 0xffffff9800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01890() { x = 0x00000001deadf00dl; long result = x * 0xffffff9800000000l; AssertJUnit.assertEquals("multiply", result, 0x89567ab800000000l); }
@Test
public void test01891() { x = 0xffffffffdeadf00dl; long result = x * 0xffffff9800000000l; AssertJUnit.assertEquals("multiply", result, 0x89567ab800000000l); }
@Test
public void test01892() { x = 0x7fffffffffffffffl; long result = x * 0xffffff9800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000006800000000l); }
@Test
public void test01893() { x = 0x7fffffff7fffffffl; long result = x * 0xffffff9800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000006800000000l); }
@Test
public void test01894() { x = 0x7fffffff80000000l; long result = x * 0xffffff9800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01895() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffff9800000000l; AssertJUnit.assertEquals("multiply", result, 0x89567ab800000000l); }
@Test
public void test01896() { x = 0x8000000000000000l; long result = x * 0xffffff9800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01897() { x = 0xffffffffffffffffl; long result = x * 0xffffff9800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000006800000000l); }
@Test
public void test01898() { x = 0xfffffffffffffffel; long result = x * 0xffffff9800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000d000000000l); }
@Test
public void test01899() { x = 0xefffffffffffffffl; long result = x * 0xffffff9800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000006800000000l); }
@Test
public void test01900() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffff9800000000l; AssertJUnit.assertEquals("multiply", result, 0x89567ab800000000l); }
@Test
public void test01901() { x = 0x000000007fffffffl; long result = x * 0xel; AssertJUnit.assertEquals("multiply", result, 0x00000006fffffff2l); }
@Test
public void test01902() { x = 0x0000000080000000l; long result = x * 0xel; AssertJUnit.assertEquals("multiply", result, 0x0000000700000000l); }
@Test
public void test01903() { x = 0x00000000ffffffffl; long result = x * 0xel; AssertJUnit.assertEquals("multiply", result, 0x0000000dfffffff2l); }
@Test
public void test01904() { x = 0x000000017fffffffl; long result = x * 0xel; AssertJUnit.assertEquals("multiply", result, 0x00000014fffffff2l); }
@Test
public void test01905() { x = 0x0000000180000000l; long result = x * 0xel; AssertJUnit.assertEquals("multiply", result, 0x0000001500000000l); }
@Test
public void test01906() { x = 0x00000001ffffffffl; long result = x * 0xel; AssertJUnit.assertEquals("multiply", result, 0x0000001bfffffff2l); }
@Test
public void test01907() { x = 0xffffffff7fffffffl; long result = x * 0xel; AssertJUnit.assertEquals("multiply", result, 0xfffffff8fffffff2l); }
@Test
public void test01908() { x = 0xffffffff80000000l; long result = x * 0xel; AssertJUnit.assertEquals("multiply", result, 0xfffffff900000000l); }
@Test
public void test01909() { x = 0x00000001deadf00dl; long result = x * 0xel; AssertJUnit.assertEquals("multiply", result, 0x0000001a2d8320b6l); }
@Test
public void test01910() { x = 0xffffffffdeadf00dl; long result = x * 0xel; AssertJUnit.assertEquals("multiply", result, 0xfffffffe2d8320b6l); }
@Test
public void test01911() { x = 0x7fffffffffffffffl; long result = x * 0xel; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffff2l); }
@Test
public void test01912() { x = 0x7fffffff7fffffffl; long result = x * 0xel; AssertJUnit.assertEquals("multiply", result, 0xfffffff8fffffff2l); }
@Test
public void test01913() { x = 0x7fffffff80000000l; long result = x * 0xel; AssertJUnit.assertEquals("multiply", result, 0xfffffff900000000l); }
@Test
public void test01914() { x = 0x7fffffffdeadf00dl; long result = x * 0xel; AssertJUnit.assertEquals("multiply", result, 0xfffffffe2d8320b6l); }
@Test
public void test01915() { x = 0x8000000000000000l; long result = x * 0xel; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01916() { x = 0xffffffffffffffffl; long result = x * 0xel; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffff2l); }
@Test
public void test01917() { x = 0xfffffffffffffffel; long result = x * 0xel; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffe4l); }
@Test
public void test01918() { x = 0xefffffffffffffffl; long result = x * 0xel; AssertJUnit.assertEquals("multiply", result, 0x1ffffffffffffff2l); }
@Test
public void test01919() { x = 0xdeadf00ddeadf00dl; long result = x * 0xel; AssertJUnit.assertEquals("multiply", result, 0x2d8320c22d8320b6l); }
@Test
public void test01920() { x = 0x000000007fffffffl; long result = x * 0x70l; AssertJUnit.assertEquals("multiply", result, 0x00000037ffffff90l); }
@Test
public void test01921() { x = 0x0000000080000000l; long result = x * 0x70l; AssertJUnit.assertEquals("multiply", result, 0x0000003800000000l); }
@Test
public void test01922() { x = 0x00000000ffffffffl; long result = x * 0x70l; AssertJUnit.assertEquals("multiply", result, 0x0000006fffffff90l); }
@Test
public void test01923() { x = 0x000000017fffffffl; long result = x * 0x70l; AssertJUnit.assertEquals("multiply", result, 0x000000a7ffffff90l); }
@Test
public void test01924() { x = 0x0000000180000000l; long result = x * 0x70l; AssertJUnit.assertEquals("multiply", result, 0x000000a800000000l); }
@Test
public void test01925() { x = 0x00000001ffffffffl; long result = x * 0x70l; AssertJUnit.assertEquals("multiply", result, 0x000000dfffffff90l); }
@Test
public void test01926() { x = 0xffffffff7fffffffl; long result = x * 0x70l; AssertJUnit.assertEquals("multiply", result, 0xffffffc7ffffff90l); }
@Test
public void test01927() { x = 0xffffffff80000000l; long result = x * 0x70l; AssertJUnit.assertEquals("multiply", result, 0xffffffc800000000l); }
@Test
public void test01928() { x = 0x00000001deadf00dl; long result = x * 0x70l; AssertJUnit.assertEquals("multiply", result, 0x000000d16c1905b0l); }
@Test
public void test01929() { x = 0xffffffffdeadf00dl; long result = x * 0x70l; AssertJUnit.assertEquals("multiply", result, 0xfffffff16c1905b0l); }
@Test
public void test01930() { x = 0x7fffffffffffffffl; long result = x * 0x70l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff90l); }
@Test
public void test01931() { x = 0x7fffffff7fffffffl; long result = x * 0x70l; AssertJUnit.assertEquals("multiply", result, 0xffffffc7ffffff90l); }
@Test
public void test01932() { x = 0x7fffffff80000000l; long result = x * 0x70l; AssertJUnit.assertEquals("multiply", result, 0xffffffc800000000l); }
@Test
public void test01933() { x = 0x7fffffffdeadf00dl; long result = x * 0x70l; AssertJUnit.assertEquals("multiply", result, 0xfffffff16c1905b0l); }
@Test
public void test01934() { x = 0x8000000000000000l; long result = x * 0x70l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01935() { x = 0xffffffffffffffffl; long result = x * 0x70l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff90l); }
@Test
public void test01936() { x = 0xfffffffffffffffel; long result = x * 0x70l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff20l); }
@Test
public void test01937() { x = 0xefffffffffffffffl; long result = x * 0x70l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff90l); }
@Test
public void test01938() { x = 0xdeadf00ddeadf00dl; long result = x * 0x70l; AssertJUnit.assertEquals("multiply", result, 0x6c1906116c1905b0l); }
@Test
public void test01939() { x = 0x000000007fffffffl; long result = x * 0xe00l; AssertJUnit.assertEquals("multiply", result, 0x000006fffffff200l); }
@Test
public void test01940() { x = 0x0000000080000000l; long result = x * 0xe00l; AssertJUnit.assertEquals("multiply", result, 0x0000070000000000l); }
@Test
public void test01941() { x = 0x00000000ffffffffl; long result = x * 0xe00l; AssertJUnit.assertEquals("multiply", result, 0x00000dfffffff200l); }
@Test
public void test01942() { x = 0x000000017fffffffl; long result = x * 0xe00l; AssertJUnit.assertEquals("multiply", result, 0x000014fffffff200l); }
@Test
public void test01943() { x = 0x0000000180000000l; long result = x * 0xe00l; AssertJUnit.assertEquals("multiply", result, 0x0000150000000000l); }
@Test
public void test01944() { x = 0x00000001ffffffffl; long result = x * 0xe00l; AssertJUnit.assertEquals("multiply", result, 0x00001bfffffff200l); }
@Test
public void test01945() { x = 0xffffffff7fffffffl; long result = x * 0xe00l; AssertJUnit.assertEquals("multiply", result, 0xfffff8fffffff200l); }
@Test
public void test01946() { x = 0xffffffff80000000l; long result = x * 0xe00l; AssertJUnit.assertEquals("multiply", result, 0xfffff90000000000l); }
@Test
public void test01947() { x = 0x00000001deadf00dl; long result = x * 0xe00l; AssertJUnit.assertEquals("multiply", result, 0x00001a2d8320b600l); }
@Test
public void test01948() { x = 0xffffffffdeadf00dl; long result = x * 0xe00l; AssertJUnit.assertEquals("multiply", result, 0xfffffe2d8320b600l); }
@Test
public void test01949() { x = 0x7fffffffffffffffl; long result = x * 0xe00l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffff200l); }
@Test
public void test01950() { x = 0x7fffffff7fffffffl; long result = x * 0xe00l; AssertJUnit.assertEquals("multiply", result, 0xfffff8fffffff200l); }
@Test
public void test01951() { x = 0x7fffffff80000000l; long result = x * 0xe00l; AssertJUnit.assertEquals("multiply", result, 0xfffff90000000000l); }
@Test
public void test01952() { x = 0x7fffffffdeadf00dl; long result = x * 0xe00l; AssertJUnit.assertEquals("multiply", result, 0xfffffe2d8320b600l); }
@Test
public void test01953() { x = 0x8000000000000000l; long result = x * 0xe00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01954() { x = 0xffffffffffffffffl; long result = x * 0xe00l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffff200l); }
@Test
public void test01955() { x = 0xfffffffffffffffel; long result = x * 0xe00l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffe400l); }
@Test
public void test01956() { x = 0xefffffffffffffffl; long result = x * 0xe00l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffff200l); }
@Test
public void test01957() { x = 0xdeadf00ddeadf00dl; long result = x * 0xe00l; AssertJUnit.assertEquals("multiply", result, 0x8320c22d8320b600l); }
@Test
public void test01958() { x = 0x000000007fffffffl; long result = x * 0xe00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff200000000l); }
@Test
public void test01959() { x = 0x0000000080000000l; long result = x * 0xe00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01960() { x = 0x00000000ffffffffl; long result = x * 0xe00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff200000000l); }
@Test
public void test01961() { x = 0x000000017fffffffl; long result = x * 0xe00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff200000000l); }
@Test
public void test01962() { x = 0x0000000180000000l; long result = x * 0xe00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01963() { x = 0x00000001ffffffffl; long result = x * 0xe00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff200000000l); }
@Test
public void test01964() { x = 0xffffffff7fffffffl; long result = x * 0xe00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff200000000l); }
@Test
public void test01965() { x = 0xffffffff80000000l; long result = x * 0xe00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01966() { x = 0x00000001deadf00dl; long result = x * 0xe00000000l; AssertJUnit.assertEquals("multiply", result, 0x2d8320b600000000l); }
@Test
public void test01967() { x = 0xffffffffdeadf00dl; long result = x * 0xe00000000l; AssertJUnit.assertEquals("multiply", result, 0x2d8320b600000000l); }
@Test
public void test01968() { x = 0x7fffffffffffffffl; long result = x * 0xe00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff200000000l); }
@Test
public void test01969() { x = 0x7fffffff7fffffffl; long result = x * 0xe00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff200000000l); }
@Test
public void test01970() { x = 0x7fffffff80000000l; long result = x * 0xe00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01971() { x = 0x7fffffffdeadf00dl; long result = x * 0xe00000000l; AssertJUnit.assertEquals("multiply", result, 0x2d8320b600000000l); }
@Test
public void test01972() { x = 0x8000000000000000l; long result = x * 0xe00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01973() { x = 0xffffffffffffffffl; long result = x * 0xe00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff200000000l); }
@Test
public void test01974() { x = 0xfffffffffffffffel; long result = x * 0xe00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe400000000l); }
@Test
public void test01975() { x = 0xefffffffffffffffl; long result = x * 0xe00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff200000000l); }
@Test
public void test01976() { x = 0xdeadf00ddeadf00dl; long result = x * 0xe00000000l; AssertJUnit.assertEquals("multiply", result, 0x2d8320b600000000l); }
@Test
public void test01977() { x = 0x000000007fffffffl; long result = x * 0x7000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff9000000000l); }
@Test
public void test01978() { x = 0x0000000080000000l; long result = x * 0x7000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01979() { x = 0x00000000ffffffffl; long result = x * 0x7000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff9000000000l); }
@Test
public void test01980() { x = 0x000000017fffffffl; long result = x * 0x7000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff9000000000l); }
@Test
public void test01981() { x = 0x0000000180000000l; long result = x * 0x7000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01982() { x = 0x00000001ffffffffl; long result = x * 0x7000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff9000000000l); }
@Test
public void test01983() { x = 0xffffffff7fffffffl; long result = x * 0x7000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff9000000000l); }
@Test
public void test01984() { x = 0xffffffff80000000l; long result = x * 0x7000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01985() { x = 0x00000001deadf00dl; long result = x * 0x7000000000l; AssertJUnit.assertEquals("multiply", result, 0x6c1905b000000000l); }
@Test
public void test01986() { x = 0xffffffffdeadf00dl; long result = x * 0x7000000000l; AssertJUnit.assertEquals("multiply", result, 0x6c1905b000000000l); }
@Test
public void test01987() { x = 0x7fffffffffffffffl; long result = x * 0x7000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff9000000000l); }
@Test
public void test01988() { x = 0x7fffffff7fffffffl; long result = x * 0x7000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff9000000000l); }
@Test
public void test01989() { x = 0x7fffffff80000000l; long result = x * 0x7000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01990() { x = 0x7fffffffdeadf00dl; long result = x * 0x7000000000l; AssertJUnit.assertEquals("multiply", result, 0x6c1905b000000000l); }
@Test
public void test01991() { x = 0x8000000000000000l; long result = x * 0x7000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test01992() { x = 0xffffffffffffffffl; long result = x * 0x7000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff9000000000l); }
@Test
public void test01993() { x = 0xfffffffffffffffel; long result = x * 0x7000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff2000000000l); }
@Test
public void test01994() { x = 0xefffffffffffffffl; long result = x * 0x7000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff9000000000l); }
@Test
public void test01995() { x = 0xdeadf00ddeadf00dl; long result = x * 0x7000000000l; AssertJUnit.assertEquals("multiply", result, 0x6c1905b000000000l); }
@Test
public void test01996() { x = 0x000000007fffffffl; long result = x * 0xfffffffffffffff2l; AssertJUnit.assertEquals("multiply", result, 0xfffffff90000000el); }
@Test
public void test01997() { x = 0x0000000080000000l; long result = x * 0xfffffffffffffff2l; AssertJUnit.assertEquals("multiply", result, 0xfffffff900000000l); }
@Test
public void test01998() { x = 0x00000000ffffffffl; long result = x * 0xfffffffffffffff2l; AssertJUnit.assertEquals("multiply", result, 0xfffffff20000000el); }
@Test
public void test01999() { x = 0x000000017fffffffl; long result = x * 0xfffffffffffffff2l; AssertJUnit.assertEquals("multiply", result, 0xffffffeb0000000el); }
@Test
public void test02000() { x = 0x0000000180000000l; long result = x * 0xfffffffffffffff2l; AssertJUnit.assertEquals("multiply", result, 0xffffffeb00000000l); }
@Test
public void test02001() { x = 0x00000001ffffffffl; long result = x * 0xfffffffffffffff2l; AssertJUnit.assertEquals("multiply", result, 0xffffffe40000000el); }
@Test
public void test02002() { x = 0xffffffff7fffffffl; long result = x * 0xfffffffffffffff2l; AssertJUnit.assertEquals("multiply", result, 0x000000070000000el); }
@Test
public void test02003() { x = 0xffffffff80000000l; long result = x * 0xfffffffffffffff2l; AssertJUnit.assertEquals("multiply", result, 0x0000000700000000l); }
@Test
public void test02004() { x = 0x00000001deadf00dl; long result = x * 0xfffffffffffffff2l; AssertJUnit.assertEquals("multiply", result, 0xffffffe5d27cdf4al); }
@Test
public void test02005() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffffffffffff2l; AssertJUnit.assertEquals("multiply", result, 0x00000001d27cdf4al); }
@Test
public void test02006() { x = 0x7fffffffffffffffl; long result = x * 0xfffffffffffffff2l; AssertJUnit.assertEquals("multiply", result, 0x000000000000000el); }
@Test
public void test02007() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffffffffffff2l; AssertJUnit.assertEquals("multiply", result, 0x000000070000000el); }
@Test
public void test02008() { x = 0x7fffffff80000000l; long result = x * 0xfffffffffffffff2l; AssertJUnit.assertEquals("multiply", result, 0x0000000700000000l); }
@Test
public void test02009() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffffffffffff2l; AssertJUnit.assertEquals("multiply", result, 0x00000001d27cdf4al); }
@Test
public void test02010() { x = 0x8000000000000000l; long result = x * 0xfffffffffffffff2l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02011() { x = 0xffffffffffffffffl; long result = x * 0xfffffffffffffff2l; AssertJUnit.assertEquals("multiply", result, 0x000000000000000el); }
@Test
public void test02012() { x = 0xfffffffffffffffel; long result = x * 0xfffffffffffffff2l; AssertJUnit.assertEquals("multiply", result, 0x000000000000001cl); }
@Test
public void test02013() { x = 0xefffffffffffffffl; long result = x * 0xfffffffffffffff2l; AssertJUnit.assertEquals("multiply", result, 0xe00000000000000el); }
@Test
public void test02014() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffffffffffff2l; AssertJUnit.assertEquals("multiply", result, 0xd27cdf3dd27cdf4al); }
@Test
public void test02015() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffff90l; AssertJUnit.assertEquals("multiply", result, 0xffffffc800000070l); }
@Test
public void test02016() { x = 0x0000000080000000l; long result = x * 0xffffffffffffff90l; AssertJUnit.assertEquals("multiply", result, 0xffffffc800000000l); }
@Test
public void test02017() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffff90l; AssertJUnit.assertEquals("multiply", result, 0xffffff9000000070l); }
@Test
public void test02018() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffff90l; AssertJUnit.assertEquals("multiply", result, 0xffffff5800000070l); }
@Test
public void test02019() { x = 0x0000000180000000l; long result = x * 0xffffffffffffff90l; AssertJUnit.assertEquals("multiply", result, 0xffffff5800000000l); }
@Test
public void test02020() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffff90l; AssertJUnit.assertEquals("multiply", result, 0xffffff2000000070l); }
@Test
public void test02021() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffff90l; AssertJUnit.assertEquals("multiply", result, 0x0000003800000070l); }
@Test
public void test02022() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffff90l; AssertJUnit.assertEquals("multiply", result, 0x0000003800000000l); }
@Test
public void test02023() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffff90l; AssertJUnit.assertEquals("multiply", result, 0xffffff2e93e6fa50l); }
@Test
public void test02024() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffff90l; AssertJUnit.assertEquals("multiply", result, 0x0000000e93e6fa50l); }
@Test
public void test02025() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffff90l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000070l); }
@Test
public void test02026() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffff90l; AssertJUnit.assertEquals("multiply", result, 0x0000003800000070l); }
@Test
public void test02027() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffff90l; AssertJUnit.assertEquals("multiply", result, 0x0000003800000000l); }
@Test
public void test02028() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffff90l; AssertJUnit.assertEquals("multiply", result, 0x0000000e93e6fa50l); }
@Test
public void test02029() { x = 0x8000000000000000l; long result = x * 0xffffffffffffff90l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02030() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffff90l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000070l); }
@Test
public void test02031() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffff90l; AssertJUnit.assertEquals("multiply", result, 0x00000000000000e0l); }
@Test
public void test02032() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffff90l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000070l); }
@Test
public void test02033() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffff90l; AssertJUnit.assertEquals("multiply", result, 0x93e6f9ee93e6fa50l); }
@Test
public void test02034() { x = 0x000000007fffffffl; long result = x * 0xfffffffffffff200l; AssertJUnit.assertEquals("multiply", result, 0xfffff90000000e00l); }
@Test
public void test02035() { x = 0x0000000080000000l; long result = x * 0xfffffffffffff200l; AssertJUnit.assertEquals("multiply", result, 0xfffff90000000000l); }
@Test
public void test02036() { x = 0x00000000ffffffffl; long result = x * 0xfffffffffffff200l; AssertJUnit.assertEquals("multiply", result, 0xfffff20000000e00l); }
@Test
public void test02037() { x = 0x000000017fffffffl; long result = x * 0xfffffffffffff200l; AssertJUnit.assertEquals("multiply", result, 0xffffeb0000000e00l); }
@Test
public void test02038() { x = 0x0000000180000000l; long result = x * 0xfffffffffffff200l; AssertJUnit.assertEquals("multiply", result, 0xffffeb0000000000l); }
@Test
public void test02039() { x = 0x00000001ffffffffl; long result = x * 0xfffffffffffff200l; AssertJUnit.assertEquals("multiply", result, 0xffffe40000000e00l); }
@Test
public void test02040() { x = 0xffffffff7fffffffl; long result = x * 0xfffffffffffff200l; AssertJUnit.assertEquals("multiply", result, 0x0000070000000e00l); }
@Test
public void test02041() { x = 0xffffffff80000000l; long result = x * 0xfffffffffffff200l; AssertJUnit.assertEquals("multiply", result, 0x0000070000000000l); }
@Test
public void test02042() { x = 0x00000001deadf00dl; long result = x * 0xfffffffffffff200l; AssertJUnit.assertEquals("multiply", result, 0xffffe5d27cdf4a00l); }
@Test
public void test02043() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffffffffff200l; AssertJUnit.assertEquals("multiply", result, 0x000001d27cdf4a00l); }
@Test
public void test02044() { x = 0x7fffffffffffffffl; long result = x * 0xfffffffffffff200l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000e00l); }
@Test
public void test02045() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffffffffff200l; AssertJUnit.assertEquals("multiply", result, 0x0000070000000e00l); }
@Test
public void test02046() { x = 0x7fffffff80000000l; long result = x * 0xfffffffffffff200l; AssertJUnit.assertEquals("multiply", result, 0x0000070000000000l); }
@Test
public void test02047() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffffffffff200l; AssertJUnit.assertEquals("multiply", result, 0x000001d27cdf4a00l); }
@Test
public void test02048() { x = 0x8000000000000000l; long result = x * 0xfffffffffffff200l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02049() { x = 0xffffffffffffffffl; long result = x * 0xfffffffffffff200l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000e00l); }
@Test
public void test02050() { x = 0xfffffffffffffffel; long result = x * 0xfffffffffffff200l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001c00l); }
@Test
public void test02051() { x = 0xefffffffffffffffl; long result = x * 0xfffffffffffff200l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000e00l); }
@Test
public void test02052() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffffffffff200l; AssertJUnit.assertEquals("multiply", result, 0x7cdf3dd27cdf4a00l); }
@Test
public void test02053() { x = 0x000000007fffffffl; long result = x * 0xfffffff200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000e00000000l); }
@Test
public void test02054() { x = 0x0000000080000000l; long result = x * 0xfffffff200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02055() { x = 0x00000000ffffffffl; long result = x * 0xfffffff200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000e00000000l); }
@Test
public void test02056() { x = 0x000000017fffffffl; long result = x * 0xfffffff200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000e00000000l); }
@Test
public void test02057() { x = 0x0000000180000000l; long result = x * 0xfffffff200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02058() { x = 0x00000001ffffffffl; long result = x * 0xfffffff200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000e00000000l); }
@Test
public void test02059() { x = 0xffffffff7fffffffl; long result = x * 0xfffffff200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000e00000000l); }
@Test
public void test02060() { x = 0xffffffff80000000l; long result = x * 0xfffffff200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02061() { x = 0x00000001deadf00dl; long result = x * 0xfffffff200000000l; AssertJUnit.assertEquals("multiply", result, 0xd27cdf4a00000000l); }
@Test
public void test02062() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffff200000000l; AssertJUnit.assertEquals("multiply", result, 0xd27cdf4a00000000l); }
@Test
public void test02063() { x = 0x7fffffffffffffffl; long result = x * 0xfffffff200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000e00000000l); }
@Test
public void test02064() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffff200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000e00000000l); }
@Test
public void test02065() { x = 0x7fffffff80000000l; long result = x * 0xfffffff200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02066() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffff200000000l; AssertJUnit.assertEquals("multiply", result, 0xd27cdf4a00000000l); }
@Test
public void test02067() { x = 0x8000000000000000l; long result = x * 0xfffffff200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02068() { x = 0xffffffffffffffffl; long result = x * 0xfffffff200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000e00000000l); }
@Test
public void test02069() { x = 0xfffffffffffffffel; long result = x * 0xfffffff200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001c00000000l); }
@Test
public void test02070() { x = 0xefffffffffffffffl; long result = x * 0xfffffff200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000e00000000l); }
@Test
public void test02071() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffff200000000l; AssertJUnit.assertEquals("multiply", result, 0xd27cdf4a00000000l); }
@Test
public void test02072() { x = 0x000000007fffffffl; long result = x * 0xffffff9000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000007000000000l); }
@Test
public void test02073() { x = 0x0000000080000000l; long result = x * 0xffffff9000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02074() { x = 0x00000000ffffffffl; long result = x * 0xffffff9000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000007000000000l); }
@Test
public void test02075() { x = 0x000000017fffffffl; long result = x * 0xffffff9000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000007000000000l); }
@Test
public void test02076() { x = 0x0000000180000000l; long result = x * 0xffffff9000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02077() { x = 0x00000001ffffffffl; long result = x * 0xffffff9000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000007000000000l); }
@Test
public void test02078() { x = 0xffffffff7fffffffl; long result = x * 0xffffff9000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000007000000000l); }
@Test
public void test02079() { x = 0xffffffff80000000l; long result = x * 0xffffff9000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02080() { x = 0x00000001deadf00dl; long result = x * 0xffffff9000000000l; AssertJUnit.assertEquals("multiply", result, 0x93e6fa5000000000l); }
@Test
public void test02081() { x = 0xffffffffdeadf00dl; long result = x * 0xffffff9000000000l; AssertJUnit.assertEquals("multiply", result, 0x93e6fa5000000000l); }
@Test
public void test02082() { x = 0x7fffffffffffffffl; long result = x * 0xffffff9000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000007000000000l); }
@Test
public void test02083() { x = 0x7fffffff7fffffffl; long result = x * 0xffffff9000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000007000000000l); }
@Test
public void test02084() { x = 0x7fffffff80000000l; long result = x * 0xffffff9000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02085() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffff9000000000l; AssertJUnit.assertEquals("multiply", result, 0x93e6fa5000000000l); }
@Test
public void test02086() { x = 0x8000000000000000l; long result = x * 0xffffff9000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02087() { x = 0xffffffffffffffffl; long result = x * 0xffffff9000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000007000000000l); }
@Test
public void test02088() { x = 0xfffffffffffffffel; long result = x * 0xffffff9000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000e000000000l); }
@Test
public void test02089() { x = 0xefffffffffffffffl; long result = x * 0xffffff9000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000007000000000l); }
@Test
public void test02090() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffff9000000000l; AssertJUnit.assertEquals("multiply", result, 0x93e6fa5000000000l); }
@Test
public void test02091() { x = 0x000000007fffffffl; long result = x * 0xfl; AssertJUnit.assertEquals("multiply", result, 0x000000077ffffff1l); }
@Test
public void test02092() { x = 0x0000000080000000l; long result = x * 0xfl; AssertJUnit.assertEquals("multiply", result, 0x0000000780000000l); }
@Test
public void test02093() { x = 0x00000000ffffffffl; long result = x * 0xfl; AssertJUnit.assertEquals("multiply", result, 0x0000000efffffff1l); }
@Test
public void test02094() { x = 0x000000017fffffffl; long result = x * 0xfl; AssertJUnit.assertEquals("multiply", result, 0x000000167ffffff1l); }
@Test
public void test02095() { x = 0x0000000180000000l; long result = x * 0xfl; AssertJUnit.assertEquals("multiply", result, 0x0000001680000000l); }
@Test
public void test02096() { x = 0x00000001ffffffffl; long result = x * 0xfl; AssertJUnit.assertEquals("multiply", result, 0x0000001dfffffff1l); }
@Test
public void test02097() { x = 0xffffffff7fffffffl; long result = x * 0xfl; AssertJUnit.assertEquals("multiply", result, 0xfffffff87ffffff1l); }
@Test
public void test02098() { x = 0xffffffff80000000l; long result = x * 0xfl; AssertJUnit.assertEquals("multiply", result, 0xfffffff880000000l); }
@Test
public void test02099() { x = 0x00000001deadf00dl; long result = x * 0xfl; AssertJUnit.assertEquals("multiply", result, 0x0000001c0c3110c3l); }
@Test
public void test02100() { x = 0xffffffffdeadf00dl; long result = x * 0xfl; AssertJUnit.assertEquals("multiply", result, 0xfffffffe0c3110c3l); }
@Test
public void test02101() { x = 0x7fffffffffffffffl; long result = x * 0xfl; AssertJUnit.assertEquals("multiply", result, 0x7ffffffffffffff1l); }
@Test
public void test02102() { x = 0x7fffffff7fffffffl; long result = x * 0xfl; AssertJUnit.assertEquals("multiply", result, 0x7ffffff87ffffff1l); }
@Test
public void test02103() { x = 0x7fffffff80000000l; long result = x * 0xfl; AssertJUnit.assertEquals("multiply", result, 0x7ffffff880000000l); }
@Test
public void test02104() { x = 0x7fffffffdeadf00dl; long result = x * 0xfl; AssertJUnit.assertEquals("multiply", result, 0x7ffffffe0c3110c3l); }
@Test
public void test02105() { x = 0x8000000000000000l; long result = x * 0xfl; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test02106() { x = 0xffffffffffffffffl; long result = x * 0xfl; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffff1l); }
@Test
public void test02107() { x = 0xfffffffffffffffel; long result = x * 0xfl; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffe2l); }
@Test
public void test02108() { x = 0xefffffffffffffffl; long result = x * 0xfl; AssertJUnit.assertEquals("multiply", result, 0x0ffffffffffffff1l); }
@Test
public void test02109() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfl; AssertJUnit.assertEquals("multiply", result, 0x0c3110d00c3110c3l); }
@Test
public void test02110() { x = 0x000000007fffffffl; long result = x * 0x78l; AssertJUnit.assertEquals("multiply", result, 0x0000003bffffff88l); }
@Test
public void test02111() { x = 0x0000000080000000l; long result = x * 0x78l; AssertJUnit.assertEquals("multiply", result, 0x0000003c00000000l); }
@Test
public void test02112() { x = 0x00000000ffffffffl; long result = x * 0x78l; AssertJUnit.assertEquals("multiply", result, 0x00000077ffffff88l); }
@Test
public void test02113() { x = 0x000000017fffffffl; long result = x * 0x78l; AssertJUnit.assertEquals("multiply", result, 0x000000b3ffffff88l); }
@Test
public void test02114() { x = 0x0000000180000000l; long result = x * 0x78l; AssertJUnit.assertEquals("multiply", result, 0x000000b400000000l); }
@Test
public void test02115() { x = 0x00000001ffffffffl; long result = x * 0x78l; AssertJUnit.assertEquals("multiply", result, 0x000000efffffff88l); }
@Test
public void test02116() { x = 0xffffffff7fffffffl; long result = x * 0x78l; AssertJUnit.assertEquals("multiply", result, 0xffffffc3ffffff88l); }
@Test
public void test02117() { x = 0xffffffff80000000l; long result = x * 0x78l; AssertJUnit.assertEquals("multiply", result, 0xffffffc400000000l); }
@Test
public void test02118() { x = 0x00000001deadf00dl; long result = x * 0x78l; AssertJUnit.assertEquals("multiply", result, 0x000000e061888618l); }
@Test
public void test02119() { x = 0xffffffffdeadf00dl; long result = x * 0x78l; AssertJUnit.assertEquals("multiply", result, 0xfffffff061888618l); }
@Test
public void test02120() { x = 0x7fffffffffffffffl; long result = x * 0x78l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff88l); }
@Test
public void test02121() { x = 0x7fffffff7fffffffl; long result = x * 0x78l; AssertJUnit.assertEquals("multiply", result, 0xffffffc3ffffff88l); }
@Test
public void test02122() { x = 0x7fffffff80000000l; long result = x * 0x78l; AssertJUnit.assertEquals("multiply", result, 0xffffffc400000000l); }
@Test
public void test02123() { x = 0x7fffffffdeadf00dl; long result = x * 0x78l; AssertJUnit.assertEquals("multiply", result, 0xfffffff061888618l); }
@Test
public void test02124() { x = 0x8000000000000000l; long result = x * 0x78l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02125() { x = 0xffffffffffffffffl; long result = x * 0x78l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff88l); }
@Test
public void test02126() { x = 0xfffffffffffffffel; long result = x * 0x78l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff10l); }
@Test
public void test02127() { x = 0xefffffffffffffffl; long result = x * 0x78l; AssertJUnit.assertEquals("multiply", result, 0x7fffffffffffff88l); }
@Test
public void test02128() { x = 0xdeadf00ddeadf00dl; long result = x * 0x78l; AssertJUnit.assertEquals("multiply", result, 0x6188868061888618l); }
@Test
public void test02129() { x = 0x000000007fffffffl; long result = x * 0xf00l; AssertJUnit.assertEquals("multiply", result, 0x0000077ffffff100l); }
@Test
public void test02130() { x = 0x0000000080000000l; long result = x * 0xf00l; AssertJUnit.assertEquals("multiply", result, 0x0000078000000000l); }
@Test
public void test02131() { x = 0x00000000ffffffffl; long result = x * 0xf00l; AssertJUnit.assertEquals("multiply", result, 0x00000efffffff100l); }
@Test
public void test02132() { x = 0x000000017fffffffl; long result = x * 0xf00l; AssertJUnit.assertEquals("multiply", result, 0x0000167ffffff100l); }
@Test
public void test02133() { x = 0x0000000180000000l; long result = x * 0xf00l; AssertJUnit.assertEquals("multiply", result, 0x0000168000000000l); }
@Test
public void test02134() { x = 0x00000001ffffffffl; long result = x * 0xf00l; AssertJUnit.assertEquals("multiply", result, 0x00001dfffffff100l); }
@Test
public void test02135() { x = 0xffffffff7fffffffl; long result = x * 0xf00l; AssertJUnit.assertEquals("multiply", result, 0xfffff87ffffff100l); }
@Test
public void test02136() { x = 0xffffffff80000000l; long result = x * 0xf00l; AssertJUnit.assertEquals("multiply", result, 0xfffff88000000000l); }
@Test
public void test02137() { x = 0x00000001deadf00dl; long result = x * 0xf00l; AssertJUnit.assertEquals("multiply", result, 0x00001c0c3110c300l); }
@Test
public void test02138() { x = 0xffffffffdeadf00dl; long result = x * 0xf00l; AssertJUnit.assertEquals("multiply", result, 0xfffffe0c3110c300l); }
@Test
public void test02139() { x = 0x7fffffffffffffffl; long result = x * 0xf00l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffff100l); }
@Test
public void test02140() { x = 0x7fffffff7fffffffl; long result = x * 0xf00l; AssertJUnit.assertEquals("multiply", result, 0xfffff87ffffff100l); }
@Test
public void test02141() { x = 0x7fffffff80000000l; long result = x * 0xf00l; AssertJUnit.assertEquals("multiply", result, 0xfffff88000000000l); }
@Test
public void test02142() { x = 0x7fffffffdeadf00dl; long result = x * 0xf00l; AssertJUnit.assertEquals("multiply", result, 0xfffffe0c3110c300l); }
@Test
public void test02143() { x = 0x8000000000000000l; long result = x * 0xf00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02144() { x = 0xffffffffffffffffl; long result = x * 0xf00l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffff100l); }
@Test
public void test02145() { x = 0xfffffffffffffffel; long result = x * 0xf00l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffe200l); }
@Test
public void test02146() { x = 0xefffffffffffffffl; long result = x * 0xf00l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffff100l); }
@Test
public void test02147() { x = 0xdeadf00ddeadf00dl; long result = x * 0xf00l; AssertJUnit.assertEquals("multiply", result, 0x3110d00c3110c300l); }
@Test
public void test02148() { x = 0x000000007fffffffl; long result = x * 0xf00000000l; AssertJUnit.assertEquals("multiply", result, 0x7ffffff100000000l); }
@Test
public void test02149() { x = 0x0000000080000000l; long result = x * 0xf00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test02150() { x = 0x00000000ffffffffl; long result = x * 0xf00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff100000000l); }
@Test
public void test02151() { x = 0x000000017fffffffl; long result = x * 0xf00000000l; AssertJUnit.assertEquals("multiply", result, 0x7ffffff100000000l); }
@Test
public void test02152() { x = 0x0000000180000000l; long result = x * 0xf00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test02153() { x = 0x00000001ffffffffl; long result = x * 0xf00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff100000000l); }
@Test
public void test02154() { x = 0xffffffff7fffffffl; long result = x * 0xf00000000l; AssertJUnit.assertEquals("multiply", result, 0x7ffffff100000000l); }
@Test
public void test02155() { x = 0xffffffff80000000l; long result = x * 0xf00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test02156() { x = 0x00000001deadf00dl; long result = x * 0xf00000000l; AssertJUnit.assertEquals("multiply", result, 0x0c3110c300000000l); }
@Test
public void test02157() { x = 0xffffffffdeadf00dl; long result = x * 0xf00000000l; AssertJUnit.assertEquals("multiply", result, 0x0c3110c300000000l); }
@Test
public void test02158() { x = 0x7fffffffffffffffl; long result = x * 0xf00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff100000000l); }
@Test
public void test02159() { x = 0x7fffffff7fffffffl; long result = x * 0xf00000000l; AssertJUnit.assertEquals("multiply", result, 0x7ffffff100000000l); }
@Test
public void test02160() { x = 0x7fffffff80000000l; long result = x * 0xf00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test02161() { x = 0x7fffffffdeadf00dl; long result = x * 0xf00000000l; AssertJUnit.assertEquals("multiply", result, 0x0c3110c300000000l); }
@Test
public void test02162() { x = 0x8000000000000000l; long result = x * 0xf00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02163() { x = 0xffffffffffffffffl; long result = x * 0xf00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff100000000l); }
@Test
public void test02164() { x = 0xfffffffffffffffel; long result = x * 0xf00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe200000000l); }
@Test
public void test02165() { x = 0xefffffffffffffffl; long result = x * 0xf00000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffff100000000l); }
@Test
public void test02166() { x = 0xdeadf00ddeadf00dl; long result = x * 0xf00000000l; AssertJUnit.assertEquals("multiply", result, 0x0c3110c300000000l); }
@Test
public void test02167() { x = 0x000000007fffffffl; long result = x * 0x7800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff8800000000l); }
@Test
public void test02168() { x = 0x0000000080000000l; long result = x * 0x7800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02169() { x = 0x00000000ffffffffl; long result = x * 0x7800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff8800000000l); }
@Test
public void test02170() { x = 0x000000017fffffffl; long result = x * 0x7800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff8800000000l); }
@Test
public void test02171() { x = 0x0000000180000000l; long result = x * 0x7800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02172() { x = 0x00000001ffffffffl; long result = x * 0x7800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff8800000000l); }
@Test
public void test02173() { x = 0xffffffff7fffffffl; long result = x * 0x7800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff8800000000l); }
@Test
public void test02174() { x = 0xffffffff80000000l; long result = x * 0x7800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02175() { x = 0x00000001deadf00dl; long result = x * 0x7800000000l; AssertJUnit.assertEquals("multiply", result, 0x6188861800000000l); }
@Test
public void test02176() { x = 0xffffffffdeadf00dl; long result = x * 0x7800000000l; AssertJUnit.assertEquals("multiply", result, 0x6188861800000000l); }
@Test
public void test02177() { x = 0x7fffffffffffffffl; long result = x * 0x7800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff8800000000l); }
@Test
public void test02178() { x = 0x7fffffff7fffffffl; long result = x * 0x7800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff8800000000l); }
@Test
public void test02179() { x = 0x7fffffff80000000l; long result = x * 0x7800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02180() { x = 0x7fffffffdeadf00dl; long result = x * 0x7800000000l; AssertJUnit.assertEquals("multiply", result, 0x6188861800000000l); }
@Test
public void test02181() { x = 0x8000000000000000l; long result = x * 0x7800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02182() { x = 0xffffffffffffffffl; long result = x * 0x7800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff8800000000l); }
@Test
public void test02183() { x = 0xfffffffffffffffel; long result = x * 0x7800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff1000000000l); }
@Test
public void test02184() { x = 0xefffffffffffffffl; long result = x * 0x7800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff8800000000l); }
@Test
public void test02185() { x = 0xdeadf00ddeadf00dl; long result = x * 0x7800000000l; AssertJUnit.assertEquals("multiply", result, 0x6188861800000000l); }
@Test
public void test02186() { x = 0x000000007fffffffl; long result = x * 0xfffffffffffffff1l; AssertJUnit.assertEquals("multiply", result, 0xfffffff88000000fl); }
@Test
public void test02187() { x = 0x0000000080000000l; long result = x * 0xfffffffffffffff1l; AssertJUnit.assertEquals("multiply", result, 0xfffffff880000000l); }
@Test
public void test02188() { x = 0x00000000ffffffffl; long result = x * 0xfffffffffffffff1l; AssertJUnit.assertEquals("multiply", result, 0xfffffff10000000fl); }
@Test
public void test02189() { x = 0x000000017fffffffl; long result = x * 0xfffffffffffffff1l; AssertJUnit.assertEquals("multiply", result, 0xffffffe98000000fl); }
@Test
public void test02190() { x = 0x0000000180000000l; long result = x * 0xfffffffffffffff1l; AssertJUnit.assertEquals("multiply", result, 0xffffffe980000000l); }
@Test
public void test02191() { x = 0x00000001ffffffffl; long result = x * 0xfffffffffffffff1l; AssertJUnit.assertEquals("multiply", result, 0xffffffe20000000fl); }
@Test
public void test02192() { x = 0xffffffff7fffffffl; long result = x * 0xfffffffffffffff1l; AssertJUnit.assertEquals("multiply", result, 0x000000078000000fl); }
@Test
public void test02193() { x = 0xffffffff80000000l; long result = x * 0xfffffffffffffff1l; AssertJUnit.assertEquals("multiply", result, 0x0000000780000000l); }
@Test
public void test02194() { x = 0x00000001deadf00dl; long result = x * 0xfffffffffffffff1l; AssertJUnit.assertEquals("multiply", result, 0xffffffe3f3ceef3dl); }
@Test
public void test02195() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffffffffffff1l; AssertJUnit.assertEquals("multiply", result, 0x00000001f3ceef3dl); }
@Test
public void test02196() { x = 0x7fffffffffffffffl; long result = x * 0xfffffffffffffff1l; AssertJUnit.assertEquals("multiply", result, 0x800000000000000fl); }
@Test
public void test02197() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffffffffffff1l; AssertJUnit.assertEquals("multiply", result, 0x800000078000000fl); }
@Test
public void test02198() { x = 0x7fffffff80000000l; long result = x * 0xfffffffffffffff1l; AssertJUnit.assertEquals("multiply", result, 0x8000000780000000l); }
@Test
public void test02199() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffffffffffff1l; AssertJUnit.assertEquals("multiply", result, 0x80000001f3ceef3dl); }
@Test
public void test02200() { x = 0x8000000000000000l; long result = x * 0xfffffffffffffff1l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test02201() { x = 0xffffffffffffffffl; long result = x * 0xfffffffffffffff1l; AssertJUnit.assertEquals("multiply", result, 0x000000000000000fl); }
@Test
public void test02202() { x = 0xfffffffffffffffel; long result = x * 0xfffffffffffffff1l; AssertJUnit.assertEquals("multiply", result, 0x000000000000001el); }
@Test
public void test02203() { x = 0xefffffffffffffffl; long result = x * 0xfffffffffffffff1l; AssertJUnit.assertEquals("multiply", result, 0xf00000000000000fl); }
@Test
public void test02204() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffffffffffff1l; AssertJUnit.assertEquals("multiply", result, 0xf3ceef2ff3ceef3dl); }
@Test
public void test02205() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffff88l; AssertJUnit.assertEquals("multiply", result, 0xffffffc400000078l); }
@Test
public void test02206() { x = 0x0000000080000000l; long result = x * 0xffffffffffffff88l; AssertJUnit.assertEquals("multiply", result, 0xffffffc400000000l); }
@Test
public void test02207() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffff88l; AssertJUnit.assertEquals("multiply", result, 0xffffff8800000078l); }
@Test
public void test02208() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffff88l; AssertJUnit.assertEquals("multiply", result, 0xffffff4c00000078l); }
@Test
public void test02209() { x = 0x0000000180000000l; long result = x * 0xffffffffffffff88l; AssertJUnit.assertEquals("multiply", result, 0xffffff4c00000000l); }
@Test
public void test02210() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffff88l; AssertJUnit.assertEquals("multiply", result, 0xffffff1000000078l); }
@Test
public void test02211() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffff88l; AssertJUnit.assertEquals("multiply", result, 0x0000003c00000078l); }
@Test
public void test02212() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffff88l; AssertJUnit.assertEquals("multiply", result, 0x0000003c00000000l); }
@Test
public void test02213() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffff88l; AssertJUnit.assertEquals("multiply", result, 0xffffff1f9e7779e8l); }
@Test
public void test02214() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffff88l; AssertJUnit.assertEquals("multiply", result, 0x0000000f9e7779e8l); }
@Test
public void test02215() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffff88l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000078l); }
@Test
public void test02216() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffff88l; AssertJUnit.assertEquals("multiply", result, 0x0000003c00000078l); }
@Test
public void test02217() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffff88l; AssertJUnit.assertEquals("multiply", result, 0x0000003c00000000l); }
@Test
public void test02218() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffff88l; AssertJUnit.assertEquals("multiply", result, 0x0000000f9e7779e8l); }
@Test
public void test02219() { x = 0x8000000000000000l; long result = x * 0xffffffffffffff88l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02220() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffff88l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000078l); }
@Test
public void test02221() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffff88l; AssertJUnit.assertEquals("multiply", result, 0x00000000000000f0l); }
@Test
public void test02222() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffff88l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000078l); }
@Test
public void test02223() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffff88l; AssertJUnit.assertEquals("multiply", result, 0x9e77797f9e7779e8l); }
@Test
public void test02224() { x = 0x000000007fffffffl; long result = x * 0xfffffffffffff100l; AssertJUnit.assertEquals("multiply", result, 0xfffff88000000f00l); }
@Test
public void test02225() { x = 0x0000000080000000l; long result = x * 0xfffffffffffff100l; AssertJUnit.assertEquals("multiply", result, 0xfffff88000000000l); }
@Test
public void test02226() { x = 0x00000000ffffffffl; long result = x * 0xfffffffffffff100l; AssertJUnit.assertEquals("multiply", result, 0xfffff10000000f00l); }
@Test
public void test02227() { x = 0x000000017fffffffl; long result = x * 0xfffffffffffff100l; AssertJUnit.assertEquals("multiply", result, 0xffffe98000000f00l); }
@Test
public void test02228() { x = 0x0000000180000000l; long result = x * 0xfffffffffffff100l; AssertJUnit.assertEquals("multiply", result, 0xffffe98000000000l); }
@Test
public void test02229() { x = 0x00000001ffffffffl; long result = x * 0xfffffffffffff100l; AssertJUnit.assertEquals("multiply", result, 0xffffe20000000f00l); }
@Test
public void test02230() { x = 0xffffffff7fffffffl; long result = x * 0xfffffffffffff100l; AssertJUnit.assertEquals("multiply", result, 0x0000078000000f00l); }
@Test
public void test02231() { x = 0xffffffff80000000l; long result = x * 0xfffffffffffff100l; AssertJUnit.assertEquals("multiply", result, 0x0000078000000000l); }
@Test
public void test02232() { x = 0x00000001deadf00dl; long result = x * 0xfffffffffffff100l; AssertJUnit.assertEquals("multiply", result, 0xffffe3f3ceef3d00l); }
@Test
public void test02233() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffffffffff100l; AssertJUnit.assertEquals("multiply", result, 0x000001f3ceef3d00l); }
@Test
public void test02234() { x = 0x7fffffffffffffffl; long result = x * 0xfffffffffffff100l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000f00l); }
@Test
public void test02235() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffffffffff100l; AssertJUnit.assertEquals("multiply", result, 0x0000078000000f00l); }
@Test
public void test02236() { x = 0x7fffffff80000000l; long result = x * 0xfffffffffffff100l; AssertJUnit.assertEquals("multiply", result, 0x0000078000000000l); }
@Test
public void test02237() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffffffffff100l; AssertJUnit.assertEquals("multiply", result, 0x000001f3ceef3d00l); }
@Test
public void test02238() { x = 0x8000000000000000l; long result = x * 0xfffffffffffff100l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02239() { x = 0xffffffffffffffffl; long result = x * 0xfffffffffffff100l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000f00l); }
@Test
public void test02240() { x = 0xfffffffffffffffel; long result = x * 0xfffffffffffff100l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001e00l); }
@Test
public void test02241() { x = 0xefffffffffffffffl; long result = x * 0xfffffffffffff100l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000f00l); }
@Test
public void test02242() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffffffffff100l; AssertJUnit.assertEquals("multiply", result, 0xceef2ff3ceef3d00l); }
@Test
public void test02243() { x = 0x000000007fffffffl; long result = x * 0xfffffff100000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000f00000000l); }
@Test
public void test02244() { x = 0x0000000080000000l; long result = x * 0xfffffff100000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test02245() { x = 0x00000000ffffffffl; long result = x * 0xfffffff100000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000f00000000l); }
@Test
public void test02246() { x = 0x000000017fffffffl; long result = x * 0xfffffff100000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000f00000000l); }
@Test
public void test02247() { x = 0x0000000180000000l; long result = x * 0xfffffff100000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test02248() { x = 0x00000001ffffffffl; long result = x * 0xfffffff100000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000f00000000l); }
@Test
public void test02249() { x = 0xffffffff7fffffffl; long result = x * 0xfffffff100000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000f00000000l); }
@Test
public void test02250() { x = 0xffffffff80000000l; long result = x * 0xfffffff100000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test02251() { x = 0x00000001deadf00dl; long result = x * 0xfffffff100000000l; AssertJUnit.assertEquals("multiply", result, 0xf3ceef3d00000000l); }
@Test
public void test02252() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffff100000000l; AssertJUnit.assertEquals("multiply", result, 0xf3ceef3d00000000l); }
@Test
public void test02253() { x = 0x7fffffffffffffffl; long result = x * 0xfffffff100000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000f00000000l); }
@Test
public void test02254() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffff100000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000f00000000l); }
@Test
public void test02255() { x = 0x7fffffff80000000l; long result = x * 0xfffffff100000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test02256() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffff100000000l; AssertJUnit.assertEquals("multiply", result, 0xf3ceef3d00000000l); }
@Test
public void test02257() { x = 0x8000000000000000l; long result = x * 0xfffffff100000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02258() { x = 0xffffffffffffffffl; long result = x * 0xfffffff100000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000f00000000l); }
@Test
public void test02259() { x = 0xfffffffffffffffel; long result = x * 0xfffffff100000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001e00000000l); }
@Test
public void test02260() { x = 0xefffffffffffffffl; long result = x * 0xfffffff100000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000f00000000l); }
@Test
public void test02261() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffff100000000l; AssertJUnit.assertEquals("multiply", result, 0xf3ceef3d00000000l); }
@Test
public void test02262() { x = 0x000000007fffffffl; long result = x * 0xffffff8800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000007800000000l); }
@Test
public void test02263() { x = 0x0000000080000000l; long result = x * 0xffffff8800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02264() { x = 0x00000000ffffffffl; long result = x * 0xffffff8800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000007800000000l); }
@Test
public void test02265() { x = 0x000000017fffffffl; long result = x * 0xffffff8800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000007800000000l); }
@Test
public void test02266() { x = 0x0000000180000000l; long result = x * 0xffffff8800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02267() { x = 0x00000001ffffffffl; long result = x * 0xffffff8800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000007800000000l); }
@Test
public void test02268() { x = 0xffffffff7fffffffl; long result = x * 0xffffff8800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000007800000000l); }
@Test
public void test02269() { x = 0xffffffff80000000l; long result = x * 0xffffff8800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02270() { x = 0x00000001deadf00dl; long result = x * 0xffffff8800000000l; AssertJUnit.assertEquals("multiply", result, 0x9e7779e800000000l); }
@Test
public void test02271() { x = 0xffffffffdeadf00dl; long result = x * 0xffffff8800000000l; AssertJUnit.assertEquals("multiply", result, 0x9e7779e800000000l); }
@Test
public void test02272() { x = 0x7fffffffffffffffl; long result = x * 0xffffff8800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000007800000000l); }
@Test
public void test02273() { x = 0x7fffffff7fffffffl; long result = x * 0xffffff8800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000007800000000l); }
@Test
public void test02274() { x = 0x7fffffff80000000l; long result = x * 0xffffff8800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02275() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffff8800000000l; AssertJUnit.assertEquals("multiply", result, 0x9e7779e800000000l); }
@Test
public void test02276() { x = 0x8000000000000000l; long result = x * 0xffffff8800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02277() { x = 0xffffffffffffffffl; long result = x * 0xffffff8800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000007800000000l); }
@Test
public void test02278() { x = 0xfffffffffffffffel; long result = x * 0xffffff8800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000f000000000l); }
@Test
public void test02279() { x = 0xefffffffffffffffl; long result = x * 0xffffff8800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000007800000000l); }
@Test
public void test02280() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffff8800000000l; AssertJUnit.assertEquals("multiply", result, 0x9e7779e800000000l); }
@Test
public void test02281() { x = 0x000000007fffffffl; long result = x * 0x11l; AssertJUnit.assertEquals("multiply", result, 0x000000087fffffefl); }
@Test
public void test02282() { x = 0x0000000080000000l; long result = x * 0x11l; AssertJUnit.assertEquals("multiply", result, 0x0000000880000000l); }
@Test
public void test02283() { x = 0x00000000ffffffffl; long result = x * 0x11l; AssertJUnit.assertEquals("multiply", result, 0x00000010ffffffefl); }
@Test
public void test02284() { x = 0x000000017fffffffl; long result = x * 0x11l; AssertJUnit.assertEquals("multiply", result, 0x000000197fffffefl); }
@Test
public void test02285() { x = 0x0000000180000000l; long result = x * 0x11l; AssertJUnit.assertEquals("multiply", result, 0x0000001980000000l); }
@Test
public void test02286() { x = 0x00000001ffffffffl; long result = x * 0x11l; AssertJUnit.assertEquals("multiply", result, 0x00000021ffffffefl); }
@Test
public void test02287() { x = 0xffffffff7fffffffl; long result = x * 0x11l; AssertJUnit.assertEquals("multiply", result, 0xfffffff77fffffefl); }
@Test
public void test02288() { x = 0xffffffff80000000l; long result = x * 0x11l; AssertJUnit.assertEquals("multiply", result, 0xfffffff780000000l); }
@Test
public void test02289() { x = 0x00000001deadf00dl; long result = x * 0x11l; AssertJUnit.assertEquals("multiply", result, 0x0000001fc98cf0ddl); }
@Test
public void test02290() { x = 0xffffffffdeadf00dl; long result = x * 0x11l; AssertJUnit.assertEquals("multiply", result, 0xfffffffdc98cf0ddl); }
@Test
public void test02291() { x = 0x7fffffffffffffffl; long result = x * 0x11l; AssertJUnit.assertEquals("multiply", result, 0x7fffffffffffffefl); }
@Test
public void test02292() { x = 0x7fffffff7fffffffl; long result = x * 0x11l; AssertJUnit.assertEquals("multiply", result, 0x7ffffff77fffffefl); }
@Test
public void test02293() { x = 0x7fffffff80000000l; long result = x * 0x11l; AssertJUnit.assertEquals("multiply", result, 0x7ffffff780000000l); }
@Test
public void test02294() { x = 0x7fffffffdeadf00dl; long result = x * 0x11l; AssertJUnit.assertEquals("multiply", result, 0x7ffffffdc98cf0ddl); }
@Test
public void test02295() { x = 0x8000000000000000l; long result = x * 0x11l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test02296() { x = 0xffffffffffffffffl; long result = x * 0x11l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffefl); }
@Test
public void test02297() { x = 0xfffffffffffffffel; long result = x * 0x11l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffdel); }
@Test
public void test02298() { x = 0xefffffffffffffffl; long result = x * 0x11l; AssertJUnit.assertEquals("multiply", result, 0xefffffffffffffefl); }
@Test
public void test02299() { x = 0xdeadf00ddeadf00dl; long result = x * 0x11l; AssertJUnit.assertEquals("multiply", result, 0xc98cf0ebc98cf0ddl); }
@Test
public void test02300() { x = 0x000000007fffffffl; long result = x * 0x88l; AssertJUnit.assertEquals("multiply", result, 0x00000043ffffff78l); }
@Test
public void test02301() { x = 0x0000000080000000l; long result = x * 0x88l; AssertJUnit.assertEquals("multiply", result, 0x0000004400000000l); }
@Test
public void test02302() { x = 0x00000000ffffffffl; long result = x * 0x88l; AssertJUnit.assertEquals("multiply", result, 0x00000087ffffff78l); }
@Test
public void test02303() { x = 0x000000017fffffffl; long result = x * 0x88l; AssertJUnit.assertEquals("multiply", result, 0x000000cbffffff78l); }
@Test
public void test02304() { x = 0x0000000180000000l; long result = x * 0x88l; AssertJUnit.assertEquals("multiply", result, 0x000000cc00000000l); }
@Test
public void test02305() { x = 0x00000001ffffffffl; long result = x * 0x88l; AssertJUnit.assertEquals("multiply", result, 0x0000010fffffff78l); }
@Test
public void test02306() { x = 0xffffffff7fffffffl; long result = x * 0x88l; AssertJUnit.assertEquals("multiply", result, 0xffffffbbffffff78l); }
@Test
public void test02307() { x = 0xffffffff80000000l; long result = x * 0x88l; AssertJUnit.assertEquals("multiply", result, 0xffffffbc00000000l); }
@Test
public void test02308() { x = 0x00000001deadf00dl; long result = x * 0x88l; AssertJUnit.assertEquals("multiply", result, 0x000000fe4c6786e8l); }
@Test
public void test02309() { x = 0xffffffffdeadf00dl; long result = x * 0x88l; AssertJUnit.assertEquals("multiply", result, 0xffffffee4c6786e8l); }
@Test
public void test02310() { x = 0x7fffffffffffffffl; long result = x * 0x88l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff78l); }
@Test
public void test02311() { x = 0x7fffffff7fffffffl; long result = x * 0x88l; AssertJUnit.assertEquals("multiply", result, 0xffffffbbffffff78l); }
@Test
public void test02312() { x = 0x7fffffff80000000l; long result = x * 0x88l; AssertJUnit.assertEquals("multiply", result, 0xffffffbc00000000l); }
@Test
public void test02313() { x = 0x7fffffffdeadf00dl; long result = x * 0x88l; AssertJUnit.assertEquals("multiply", result, 0xffffffee4c6786e8l); }
@Test
public void test02314() { x = 0x8000000000000000l; long result = x * 0x88l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02315() { x = 0xffffffffffffffffl; long result = x * 0x88l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff78l); }
@Test
public void test02316() { x = 0xfffffffffffffffel; long result = x * 0x88l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffef0l); }
@Test
public void test02317() { x = 0xefffffffffffffffl; long result = x * 0x88l; AssertJUnit.assertEquals("multiply", result, 0x7fffffffffffff78l); }
@Test
public void test02318() { x = 0xdeadf00ddeadf00dl; long result = x * 0x88l; AssertJUnit.assertEquals("multiply", result, 0x4c67875e4c6786e8l); }
@Test
public void test02319() { x = 0x000000007fffffffl; long result = x * 0x1100l; AssertJUnit.assertEquals("multiply", result, 0x0000087fffffef00l); }
@Test
public void test02320() { x = 0x0000000080000000l; long result = x * 0x1100l; AssertJUnit.assertEquals("multiply", result, 0x0000088000000000l); }
@Test
public void test02321() { x = 0x00000000ffffffffl; long result = x * 0x1100l; AssertJUnit.assertEquals("multiply", result, 0x000010ffffffef00l); }
@Test
public void test02322() { x = 0x000000017fffffffl; long result = x * 0x1100l; AssertJUnit.assertEquals("multiply", result, 0x0000197fffffef00l); }
@Test
public void test02323() { x = 0x0000000180000000l; long result = x * 0x1100l; AssertJUnit.assertEquals("multiply", result, 0x0000198000000000l); }
@Test
public void test02324() { x = 0x00000001ffffffffl; long result = x * 0x1100l; AssertJUnit.assertEquals("multiply", result, 0x000021ffffffef00l); }
@Test
public void test02325() { x = 0xffffffff7fffffffl; long result = x * 0x1100l; AssertJUnit.assertEquals("multiply", result, 0xfffff77fffffef00l); }
@Test
public void test02326() { x = 0xffffffff80000000l; long result = x * 0x1100l; AssertJUnit.assertEquals("multiply", result, 0xfffff78000000000l); }
@Test
public void test02327() { x = 0x00000001deadf00dl; long result = x * 0x1100l; AssertJUnit.assertEquals("multiply", result, 0x00001fc98cf0dd00l); }
@Test
public void test02328() { x = 0xffffffffdeadf00dl; long result = x * 0x1100l; AssertJUnit.assertEquals("multiply", result, 0xfffffdc98cf0dd00l); }
@Test
public void test02329() { x = 0x7fffffffffffffffl; long result = x * 0x1100l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffef00l); }
@Test
public void test02330() { x = 0x7fffffff7fffffffl; long result = x * 0x1100l; AssertJUnit.assertEquals("multiply", result, 0xfffff77fffffef00l); }
@Test
public void test02331() { x = 0x7fffffff80000000l; long result = x * 0x1100l; AssertJUnit.assertEquals("multiply", result, 0xfffff78000000000l); }
@Test
public void test02332() { x = 0x7fffffffdeadf00dl; long result = x * 0x1100l; AssertJUnit.assertEquals("multiply", result, 0xfffffdc98cf0dd00l); }
@Test
public void test02333() { x = 0x8000000000000000l; long result = x * 0x1100l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02334() { x = 0xffffffffffffffffl; long result = x * 0x1100l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffef00l); }
@Test
public void test02335() { x = 0xfffffffffffffffel; long result = x * 0x1100l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffde00l); }
@Test
public void test02336() { x = 0xefffffffffffffffl; long result = x * 0x1100l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffef00l); }
@Test
public void test02337() { x = 0xdeadf00ddeadf00dl; long result = x * 0x1100l; AssertJUnit.assertEquals("multiply", result, 0x8cf0ebc98cf0dd00l); }
@Test
public void test02338() { x = 0x000000007fffffffl; long result = x * 0x1100000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffef00000000l); }
@Test
public void test02339() { x = 0x0000000080000000l; long result = x * 0x1100000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test02340() { x = 0x00000000ffffffffl; long result = x * 0x1100000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffef00000000l); }
@Test
public void test02341() { x = 0x000000017fffffffl; long result = x * 0x1100000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffef00000000l); }
@Test
public void test02342() { x = 0x0000000180000000l; long result = x * 0x1100000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test02343() { x = 0x00000001ffffffffl; long result = x * 0x1100000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffef00000000l); }
@Test
public void test02344() { x = 0xffffffff7fffffffl; long result = x * 0x1100000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffef00000000l); }
@Test
public void test02345() { x = 0xffffffff80000000l; long result = x * 0x1100000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test02346() { x = 0x00000001deadf00dl; long result = x * 0x1100000000l; AssertJUnit.assertEquals("multiply", result, 0xc98cf0dd00000000l); }
@Test
public void test02347() { x = 0xffffffffdeadf00dl; long result = x * 0x1100000000l; AssertJUnit.assertEquals("multiply", result, 0xc98cf0dd00000000l); }
@Test
public void test02348() { x = 0x7fffffffffffffffl; long result = x * 0x1100000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffef00000000l); }
@Test
public void test02349() { x = 0x7fffffff7fffffffl; long result = x * 0x1100000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffef00000000l); }
@Test
public void test02350() { x = 0x7fffffff80000000l; long result = x * 0x1100000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test02351() { x = 0x7fffffffdeadf00dl; long result = x * 0x1100000000l; AssertJUnit.assertEquals("multiply", result, 0xc98cf0dd00000000l); }
@Test
public void test02352() { x = 0x8000000000000000l; long result = x * 0x1100000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02353() { x = 0xffffffffffffffffl; long result = x * 0x1100000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffef00000000l); }
@Test
public void test02354() { x = 0xfffffffffffffffel; long result = x * 0x1100000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffde00000000l); }
@Test
public void test02355() { x = 0xefffffffffffffffl; long result = x * 0x1100000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffef00000000l); }
@Test
public void test02356() { x = 0xdeadf00ddeadf00dl; long result = x * 0x1100000000l; AssertJUnit.assertEquals("multiply", result, 0xc98cf0dd00000000l); }
@Test
public void test02357() { x = 0x000000007fffffffl; long result = x * 0x8800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff7800000000l); }
@Test
public void test02358() { x = 0x0000000080000000l; long result = x * 0x8800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02359() { x = 0x00000000ffffffffl; long result = x * 0x8800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff7800000000l); }
@Test
public void test02360() { x = 0x000000017fffffffl; long result = x * 0x8800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff7800000000l); }
@Test
public void test02361() { x = 0x0000000180000000l; long result = x * 0x8800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02362() { x = 0x00000001ffffffffl; long result = x * 0x8800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff7800000000l); }
@Test
public void test02363() { x = 0xffffffff7fffffffl; long result = x * 0x8800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff7800000000l); }
@Test
public void test02364() { x = 0xffffffff80000000l; long result = x * 0x8800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02365() { x = 0x00000001deadf00dl; long result = x * 0x8800000000l; AssertJUnit.assertEquals("multiply", result, 0x4c6786e800000000l); }
@Test
public void test02366() { x = 0xffffffffdeadf00dl; long result = x * 0x8800000000l; AssertJUnit.assertEquals("multiply", result, 0x4c6786e800000000l); }
@Test
public void test02367() { x = 0x7fffffffffffffffl; long result = x * 0x8800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff7800000000l); }
@Test
public void test02368() { x = 0x7fffffff7fffffffl; long result = x * 0x8800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff7800000000l); }
@Test
public void test02369() { x = 0x7fffffff80000000l; long result = x * 0x8800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02370() { x = 0x7fffffffdeadf00dl; long result = x * 0x8800000000l; AssertJUnit.assertEquals("multiply", result, 0x4c6786e800000000l); }
@Test
public void test02371() { x = 0x8000000000000000l; long result = x * 0x8800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02372() { x = 0xffffffffffffffffl; long result = x * 0x8800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff7800000000l); }
@Test
public void test02373() { x = 0xfffffffffffffffel; long result = x * 0x8800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffef000000000l); }
@Test
public void test02374() { x = 0xefffffffffffffffl; long result = x * 0x8800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff7800000000l); }
@Test
public void test02375() { x = 0xdeadf00ddeadf00dl; long result = x * 0x8800000000l; AssertJUnit.assertEquals("multiply", result, 0x4c6786e800000000l); }
@Test
public void test02376() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffffefl; AssertJUnit.assertEquals("multiply", result, 0xfffffff780000011l); }
@Test
public void test02377() { x = 0x0000000080000000l; long result = x * 0xffffffffffffffefl; AssertJUnit.assertEquals("multiply", result, 0xfffffff780000000l); }
@Test
public void test02378() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffffefl; AssertJUnit.assertEquals("multiply", result, 0xffffffef00000011l); }
@Test
public void test02379() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffffefl; AssertJUnit.assertEquals("multiply", result, 0xffffffe680000011l); }
@Test
public void test02380() { x = 0x0000000180000000l; long result = x * 0xffffffffffffffefl; AssertJUnit.assertEquals("multiply", result, 0xffffffe680000000l); }
@Test
public void test02381() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffffefl; AssertJUnit.assertEquals("multiply", result, 0xffffffde00000011l); }
@Test
public void test02382() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffffefl; AssertJUnit.assertEquals("multiply", result, 0x0000000880000011l); }
@Test
public void test02383() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffffefl; AssertJUnit.assertEquals("multiply", result, 0x0000000880000000l); }
@Test
public void test02384() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffffefl; AssertJUnit.assertEquals("multiply", result, 0xffffffe036730f23l); }
@Test
public void test02385() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffffefl; AssertJUnit.assertEquals("multiply", result, 0x0000000236730f23l); }
@Test
public void test02386() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffffefl; AssertJUnit.assertEquals("multiply", result, 0x8000000000000011l); }
@Test
public void test02387() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffffefl; AssertJUnit.assertEquals("multiply", result, 0x8000000880000011l); }
@Test
public void test02388() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffffefl; AssertJUnit.assertEquals("multiply", result, 0x8000000880000000l); }
@Test
public void test02389() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffffefl; AssertJUnit.assertEquals("multiply", result, 0x8000000236730f23l); }
@Test
public void test02390() { x = 0x8000000000000000l; long result = x * 0xffffffffffffffefl; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test02391() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffffefl; AssertJUnit.assertEquals("multiply", result, 0x0000000000000011l); }
@Test
public void test02392() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffffefl; AssertJUnit.assertEquals("multiply", result, 0x0000000000000022l); }
@Test
public void test02393() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffffefl; AssertJUnit.assertEquals("multiply", result, 0x1000000000000011l); }
@Test
public void test02394() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffffefl; AssertJUnit.assertEquals("multiply", result, 0x36730f1436730f23l); }
@Test
public void test02395() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffff78l; AssertJUnit.assertEquals("multiply", result, 0xffffffbc00000088l); }
@Test
public void test02396() { x = 0x0000000080000000l; long result = x * 0xffffffffffffff78l; AssertJUnit.assertEquals("multiply", result, 0xffffffbc00000000l); }
@Test
public void test02397() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffff78l; AssertJUnit.assertEquals("multiply", result, 0xffffff7800000088l); }
@Test
public void test02398() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffff78l; AssertJUnit.assertEquals("multiply", result, 0xffffff3400000088l); }
@Test
public void test02399() { x = 0x0000000180000000l; long result = x * 0xffffffffffffff78l; AssertJUnit.assertEquals("multiply", result, 0xffffff3400000000l); }
@Test
public void test02400() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffff78l; AssertJUnit.assertEquals("multiply", result, 0xfffffef000000088l); }
@Test
public void test02401() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffff78l; AssertJUnit.assertEquals("multiply", result, 0x0000004400000088l); }
@Test
public void test02402() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffff78l; AssertJUnit.assertEquals("multiply", result, 0x0000004400000000l); }
@Test
public void test02403() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffff78l; AssertJUnit.assertEquals("multiply", result, 0xffffff01b3987918l); }
@Test
public void test02404() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffff78l; AssertJUnit.assertEquals("multiply", result, 0x00000011b3987918l); }
@Test
public void test02405() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffff78l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000088l); }
@Test
public void test02406() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffff78l; AssertJUnit.assertEquals("multiply", result, 0x0000004400000088l); }
@Test
public void test02407() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffff78l; AssertJUnit.assertEquals("multiply", result, 0x0000004400000000l); }
@Test
public void test02408() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffff78l; AssertJUnit.assertEquals("multiply", result, 0x00000011b3987918l); }
@Test
public void test02409() { x = 0x8000000000000000l; long result = x * 0xffffffffffffff78l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02410() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffff78l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000088l); }
@Test
public void test02411() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffff78l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000110l); }
@Test
public void test02412() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffff78l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000088l); }
@Test
public void test02413() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffff78l; AssertJUnit.assertEquals("multiply", result, 0xb39878a1b3987918l); }
@Test
public void test02414() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffef00l; AssertJUnit.assertEquals("multiply", result, 0xfffff78000001100l); }
@Test
public void test02415() { x = 0x0000000080000000l; long result = x * 0xffffffffffffef00l; AssertJUnit.assertEquals("multiply", result, 0xfffff78000000000l); }
@Test
public void test02416() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffef00l; AssertJUnit.assertEquals("multiply", result, 0xffffef0000001100l); }
@Test
public void test02417() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffef00l; AssertJUnit.assertEquals("multiply", result, 0xffffe68000001100l); }
@Test
public void test02418() { x = 0x0000000180000000l; long result = x * 0xffffffffffffef00l; AssertJUnit.assertEquals("multiply", result, 0xffffe68000000000l); }
@Test
public void test02419() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffef00l; AssertJUnit.assertEquals("multiply", result, 0xffffde0000001100l); }
@Test
public void test02420() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffef00l; AssertJUnit.assertEquals("multiply", result, 0x0000088000001100l); }
@Test
public void test02421() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffef00l; AssertJUnit.assertEquals("multiply", result, 0x0000088000000000l); }
@Test
public void test02422() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffef00l; AssertJUnit.assertEquals("multiply", result, 0xffffe036730f2300l); }
@Test
public void test02423() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffef00l; AssertJUnit.assertEquals("multiply", result, 0x00000236730f2300l); }
@Test
public void test02424() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffef00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001100l); }
@Test
public void test02425() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffef00l; AssertJUnit.assertEquals("multiply", result, 0x0000088000001100l); }
@Test
public void test02426() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffef00l; AssertJUnit.assertEquals("multiply", result, 0x0000088000000000l); }
@Test
public void test02427() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffef00l; AssertJUnit.assertEquals("multiply", result, 0x00000236730f2300l); }
@Test
public void test02428() { x = 0x8000000000000000l; long result = x * 0xffffffffffffef00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02429() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffef00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001100l); }
@Test
public void test02430() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffef00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000002200l); }
@Test
public void test02431() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffef00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001100l); }
@Test
public void test02432() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffef00l; AssertJUnit.assertEquals("multiply", result, 0x730f1436730f2300l); }
@Test
public void test02433() { x = 0x000000007fffffffl; long result = x * 0xffffffef00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000001100000000l); }
@Test
public void test02434() { x = 0x0000000080000000l; long result = x * 0xffffffef00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test02435() { x = 0x00000000ffffffffl; long result = x * 0xffffffef00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001100000000l); }
@Test
public void test02436() { x = 0x000000017fffffffl; long result = x * 0xffffffef00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000001100000000l); }
@Test
public void test02437() { x = 0x0000000180000000l; long result = x * 0xffffffef00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test02438() { x = 0x00000001ffffffffl; long result = x * 0xffffffef00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001100000000l); }
@Test
public void test02439() { x = 0xffffffff7fffffffl; long result = x * 0xffffffef00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000001100000000l); }
@Test
public void test02440() { x = 0xffffffff80000000l; long result = x * 0xffffffef00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test02441() { x = 0x00000001deadf00dl; long result = x * 0xffffffef00000000l; AssertJUnit.assertEquals("multiply", result, 0x36730f2300000000l); }
@Test
public void test02442() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffef00000000l; AssertJUnit.assertEquals("multiply", result, 0x36730f2300000000l); }
@Test
public void test02443() { x = 0x7fffffffffffffffl; long result = x * 0xffffffef00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001100000000l); }
@Test
public void test02444() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffef00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000001100000000l); }
@Test
public void test02445() { x = 0x7fffffff80000000l; long result = x * 0xffffffef00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test02446() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffef00000000l; AssertJUnit.assertEquals("multiply", result, 0x36730f2300000000l); }
@Test
public void test02447() { x = 0x8000000000000000l; long result = x * 0xffffffef00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02448() { x = 0xffffffffffffffffl; long result = x * 0xffffffef00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001100000000l); }
@Test
public void test02449() { x = 0xfffffffffffffffel; long result = x * 0xffffffef00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002200000000l); }
@Test
public void test02450() { x = 0xefffffffffffffffl; long result = x * 0xffffffef00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001100000000l); }
@Test
public void test02451() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffef00000000l; AssertJUnit.assertEquals("multiply", result, 0x36730f2300000000l); }
@Test
public void test02452() { x = 0x000000007fffffffl; long result = x * 0xffffff7800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000008800000000l); }
@Test
public void test02453() { x = 0x0000000080000000l; long result = x * 0xffffff7800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02454() { x = 0x00000000ffffffffl; long result = x * 0xffffff7800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000008800000000l); }
@Test
public void test02455() { x = 0x000000017fffffffl; long result = x * 0xffffff7800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000008800000000l); }
@Test
public void test02456() { x = 0x0000000180000000l; long result = x * 0xffffff7800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02457() { x = 0x00000001ffffffffl; long result = x * 0xffffff7800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000008800000000l); }
@Test
public void test02458() { x = 0xffffffff7fffffffl; long result = x * 0xffffff7800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000008800000000l); }
@Test
public void test02459() { x = 0xffffffff80000000l; long result = x * 0xffffff7800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02460() { x = 0x00000001deadf00dl; long result = x * 0xffffff7800000000l; AssertJUnit.assertEquals("multiply", result, 0xb398791800000000l); }
@Test
public void test02461() { x = 0xffffffffdeadf00dl; long result = x * 0xffffff7800000000l; AssertJUnit.assertEquals("multiply", result, 0xb398791800000000l); }
@Test
public void test02462() { x = 0x7fffffffffffffffl; long result = x * 0xffffff7800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000008800000000l); }
@Test
public void test02463() { x = 0x7fffffff7fffffffl; long result = x * 0xffffff7800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000008800000000l); }
@Test
public void test02464() { x = 0x7fffffff80000000l; long result = x * 0xffffff7800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02465() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffff7800000000l; AssertJUnit.assertEquals("multiply", result, 0xb398791800000000l); }
@Test
public void test02466() { x = 0x8000000000000000l; long result = x * 0xffffff7800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02467() { x = 0xffffffffffffffffl; long result = x * 0xffffff7800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000008800000000l); }
@Test
public void test02468() { x = 0xfffffffffffffffel; long result = x * 0xffffff7800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000011000000000l); }
@Test
public void test02469() { x = 0xefffffffffffffffl; long result = x * 0xffffff7800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000008800000000l); }
@Test
public void test02470() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffff7800000000l; AssertJUnit.assertEquals("multiply", result, 0xb398791800000000l); }
@Test
public void test02471() { x = 0x000000007fffffffl; long result = x * 0x12l; AssertJUnit.assertEquals("multiply", result, 0x00000008ffffffeel); }
@Test
public void test02472() { x = 0x0000000080000000l; long result = x * 0x12l; AssertJUnit.assertEquals("multiply", result, 0x0000000900000000l); }
@Test
public void test02473() { x = 0x00000000ffffffffl; long result = x * 0x12l; AssertJUnit.assertEquals("multiply", result, 0x00000011ffffffeel); }
@Test
public void test02474() { x = 0x000000017fffffffl; long result = x * 0x12l; AssertJUnit.assertEquals("multiply", result, 0x0000001affffffeel); }
@Test
public void test02475() { x = 0x0000000180000000l; long result = x * 0x12l; AssertJUnit.assertEquals("multiply", result, 0x0000001b00000000l); }
@Test
public void test02476() { x = 0x00000001ffffffffl; long result = x * 0x12l; AssertJUnit.assertEquals("multiply", result, 0x00000023ffffffeel); }
@Test
public void test02477() { x = 0xffffffff7fffffffl; long result = x * 0x12l; AssertJUnit.assertEquals("multiply", result, 0xfffffff6ffffffeel); }
@Test
public void test02478() { x = 0xffffffff80000000l; long result = x * 0x12l; AssertJUnit.assertEquals("multiply", result, 0xfffffff700000000l); }
@Test
public void test02479() { x = 0x00000001deadf00dl; long result = x * 0x12l; AssertJUnit.assertEquals("multiply", result, 0x00000021a83ae0eal); }
@Test
public void test02480() { x = 0xffffffffdeadf00dl; long result = x * 0x12l; AssertJUnit.assertEquals("multiply", result, 0xfffffffda83ae0eal); }
@Test
public void test02481() { x = 0x7fffffffffffffffl; long result = x * 0x12l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffeel); }
@Test
public void test02482() { x = 0x7fffffff7fffffffl; long result = x * 0x12l; AssertJUnit.assertEquals("multiply", result, 0xfffffff6ffffffeel); }
@Test
public void test02483() { x = 0x7fffffff80000000l; long result = x * 0x12l; AssertJUnit.assertEquals("multiply", result, 0xfffffff700000000l); }
@Test
public void test02484() { x = 0x7fffffffdeadf00dl; long result = x * 0x12l; AssertJUnit.assertEquals("multiply", result, 0xfffffffda83ae0eal); }
@Test
public void test02485() { x = 0x8000000000000000l; long result = x * 0x12l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02486() { x = 0xffffffffffffffffl; long result = x * 0x12l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffeel); }
@Test
public void test02487() { x = 0xfffffffffffffffel; long result = x * 0x12l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffdcl); }
@Test
public void test02488() { x = 0xefffffffffffffffl; long result = x * 0x12l; AssertJUnit.assertEquals("multiply", result, 0xdfffffffffffffeel); }
@Test
public void test02489() { x = 0xdeadf00ddeadf00dl; long result = x * 0x12l; AssertJUnit.assertEquals("multiply", result, 0xa83ae0f9a83ae0eal); }
@Test
public void test02490() { x = 0x000000007fffffffl; long result = x * 0x90l; AssertJUnit.assertEquals("multiply", result, 0x00000047ffffff70l); }
@Test
public void test02491() { x = 0x0000000080000000l; long result = x * 0x90l; AssertJUnit.assertEquals("multiply", result, 0x0000004800000000l); }
@Test
public void test02492() { x = 0x00000000ffffffffl; long result = x * 0x90l; AssertJUnit.assertEquals("multiply", result, 0x0000008fffffff70l); }
@Test
public void test02493() { x = 0x000000017fffffffl; long result = x * 0x90l; AssertJUnit.assertEquals("multiply", result, 0x000000d7ffffff70l); }
@Test
public void test02494() { x = 0x0000000180000000l; long result = x * 0x90l; AssertJUnit.assertEquals("multiply", result, 0x000000d800000000l); }
@Test
public void test02495() { x = 0x00000001ffffffffl; long result = x * 0x90l; AssertJUnit.assertEquals("multiply", result, 0x0000011fffffff70l); }
@Test
public void test02496() { x = 0xffffffff7fffffffl; long result = x * 0x90l; AssertJUnit.assertEquals("multiply", result, 0xffffffb7ffffff70l); }
@Test
public void test02497() { x = 0xffffffff80000000l; long result = x * 0x90l; AssertJUnit.assertEquals("multiply", result, 0xffffffb800000000l); }
@Test
public void test02498() { x = 0x00000001deadf00dl; long result = x * 0x90l; AssertJUnit.assertEquals("multiply", result, 0x0000010d41d70750l); }
@Test
public void test02499() { x = 0xffffffffdeadf00dl; long result = x * 0x90l; AssertJUnit.assertEquals("multiply", result, 0xffffffed41d70750l); }
@Test
public void test02500() { x = 0x7fffffffffffffffl; long result = x * 0x90l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff70l); }
@Test
public void test02501() { x = 0x7fffffff7fffffffl; long result = x * 0x90l; AssertJUnit.assertEquals("multiply", result, 0xffffffb7ffffff70l); }
@Test
public void test02502() { x = 0x7fffffff80000000l; long result = x * 0x90l; AssertJUnit.assertEquals("multiply", result, 0xffffffb800000000l); }
@Test
public void test02503() { x = 0x7fffffffdeadf00dl; long result = x * 0x90l; AssertJUnit.assertEquals("multiply", result, 0xffffffed41d70750l); }
@Test
public void test02504() { x = 0x8000000000000000l; long result = x * 0x90l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02505() { x = 0xffffffffffffffffl; long result = x * 0x90l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff70l); }
@Test
public void test02506() { x = 0xfffffffffffffffel; long result = x * 0x90l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffee0l); }
@Test
public void test02507() { x = 0xefffffffffffffffl; long result = x * 0x90l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff70l); }
@Test
public void test02508() { x = 0xdeadf00ddeadf00dl; long result = x * 0x90l; AssertJUnit.assertEquals("multiply", result, 0x41d707cd41d70750l); }
@Test
public void test02509() { x = 0x000000007fffffffl; long result = x * 0x1200l; AssertJUnit.assertEquals("multiply", result, 0x000008ffffffee00l); }
@Test
public void test02510() { x = 0x0000000080000000l; long result = x * 0x1200l; AssertJUnit.assertEquals("multiply", result, 0x0000090000000000l); }
@Test
public void test02511() { x = 0x00000000ffffffffl; long result = x * 0x1200l; AssertJUnit.assertEquals("multiply", result, 0x000011ffffffee00l); }
@Test
public void test02512() { x = 0x000000017fffffffl; long result = x * 0x1200l; AssertJUnit.assertEquals("multiply", result, 0x00001affffffee00l); }
@Test
public void test02513() { x = 0x0000000180000000l; long result = x * 0x1200l; AssertJUnit.assertEquals("multiply", result, 0x00001b0000000000l); }
@Test
public void test02514() { x = 0x00000001ffffffffl; long result = x * 0x1200l; AssertJUnit.assertEquals("multiply", result, 0x000023ffffffee00l); }
@Test
public void test02515() { x = 0xffffffff7fffffffl; long result = x * 0x1200l; AssertJUnit.assertEquals("multiply", result, 0xfffff6ffffffee00l); }
@Test
public void test02516() { x = 0xffffffff80000000l; long result = x * 0x1200l; AssertJUnit.assertEquals("multiply", result, 0xfffff70000000000l); }
@Test
public void test02517() { x = 0x00000001deadf00dl; long result = x * 0x1200l; AssertJUnit.assertEquals("multiply", result, 0x000021a83ae0ea00l); }
@Test
public void test02518() { x = 0xffffffffdeadf00dl; long result = x * 0x1200l; AssertJUnit.assertEquals("multiply", result, 0xfffffda83ae0ea00l); }
@Test
public void test02519() { x = 0x7fffffffffffffffl; long result = x * 0x1200l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffee00l); }
@Test
public void test02520() { x = 0x7fffffff7fffffffl; long result = x * 0x1200l; AssertJUnit.assertEquals("multiply", result, 0xfffff6ffffffee00l); }
@Test
public void test02521() { x = 0x7fffffff80000000l; long result = x * 0x1200l; AssertJUnit.assertEquals("multiply", result, 0xfffff70000000000l); }
@Test
public void test02522() { x = 0x7fffffffdeadf00dl; long result = x * 0x1200l; AssertJUnit.assertEquals("multiply", result, 0xfffffda83ae0ea00l); }
@Test
public void test02523() { x = 0x8000000000000000l; long result = x * 0x1200l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02524() { x = 0xffffffffffffffffl; long result = x * 0x1200l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffee00l); }
@Test
public void test02525() { x = 0xfffffffffffffffel; long result = x * 0x1200l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffdc00l); }
@Test
public void test02526() { x = 0xefffffffffffffffl; long result = x * 0x1200l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffee00l); }
@Test
public void test02527() { x = 0xdeadf00ddeadf00dl; long result = x * 0x1200l; AssertJUnit.assertEquals("multiply", result, 0x3ae0f9a83ae0ea00l); }
@Test
public void test02528() { x = 0x000000007fffffffl; long result = x * 0x1200000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffee00000000l); }
@Test
public void test02529() { x = 0x0000000080000000l; long result = x * 0x1200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02530() { x = 0x00000000ffffffffl; long result = x * 0x1200000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffee00000000l); }
@Test
public void test02531() { x = 0x000000017fffffffl; long result = x * 0x1200000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffee00000000l); }
@Test
public void test02532() { x = 0x0000000180000000l; long result = x * 0x1200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02533() { x = 0x00000001ffffffffl; long result = x * 0x1200000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffee00000000l); }
@Test
public void test02534() { x = 0xffffffff7fffffffl; long result = x * 0x1200000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffee00000000l); }
@Test
public void test02535() { x = 0xffffffff80000000l; long result = x * 0x1200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02536() { x = 0x00000001deadf00dl; long result = x * 0x1200000000l; AssertJUnit.assertEquals("multiply", result, 0xa83ae0ea00000000l); }
@Test
public void test02537() { x = 0xffffffffdeadf00dl; long result = x * 0x1200000000l; AssertJUnit.assertEquals("multiply", result, 0xa83ae0ea00000000l); }
@Test
public void test02538() { x = 0x7fffffffffffffffl; long result = x * 0x1200000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffee00000000l); }
@Test
public void test02539() { x = 0x7fffffff7fffffffl; long result = x * 0x1200000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffee00000000l); }
@Test
public void test02540() { x = 0x7fffffff80000000l; long result = x * 0x1200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02541() { x = 0x7fffffffdeadf00dl; long result = x * 0x1200000000l; AssertJUnit.assertEquals("multiply", result, 0xa83ae0ea00000000l); }
@Test
public void test02542() { x = 0x8000000000000000l; long result = x * 0x1200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02543() { x = 0xffffffffffffffffl; long result = x * 0x1200000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffee00000000l); }
@Test
public void test02544() { x = 0xfffffffffffffffel; long result = x * 0x1200000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffdc00000000l); }
@Test
public void test02545() { x = 0xefffffffffffffffl; long result = x * 0x1200000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffee00000000l); }
@Test
public void test02546() { x = 0xdeadf00ddeadf00dl; long result = x * 0x1200000000l; AssertJUnit.assertEquals("multiply", result, 0xa83ae0ea00000000l); }
@Test
public void test02547() { x = 0x000000007fffffffl; long result = x * 0x9000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff7000000000l); }
@Test
public void test02548() { x = 0x0000000080000000l; long result = x * 0x9000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02549() { x = 0x00000000ffffffffl; long result = x * 0x9000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff7000000000l); }
@Test
public void test02550() { x = 0x000000017fffffffl; long result = x * 0x9000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff7000000000l); }
@Test
public void test02551() { x = 0x0000000180000000l; long result = x * 0x9000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02552() { x = 0x00000001ffffffffl; long result = x * 0x9000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff7000000000l); }
@Test
public void test02553() { x = 0xffffffff7fffffffl; long result = x * 0x9000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff7000000000l); }
@Test
public void test02554() { x = 0xffffffff80000000l; long result = x * 0x9000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02555() { x = 0x00000001deadf00dl; long result = x * 0x9000000000l; AssertJUnit.assertEquals("multiply", result, 0x41d7075000000000l); }
@Test
public void test02556() { x = 0xffffffffdeadf00dl; long result = x * 0x9000000000l; AssertJUnit.assertEquals("multiply", result, 0x41d7075000000000l); }
@Test
public void test02557() { x = 0x7fffffffffffffffl; long result = x * 0x9000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff7000000000l); }
@Test
public void test02558() { x = 0x7fffffff7fffffffl; long result = x * 0x9000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff7000000000l); }
@Test
public void test02559() { x = 0x7fffffff80000000l; long result = x * 0x9000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02560() { x = 0x7fffffffdeadf00dl; long result = x * 0x9000000000l; AssertJUnit.assertEquals("multiply", result, 0x41d7075000000000l); }
@Test
public void test02561() { x = 0x8000000000000000l; long result = x * 0x9000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02562() { x = 0xffffffffffffffffl; long result = x * 0x9000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff7000000000l); }
@Test
public void test02563() { x = 0xfffffffffffffffel; long result = x * 0x9000000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffee000000000l); }
@Test
public void test02564() { x = 0xefffffffffffffffl; long result = x * 0x9000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff7000000000l); }
@Test
public void test02565() { x = 0xdeadf00ddeadf00dl; long result = x * 0x9000000000l; AssertJUnit.assertEquals("multiply", result, 0x41d7075000000000l); }
@Test
public void test02566() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffffeel; AssertJUnit.assertEquals("multiply", result, 0xfffffff700000012l); }
@Test
public void test02567() { x = 0x0000000080000000l; long result = x * 0xffffffffffffffeel; AssertJUnit.assertEquals("multiply", result, 0xfffffff700000000l); }
@Test
public void test02568() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffffeel; AssertJUnit.assertEquals("multiply", result, 0xffffffee00000012l); }
@Test
public void test02569() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffffeel; AssertJUnit.assertEquals("multiply", result, 0xffffffe500000012l); }
@Test
public void test02570() { x = 0x0000000180000000l; long result = x * 0xffffffffffffffeel; AssertJUnit.assertEquals("multiply", result, 0xffffffe500000000l); }
@Test
public void test02571() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffffeel; AssertJUnit.assertEquals("multiply", result, 0xffffffdc00000012l); }
@Test
public void test02572() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffffeel; AssertJUnit.assertEquals("multiply", result, 0x0000000900000012l); }
@Test
public void test02573() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffffeel; AssertJUnit.assertEquals("multiply", result, 0x0000000900000000l); }
@Test
public void test02574() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffffeel; AssertJUnit.assertEquals("multiply", result, 0xffffffde57c51f16l); }
@Test
public void test02575() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffffeel; AssertJUnit.assertEquals("multiply", result, 0x0000000257c51f16l); }
@Test
public void test02576() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffffeel; AssertJUnit.assertEquals("multiply", result, 0x0000000000000012l); }
@Test
public void test02577() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffffeel; AssertJUnit.assertEquals("multiply", result, 0x0000000900000012l); }
@Test
public void test02578() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffffeel; AssertJUnit.assertEquals("multiply", result, 0x0000000900000000l); }
@Test
public void test02579() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffffeel; AssertJUnit.assertEquals("multiply", result, 0x0000000257c51f16l); }
@Test
public void test02580() { x = 0x8000000000000000l; long result = x * 0xffffffffffffffeel; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02581() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffffeel; AssertJUnit.assertEquals("multiply", result, 0x0000000000000012l); }
@Test
public void test02582() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffffeel; AssertJUnit.assertEquals("multiply", result, 0x0000000000000024l); }
@Test
public void test02583() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffffeel; AssertJUnit.assertEquals("multiply", result, 0x2000000000000012l); }
@Test
public void test02584() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffffeel; AssertJUnit.assertEquals("multiply", result, 0x57c51f0657c51f16l); }
@Test
public void test02585() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffff70l; AssertJUnit.assertEquals("multiply", result, 0xffffffb800000090l); }
@Test
public void test02586() { x = 0x0000000080000000l; long result = x * 0xffffffffffffff70l; AssertJUnit.assertEquals("multiply", result, 0xffffffb800000000l); }
@Test
public void test02587() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffff70l; AssertJUnit.assertEquals("multiply", result, 0xffffff7000000090l); }
@Test
public void test02588() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffff70l; AssertJUnit.assertEquals("multiply", result, 0xffffff2800000090l); }
@Test
public void test02589() { x = 0x0000000180000000l; long result = x * 0xffffffffffffff70l; AssertJUnit.assertEquals("multiply", result, 0xffffff2800000000l); }
@Test
public void test02590() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffff70l; AssertJUnit.assertEquals("multiply", result, 0xfffffee000000090l); }
@Test
public void test02591() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffff70l; AssertJUnit.assertEquals("multiply", result, 0x0000004800000090l); }
@Test
public void test02592() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffff70l; AssertJUnit.assertEquals("multiply", result, 0x0000004800000000l); }
@Test
public void test02593() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffff70l; AssertJUnit.assertEquals("multiply", result, 0xfffffef2be28f8b0l); }
@Test
public void test02594() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffff70l; AssertJUnit.assertEquals("multiply", result, 0x00000012be28f8b0l); }
@Test
public void test02595() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffff70l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000090l); }
@Test
public void test02596() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffff70l; AssertJUnit.assertEquals("multiply", result, 0x0000004800000090l); }
@Test
public void test02597() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffff70l; AssertJUnit.assertEquals("multiply", result, 0x0000004800000000l); }
@Test
public void test02598() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffff70l; AssertJUnit.assertEquals("multiply", result, 0x00000012be28f8b0l); }
@Test
public void test02599() { x = 0x8000000000000000l; long result = x * 0xffffffffffffff70l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02600() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffff70l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000090l); }
@Test
public void test02601() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffff70l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000120l); }
@Test
public void test02602() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffff70l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000090l); }
@Test
public void test02603() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffff70l; AssertJUnit.assertEquals("multiply", result, 0xbe28f832be28f8b0l); }
@Test
public void test02604() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffee00l; AssertJUnit.assertEquals("multiply", result, 0xfffff70000001200l); }
@Test
public void test02605() { x = 0x0000000080000000l; long result = x * 0xffffffffffffee00l; AssertJUnit.assertEquals("multiply", result, 0xfffff70000000000l); }
@Test
public void test02606() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffee00l; AssertJUnit.assertEquals("multiply", result, 0xffffee0000001200l); }
@Test
public void test02607() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffee00l; AssertJUnit.assertEquals("multiply", result, 0xffffe50000001200l); }
@Test
public void test02608() { x = 0x0000000180000000l; long result = x * 0xffffffffffffee00l; AssertJUnit.assertEquals("multiply", result, 0xffffe50000000000l); }
@Test
public void test02609() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffee00l; AssertJUnit.assertEquals("multiply", result, 0xffffdc0000001200l); }
@Test
public void test02610() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffee00l; AssertJUnit.assertEquals("multiply", result, 0x0000090000001200l); }
@Test
public void test02611() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffee00l; AssertJUnit.assertEquals("multiply", result, 0x0000090000000000l); }
@Test
public void test02612() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffee00l; AssertJUnit.assertEquals("multiply", result, 0xffffde57c51f1600l); }
@Test
public void test02613() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffee00l; AssertJUnit.assertEquals("multiply", result, 0x00000257c51f1600l); }
@Test
public void test02614() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffee00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001200l); }
@Test
public void test02615() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffee00l; AssertJUnit.assertEquals("multiply", result, 0x0000090000001200l); }
@Test
public void test02616() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffee00l; AssertJUnit.assertEquals("multiply", result, 0x0000090000000000l); }
@Test
public void test02617() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffee00l; AssertJUnit.assertEquals("multiply", result, 0x00000257c51f1600l); }
@Test
public void test02618() { x = 0x8000000000000000l; long result = x * 0xffffffffffffee00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02619() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffee00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001200l); }
@Test
public void test02620() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffee00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000002400l); }
@Test
public void test02621() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffee00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001200l); }
@Test
public void test02622() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffee00l; AssertJUnit.assertEquals("multiply", result, 0xc51f0657c51f1600l); }
@Test
public void test02623() { x = 0x000000007fffffffl; long result = x * 0xffffffee00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001200000000l); }
@Test
public void test02624() { x = 0x0000000080000000l; long result = x * 0xffffffee00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02625() { x = 0x00000000ffffffffl; long result = x * 0xffffffee00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001200000000l); }
@Test
public void test02626() { x = 0x000000017fffffffl; long result = x * 0xffffffee00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001200000000l); }
@Test
public void test02627() { x = 0x0000000180000000l; long result = x * 0xffffffee00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02628() { x = 0x00000001ffffffffl; long result = x * 0xffffffee00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001200000000l); }
@Test
public void test02629() { x = 0xffffffff7fffffffl; long result = x * 0xffffffee00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001200000000l); }
@Test
public void test02630() { x = 0xffffffff80000000l; long result = x * 0xffffffee00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02631() { x = 0x00000001deadf00dl; long result = x * 0xffffffee00000000l; AssertJUnit.assertEquals("multiply", result, 0x57c51f1600000000l); }
@Test
public void test02632() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffee00000000l; AssertJUnit.assertEquals("multiply", result, 0x57c51f1600000000l); }
@Test
public void test02633() { x = 0x7fffffffffffffffl; long result = x * 0xffffffee00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001200000000l); }
@Test
public void test02634() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffee00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001200000000l); }
@Test
public void test02635() { x = 0x7fffffff80000000l; long result = x * 0xffffffee00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02636() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffee00000000l; AssertJUnit.assertEquals("multiply", result, 0x57c51f1600000000l); }
@Test
public void test02637() { x = 0x8000000000000000l; long result = x * 0xffffffee00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02638() { x = 0xffffffffffffffffl; long result = x * 0xffffffee00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001200000000l); }
@Test
public void test02639() { x = 0xfffffffffffffffel; long result = x * 0xffffffee00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002400000000l); }
@Test
public void test02640() { x = 0xefffffffffffffffl; long result = x * 0xffffffee00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001200000000l); }
@Test
public void test02641() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffee00000000l; AssertJUnit.assertEquals("multiply", result, 0x57c51f1600000000l); }
@Test
public void test02642() { x = 0x000000007fffffffl; long result = x * 0xffffff7000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000009000000000l); }
@Test
public void test02643() { x = 0x0000000080000000l; long result = x * 0xffffff7000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02644() { x = 0x00000000ffffffffl; long result = x * 0xffffff7000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000009000000000l); }
@Test
public void test02645() { x = 0x000000017fffffffl; long result = x * 0xffffff7000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000009000000000l); }
@Test
public void test02646() { x = 0x0000000180000000l; long result = x * 0xffffff7000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02647() { x = 0x00000001ffffffffl; long result = x * 0xffffff7000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000009000000000l); }
@Test
public void test02648() { x = 0xffffffff7fffffffl; long result = x * 0xffffff7000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000009000000000l); }
@Test
public void test02649() { x = 0xffffffff80000000l; long result = x * 0xffffff7000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02650() { x = 0x00000001deadf00dl; long result = x * 0xffffff7000000000l; AssertJUnit.assertEquals("multiply", result, 0xbe28f8b000000000l); }
@Test
public void test02651() { x = 0xffffffffdeadf00dl; long result = x * 0xffffff7000000000l; AssertJUnit.assertEquals("multiply", result, 0xbe28f8b000000000l); }
@Test
public void test02652() { x = 0x7fffffffffffffffl; long result = x * 0xffffff7000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000009000000000l); }
@Test
public void test02653() { x = 0x7fffffff7fffffffl; long result = x * 0xffffff7000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000009000000000l); }
@Test
public void test02654() { x = 0x7fffffff80000000l; long result = x * 0xffffff7000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02655() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffff7000000000l; AssertJUnit.assertEquals("multiply", result, 0xbe28f8b000000000l); }
@Test
public void test02656() { x = 0x8000000000000000l; long result = x * 0xffffff7000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02657() { x = 0xffffffffffffffffl; long result = x * 0xffffff7000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000009000000000l); }
@Test
public void test02658() { x = 0xfffffffffffffffel; long result = x * 0xffffff7000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000012000000000l); }
@Test
public void test02659() { x = 0xefffffffffffffffl; long result = x * 0xffffff7000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000009000000000l); }
@Test
public void test02660() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffff7000000000l; AssertJUnit.assertEquals("multiply", result, 0xbe28f8b000000000l); }
@Test
public void test02661() { x = 0x000000007fffffffl; long result = x * 0x13l; AssertJUnit.assertEquals("multiply", result, 0x000000097fffffedl); }
@Test
public void test02662() { x = 0x0000000080000000l; long result = x * 0x13l; AssertJUnit.assertEquals("multiply", result, 0x0000000980000000l); }
@Test
public void test02663() { x = 0x00000000ffffffffl; long result = x * 0x13l; AssertJUnit.assertEquals("multiply", result, 0x00000012ffffffedl); }
@Test
public void test02664() { x = 0x000000017fffffffl; long result = x * 0x13l; AssertJUnit.assertEquals("multiply", result, 0x0000001c7fffffedl); }
@Test
public void test02665() { x = 0x0000000180000000l; long result = x * 0x13l; AssertJUnit.assertEquals("multiply", result, 0x0000001c80000000l); }
@Test
public void test02666() { x = 0x00000001ffffffffl; long result = x * 0x13l; AssertJUnit.assertEquals("multiply", result, 0x00000025ffffffedl); }
@Test
public void test02667() { x = 0xffffffff7fffffffl; long result = x * 0x13l; AssertJUnit.assertEquals("multiply", result, 0xfffffff67fffffedl); }
@Test
public void test02668() { x = 0xffffffff80000000l; long result = x * 0x13l; AssertJUnit.assertEquals("multiply", result, 0xfffffff680000000l); }
@Test
public void test02669() { x = 0x00000001deadf00dl; long result = x * 0x13l; AssertJUnit.assertEquals("multiply", result, 0x0000002386e8d0f7l); }
@Test
public void test02670() { x = 0xffffffffdeadf00dl; long result = x * 0x13l; AssertJUnit.assertEquals("multiply", result, 0xfffffffd86e8d0f7l); }
@Test
public void test02671() { x = 0x7fffffffffffffffl; long result = x * 0x13l; AssertJUnit.assertEquals("multiply", result, 0x7fffffffffffffedl); }
@Test
public void test02672() { x = 0x7fffffff7fffffffl; long result = x * 0x13l; AssertJUnit.assertEquals("multiply", result, 0x7ffffff67fffffedl); }
@Test
public void test02673() { x = 0x7fffffff80000000l; long result = x * 0x13l; AssertJUnit.assertEquals("multiply", result, 0x7ffffff680000000l); }
@Test
public void test02674() { x = 0x7fffffffdeadf00dl; long result = x * 0x13l; AssertJUnit.assertEquals("multiply", result, 0x7ffffffd86e8d0f7l); }
@Test
public void test02675() { x = 0x8000000000000000l; long result = x * 0x13l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test02676() { x = 0xffffffffffffffffl; long result = x * 0x13l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffedl); }
@Test
public void test02677() { x = 0xfffffffffffffffel; long result = x * 0x13l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffdal); }
@Test
public void test02678() { x = 0xefffffffffffffffl; long result = x * 0x13l; AssertJUnit.assertEquals("multiply", result, 0xcfffffffffffffedl); }
@Test
public void test02679() { x = 0xdeadf00ddeadf00dl; long result = x * 0x13l; AssertJUnit.assertEquals("multiply", result, 0x86e8d10786e8d0f7l); }
@Test
public void test02680() { x = 0x000000007fffffffl; long result = x * 0x98l; AssertJUnit.assertEquals("multiply", result, 0x0000004bffffff68l); }
@Test
public void test02681() { x = 0x0000000080000000l; long result = x * 0x98l; AssertJUnit.assertEquals("multiply", result, 0x0000004c00000000l); }
@Test
public void test02682() { x = 0x00000000ffffffffl; long result = x * 0x98l; AssertJUnit.assertEquals("multiply", result, 0x00000097ffffff68l); }
@Test
public void test02683() { x = 0x000000017fffffffl; long result = x * 0x98l; AssertJUnit.assertEquals("multiply", result, 0x000000e3ffffff68l); }
@Test
public void test02684() { x = 0x0000000180000000l; long result = x * 0x98l; AssertJUnit.assertEquals("multiply", result, 0x000000e400000000l); }
@Test
public void test02685() { x = 0x00000001ffffffffl; long result = x * 0x98l; AssertJUnit.assertEquals("multiply", result, 0x0000012fffffff68l); }
@Test
public void test02686() { x = 0xffffffff7fffffffl; long result = x * 0x98l; AssertJUnit.assertEquals("multiply", result, 0xffffffb3ffffff68l); }
@Test
public void test02687() { x = 0xffffffff80000000l; long result = x * 0x98l; AssertJUnit.assertEquals("multiply", result, 0xffffffb400000000l); }
@Test
public void test02688() { x = 0x00000001deadf00dl; long result = x * 0x98l; AssertJUnit.assertEquals("multiply", result, 0x0000011c374687b8l); }
@Test
public void test02689() { x = 0xffffffffdeadf00dl; long result = x * 0x98l; AssertJUnit.assertEquals("multiply", result, 0xffffffec374687b8l); }
@Test
public void test02690() { x = 0x7fffffffffffffffl; long result = x * 0x98l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff68l); }
@Test
public void test02691() { x = 0x7fffffff7fffffffl; long result = x * 0x98l; AssertJUnit.assertEquals("multiply", result, 0xffffffb3ffffff68l); }
@Test
public void test02692() { x = 0x7fffffff80000000l; long result = x * 0x98l; AssertJUnit.assertEquals("multiply", result, 0xffffffb400000000l); }
@Test
public void test02693() { x = 0x7fffffffdeadf00dl; long result = x * 0x98l; AssertJUnit.assertEquals("multiply", result, 0xffffffec374687b8l); }
@Test
public void test02694() { x = 0x8000000000000000l; long result = x * 0x98l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02695() { x = 0xffffffffffffffffl; long result = x * 0x98l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff68l); }
@Test
public void test02696() { x = 0xfffffffffffffffel; long result = x * 0x98l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffed0l); }
@Test
public void test02697() { x = 0xefffffffffffffffl; long result = x * 0x98l; AssertJUnit.assertEquals("multiply", result, 0x7fffffffffffff68l); }
@Test
public void test02698() { x = 0xdeadf00ddeadf00dl; long result = x * 0x98l; AssertJUnit.assertEquals("multiply", result, 0x3746883c374687b8l); }
@Test
public void test02699() { x = 0x000000007fffffffl; long result = x * 0x1300l; AssertJUnit.assertEquals("multiply", result, 0x0000097fffffed00l); }
@Test
public void test02700() { x = 0x0000000080000000l; long result = x * 0x1300l; AssertJUnit.assertEquals("multiply", result, 0x0000098000000000l); }
@Test
public void test02701() { x = 0x00000000ffffffffl; long result = x * 0x1300l; AssertJUnit.assertEquals("multiply", result, 0x000012ffffffed00l); }
@Test
public void test02702() { x = 0x000000017fffffffl; long result = x * 0x1300l; AssertJUnit.assertEquals("multiply", result, 0x00001c7fffffed00l); }
@Test
public void test02703() { x = 0x0000000180000000l; long result = x * 0x1300l; AssertJUnit.assertEquals("multiply", result, 0x00001c8000000000l); }
@Test
public void test02704() { x = 0x00000001ffffffffl; long result = x * 0x1300l; AssertJUnit.assertEquals("multiply", result, 0x000025ffffffed00l); }
@Test
public void test02705() { x = 0xffffffff7fffffffl; long result = x * 0x1300l; AssertJUnit.assertEquals("multiply", result, 0xfffff67fffffed00l); }
@Test
public void test02706() { x = 0xffffffff80000000l; long result = x * 0x1300l; AssertJUnit.assertEquals("multiply", result, 0xfffff68000000000l); }
@Test
public void test02707() { x = 0x00000001deadf00dl; long result = x * 0x1300l; AssertJUnit.assertEquals("multiply", result, 0x00002386e8d0f700l); }
@Test
public void test02708() { x = 0xffffffffdeadf00dl; long result = x * 0x1300l; AssertJUnit.assertEquals("multiply", result, 0xfffffd86e8d0f700l); }
@Test
public void test02709() { x = 0x7fffffffffffffffl; long result = x * 0x1300l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffed00l); }
@Test
public void test02710() { x = 0x7fffffff7fffffffl; long result = x * 0x1300l; AssertJUnit.assertEquals("multiply", result, 0xfffff67fffffed00l); }
@Test
public void test02711() { x = 0x7fffffff80000000l; long result = x * 0x1300l; AssertJUnit.assertEquals("multiply", result, 0xfffff68000000000l); }
@Test
public void test02712() { x = 0x7fffffffdeadf00dl; long result = x * 0x1300l; AssertJUnit.assertEquals("multiply", result, 0xfffffd86e8d0f700l); }
@Test
public void test02713() { x = 0x8000000000000000l; long result = x * 0x1300l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02714() { x = 0xffffffffffffffffl; long result = x * 0x1300l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffed00l); }
@Test
public void test02715() { x = 0xfffffffffffffffel; long result = x * 0x1300l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffda00l); }
@Test
public void test02716() { x = 0xefffffffffffffffl; long result = x * 0x1300l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffed00l); }
@Test
public void test02717() { x = 0xdeadf00ddeadf00dl; long result = x * 0x1300l; AssertJUnit.assertEquals("multiply", result, 0xe8d10786e8d0f700l); }
@Test
public void test02718() { x = 0x000000007fffffffl; long result = x * 0x1300000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffed00000000l); }
@Test
public void test02719() { x = 0x0000000080000000l; long result = x * 0x1300000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test02720() { x = 0x00000000ffffffffl; long result = x * 0x1300000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffed00000000l); }
@Test
public void test02721() { x = 0x000000017fffffffl; long result = x * 0x1300000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffed00000000l); }
@Test
public void test02722() { x = 0x0000000180000000l; long result = x * 0x1300000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test02723() { x = 0x00000001ffffffffl; long result = x * 0x1300000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffed00000000l); }
@Test
public void test02724() { x = 0xffffffff7fffffffl; long result = x * 0x1300000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffed00000000l); }
@Test
public void test02725() { x = 0xffffffff80000000l; long result = x * 0x1300000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test02726() { x = 0x00000001deadf00dl; long result = x * 0x1300000000l; AssertJUnit.assertEquals("multiply", result, 0x86e8d0f700000000l); }
@Test
public void test02727() { x = 0xffffffffdeadf00dl; long result = x * 0x1300000000l; AssertJUnit.assertEquals("multiply", result, 0x86e8d0f700000000l); }
@Test
public void test02728() { x = 0x7fffffffffffffffl; long result = x * 0x1300000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffed00000000l); }
@Test
public void test02729() { x = 0x7fffffff7fffffffl; long result = x * 0x1300000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffed00000000l); }
@Test
public void test02730() { x = 0x7fffffff80000000l; long result = x * 0x1300000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test02731() { x = 0x7fffffffdeadf00dl; long result = x * 0x1300000000l; AssertJUnit.assertEquals("multiply", result, 0x86e8d0f700000000l); }
@Test
public void test02732() { x = 0x8000000000000000l; long result = x * 0x1300000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02733() { x = 0xffffffffffffffffl; long result = x * 0x1300000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffed00000000l); }
@Test
public void test02734() { x = 0xfffffffffffffffel; long result = x * 0x1300000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffda00000000l); }
@Test
public void test02735() { x = 0xefffffffffffffffl; long result = x * 0x1300000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffed00000000l); }
@Test
public void test02736() { x = 0xdeadf00ddeadf00dl; long result = x * 0x1300000000l; AssertJUnit.assertEquals("multiply", result, 0x86e8d0f700000000l); }
@Test
public void test02737() { x = 0x000000007fffffffl; long result = x * 0x9800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff6800000000l); }
@Test
public void test02738() { x = 0x0000000080000000l; long result = x * 0x9800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02739() { x = 0x00000000ffffffffl; long result = x * 0x9800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff6800000000l); }
@Test
public void test02740() { x = 0x000000017fffffffl; long result = x * 0x9800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff6800000000l); }
@Test
public void test02741() { x = 0x0000000180000000l; long result = x * 0x9800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02742() { x = 0x00000001ffffffffl; long result = x * 0x9800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff6800000000l); }
@Test
public void test02743() { x = 0xffffffff7fffffffl; long result = x * 0x9800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff6800000000l); }
@Test
public void test02744() { x = 0xffffffff80000000l; long result = x * 0x9800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02745() { x = 0x00000001deadf00dl; long result = x * 0x9800000000l; AssertJUnit.assertEquals("multiply", result, 0x374687b800000000l); }
@Test
public void test02746() { x = 0xffffffffdeadf00dl; long result = x * 0x9800000000l; AssertJUnit.assertEquals("multiply", result, 0x374687b800000000l); }
@Test
public void test02747() { x = 0x7fffffffffffffffl; long result = x * 0x9800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff6800000000l); }
@Test
public void test02748() { x = 0x7fffffff7fffffffl; long result = x * 0x9800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff6800000000l); }
@Test
public void test02749() { x = 0x7fffffff80000000l; long result = x * 0x9800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02750() { x = 0x7fffffffdeadf00dl; long result = x * 0x9800000000l; AssertJUnit.assertEquals("multiply", result, 0x374687b800000000l); }
@Test
public void test02751() { x = 0x8000000000000000l; long result = x * 0x9800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02752() { x = 0xffffffffffffffffl; long result = x * 0x9800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff6800000000l); }
@Test
public void test02753() { x = 0xfffffffffffffffel; long result = x * 0x9800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffed000000000l); }
@Test
public void test02754() { x = 0xefffffffffffffffl; long result = x * 0x9800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff6800000000l); }
@Test
public void test02755() { x = 0xdeadf00ddeadf00dl; long result = x * 0x9800000000l; AssertJUnit.assertEquals("multiply", result, 0x374687b800000000l); }
@Test
public void test02756() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffffedl; AssertJUnit.assertEquals("multiply", result, 0xfffffff680000013l); }
@Test
public void test02757() { x = 0x0000000080000000l; long result = x * 0xffffffffffffffedl; AssertJUnit.assertEquals("multiply", result, 0xfffffff680000000l); }
@Test
public void test02758() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffffedl; AssertJUnit.assertEquals("multiply", result, 0xffffffed00000013l); }
@Test
public void test02759() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffffedl; AssertJUnit.assertEquals("multiply", result, 0xffffffe380000013l); }
@Test
public void test02760() { x = 0x0000000180000000l; long result = x * 0xffffffffffffffedl; AssertJUnit.assertEquals("multiply", result, 0xffffffe380000000l); }
@Test
public void test02761() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffffedl; AssertJUnit.assertEquals("multiply", result, 0xffffffda00000013l); }
@Test
public void test02762() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffffedl; AssertJUnit.assertEquals("multiply", result, 0x0000000980000013l); }
@Test
public void test02763() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffffedl; AssertJUnit.assertEquals("multiply", result, 0x0000000980000000l); }
@Test
public void test02764() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffffedl; AssertJUnit.assertEquals("multiply", result, 0xffffffdc79172f09l); }
@Test
public void test02765() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffffedl; AssertJUnit.assertEquals("multiply", result, 0x0000000279172f09l); }
@Test
public void test02766() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffffedl; AssertJUnit.assertEquals("multiply", result, 0x8000000000000013l); }
@Test
public void test02767() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffffedl; AssertJUnit.assertEquals("multiply", result, 0x8000000980000013l); }
@Test
public void test02768() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffffedl; AssertJUnit.assertEquals("multiply", result, 0x8000000980000000l); }
@Test
public void test02769() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffffedl; AssertJUnit.assertEquals("multiply", result, 0x8000000279172f09l); }
@Test
public void test02770() { x = 0x8000000000000000l; long result = x * 0xffffffffffffffedl; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test02771() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffffedl; AssertJUnit.assertEquals("multiply", result, 0x0000000000000013l); }
@Test
public void test02772() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffffedl; AssertJUnit.assertEquals("multiply", result, 0x0000000000000026l); }
@Test
public void test02773() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffffedl; AssertJUnit.assertEquals("multiply", result, 0x3000000000000013l); }
@Test
public void test02774() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffffedl; AssertJUnit.assertEquals("multiply", result, 0x79172ef879172f09l); }
@Test
public void test02775() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffff68l; AssertJUnit.assertEquals("multiply", result, 0xffffffb400000098l); }
@Test
public void test02776() { x = 0x0000000080000000l; long result = x * 0xffffffffffffff68l; AssertJUnit.assertEquals("multiply", result, 0xffffffb400000000l); }
@Test
public void test02777() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffff68l; AssertJUnit.assertEquals("multiply", result, 0xffffff6800000098l); }
@Test
public void test02778() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffff68l; AssertJUnit.assertEquals("multiply", result, 0xffffff1c00000098l); }
@Test
public void test02779() { x = 0x0000000180000000l; long result = x * 0xffffffffffffff68l; AssertJUnit.assertEquals("multiply", result, 0xffffff1c00000000l); }
@Test
public void test02780() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffff68l; AssertJUnit.assertEquals("multiply", result, 0xfffffed000000098l); }
@Test
public void test02781() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffff68l; AssertJUnit.assertEquals("multiply", result, 0x0000004c00000098l); }
@Test
public void test02782() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffff68l; AssertJUnit.assertEquals("multiply", result, 0x0000004c00000000l); }
@Test
public void test02783() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffff68l; AssertJUnit.assertEquals("multiply", result, 0xfffffee3c8b97848l); }
@Test
public void test02784() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffff68l; AssertJUnit.assertEquals("multiply", result, 0x00000013c8b97848l); }
@Test
public void test02785() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffff68l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000098l); }
@Test
public void test02786() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffff68l; AssertJUnit.assertEquals("multiply", result, 0x0000004c00000098l); }
@Test
public void test02787() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffff68l; AssertJUnit.assertEquals("multiply", result, 0x0000004c00000000l); }
@Test
public void test02788() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffff68l; AssertJUnit.assertEquals("multiply", result, 0x00000013c8b97848l); }
@Test
public void test02789() { x = 0x8000000000000000l; long result = x * 0xffffffffffffff68l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02790() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffff68l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000098l); }
@Test
public void test02791() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffff68l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000130l); }
@Test
public void test02792() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffff68l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000098l); }
@Test
public void test02793() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffff68l; AssertJUnit.assertEquals("multiply", result, 0xc8b977c3c8b97848l); }
@Test
public void test02794() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffed00l; AssertJUnit.assertEquals("multiply", result, 0xfffff68000001300l); }
@Test
public void test02795() { x = 0x0000000080000000l; long result = x * 0xffffffffffffed00l; AssertJUnit.assertEquals("multiply", result, 0xfffff68000000000l); }
@Test
public void test02796() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffed00l; AssertJUnit.assertEquals("multiply", result, 0xffffed0000001300l); }
@Test
public void test02797() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffed00l; AssertJUnit.assertEquals("multiply", result, 0xffffe38000001300l); }
@Test
public void test02798() { x = 0x0000000180000000l; long result = x * 0xffffffffffffed00l; AssertJUnit.assertEquals("multiply", result, 0xffffe38000000000l); }
@Test
public void test02799() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffed00l; AssertJUnit.assertEquals("multiply", result, 0xffffda0000001300l); }
@Test
public void test02800() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffed00l; AssertJUnit.assertEquals("multiply", result, 0x0000098000001300l); }
@Test
public void test02801() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffed00l; AssertJUnit.assertEquals("multiply", result, 0x0000098000000000l); }
@Test
public void test02802() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffed00l; AssertJUnit.assertEquals("multiply", result, 0xffffdc79172f0900l); }
@Test
public void test02803() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffed00l; AssertJUnit.assertEquals("multiply", result, 0x00000279172f0900l); }
@Test
public void test02804() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffed00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001300l); }
@Test
public void test02805() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffed00l; AssertJUnit.assertEquals("multiply", result, 0x0000098000001300l); }
@Test
public void test02806() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffed00l; AssertJUnit.assertEquals("multiply", result, 0x0000098000000000l); }
@Test
public void test02807() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffed00l; AssertJUnit.assertEquals("multiply", result, 0x00000279172f0900l); }
@Test
public void test02808() { x = 0x8000000000000000l; long result = x * 0xffffffffffffed00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02809() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffed00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001300l); }
@Test
public void test02810() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffed00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000002600l); }
@Test
public void test02811() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffed00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001300l); }
@Test
public void test02812() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffed00l; AssertJUnit.assertEquals("multiply", result, 0x172ef879172f0900l); }
@Test
public void test02813() { x = 0x000000007fffffffl; long result = x * 0xffffffed00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000001300000000l); }
@Test
public void test02814() { x = 0x0000000080000000l; long result = x * 0xffffffed00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test02815() { x = 0x00000000ffffffffl; long result = x * 0xffffffed00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001300000000l); }
@Test
public void test02816() { x = 0x000000017fffffffl; long result = x * 0xffffffed00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000001300000000l); }
@Test
public void test02817() { x = 0x0000000180000000l; long result = x * 0xffffffed00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test02818() { x = 0x00000001ffffffffl; long result = x * 0xffffffed00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001300000000l); }
@Test
public void test02819() { x = 0xffffffff7fffffffl; long result = x * 0xffffffed00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000001300000000l); }
@Test
public void test02820() { x = 0xffffffff80000000l; long result = x * 0xffffffed00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test02821() { x = 0x00000001deadf00dl; long result = x * 0xffffffed00000000l; AssertJUnit.assertEquals("multiply", result, 0x79172f0900000000l); }
@Test
public void test02822() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffed00000000l; AssertJUnit.assertEquals("multiply", result, 0x79172f0900000000l); }
@Test
public void test02823() { x = 0x7fffffffffffffffl; long result = x * 0xffffffed00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001300000000l); }
@Test
public void test02824() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffed00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000001300000000l); }
@Test
public void test02825() { x = 0x7fffffff80000000l; long result = x * 0xffffffed00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test02826() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffed00000000l; AssertJUnit.assertEquals("multiply", result, 0x79172f0900000000l); }
@Test
public void test02827() { x = 0x8000000000000000l; long result = x * 0xffffffed00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02828() { x = 0xffffffffffffffffl; long result = x * 0xffffffed00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001300000000l); }
@Test
public void test02829() { x = 0xfffffffffffffffel; long result = x * 0xffffffed00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002600000000l); }
@Test
public void test02830() { x = 0xefffffffffffffffl; long result = x * 0xffffffed00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001300000000l); }
@Test
public void test02831() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffed00000000l; AssertJUnit.assertEquals("multiply", result, 0x79172f0900000000l); }
@Test
public void test02832() { x = 0x000000007fffffffl; long result = x * 0xffffff6800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000009800000000l); }
@Test
public void test02833() { x = 0x0000000080000000l; long result = x * 0xffffff6800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02834() { x = 0x00000000ffffffffl; long result = x * 0xffffff6800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000009800000000l); }
@Test
public void test02835() { x = 0x000000017fffffffl; long result = x * 0xffffff6800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000009800000000l); }
@Test
public void test02836() { x = 0x0000000180000000l; long result = x * 0xffffff6800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02837() { x = 0x00000001ffffffffl; long result = x * 0xffffff6800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000009800000000l); }
@Test
public void test02838() { x = 0xffffffff7fffffffl; long result = x * 0xffffff6800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000009800000000l); }
@Test
public void test02839() { x = 0xffffffff80000000l; long result = x * 0xffffff6800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02840() { x = 0x00000001deadf00dl; long result = x * 0xffffff6800000000l; AssertJUnit.assertEquals("multiply", result, 0xc8b9784800000000l); }
@Test
public void test02841() { x = 0xffffffffdeadf00dl; long result = x * 0xffffff6800000000l; AssertJUnit.assertEquals("multiply", result, 0xc8b9784800000000l); }
@Test
public void test02842() { x = 0x7fffffffffffffffl; long result = x * 0xffffff6800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000009800000000l); }
@Test
public void test02843() { x = 0x7fffffff7fffffffl; long result = x * 0xffffff6800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000009800000000l); }
@Test
public void test02844() { x = 0x7fffffff80000000l; long result = x * 0xffffff6800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02845() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffff6800000000l; AssertJUnit.assertEquals("multiply", result, 0xc8b9784800000000l); }
@Test
public void test02846() { x = 0x8000000000000000l; long result = x * 0xffffff6800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02847() { x = 0xffffffffffffffffl; long result = x * 0xffffff6800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000009800000000l); }
@Test
public void test02848() { x = 0xfffffffffffffffel; long result = x * 0xffffff6800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000013000000000l); }
@Test
public void test02849() { x = 0xefffffffffffffffl; long result = x * 0xffffff6800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000009800000000l); }
@Test
public void test02850() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffff6800000000l; AssertJUnit.assertEquals("multiply", result, 0xc8b9784800000000l); }
@Test
public void test02851() { x = 0x000000007fffffffl; long result = x * 0x14l; AssertJUnit.assertEquals("multiply", result, 0x00000009ffffffecl); }
@Test
public void test02852() { x = 0x0000000080000000l; long result = x * 0x14l; AssertJUnit.assertEquals("multiply", result, 0x0000000a00000000l); }
@Test
public void test02853() { x = 0x00000000ffffffffl; long result = x * 0x14l; AssertJUnit.assertEquals("multiply", result, 0x00000013ffffffecl); }
@Test
public void test02854() { x = 0x000000017fffffffl; long result = x * 0x14l; AssertJUnit.assertEquals("multiply", result, 0x0000001dffffffecl); }
@Test
public void test02855() { x = 0x0000000180000000l; long result = x * 0x14l; AssertJUnit.assertEquals("multiply", result, 0x0000001e00000000l); }
@Test
public void test02856() { x = 0x00000001ffffffffl; long result = x * 0x14l; AssertJUnit.assertEquals("multiply", result, 0x00000027ffffffecl); }
@Test
public void test02857() { x = 0xffffffff7fffffffl; long result = x * 0x14l; AssertJUnit.assertEquals("multiply", result, 0xfffffff5ffffffecl); }
@Test
public void test02858() { x = 0xffffffff80000000l; long result = x * 0x14l; AssertJUnit.assertEquals("multiply", result, 0xfffffff600000000l); }
@Test
public void test02859() { x = 0x00000001deadf00dl; long result = x * 0x14l; AssertJUnit.assertEquals("multiply", result, 0x000000256596c104l); }
@Test
public void test02860() { x = 0xffffffffdeadf00dl; long result = x * 0x14l; AssertJUnit.assertEquals("multiply", result, 0xfffffffd6596c104l); }
@Test
public void test02861() { x = 0x7fffffffffffffffl; long result = x * 0x14l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffecl); }
@Test
public void test02862() { x = 0x7fffffff7fffffffl; long result = x * 0x14l; AssertJUnit.assertEquals("multiply", result, 0xfffffff5ffffffecl); }
@Test
public void test02863() { x = 0x7fffffff80000000l; long result = x * 0x14l; AssertJUnit.assertEquals("multiply", result, 0xfffffff600000000l); }
@Test
public void test02864() { x = 0x7fffffffdeadf00dl; long result = x * 0x14l; AssertJUnit.assertEquals("multiply", result, 0xfffffffd6596c104l); }
@Test
public void test02865() { x = 0x8000000000000000l; long result = x * 0x14l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02866() { x = 0xffffffffffffffffl; long result = x * 0x14l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffecl); }
@Test
public void test02867() { x = 0xfffffffffffffffel; long result = x * 0x14l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffd8l); }
@Test
public void test02868() { x = 0xefffffffffffffffl; long result = x * 0x14l; AssertJUnit.assertEquals("multiply", result, 0xbfffffffffffffecl); }
@Test
public void test02869() { x = 0xdeadf00ddeadf00dl; long result = x * 0x14l; AssertJUnit.assertEquals("multiply", result, 0x6596c1156596c104l); }
@Test
public void test02870() { x = 0x000000007fffffffl; long result = x * 0xa0l; AssertJUnit.assertEquals("multiply", result, 0x0000004fffffff60l); }
@Test
public void test02871() { x = 0x0000000080000000l; long result = x * 0xa0l; AssertJUnit.assertEquals("multiply", result, 0x0000005000000000l); }
@Test
public void test02872() { x = 0x00000000ffffffffl; long result = x * 0xa0l; AssertJUnit.assertEquals("multiply", result, 0x0000009fffffff60l); }
@Test
public void test02873() { x = 0x000000017fffffffl; long result = x * 0xa0l; AssertJUnit.assertEquals("multiply", result, 0x000000efffffff60l); }
@Test
public void test02874() { x = 0x0000000180000000l; long result = x * 0xa0l; AssertJUnit.assertEquals("multiply", result, 0x000000f000000000l); }
@Test
public void test02875() { x = 0x00000001ffffffffl; long result = x * 0xa0l; AssertJUnit.assertEquals("multiply", result, 0x0000013fffffff60l); }
@Test
public void test02876() { x = 0xffffffff7fffffffl; long result = x * 0xa0l; AssertJUnit.assertEquals("multiply", result, 0xffffffafffffff60l); }
@Test
public void test02877() { x = 0xffffffff80000000l; long result = x * 0xa0l; AssertJUnit.assertEquals("multiply", result, 0xffffffb000000000l); }
@Test
public void test02878() { x = 0x00000001deadf00dl; long result = x * 0xa0l; AssertJUnit.assertEquals("multiply", result, 0x0000012b2cb60820l); }
@Test
public void test02879() { x = 0xffffffffdeadf00dl; long result = x * 0xa0l; AssertJUnit.assertEquals("multiply", result, 0xffffffeb2cb60820l); }
@Test
public void test02880() { x = 0x7fffffffffffffffl; long result = x * 0xa0l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff60l); }
@Test
public void test02881() { x = 0x7fffffff7fffffffl; long result = x * 0xa0l; AssertJUnit.assertEquals("multiply", result, 0xffffffafffffff60l); }
@Test
public void test02882() { x = 0x7fffffff80000000l; long result = x * 0xa0l; AssertJUnit.assertEquals("multiply", result, 0xffffffb000000000l); }
@Test
public void test02883() { x = 0x7fffffffdeadf00dl; long result = x * 0xa0l; AssertJUnit.assertEquals("multiply", result, 0xffffffeb2cb60820l); }
@Test
public void test02884() { x = 0x8000000000000000l; long result = x * 0xa0l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02885() { x = 0xffffffffffffffffl; long result = x * 0xa0l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff60l); }
@Test
public void test02886() { x = 0xfffffffffffffffel; long result = x * 0xa0l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffec0l); }
@Test
public void test02887() { x = 0xefffffffffffffffl; long result = x * 0xa0l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff60l); }
@Test
public void test02888() { x = 0xdeadf00ddeadf00dl; long result = x * 0xa0l; AssertJUnit.assertEquals("multiply", result, 0x2cb608ab2cb60820l); }
@Test
public void test02889() { x = 0x000000007fffffffl; long result = x * 0x1400l; AssertJUnit.assertEquals("multiply", result, 0x000009ffffffec00l); }
@Test
public void test02890() { x = 0x0000000080000000l; long result = x * 0x1400l; AssertJUnit.assertEquals("multiply", result, 0x00000a0000000000l); }
@Test
public void test02891() { x = 0x00000000ffffffffl; long result = x * 0x1400l; AssertJUnit.assertEquals("multiply", result, 0x000013ffffffec00l); }
@Test
public void test02892() { x = 0x000000017fffffffl; long result = x * 0x1400l; AssertJUnit.assertEquals("multiply", result, 0x00001dffffffec00l); }
@Test
public void test02893() { x = 0x0000000180000000l; long result = x * 0x1400l; AssertJUnit.assertEquals("multiply", result, 0x00001e0000000000l); }
@Test
public void test02894() { x = 0x00000001ffffffffl; long result = x * 0x1400l; AssertJUnit.assertEquals("multiply", result, 0x000027ffffffec00l); }
@Test
public void test02895() { x = 0xffffffff7fffffffl; long result = x * 0x1400l; AssertJUnit.assertEquals("multiply", result, 0xfffff5ffffffec00l); }
@Test
public void test02896() { x = 0xffffffff80000000l; long result = x * 0x1400l; AssertJUnit.assertEquals("multiply", result, 0xfffff60000000000l); }
@Test
public void test02897() { x = 0x00000001deadf00dl; long result = x * 0x1400l; AssertJUnit.assertEquals("multiply", result, 0x0000256596c10400l); }
@Test
public void test02898() { x = 0xffffffffdeadf00dl; long result = x * 0x1400l; AssertJUnit.assertEquals("multiply", result, 0xfffffd6596c10400l); }
@Test
public void test02899() { x = 0x7fffffffffffffffl; long result = x * 0x1400l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffec00l); }
@Test
public void test02900() { x = 0x7fffffff7fffffffl; long result = x * 0x1400l; AssertJUnit.assertEquals("multiply", result, 0xfffff5ffffffec00l); }
@Test
public void test02901() { x = 0x7fffffff80000000l; long result = x * 0x1400l; AssertJUnit.assertEquals("multiply", result, 0xfffff60000000000l); }
@Test
public void test02902() { x = 0x7fffffffdeadf00dl; long result = x * 0x1400l; AssertJUnit.assertEquals("multiply", result, 0xfffffd6596c10400l); }
@Test
public void test02903() { x = 0x8000000000000000l; long result = x * 0x1400l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02904() { x = 0xffffffffffffffffl; long result = x * 0x1400l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffec00l); }
@Test
public void test02905() { x = 0xfffffffffffffffel; long result = x * 0x1400l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffd800l); }
@Test
public void test02906() { x = 0xefffffffffffffffl; long result = x * 0x1400l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffec00l); }
@Test
public void test02907() { x = 0xdeadf00ddeadf00dl; long result = x * 0x1400l; AssertJUnit.assertEquals("multiply", result, 0x96c1156596c10400l); }
@Test
public void test02908() { x = 0x000000007fffffffl; long result = x * 0x1400000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffec00000000l); }
@Test
public void test02909() { x = 0x0000000080000000l; long result = x * 0x1400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02910() { x = 0x00000000ffffffffl; long result = x * 0x1400000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffec00000000l); }
@Test
public void test02911() { x = 0x000000017fffffffl; long result = x * 0x1400000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffec00000000l); }
@Test
public void test02912() { x = 0x0000000180000000l; long result = x * 0x1400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02913() { x = 0x00000001ffffffffl; long result = x * 0x1400000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffec00000000l); }
@Test
public void test02914() { x = 0xffffffff7fffffffl; long result = x * 0x1400000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffec00000000l); }
@Test
public void test02915() { x = 0xffffffff80000000l; long result = x * 0x1400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02916() { x = 0x00000001deadf00dl; long result = x * 0x1400000000l; AssertJUnit.assertEquals("multiply", result, 0x6596c10400000000l); }
@Test
public void test02917() { x = 0xffffffffdeadf00dl; long result = x * 0x1400000000l; AssertJUnit.assertEquals("multiply", result, 0x6596c10400000000l); }
@Test
public void test02918() { x = 0x7fffffffffffffffl; long result = x * 0x1400000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffec00000000l); }
@Test
public void test02919() { x = 0x7fffffff7fffffffl; long result = x * 0x1400000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffec00000000l); }
@Test
public void test02920() { x = 0x7fffffff80000000l; long result = x * 0x1400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02921() { x = 0x7fffffffdeadf00dl; long result = x * 0x1400000000l; AssertJUnit.assertEquals("multiply", result, 0x6596c10400000000l); }
@Test
public void test02922() { x = 0x8000000000000000l; long result = x * 0x1400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02923() { x = 0xffffffffffffffffl; long result = x * 0x1400000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffec00000000l); }
@Test
public void test02924() { x = 0xfffffffffffffffel; long result = x * 0x1400000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffd800000000l); }
@Test
public void test02925() { x = 0xefffffffffffffffl; long result = x * 0x1400000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffec00000000l); }
@Test
public void test02926() { x = 0xdeadf00ddeadf00dl; long result = x * 0x1400000000l; AssertJUnit.assertEquals("multiply", result, 0x6596c10400000000l); }
@Test
public void test02927() { x = 0x000000007fffffffl; long result = x * 0xa000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff6000000000l); }
@Test
public void test02928() { x = 0x0000000080000000l; long result = x * 0xa000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02929() { x = 0x00000000ffffffffl; long result = x * 0xa000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff6000000000l); }
@Test
public void test02930() { x = 0x000000017fffffffl; long result = x * 0xa000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff6000000000l); }
@Test
public void test02931() { x = 0x0000000180000000l; long result = x * 0xa000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02932() { x = 0x00000001ffffffffl; long result = x * 0xa000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff6000000000l); }
@Test
public void test02933() { x = 0xffffffff7fffffffl; long result = x * 0xa000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff6000000000l); }
@Test
public void test02934() { x = 0xffffffff80000000l; long result = x * 0xa000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02935() { x = 0x00000001deadf00dl; long result = x * 0xa000000000l; AssertJUnit.assertEquals("multiply", result, 0x2cb6082000000000l); }
@Test
public void test02936() { x = 0xffffffffdeadf00dl; long result = x * 0xa000000000l; AssertJUnit.assertEquals("multiply", result, 0x2cb6082000000000l); }
@Test
public void test02937() { x = 0x7fffffffffffffffl; long result = x * 0xa000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff6000000000l); }
@Test
public void test02938() { x = 0x7fffffff7fffffffl; long result = x * 0xa000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff6000000000l); }
@Test
public void test02939() { x = 0x7fffffff80000000l; long result = x * 0xa000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02940() { x = 0x7fffffffdeadf00dl; long result = x * 0xa000000000l; AssertJUnit.assertEquals("multiply", result, 0x2cb6082000000000l); }
@Test
public void test02941() { x = 0x8000000000000000l; long result = x * 0xa000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02942() { x = 0xffffffffffffffffl; long result = x * 0xa000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff6000000000l); }
@Test
public void test02943() { x = 0xfffffffffffffffel; long result = x * 0xa000000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffec000000000l); }
@Test
public void test02944() { x = 0xefffffffffffffffl; long result = x * 0xa000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff6000000000l); }
@Test
public void test02945() { x = 0xdeadf00ddeadf00dl; long result = x * 0xa000000000l; AssertJUnit.assertEquals("multiply", result, 0x2cb6082000000000l); }
@Test
public void test02946() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffffecl; AssertJUnit.assertEquals("multiply", result, 0xfffffff600000014l); }
@Test
public void test02947() { x = 0x0000000080000000l; long result = x * 0xffffffffffffffecl; AssertJUnit.assertEquals("multiply", result, 0xfffffff600000000l); }
@Test
public void test02948() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffffecl; AssertJUnit.assertEquals("multiply", result, 0xffffffec00000014l); }
@Test
public void test02949() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffffecl; AssertJUnit.assertEquals("multiply", result, 0xffffffe200000014l); }
@Test
public void test02950() { x = 0x0000000180000000l; long result = x * 0xffffffffffffffecl; AssertJUnit.assertEquals("multiply", result, 0xffffffe200000000l); }
@Test
public void test02951() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffffecl; AssertJUnit.assertEquals("multiply", result, 0xffffffd800000014l); }
@Test
public void test02952() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffffecl; AssertJUnit.assertEquals("multiply", result, 0x0000000a00000014l); }
@Test
public void test02953() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffffecl; AssertJUnit.assertEquals("multiply", result, 0x0000000a00000000l); }
@Test
public void test02954() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffffecl; AssertJUnit.assertEquals("multiply", result, 0xffffffda9a693efcl); }
@Test
public void test02955() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffffecl; AssertJUnit.assertEquals("multiply", result, 0x000000029a693efcl); }
@Test
public void test02956() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffffecl; AssertJUnit.assertEquals("multiply", result, 0x0000000000000014l); }
@Test
public void test02957() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffffecl; AssertJUnit.assertEquals("multiply", result, 0x0000000a00000014l); }
@Test
public void test02958() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffffecl; AssertJUnit.assertEquals("multiply", result, 0x0000000a00000000l); }
@Test
public void test02959() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffffecl; AssertJUnit.assertEquals("multiply", result, 0x000000029a693efcl); }
@Test
public void test02960() { x = 0x8000000000000000l; long result = x * 0xffffffffffffffecl; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02961() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffffecl; AssertJUnit.assertEquals("multiply", result, 0x0000000000000014l); }
@Test
public void test02962() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffffecl; AssertJUnit.assertEquals("multiply", result, 0x0000000000000028l); }
@Test
public void test02963() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffffecl; AssertJUnit.assertEquals("multiply", result, 0x4000000000000014l); }
@Test
public void test02964() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffffecl; AssertJUnit.assertEquals("multiply", result, 0x9a693eea9a693efcl); }
@Test
public void test02965() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffff60l; AssertJUnit.assertEquals("multiply", result, 0xffffffb0000000a0l); }
@Test
public void test02966() { x = 0x0000000080000000l; long result = x * 0xffffffffffffff60l; AssertJUnit.assertEquals("multiply", result, 0xffffffb000000000l); }
@Test
public void test02967() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffff60l; AssertJUnit.assertEquals("multiply", result, 0xffffff60000000a0l); }
@Test
public void test02968() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffff60l; AssertJUnit.assertEquals("multiply", result, 0xffffff10000000a0l); }
@Test
public void test02969() { x = 0x0000000180000000l; long result = x * 0xffffffffffffff60l; AssertJUnit.assertEquals("multiply", result, 0xffffff1000000000l); }
@Test
public void test02970() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffff60l; AssertJUnit.assertEquals("multiply", result, 0xfffffec0000000a0l); }
@Test
public void test02971() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffff60l; AssertJUnit.assertEquals("multiply", result, 0x00000050000000a0l); }
@Test
public void test02972() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffff60l; AssertJUnit.assertEquals("multiply", result, 0x0000005000000000l); }
@Test
public void test02973() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffff60l; AssertJUnit.assertEquals("multiply", result, 0xfffffed4d349f7e0l); }
@Test
public void test02974() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffff60l; AssertJUnit.assertEquals("multiply", result, 0x00000014d349f7e0l); }
@Test
public void test02975() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffff60l; AssertJUnit.assertEquals("multiply", result, 0x00000000000000a0l); }
@Test
public void test02976() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffff60l; AssertJUnit.assertEquals("multiply", result, 0x00000050000000a0l); }
@Test
public void test02977() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffff60l; AssertJUnit.assertEquals("multiply", result, 0x0000005000000000l); }
@Test
public void test02978() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffff60l; AssertJUnit.assertEquals("multiply", result, 0x00000014d349f7e0l); }
@Test
public void test02979() { x = 0x8000000000000000l; long result = x * 0xffffffffffffff60l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02980() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffff60l; AssertJUnit.assertEquals("multiply", result, 0x00000000000000a0l); }
@Test
public void test02981() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffff60l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000140l); }
@Test
public void test02982() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffff60l; AssertJUnit.assertEquals("multiply", result, 0x00000000000000a0l); }
@Test
public void test02983() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffff60l; AssertJUnit.assertEquals("multiply", result, 0xd349f754d349f7e0l); }
@Test
public void test02984() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffec00l; AssertJUnit.assertEquals("multiply", result, 0xfffff60000001400l); }
@Test
public void test02985() { x = 0x0000000080000000l; long result = x * 0xffffffffffffec00l; AssertJUnit.assertEquals("multiply", result, 0xfffff60000000000l); }
@Test
public void test02986() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffec00l; AssertJUnit.assertEquals("multiply", result, 0xffffec0000001400l); }
@Test
public void test02987() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffec00l; AssertJUnit.assertEquals("multiply", result, 0xffffe20000001400l); }
@Test
public void test02988() { x = 0x0000000180000000l; long result = x * 0xffffffffffffec00l; AssertJUnit.assertEquals("multiply", result, 0xffffe20000000000l); }
@Test
public void test02989() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffec00l; AssertJUnit.assertEquals("multiply", result, 0xffffd80000001400l); }
@Test
public void test02990() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffec00l; AssertJUnit.assertEquals("multiply", result, 0x00000a0000001400l); }
@Test
public void test02991() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffec00l; AssertJUnit.assertEquals("multiply", result, 0x00000a0000000000l); }
@Test
public void test02992() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffec00l; AssertJUnit.assertEquals("multiply", result, 0xffffda9a693efc00l); }
@Test
public void test02993() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffec00l; AssertJUnit.assertEquals("multiply", result, 0x0000029a693efc00l); }
@Test
public void test02994() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffec00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001400l); }
@Test
public void test02995() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffec00l; AssertJUnit.assertEquals("multiply", result, 0x00000a0000001400l); }
@Test
public void test02996() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffec00l; AssertJUnit.assertEquals("multiply", result, 0x00000a0000000000l); }
@Test
public void test02997() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffec00l; AssertJUnit.assertEquals("multiply", result, 0x0000029a693efc00l); }
@Test
public void test02998() { x = 0x8000000000000000l; long result = x * 0xffffffffffffec00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test02999() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffec00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001400l); }
@Test
public void test03000() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffec00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000002800l); }
@Test
public void test03001() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffec00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001400l); }
@Test
public void test03002() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffec00l; AssertJUnit.assertEquals("multiply", result, 0x693eea9a693efc00l); }
@Test
public void test03003() { x = 0x000000007fffffffl; long result = x * 0xffffffec00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001400000000l); }
@Test
public void test03004() { x = 0x0000000080000000l; long result = x * 0xffffffec00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03005() { x = 0x00000000ffffffffl; long result = x * 0xffffffec00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001400000000l); }
@Test
public void test03006() { x = 0x000000017fffffffl; long result = x * 0xffffffec00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001400000000l); }
@Test
public void test03007() { x = 0x0000000180000000l; long result = x * 0xffffffec00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03008() { x = 0x00000001ffffffffl; long result = x * 0xffffffec00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001400000000l); }
@Test
public void test03009() { x = 0xffffffff7fffffffl; long result = x * 0xffffffec00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001400000000l); }
@Test
public void test03010() { x = 0xffffffff80000000l; long result = x * 0xffffffec00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03011() { x = 0x00000001deadf00dl; long result = x * 0xffffffec00000000l; AssertJUnit.assertEquals("multiply", result, 0x9a693efc00000000l); }
@Test
public void test03012() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffec00000000l; AssertJUnit.assertEquals("multiply", result, 0x9a693efc00000000l); }
@Test
public void test03013() { x = 0x7fffffffffffffffl; long result = x * 0xffffffec00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001400000000l); }
@Test
public void test03014() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffec00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001400000000l); }
@Test
public void test03015() { x = 0x7fffffff80000000l; long result = x * 0xffffffec00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03016() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffec00000000l; AssertJUnit.assertEquals("multiply", result, 0x9a693efc00000000l); }
@Test
public void test03017() { x = 0x8000000000000000l; long result = x * 0xffffffec00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03018() { x = 0xffffffffffffffffl; long result = x * 0xffffffec00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001400000000l); }
@Test
public void test03019() { x = 0xfffffffffffffffel; long result = x * 0xffffffec00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002800000000l); }
@Test
public void test03020() { x = 0xefffffffffffffffl; long result = x * 0xffffffec00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001400000000l); }
@Test
public void test03021() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffec00000000l; AssertJUnit.assertEquals("multiply", result, 0x9a693efc00000000l); }
@Test
public void test03022() { x = 0x000000007fffffffl; long result = x * 0xffffff6000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000a000000000l); }
@Test
public void test03023() { x = 0x0000000080000000l; long result = x * 0xffffff6000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03024() { x = 0x00000000ffffffffl; long result = x * 0xffffff6000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000a000000000l); }
@Test
public void test03025() { x = 0x000000017fffffffl; long result = x * 0xffffff6000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000a000000000l); }
@Test
public void test03026() { x = 0x0000000180000000l; long result = x * 0xffffff6000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03027() { x = 0x00000001ffffffffl; long result = x * 0xffffff6000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000a000000000l); }
@Test
public void test03028() { x = 0xffffffff7fffffffl; long result = x * 0xffffff6000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000a000000000l); }
@Test
public void test03029() { x = 0xffffffff80000000l; long result = x * 0xffffff6000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03030() { x = 0x00000001deadf00dl; long result = x * 0xffffff6000000000l; AssertJUnit.assertEquals("multiply", result, 0xd349f7e000000000l); }
@Test
public void test03031() { x = 0xffffffffdeadf00dl; long result = x * 0xffffff6000000000l; AssertJUnit.assertEquals("multiply", result, 0xd349f7e000000000l); }
@Test
public void test03032() { x = 0x7fffffffffffffffl; long result = x * 0xffffff6000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000a000000000l); }
@Test
public void test03033() { x = 0x7fffffff7fffffffl; long result = x * 0xffffff6000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000a000000000l); }
@Test
public void test03034() { x = 0x7fffffff80000000l; long result = x * 0xffffff6000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03035() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffff6000000000l; AssertJUnit.assertEquals("multiply", result, 0xd349f7e000000000l); }
@Test
public void test03036() { x = 0x8000000000000000l; long result = x * 0xffffff6000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03037() { x = 0xffffffffffffffffl; long result = x * 0xffffff6000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000a000000000l); }
@Test
public void test03038() { x = 0xfffffffffffffffel; long result = x * 0xffffff6000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000014000000000l); }
@Test
public void test03039() { x = 0xefffffffffffffffl; long result = x * 0xffffff6000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000a000000000l); }
@Test
public void test03040() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffff6000000000l; AssertJUnit.assertEquals("multiply", result, 0xd349f7e000000000l); }
@Test
public void test03041() { x = 0x000000007fffffffl; long result = x * 0x15l; AssertJUnit.assertEquals("multiply", result, 0x0000000a7fffffebl); }
@Test
public void test03042() { x = 0x0000000080000000l; long result = x * 0x15l; AssertJUnit.assertEquals("multiply", result, 0x0000000a80000000l); }
@Test
public void test03043() { x = 0x00000000ffffffffl; long result = x * 0x15l; AssertJUnit.assertEquals("multiply", result, 0x00000014ffffffebl); }
@Test
public void test03044() { x = 0x000000017fffffffl; long result = x * 0x15l; AssertJUnit.assertEquals("multiply", result, 0x0000001f7fffffebl); }
@Test
public void test03045() { x = 0x0000000180000000l; long result = x * 0x15l; AssertJUnit.assertEquals("multiply", result, 0x0000001f80000000l); }
@Test
public void test03046() { x = 0x00000001ffffffffl; long result = x * 0x15l; AssertJUnit.assertEquals("multiply", result, 0x00000029ffffffebl); }
@Test
public void test03047() { x = 0xffffffff7fffffffl; long result = x * 0x15l; AssertJUnit.assertEquals("multiply", result, 0xfffffff57fffffebl); }
@Test
public void test03048() { x = 0xffffffff80000000l; long result = x * 0x15l; AssertJUnit.assertEquals("multiply", result, 0xfffffff580000000l); }
@Test
public void test03049() { x = 0x00000001deadf00dl; long result = x * 0x15l; AssertJUnit.assertEquals("multiply", result, 0x000000274444b111l); }
@Test
public void test03050() { x = 0xffffffffdeadf00dl; long result = x * 0x15l; AssertJUnit.assertEquals("multiply", result, 0xfffffffd4444b111l); }
@Test
public void test03051() { x = 0x7fffffffffffffffl; long result = x * 0x15l; AssertJUnit.assertEquals("multiply", result, 0x7fffffffffffffebl); }
@Test
public void test03052() { x = 0x7fffffff7fffffffl; long result = x * 0x15l; AssertJUnit.assertEquals("multiply", result, 0x7ffffff57fffffebl); }
@Test
public void test03053() { x = 0x7fffffff80000000l; long result = x * 0x15l; AssertJUnit.assertEquals("multiply", result, 0x7ffffff580000000l); }
@Test
public void test03054() { x = 0x7fffffffdeadf00dl; long result = x * 0x15l; AssertJUnit.assertEquals("multiply", result, 0x7ffffffd4444b111l); }
@Test
public void test03055() { x = 0x8000000000000000l; long result = x * 0x15l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test03056() { x = 0xffffffffffffffffl; long result = x * 0x15l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffebl); }
@Test
public void test03057() { x = 0xfffffffffffffffel; long result = x * 0x15l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffd6l); }
@Test
public void test03058() { x = 0xefffffffffffffffl; long result = x * 0x15l; AssertJUnit.assertEquals("multiply", result, 0xafffffffffffffebl); }
@Test
public void test03059() { x = 0xdeadf00ddeadf00dl; long result = x * 0x15l; AssertJUnit.assertEquals("multiply", result, 0x4444b1234444b111l); }
@Test
public void test03060() { x = 0x000000007fffffffl; long result = x * 0xa8l; AssertJUnit.assertEquals("multiply", result, 0x00000053ffffff58l); }
@Test
public void test03061() { x = 0x0000000080000000l; long result = x * 0xa8l; AssertJUnit.assertEquals("multiply", result, 0x0000005400000000l); }
@Test
public void test03062() { x = 0x00000000ffffffffl; long result = x * 0xa8l; AssertJUnit.assertEquals("multiply", result, 0x000000a7ffffff58l); }
@Test
public void test03063() { x = 0x000000017fffffffl; long result = x * 0xa8l; AssertJUnit.assertEquals("multiply", result, 0x000000fbffffff58l); }
@Test
public void test03064() { x = 0x0000000180000000l; long result = x * 0xa8l; AssertJUnit.assertEquals("multiply", result, 0x000000fc00000000l); }
@Test
public void test03065() { x = 0x00000001ffffffffl; long result = x * 0xa8l; AssertJUnit.assertEquals("multiply", result, 0x0000014fffffff58l); }
@Test
public void test03066() { x = 0xffffffff7fffffffl; long result = x * 0xa8l; AssertJUnit.assertEquals("multiply", result, 0xffffffabffffff58l); }
@Test
public void test03067() { x = 0xffffffff80000000l; long result = x * 0xa8l; AssertJUnit.assertEquals("multiply", result, 0xffffffac00000000l); }
@Test
public void test03068() { x = 0x00000001deadf00dl; long result = x * 0xa8l; AssertJUnit.assertEquals("multiply", result, 0x0000013a22258888l); }
@Test
public void test03069() { x = 0xffffffffdeadf00dl; long result = x * 0xa8l; AssertJUnit.assertEquals("multiply", result, 0xffffffea22258888l); }
@Test
public void test03070() { x = 0x7fffffffffffffffl; long result = x * 0xa8l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff58l); }
@Test
public void test03071() { x = 0x7fffffff7fffffffl; long result = x * 0xa8l; AssertJUnit.assertEquals("multiply", result, 0xffffffabffffff58l); }
@Test
public void test03072() { x = 0x7fffffff80000000l; long result = x * 0xa8l; AssertJUnit.assertEquals("multiply", result, 0xffffffac00000000l); }
@Test
public void test03073() { x = 0x7fffffffdeadf00dl; long result = x * 0xa8l; AssertJUnit.assertEquals("multiply", result, 0xffffffea22258888l); }
@Test
public void test03074() { x = 0x8000000000000000l; long result = x * 0xa8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03075() { x = 0xffffffffffffffffl; long result = x * 0xa8l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff58l); }
@Test
public void test03076() { x = 0xfffffffffffffffel; long result = x * 0xa8l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffeb0l); }
@Test
public void test03077() { x = 0xefffffffffffffffl; long result = x * 0xa8l; AssertJUnit.assertEquals("multiply", result, 0x7fffffffffffff58l); }
@Test
public void test03078() { x = 0xdeadf00ddeadf00dl; long result = x * 0xa8l; AssertJUnit.assertEquals("multiply", result, 0x2225891a22258888l); }
@Test
public void test03079() { x = 0x000000007fffffffl; long result = x * 0x1500l; AssertJUnit.assertEquals("multiply", result, 0x00000a7fffffeb00l); }
@Test
public void test03080() { x = 0x0000000080000000l; long result = x * 0x1500l; AssertJUnit.assertEquals("multiply", result, 0x00000a8000000000l); }
@Test
public void test03081() { x = 0x00000000ffffffffl; long result = x * 0x1500l; AssertJUnit.assertEquals("multiply", result, 0x000014ffffffeb00l); }
@Test
public void test03082() { x = 0x000000017fffffffl; long result = x * 0x1500l; AssertJUnit.assertEquals("multiply", result, 0x00001f7fffffeb00l); }
@Test
public void test03083() { x = 0x0000000180000000l; long result = x * 0x1500l; AssertJUnit.assertEquals("multiply", result, 0x00001f8000000000l); }
@Test
public void test03084() { x = 0x00000001ffffffffl; long result = x * 0x1500l; AssertJUnit.assertEquals("multiply", result, 0x000029ffffffeb00l); }
@Test
public void test03085() { x = 0xffffffff7fffffffl; long result = x * 0x1500l; AssertJUnit.assertEquals("multiply", result, 0xfffff57fffffeb00l); }
@Test
public void test03086() { x = 0xffffffff80000000l; long result = x * 0x1500l; AssertJUnit.assertEquals("multiply", result, 0xfffff58000000000l); }
@Test
public void test03087() { x = 0x00000001deadf00dl; long result = x * 0x1500l; AssertJUnit.assertEquals("multiply", result, 0x0000274444b11100l); }
@Test
public void test03088() { x = 0xffffffffdeadf00dl; long result = x * 0x1500l; AssertJUnit.assertEquals("multiply", result, 0xfffffd4444b11100l); }
@Test
public void test03089() { x = 0x7fffffffffffffffl; long result = x * 0x1500l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffeb00l); }
@Test
public void test03090() { x = 0x7fffffff7fffffffl; long result = x * 0x1500l; AssertJUnit.assertEquals("multiply", result, 0xfffff57fffffeb00l); }
@Test
public void test03091() { x = 0x7fffffff80000000l; long result = x * 0x1500l; AssertJUnit.assertEquals("multiply", result, 0xfffff58000000000l); }
@Test
public void test03092() { x = 0x7fffffffdeadf00dl; long result = x * 0x1500l; AssertJUnit.assertEquals("multiply", result, 0xfffffd4444b11100l); }
@Test
public void test03093() { x = 0x8000000000000000l; long result = x * 0x1500l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03094() { x = 0xffffffffffffffffl; long result = x * 0x1500l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffeb00l); }
@Test
public void test03095() { x = 0xfffffffffffffffel; long result = x * 0x1500l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffd600l); }
@Test
public void test03096() { x = 0xefffffffffffffffl; long result = x * 0x1500l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffeb00l); }
@Test
public void test03097() { x = 0xdeadf00ddeadf00dl; long result = x * 0x1500l; AssertJUnit.assertEquals("multiply", result, 0x44b1234444b11100l); }
@Test
public void test03098() { x = 0x000000007fffffffl; long result = x * 0x1500000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffeb00000000l); }
@Test
public void test03099() { x = 0x0000000080000000l; long result = x * 0x1500000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test03100() { x = 0x00000000ffffffffl; long result = x * 0x1500000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffeb00000000l); }
@Test
public void test03101() { x = 0x000000017fffffffl; long result = x * 0x1500000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffeb00000000l); }
@Test
public void test03102() { x = 0x0000000180000000l; long result = x * 0x1500000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test03103() { x = 0x00000001ffffffffl; long result = x * 0x1500000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffeb00000000l); }
@Test
public void test03104() { x = 0xffffffff7fffffffl; long result = x * 0x1500000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffeb00000000l); }
@Test
public void test03105() { x = 0xffffffff80000000l; long result = x * 0x1500000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test03106() { x = 0x00000001deadf00dl; long result = x * 0x1500000000l; AssertJUnit.assertEquals("multiply", result, 0x4444b11100000000l); }
@Test
public void test03107() { x = 0xffffffffdeadf00dl; long result = x * 0x1500000000l; AssertJUnit.assertEquals("multiply", result, 0x4444b11100000000l); }
@Test
public void test03108() { x = 0x7fffffffffffffffl; long result = x * 0x1500000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffeb00000000l); }
@Test
public void test03109() { x = 0x7fffffff7fffffffl; long result = x * 0x1500000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffeb00000000l); }
@Test
public void test03110() { x = 0x7fffffff80000000l; long result = x * 0x1500000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test03111() { x = 0x7fffffffdeadf00dl; long result = x * 0x1500000000l; AssertJUnit.assertEquals("multiply", result, 0x4444b11100000000l); }
@Test
public void test03112() { x = 0x8000000000000000l; long result = x * 0x1500000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03113() { x = 0xffffffffffffffffl; long result = x * 0x1500000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffeb00000000l); }
@Test
public void test03114() { x = 0xfffffffffffffffel; long result = x * 0x1500000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffd600000000l); }
@Test
public void test03115() { x = 0xefffffffffffffffl; long result = x * 0x1500000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffeb00000000l); }
@Test
public void test03116() { x = 0xdeadf00ddeadf00dl; long result = x * 0x1500000000l; AssertJUnit.assertEquals("multiply", result, 0x4444b11100000000l); }
@Test
public void test03117() { x = 0x000000007fffffffl; long result = x * 0xa800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff5800000000l); }
@Test
public void test03118() { x = 0x0000000080000000l; long result = x * 0xa800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03119() { x = 0x00000000ffffffffl; long result = x * 0xa800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff5800000000l); }
@Test
public void test03120() { x = 0x000000017fffffffl; long result = x * 0xa800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff5800000000l); }
@Test
public void test03121() { x = 0x0000000180000000l; long result = x * 0xa800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03122() { x = 0x00000001ffffffffl; long result = x * 0xa800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff5800000000l); }
@Test
public void test03123() { x = 0xffffffff7fffffffl; long result = x * 0xa800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff5800000000l); }
@Test
public void test03124() { x = 0xffffffff80000000l; long result = x * 0xa800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03125() { x = 0x00000001deadf00dl; long result = x * 0xa800000000l; AssertJUnit.assertEquals("multiply", result, 0x2225888800000000l); }
@Test
public void test03126() { x = 0xffffffffdeadf00dl; long result = x * 0xa800000000l; AssertJUnit.assertEquals("multiply", result, 0x2225888800000000l); }
@Test
public void test03127() { x = 0x7fffffffffffffffl; long result = x * 0xa800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff5800000000l); }
@Test
public void test03128() { x = 0x7fffffff7fffffffl; long result = x * 0xa800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff5800000000l); }
@Test
public void test03129() { x = 0x7fffffff80000000l; long result = x * 0xa800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03130() { x = 0x7fffffffdeadf00dl; long result = x * 0xa800000000l; AssertJUnit.assertEquals("multiply", result, 0x2225888800000000l); }
@Test
public void test03131() { x = 0x8000000000000000l; long result = x * 0xa800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03132() { x = 0xffffffffffffffffl; long result = x * 0xa800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff5800000000l); }
@Test
public void test03133() { x = 0xfffffffffffffffel; long result = x * 0xa800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffeb000000000l); }
@Test
public void test03134() { x = 0xefffffffffffffffl; long result = x * 0xa800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff5800000000l); }
@Test
public void test03135() { x = 0xdeadf00ddeadf00dl; long result = x * 0xa800000000l; AssertJUnit.assertEquals("multiply", result, 0x2225888800000000l); }
@Test
public void test03136() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffffebl; AssertJUnit.assertEquals("multiply", result, 0xfffffff580000015l); }
@Test
public void test03137() { x = 0x0000000080000000l; long result = x * 0xffffffffffffffebl; AssertJUnit.assertEquals("multiply", result, 0xfffffff580000000l); }
@Test
public void test03138() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffffebl; AssertJUnit.assertEquals("multiply", result, 0xffffffeb00000015l); }
@Test
public void test03139() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffffebl; AssertJUnit.assertEquals("multiply", result, 0xffffffe080000015l); }
@Test
public void test03140() { x = 0x0000000180000000l; long result = x * 0xffffffffffffffebl; AssertJUnit.assertEquals("multiply", result, 0xffffffe080000000l); }
@Test
public void test03141() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffffebl; AssertJUnit.assertEquals("multiply", result, 0xffffffd600000015l); }
@Test
public void test03142() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffffebl; AssertJUnit.assertEquals("multiply", result, 0x0000000a80000015l); }
@Test
public void test03143() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffffebl; AssertJUnit.assertEquals("multiply", result, 0x0000000a80000000l); }
@Test
public void test03144() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffffebl; AssertJUnit.assertEquals("multiply", result, 0xffffffd8bbbb4eefl); }
@Test
public void test03145() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffffebl; AssertJUnit.assertEquals("multiply", result, 0x00000002bbbb4eefl); }
@Test
public void test03146() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffffebl; AssertJUnit.assertEquals("multiply", result, 0x8000000000000015l); }
@Test
public void test03147() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffffebl; AssertJUnit.assertEquals("multiply", result, 0x8000000a80000015l); }
@Test
public void test03148() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffffebl; AssertJUnit.assertEquals("multiply", result, 0x8000000a80000000l); }
@Test
public void test03149() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffffebl; AssertJUnit.assertEquals("multiply", result, 0x80000002bbbb4eefl); }
@Test
public void test03150() { x = 0x8000000000000000l; long result = x * 0xffffffffffffffebl; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test03151() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffffebl; AssertJUnit.assertEquals("multiply", result, 0x0000000000000015l); }
@Test
public void test03152() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffffebl; AssertJUnit.assertEquals("multiply", result, 0x000000000000002al); }
@Test
public void test03153() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffffebl; AssertJUnit.assertEquals("multiply", result, 0x5000000000000015l); }
@Test
public void test03154() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffffebl; AssertJUnit.assertEquals("multiply", result, 0xbbbb4edcbbbb4eefl); }
@Test
public void test03155() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffff58l; AssertJUnit.assertEquals("multiply", result, 0xffffffac000000a8l); }
@Test
public void test03156() { x = 0x0000000080000000l; long result = x * 0xffffffffffffff58l; AssertJUnit.assertEquals("multiply", result, 0xffffffac00000000l); }
@Test
public void test03157() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffff58l; AssertJUnit.assertEquals("multiply", result, 0xffffff58000000a8l); }
@Test
public void test03158() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffff58l; AssertJUnit.assertEquals("multiply", result, 0xffffff04000000a8l); }
@Test
public void test03159() { x = 0x0000000180000000l; long result = x * 0xffffffffffffff58l; AssertJUnit.assertEquals("multiply", result, 0xffffff0400000000l); }
@Test
public void test03160() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffff58l; AssertJUnit.assertEquals("multiply", result, 0xfffffeb0000000a8l); }
@Test
public void test03161() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffff58l; AssertJUnit.assertEquals("multiply", result, 0x00000054000000a8l); }
@Test
public void test03162() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffff58l; AssertJUnit.assertEquals("multiply", result, 0x0000005400000000l); }
@Test
public void test03163() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffff58l; AssertJUnit.assertEquals("multiply", result, 0xfffffec5ddda7778l); }
@Test
public void test03164() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffff58l; AssertJUnit.assertEquals("multiply", result, 0x00000015ddda7778l); }
@Test
public void test03165() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffff58l; AssertJUnit.assertEquals("multiply", result, 0x00000000000000a8l); }
@Test
public void test03166() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffff58l; AssertJUnit.assertEquals("multiply", result, 0x00000054000000a8l); }
@Test
public void test03167() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffff58l; AssertJUnit.assertEquals("multiply", result, 0x0000005400000000l); }
@Test
public void test03168() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffff58l; AssertJUnit.assertEquals("multiply", result, 0x00000015ddda7778l); }
@Test
public void test03169() { x = 0x8000000000000000l; long result = x * 0xffffffffffffff58l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03170() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffff58l; AssertJUnit.assertEquals("multiply", result, 0x00000000000000a8l); }
@Test
public void test03171() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffff58l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000150l); }
@Test
public void test03172() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffff58l; AssertJUnit.assertEquals("multiply", result, 0x80000000000000a8l); }
@Test
public void test03173() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffff58l; AssertJUnit.assertEquals("multiply", result, 0xddda76e5ddda7778l); }
@Test
public void test03174() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffeb00l; AssertJUnit.assertEquals("multiply", result, 0xfffff58000001500l); }
@Test
public void test03175() { x = 0x0000000080000000l; long result = x * 0xffffffffffffeb00l; AssertJUnit.assertEquals("multiply", result, 0xfffff58000000000l); }
@Test
public void test03176() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffeb00l; AssertJUnit.assertEquals("multiply", result, 0xffffeb0000001500l); }
@Test
public void test03177() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffeb00l; AssertJUnit.assertEquals("multiply", result, 0xffffe08000001500l); }
@Test
public void test03178() { x = 0x0000000180000000l; long result = x * 0xffffffffffffeb00l; AssertJUnit.assertEquals("multiply", result, 0xffffe08000000000l); }
@Test
public void test03179() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffeb00l; AssertJUnit.assertEquals("multiply", result, 0xffffd60000001500l); }
@Test
public void test03180() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffeb00l; AssertJUnit.assertEquals("multiply", result, 0x00000a8000001500l); }
@Test
public void test03181() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffeb00l; AssertJUnit.assertEquals("multiply", result, 0x00000a8000000000l); }
@Test
public void test03182() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffeb00l; AssertJUnit.assertEquals("multiply", result, 0xffffd8bbbb4eef00l); }
@Test
public void test03183() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffeb00l; AssertJUnit.assertEquals("multiply", result, 0x000002bbbb4eef00l); }
@Test
public void test03184() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffeb00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001500l); }
@Test
public void test03185() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffeb00l; AssertJUnit.assertEquals("multiply", result, 0x00000a8000001500l); }
@Test
public void test03186() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffeb00l; AssertJUnit.assertEquals("multiply", result, 0x00000a8000000000l); }
@Test
public void test03187() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffeb00l; AssertJUnit.assertEquals("multiply", result, 0x000002bbbb4eef00l); }
@Test
public void test03188() { x = 0x8000000000000000l; long result = x * 0xffffffffffffeb00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03189() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffeb00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001500l); }
@Test
public void test03190() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffeb00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000002a00l); }
@Test
public void test03191() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffeb00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001500l); }
@Test
public void test03192() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffeb00l; AssertJUnit.assertEquals("multiply", result, 0xbb4edcbbbb4eef00l); }
@Test
public void test03193() { x = 0x000000007fffffffl; long result = x * 0xffffffeb00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000001500000000l); }
@Test
public void test03194() { x = 0x0000000080000000l; long result = x * 0xffffffeb00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test03195() { x = 0x00000000ffffffffl; long result = x * 0xffffffeb00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001500000000l); }
@Test
public void test03196() { x = 0x000000017fffffffl; long result = x * 0xffffffeb00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000001500000000l); }
@Test
public void test03197() { x = 0x0000000180000000l; long result = x * 0xffffffeb00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test03198() { x = 0x00000001ffffffffl; long result = x * 0xffffffeb00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001500000000l); }
@Test
public void test03199() { x = 0xffffffff7fffffffl; long result = x * 0xffffffeb00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000001500000000l); }
@Test
public void test03200() { x = 0xffffffff80000000l; long result = x * 0xffffffeb00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test03201() { x = 0x00000001deadf00dl; long result = x * 0xffffffeb00000000l; AssertJUnit.assertEquals("multiply", result, 0xbbbb4eef00000000l); }
@Test
public void test03202() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffeb00000000l; AssertJUnit.assertEquals("multiply", result, 0xbbbb4eef00000000l); }
@Test
public void test03203() { x = 0x7fffffffffffffffl; long result = x * 0xffffffeb00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001500000000l); }
@Test
public void test03204() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffeb00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000001500000000l); }
@Test
public void test03205() { x = 0x7fffffff80000000l; long result = x * 0xffffffeb00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test03206() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffeb00000000l; AssertJUnit.assertEquals("multiply", result, 0xbbbb4eef00000000l); }
@Test
public void test03207() { x = 0x8000000000000000l; long result = x * 0xffffffeb00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03208() { x = 0xffffffffffffffffl; long result = x * 0xffffffeb00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001500000000l); }
@Test
public void test03209() { x = 0xfffffffffffffffel; long result = x * 0xffffffeb00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002a00000000l); }
@Test
public void test03210() { x = 0xefffffffffffffffl; long result = x * 0xffffffeb00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001500000000l); }
@Test
public void test03211() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffeb00000000l; AssertJUnit.assertEquals("multiply", result, 0xbbbb4eef00000000l); }
@Test
public void test03212() { x = 0x000000007fffffffl; long result = x * 0xffffff5800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000a800000000l); }
@Test
public void test03213() { x = 0x0000000080000000l; long result = x * 0xffffff5800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03214() { x = 0x00000000ffffffffl; long result = x * 0xffffff5800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000a800000000l); }
@Test
public void test03215() { x = 0x000000017fffffffl; long result = x * 0xffffff5800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000a800000000l); }
@Test
public void test03216() { x = 0x0000000180000000l; long result = x * 0xffffff5800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03217() { x = 0x00000001ffffffffl; long result = x * 0xffffff5800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000a800000000l); }
@Test
public void test03218() { x = 0xffffffff7fffffffl; long result = x * 0xffffff5800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000a800000000l); }
@Test
public void test03219() { x = 0xffffffff80000000l; long result = x * 0xffffff5800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03220() { x = 0x00000001deadf00dl; long result = x * 0xffffff5800000000l; AssertJUnit.assertEquals("multiply", result, 0xddda777800000000l); }
@Test
public void test03221() { x = 0xffffffffdeadf00dl; long result = x * 0xffffff5800000000l; AssertJUnit.assertEquals("multiply", result, 0xddda777800000000l); }
@Test
public void test03222() { x = 0x7fffffffffffffffl; long result = x * 0xffffff5800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000a800000000l); }
@Test
public void test03223() { x = 0x7fffffff7fffffffl; long result = x * 0xffffff5800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000a800000000l); }
@Test
public void test03224() { x = 0x7fffffff80000000l; long result = x * 0xffffff5800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03225() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffff5800000000l; AssertJUnit.assertEquals("multiply", result, 0xddda777800000000l); }
@Test
public void test03226() { x = 0x8000000000000000l; long result = x * 0xffffff5800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03227() { x = 0xffffffffffffffffl; long result = x * 0xffffff5800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000a800000000l); }
@Test
public void test03228() { x = 0xfffffffffffffffel; long result = x * 0xffffff5800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000015000000000l); }
@Test
public void test03229() { x = 0xefffffffffffffffl; long result = x * 0xffffff5800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000a800000000l); }
@Test
public void test03230() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffff5800000000l; AssertJUnit.assertEquals("multiply", result, 0xddda777800000000l); }
@Test
public void test03231() { x = 0x000000007fffffffl; long result = x * 0x16l; AssertJUnit.assertEquals("multiply", result, 0x0000000affffffeal); }
@Test
public void test03232() { x = 0x0000000080000000l; long result = x * 0x16l; AssertJUnit.assertEquals("multiply", result, 0x0000000b00000000l); }
@Test
public void test03233() { x = 0x00000000ffffffffl; long result = x * 0x16l; AssertJUnit.assertEquals("multiply", result, 0x00000015ffffffeal); }
@Test
public void test03234() { x = 0x000000017fffffffl; long result = x * 0x16l; AssertJUnit.assertEquals("multiply", result, 0x00000020ffffffeal); }
@Test
public void test03235() { x = 0x0000000180000000l; long result = x * 0x16l; AssertJUnit.assertEquals("multiply", result, 0x0000002100000000l); }
@Test
public void test03236() { x = 0x00000001ffffffffl; long result = x * 0x16l; AssertJUnit.assertEquals("multiply", result, 0x0000002bffffffeal); }
@Test
public void test03237() { x = 0xffffffff7fffffffl; long result = x * 0x16l; AssertJUnit.assertEquals("multiply", result, 0xfffffff4ffffffeal); }
@Test
public void test03238() { x = 0xffffffff80000000l; long result = x * 0x16l; AssertJUnit.assertEquals("multiply", result, 0xfffffff500000000l); }
@Test
public void test03239() { x = 0x00000001deadf00dl; long result = x * 0x16l; AssertJUnit.assertEquals("multiply", result, 0x0000002922f2a11el); }
@Test
public void test03240() { x = 0xffffffffdeadf00dl; long result = x * 0x16l; AssertJUnit.assertEquals("multiply", result, 0xfffffffd22f2a11el); }
@Test
public void test03241() { x = 0x7fffffffffffffffl; long result = x * 0x16l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffeal); }
@Test
public void test03242() { x = 0x7fffffff7fffffffl; long result = x * 0x16l; AssertJUnit.assertEquals("multiply", result, 0xfffffff4ffffffeal); }
@Test
public void test03243() { x = 0x7fffffff80000000l; long result = x * 0x16l; AssertJUnit.assertEquals("multiply", result, 0xfffffff500000000l); }
@Test
public void test03244() { x = 0x7fffffffdeadf00dl; long result = x * 0x16l; AssertJUnit.assertEquals("multiply", result, 0xfffffffd22f2a11el); }
@Test
public void test03245() { x = 0x8000000000000000l; long result = x * 0x16l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03246() { x = 0xffffffffffffffffl; long result = x * 0x16l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffeal); }
@Test
public void test03247() { x = 0xfffffffffffffffel; long result = x * 0x16l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffd4l); }
@Test
public void test03248() { x = 0xefffffffffffffffl; long result = x * 0x16l; AssertJUnit.assertEquals("multiply", result, 0x9fffffffffffffeal); }
@Test
public void test03249() { x = 0xdeadf00ddeadf00dl; long result = x * 0x16l; AssertJUnit.assertEquals("multiply", result, 0x22f2a13122f2a11el); }
@Test
public void test03250() { x = 0x000000007fffffffl; long result = x * 0xb0l; AssertJUnit.assertEquals("multiply", result, 0x00000057ffffff50l); }
@Test
public void test03251() { x = 0x0000000080000000l; long result = x * 0xb0l; AssertJUnit.assertEquals("multiply", result, 0x0000005800000000l); }
@Test
public void test03252() { x = 0x00000000ffffffffl; long result = x * 0xb0l; AssertJUnit.assertEquals("multiply", result, 0x000000afffffff50l); }
@Test
public void test03253() { x = 0x000000017fffffffl; long result = x * 0xb0l; AssertJUnit.assertEquals("multiply", result, 0x00000107ffffff50l); }
@Test
public void test03254() { x = 0x0000000180000000l; long result = x * 0xb0l; AssertJUnit.assertEquals("multiply", result, 0x0000010800000000l); }
@Test
public void test03255() { x = 0x00000001ffffffffl; long result = x * 0xb0l; AssertJUnit.assertEquals("multiply", result, 0x0000015fffffff50l); }
@Test
public void test03256() { x = 0xffffffff7fffffffl; long result = x * 0xb0l; AssertJUnit.assertEquals("multiply", result, 0xffffffa7ffffff50l); }
@Test
public void test03257() { x = 0xffffffff80000000l; long result = x * 0xb0l; AssertJUnit.assertEquals("multiply", result, 0xffffffa800000000l); }
@Test
public void test03258() { x = 0x00000001deadf00dl; long result = x * 0xb0l; AssertJUnit.assertEquals("multiply", result, 0x00000149179508f0l); }
@Test
public void test03259() { x = 0xffffffffdeadf00dl; long result = x * 0xb0l; AssertJUnit.assertEquals("multiply", result, 0xffffffe9179508f0l); }
@Test
public void test03260() { x = 0x7fffffffffffffffl; long result = x * 0xb0l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff50l); }
@Test
public void test03261() { x = 0x7fffffff7fffffffl; long result = x * 0xb0l; AssertJUnit.assertEquals("multiply", result, 0xffffffa7ffffff50l); }
@Test
public void test03262() { x = 0x7fffffff80000000l; long result = x * 0xb0l; AssertJUnit.assertEquals("multiply", result, 0xffffffa800000000l); }
@Test
public void test03263() { x = 0x7fffffffdeadf00dl; long result = x * 0xb0l; AssertJUnit.assertEquals("multiply", result, 0xffffffe9179508f0l); }
@Test
public void test03264() { x = 0x8000000000000000l; long result = x * 0xb0l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03265() { x = 0xffffffffffffffffl; long result = x * 0xb0l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff50l); }
@Test
public void test03266() { x = 0xfffffffffffffffel; long result = x * 0xb0l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffea0l); }
@Test
public void test03267() { x = 0xefffffffffffffffl; long result = x * 0xb0l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff50l); }
@Test
public void test03268() { x = 0xdeadf00ddeadf00dl; long result = x * 0xb0l; AssertJUnit.assertEquals("multiply", result, 0x17950989179508f0l); }
@Test
public void test03269() { x = 0x000000007fffffffl; long result = x * 0x1600l; AssertJUnit.assertEquals("multiply", result, 0x00000affffffea00l); }
@Test
public void test03270() { x = 0x0000000080000000l; long result = x * 0x1600l; AssertJUnit.assertEquals("multiply", result, 0x00000b0000000000l); }
@Test
public void test03271() { x = 0x00000000ffffffffl; long result = x * 0x1600l; AssertJUnit.assertEquals("multiply", result, 0x000015ffffffea00l); }
@Test
public void test03272() { x = 0x000000017fffffffl; long result = x * 0x1600l; AssertJUnit.assertEquals("multiply", result, 0x000020ffffffea00l); }
@Test
public void test03273() { x = 0x0000000180000000l; long result = x * 0x1600l; AssertJUnit.assertEquals("multiply", result, 0x0000210000000000l); }
@Test
public void test03274() { x = 0x00000001ffffffffl; long result = x * 0x1600l; AssertJUnit.assertEquals("multiply", result, 0x00002bffffffea00l); }
@Test
public void test03275() { x = 0xffffffff7fffffffl; long result = x * 0x1600l; AssertJUnit.assertEquals("multiply", result, 0xfffff4ffffffea00l); }
@Test
public void test03276() { x = 0xffffffff80000000l; long result = x * 0x1600l; AssertJUnit.assertEquals("multiply", result, 0xfffff50000000000l); }
@Test
public void test03277() { x = 0x00000001deadf00dl; long result = x * 0x1600l; AssertJUnit.assertEquals("multiply", result, 0x00002922f2a11e00l); }
@Test
public void test03278() { x = 0xffffffffdeadf00dl; long result = x * 0x1600l; AssertJUnit.assertEquals("multiply", result, 0xfffffd22f2a11e00l); }
@Test
public void test03279() { x = 0x7fffffffffffffffl; long result = x * 0x1600l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffea00l); }
@Test
public void test03280() { x = 0x7fffffff7fffffffl; long result = x * 0x1600l; AssertJUnit.assertEquals("multiply", result, 0xfffff4ffffffea00l); }
@Test
public void test03281() { x = 0x7fffffff80000000l; long result = x * 0x1600l; AssertJUnit.assertEquals("multiply", result, 0xfffff50000000000l); }
@Test
public void test03282() { x = 0x7fffffffdeadf00dl; long result = x * 0x1600l; AssertJUnit.assertEquals("multiply", result, 0xfffffd22f2a11e00l); }
@Test
public void test03283() { x = 0x8000000000000000l; long result = x * 0x1600l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03284() { x = 0xffffffffffffffffl; long result = x * 0x1600l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffea00l); }
@Test
public void test03285() { x = 0xfffffffffffffffel; long result = x * 0x1600l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffd400l); }
@Test
public void test03286() { x = 0xefffffffffffffffl; long result = x * 0x1600l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffea00l); }
@Test
public void test03287() { x = 0xdeadf00ddeadf00dl; long result = x * 0x1600l; AssertJUnit.assertEquals("multiply", result, 0xf2a13122f2a11e00l); }
@Test
public void test03288() { x = 0x000000007fffffffl; long result = x * 0x1600000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffea00000000l); }
@Test
public void test03289() { x = 0x0000000080000000l; long result = x * 0x1600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03290() { x = 0x00000000ffffffffl; long result = x * 0x1600000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffea00000000l); }
@Test
public void test03291() { x = 0x000000017fffffffl; long result = x * 0x1600000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffea00000000l); }
@Test
public void test03292() { x = 0x0000000180000000l; long result = x * 0x1600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03293() { x = 0x00000001ffffffffl; long result = x * 0x1600000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffea00000000l); }
@Test
public void test03294() { x = 0xffffffff7fffffffl; long result = x * 0x1600000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffea00000000l); }
@Test
public void test03295() { x = 0xffffffff80000000l; long result = x * 0x1600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03296() { x = 0x00000001deadf00dl; long result = x * 0x1600000000l; AssertJUnit.assertEquals("multiply", result, 0x22f2a11e00000000l); }
@Test
public void test03297() { x = 0xffffffffdeadf00dl; long result = x * 0x1600000000l; AssertJUnit.assertEquals("multiply", result, 0x22f2a11e00000000l); }
@Test
public void test03298() { x = 0x7fffffffffffffffl; long result = x * 0x1600000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffea00000000l); }
@Test
public void test03299() { x = 0x7fffffff7fffffffl; long result = x * 0x1600000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffea00000000l); }
@Test
public void test03300() { x = 0x7fffffff80000000l; long result = x * 0x1600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03301() { x = 0x7fffffffdeadf00dl; long result = x * 0x1600000000l; AssertJUnit.assertEquals("multiply", result, 0x22f2a11e00000000l); }
@Test
public void test03302() { x = 0x8000000000000000l; long result = x * 0x1600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03303() { x = 0xffffffffffffffffl; long result = x * 0x1600000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffea00000000l); }
@Test
public void test03304() { x = 0xfffffffffffffffel; long result = x * 0x1600000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffd400000000l); }
@Test
public void test03305() { x = 0xefffffffffffffffl; long result = x * 0x1600000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffea00000000l); }
@Test
public void test03306() { x = 0xdeadf00ddeadf00dl; long result = x * 0x1600000000l; AssertJUnit.assertEquals("multiply", result, 0x22f2a11e00000000l); }
@Test
public void test03307() { x = 0x000000007fffffffl; long result = x * 0xb000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff5000000000l); }
@Test
public void test03308() { x = 0x0000000080000000l; long result = x * 0xb000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03309() { x = 0x00000000ffffffffl; long result = x * 0xb000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff5000000000l); }
@Test
public void test03310() { x = 0x000000017fffffffl; long result = x * 0xb000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff5000000000l); }
@Test
public void test03311() { x = 0x0000000180000000l; long result = x * 0xb000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03312() { x = 0x00000001ffffffffl; long result = x * 0xb000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff5000000000l); }
@Test
public void test03313() { x = 0xffffffff7fffffffl; long result = x * 0xb000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff5000000000l); }
@Test
public void test03314() { x = 0xffffffff80000000l; long result = x * 0xb000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03315() { x = 0x00000001deadf00dl; long result = x * 0xb000000000l; AssertJUnit.assertEquals("multiply", result, 0x179508f000000000l); }
@Test
public void test03316() { x = 0xffffffffdeadf00dl; long result = x * 0xb000000000l; AssertJUnit.assertEquals("multiply", result, 0x179508f000000000l); }
@Test
public void test03317() { x = 0x7fffffffffffffffl; long result = x * 0xb000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff5000000000l); }
@Test
public void test03318() { x = 0x7fffffff7fffffffl; long result = x * 0xb000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff5000000000l); }
@Test
public void test03319() { x = 0x7fffffff80000000l; long result = x * 0xb000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03320() { x = 0x7fffffffdeadf00dl; long result = x * 0xb000000000l; AssertJUnit.assertEquals("multiply", result, 0x179508f000000000l); }
@Test
public void test03321() { x = 0x8000000000000000l; long result = x * 0xb000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03322() { x = 0xffffffffffffffffl; long result = x * 0xb000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff5000000000l); }
@Test
public void test03323() { x = 0xfffffffffffffffel; long result = x * 0xb000000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffea000000000l); }
@Test
public void test03324() { x = 0xefffffffffffffffl; long result = x * 0xb000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff5000000000l); }
@Test
public void test03325() { x = 0xdeadf00ddeadf00dl; long result = x * 0xb000000000l; AssertJUnit.assertEquals("multiply", result, 0x179508f000000000l); }
@Test
public void test03326() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffffeal; AssertJUnit.assertEquals("multiply", result, 0xfffffff500000016l); }
@Test
public void test03327() { x = 0x0000000080000000l; long result = x * 0xffffffffffffffeal; AssertJUnit.assertEquals("multiply", result, 0xfffffff500000000l); }
@Test
public void test03328() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffffeal; AssertJUnit.assertEquals("multiply", result, 0xffffffea00000016l); }
@Test
public void test03329() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffffeal; AssertJUnit.assertEquals("multiply", result, 0xffffffdf00000016l); }
@Test
public void test03330() { x = 0x0000000180000000l; long result = x * 0xffffffffffffffeal; AssertJUnit.assertEquals("multiply", result, 0xffffffdf00000000l); }
@Test
public void test03331() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffffeal; AssertJUnit.assertEquals("multiply", result, 0xffffffd400000016l); }
@Test
public void test03332() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffffeal; AssertJUnit.assertEquals("multiply", result, 0x0000000b00000016l); }
@Test
public void test03333() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffffeal; AssertJUnit.assertEquals("multiply", result, 0x0000000b00000000l); }
@Test
public void test03334() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffffeal; AssertJUnit.assertEquals("multiply", result, 0xffffffd6dd0d5ee2l); }
@Test
public void test03335() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffffeal; AssertJUnit.assertEquals("multiply", result, 0x00000002dd0d5ee2l); }
@Test
public void test03336() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffffeal; AssertJUnit.assertEquals("multiply", result, 0x0000000000000016l); }
@Test
public void test03337() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffffeal; AssertJUnit.assertEquals("multiply", result, 0x0000000b00000016l); }
@Test
public void test03338() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffffeal; AssertJUnit.assertEquals("multiply", result, 0x0000000b00000000l); }
@Test
public void test03339() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffffeal; AssertJUnit.assertEquals("multiply", result, 0x00000002dd0d5ee2l); }
@Test
public void test03340() { x = 0x8000000000000000l; long result = x * 0xffffffffffffffeal; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03341() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffffeal; AssertJUnit.assertEquals("multiply", result, 0x0000000000000016l); }
@Test
public void test03342() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffffeal; AssertJUnit.assertEquals("multiply", result, 0x000000000000002cl); }
@Test
public void test03343() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffffeal; AssertJUnit.assertEquals("multiply", result, 0x6000000000000016l); }
@Test
public void test03344() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffffeal; AssertJUnit.assertEquals("multiply", result, 0xdd0d5ecedd0d5ee2l); }
@Test
public void test03345() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffff50l; AssertJUnit.assertEquals("multiply", result, 0xffffffa8000000b0l); }
@Test
public void test03346() { x = 0x0000000080000000l; long result = x * 0xffffffffffffff50l; AssertJUnit.assertEquals("multiply", result, 0xffffffa800000000l); }
@Test
public void test03347() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffff50l; AssertJUnit.assertEquals("multiply", result, 0xffffff50000000b0l); }
@Test
public void test03348() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffff50l; AssertJUnit.assertEquals("multiply", result, 0xfffffef8000000b0l); }
@Test
public void test03349() { x = 0x0000000180000000l; long result = x * 0xffffffffffffff50l; AssertJUnit.assertEquals("multiply", result, 0xfffffef800000000l); }
@Test
public void test03350() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffff50l; AssertJUnit.assertEquals("multiply", result, 0xfffffea0000000b0l); }
@Test
public void test03351() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffff50l; AssertJUnit.assertEquals("multiply", result, 0x00000058000000b0l); }
@Test
public void test03352() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffff50l; AssertJUnit.assertEquals("multiply", result, 0x0000005800000000l); }
@Test
public void test03353() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffff50l; AssertJUnit.assertEquals("multiply", result, 0xfffffeb6e86af710l); }
@Test
public void test03354() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffff50l; AssertJUnit.assertEquals("multiply", result, 0x00000016e86af710l); }
@Test
public void test03355() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffff50l; AssertJUnit.assertEquals("multiply", result, 0x00000000000000b0l); }
@Test
public void test03356() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffff50l; AssertJUnit.assertEquals("multiply", result, 0x00000058000000b0l); }
@Test
public void test03357() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffff50l; AssertJUnit.assertEquals("multiply", result, 0x0000005800000000l); }
@Test
public void test03358() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffff50l; AssertJUnit.assertEquals("multiply", result, 0x00000016e86af710l); }
@Test
public void test03359() { x = 0x8000000000000000l; long result = x * 0xffffffffffffff50l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03360() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffff50l; AssertJUnit.assertEquals("multiply", result, 0x00000000000000b0l); }
@Test
public void test03361() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffff50l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000160l); }
@Test
public void test03362() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffff50l; AssertJUnit.assertEquals("multiply", result, 0x00000000000000b0l); }
@Test
public void test03363() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffff50l; AssertJUnit.assertEquals("multiply", result, 0xe86af676e86af710l); }
@Test
public void test03364() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffea00l; AssertJUnit.assertEquals("multiply", result, 0xfffff50000001600l); }
@Test
public void test03365() { x = 0x0000000080000000l; long result = x * 0xffffffffffffea00l; AssertJUnit.assertEquals("multiply", result, 0xfffff50000000000l); }
@Test
public void test03366() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffea00l; AssertJUnit.assertEquals("multiply", result, 0xffffea0000001600l); }
@Test
public void test03367() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffea00l; AssertJUnit.assertEquals("multiply", result, 0xffffdf0000001600l); }
@Test
public void test03368() { x = 0x0000000180000000l; long result = x * 0xffffffffffffea00l; AssertJUnit.assertEquals("multiply", result, 0xffffdf0000000000l); }
@Test
public void test03369() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffea00l; AssertJUnit.assertEquals("multiply", result, 0xffffd40000001600l); }
@Test
public void test03370() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffea00l; AssertJUnit.assertEquals("multiply", result, 0x00000b0000001600l); }
@Test
public void test03371() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffea00l; AssertJUnit.assertEquals("multiply", result, 0x00000b0000000000l); }
@Test
public void test03372() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffea00l; AssertJUnit.assertEquals("multiply", result, 0xffffd6dd0d5ee200l); }
@Test
public void test03373() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffea00l; AssertJUnit.assertEquals("multiply", result, 0x000002dd0d5ee200l); }
@Test
public void test03374() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffea00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001600l); }
@Test
public void test03375() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffea00l; AssertJUnit.assertEquals("multiply", result, 0x00000b0000001600l); }
@Test
public void test03376() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffea00l; AssertJUnit.assertEquals("multiply", result, 0x00000b0000000000l); }
@Test
public void test03377() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffea00l; AssertJUnit.assertEquals("multiply", result, 0x000002dd0d5ee200l); }
@Test
public void test03378() { x = 0x8000000000000000l; long result = x * 0xffffffffffffea00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03379() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffea00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001600l); }
@Test
public void test03380() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffea00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000002c00l); }
@Test
public void test03381() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffea00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001600l); }
@Test
public void test03382() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffea00l; AssertJUnit.assertEquals("multiply", result, 0x0d5ecedd0d5ee200l); }
@Test
public void test03383() { x = 0x000000007fffffffl; long result = x * 0xffffffea00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001600000000l); }
@Test
public void test03384() { x = 0x0000000080000000l; long result = x * 0xffffffea00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03385() { x = 0x00000000ffffffffl; long result = x * 0xffffffea00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001600000000l); }
@Test
public void test03386() { x = 0x000000017fffffffl; long result = x * 0xffffffea00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001600000000l); }
@Test
public void test03387() { x = 0x0000000180000000l; long result = x * 0xffffffea00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03388() { x = 0x00000001ffffffffl; long result = x * 0xffffffea00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001600000000l); }
@Test
public void test03389() { x = 0xffffffff7fffffffl; long result = x * 0xffffffea00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001600000000l); }
@Test
public void test03390() { x = 0xffffffff80000000l; long result = x * 0xffffffea00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03391() { x = 0x00000001deadf00dl; long result = x * 0xffffffea00000000l; AssertJUnit.assertEquals("multiply", result, 0xdd0d5ee200000000l); }
@Test
public void test03392() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffea00000000l; AssertJUnit.assertEquals("multiply", result, 0xdd0d5ee200000000l); }
@Test
public void test03393() { x = 0x7fffffffffffffffl; long result = x * 0xffffffea00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001600000000l); }
@Test
public void test03394() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffea00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001600000000l); }
@Test
public void test03395() { x = 0x7fffffff80000000l; long result = x * 0xffffffea00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03396() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffea00000000l; AssertJUnit.assertEquals("multiply", result, 0xdd0d5ee200000000l); }
@Test
public void test03397() { x = 0x8000000000000000l; long result = x * 0xffffffea00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03398() { x = 0xffffffffffffffffl; long result = x * 0xffffffea00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001600000000l); }
@Test
public void test03399() { x = 0xfffffffffffffffel; long result = x * 0xffffffea00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002c00000000l); }
@Test
public void test03400() { x = 0xefffffffffffffffl; long result = x * 0xffffffea00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001600000000l); }
@Test
public void test03401() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffea00000000l; AssertJUnit.assertEquals("multiply", result, 0xdd0d5ee200000000l); }
@Test
public void test03402() { x = 0x000000007fffffffl; long result = x * 0xffffff5000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000b000000000l); }
@Test
public void test03403() { x = 0x0000000080000000l; long result = x * 0xffffff5000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03404() { x = 0x00000000ffffffffl; long result = x * 0xffffff5000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000b000000000l); }
@Test
public void test03405() { x = 0x000000017fffffffl; long result = x * 0xffffff5000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000b000000000l); }
@Test
public void test03406() { x = 0x0000000180000000l; long result = x * 0xffffff5000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03407() { x = 0x00000001ffffffffl; long result = x * 0xffffff5000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000b000000000l); }
@Test
public void test03408() { x = 0xffffffff7fffffffl; long result = x * 0xffffff5000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000b000000000l); }
@Test
public void test03409() { x = 0xffffffff80000000l; long result = x * 0xffffff5000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03410() { x = 0x00000001deadf00dl; long result = x * 0xffffff5000000000l; AssertJUnit.assertEquals("multiply", result, 0xe86af71000000000l); }
@Test
public void test03411() { x = 0xffffffffdeadf00dl; long result = x * 0xffffff5000000000l; AssertJUnit.assertEquals("multiply", result, 0xe86af71000000000l); }
@Test
public void test03412() { x = 0x7fffffffffffffffl; long result = x * 0xffffff5000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000b000000000l); }
@Test
public void test03413() { x = 0x7fffffff7fffffffl; long result = x * 0xffffff5000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000b000000000l); }
@Test
public void test03414() { x = 0x7fffffff80000000l; long result = x * 0xffffff5000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03415() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffff5000000000l; AssertJUnit.assertEquals("multiply", result, 0xe86af71000000000l); }
@Test
public void test03416() { x = 0x8000000000000000l; long result = x * 0xffffff5000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03417() { x = 0xffffffffffffffffl; long result = x * 0xffffff5000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000b000000000l); }
@Test
public void test03418() { x = 0xfffffffffffffffel; long result = x * 0xffffff5000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000016000000000l); }
@Test
public void test03419() { x = 0xefffffffffffffffl; long result = x * 0xffffff5000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000b000000000l); }
@Test
public void test03420() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffff5000000000l; AssertJUnit.assertEquals("multiply", result, 0xe86af71000000000l); }
@Test
public void test03421() { x = 0x000000007fffffffl; long result = x * 0x17l; AssertJUnit.assertEquals("multiply", result, 0x0000000b7fffffe9l); }
@Test
public void test03422() { x = 0x0000000080000000l; long result = x * 0x17l; AssertJUnit.assertEquals("multiply", result, 0x0000000b80000000l); }
@Test
public void test03423() { x = 0x00000000ffffffffl; long result = x * 0x17l; AssertJUnit.assertEquals("multiply", result, 0x00000016ffffffe9l); }
@Test
public void test03424() { x = 0x000000017fffffffl; long result = x * 0x17l; AssertJUnit.assertEquals("multiply", result, 0x000000227fffffe9l); }
@Test
public void test03425() { x = 0x0000000180000000l; long result = x * 0x17l; AssertJUnit.assertEquals("multiply", result, 0x0000002280000000l); }
@Test
public void test03426() { x = 0x00000001ffffffffl; long result = x * 0x17l; AssertJUnit.assertEquals("multiply", result, 0x0000002dffffffe9l); }
@Test
public void test03427() { x = 0xffffffff7fffffffl; long result = x * 0x17l; AssertJUnit.assertEquals("multiply", result, 0xfffffff47fffffe9l); }
@Test
public void test03428() { x = 0xffffffff80000000l; long result = x * 0x17l; AssertJUnit.assertEquals("multiply", result, 0xfffffff480000000l); }
@Test
public void test03429() { x = 0x00000001deadf00dl; long result = x * 0x17l; AssertJUnit.assertEquals("multiply", result, 0x0000002b01a0912bl); }
@Test
public void test03430() { x = 0xffffffffdeadf00dl; long result = x * 0x17l; AssertJUnit.assertEquals("multiply", result, 0xfffffffd01a0912bl); }
@Test
public void test03431() { x = 0x7fffffffffffffffl; long result = x * 0x17l; AssertJUnit.assertEquals("multiply", result, 0x7fffffffffffffe9l); }
@Test
public void test03432() { x = 0x7fffffff7fffffffl; long result = x * 0x17l; AssertJUnit.assertEquals("multiply", result, 0x7ffffff47fffffe9l); }
@Test
public void test03433() { x = 0x7fffffff80000000l; long result = x * 0x17l; AssertJUnit.assertEquals("multiply", result, 0x7ffffff480000000l); }
@Test
public void test03434() { x = 0x7fffffffdeadf00dl; long result = x * 0x17l; AssertJUnit.assertEquals("multiply", result, 0x7ffffffd01a0912bl); }
@Test
public void test03435() { x = 0x8000000000000000l; long result = x * 0x17l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test03436() { x = 0xffffffffffffffffl; long result = x * 0x17l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffe9l); }
@Test
public void test03437() { x = 0xfffffffffffffffel; long result = x * 0x17l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffd2l); }
@Test
public void test03438() { x = 0xefffffffffffffffl; long result = x * 0x17l; AssertJUnit.assertEquals("multiply", result, 0x8fffffffffffffe9l); }
@Test
public void test03439() { x = 0xdeadf00ddeadf00dl; long result = x * 0x17l; AssertJUnit.assertEquals("multiply", result, 0x01a0913f01a0912bl); }
@Test
public void test03440() { x = 0x000000007fffffffl; long result = x * 0xb8l; AssertJUnit.assertEquals("multiply", result, 0x0000005bffffff48l); }
@Test
public void test03441() { x = 0x0000000080000000l; long result = x * 0xb8l; AssertJUnit.assertEquals("multiply", result, 0x0000005c00000000l); }
@Test
public void test03442() { x = 0x00000000ffffffffl; long result = x * 0xb8l; AssertJUnit.assertEquals("multiply", result, 0x000000b7ffffff48l); }
@Test
public void test03443() { x = 0x000000017fffffffl; long result = x * 0xb8l; AssertJUnit.assertEquals("multiply", result, 0x00000113ffffff48l); }
@Test
public void test03444() { x = 0x0000000180000000l; long result = x * 0xb8l; AssertJUnit.assertEquals("multiply", result, 0x0000011400000000l); }
@Test
public void test03445() { x = 0x00000001ffffffffl; long result = x * 0xb8l; AssertJUnit.assertEquals("multiply", result, 0x0000016fffffff48l); }
@Test
public void test03446() { x = 0xffffffff7fffffffl; long result = x * 0xb8l; AssertJUnit.assertEquals("multiply", result, 0xffffffa3ffffff48l); }
@Test
public void test03447() { x = 0xffffffff80000000l; long result = x * 0xb8l; AssertJUnit.assertEquals("multiply", result, 0xffffffa400000000l); }
@Test
public void test03448() { x = 0x00000001deadf00dl; long result = x * 0xb8l; AssertJUnit.assertEquals("multiply", result, 0x000001580d048958l); }
@Test
public void test03449() { x = 0xffffffffdeadf00dl; long result = x * 0xb8l; AssertJUnit.assertEquals("multiply", result, 0xffffffe80d048958l); }
@Test
public void test03450() { x = 0x7fffffffffffffffl; long result = x * 0xb8l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff48l); }
@Test
public void test03451() { x = 0x7fffffff7fffffffl; long result = x * 0xb8l; AssertJUnit.assertEquals("multiply", result, 0xffffffa3ffffff48l); }
@Test
public void test03452() { x = 0x7fffffff80000000l; long result = x * 0xb8l; AssertJUnit.assertEquals("multiply", result, 0xffffffa400000000l); }
@Test
public void test03453() { x = 0x7fffffffdeadf00dl; long result = x * 0xb8l; AssertJUnit.assertEquals("multiply", result, 0xffffffe80d048958l); }
@Test
public void test03454() { x = 0x8000000000000000l; long result = x * 0xb8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03455() { x = 0xffffffffffffffffl; long result = x * 0xb8l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff48l); }
@Test
public void test03456() { x = 0xfffffffffffffffel; long result = x * 0xb8l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffe90l); }
@Test
public void test03457() { x = 0xefffffffffffffffl; long result = x * 0xb8l; AssertJUnit.assertEquals("multiply", result, 0x7fffffffffffff48l); }
@Test
public void test03458() { x = 0xdeadf00ddeadf00dl; long result = x * 0xb8l; AssertJUnit.assertEquals("multiply", result, 0x0d0489f80d048958l); }
@Test
public void test03459() { x = 0x000000007fffffffl; long result = x * 0x1700l; AssertJUnit.assertEquals("multiply", result, 0x00000b7fffffe900l); }
@Test
public void test03460() { x = 0x0000000080000000l; long result = x * 0x1700l; AssertJUnit.assertEquals("multiply", result, 0x00000b8000000000l); }
@Test
public void test03461() { x = 0x00000000ffffffffl; long result = x * 0x1700l; AssertJUnit.assertEquals("multiply", result, 0x000016ffffffe900l); }
@Test
public void test03462() { x = 0x000000017fffffffl; long result = x * 0x1700l; AssertJUnit.assertEquals("multiply", result, 0x0000227fffffe900l); }
@Test
public void test03463() { x = 0x0000000180000000l; long result = x * 0x1700l; AssertJUnit.assertEquals("multiply", result, 0x0000228000000000l); }
@Test
public void test03464() { x = 0x00000001ffffffffl; long result = x * 0x1700l; AssertJUnit.assertEquals("multiply", result, 0x00002dffffffe900l); }
@Test
public void test03465() { x = 0xffffffff7fffffffl; long result = x * 0x1700l; AssertJUnit.assertEquals("multiply", result, 0xfffff47fffffe900l); }
@Test
public void test03466() { x = 0xffffffff80000000l; long result = x * 0x1700l; AssertJUnit.assertEquals("multiply", result, 0xfffff48000000000l); }
@Test
public void test03467() { x = 0x00000001deadf00dl; long result = x * 0x1700l; AssertJUnit.assertEquals("multiply", result, 0x00002b01a0912b00l); }
@Test
public void test03468() { x = 0xffffffffdeadf00dl; long result = x * 0x1700l; AssertJUnit.assertEquals("multiply", result, 0xfffffd01a0912b00l); }
@Test
public void test03469() { x = 0x7fffffffffffffffl; long result = x * 0x1700l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffe900l); }
@Test
public void test03470() { x = 0x7fffffff7fffffffl; long result = x * 0x1700l; AssertJUnit.assertEquals("multiply", result, 0xfffff47fffffe900l); }
@Test
public void test03471() { x = 0x7fffffff80000000l; long result = x * 0x1700l; AssertJUnit.assertEquals("multiply", result, 0xfffff48000000000l); }
@Test
public void test03472() { x = 0x7fffffffdeadf00dl; long result = x * 0x1700l; AssertJUnit.assertEquals("multiply", result, 0xfffffd01a0912b00l); }
@Test
public void test03473() { x = 0x8000000000000000l; long result = x * 0x1700l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03474() { x = 0xffffffffffffffffl; long result = x * 0x1700l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffe900l); }
@Test
public void test03475() { x = 0xfffffffffffffffel; long result = x * 0x1700l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffd200l); }
@Test
public void test03476() { x = 0xefffffffffffffffl; long result = x * 0x1700l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffe900l); }
@Test
public void test03477() { x = 0xdeadf00ddeadf00dl; long result = x * 0x1700l; AssertJUnit.assertEquals("multiply", result, 0xa0913f01a0912b00l); }
@Test
public void test03478() { x = 0x000000007fffffffl; long result = x * 0x1700000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffe900000000l); }
@Test
public void test03479() { x = 0x0000000080000000l; long result = x * 0x1700000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test03480() { x = 0x00000000ffffffffl; long result = x * 0x1700000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe900000000l); }
@Test
public void test03481() { x = 0x000000017fffffffl; long result = x * 0x1700000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffe900000000l); }
@Test
public void test03482() { x = 0x0000000180000000l; long result = x * 0x1700000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test03483() { x = 0x00000001ffffffffl; long result = x * 0x1700000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe900000000l); }
@Test
public void test03484() { x = 0xffffffff7fffffffl; long result = x * 0x1700000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffe900000000l); }
@Test
public void test03485() { x = 0xffffffff80000000l; long result = x * 0x1700000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test03486() { x = 0x00000001deadf00dl; long result = x * 0x1700000000l; AssertJUnit.assertEquals("multiply", result, 0x01a0912b00000000l); }
@Test
public void test03487() { x = 0xffffffffdeadf00dl; long result = x * 0x1700000000l; AssertJUnit.assertEquals("multiply", result, 0x01a0912b00000000l); }
@Test
public void test03488() { x = 0x7fffffffffffffffl; long result = x * 0x1700000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe900000000l); }
@Test
public void test03489() { x = 0x7fffffff7fffffffl; long result = x * 0x1700000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffe900000000l); }
@Test
public void test03490() { x = 0x7fffffff80000000l; long result = x * 0x1700000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test03491() { x = 0x7fffffffdeadf00dl; long result = x * 0x1700000000l; AssertJUnit.assertEquals("multiply", result, 0x01a0912b00000000l); }
@Test
public void test03492() { x = 0x8000000000000000l; long result = x * 0x1700000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03493() { x = 0xffffffffffffffffl; long result = x * 0x1700000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe900000000l); }
@Test
public void test03494() { x = 0xfffffffffffffffel; long result = x * 0x1700000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffd200000000l); }
@Test
public void test03495() { x = 0xefffffffffffffffl; long result = x * 0x1700000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe900000000l); }
@Test
public void test03496() { x = 0xdeadf00ddeadf00dl; long result = x * 0x1700000000l; AssertJUnit.assertEquals("multiply", result, 0x01a0912b00000000l); }
@Test
public void test03497() { x = 0x000000007fffffffl; long result = x * 0xb800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff4800000000l); }
@Test
public void test03498() { x = 0x0000000080000000l; long result = x * 0xb800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03499() { x = 0x00000000ffffffffl; long result = x * 0xb800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff4800000000l); }
@Test
public void test03500() { x = 0x000000017fffffffl; long result = x * 0xb800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff4800000000l); }
@Test
public void test03501() { x = 0x0000000180000000l; long result = x * 0xb800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03502() { x = 0x00000001ffffffffl; long result = x * 0xb800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff4800000000l); }
@Test
public void test03503() { x = 0xffffffff7fffffffl; long result = x * 0xb800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff4800000000l); }
@Test
public void test03504() { x = 0xffffffff80000000l; long result = x * 0xb800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03505() { x = 0x00000001deadf00dl; long result = x * 0xb800000000l; AssertJUnit.assertEquals("multiply", result, 0x0d04895800000000l); }
@Test
public void test03506() { x = 0xffffffffdeadf00dl; long result = x * 0xb800000000l; AssertJUnit.assertEquals("multiply", result, 0x0d04895800000000l); }
@Test
public void test03507() { x = 0x7fffffffffffffffl; long result = x * 0xb800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff4800000000l); }
@Test
public void test03508() { x = 0x7fffffff7fffffffl; long result = x * 0xb800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff4800000000l); }
@Test
public void test03509() { x = 0x7fffffff80000000l; long result = x * 0xb800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03510() { x = 0x7fffffffdeadf00dl; long result = x * 0xb800000000l; AssertJUnit.assertEquals("multiply", result, 0x0d04895800000000l); }
@Test
public void test03511() { x = 0x8000000000000000l; long result = x * 0xb800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03512() { x = 0xffffffffffffffffl; long result = x * 0xb800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff4800000000l); }
@Test
public void test03513() { x = 0xfffffffffffffffel; long result = x * 0xb800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffe9000000000l); }
@Test
public void test03514() { x = 0xefffffffffffffffl; long result = x * 0xb800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff4800000000l); }
@Test
public void test03515() { x = 0xdeadf00ddeadf00dl; long result = x * 0xb800000000l; AssertJUnit.assertEquals("multiply", result, 0x0d04895800000000l); }
@Test
public void test03516() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffffe9l; AssertJUnit.assertEquals("multiply", result, 0xfffffff480000017l); }
@Test
public void test03517() { x = 0x0000000080000000l; long result = x * 0xffffffffffffffe9l; AssertJUnit.assertEquals("multiply", result, 0xfffffff480000000l); }
@Test
public void test03518() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffffe9l; AssertJUnit.assertEquals("multiply", result, 0xffffffe900000017l); }
@Test
public void test03519() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffffe9l; AssertJUnit.assertEquals("multiply", result, 0xffffffdd80000017l); }
@Test
public void test03520() { x = 0x0000000180000000l; long result = x * 0xffffffffffffffe9l; AssertJUnit.assertEquals("multiply", result, 0xffffffdd80000000l); }
@Test
public void test03521() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffffe9l; AssertJUnit.assertEquals("multiply", result, 0xffffffd200000017l); }
@Test
public void test03522() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffffe9l; AssertJUnit.assertEquals("multiply", result, 0x0000000b80000017l); }
@Test
public void test03523() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffffe9l; AssertJUnit.assertEquals("multiply", result, 0x0000000b80000000l); }
@Test
public void test03524() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffffe9l; AssertJUnit.assertEquals("multiply", result, 0xffffffd4fe5f6ed5l); }
@Test
public void test03525() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffffe9l; AssertJUnit.assertEquals("multiply", result, 0x00000002fe5f6ed5l); }
@Test
public void test03526() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffffe9l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000017l); }
@Test
public void test03527() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffffe9l; AssertJUnit.assertEquals("multiply", result, 0x8000000b80000017l); }
@Test
public void test03528() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffffe9l; AssertJUnit.assertEquals("multiply", result, 0x8000000b80000000l); }
@Test
public void test03529() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffffe9l; AssertJUnit.assertEquals("multiply", result, 0x80000002fe5f6ed5l); }
@Test
public void test03530() { x = 0x8000000000000000l; long result = x * 0xffffffffffffffe9l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test03531() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffffe9l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000017l); }
@Test
public void test03532() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffffe9l; AssertJUnit.assertEquals("multiply", result, 0x000000000000002el); }
@Test
public void test03533() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffffe9l; AssertJUnit.assertEquals("multiply", result, 0x7000000000000017l); }
@Test
public void test03534() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffffe9l; AssertJUnit.assertEquals("multiply", result, 0xfe5f6ec0fe5f6ed5l); }
@Test
public void test03535() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffff48l; AssertJUnit.assertEquals("multiply", result, 0xffffffa4000000b8l); }
@Test
public void test03536() { x = 0x0000000080000000l; long result = x * 0xffffffffffffff48l; AssertJUnit.assertEquals("multiply", result, 0xffffffa400000000l); }
@Test
public void test03537() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffff48l; AssertJUnit.assertEquals("multiply", result, 0xffffff48000000b8l); }
@Test
public void test03538() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffff48l; AssertJUnit.assertEquals("multiply", result, 0xfffffeec000000b8l); }
@Test
public void test03539() { x = 0x0000000180000000l; long result = x * 0xffffffffffffff48l; AssertJUnit.assertEquals("multiply", result, 0xfffffeec00000000l); }
@Test
public void test03540() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffff48l; AssertJUnit.assertEquals("multiply", result, 0xfffffe90000000b8l); }
@Test
public void test03541() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffff48l; AssertJUnit.assertEquals("multiply", result, 0x0000005c000000b8l); }
@Test
public void test03542() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffff48l; AssertJUnit.assertEquals("multiply", result, 0x0000005c00000000l); }
@Test
public void test03543() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffff48l; AssertJUnit.assertEquals("multiply", result, 0xfffffea7f2fb76a8l); }
@Test
public void test03544() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffff48l; AssertJUnit.assertEquals("multiply", result, 0x00000017f2fb76a8l); }
@Test
public void test03545() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffff48l; AssertJUnit.assertEquals("multiply", result, 0x00000000000000b8l); }
@Test
public void test03546() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffff48l; AssertJUnit.assertEquals("multiply", result, 0x0000005c000000b8l); }
@Test
public void test03547() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffff48l; AssertJUnit.assertEquals("multiply", result, 0x0000005c00000000l); }
@Test
public void test03548() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffff48l; AssertJUnit.assertEquals("multiply", result, 0x00000017f2fb76a8l); }
@Test
public void test03549() { x = 0x8000000000000000l; long result = x * 0xffffffffffffff48l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03550() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffff48l; AssertJUnit.assertEquals("multiply", result, 0x00000000000000b8l); }
@Test
public void test03551() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffff48l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000170l); }
@Test
public void test03552() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffff48l; AssertJUnit.assertEquals("multiply", result, 0x80000000000000b8l); }
@Test
public void test03553() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffff48l; AssertJUnit.assertEquals("multiply", result, 0xf2fb7607f2fb76a8l); }
@Test
public void test03554() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffe900l; AssertJUnit.assertEquals("multiply", result, 0xfffff48000001700l); }
@Test
public void test03555() { x = 0x0000000080000000l; long result = x * 0xffffffffffffe900l; AssertJUnit.assertEquals("multiply", result, 0xfffff48000000000l); }
@Test
public void test03556() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffe900l; AssertJUnit.assertEquals("multiply", result, 0xffffe90000001700l); }
@Test
public void test03557() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffe900l; AssertJUnit.assertEquals("multiply", result, 0xffffdd8000001700l); }
@Test
public void test03558() { x = 0x0000000180000000l; long result = x * 0xffffffffffffe900l; AssertJUnit.assertEquals("multiply", result, 0xffffdd8000000000l); }
@Test
public void test03559() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffe900l; AssertJUnit.assertEquals("multiply", result, 0xffffd20000001700l); }
@Test
public void test03560() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffe900l; AssertJUnit.assertEquals("multiply", result, 0x00000b8000001700l); }
@Test
public void test03561() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffe900l; AssertJUnit.assertEquals("multiply", result, 0x00000b8000000000l); }
@Test
public void test03562() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffe900l; AssertJUnit.assertEquals("multiply", result, 0xffffd4fe5f6ed500l); }
@Test
public void test03563() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffe900l; AssertJUnit.assertEquals("multiply", result, 0x000002fe5f6ed500l); }
@Test
public void test03564() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffe900l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001700l); }
@Test
public void test03565() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffe900l; AssertJUnit.assertEquals("multiply", result, 0x00000b8000001700l); }
@Test
public void test03566() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffe900l; AssertJUnit.assertEquals("multiply", result, 0x00000b8000000000l); }
@Test
public void test03567() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffe900l; AssertJUnit.assertEquals("multiply", result, 0x000002fe5f6ed500l); }
@Test
public void test03568() { x = 0x8000000000000000l; long result = x * 0xffffffffffffe900l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03569() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffe900l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001700l); }
@Test
public void test03570() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffe900l; AssertJUnit.assertEquals("multiply", result, 0x0000000000002e00l); }
@Test
public void test03571() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffe900l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001700l); }
@Test
public void test03572() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffe900l; AssertJUnit.assertEquals("multiply", result, 0x5f6ec0fe5f6ed500l); }
@Test
public void test03573() { x = 0x000000007fffffffl; long result = x * 0xffffffe900000000l; AssertJUnit.assertEquals("multiply", result, 0x8000001700000000l); }
@Test
public void test03574() { x = 0x0000000080000000l; long result = x * 0xffffffe900000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test03575() { x = 0x00000000ffffffffl; long result = x * 0xffffffe900000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001700000000l); }
@Test
public void test03576() { x = 0x000000017fffffffl; long result = x * 0xffffffe900000000l; AssertJUnit.assertEquals("multiply", result, 0x8000001700000000l); }
@Test
public void test03577() { x = 0x0000000180000000l; long result = x * 0xffffffe900000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test03578() { x = 0x00000001ffffffffl; long result = x * 0xffffffe900000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001700000000l); }
@Test
public void test03579() { x = 0xffffffff7fffffffl; long result = x * 0xffffffe900000000l; AssertJUnit.assertEquals("multiply", result, 0x8000001700000000l); }
@Test
public void test03580() { x = 0xffffffff80000000l; long result = x * 0xffffffe900000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test03581() { x = 0x00000001deadf00dl; long result = x * 0xffffffe900000000l; AssertJUnit.assertEquals("multiply", result, 0xfe5f6ed500000000l); }
@Test
public void test03582() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffe900000000l; AssertJUnit.assertEquals("multiply", result, 0xfe5f6ed500000000l); }
@Test
public void test03583() { x = 0x7fffffffffffffffl; long result = x * 0xffffffe900000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001700000000l); }
@Test
public void test03584() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffe900000000l; AssertJUnit.assertEquals("multiply", result, 0x8000001700000000l); }
@Test
public void test03585() { x = 0x7fffffff80000000l; long result = x * 0xffffffe900000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test03586() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffe900000000l; AssertJUnit.assertEquals("multiply", result, 0xfe5f6ed500000000l); }
@Test
public void test03587() { x = 0x8000000000000000l; long result = x * 0xffffffe900000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03588() { x = 0xffffffffffffffffl; long result = x * 0xffffffe900000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001700000000l); }
@Test
public void test03589() { x = 0xfffffffffffffffel; long result = x * 0xffffffe900000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002e00000000l); }
@Test
public void test03590() { x = 0xefffffffffffffffl; long result = x * 0xffffffe900000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001700000000l); }
@Test
public void test03591() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffe900000000l; AssertJUnit.assertEquals("multiply", result, 0xfe5f6ed500000000l); }
@Test
public void test03592() { x = 0x000000007fffffffl; long result = x * 0xffffff4800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000b800000000l); }
@Test
public void test03593() { x = 0x0000000080000000l; long result = x * 0xffffff4800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03594() { x = 0x00000000ffffffffl; long result = x * 0xffffff4800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000b800000000l); }
@Test
public void test03595() { x = 0x000000017fffffffl; long result = x * 0xffffff4800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000b800000000l); }
@Test
public void test03596() { x = 0x0000000180000000l; long result = x * 0xffffff4800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03597() { x = 0x00000001ffffffffl; long result = x * 0xffffff4800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000b800000000l); }
@Test
public void test03598() { x = 0xffffffff7fffffffl; long result = x * 0xffffff4800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000b800000000l); }
@Test
public void test03599() { x = 0xffffffff80000000l; long result = x * 0xffffff4800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03600() { x = 0x00000001deadf00dl; long result = x * 0xffffff4800000000l; AssertJUnit.assertEquals("multiply", result, 0xf2fb76a800000000l); }
@Test
public void test03601() { x = 0xffffffffdeadf00dl; long result = x * 0xffffff4800000000l; AssertJUnit.assertEquals("multiply", result, 0xf2fb76a800000000l); }
@Test
public void test03602() { x = 0x7fffffffffffffffl; long result = x * 0xffffff4800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000b800000000l); }
@Test
public void test03603() { x = 0x7fffffff7fffffffl; long result = x * 0xffffff4800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000b800000000l); }
@Test
public void test03604() { x = 0x7fffffff80000000l; long result = x * 0xffffff4800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03605() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffff4800000000l; AssertJUnit.assertEquals("multiply", result, 0xf2fb76a800000000l); }
@Test
public void test03606() { x = 0x8000000000000000l; long result = x * 0xffffff4800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03607() { x = 0xffffffffffffffffl; long result = x * 0xffffff4800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000b800000000l); }
@Test
public void test03608() { x = 0xfffffffffffffffel; long result = x * 0xffffff4800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000017000000000l); }
@Test
public void test03609() { x = 0xefffffffffffffffl; long result = x * 0xffffff4800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000b800000000l); }
@Test
public void test03610() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffff4800000000l; AssertJUnit.assertEquals("multiply", result, 0xf2fb76a800000000l); }
@Test
public void test03611() { x = 0x000000007fffffffl; long result = x * 0x18l; AssertJUnit.assertEquals("multiply", result, 0x0000000bffffffe8l); }
@Test
public void test03612() { x = 0x0000000080000000l; long result = x * 0x18l; AssertJUnit.assertEquals("multiply", result, 0x0000000c00000000l); }
@Test
public void test03613() { x = 0x00000000ffffffffl; long result = x * 0x18l; AssertJUnit.assertEquals("multiply", result, 0x00000017ffffffe8l); }
@Test
public void test03614() { x = 0x000000017fffffffl; long result = x * 0x18l; AssertJUnit.assertEquals("multiply", result, 0x00000023ffffffe8l); }
@Test
public void test03615() { x = 0x0000000180000000l; long result = x * 0x18l; AssertJUnit.assertEquals("multiply", result, 0x0000002400000000l); }
@Test
public void test03616() { x = 0x00000001ffffffffl; long result = x * 0x18l; AssertJUnit.assertEquals("multiply", result, 0x0000002fffffffe8l); }
@Test
public void test03617() { x = 0xffffffff7fffffffl; long result = x * 0x18l; AssertJUnit.assertEquals("multiply", result, 0xfffffff3ffffffe8l); }
@Test
public void test03618() { x = 0xffffffff80000000l; long result = x * 0x18l; AssertJUnit.assertEquals("multiply", result, 0xfffffff400000000l); }
@Test
public void test03619() { x = 0x00000001deadf00dl; long result = x * 0x18l; AssertJUnit.assertEquals("multiply", result, 0x0000002ce04e8138l); }
@Test
public void test03620() { x = 0xffffffffdeadf00dl; long result = x * 0x18l; AssertJUnit.assertEquals("multiply", result, 0xfffffffce04e8138l); }
@Test
public void test03621() { x = 0x7fffffffffffffffl; long result = x * 0x18l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffe8l); }
@Test
public void test03622() { x = 0x7fffffff7fffffffl; long result = x * 0x18l; AssertJUnit.assertEquals("multiply", result, 0xfffffff3ffffffe8l); }
@Test
public void test03623() { x = 0x7fffffff80000000l; long result = x * 0x18l; AssertJUnit.assertEquals("multiply", result, 0xfffffff400000000l); }
@Test
public void test03624() { x = 0x7fffffffdeadf00dl; long result = x * 0x18l; AssertJUnit.assertEquals("multiply", result, 0xfffffffce04e8138l); }
@Test
public void test03625() { x = 0x8000000000000000l; long result = x * 0x18l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03626() { x = 0xffffffffffffffffl; long result = x * 0x18l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffe8l); }
@Test
public void test03627() { x = 0xfffffffffffffffel; long result = x * 0x18l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffd0l); }
@Test
public void test03628() { x = 0xefffffffffffffffl; long result = x * 0x18l; AssertJUnit.assertEquals("multiply", result, 0x7fffffffffffffe8l); }
@Test
public void test03629() { x = 0xdeadf00ddeadf00dl; long result = x * 0x18l; AssertJUnit.assertEquals("multiply", result, 0xe04e814ce04e8138l); }
@Test
public void test03630() { x = 0x000000007fffffffl; long result = x * 0xc0l; AssertJUnit.assertEquals("multiply", result, 0x0000005fffffff40l); }
@Test
public void test03631() { x = 0x0000000080000000l; long result = x * 0xc0l; AssertJUnit.assertEquals("multiply", result, 0x0000006000000000l); }
@Test
public void test03632() { x = 0x00000000ffffffffl; long result = x * 0xc0l; AssertJUnit.assertEquals("multiply", result, 0x000000bfffffff40l); }
@Test
public void test03633() { x = 0x000000017fffffffl; long result = x * 0xc0l; AssertJUnit.assertEquals("multiply", result, 0x0000011fffffff40l); }
@Test
public void test03634() { x = 0x0000000180000000l; long result = x * 0xc0l; AssertJUnit.assertEquals("multiply", result, 0x0000012000000000l); }
@Test
public void test03635() { x = 0x00000001ffffffffl; long result = x * 0xc0l; AssertJUnit.assertEquals("multiply", result, 0x0000017fffffff40l); }
@Test
public void test03636() { x = 0xffffffff7fffffffl; long result = x * 0xc0l; AssertJUnit.assertEquals("multiply", result, 0xffffff9fffffff40l); }
@Test
public void test03637() { x = 0xffffffff80000000l; long result = x * 0xc0l; AssertJUnit.assertEquals("multiply", result, 0xffffffa000000000l); }
@Test
public void test03638() { x = 0x00000001deadf00dl; long result = x * 0xc0l; AssertJUnit.assertEquals("multiply", result, 0x00000167027409c0l); }
@Test
public void test03639() { x = 0xffffffffdeadf00dl; long result = x * 0xc0l; AssertJUnit.assertEquals("multiply", result, 0xffffffe7027409c0l); }
@Test
public void test03640() { x = 0x7fffffffffffffffl; long result = x * 0xc0l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff40l); }
@Test
public void test03641() { x = 0x7fffffff7fffffffl; long result = x * 0xc0l; AssertJUnit.assertEquals("multiply", result, 0xffffff9fffffff40l); }
@Test
public void test03642() { x = 0x7fffffff80000000l; long result = x * 0xc0l; AssertJUnit.assertEquals("multiply", result, 0xffffffa000000000l); }
@Test
public void test03643() { x = 0x7fffffffdeadf00dl; long result = x * 0xc0l; AssertJUnit.assertEquals("multiply", result, 0xffffffe7027409c0l); }
@Test
public void test03644() { x = 0x8000000000000000l; long result = x * 0xc0l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03645() { x = 0xffffffffffffffffl; long result = x * 0xc0l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff40l); }
@Test
public void test03646() { x = 0xfffffffffffffffel; long result = x * 0xc0l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffe80l); }
@Test
public void test03647() { x = 0xefffffffffffffffl; long result = x * 0xc0l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff40l); }
@Test
public void test03648() { x = 0xdeadf00ddeadf00dl; long result = x * 0xc0l; AssertJUnit.assertEquals("multiply", result, 0x02740a67027409c0l); }
@Test
public void test03649() { x = 0x000000007fffffffl; long result = x * 0x1800l; AssertJUnit.assertEquals("multiply", result, 0x00000bffffffe800l); }
@Test
public void test03650() { x = 0x0000000080000000l; long result = x * 0x1800l; AssertJUnit.assertEquals("multiply", result, 0x00000c0000000000l); }
@Test
public void test03651() { x = 0x00000000ffffffffl; long result = x * 0x1800l; AssertJUnit.assertEquals("multiply", result, 0x000017ffffffe800l); }
@Test
public void test03652() { x = 0x000000017fffffffl; long result = x * 0x1800l; AssertJUnit.assertEquals("multiply", result, 0x000023ffffffe800l); }
@Test
public void test03653() { x = 0x0000000180000000l; long result = x * 0x1800l; AssertJUnit.assertEquals("multiply", result, 0x0000240000000000l); }
@Test
public void test03654() { x = 0x00000001ffffffffl; long result = x * 0x1800l; AssertJUnit.assertEquals("multiply", result, 0x00002fffffffe800l); }
@Test
public void test03655() { x = 0xffffffff7fffffffl; long result = x * 0x1800l; AssertJUnit.assertEquals("multiply", result, 0xfffff3ffffffe800l); }
@Test
public void test03656() { x = 0xffffffff80000000l; long result = x * 0x1800l; AssertJUnit.assertEquals("multiply", result, 0xfffff40000000000l); }
@Test
public void test03657() { x = 0x00000001deadf00dl; long result = x * 0x1800l; AssertJUnit.assertEquals("multiply", result, 0x00002ce04e813800l); }
@Test
public void test03658() { x = 0xffffffffdeadf00dl; long result = x * 0x1800l; AssertJUnit.assertEquals("multiply", result, 0xfffffce04e813800l); }
@Test
public void test03659() { x = 0x7fffffffffffffffl; long result = x * 0x1800l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffe800l); }
@Test
public void test03660() { x = 0x7fffffff7fffffffl; long result = x * 0x1800l; AssertJUnit.assertEquals("multiply", result, 0xfffff3ffffffe800l); }
@Test
public void test03661() { x = 0x7fffffff80000000l; long result = x * 0x1800l; AssertJUnit.assertEquals("multiply", result, 0xfffff40000000000l); }
@Test
public void test03662() { x = 0x7fffffffdeadf00dl; long result = x * 0x1800l; AssertJUnit.assertEquals("multiply", result, 0xfffffce04e813800l); }
@Test
public void test03663() { x = 0x8000000000000000l; long result = x * 0x1800l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03664() { x = 0xffffffffffffffffl; long result = x * 0x1800l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffe800l); }
@Test
public void test03665() { x = 0xfffffffffffffffel; long result = x * 0x1800l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffd000l); }
@Test
public void test03666() { x = 0xefffffffffffffffl; long result = x * 0x1800l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffe800l); }
@Test
public void test03667() { x = 0xdeadf00ddeadf00dl; long result = x * 0x1800l; AssertJUnit.assertEquals("multiply", result, 0x4e814ce04e813800l); }
@Test
public void test03668() { x = 0x000000007fffffffl; long result = x * 0x1800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe800000000l); }
@Test
public void test03669() { x = 0x0000000080000000l; long result = x * 0x1800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03670() { x = 0x00000000ffffffffl; long result = x * 0x1800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe800000000l); }
@Test
public void test03671() { x = 0x000000017fffffffl; long result = x * 0x1800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe800000000l); }
@Test
public void test03672() { x = 0x0000000180000000l; long result = x * 0x1800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03673() { x = 0x00000001ffffffffl; long result = x * 0x1800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe800000000l); }
@Test
public void test03674() { x = 0xffffffff7fffffffl; long result = x * 0x1800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe800000000l); }
@Test
public void test03675() { x = 0xffffffff80000000l; long result = x * 0x1800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03676() { x = 0x00000001deadf00dl; long result = x * 0x1800000000l; AssertJUnit.assertEquals("multiply", result, 0xe04e813800000000l); }
@Test
public void test03677() { x = 0xffffffffdeadf00dl; long result = x * 0x1800000000l; AssertJUnit.assertEquals("multiply", result, 0xe04e813800000000l); }
@Test
public void test03678() { x = 0x7fffffffffffffffl; long result = x * 0x1800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe800000000l); }
@Test
public void test03679() { x = 0x7fffffff7fffffffl; long result = x * 0x1800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe800000000l); }
@Test
public void test03680() { x = 0x7fffffff80000000l; long result = x * 0x1800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03681() { x = 0x7fffffffdeadf00dl; long result = x * 0x1800000000l; AssertJUnit.assertEquals("multiply", result, 0xe04e813800000000l); }
@Test
public void test03682() { x = 0x8000000000000000l; long result = x * 0x1800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03683() { x = 0xffffffffffffffffl; long result = x * 0x1800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe800000000l); }
@Test
public void test03684() { x = 0xfffffffffffffffel; long result = x * 0x1800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffd000000000l); }
@Test
public void test03685() { x = 0xefffffffffffffffl; long result = x * 0x1800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe800000000l); }
@Test
public void test03686() { x = 0xdeadf00ddeadf00dl; long result = x * 0x1800000000l; AssertJUnit.assertEquals("multiply", result, 0xe04e813800000000l); }
@Test
public void test03687() { x = 0x000000007fffffffl; long result = x * 0xc000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff4000000000l); }
@Test
public void test03688() { x = 0x0000000080000000l; long result = x * 0xc000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03689() { x = 0x00000000ffffffffl; long result = x * 0xc000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff4000000000l); }
@Test
public void test03690() { x = 0x000000017fffffffl; long result = x * 0xc000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff4000000000l); }
@Test
public void test03691() { x = 0x0000000180000000l; long result = x * 0xc000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03692() { x = 0x00000001ffffffffl; long result = x * 0xc000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff4000000000l); }
@Test
public void test03693() { x = 0xffffffff7fffffffl; long result = x * 0xc000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff4000000000l); }
@Test
public void test03694() { x = 0xffffffff80000000l; long result = x * 0xc000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03695() { x = 0x00000001deadf00dl; long result = x * 0xc000000000l; AssertJUnit.assertEquals("multiply", result, 0x027409c000000000l); }
@Test
public void test03696() { x = 0xffffffffdeadf00dl; long result = x * 0xc000000000l; AssertJUnit.assertEquals("multiply", result, 0x027409c000000000l); }
@Test
public void test03697() { x = 0x7fffffffffffffffl; long result = x * 0xc000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff4000000000l); }
@Test
public void test03698() { x = 0x7fffffff7fffffffl; long result = x * 0xc000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff4000000000l); }
@Test
public void test03699() { x = 0x7fffffff80000000l; long result = x * 0xc000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03700() { x = 0x7fffffffdeadf00dl; long result = x * 0xc000000000l; AssertJUnit.assertEquals("multiply", result, 0x027409c000000000l); }
@Test
public void test03701() { x = 0x8000000000000000l; long result = x * 0xc000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03702() { x = 0xffffffffffffffffl; long result = x * 0xc000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff4000000000l); }
@Test
public void test03703() { x = 0xfffffffffffffffel; long result = x * 0xc000000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffe8000000000l); }
@Test
public void test03704() { x = 0xefffffffffffffffl; long result = x * 0xc000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff4000000000l); }
@Test
public void test03705() { x = 0xdeadf00ddeadf00dl; long result = x * 0xc000000000l; AssertJUnit.assertEquals("multiply", result, 0x027409c000000000l); }
@Test
public void test03706() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffffe8l; AssertJUnit.assertEquals("multiply", result, 0xfffffff400000018l); }
@Test
public void test03707() { x = 0x0000000080000000l; long result = x * 0xffffffffffffffe8l; AssertJUnit.assertEquals("multiply", result, 0xfffffff400000000l); }
@Test
public void test03708() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffffe8l; AssertJUnit.assertEquals("multiply", result, 0xffffffe800000018l); }
@Test
public void test03709() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffffe8l; AssertJUnit.assertEquals("multiply", result, 0xffffffdc00000018l); }
@Test
public void test03710() { x = 0x0000000180000000l; long result = x * 0xffffffffffffffe8l; AssertJUnit.assertEquals("multiply", result, 0xffffffdc00000000l); }
@Test
public void test03711() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffffe8l; AssertJUnit.assertEquals("multiply", result, 0xffffffd000000018l); }
@Test
public void test03712() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffffe8l; AssertJUnit.assertEquals("multiply", result, 0x0000000c00000018l); }
@Test
public void test03713() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffffe8l; AssertJUnit.assertEquals("multiply", result, 0x0000000c00000000l); }
@Test
public void test03714() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffffe8l; AssertJUnit.assertEquals("multiply", result, 0xffffffd31fb17ec8l); }
@Test
public void test03715() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffffe8l; AssertJUnit.assertEquals("multiply", result, 0x000000031fb17ec8l); }
@Test
public void test03716() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffffe8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000018l); }
@Test
public void test03717() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffffe8l; AssertJUnit.assertEquals("multiply", result, 0x0000000c00000018l); }
@Test
public void test03718() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffffe8l; AssertJUnit.assertEquals("multiply", result, 0x0000000c00000000l); }
@Test
public void test03719() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffffe8l; AssertJUnit.assertEquals("multiply", result, 0x000000031fb17ec8l); }
@Test
public void test03720() { x = 0x8000000000000000l; long result = x * 0xffffffffffffffe8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03721() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffffe8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000018l); }
@Test
public void test03722() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffffe8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000030l); }
@Test
public void test03723() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffffe8l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000018l); }
@Test
public void test03724() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffffe8l; AssertJUnit.assertEquals("multiply", result, 0x1fb17eb31fb17ec8l); }
@Test
public void test03725() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffff40l; AssertJUnit.assertEquals("multiply", result, 0xffffffa0000000c0l); }
@Test
public void test03726() { x = 0x0000000080000000l; long result = x * 0xffffffffffffff40l; AssertJUnit.assertEquals("multiply", result, 0xffffffa000000000l); }
@Test
public void test03727() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffff40l; AssertJUnit.assertEquals("multiply", result, 0xffffff40000000c0l); }
@Test
public void test03728() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffff40l; AssertJUnit.assertEquals("multiply", result, 0xfffffee0000000c0l); }
@Test
public void test03729() { x = 0x0000000180000000l; long result = x * 0xffffffffffffff40l; AssertJUnit.assertEquals("multiply", result, 0xfffffee000000000l); }
@Test
public void test03730() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffff40l; AssertJUnit.assertEquals("multiply", result, 0xfffffe80000000c0l); }
@Test
public void test03731() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffff40l; AssertJUnit.assertEquals("multiply", result, 0x00000060000000c0l); }
@Test
public void test03732() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffff40l; AssertJUnit.assertEquals("multiply", result, 0x0000006000000000l); }
@Test
public void test03733() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffff40l; AssertJUnit.assertEquals("multiply", result, 0xfffffe98fd8bf640l); }
@Test
public void test03734() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffff40l; AssertJUnit.assertEquals("multiply", result, 0x00000018fd8bf640l); }
@Test
public void test03735() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffff40l; AssertJUnit.assertEquals("multiply", result, 0x00000000000000c0l); }
@Test
public void test03736() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffff40l; AssertJUnit.assertEquals("multiply", result, 0x00000060000000c0l); }
@Test
public void test03737() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffff40l; AssertJUnit.assertEquals("multiply", result, 0x0000006000000000l); }
@Test
public void test03738() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffff40l; AssertJUnit.assertEquals("multiply", result, 0x00000018fd8bf640l); }
@Test
public void test03739() { x = 0x8000000000000000l; long result = x * 0xffffffffffffff40l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03740() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffff40l; AssertJUnit.assertEquals("multiply", result, 0x00000000000000c0l); }
@Test
public void test03741() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffff40l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000180l); }
@Test
public void test03742() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffff40l; AssertJUnit.assertEquals("multiply", result, 0x00000000000000c0l); }
@Test
public void test03743() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffff40l; AssertJUnit.assertEquals("multiply", result, 0xfd8bf598fd8bf640l); }
@Test
public void test03744() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffe800l; AssertJUnit.assertEquals("multiply", result, 0xfffff40000001800l); }
@Test
public void test03745() { x = 0x0000000080000000l; long result = x * 0xffffffffffffe800l; AssertJUnit.assertEquals("multiply", result, 0xfffff40000000000l); }
@Test
public void test03746() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffe800l; AssertJUnit.assertEquals("multiply", result, 0xffffe80000001800l); }
@Test
public void test03747() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffe800l; AssertJUnit.assertEquals("multiply", result, 0xffffdc0000001800l); }
@Test
public void test03748() { x = 0x0000000180000000l; long result = x * 0xffffffffffffe800l; AssertJUnit.assertEquals("multiply", result, 0xffffdc0000000000l); }
@Test
public void test03749() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffe800l; AssertJUnit.assertEquals("multiply", result, 0xffffd00000001800l); }
@Test
public void test03750() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffe800l; AssertJUnit.assertEquals("multiply", result, 0x00000c0000001800l); }
@Test
public void test03751() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffe800l; AssertJUnit.assertEquals("multiply", result, 0x00000c0000000000l); }
@Test
public void test03752() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffe800l; AssertJUnit.assertEquals("multiply", result, 0xffffd31fb17ec800l); }
@Test
public void test03753() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffe800l; AssertJUnit.assertEquals("multiply", result, 0x0000031fb17ec800l); }
@Test
public void test03754() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffe800l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001800l); }
@Test
public void test03755() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffe800l; AssertJUnit.assertEquals("multiply", result, 0x00000c0000001800l); }
@Test
public void test03756() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffe800l; AssertJUnit.assertEquals("multiply", result, 0x00000c0000000000l); }
@Test
public void test03757() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffe800l; AssertJUnit.assertEquals("multiply", result, 0x0000031fb17ec800l); }
@Test
public void test03758() { x = 0x8000000000000000l; long result = x * 0xffffffffffffe800l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03759() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffe800l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001800l); }
@Test
public void test03760() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffe800l; AssertJUnit.assertEquals("multiply", result, 0x0000000000003000l); }
@Test
public void test03761() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffe800l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001800l); }
@Test
public void test03762() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffe800l; AssertJUnit.assertEquals("multiply", result, 0xb17eb31fb17ec800l); }
@Test
public void test03763() { x = 0x000000007fffffffl; long result = x * 0xffffffe800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001800000000l); }
@Test
public void test03764() { x = 0x0000000080000000l; long result = x * 0xffffffe800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03765() { x = 0x00000000ffffffffl; long result = x * 0xffffffe800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001800000000l); }
@Test
public void test03766() { x = 0x000000017fffffffl; long result = x * 0xffffffe800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001800000000l); }
@Test
public void test03767() { x = 0x0000000180000000l; long result = x * 0xffffffe800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03768() { x = 0x00000001ffffffffl; long result = x * 0xffffffe800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001800000000l); }
@Test
public void test03769() { x = 0xffffffff7fffffffl; long result = x * 0xffffffe800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001800000000l); }
@Test
public void test03770() { x = 0xffffffff80000000l; long result = x * 0xffffffe800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03771() { x = 0x00000001deadf00dl; long result = x * 0xffffffe800000000l; AssertJUnit.assertEquals("multiply", result, 0x1fb17ec800000000l); }
@Test
public void test03772() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffe800000000l; AssertJUnit.assertEquals("multiply", result, 0x1fb17ec800000000l); }
@Test
public void test03773() { x = 0x7fffffffffffffffl; long result = x * 0xffffffe800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001800000000l); }
@Test
public void test03774() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffe800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001800000000l); }
@Test
public void test03775() { x = 0x7fffffff80000000l; long result = x * 0xffffffe800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03776() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffe800000000l; AssertJUnit.assertEquals("multiply", result, 0x1fb17ec800000000l); }
@Test
public void test03777() { x = 0x8000000000000000l; long result = x * 0xffffffe800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03778() { x = 0xffffffffffffffffl; long result = x * 0xffffffe800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001800000000l); }
@Test
public void test03779() { x = 0xfffffffffffffffel; long result = x * 0xffffffe800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000003000000000l); }
@Test
public void test03780() { x = 0xefffffffffffffffl; long result = x * 0xffffffe800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001800000000l); }
@Test
public void test03781() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffe800000000l; AssertJUnit.assertEquals("multiply", result, 0x1fb17ec800000000l); }
@Test
public void test03782() { x = 0x000000007fffffffl; long result = x * 0xffffff4000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000c000000000l); }
@Test
public void test03783() { x = 0x0000000080000000l; long result = x * 0xffffff4000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03784() { x = 0x00000000ffffffffl; long result = x * 0xffffff4000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000c000000000l); }
@Test
public void test03785() { x = 0x000000017fffffffl; long result = x * 0xffffff4000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000c000000000l); }
@Test
public void test03786() { x = 0x0000000180000000l; long result = x * 0xffffff4000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03787() { x = 0x00000001ffffffffl; long result = x * 0xffffff4000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000c000000000l); }
@Test
public void test03788() { x = 0xffffffff7fffffffl; long result = x * 0xffffff4000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000c000000000l); }
@Test
public void test03789() { x = 0xffffffff80000000l; long result = x * 0xffffff4000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03790() { x = 0x00000001deadf00dl; long result = x * 0xffffff4000000000l; AssertJUnit.assertEquals("multiply", result, 0xfd8bf64000000000l); }
@Test
public void test03791() { x = 0xffffffffdeadf00dl; long result = x * 0xffffff4000000000l; AssertJUnit.assertEquals("multiply", result, 0xfd8bf64000000000l); }
@Test
public void test03792() { x = 0x7fffffffffffffffl; long result = x * 0xffffff4000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000c000000000l); }
@Test
public void test03793() { x = 0x7fffffff7fffffffl; long result = x * 0xffffff4000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000c000000000l); }
@Test
public void test03794() { x = 0x7fffffff80000000l; long result = x * 0xffffff4000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03795() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffff4000000000l; AssertJUnit.assertEquals("multiply", result, 0xfd8bf64000000000l); }
@Test
public void test03796() { x = 0x8000000000000000l; long result = x * 0xffffff4000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03797() { x = 0xffffffffffffffffl; long result = x * 0xffffff4000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000c000000000l); }
@Test
public void test03798() { x = 0xfffffffffffffffel; long result = x * 0xffffff4000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000018000000000l); }
@Test
public void test03799() { x = 0xefffffffffffffffl; long result = x * 0xffffff4000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000c000000000l); }
@Test
public void test03800() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffff4000000000l; AssertJUnit.assertEquals("multiply", result, 0xfd8bf64000000000l); }
@Test
public void test03801() { x = 0x000000007fffffffl; long result = x * 0x19l; AssertJUnit.assertEquals("multiply", result, 0x0000000c7fffffe7l); }
@Test
public void test03802() { x = 0x0000000080000000l; long result = x * 0x19l; AssertJUnit.assertEquals("multiply", result, 0x0000000c80000000l); }
@Test
public void test03803() { x = 0x00000000ffffffffl; long result = x * 0x19l; AssertJUnit.assertEquals("multiply", result, 0x00000018ffffffe7l); }
@Test
public void test03804() { x = 0x000000017fffffffl; long result = x * 0x19l; AssertJUnit.assertEquals("multiply", result, 0x000000257fffffe7l); }
@Test
public void test03805() { x = 0x0000000180000000l; long result = x * 0x19l; AssertJUnit.assertEquals("multiply", result, 0x0000002580000000l); }
@Test
public void test03806() { x = 0x00000001ffffffffl; long result = x * 0x19l; AssertJUnit.assertEquals("multiply", result, 0x00000031ffffffe7l); }
@Test
public void test03807() { x = 0xffffffff7fffffffl; long result = x * 0x19l; AssertJUnit.assertEquals("multiply", result, 0xfffffff37fffffe7l); }
@Test
public void test03808() { x = 0xffffffff80000000l; long result = x * 0x19l; AssertJUnit.assertEquals("multiply", result, 0xfffffff380000000l); }
@Test
public void test03809() { x = 0x00000001deadf00dl; long result = x * 0x19l; AssertJUnit.assertEquals("multiply", result, 0x0000002ebefc7145l); }
@Test
public void test03810() { x = 0xffffffffdeadf00dl; long result = x * 0x19l; AssertJUnit.assertEquals("multiply", result, 0xfffffffcbefc7145l); }
@Test
public void test03811() { x = 0x7fffffffffffffffl; long result = x * 0x19l; AssertJUnit.assertEquals("multiply", result, 0x7fffffffffffffe7l); }
@Test
public void test03812() { x = 0x7fffffff7fffffffl; long result = x * 0x19l; AssertJUnit.assertEquals("multiply", result, 0x7ffffff37fffffe7l); }
@Test
public void test03813() { x = 0x7fffffff80000000l; long result = x * 0x19l; AssertJUnit.assertEquals("multiply", result, 0x7ffffff380000000l); }
@Test
public void test03814() { x = 0x7fffffffdeadf00dl; long result = x * 0x19l; AssertJUnit.assertEquals("multiply", result, 0x7ffffffcbefc7145l); }
@Test
public void test03815() { x = 0x8000000000000000l; long result = x * 0x19l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test03816() { x = 0xffffffffffffffffl; long result = x * 0x19l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffe7l); }
@Test
public void test03817() { x = 0xfffffffffffffffel; long result = x * 0x19l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffcel); }
@Test
public void test03818() { x = 0xefffffffffffffffl; long result = x * 0x19l; AssertJUnit.assertEquals("multiply", result, 0x6fffffffffffffe7l); }
@Test
public void test03819() { x = 0xdeadf00ddeadf00dl; long result = x * 0x19l; AssertJUnit.assertEquals("multiply", result, 0xbefc715abefc7145l); }
@Test
public void test03820() { x = 0x000000007fffffffl; long result = x * 0xc8l; AssertJUnit.assertEquals("multiply", result, 0x00000063ffffff38l); }
@Test
public void test03821() { x = 0x0000000080000000l; long result = x * 0xc8l; AssertJUnit.assertEquals("multiply", result, 0x0000006400000000l); }
@Test
public void test03822() { x = 0x00000000ffffffffl; long result = x * 0xc8l; AssertJUnit.assertEquals("multiply", result, 0x000000c7ffffff38l); }
@Test
public void test03823() { x = 0x000000017fffffffl; long result = x * 0xc8l; AssertJUnit.assertEquals("multiply", result, 0x0000012bffffff38l); }
@Test
public void test03824() { x = 0x0000000180000000l; long result = x * 0xc8l; AssertJUnit.assertEquals("multiply", result, 0x0000012c00000000l); }
@Test
public void test03825() { x = 0x00000001ffffffffl; long result = x * 0xc8l; AssertJUnit.assertEquals("multiply", result, 0x0000018fffffff38l); }
@Test
public void test03826() { x = 0xffffffff7fffffffl; long result = x * 0xc8l; AssertJUnit.assertEquals("multiply", result, 0xffffff9bffffff38l); }
@Test
public void test03827() { x = 0xffffffff80000000l; long result = x * 0xc8l; AssertJUnit.assertEquals("multiply", result, 0xffffff9c00000000l); }
@Test
public void test03828() { x = 0x00000001deadf00dl; long result = x * 0xc8l; AssertJUnit.assertEquals("multiply", result, 0x00000175f7e38a28l); }
@Test
public void test03829() { x = 0xffffffffdeadf00dl; long result = x * 0xc8l; AssertJUnit.assertEquals("multiply", result, 0xffffffe5f7e38a28l); }
@Test
public void test03830() { x = 0x7fffffffffffffffl; long result = x * 0xc8l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff38l); }
@Test
public void test03831() { x = 0x7fffffff7fffffffl; long result = x * 0xc8l; AssertJUnit.assertEquals("multiply", result, 0xffffff9bffffff38l); }
@Test
public void test03832() { x = 0x7fffffff80000000l; long result = x * 0xc8l; AssertJUnit.assertEquals("multiply", result, 0xffffff9c00000000l); }
@Test
public void test03833() { x = 0x7fffffffdeadf00dl; long result = x * 0xc8l; AssertJUnit.assertEquals("multiply", result, 0xffffffe5f7e38a28l); }
@Test
public void test03834() { x = 0x8000000000000000l; long result = x * 0xc8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03835() { x = 0xffffffffffffffffl; long result = x * 0xc8l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff38l); }
@Test
public void test03836() { x = 0xfffffffffffffffel; long result = x * 0xc8l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffe70l); }
@Test
public void test03837() { x = 0xefffffffffffffffl; long result = x * 0xc8l; AssertJUnit.assertEquals("multiply", result, 0x7fffffffffffff38l); }
@Test
public void test03838() { x = 0xdeadf00ddeadf00dl; long result = x * 0xc8l; AssertJUnit.assertEquals("multiply", result, 0xf7e38ad5f7e38a28l); }
@Test
public void test03839() { x = 0x000000007fffffffl; long result = x * 0x1900l; AssertJUnit.assertEquals("multiply", result, 0x00000c7fffffe700l); }
@Test
public void test03840() { x = 0x0000000080000000l; long result = x * 0x1900l; AssertJUnit.assertEquals("multiply", result, 0x00000c8000000000l); }
@Test
public void test03841() { x = 0x00000000ffffffffl; long result = x * 0x1900l; AssertJUnit.assertEquals("multiply", result, 0x000018ffffffe700l); }
@Test
public void test03842() { x = 0x000000017fffffffl; long result = x * 0x1900l; AssertJUnit.assertEquals("multiply", result, 0x0000257fffffe700l); }
@Test
public void test03843() { x = 0x0000000180000000l; long result = x * 0x1900l; AssertJUnit.assertEquals("multiply", result, 0x0000258000000000l); }
@Test
public void test03844() { x = 0x00000001ffffffffl; long result = x * 0x1900l; AssertJUnit.assertEquals("multiply", result, 0x000031ffffffe700l); }
@Test
public void test03845() { x = 0xffffffff7fffffffl; long result = x * 0x1900l; AssertJUnit.assertEquals("multiply", result, 0xfffff37fffffe700l); }
@Test
public void test03846() { x = 0xffffffff80000000l; long result = x * 0x1900l; AssertJUnit.assertEquals("multiply", result, 0xfffff38000000000l); }
@Test
public void test03847() { x = 0x00000001deadf00dl; long result = x * 0x1900l; AssertJUnit.assertEquals("multiply", result, 0x00002ebefc714500l); }
@Test
public void test03848() { x = 0xffffffffdeadf00dl; long result = x * 0x1900l; AssertJUnit.assertEquals("multiply", result, 0xfffffcbefc714500l); }
@Test
public void test03849() { x = 0x7fffffffffffffffl; long result = x * 0x1900l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffe700l); }
@Test
public void test03850() { x = 0x7fffffff7fffffffl; long result = x * 0x1900l; AssertJUnit.assertEquals("multiply", result, 0xfffff37fffffe700l); }
@Test
public void test03851() { x = 0x7fffffff80000000l; long result = x * 0x1900l; AssertJUnit.assertEquals("multiply", result, 0xfffff38000000000l); }
@Test
public void test03852() { x = 0x7fffffffdeadf00dl; long result = x * 0x1900l; AssertJUnit.assertEquals("multiply", result, 0xfffffcbefc714500l); }
@Test
public void test03853() { x = 0x8000000000000000l; long result = x * 0x1900l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03854() { x = 0xffffffffffffffffl; long result = x * 0x1900l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffe700l); }
@Test
public void test03855() { x = 0xfffffffffffffffel; long result = x * 0x1900l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffce00l); }
@Test
public void test03856() { x = 0xefffffffffffffffl; long result = x * 0x1900l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffe700l); }
@Test
public void test03857() { x = 0xdeadf00ddeadf00dl; long result = x * 0x1900l; AssertJUnit.assertEquals("multiply", result, 0xfc715abefc714500l); }
@Test
public void test03858() { x = 0x000000007fffffffl; long result = x * 0x1900000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffe700000000l); }
@Test
public void test03859() { x = 0x0000000080000000l; long result = x * 0x1900000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test03860() { x = 0x00000000ffffffffl; long result = x * 0x1900000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe700000000l); }
@Test
public void test03861() { x = 0x000000017fffffffl; long result = x * 0x1900000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffe700000000l); }
@Test
public void test03862() { x = 0x0000000180000000l; long result = x * 0x1900000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test03863() { x = 0x00000001ffffffffl; long result = x * 0x1900000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe700000000l); }
@Test
public void test03864() { x = 0xffffffff7fffffffl; long result = x * 0x1900000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffe700000000l); }
@Test
public void test03865() { x = 0xffffffff80000000l; long result = x * 0x1900000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test03866() { x = 0x00000001deadf00dl; long result = x * 0x1900000000l; AssertJUnit.assertEquals("multiply", result, 0xbefc714500000000l); }
@Test
public void test03867() { x = 0xffffffffdeadf00dl; long result = x * 0x1900000000l; AssertJUnit.assertEquals("multiply", result, 0xbefc714500000000l); }
@Test
public void test03868() { x = 0x7fffffffffffffffl; long result = x * 0x1900000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe700000000l); }
@Test
public void test03869() { x = 0x7fffffff7fffffffl; long result = x * 0x1900000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffe700000000l); }
@Test
public void test03870() { x = 0x7fffffff80000000l; long result = x * 0x1900000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test03871() { x = 0x7fffffffdeadf00dl; long result = x * 0x1900000000l; AssertJUnit.assertEquals("multiply", result, 0xbefc714500000000l); }
@Test
public void test03872() { x = 0x8000000000000000l; long result = x * 0x1900000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03873() { x = 0xffffffffffffffffl; long result = x * 0x1900000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe700000000l); }
@Test
public void test03874() { x = 0xfffffffffffffffel; long result = x * 0x1900000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffce00000000l); }
@Test
public void test03875() { x = 0xefffffffffffffffl; long result = x * 0x1900000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe700000000l); }
@Test
public void test03876() { x = 0xdeadf00ddeadf00dl; long result = x * 0x1900000000l; AssertJUnit.assertEquals("multiply", result, 0xbefc714500000000l); }
@Test
public void test03877() { x = 0x000000007fffffffl; long result = x * 0xc800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff3800000000l); }
@Test
public void test03878() { x = 0x0000000080000000l; long result = x * 0xc800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03879() { x = 0x00000000ffffffffl; long result = x * 0xc800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff3800000000l); }
@Test
public void test03880() { x = 0x000000017fffffffl; long result = x * 0xc800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff3800000000l); }
@Test
public void test03881() { x = 0x0000000180000000l; long result = x * 0xc800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03882() { x = 0x00000001ffffffffl; long result = x * 0xc800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff3800000000l); }
@Test
public void test03883() { x = 0xffffffff7fffffffl; long result = x * 0xc800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff3800000000l); }
@Test
public void test03884() { x = 0xffffffff80000000l; long result = x * 0xc800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03885() { x = 0x00000001deadf00dl; long result = x * 0xc800000000l; AssertJUnit.assertEquals("multiply", result, 0xf7e38a2800000000l); }
@Test
public void test03886() { x = 0xffffffffdeadf00dl; long result = x * 0xc800000000l; AssertJUnit.assertEquals("multiply", result, 0xf7e38a2800000000l); }
@Test
public void test03887() { x = 0x7fffffffffffffffl; long result = x * 0xc800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff3800000000l); }
@Test
public void test03888() { x = 0x7fffffff7fffffffl; long result = x * 0xc800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff3800000000l); }
@Test
public void test03889() { x = 0x7fffffff80000000l; long result = x * 0xc800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03890() { x = 0x7fffffffdeadf00dl; long result = x * 0xc800000000l; AssertJUnit.assertEquals("multiply", result, 0xf7e38a2800000000l); }
@Test
public void test03891() { x = 0x8000000000000000l; long result = x * 0xc800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03892() { x = 0xffffffffffffffffl; long result = x * 0xc800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff3800000000l); }
@Test
public void test03893() { x = 0xfffffffffffffffel; long result = x * 0xc800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffe7000000000l); }
@Test
public void test03894() { x = 0xefffffffffffffffl; long result = x * 0xc800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff3800000000l); }
@Test
public void test03895() { x = 0xdeadf00ddeadf00dl; long result = x * 0xc800000000l; AssertJUnit.assertEquals("multiply", result, 0xf7e38a2800000000l); }
@Test
public void test03896() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffffe7l; AssertJUnit.assertEquals("multiply", result, 0xfffffff380000019l); }
@Test
public void test03897() { x = 0x0000000080000000l; long result = x * 0xffffffffffffffe7l; AssertJUnit.assertEquals("multiply", result, 0xfffffff380000000l); }
@Test
public void test03898() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffffe7l; AssertJUnit.assertEquals("multiply", result, 0xffffffe700000019l); }
@Test
public void test03899() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffffe7l; AssertJUnit.assertEquals("multiply", result, 0xffffffda80000019l); }
@Test
public void test03900() { x = 0x0000000180000000l; long result = x * 0xffffffffffffffe7l; AssertJUnit.assertEquals("multiply", result, 0xffffffda80000000l); }
@Test
public void test03901() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffffe7l; AssertJUnit.assertEquals("multiply", result, 0xffffffce00000019l); }
@Test
public void test03902() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffffe7l; AssertJUnit.assertEquals("multiply", result, 0x0000000c80000019l); }
@Test
public void test03903() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffffe7l; AssertJUnit.assertEquals("multiply", result, 0x0000000c80000000l); }
@Test
public void test03904() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffffe7l; AssertJUnit.assertEquals("multiply", result, 0xffffffd141038ebbl); }
@Test
public void test03905() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffffe7l; AssertJUnit.assertEquals("multiply", result, 0x0000000341038ebbl); }
@Test
public void test03906() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffffe7l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000019l); }
@Test
public void test03907() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffffe7l; AssertJUnit.assertEquals("multiply", result, 0x8000000c80000019l); }
@Test
public void test03908() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffffe7l; AssertJUnit.assertEquals("multiply", result, 0x8000000c80000000l); }
@Test
public void test03909() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffffe7l; AssertJUnit.assertEquals("multiply", result, 0x8000000341038ebbl); }
@Test
public void test03910() { x = 0x8000000000000000l; long result = x * 0xffffffffffffffe7l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test03911() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffffe7l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000019l); }
@Test
public void test03912() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffffe7l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000032l); }
@Test
public void test03913() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffffe7l; AssertJUnit.assertEquals("multiply", result, 0x9000000000000019l); }
@Test
public void test03914() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffffe7l; AssertJUnit.assertEquals("multiply", result, 0x41038ea541038ebbl); }
@Test
public void test03915() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffff38l; AssertJUnit.assertEquals("multiply", result, 0xffffff9c000000c8l); }
@Test
public void test03916() { x = 0x0000000080000000l; long result = x * 0xffffffffffffff38l; AssertJUnit.assertEquals("multiply", result, 0xffffff9c00000000l); }
@Test
public void test03917() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffff38l; AssertJUnit.assertEquals("multiply", result, 0xffffff38000000c8l); }
@Test
public void test03918() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffff38l; AssertJUnit.assertEquals("multiply", result, 0xfffffed4000000c8l); }
@Test
public void test03919() { x = 0x0000000180000000l; long result = x * 0xffffffffffffff38l; AssertJUnit.assertEquals("multiply", result, 0xfffffed400000000l); }
@Test
public void test03920() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffff38l; AssertJUnit.assertEquals("multiply", result, 0xfffffe70000000c8l); }
@Test
public void test03921() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffff38l; AssertJUnit.assertEquals("multiply", result, 0x00000064000000c8l); }
@Test
public void test03922() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffff38l; AssertJUnit.assertEquals("multiply", result, 0x0000006400000000l); }
@Test
public void test03923() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffff38l; AssertJUnit.assertEquals("multiply", result, 0xfffffe8a081c75d8l); }
@Test
public void test03924() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffff38l; AssertJUnit.assertEquals("multiply", result, 0x0000001a081c75d8l); }
@Test
public void test03925() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffff38l; AssertJUnit.assertEquals("multiply", result, 0x00000000000000c8l); }
@Test
public void test03926() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffff38l; AssertJUnit.assertEquals("multiply", result, 0x00000064000000c8l); }
@Test
public void test03927() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffff38l; AssertJUnit.assertEquals("multiply", result, 0x0000006400000000l); }
@Test
public void test03928() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffff38l; AssertJUnit.assertEquals("multiply", result, 0x0000001a081c75d8l); }
@Test
public void test03929() { x = 0x8000000000000000l; long result = x * 0xffffffffffffff38l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03930() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffff38l; AssertJUnit.assertEquals("multiply", result, 0x00000000000000c8l); }
@Test
public void test03931() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffff38l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000190l); }
@Test
public void test03932() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffff38l; AssertJUnit.assertEquals("multiply", result, 0x80000000000000c8l); }
@Test
public void test03933() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffff38l; AssertJUnit.assertEquals("multiply", result, 0x081c752a081c75d8l); }
@Test
public void test03934() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffe700l; AssertJUnit.assertEquals("multiply", result, 0xfffff38000001900l); }
@Test
public void test03935() { x = 0x0000000080000000l; long result = x * 0xffffffffffffe700l; AssertJUnit.assertEquals("multiply", result, 0xfffff38000000000l); }
@Test
public void test03936() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffe700l; AssertJUnit.assertEquals("multiply", result, 0xffffe70000001900l); }
@Test
public void test03937() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffe700l; AssertJUnit.assertEquals("multiply", result, 0xffffda8000001900l); }
@Test
public void test03938() { x = 0x0000000180000000l; long result = x * 0xffffffffffffe700l; AssertJUnit.assertEquals("multiply", result, 0xffffda8000000000l); }
@Test
public void test03939() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffe700l; AssertJUnit.assertEquals("multiply", result, 0xffffce0000001900l); }
@Test
public void test03940() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffe700l; AssertJUnit.assertEquals("multiply", result, 0x00000c8000001900l); }
@Test
public void test03941() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffe700l; AssertJUnit.assertEquals("multiply", result, 0x00000c8000000000l); }
@Test
public void test03942() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffe700l; AssertJUnit.assertEquals("multiply", result, 0xffffd141038ebb00l); }
@Test
public void test03943() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffe700l; AssertJUnit.assertEquals("multiply", result, 0x00000341038ebb00l); }
@Test
public void test03944() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffe700l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001900l); }
@Test
public void test03945() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffe700l; AssertJUnit.assertEquals("multiply", result, 0x00000c8000001900l); }
@Test
public void test03946() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffe700l; AssertJUnit.assertEquals("multiply", result, 0x00000c8000000000l); }
@Test
public void test03947() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffe700l; AssertJUnit.assertEquals("multiply", result, 0x00000341038ebb00l); }
@Test
public void test03948() { x = 0x8000000000000000l; long result = x * 0xffffffffffffe700l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03949() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffe700l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001900l); }
@Test
public void test03950() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffe700l; AssertJUnit.assertEquals("multiply", result, 0x0000000000003200l); }
@Test
public void test03951() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffe700l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001900l); }
@Test
public void test03952() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffe700l; AssertJUnit.assertEquals("multiply", result, 0x038ea541038ebb00l); }
@Test
public void test03953() { x = 0x000000007fffffffl; long result = x * 0xffffffe700000000l; AssertJUnit.assertEquals("multiply", result, 0x8000001900000000l); }
@Test
public void test03954() { x = 0x0000000080000000l; long result = x * 0xffffffe700000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test03955() { x = 0x00000000ffffffffl; long result = x * 0xffffffe700000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001900000000l); }
@Test
public void test03956() { x = 0x000000017fffffffl; long result = x * 0xffffffe700000000l; AssertJUnit.assertEquals("multiply", result, 0x8000001900000000l); }
@Test
public void test03957() { x = 0x0000000180000000l; long result = x * 0xffffffe700000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test03958() { x = 0x00000001ffffffffl; long result = x * 0xffffffe700000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001900000000l); }
@Test
public void test03959() { x = 0xffffffff7fffffffl; long result = x * 0xffffffe700000000l; AssertJUnit.assertEquals("multiply", result, 0x8000001900000000l); }
@Test
public void test03960() { x = 0xffffffff80000000l; long result = x * 0xffffffe700000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test03961() { x = 0x00000001deadf00dl; long result = x * 0xffffffe700000000l; AssertJUnit.assertEquals("multiply", result, 0x41038ebb00000000l); }
@Test
public void test03962() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffe700000000l; AssertJUnit.assertEquals("multiply", result, 0x41038ebb00000000l); }
@Test
public void test03963() { x = 0x7fffffffffffffffl; long result = x * 0xffffffe700000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001900000000l); }
@Test
public void test03964() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffe700000000l; AssertJUnit.assertEquals("multiply", result, 0x8000001900000000l); }
@Test
public void test03965() { x = 0x7fffffff80000000l; long result = x * 0xffffffe700000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test03966() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffe700000000l; AssertJUnit.assertEquals("multiply", result, 0x41038ebb00000000l); }
@Test
public void test03967() { x = 0x8000000000000000l; long result = x * 0xffffffe700000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03968() { x = 0xffffffffffffffffl; long result = x * 0xffffffe700000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001900000000l); }
@Test
public void test03969() { x = 0xfffffffffffffffel; long result = x * 0xffffffe700000000l; AssertJUnit.assertEquals("multiply", result, 0x0000003200000000l); }
@Test
public void test03970() { x = 0xefffffffffffffffl; long result = x * 0xffffffe700000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001900000000l); }
@Test
public void test03971() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffe700000000l; AssertJUnit.assertEquals("multiply", result, 0x41038ebb00000000l); }
@Test
public void test03972() { x = 0x000000007fffffffl; long result = x * 0xffffff3800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000c800000000l); }
@Test
public void test03973() { x = 0x0000000080000000l; long result = x * 0xffffff3800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03974() { x = 0x00000000ffffffffl; long result = x * 0xffffff3800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000c800000000l); }
@Test
public void test03975() { x = 0x000000017fffffffl; long result = x * 0xffffff3800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000c800000000l); }
@Test
public void test03976() { x = 0x0000000180000000l; long result = x * 0xffffff3800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03977() { x = 0x00000001ffffffffl; long result = x * 0xffffff3800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000c800000000l); }
@Test
public void test03978() { x = 0xffffffff7fffffffl; long result = x * 0xffffff3800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000c800000000l); }
@Test
public void test03979() { x = 0xffffffff80000000l; long result = x * 0xffffff3800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03980() { x = 0x00000001deadf00dl; long result = x * 0xffffff3800000000l; AssertJUnit.assertEquals("multiply", result, 0x081c75d800000000l); }
@Test
public void test03981() { x = 0xffffffffdeadf00dl; long result = x * 0xffffff3800000000l; AssertJUnit.assertEquals("multiply", result, 0x081c75d800000000l); }
@Test
public void test03982() { x = 0x7fffffffffffffffl; long result = x * 0xffffff3800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000c800000000l); }
@Test
public void test03983() { x = 0x7fffffff7fffffffl; long result = x * 0xffffff3800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000c800000000l); }
@Test
public void test03984() { x = 0x7fffffff80000000l; long result = x * 0xffffff3800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03985() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffff3800000000l; AssertJUnit.assertEquals("multiply", result, 0x081c75d800000000l); }
@Test
public void test03986() { x = 0x8000000000000000l; long result = x * 0xffffff3800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test03987() { x = 0xffffffffffffffffl; long result = x * 0xffffff3800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000c800000000l); }
@Test
public void test03988() { x = 0xfffffffffffffffel; long result = x * 0xffffff3800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000019000000000l); }
@Test
public void test03989() { x = 0xefffffffffffffffl; long result = x * 0xffffff3800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000c800000000l); }
@Test
public void test03990() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffff3800000000l; AssertJUnit.assertEquals("multiply", result, 0x081c75d800000000l); }
@Test
public void test03991() { x = 0x000000007fffffffl; long result = x * 0x1al; AssertJUnit.assertEquals("multiply", result, 0x0000000cffffffe6l); }
@Test
public void test03992() { x = 0x0000000080000000l; long result = x * 0x1al; AssertJUnit.assertEquals("multiply", result, 0x0000000d00000000l); }
@Test
public void test03993() { x = 0x00000000ffffffffl; long result = x * 0x1al; AssertJUnit.assertEquals("multiply", result, 0x00000019ffffffe6l); }
@Test
public void test03994() { x = 0x000000017fffffffl; long result = x * 0x1al; AssertJUnit.assertEquals("multiply", result, 0x00000026ffffffe6l); }
@Test
public void test03995() { x = 0x0000000180000000l; long result = x * 0x1al; AssertJUnit.assertEquals("multiply", result, 0x0000002700000000l); }
@Test
public void test03996() { x = 0x00000001ffffffffl; long result = x * 0x1al; AssertJUnit.assertEquals("multiply", result, 0x00000033ffffffe6l); }
@Test
public void test03997() { x = 0xffffffff7fffffffl; long result = x * 0x1al; AssertJUnit.assertEquals("multiply", result, 0xfffffff2ffffffe6l); }
@Test
public void test03998() { x = 0xffffffff80000000l; long result = x * 0x1al; AssertJUnit.assertEquals("multiply", result, 0xfffffff300000000l); }
@Test
public void test03999() { x = 0x00000001deadf00dl; long result = x * 0x1al; AssertJUnit.assertEquals("multiply", result, 0x000000309daa6152l); }
@Test
public void test04000() { x = 0xffffffffdeadf00dl; long result = x * 0x1al; AssertJUnit.assertEquals("multiply", result, 0xfffffffc9daa6152l); }
@Test
public void test04001() { x = 0x7fffffffffffffffl; long result = x * 0x1al; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffe6l); }
@Test
public void test04002() { x = 0x7fffffff7fffffffl; long result = x * 0x1al; AssertJUnit.assertEquals("multiply", result, 0xfffffff2ffffffe6l); }
@Test
public void test04003() { x = 0x7fffffff80000000l; long result = x * 0x1al; AssertJUnit.assertEquals("multiply", result, 0xfffffff300000000l); }
@Test
public void test04004() { x = 0x7fffffffdeadf00dl; long result = x * 0x1al; AssertJUnit.assertEquals("multiply", result, 0xfffffffc9daa6152l); }
@Test
public void test04005() { x = 0x8000000000000000l; long result = x * 0x1al; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04006() { x = 0xffffffffffffffffl; long result = x * 0x1al; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffe6l); }
@Test
public void test04007() { x = 0xfffffffffffffffel; long result = x * 0x1al; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffccl); }
@Test
public void test04008() { x = 0xefffffffffffffffl; long result = x * 0x1al; AssertJUnit.assertEquals("multiply", result, 0x5fffffffffffffe6l); }
@Test
public void test04009() { x = 0xdeadf00ddeadf00dl; long result = x * 0x1al; AssertJUnit.assertEquals("multiply", result, 0x9daa61689daa6152l); }
@Test
public void test04010() { x = 0x000000007fffffffl; long result = x * 0xd0l; AssertJUnit.assertEquals("multiply", result, 0x00000067ffffff30l); }
@Test
public void test04011() { x = 0x0000000080000000l; long result = x * 0xd0l; AssertJUnit.assertEquals("multiply", result, 0x0000006800000000l); }
@Test
public void test04012() { x = 0x00000000ffffffffl; long result = x * 0xd0l; AssertJUnit.assertEquals("multiply", result, 0x000000cfffffff30l); }
@Test
public void test04013() { x = 0x000000017fffffffl; long result = x * 0xd0l; AssertJUnit.assertEquals("multiply", result, 0x00000137ffffff30l); }
@Test
public void test04014() { x = 0x0000000180000000l; long result = x * 0xd0l; AssertJUnit.assertEquals("multiply", result, 0x0000013800000000l); }
@Test
public void test04015() { x = 0x00000001ffffffffl; long result = x * 0xd0l; AssertJUnit.assertEquals("multiply", result, 0x0000019fffffff30l); }
@Test
public void test04016() { x = 0xffffffff7fffffffl; long result = x * 0xd0l; AssertJUnit.assertEquals("multiply", result, 0xffffff97ffffff30l); }
@Test
public void test04017() { x = 0xffffffff80000000l; long result = x * 0xd0l; AssertJUnit.assertEquals("multiply", result, 0xffffff9800000000l); }
@Test
public void test04018() { x = 0x00000001deadf00dl; long result = x * 0xd0l; AssertJUnit.assertEquals("multiply", result, 0x00000184ed530a90l); }
@Test
public void test04019() { x = 0xffffffffdeadf00dl; long result = x * 0xd0l; AssertJUnit.assertEquals("multiply", result, 0xffffffe4ed530a90l); }
@Test
public void test04020() { x = 0x7fffffffffffffffl; long result = x * 0xd0l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff30l); }
@Test
public void test04021() { x = 0x7fffffff7fffffffl; long result = x * 0xd0l; AssertJUnit.assertEquals("multiply", result, 0xffffff97ffffff30l); }
@Test
public void test04022() { x = 0x7fffffff80000000l; long result = x * 0xd0l; AssertJUnit.assertEquals("multiply", result, 0xffffff9800000000l); }
@Test
public void test04023() { x = 0x7fffffffdeadf00dl; long result = x * 0xd0l; AssertJUnit.assertEquals("multiply", result, 0xffffffe4ed530a90l); }
@Test
public void test04024() { x = 0x8000000000000000l; long result = x * 0xd0l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04025() { x = 0xffffffffffffffffl; long result = x * 0xd0l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff30l); }
@Test
public void test04026() { x = 0xfffffffffffffffel; long result = x * 0xd0l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffe60l); }
@Test
public void test04027() { x = 0xefffffffffffffffl; long result = x * 0xd0l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff30l); }
@Test
public void test04028() { x = 0xdeadf00ddeadf00dl; long result = x * 0xd0l; AssertJUnit.assertEquals("multiply", result, 0xed530b44ed530a90l); }
@Test
public void test04029() { x = 0x000000007fffffffl; long result = x * 0x1a00l; AssertJUnit.assertEquals("multiply", result, 0x00000cffffffe600l); }
@Test
public void test04030() { x = 0x0000000080000000l; long result = x * 0x1a00l; AssertJUnit.assertEquals("multiply", result, 0x00000d0000000000l); }
@Test
public void test04031() { x = 0x00000000ffffffffl; long result = x * 0x1a00l; AssertJUnit.assertEquals("multiply", result, 0x000019ffffffe600l); }
@Test
public void test04032() { x = 0x000000017fffffffl; long result = x * 0x1a00l; AssertJUnit.assertEquals("multiply", result, 0x000026ffffffe600l); }
@Test
public void test04033() { x = 0x0000000180000000l; long result = x * 0x1a00l; AssertJUnit.assertEquals("multiply", result, 0x0000270000000000l); }
@Test
public void test04034() { x = 0x00000001ffffffffl; long result = x * 0x1a00l; AssertJUnit.assertEquals("multiply", result, 0x000033ffffffe600l); }
@Test
public void test04035() { x = 0xffffffff7fffffffl; long result = x * 0x1a00l; AssertJUnit.assertEquals("multiply", result, 0xfffff2ffffffe600l); }
@Test
public void test04036() { x = 0xffffffff80000000l; long result = x * 0x1a00l; AssertJUnit.assertEquals("multiply", result, 0xfffff30000000000l); }
@Test
public void test04037() { x = 0x00000001deadf00dl; long result = x * 0x1a00l; AssertJUnit.assertEquals("multiply", result, 0x0000309daa615200l); }
@Test
public void test04038() { x = 0xffffffffdeadf00dl; long result = x * 0x1a00l; AssertJUnit.assertEquals("multiply", result, 0xfffffc9daa615200l); }
@Test
public void test04039() { x = 0x7fffffffffffffffl; long result = x * 0x1a00l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffe600l); }
@Test
public void test04040() { x = 0x7fffffff7fffffffl; long result = x * 0x1a00l; AssertJUnit.assertEquals("multiply", result, 0xfffff2ffffffe600l); }
@Test
public void test04041() { x = 0x7fffffff80000000l; long result = x * 0x1a00l; AssertJUnit.assertEquals("multiply", result, 0xfffff30000000000l); }
@Test
public void test04042() { x = 0x7fffffffdeadf00dl; long result = x * 0x1a00l; AssertJUnit.assertEquals("multiply", result, 0xfffffc9daa615200l); }
@Test
public void test04043() { x = 0x8000000000000000l; long result = x * 0x1a00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04044() { x = 0xffffffffffffffffl; long result = x * 0x1a00l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffe600l); }
@Test
public void test04045() { x = 0xfffffffffffffffel; long result = x * 0x1a00l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffcc00l); }
@Test
public void test04046() { x = 0xefffffffffffffffl; long result = x * 0x1a00l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffe600l); }
@Test
public void test04047() { x = 0xdeadf00ddeadf00dl; long result = x * 0x1a00l; AssertJUnit.assertEquals("multiply", result, 0xaa61689daa615200l); }
@Test
public void test04048() { x = 0x000000007fffffffl; long result = x * 0x1a00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe600000000l); }
@Test
public void test04049() { x = 0x0000000080000000l; long result = x * 0x1a00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04050() { x = 0x00000000ffffffffl; long result = x * 0x1a00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe600000000l); }
@Test
public void test04051() { x = 0x000000017fffffffl; long result = x * 0x1a00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe600000000l); }
@Test
public void test04052() { x = 0x0000000180000000l; long result = x * 0x1a00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04053() { x = 0x00000001ffffffffl; long result = x * 0x1a00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe600000000l); }
@Test
public void test04054() { x = 0xffffffff7fffffffl; long result = x * 0x1a00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe600000000l); }
@Test
public void test04055() { x = 0xffffffff80000000l; long result = x * 0x1a00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04056() { x = 0x00000001deadf00dl; long result = x * 0x1a00000000l; AssertJUnit.assertEquals("multiply", result, 0x9daa615200000000l); }
@Test
public void test04057() { x = 0xffffffffdeadf00dl; long result = x * 0x1a00000000l; AssertJUnit.assertEquals("multiply", result, 0x9daa615200000000l); }
@Test
public void test04058() { x = 0x7fffffffffffffffl; long result = x * 0x1a00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe600000000l); }
@Test
public void test04059() { x = 0x7fffffff7fffffffl; long result = x * 0x1a00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe600000000l); }
@Test
public void test04060() { x = 0x7fffffff80000000l; long result = x * 0x1a00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04061() { x = 0x7fffffffdeadf00dl; long result = x * 0x1a00000000l; AssertJUnit.assertEquals("multiply", result, 0x9daa615200000000l); }
@Test
public void test04062() { x = 0x8000000000000000l; long result = x * 0x1a00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04063() { x = 0xffffffffffffffffl; long result = x * 0x1a00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe600000000l); }
@Test
public void test04064() { x = 0xfffffffffffffffel; long result = x * 0x1a00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffcc00000000l); }
@Test
public void test04065() { x = 0xefffffffffffffffl; long result = x * 0x1a00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe600000000l); }
@Test
public void test04066() { x = 0xdeadf00ddeadf00dl; long result = x * 0x1a00000000l; AssertJUnit.assertEquals("multiply", result, 0x9daa615200000000l); }
@Test
public void test04067() { x = 0x000000007fffffffl; long result = x * 0xd000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff3000000000l); }
@Test
public void test04068() { x = 0x0000000080000000l; long result = x * 0xd000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04069() { x = 0x00000000ffffffffl; long result = x * 0xd000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff3000000000l); }
@Test
public void test04070() { x = 0x000000017fffffffl; long result = x * 0xd000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff3000000000l); }
@Test
public void test04071() { x = 0x0000000180000000l; long result = x * 0xd000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04072() { x = 0x00000001ffffffffl; long result = x * 0xd000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff3000000000l); }
@Test
public void test04073() { x = 0xffffffff7fffffffl; long result = x * 0xd000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff3000000000l); }
@Test
public void test04074() { x = 0xffffffff80000000l; long result = x * 0xd000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04075() { x = 0x00000001deadf00dl; long result = x * 0xd000000000l; AssertJUnit.assertEquals("multiply", result, 0xed530a9000000000l); }
@Test
public void test04076() { x = 0xffffffffdeadf00dl; long result = x * 0xd000000000l; AssertJUnit.assertEquals("multiply", result, 0xed530a9000000000l); }
@Test
public void test04077() { x = 0x7fffffffffffffffl; long result = x * 0xd000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff3000000000l); }
@Test
public void test04078() { x = 0x7fffffff7fffffffl; long result = x * 0xd000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff3000000000l); }
@Test
public void test04079() { x = 0x7fffffff80000000l; long result = x * 0xd000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04080() { x = 0x7fffffffdeadf00dl; long result = x * 0xd000000000l; AssertJUnit.assertEquals("multiply", result, 0xed530a9000000000l); }
@Test
public void test04081() { x = 0x8000000000000000l; long result = x * 0xd000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04082() { x = 0xffffffffffffffffl; long result = x * 0xd000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff3000000000l); }
@Test
public void test04083() { x = 0xfffffffffffffffel; long result = x * 0xd000000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffe6000000000l); }
@Test
public void test04084() { x = 0xefffffffffffffffl; long result = x * 0xd000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff3000000000l); }
@Test
public void test04085() { x = 0xdeadf00ddeadf00dl; long result = x * 0xd000000000l; AssertJUnit.assertEquals("multiply", result, 0xed530a9000000000l); }
@Test
public void test04086() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffffe6l; AssertJUnit.assertEquals("multiply", result, 0xfffffff30000001al); }
@Test
public void test04087() { x = 0x0000000080000000l; long result = x * 0xffffffffffffffe6l; AssertJUnit.assertEquals("multiply", result, 0xfffffff300000000l); }
@Test
public void test04088() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffffe6l; AssertJUnit.assertEquals("multiply", result, 0xffffffe60000001al); }
@Test
public void test04089() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffffe6l; AssertJUnit.assertEquals("multiply", result, 0xffffffd90000001al); }
@Test
public void test04090() { x = 0x0000000180000000l; long result = x * 0xffffffffffffffe6l; AssertJUnit.assertEquals("multiply", result, 0xffffffd900000000l); }
@Test
public void test04091() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffffe6l; AssertJUnit.assertEquals("multiply", result, 0xffffffcc0000001al); }
@Test
public void test04092() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffffe6l; AssertJUnit.assertEquals("multiply", result, 0x0000000d0000001al); }
@Test
public void test04093() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffffe6l; AssertJUnit.assertEquals("multiply", result, 0x0000000d00000000l); }
@Test
public void test04094() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffffe6l; AssertJUnit.assertEquals("multiply", result, 0xffffffcf62559eael); }
@Test
public void test04095() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffffe6l; AssertJUnit.assertEquals("multiply", result, 0x0000000362559eael); }
@Test
public void test04096() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffffe6l; AssertJUnit.assertEquals("multiply", result, 0x000000000000001al); }
@Test
public void test04097() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffffe6l; AssertJUnit.assertEquals("multiply", result, 0x0000000d0000001al); }
@Test
public void test04098() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffffe6l; AssertJUnit.assertEquals("multiply", result, 0x0000000d00000000l); }
@Test
public void test04099() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffffe6l; AssertJUnit.assertEquals("multiply", result, 0x0000000362559eael); }
@Test
public void test04100() { x = 0x8000000000000000l; long result = x * 0xffffffffffffffe6l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04101() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffffe6l; AssertJUnit.assertEquals("multiply", result, 0x000000000000001al); }
@Test
public void test04102() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffffe6l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000034l); }
@Test
public void test04103() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffffe6l; AssertJUnit.assertEquals("multiply", result, 0xa00000000000001al); }
@Test
public void test04104() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffffe6l; AssertJUnit.assertEquals("multiply", result, 0x62559e9762559eael); }
@Test
public void test04105() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffff30l; AssertJUnit.assertEquals("multiply", result, 0xffffff98000000d0l); }
@Test
public void test04106() { x = 0x0000000080000000l; long result = x * 0xffffffffffffff30l; AssertJUnit.assertEquals("multiply", result, 0xffffff9800000000l); }
@Test
public void test04107() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffff30l; AssertJUnit.assertEquals("multiply", result, 0xffffff30000000d0l); }
@Test
public void test04108() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffff30l; AssertJUnit.assertEquals("multiply", result, 0xfffffec8000000d0l); }
@Test
public void test04109() { x = 0x0000000180000000l; long result = x * 0xffffffffffffff30l; AssertJUnit.assertEquals("multiply", result, 0xfffffec800000000l); }
@Test
public void test04110() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffff30l; AssertJUnit.assertEquals("multiply", result, 0xfffffe60000000d0l); }
@Test
public void test04111() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffff30l; AssertJUnit.assertEquals("multiply", result, 0x00000068000000d0l); }
@Test
public void test04112() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffff30l; AssertJUnit.assertEquals("multiply", result, 0x0000006800000000l); }
@Test
public void test04113() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffff30l; AssertJUnit.assertEquals("multiply", result, 0xfffffe7b12acf570l); }
@Test
public void test04114() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffff30l; AssertJUnit.assertEquals("multiply", result, 0x0000001b12acf570l); }
@Test
public void test04115() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffff30l; AssertJUnit.assertEquals("multiply", result, 0x00000000000000d0l); }
@Test
public void test04116() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffff30l; AssertJUnit.assertEquals("multiply", result, 0x00000068000000d0l); }
@Test
public void test04117() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffff30l; AssertJUnit.assertEquals("multiply", result, 0x0000006800000000l); }
@Test
public void test04118() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffff30l; AssertJUnit.assertEquals("multiply", result, 0x0000001b12acf570l); }
@Test
public void test04119() { x = 0x8000000000000000l; long result = x * 0xffffffffffffff30l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04120() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffff30l; AssertJUnit.assertEquals("multiply", result, 0x00000000000000d0l); }
@Test
public void test04121() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffff30l; AssertJUnit.assertEquals("multiply", result, 0x00000000000001a0l); }
@Test
public void test04122() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffff30l; AssertJUnit.assertEquals("multiply", result, 0x00000000000000d0l); }
@Test
public void test04123() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffff30l; AssertJUnit.assertEquals("multiply", result, 0x12acf4bb12acf570l); }
@Test
public void test04124() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffe600l; AssertJUnit.assertEquals("multiply", result, 0xfffff30000001a00l); }
@Test
public void test04125() { x = 0x0000000080000000l; long result = x * 0xffffffffffffe600l; AssertJUnit.assertEquals("multiply", result, 0xfffff30000000000l); }
@Test
public void test04126() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffe600l; AssertJUnit.assertEquals("multiply", result, 0xffffe60000001a00l); }
@Test
public void test04127() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffe600l; AssertJUnit.assertEquals("multiply", result, 0xffffd90000001a00l); }
@Test
public void test04128() { x = 0x0000000180000000l; long result = x * 0xffffffffffffe600l; AssertJUnit.assertEquals("multiply", result, 0xffffd90000000000l); }
@Test
public void test04129() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffe600l; AssertJUnit.assertEquals("multiply", result, 0xffffcc0000001a00l); }
@Test
public void test04130() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffe600l; AssertJUnit.assertEquals("multiply", result, 0x00000d0000001a00l); }
@Test
public void test04131() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffe600l; AssertJUnit.assertEquals("multiply", result, 0x00000d0000000000l); }
@Test
public void test04132() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffe600l; AssertJUnit.assertEquals("multiply", result, 0xffffcf62559eae00l); }
@Test
public void test04133() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffe600l; AssertJUnit.assertEquals("multiply", result, 0x00000362559eae00l); }
@Test
public void test04134() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffe600l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001a00l); }
@Test
public void test04135() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffe600l; AssertJUnit.assertEquals("multiply", result, 0x00000d0000001a00l); }
@Test
public void test04136() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffe600l; AssertJUnit.assertEquals("multiply", result, 0x00000d0000000000l); }
@Test
public void test04137() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffe600l; AssertJUnit.assertEquals("multiply", result, 0x00000362559eae00l); }
@Test
public void test04138() { x = 0x8000000000000000l; long result = x * 0xffffffffffffe600l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04139() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffe600l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001a00l); }
@Test
public void test04140() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffe600l; AssertJUnit.assertEquals("multiply", result, 0x0000000000003400l); }
@Test
public void test04141() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffe600l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001a00l); }
@Test
public void test04142() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffe600l; AssertJUnit.assertEquals("multiply", result, 0x559e9762559eae00l); }
@Test
public void test04143() { x = 0x000000007fffffffl; long result = x * 0xffffffe600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001a00000000l); }
@Test
public void test04144() { x = 0x0000000080000000l; long result = x * 0xffffffe600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04145() { x = 0x00000000ffffffffl; long result = x * 0xffffffe600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001a00000000l); }
@Test
public void test04146() { x = 0x000000017fffffffl; long result = x * 0xffffffe600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001a00000000l); }
@Test
public void test04147() { x = 0x0000000180000000l; long result = x * 0xffffffe600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04148() { x = 0x00000001ffffffffl; long result = x * 0xffffffe600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001a00000000l); }
@Test
public void test04149() { x = 0xffffffff7fffffffl; long result = x * 0xffffffe600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001a00000000l); }
@Test
public void test04150() { x = 0xffffffff80000000l; long result = x * 0xffffffe600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04151() { x = 0x00000001deadf00dl; long result = x * 0xffffffe600000000l; AssertJUnit.assertEquals("multiply", result, 0x62559eae00000000l); }
@Test
public void test04152() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffe600000000l; AssertJUnit.assertEquals("multiply", result, 0x62559eae00000000l); }
@Test
public void test04153() { x = 0x7fffffffffffffffl; long result = x * 0xffffffe600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001a00000000l); }
@Test
public void test04154() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffe600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001a00000000l); }
@Test
public void test04155() { x = 0x7fffffff80000000l; long result = x * 0xffffffe600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04156() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffe600000000l; AssertJUnit.assertEquals("multiply", result, 0x62559eae00000000l); }
@Test
public void test04157() { x = 0x8000000000000000l; long result = x * 0xffffffe600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04158() { x = 0xffffffffffffffffl; long result = x * 0xffffffe600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001a00000000l); }
@Test
public void test04159() { x = 0xfffffffffffffffel; long result = x * 0xffffffe600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000003400000000l); }
@Test
public void test04160() { x = 0xefffffffffffffffl; long result = x * 0xffffffe600000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001a00000000l); }
@Test
public void test04161() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffe600000000l; AssertJUnit.assertEquals("multiply", result, 0x62559eae00000000l); }
@Test
public void test04162() { x = 0x000000007fffffffl; long result = x * 0xffffff3000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000d000000000l); }
@Test
public void test04163() { x = 0x0000000080000000l; long result = x * 0xffffff3000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04164() { x = 0x00000000ffffffffl; long result = x * 0xffffff3000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000d000000000l); }
@Test
public void test04165() { x = 0x000000017fffffffl; long result = x * 0xffffff3000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000d000000000l); }
@Test
public void test04166() { x = 0x0000000180000000l; long result = x * 0xffffff3000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04167() { x = 0x00000001ffffffffl; long result = x * 0xffffff3000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000d000000000l); }
@Test
public void test04168() { x = 0xffffffff7fffffffl; long result = x * 0xffffff3000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000d000000000l); }
@Test
public void test04169() { x = 0xffffffff80000000l; long result = x * 0xffffff3000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04170() { x = 0x00000001deadf00dl; long result = x * 0xffffff3000000000l; AssertJUnit.assertEquals("multiply", result, 0x12acf57000000000l); }
@Test
public void test04171() { x = 0xffffffffdeadf00dl; long result = x * 0xffffff3000000000l; AssertJUnit.assertEquals("multiply", result, 0x12acf57000000000l); }
@Test
public void test04172() { x = 0x7fffffffffffffffl; long result = x * 0xffffff3000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000d000000000l); }
@Test
public void test04173() { x = 0x7fffffff7fffffffl; long result = x * 0xffffff3000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000d000000000l); }
@Test
public void test04174() { x = 0x7fffffff80000000l; long result = x * 0xffffff3000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04175() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffff3000000000l; AssertJUnit.assertEquals("multiply", result, 0x12acf57000000000l); }
@Test
public void test04176() { x = 0x8000000000000000l; long result = x * 0xffffff3000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04177() { x = 0xffffffffffffffffl; long result = x * 0xffffff3000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000d000000000l); }
@Test
public void test04178() { x = 0xfffffffffffffffel; long result = x * 0xffffff3000000000l; AssertJUnit.assertEquals("multiply", result, 0x000001a000000000l); }
@Test
public void test04179() { x = 0xefffffffffffffffl; long result = x * 0xffffff3000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000d000000000l); }
@Test
public void test04180() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffff3000000000l; AssertJUnit.assertEquals("multiply", result, 0x12acf57000000000l); }
@Test
public void test04181() { x = 0x000000007fffffffl; long result = x * 0x1bl; AssertJUnit.assertEquals("multiply", result, 0x0000000d7fffffe5l); }
@Test
public void test04182() { x = 0x0000000080000000l; long result = x * 0x1bl; AssertJUnit.assertEquals("multiply", result, 0x0000000d80000000l); }
@Test
public void test04183() { x = 0x00000000ffffffffl; long result = x * 0x1bl; AssertJUnit.assertEquals("multiply", result, 0x0000001affffffe5l); }
@Test
public void test04184() { x = 0x000000017fffffffl; long result = x * 0x1bl; AssertJUnit.assertEquals("multiply", result, 0x000000287fffffe5l); }
@Test
public void test04185() { x = 0x0000000180000000l; long result = x * 0x1bl; AssertJUnit.assertEquals("multiply", result, 0x0000002880000000l); }
@Test
public void test04186() { x = 0x00000001ffffffffl; long result = x * 0x1bl; AssertJUnit.assertEquals("multiply", result, 0x00000035ffffffe5l); }
@Test
public void test04187() { x = 0xffffffff7fffffffl; long result = x * 0x1bl; AssertJUnit.assertEquals("multiply", result, 0xfffffff27fffffe5l); }
@Test
public void test04188() { x = 0xffffffff80000000l; long result = x * 0x1bl; AssertJUnit.assertEquals("multiply", result, 0xfffffff280000000l); }
@Test
public void test04189() { x = 0x00000001deadf00dl; long result = x * 0x1bl; AssertJUnit.assertEquals("multiply", result, 0x000000327c58515fl); }
@Test
public void test04190() { x = 0xffffffffdeadf00dl; long result = x * 0x1bl; AssertJUnit.assertEquals("multiply", result, 0xfffffffc7c58515fl); }
@Test
public void test04191() { x = 0x7fffffffffffffffl; long result = x * 0x1bl; AssertJUnit.assertEquals("multiply", result, 0x7fffffffffffffe5l); }
@Test
public void test04192() { x = 0x7fffffff7fffffffl; long result = x * 0x1bl; AssertJUnit.assertEquals("multiply", result, 0x7ffffff27fffffe5l); }
@Test
public void test04193() { x = 0x7fffffff80000000l; long result = x * 0x1bl; AssertJUnit.assertEquals("multiply", result, 0x7ffffff280000000l); }
@Test
public void test04194() { x = 0x7fffffffdeadf00dl; long result = x * 0x1bl; AssertJUnit.assertEquals("multiply", result, 0x7ffffffc7c58515fl); }
@Test
public void test04195() { x = 0x8000000000000000l; long result = x * 0x1bl; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test04196() { x = 0xffffffffffffffffl; long result = x * 0x1bl; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffe5l); }
@Test
public void test04197() { x = 0xfffffffffffffffel; long result = x * 0x1bl; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffcal); }
@Test
public void test04198() { x = 0xefffffffffffffffl; long result = x * 0x1bl; AssertJUnit.assertEquals("multiply", result, 0x4fffffffffffffe5l); }
@Test
public void test04199() { x = 0xdeadf00ddeadf00dl; long result = x * 0x1bl; AssertJUnit.assertEquals("multiply", result, 0x7c5851767c58515fl); }
@Test
public void test04200() { x = 0x000000007fffffffl; long result = x * 0xd8l; AssertJUnit.assertEquals("multiply", result, 0x0000006bffffff28l); }
@Test
public void test04201() { x = 0x0000000080000000l; long result = x * 0xd8l; AssertJUnit.assertEquals("multiply", result, 0x0000006c00000000l); }
@Test
public void test04202() { x = 0x00000000ffffffffl; long result = x * 0xd8l; AssertJUnit.assertEquals("multiply", result, 0x000000d7ffffff28l); }
@Test
public void test04203() { x = 0x000000017fffffffl; long result = x * 0xd8l; AssertJUnit.assertEquals("multiply", result, 0x00000143ffffff28l); }
@Test
public void test04204() { x = 0x0000000180000000l; long result = x * 0xd8l; AssertJUnit.assertEquals("multiply", result, 0x0000014400000000l); }
@Test
public void test04205() { x = 0x00000001ffffffffl; long result = x * 0xd8l; AssertJUnit.assertEquals("multiply", result, 0x000001afffffff28l); }
@Test
public void test04206() { x = 0xffffffff7fffffffl; long result = x * 0xd8l; AssertJUnit.assertEquals("multiply", result, 0xffffff93ffffff28l); }
@Test
public void test04207() { x = 0xffffffff80000000l; long result = x * 0xd8l; AssertJUnit.assertEquals("multiply", result, 0xffffff9400000000l); }
@Test
public void test04208() { x = 0x00000001deadf00dl; long result = x * 0xd8l; AssertJUnit.assertEquals("multiply", result, 0x00000193e2c28af8l); }
@Test
public void test04209() { x = 0xffffffffdeadf00dl; long result = x * 0xd8l; AssertJUnit.assertEquals("multiply", result, 0xffffffe3e2c28af8l); }
@Test
public void test04210() { x = 0x7fffffffffffffffl; long result = x * 0xd8l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff28l); }
@Test
public void test04211() { x = 0x7fffffff7fffffffl; long result = x * 0xd8l; AssertJUnit.assertEquals("multiply", result, 0xffffff93ffffff28l); }
@Test
public void test04212() { x = 0x7fffffff80000000l; long result = x * 0xd8l; AssertJUnit.assertEquals("multiply", result, 0xffffff9400000000l); }
@Test
public void test04213() { x = 0x7fffffffdeadf00dl; long result = x * 0xd8l; AssertJUnit.assertEquals("multiply", result, 0xffffffe3e2c28af8l); }
@Test
public void test04214() { x = 0x8000000000000000l; long result = x * 0xd8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04215() { x = 0xffffffffffffffffl; long result = x * 0xd8l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff28l); }
@Test
public void test04216() { x = 0xfffffffffffffffel; long result = x * 0xd8l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffe50l); }
@Test
public void test04217() { x = 0xefffffffffffffffl; long result = x * 0xd8l; AssertJUnit.assertEquals("multiply", result, 0x7fffffffffffff28l); }
@Test
public void test04218() { x = 0xdeadf00ddeadf00dl; long result = x * 0xd8l; AssertJUnit.assertEquals("multiply", result, 0xe2c28bb3e2c28af8l); }
@Test
public void test04219() { x = 0x000000007fffffffl; long result = x * 0x1b00l; AssertJUnit.assertEquals("multiply", result, 0x00000d7fffffe500l); }
@Test
public void test04220() { x = 0x0000000080000000l; long result = x * 0x1b00l; AssertJUnit.assertEquals("multiply", result, 0x00000d8000000000l); }
@Test
public void test04221() { x = 0x00000000ffffffffl; long result = x * 0x1b00l; AssertJUnit.assertEquals("multiply", result, 0x00001affffffe500l); }
@Test
public void test04222() { x = 0x000000017fffffffl; long result = x * 0x1b00l; AssertJUnit.assertEquals("multiply", result, 0x0000287fffffe500l); }
@Test
public void test04223() { x = 0x0000000180000000l; long result = x * 0x1b00l; AssertJUnit.assertEquals("multiply", result, 0x0000288000000000l); }
@Test
public void test04224() { x = 0x00000001ffffffffl; long result = x * 0x1b00l; AssertJUnit.assertEquals("multiply", result, 0x000035ffffffe500l); }
@Test
public void test04225() { x = 0xffffffff7fffffffl; long result = x * 0x1b00l; AssertJUnit.assertEquals("multiply", result, 0xfffff27fffffe500l); }
@Test
public void test04226() { x = 0xffffffff80000000l; long result = x * 0x1b00l; AssertJUnit.assertEquals("multiply", result, 0xfffff28000000000l); }
@Test
public void test04227() { x = 0x00000001deadf00dl; long result = x * 0x1b00l; AssertJUnit.assertEquals("multiply", result, 0x0000327c58515f00l); }
@Test
public void test04228() { x = 0xffffffffdeadf00dl; long result = x * 0x1b00l; AssertJUnit.assertEquals("multiply", result, 0xfffffc7c58515f00l); }
@Test
public void test04229() { x = 0x7fffffffffffffffl; long result = x * 0x1b00l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffe500l); }
@Test
public void test04230() { x = 0x7fffffff7fffffffl; long result = x * 0x1b00l; AssertJUnit.assertEquals("multiply", result, 0xfffff27fffffe500l); }
@Test
public void test04231() { x = 0x7fffffff80000000l; long result = x * 0x1b00l; AssertJUnit.assertEquals("multiply", result, 0xfffff28000000000l); }
@Test
public void test04232() { x = 0x7fffffffdeadf00dl; long result = x * 0x1b00l; AssertJUnit.assertEquals("multiply", result, 0xfffffc7c58515f00l); }
@Test
public void test04233() { x = 0x8000000000000000l; long result = x * 0x1b00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04234() { x = 0xffffffffffffffffl; long result = x * 0x1b00l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffe500l); }
@Test
public void test04235() { x = 0xfffffffffffffffel; long result = x * 0x1b00l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffca00l); }
@Test
public void test04236() { x = 0xefffffffffffffffl; long result = x * 0x1b00l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffe500l); }
@Test
public void test04237() { x = 0xdeadf00ddeadf00dl; long result = x * 0x1b00l; AssertJUnit.assertEquals("multiply", result, 0x5851767c58515f00l); }
@Test
public void test04238() { x = 0x000000007fffffffl; long result = x * 0x1b00000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffe500000000l); }
@Test
public void test04239() { x = 0x0000000080000000l; long result = x * 0x1b00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test04240() { x = 0x00000000ffffffffl; long result = x * 0x1b00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe500000000l); }
@Test
public void test04241() { x = 0x000000017fffffffl; long result = x * 0x1b00000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffe500000000l); }
@Test
public void test04242() { x = 0x0000000180000000l; long result = x * 0x1b00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test04243() { x = 0x00000001ffffffffl; long result = x * 0x1b00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe500000000l); }
@Test
public void test04244() { x = 0xffffffff7fffffffl; long result = x * 0x1b00000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffe500000000l); }
@Test
public void test04245() { x = 0xffffffff80000000l; long result = x * 0x1b00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test04246() { x = 0x00000001deadf00dl; long result = x * 0x1b00000000l; AssertJUnit.assertEquals("multiply", result, 0x7c58515f00000000l); }
@Test
public void test04247() { x = 0xffffffffdeadf00dl; long result = x * 0x1b00000000l; AssertJUnit.assertEquals("multiply", result, 0x7c58515f00000000l); }
@Test
public void test04248() { x = 0x7fffffffffffffffl; long result = x * 0x1b00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe500000000l); }
@Test
public void test04249() { x = 0x7fffffff7fffffffl; long result = x * 0x1b00000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffe500000000l); }
@Test
public void test04250() { x = 0x7fffffff80000000l; long result = x * 0x1b00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test04251() { x = 0x7fffffffdeadf00dl; long result = x * 0x1b00000000l; AssertJUnit.assertEquals("multiply", result, 0x7c58515f00000000l); }
@Test
public void test04252() { x = 0x8000000000000000l; long result = x * 0x1b00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04253() { x = 0xffffffffffffffffl; long result = x * 0x1b00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe500000000l); }
@Test
public void test04254() { x = 0xfffffffffffffffel; long result = x * 0x1b00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffca00000000l); }
@Test
public void test04255() { x = 0xefffffffffffffffl; long result = x * 0x1b00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe500000000l); }
@Test
public void test04256() { x = 0xdeadf00ddeadf00dl; long result = x * 0x1b00000000l; AssertJUnit.assertEquals("multiply", result, 0x7c58515f00000000l); }
@Test
public void test04257() { x = 0x000000007fffffffl; long result = x * 0xd800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff2800000000l); }
@Test
public void test04258() { x = 0x0000000080000000l; long result = x * 0xd800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04259() { x = 0x00000000ffffffffl; long result = x * 0xd800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff2800000000l); }
@Test
public void test04260() { x = 0x000000017fffffffl; long result = x * 0xd800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff2800000000l); }
@Test
public void test04261() { x = 0x0000000180000000l; long result = x * 0xd800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04262() { x = 0x00000001ffffffffl; long result = x * 0xd800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff2800000000l); }
@Test
public void test04263() { x = 0xffffffff7fffffffl; long result = x * 0xd800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff2800000000l); }
@Test
public void test04264() { x = 0xffffffff80000000l; long result = x * 0xd800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04265() { x = 0x00000001deadf00dl; long result = x * 0xd800000000l; AssertJUnit.assertEquals("multiply", result, 0xe2c28af800000000l); }
@Test
public void test04266() { x = 0xffffffffdeadf00dl; long result = x * 0xd800000000l; AssertJUnit.assertEquals("multiply", result, 0xe2c28af800000000l); }
@Test
public void test04267() { x = 0x7fffffffffffffffl; long result = x * 0xd800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff2800000000l); }
@Test
public void test04268() { x = 0x7fffffff7fffffffl; long result = x * 0xd800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff2800000000l); }
@Test
public void test04269() { x = 0x7fffffff80000000l; long result = x * 0xd800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04270() { x = 0x7fffffffdeadf00dl; long result = x * 0xd800000000l; AssertJUnit.assertEquals("multiply", result, 0xe2c28af800000000l); }
@Test
public void test04271() { x = 0x8000000000000000l; long result = x * 0xd800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04272() { x = 0xffffffffffffffffl; long result = x * 0xd800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff2800000000l); }
@Test
public void test04273() { x = 0xfffffffffffffffel; long result = x * 0xd800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffe5000000000l); }
@Test
public void test04274() { x = 0xefffffffffffffffl; long result = x * 0xd800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff2800000000l); }
@Test
public void test04275() { x = 0xdeadf00ddeadf00dl; long result = x * 0xd800000000l; AssertJUnit.assertEquals("multiply", result, 0xe2c28af800000000l); }
@Test
public void test04276() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffffe5l; AssertJUnit.assertEquals("multiply", result, 0xfffffff28000001bl); }
@Test
public void test04277() { x = 0x0000000080000000l; long result = x * 0xffffffffffffffe5l; AssertJUnit.assertEquals("multiply", result, 0xfffffff280000000l); }
@Test
public void test04278() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffffe5l; AssertJUnit.assertEquals("multiply", result, 0xffffffe50000001bl); }
@Test
public void test04279() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffffe5l; AssertJUnit.assertEquals("multiply", result, 0xffffffd78000001bl); }
@Test
public void test04280() { x = 0x0000000180000000l; long result = x * 0xffffffffffffffe5l; AssertJUnit.assertEquals("multiply", result, 0xffffffd780000000l); }
@Test
public void test04281() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffffe5l; AssertJUnit.assertEquals("multiply", result, 0xffffffca0000001bl); }
@Test
public void test04282() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffffe5l; AssertJUnit.assertEquals("multiply", result, 0x0000000d8000001bl); }
@Test
public void test04283() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffffe5l; AssertJUnit.assertEquals("multiply", result, 0x0000000d80000000l); }
@Test
public void test04284() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffffe5l; AssertJUnit.assertEquals("multiply", result, 0xffffffcd83a7aea1l); }
@Test
public void test04285() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffffe5l; AssertJUnit.assertEquals("multiply", result, 0x0000000383a7aea1l); }
@Test
public void test04286() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffffe5l; AssertJUnit.assertEquals("multiply", result, 0x800000000000001bl); }
@Test
public void test04287() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffffe5l; AssertJUnit.assertEquals("multiply", result, 0x8000000d8000001bl); }
@Test
public void test04288() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffffe5l; AssertJUnit.assertEquals("multiply", result, 0x8000000d80000000l); }
@Test
public void test04289() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffffe5l; AssertJUnit.assertEquals("multiply", result, 0x8000000383a7aea1l); }
@Test
public void test04290() { x = 0x8000000000000000l; long result = x * 0xffffffffffffffe5l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test04291() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffffe5l; AssertJUnit.assertEquals("multiply", result, 0x000000000000001bl); }
@Test
public void test04292() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffffe5l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000036l); }
@Test
public void test04293() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffffe5l; AssertJUnit.assertEquals("multiply", result, 0xb00000000000001bl); }
@Test
public void test04294() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffffe5l; AssertJUnit.assertEquals("multiply", result, 0x83a7ae8983a7aea1l); }
@Test
public void test04295() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffff28l; AssertJUnit.assertEquals("multiply", result, 0xffffff94000000d8l); }
@Test
public void test04296() { x = 0x0000000080000000l; long result = x * 0xffffffffffffff28l; AssertJUnit.assertEquals("multiply", result, 0xffffff9400000000l); }
@Test
public void test04297() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffff28l; AssertJUnit.assertEquals("multiply", result, 0xffffff28000000d8l); }
@Test
public void test04298() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffff28l; AssertJUnit.assertEquals("multiply", result, 0xfffffebc000000d8l); }
@Test
public void test04299() { x = 0x0000000180000000l; long result = x * 0xffffffffffffff28l; AssertJUnit.assertEquals("multiply", result, 0xfffffebc00000000l); }
@Test
public void test04300() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffff28l; AssertJUnit.assertEquals("multiply", result, 0xfffffe50000000d8l); }
@Test
public void test04301() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffff28l; AssertJUnit.assertEquals("multiply", result, 0x0000006c000000d8l); }
@Test
public void test04302() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffff28l; AssertJUnit.assertEquals("multiply", result, 0x0000006c00000000l); }
@Test
public void test04303() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffff28l; AssertJUnit.assertEquals("multiply", result, 0xfffffe6c1d3d7508l); }
@Test
public void test04304() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffff28l; AssertJUnit.assertEquals("multiply", result, 0x0000001c1d3d7508l); }
@Test
public void test04305() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffff28l; AssertJUnit.assertEquals("multiply", result, 0x00000000000000d8l); }
@Test
public void test04306() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffff28l; AssertJUnit.assertEquals("multiply", result, 0x0000006c000000d8l); }
@Test
public void test04307() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffff28l; AssertJUnit.assertEquals("multiply", result, 0x0000006c00000000l); }
@Test
public void test04308() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffff28l; AssertJUnit.assertEquals("multiply", result, 0x0000001c1d3d7508l); }
@Test
public void test04309() { x = 0x8000000000000000l; long result = x * 0xffffffffffffff28l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04310() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffff28l; AssertJUnit.assertEquals("multiply", result, 0x00000000000000d8l); }
@Test
public void test04311() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffff28l; AssertJUnit.assertEquals("multiply", result, 0x00000000000001b0l); }
@Test
public void test04312() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffff28l; AssertJUnit.assertEquals("multiply", result, 0x80000000000000d8l); }
@Test
public void test04313() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffff28l; AssertJUnit.assertEquals("multiply", result, 0x1d3d744c1d3d7508l); }
@Test
public void test04314() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffe500l; AssertJUnit.assertEquals("multiply", result, 0xfffff28000001b00l); }
@Test
public void test04315() { x = 0x0000000080000000l; long result = x * 0xffffffffffffe500l; AssertJUnit.assertEquals("multiply", result, 0xfffff28000000000l); }
@Test
public void test04316() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffe500l; AssertJUnit.assertEquals("multiply", result, 0xffffe50000001b00l); }
@Test
public void test04317() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffe500l; AssertJUnit.assertEquals("multiply", result, 0xffffd78000001b00l); }
@Test
public void test04318() { x = 0x0000000180000000l; long result = x * 0xffffffffffffe500l; AssertJUnit.assertEquals("multiply", result, 0xffffd78000000000l); }
@Test
public void test04319() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffe500l; AssertJUnit.assertEquals("multiply", result, 0xffffca0000001b00l); }
@Test
public void test04320() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffe500l; AssertJUnit.assertEquals("multiply", result, 0x00000d8000001b00l); }
@Test
public void test04321() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffe500l; AssertJUnit.assertEquals("multiply", result, 0x00000d8000000000l); }
@Test
public void test04322() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffe500l; AssertJUnit.assertEquals("multiply", result, 0xffffcd83a7aea100l); }
@Test
public void test04323() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffe500l; AssertJUnit.assertEquals("multiply", result, 0x00000383a7aea100l); }
@Test
public void test04324() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffe500l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001b00l); }
@Test
public void test04325() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffe500l; AssertJUnit.assertEquals("multiply", result, 0x00000d8000001b00l); }
@Test
public void test04326() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffe500l; AssertJUnit.assertEquals("multiply", result, 0x00000d8000000000l); }
@Test
public void test04327() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffe500l; AssertJUnit.assertEquals("multiply", result, 0x00000383a7aea100l); }
@Test
public void test04328() { x = 0x8000000000000000l; long result = x * 0xffffffffffffe500l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04329() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffe500l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001b00l); }
@Test
public void test04330() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffe500l; AssertJUnit.assertEquals("multiply", result, 0x0000000000003600l); }
@Test
public void test04331() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffe500l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001b00l); }
@Test
public void test04332() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffe500l; AssertJUnit.assertEquals("multiply", result, 0xa7ae8983a7aea100l); }
@Test
public void test04333() { x = 0x000000007fffffffl; long result = x * 0xffffffe500000000l; AssertJUnit.assertEquals("multiply", result, 0x8000001b00000000l); }
@Test
public void test04334() { x = 0x0000000080000000l; long result = x * 0xffffffe500000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test04335() { x = 0x00000000ffffffffl; long result = x * 0xffffffe500000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001b00000000l); }
@Test
public void test04336() { x = 0x000000017fffffffl; long result = x * 0xffffffe500000000l; AssertJUnit.assertEquals("multiply", result, 0x8000001b00000000l); }
@Test
public void test04337() { x = 0x0000000180000000l; long result = x * 0xffffffe500000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test04338() { x = 0x00000001ffffffffl; long result = x * 0xffffffe500000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001b00000000l); }
@Test
public void test04339() { x = 0xffffffff7fffffffl; long result = x * 0xffffffe500000000l; AssertJUnit.assertEquals("multiply", result, 0x8000001b00000000l); }
@Test
public void test04340() { x = 0xffffffff80000000l; long result = x * 0xffffffe500000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test04341() { x = 0x00000001deadf00dl; long result = x * 0xffffffe500000000l; AssertJUnit.assertEquals("multiply", result, 0x83a7aea100000000l); }
@Test
public void test04342() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffe500000000l; AssertJUnit.assertEquals("multiply", result, 0x83a7aea100000000l); }
@Test
public void test04343() { x = 0x7fffffffffffffffl; long result = x * 0xffffffe500000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001b00000000l); }
@Test
public void test04344() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffe500000000l; AssertJUnit.assertEquals("multiply", result, 0x8000001b00000000l); }
@Test
public void test04345() { x = 0x7fffffff80000000l; long result = x * 0xffffffe500000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test04346() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffe500000000l; AssertJUnit.assertEquals("multiply", result, 0x83a7aea100000000l); }
@Test
public void test04347() { x = 0x8000000000000000l; long result = x * 0xffffffe500000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04348() { x = 0xffffffffffffffffl; long result = x * 0xffffffe500000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001b00000000l); }
@Test
public void test04349() { x = 0xfffffffffffffffel; long result = x * 0xffffffe500000000l; AssertJUnit.assertEquals("multiply", result, 0x0000003600000000l); }
@Test
public void test04350() { x = 0xefffffffffffffffl; long result = x * 0xffffffe500000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001b00000000l); }
@Test
public void test04351() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffe500000000l; AssertJUnit.assertEquals("multiply", result, 0x83a7aea100000000l); }
@Test
public void test04352() { x = 0x000000007fffffffl; long result = x * 0xffffff2800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000d800000000l); }
@Test
public void test04353() { x = 0x0000000080000000l; long result = x * 0xffffff2800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04354() { x = 0x00000000ffffffffl; long result = x * 0xffffff2800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000d800000000l); }
@Test
public void test04355() { x = 0x000000017fffffffl; long result = x * 0xffffff2800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000d800000000l); }
@Test
public void test04356() { x = 0x0000000180000000l; long result = x * 0xffffff2800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04357() { x = 0x00000001ffffffffl; long result = x * 0xffffff2800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000d800000000l); }
@Test
public void test04358() { x = 0xffffffff7fffffffl; long result = x * 0xffffff2800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000d800000000l); }
@Test
public void test04359() { x = 0xffffffff80000000l; long result = x * 0xffffff2800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04360() { x = 0x00000001deadf00dl; long result = x * 0xffffff2800000000l; AssertJUnit.assertEquals("multiply", result, 0x1d3d750800000000l); }
@Test
public void test04361() { x = 0xffffffffdeadf00dl; long result = x * 0xffffff2800000000l; AssertJUnit.assertEquals("multiply", result, 0x1d3d750800000000l); }
@Test
public void test04362() { x = 0x7fffffffffffffffl; long result = x * 0xffffff2800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000d800000000l); }
@Test
public void test04363() { x = 0x7fffffff7fffffffl; long result = x * 0xffffff2800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000d800000000l); }
@Test
public void test04364() { x = 0x7fffffff80000000l; long result = x * 0xffffff2800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04365() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffff2800000000l; AssertJUnit.assertEquals("multiply", result, 0x1d3d750800000000l); }
@Test
public void test04366() { x = 0x8000000000000000l; long result = x * 0xffffff2800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04367() { x = 0xffffffffffffffffl; long result = x * 0xffffff2800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000d800000000l); }
@Test
public void test04368() { x = 0xfffffffffffffffel; long result = x * 0xffffff2800000000l; AssertJUnit.assertEquals("multiply", result, 0x000001b000000000l); }
@Test
public void test04369() { x = 0xefffffffffffffffl; long result = x * 0xffffff2800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000d800000000l); }
@Test
public void test04370() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffff2800000000l; AssertJUnit.assertEquals("multiply", result, 0x1d3d750800000000l); }
@Test
public void test04371() { x = 0x000000007fffffffl; long result = x * 0x1cl; AssertJUnit.assertEquals("multiply", result, 0x0000000dffffffe4l); }
@Test
public void test04372() { x = 0x0000000080000000l; long result = x * 0x1cl; AssertJUnit.assertEquals("multiply", result, 0x0000000e00000000l); }
@Test
public void test04373() { x = 0x00000000ffffffffl; long result = x * 0x1cl; AssertJUnit.assertEquals("multiply", result, 0x0000001bffffffe4l); }
@Test
public void test04374() { x = 0x000000017fffffffl; long result = x * 0x1cl; AssertJUnit.assertEquals("multiply", result, 0x00000029ffffffe4l); }
@Test
public void test04375() { x = 0x0000000180000000l; long result = x * 0x1cl; AssertJUnit.assertEquals("multiply", result, 0x0000002a00000000l); }
@Test
public void test04376() { x = 0x00000001ffffffffl; long result = x * 0x1cl; AssertJUnit.assertEquals("multiply", result, 0x00000037ffffffe4l); }
@Test
public void test04377() { x = 0xffffffff7fffffffl; long result = x * 0x1cl; AssertJUnit.assertEquals("multiply", result, 0xfffffff1ffffffe4l); }
@Test
public void test04378() { x = 0xffffffff80000000l; long result = x * 0x1cl; AssertJUnit.assertEquals("multiply", result, 0xfffffff200000000l); }
@Test
public void test04379() { x = 0x00000001deadf00dl; long result = x * 0x1cl; AssertJUnit.assertEquals("multiply", result, 0x000000345b06416cl); }
@Test
public void test04380() { x = 0xffffffffdeadf00dl; long result = x * 0x1cl; AssertJUnit.assertEquals("multiply", result, 0xfffffffc5b06416cl); }
@Test
public void test04381() { x = 0x7fffffffffffffffl; long result = x * 0x1cl; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffe4l); }
@Test
public void test04382() { x = 0x7fffffff7fffffffl; long result = x * 0x1cl; AssertJUnit.assertEquals("multiply", result, 0xfffffff1ffffffe4l); }
@Test
public void test04383() { x = 0x7fffffff80000000l; long result = x * 0x1cl; AssertJUnit.assertEquals("multiply", result, 0xfffffff200000000l); }
@Test
public void test04384() { x = 0x7fffffffdeadf00dl; long result = x * 0x1cl; AssertJUnit.assertEquals("multiply", result, 0xfffffffc5b06416cl); }
@Test
public void test04385() { x = 0x8000000000000000l; long result = x * 0x1cl; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04386() { x = 0xffffffffffffffffl; long result = x * 0x1cl; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffe4l); }
@Test
public void test04387() { x = 0xfffffffffffffffel; long result = x * 0x1cl; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffc8l); }
@Test
public void test04388() { x = 0xefffffffffffffffl; long result = x * 0x1cl; AssertJUnit.assertEquals("multiply", result, 0x3fffffffffffffe4l); }
@Test
public void test04389() { x = 0xdeadf00ddeadf00dl; long result = x * 0x1cl; AssertJUnit.assertEquals("multiply", result, 0x5b0641845b06416cl); }
@Test
public void test04390() { x = 0x000000007fffffffl; long result = x * 0xe0l; AssertJUnit.assertEquals("multiply", result, 0x0000006fffffff20l); }
@Test
public void test04391() { x = 0x0000000080000000l; long result = x * 0xe0l; AssertJUnit.assertEquals("multiply", result, 0x0000007000000000l); }
@Test
public void test04392() { x = 0x00000000ffffffffl; long result = x * 0xe0l; AssertJUnit.assertEquals("multiply", result, 0x000000dfffffff20l); }
@Test
public void test04393() { x = 0x000000017fffffffl; long result = x * 0xe0l; AssertJUnit.assertEquals("multiply", result, 0x0000014fffffff20l); }
@Test
public void test04394() { x = 0x0000000180000000l; long result = x * 0xe0l; AssertJUnit.assertEquals("multiply", result, 0x0000015000000000l); }
@Test
public void test04395() { x = 0x00000001ffffffffl; long result = x * 0xe0l; AssertJUnit.assertEquals("multiply", result, 0x000001bfffffff20l); }
@Test
public void test04396() { x = 0xffffffff7fffffffl; long result = x * 0xe0l; AssertJUnit.assertEquals("multiply", result, 0xffffff8fffffff20l); }
@Test
public void test04397() { x = 0xffffffff80000000l; long result = x * 0xe0l; AssertJUnit.assertEquals("multiply", result, 0xffffff9000000000l); }
@Test
public void test04398() { x = 0x00000001deadf00dl; long result = x * 0xe0l; AssertJUnit.assertEquals("multiply", result, 0x000001a2d8320b60l); }
@Test
public void test04399() { x = 0xffffffffdeadf00dl; long result = x * 0xe0l; AssertJUnit.assertEquals("multiply", result, 0xffffffe2d8320b60l); }
@Test
public void test04400() { x = 0x7fffffffffffffffl; long result = x * 0xe0l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff20l); }
@Test
public void test04401() { x = 0x7fffffff7fffffffl; long result = x * 0xe0l; AssertJUnit.assertEquals("multiply", result, 0xffffff8fffffff20l); }
@Test
public void test04402() { x = 0x7fffffff80000000l; long result = x * 0xe0l; AssertJUnit.assertEquals("multiply", result, 0xffffff9000000000l); }
@Test
public void test04403() { x = 0x7fffffffdeadf00dl; long result = x * 0xe0l; AssertJUnit.assertEquals("multiply", result, 0xffffffe2d8320b60l); }
@Test
public void test04404() { x = 0x8000000000000000l; long result = x * 0xe0l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04405() { x = 0xffffffffffffffffl; long result = x * 0xe0l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff20l); }
@Test
public void test04406() { x = 0xfffffffffffffffel; long result = x * 0xe0l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffe40l); }
@Test
public void test04407() { x = 0xefffffffffffffffl; long result = x * 0xe0l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff20l); }
@Test
public void test04408() { x = 0xdeadf00ddeadf00dl; long result = x * 0xe0l; AssertJUnit.assertEquals("multiply", result, 0xd8320c22d8320b60l); }
@Test
public void test04409() { x = 0x000000007fffffffl; long result = x * 0x1c00l; AssertJUnit.assertEquals("multiply", result, 0x00000dffffffe400l); }
@Test
public void test04410() { x = 0x0000000080000000l; long result = x * 0x1c00l; AssertJUnit.assertEquals("multiply", result, 0x00000e0000000000l); }
@Test
public void test04411() { x = 0x00000000ffffffffl; long result = x * 0x1c00l; AssertJUnit.assertEquals("multiply", result, 0x00001bffffffe400l); }
@Test
public void test04412() { x = 0x000000017fffffffl; long result = x * 0x1c00l; AssertJUnit.assertEquals("multiply", result, 0x000029ffffffe400l); }
@Test
public void test04413() { x = 0x0000000180000000l; long result = x * 0x1c00l; AssertJUnit.assertEquals("multiply", result, 0x00002a0000000000l); }
@Test
public void test04414() { x = 0x00000001ffffffffl; long result = x * 0x1c00l; AssertJUnit.assertEquals("multiply", result, 0x000037ffffffe400l); }
@Test
public void test04415() { x = 0xffffffff7fffffffl; long result = x * 0x1c00l; AssertJUnit.assertEquals("multiply", result, 0xfffff1ffffffe400l); }
@Test
public void test04416() { x = 0xffffffff80000000l; long result = x * 0x1c00l; AssertJUnit.assertEquals("multiply", result, 0xfffff20000000000l); }
@Test
public void test04417() { x = 0x00000001deadf00dl; long result = x * 0x1c00l; AssertJUnit.assertEquals("multiply", result, 0x0000345b06416c00l); }
@Test
public void test04418() { x = 0xffffffffdeadf00dl; long result = x * 0x1c00l; AssertJUnit.assertEquals("multiply", result, 0xfffffc5b06416c00l); }
@Test
public void test04419() { x = 0x7fffffffffffffffl; long result = x * 0x1c00l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffe400l); }
@Test
public void test04420() { x = 0x7fffffff7fffffffl; long result = x * 0x1c00l; AssertJUnit.assertEquals("multiply", result, 0xfffff1ffffffe400l); }
@Test
public void test04421() { x = 0x7fffffff80000000l; long result = x * 0x1c00l; AssertJUnit.assertEquals("multiply", result, 0xfffff20000000000l); }
@Test
public void test04422() { x = 0x7fffffffdeadf00dl; long result = x * 0x1c00l; AssertJUnit.assertEquals("multiply", result, 0xfffffc5b06416c00l); }
@Test
public void test04423() { x = 0x8000000000000000l; long result = x * 0x1c00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04424() { x = 0xffffffffffffffffl; long result = x * 0x1c00l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffe400l); }
@Test
public void test04425() { x = 0xfffffffffffffffel; long result = x * 0x1c00l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffc800l); }
@Test
public void test04426() { x = 0xefffffffffffffffl; long result = x * 0x1c00l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffe400l); }
@Test
public void test04427() { x = 0xdeadf00ddeadf00dl; long result = x * 0x1c00l; AssertJUnit.assertEquals("multiply", result, 0x0641845b06416c00l); }
@Test
public void test04428() { x = 0x000000007fffffffl; long result = x * 0x1c00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe400000000l); }
@Test
public void test04429() { x = 0x0000000080000000l; long result = x * 0x1c00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04430() { x = 0x00000000ffffffffl; long result = x * 0x1c00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe400000000l); }
@Test
public void test04431() { x = 0x000000017fffffffl; long result = x * 0x1c00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe400000000l); }
@Test
public void test04432() { x = 0x0000000180000000l; long result = x * 0x1c00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04433() { x = 0x00000001ffffffffl; long result = x * 0x1c00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe400000000l); }
@Test
public void test04434() { x = 0xffffffff7fffffffl; long result = x * 0x1c00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe400000000l); }
@Test
public void test04435() { x = 0xffffffff80000000l; long result = x * 0x1c00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04436() { x = 0x00000001deadf00dl; long result = x * 0x1c00000000l; AssertJUnit.assertEquals("multiply", result, 0x5b06416c00000000l); }
@Test
public void test04437() { x = 0xffffffffdeadf00dl; long result = x * 0x1c00000000l; AssertJUnit.assertEquals("multiply", result, 0x5b06416c00000000l); }
@Test
public void test04438() { x = 0x7fffffffffffffffl; long result = x * 0x1c00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe400000000l); }
@Test
public void test04439() { x = 0x7fffffff7fffffffl; long result = x * 0x1c00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe400000000l); }
@Test
public void test04440() { x = 0x7fffffff80000000l; long result = x * 0x1c00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04441() { x = 0x7fffffffdeadf00dl; long result = x * 0x1c00000000l; AssertJUnit.assertEquals("multiply", result, 0x5b06416c00000000l); }
@Test
public void test04442() { x = 0x8000000000000000l; long result = x * 0x1c00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04443() { x = 0xffffffffffffffffl; long result = x * 0x1c00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe400000000l); }
@Test
public void test04444() { x = 0xfffffffffffffffel; long result = x * 0x1c00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffc800000000l); }
@Test
public void test04445() { x = 0xefffffffffffffffl; long result = x * 0x1c00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe400000000l); }
@Test
public void test04446() { x = 0xdeadf00ddeadf00dl; long result = x * 0x1c00000000l; AssertJUnit.assertEquals("multiply", result, 0x5b06416c00000000l); }
@Test
public void test04447() { x = 0x000000007fffffffl; long result = x * 0xe000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff2000000000l); }
@Test
public void test04448() { x = 0x0000000080000000l; long result = x * 0xe000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04449() { x = 0x00000000ffffffffl; long result = x * 0xe000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff2000000000l); }
@Test
public void test04450() { x = 0x000000017fffffffl; long result = x * 0xe000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff2000000000l); }
@Test
public void test04451() { x = 0x0000000180000000l; long result = x * 0xe000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04452() { x = 0x00000001ffffffffl; long result = x * 0xe000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff2000000000l); }
@Test
public void test04453() { x = 0xffffffff7fffffffl; long result = x * 0xe000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff2000000000l); }
@Test
public void test04454() { x = 0xffffffff80000000l; long result = x * 0xe000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04455() { x = 0x00000001deadf00dl; long result = x * 0xe000000000l; AssertJUnit.assertEquals("multiply", result, 0xd8320b6000000000l); }
@Test
public void test04456() { x = 0xffffffffdeadf00dl; long result = x * 0xe000000000l; AssertJUnit.assertEquals("multiply", result, 0xd8320b6000000000l); }
@Test
public void test04457() { x = 0x7fffffffffffffffl; long result = x * 0xe000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff2000000000l); }
@Test
public void test04458() { x = 0x7fffffff7fffffffl; long result = x * 0xe000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff2000000000l); }
@Test
public void test04459() { x = 0x7fffffff80000000l; long result = x * 0xe000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04460() { x = 0x7fffffffdeadf00dl; long result = x * 0xe000000000l; AssertJUnit.assertEquals("multiply", result, 0xd8320b6000000000l); }
@Test
public void test04461() { x = 0x8000000000000000l; long result = x * 0xe000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04462() { x = 0xffffffffffffffffl; long result = x * 0xe000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff2000000000l); }
@Test
public void test04463() { x = 0xfffffffffffffffel; long result = x * 0xe000000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffe4000000000l); }
@Test
public void test04464() { x = 0xefffffffffffffffl; long result = x * 0xe000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff2000000000l); }
@Test
public void test04465() { x = 0xdeadf00ddeadf00dl; long result = x * 0xe000000000l; AssertJUnit.assertEquals("multiply", result, 0xd8320b6000000000l); }
@Test
public void test04466() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffffe4l; AssertJUnit.assertEquals("multiply", result, 0xfffffff20000001cl); }
@Test
public void test04467() { x = 0x0000000080000000l; long result = x * 0xffffffffffffffe4l; AssertJUnit.assertEquals("multiply", result, 0xfffffff200000000l); }
@Test
public void test04468() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffffe4l; AssertJUnit.assertEquals("multiply", result, 0xffffffe40000001cl); }
@Test
public void test04469() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffffe4l; AssertJUnit.assertEquals("multiply", result, 0xffffffd60000001cl); }
@Test
public void test04470() { x = 0x0000000180000000l; long result = x * 0xffffffffffffffe4l; AssertJUnit.assertEquals("multiply", result, 0xffffffd600000000l); }
@Test
public void test04471() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffffe4l; AssertJUnit.assertEquals("multiply", result, 0xffffffc80000001cl); }
@Test
public void test04472() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffffe4l; AssertJUnit.assertEquals("multiply", result, 0x0000000e0000001cl); }
@Test
public void test04473() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffffe4l; AssertJUnit.assertEquals("multiply", result, 0x0000000e00000000l); }
@Test
public void test04474() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffffe4l; AssertJUnit.assertEquals("multiply", result, 0xffffffcba4f9be94l); }
@Test
public void test04475() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffffe4l; AssertJUnit.assertEquals("multiply", result, 0x00000003a4f9be94l); }
@Test
public void test04476() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffffe4l; AssertJUnit.assertEquals("multiply", result, 0x000000000000001cl); }
@Test
public void test04477() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffffe4l; AssertJUnit.assertEquals("multiply", result, 0x0000000e0000001cl); }
@Test
public void test04478() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffffe4l; AssertJUnit.assertEquals("multiply", result, 0x0000000e00000000l); }
@Test
public void test04479() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffffe4l; AssertJUnit.assertEquals("multiply", result, 0x00000003a4f9be94l); }
@Test
public void test04480() { x = 0x8000000000000000l; long result = x * 0xffffffffffffffe4l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04481() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffffe4l; AssertJUnit.assertEquals("multiply", result, 0x000000000000001cl); }
@Test
public void test04482() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffffe4l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000038l); }
@Test
public void test04483() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffffe4l; AssertJUnit.assertEquals("multiply", result, 0xc00000000000001cl); }
@Test
public void test04484() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffffe4l; AssertJUnit.assertEquals("multiply", result, 0xa4f9be7ba4f9be94l); }
@Test
public void test04485() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffff20l; AssertJUnit.assertEquals("multiply", result, 0xffffff90000000e0l); }
@Test
public void test04486() { x = 0x0000000080000000l; long result = x * 0xffffffffffffff20l; AssertJUnit.assertEquals("multiply", result, 0xffffff9000000000l); }
@Test
public void test04487() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffff20l; AssertJUnit.assertEquals("multiply", result, 0xffffff20000000e0l); }
@Test
public void test04488() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffff20l; AssertJUnit.assertEquals("multiply", result, 0xfffffeb0000000e0l); }
@Test
public void test04489() { x = 0x0000000180000000l; long result = x * 0xffffffffffffff20l; AssertJUnit.assertEquals("multiply", result, 0xfffffeb000000000l); }
@Test
public void test04490() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffff20l; AssertJUnit.assertEquals("multiply", result, 0xfffffe40000000e0l); }
@Test
public void test04491() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffff20l; AssertJUnit.assertEquals("multiply", result, 0x00000070000000e0l); }
@Test
public void test04492() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffff20l; AssertJUnit.assertEquals("multiply", result, 0x0000007000000000l); }
@Test
public void test04493() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffff20l; AssertJUnit.assertEquals("multiply", result, 0xfffffe5d27cdf4a0l); }
@Test
public void test04494() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffff20l; AssertJUnit.assertEquals("multiply", result, 0x0000001d27cdf4a0l); }
@Test
public void test04495() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffff20l; AssertJUnit.assertEquals("multiply", result, 0x00000000000000e0l); }
@Test
public void test04496() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffff20l; AssertJUnit.assertEquals("multiply", result, 0x00000070000000e0l); }
@Test
public void test04497() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffff20l; AssertJUnit.assertEquals("multiply", result, 0x0000007000000000l); }
@Test
public void test04498() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffff20l; AssertJUnit.assertEquals("multiply", result, 0x0000001d27cdf4a0l); }
@Test
public void test04499() { x = 0x8000000000000000l; long result = x * 0xffffffffffffff20l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04500() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffff20l; AssertJUnit.assertEquals("multiply", result, 0x00000000000000e0l); }
@Test
public void test04501() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffff20l; AssertJUnit.assertEquals("multiply", result, 0x00000000000001c0l); }
@Test
public void test04502() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffff20l; AssertJUnit.assertEquals("multiply", result, 0x00000000000000e0l); }
@Test
public void test04503() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffff20l; AssertJUnit.assertEquals("multiply", result, 0x27cdf3dd27cdf4a0l); }
@Test
public void test04504() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffe400l; AssertJUnit.assertEquals("multiply", result, 0xfffff20000001c00l); }
@Test
public void test04505() { x = 0x0000000080000000l; long result = x * 0xffffffffffffe400l; AssertJUnit.assertEquals("multiply", result, 0xfffff20000000000l); }
@Test
public void test04506() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffe400l; AssertJUnit.assertEquals("multiply", result, 0xffffe40000001c00l); }
@Test
public void test04507() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffe400l; AssertJUnit.assertEquals("multiply", result, 0xffffd60000001c00l); }
@Test
public void test04508() { x = 0x0000000180000000l; long result = x * 0xffffffffffffe400l; AssertJUnit.assertEquals("multiply", result, 0xffffd60000000000l); }
@Test
public void test04509() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffe400l; AssertJUnit.assertEquals("multiply", result, 0xffffc80000001c00l); }
@Test
public void test04510() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffe400l; AssertJUnit.assertEquals("multiply", result, 0x00000e0000001c00l); }
@Test
public void test04511() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffe400l; AssertJUnit.assertEquals("multiply", result, 0x00000e0000000000l); }
@Test
public void test04512() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffe400l; AssertJUnit.assertEquals("multiply", result, 0xffffcba4f9be9400l); }
@Test
public void test04513() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffe400l; AssertJUnit.assertEquals("multiply", result, 0x000003a4f9be9400l); }
@Test
public void test04514() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffe400l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001c00l); }
@Test
public void test04515() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffe400l; AssertJUnit.assertEquals("multiply", result, 0x00000e0000001c00l); }
@Test
public void test04516() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffe400l; AssertJUnit.assertEquals("multiply", result, 0x00000e0000000000l); }
@Test
public void test04517() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffe400l; AssertJUnit.assertEquals("multiply", result, 0x000003a4f9be9400l); }
@Test
public void test04518() { x = 0x8000000000000000l; long result = x * 0xffffffffffffe400l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04519() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffe400l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001c00l); }
@Test
public void test04520() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffe400l; AssertJUnit.assertEquals("multiply", result, 0x0000000000003800l); }
@Test
public void test04521() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffe400l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001c00l); }
@Test
public void test04522() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffe400l; AssertJUnit.assertEquals("multiply", result, 0xf9be7ba4f9be9400l); }
@Test
public void test04523() { x = 0x000000007fffffffl; long result = x * 0xffffffe400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001c00000000l); }
@Test
public void test04524() { x = 0x0000000080000000l; long result = x * 0xffffffe400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04525() { x = 0x00000000ffffffffl; long result = x * 0xffffffe400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001c00000000l); }
@Test
public void test04526() { x = 0x000000017fffffffl; long result = x * 0xffffffe400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001c00000000l); }
@Test
public void test04527() { x = 0x0000000180000000l; long result = x * 0xffffffe400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04528() { x = 0x00000001ffffffffl; long result = x * 0xffffffe400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001c00000000l); }
@Test
public void test04529() { x = 0xffffffff7fffffffl; long result = x * 0xffffffe400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001c00000000l); }
@Test
public void test04530() { x = 0xffffffff80000000l; long result = x * 0xffffffe400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04531() { x = 0x00000001deadf00dl; long result = x * 0xffffffe400000000l; AssertJUnit.assertEquals("multiply", result, 0xa4f9be9400000000l); }
@Test
public void test04532() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffe400000000l; AssertJUnit.assertEquals("multiply", result, 0xa4f9be9400000000l); }
@Test
public void test04533() { x = 0x7fffffffffffffffl; long result = x * 0xffffffe400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001c00000000l); }
@Test
public void test04534() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffe400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001c00000000l); }
@Test
public void test04535() { x = 0x7fffffff80000000l; long result = x * 0xffffffe400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04536() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffe400000000l; AssertJUnit.assertEquals("multiply", result, 0xa4f9be9400000000l); }
@Test
public void test04537() { x = 0x8000000000000000l; long result = x * 0xffffffe400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04538() { x = 0xffffffffffffffffl; long result = x * 0xffffffe400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001c00000000l); }
@Test
public void test04539() { x = 0xfffffffffffffffel; long result = x * 0xffffffe400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000003800000000l); }
@Test
public void test04540() { x = 0xefffffffffffffffl; long result = x * 0xffffffe400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001c00000000l); }
@Test
public void test04541() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffe400000000l; AssertJUnit.assertEquals("multiply", result, 0xa4f9be9400000000l); }
@Test
public void test04542() { x = 0x000000007fffffffl; long result = x * 0xffffff2000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000e000000000l); }
@Test
public void test04543() { x = 0x0000000080000000l; long result = x * 0xffffff2000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04544() { x = 0x00000000ffffffffl; long result = x * 0xffffff2000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000e000000000l); }
@Test
public void test04545() { x = 0x000000017fffffffl; long result = x * 0xffffff2000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000e000000000l); }
@Test
public void test04546() { x = 0x0000000180000000l; long result = x * 0xffffff2000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04547() { x = 0x00000001ffffffffl; long result = x * 0xffffff2000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000e000000000l); }
@Test
public void test04548() { x = 0xffffffff7fffffffl; long result = x * 0xffffff2000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000e000000000l); }
@Test
public void test04549() { x = 0xffffffff80000000l; long result = x * 0xffffff2000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04550() { x = 0x00000001deadf00dl; long result = x * 0xffffff2000000000l; AssertJUnit.assertEquals("multiply", result, 0x27cdf4a000000000l); }
@Test
public void test04551() { x = 0xffffffffdeadf00dl; long result = x * 0xffffff2000000000l; AssertJUnit.assertEquals("multiply", result, 0x27cdf4a000000000l); }
@Test
public void test04552() { x = 0x7fffffffffffffffl; long result = x * 0xffffff2000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000e000000000l); }
@Test
public void test04553() { x = 0x7fffffff7fffffffl; long result = x * 0xffffff2000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000e000000000l); }
@Test
public void test04554() { x = 0x7fffffff80000000l; long result = x * 0xffffff2000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04555() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffff2000000000l; AssertJUnit.assertEquals("multiply", result, 0x27cdf4a000000000l); }
@Test
public void test04556() { x = 0x8000000000000000l; long result = x * 0xffffff2000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04557() { x = 0xffffffffffffffffl; long result = x * 0xffffff2000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000e000000000l); }
@Test
public void test04558() { x = 0xfffffffffffffffel; long result = x * 0xffffff2000000000l; AssertJUnit.assertEquals("multiply", result, 0x000001c000000000l); }
@Test
public void test04559() { x = 0xefffffffffffffffl; long result = x * 0xffffff2000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000e000000000l); }
@Test
public void test04560() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffff2000000000l; AssertJUnit.assertEquals("multiply", result, 0x27cdf4a000000000l); }
@Test
public void test04561() { x = 0x000000007fffffffl; long result = x * 0x1dl; AssertJUnit.assertEquals("multiply", result, 0x0000000e7fffffe3l); }
@Test
public void test04562() { x = 0x0000000080000000l; long result = x * 0x1dl; AssertJUnit.assertEquals("multiply", result, 0x0000000e80000000l); }
@Test
public void test04563() { x = 0x00000000ffffffffl; long result = x * 0x1dl; AssertJUnit.assertEquals("multiply", result, 0x0000001cffffffe3l); }
@Test
public void test04564() { x = 0x000000017fffffffl; long result = x * 0x1dl; AssertJUnit.assertEquals("multiply", result, 0x0000002b7fffffe3l); }
@Test
public void test04565() { x = 0x0000000180000000l; long result = x * 0x1dl; AssertJUnit.assertEquals("multiply", result, 0x0000002b80000000l); }
@Test
public void test04566() { x = 0x00000001ffffffffl; long result = x * 0x1dl; AssertJUnit.assertEquals("multiply", result, 0x00000039ffffffe3l); }
@Test
public void test04567() { x = 0xffffffff7fffffffl; long result = x * 0x1dl; AssertJUnit.assertEquals("multiply", result, 0xfffffff17fffffe3l); }
@Test
public void test04568() { x = 0xffffffff80000000l; long result = x * 0x1dl; AssertJUnit.assertEquals("multiply", result, 0xfffffff180000000l); }
@Test
public void test04569() { x = 0x00000001deadf00dl; long result = x * 0x1dl; AssertJUnit.assertEquals("multiply", result, 0x0000003639b43179l); }
@Test
public void test04570() { x = 0xffffffffdeadf00dl; long result = x * 0x1dl; AssertJUnit.assertEquals("multiply", result, 0xfffffffc39b43179l); }
@Test
public void test04571() { x = 0x7fffffffffffffffl; long result = x * 0x1dl; AssertJUnit.assertEquals("multiply", result, 0x7fffffffffffffe3l); }
@Test
public void test04572() { x = 0x7fffffff7fffffffl; long result = x * 0x1dl; AssertJUnit.assertEquals("multiply", result, 0x7ffffff17fffffe3l); }
@Test
public void test04573() { x = 0x7fffffff80000000l; long result = x * 0x1dl; AssertJUnit.assertEquals("multiply", result, 0x7ffffff180000000l); }
@Test
public void test04574() { x = 0x7fffffffdeadf00dl; long result = x * 0x1dl; AssertJUnit.assertEquals("multiply", result, 0x7ffffffc39b43179l); }
@Test
public void test04575() { x = 0x8000000000000000l; long result = x * 0x1dl; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test04576() { x = 0xffffffffffffffffl; long result = x * 0x1dl; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffe3l); }
@Test
public void test04577() { x = 0xfffffffffffffffel; long result = x * 0x1dl; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffc6l); }
@Test
public void test04578() { x = 0xefffffffffffffffl; long result = x * 0x1dl; AssertJUnit.assertEquals("multiply", result, 0x2fffffffffffffe3l); }
@Test
public void test04579() { x = 0xdeadf00ddeadf00dl; long result = x * 0x1dl; AssertJUnit.assertEquals("multiply", result, 0x39b4319239b43179l); }
@Test
public void test04580() { x = 0x000000007fffffffl; long result = x * 0xe8l; AssertJUnit.assertEquals("multiply", result, 0x00000073ffffff18l); }
@Test
public void test04581() { x = 0x0000000080000000l; long result = x * 0xe8l; AssertJUnit.assertEquals("multiply", result, 0x0000007400000000l); }
@Test
public void test04582() { x = 0x00000000ffffffffl; long result = x * 0xe8l; AssertJUnit.assertEquals("multiply", result, 0x000000e7ffffff18l); }
@Test
public void test04583() { x = 0x000000017fffffffl; long result = x * 0xe8l; AssertJUnit.assertEquals("multiply", result, 0x0000015bffffff18l); }
@Test
public void test04584() { x = 0x0000000180000000l; long result = x * 0xe8l; AssertJUnit.assertEquals("multiply", result, 0x0000015c00000000l); }
@Test
public void test04585() { x = 0x00000001ffffffffl; long result = x * 0xe8l; AssertJUnit.assertEquals("multiply", result, 0x000001cfffffff18l); }
@Test
public void test04586() { x = 0xffffffff7fffffffl; long result = x * 0xe8l; AssertJUnit.assertEquals("multiply", result, 0xffffff8bffffff18l); }
@Test
public void test04587() { x = 0xffffffff80000000l; long result = x * 0xe8l; AssertJUnit.assertEquals("multiply", result, 0xffffff8c00000000l); }
@Test
public void test04588() { x = 0x00000001deadf00dl; long result = x * 0xe8l; AssertJUnit.assertEquals("multiply", result, 0x000001b1cda18bc8l); }
@Test
public void test04589() { x = 0xffffffffdeadf00dl; long result = x * 0xe8l; AssertJUnit.assertEquals("multiply", result, 0xffffffe1cda18bc8l); }
@Test
public void test04590() { x = 0x7fffffffffffffffl; long result = x * 0xe8l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff18l); }
@Test
public void test04591() { x = 0x7fffffff7fffffffl; long result = x * 0xe8l; AssertJUnit.assertEquals("multiply", result, 0xffffff8bffffff18l); }
@Test
public void test04592() { x = 0x7fffffff80000000l; long result = x * 0xe8l; AssertJUnit.assertEquals("multiply", result, 0xffffff8c00000000l); }
@Test
public void test04593() { x = 0x7fffffffdeadf00dl; long result = x * 0xe8l; AssertJUnit.assertEquals("multiply", result, 0xffffffe1cda18bc8l); }
@Test
public void test04594() { x = 0x8000000000000000l; long result = x * 0xe8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04595() { x = 0xffffffffffffffffl; long result = x * 0xe8l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff18l); }
@Test
public void test04596() { x = 0xfffffffffffffffel; long result = x * 0xe8l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffe30l); }
@Test
public void test04597() { x = 0xefffffffffffffffl; long result = x * 0xe8l; AssertJUnit.assertEquals("multiply", result, 0x7fffffffffffff18l); }
@Test
public void test04598() { x = 0xdeadf00ddeadf00dl; long result = x * 0xe8l; AssertJUnit.assertEquals("multiply", result, 0xcda18c91cda18bc8l); }
@Test
public void test04599() { x = 0x000000007fffffffl; long result = x * 0x1d00l; AssertJUnit.assertEquals("multiply", result, 0x00000e7fffffe300l); }
@Test
public void test04600() { x = 0x0000000080000000l; long result = x * 0x1d00l; AssertJUnit.assertEquals("multiply", result, 0x00000e8000000000l); }
@Test
public void test04601() { x = 0x00000000ffffffffl; long result = x * 0x1d00l; AssertJUnit.assertEquals("multiply", result, 0x00001cffffffe300l); }
@Test
public void test04602() { x = 0x000000017fffffffl; long result = x * 0x1d00l; AssertJUnit.assertEquals("multiply", result, 0x00002b7fffffe300l); }
@Test
public void test04603() { x = 0x0000000180000000l; long result = x * 0x1d00l; AssertJUnit.assertEquals("multiply", result, 0x00002b8000000000l); }
@Test
public void test04604() { x = 0x00000001ffffffffl; long result = x * 0x1d00l; AssertJUnit.assertEquals("multiply", result, 0x000039ffffffe300l); }
@Test
public void test04605() { x = 0xffffffff7fffffffl; long result = x * 0x1d00l; AssertJUnit.assertEquals("multiply", result, 0xfffff17fffffe300l); }
@Test
public void test04606() { x = 0xffffffff80000000l; long result = x * 0x1d00l; AssertJUnit.assertEquals("multiply", result, 0xfffff18000000000l); }
@Test
public void test04607() { x = 0x00000001deadf00dl; long result = x * 0x1d00l; AssertJUnit.assertEquals("multiply", result, 0x00003639b4317900l); }
@Test
public void test04608() { x = 0xffffffffdeadf00dl; long result = x * 0x1d00l; AssertJUnit.assertEquals("multiply", result, 0xfffffc39b4317900l); }
@Test
public void test04609() { x = 0x7fffffffffffffffl; long result = x * 0x1d00l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffe300l); }
@Test
public void test04610() { x = 0x7fffffff7fffffffl; long result = x * 0x1d00l; AssertJUnit.assertEquals("multiply", result, 0xfffff17fffffe300l); }
@Test
public void test04611() { x = 0x7fffffff80000000l; long result = x * 0x1d00l; AssertJUnit.assertEquals("multiply", result, 0xfffff18000000000l); }
@Test
public void test04612() { x = 0x7fffffffdeadf00dl; long result = x * 0x1d00l; AssertJUnit.assertEquals("multiply", result, 0xfffffc39b4317900l); }
@Test
public void test04613() { x = 0x8000000000000000l; long result = x * 0x1d00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04614() { x = 0xffffffffffffffffl; long result = x * 0x1d00l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffe300l); }
@Test
public void test04615() { x = 0xfffffffffffffffel; long result = x * 0x1d00l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffc600l); }
@Test
public void test04616() { x = 0xefffffffffffffffl; long result = x * 0x1d00l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffe300l); }
@Test
public void test04617() { x = 0xdeadf00ddeadf00dl; long result = x * 0x1d00l; AssertJUnit.assertEquals("multiply", result, 0xb4319239b4317900l); }
@Test
public void test04618() { x = 0x000000007fffffffl; long result = x * 0x1d00000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffe300000000l); }
@Test
public void test04619() { x = 0x0000000080000000l; long result = x * 0x1d00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test04620() { x = 0x00000000ffffffffl; long result = x * 0x1d00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe300000000l); }
@Test
public void test04621() { x = 0x000000017fffffffl; long result = x * 0x1d00000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffe300000000l); }
@Test
public void test04622() { x = 0x0000000180000000l; long result = x * 0x1d00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test04623() { x = 0x00000001ffffffffl; long result = x * 0x1d00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe300000000l); }
@Test
public void test04624() { x = 0xffffffff7fffffffl; long result = x * 0x1d00000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffe300000000l); }
@Test
public void test04625() { x = 0xffffffff80000000l; long result = x * 0x1d00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test04626() { x = 0x00000001deadf00dl; long result = x * 0x1d00000000l; AssertJUnit.assertEquals("multiply", result, 0x39b4317900000000l); }
@Test
public void test04627() { x = 0xffffffffdeadf00dl; long result = x * 0x1d00000000l; AssertJUnit.assertEquals("multiply", result, 0x39b4317900000000l); }
@Test
public void test04628() { x = 0x7fffffffffffffffl; long result = x * 0x1d00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe300000000l); }
@Test
public void test04629() { x = 0x7fffffff7fffffffl; long result = x * 0x1d00000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffe300000000l); }
@Test
public void test04630() { x = 0x7fffffff80000000l; long result = x * 0x1d00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test04631() { x = 0x7fffffffdeadf00dl; long result = x * 0x1d00000000l; AssertJUnit.assertEquals("multiply", result, 0x39b4317900000000l); }
@Test
public void test04632() { x = 0x8000000000000000l; long result = x * 0x1d00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04633() { x = 0xffffffffffffffffl; long result = x * 0x1d00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe300000000l); }
@Test
public void test04634() { x = 0xfffffffffffffffel; long result = x * 0x1d00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffc600000000l); }
@Test
public void test04635() { x = 0xefffffffffffffffl; long result = x * 0x1d00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe300000000l); }
@Test
public void test04636() { x = 0xdeadf00ddeadf00dl; long result = x * 0x1d00000000l; AssertJUnit.assertEquals("multiply", result, 0x39b4317900000000l); }
@Test
public void test04637() { x = 0x000000007fffffffl; long result = x * 0xe800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff1800000000l); }
@Test
public void test04638() { x = 0x0000000080000000l; long result = x * 0xe800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04639() { x = 0x00000000ffffffffl; long result = x * 0xe800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff1800000000l); }
@Test
public void test04640() { x = 0x000000017fffffffl; long result = x * 0xe800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff1800000000l); }
@Test
public void test04641() { x = 0x0000000180000000l; long result = x * 0xe800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04642() { x = 0x00000001ffffffffl; long result = x * 0xe800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff1800000000l); }
@Test
public void test04643() { x = 0xffffffff7fffffffl; long result = x * 0xe800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff1800000000l); }
@Test
public void test04644() { x = 0xffffffff80000000l; long result = x * 0xe800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04645() { x = 0x00000001deadf00dl; long result = x * 0xe800000000l; AssertJUnit.assertEquals("multiply", result, 0xcda18bc800000000l); }
@Test
public void test04646() { x = 0xffffffffdeadf00dl; long result = x * 0xe800000000l; AssertJUnit.assertEquals("multiply", result, 0xcda18bc800000000l); }
@Test
public void test04647() { x = 0x7fffffffffffffffl; long result = x * 0xe800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff1800000000l); }
@Test
public void test04648() { x = 0x7fffffff7fffffffl; long result = x * 0xe800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff1800000000l); }
@Test
public void test04649() { x = 0x7fffffff80000000l; long result = x * 0xe800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04650() { x = 0x7fffffffdeadf00dl; long result = x * 0xe800000000l; AssertJUnit.assertEquals("multiply", result, 0xcda18bc800000000l); }
@Test
public void test04651() { x = 0x8000000000000000l; long result = x * 0xe800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04652() { x = 0xffffffffffffffffl; long result = x * 0xe800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff1800000000l); }
@Test
public void test04653() { x = 0xfffffffffffffffel; long result = x * 0xe800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffe3000000000l); }
@Test
public void test04654() { x = 0xefffffffffffffffl; long result = x * 0xe800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff1800000000l); }
@Test
public void test04655() { x = 0xdeadf00ddeadf00dl; long result = x * 0xe800000000l; AssertJUnit.assertEquals("multiply", result, 0xcda18bc800000000l); }
@Test
public void test04656() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffffe3l; AssertJUnit.assertEquals("multiply", result, 0xfffffff18000001dl); }
@Test
public void test04657() { x = 0x0000000080000000l; long result = x * 0xffffffffffffffe3l; AssertJUnit.assertEquals("multiply", result, 0xfffffff180000000l); }
@Test
public void test04658() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffffe3l; AssertJUnit.assertEquals("multiply", result, 0xffffffe30000001dl); }
@Test
public void test04659() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffffe3l; AssertJUnit.assertEquals("multiply", result, 0xffffffd48000001dl); }
@Test
public void test04660() { x = 0x0000000180000000l; long result = x * 0xffffffffffffffe3l; AssertJUnit.assertEquals("multiply", result, 0xffffffd480000000l); }
@Test
public void test04661() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffffe3l; AssertJUnit.assertEquals("multiply", result, 0xffffffc60000001dl); }
@Test
public void test04662() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffffe3l; AssertJUnit.assertEquals("multiply", result, 0x0000000e8000001dl); }
@Test
public void test04663() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffffe3l; AssertJUnit.assertEquals("multiply", result, 0x0000000e80000000l); }
@Test
public void test04664() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffffe3l; AssertJUnit.assertEquals("multiply", result, 0xffffffc9c64bce87l); }
@Test
public void test04665() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffffe3l; AssertJUnit.assertEquals("multiply", result, 0x00000003c64bce87l); }
@Test
public void test04666() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffffe3l; AssertJUnit.assertEquals("multiply", result, 0x800000000000001dl); }
@Test
public void test04667() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffffe3l; AssertJUnit.assertEquals("multiply", result, 0x8000000e8000001dl); }
@Test
public void test04668() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffffe3l; AssertJUnit.assertEquals("multiply", result, 0x8000000e80000000l); }
@Test
public void test04669() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffffe3l; AssertJUnit.assertEquals("multiply", result, 0x80000003c64bce87l); }
@Test
public void test04670() { x = 0x8000000000000000l; long result = x * 0xffffffffffffffe3l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test04671() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffffe3l; AssertJUnit.assertEquals("multiply", result, 0x000000000000001dl); }
@Test
public void test04672() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffffe3l; AssertJUnit.assertEquals("multiply", result, 0x000000000000003al); }
@Test
public void test04673() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffffe3l; AssertJUnit.assertEquals("multiply", result, 0xd00000000000001dl); }
@Test
public void test04674() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffffe3l; AssertJUnit.assertEquals("multiply", result, 0xc64bce6dc64bce87l); }
@Test
public void test04675() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffff18l; AssertJUnit.assertEquals("multiply", result, 0xffffff8c000000e8l); }
@Test
public void test04676() { x = 0x0000000080000000l; long result = x * 0xffffffffffffff18l; AssertJUnit.assertEquals("multiply", result, 0xffffff8c00000000l); }
@Test
public void test04677() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffff18l; AssertJUnit.assertEquals("multiply", result, 0xffffff18000000e8l); }
@Test
public void test04678() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffff18l; AssertJUnit.assertEquals("multiply", result, 0xfffffea4000000e8l); }
@Test
public void test04679() { x = 0x0000000180000000l; long result = x * 0xffffffffffffff18l; AssertJUnit.assertEquals("multiply", result, 0xfffffea400000000l); }
@Test
public void test04680() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffff18l; AssertJUnit.assertEquals("multiply", result, 0xfffffe30000000e8l); }
@Test
public void test04681() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffff18l; AssertJUnit.assertEquals("multiply", result, 0x00000074000000e8l); }
@Test
public void test04682() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffff18l; AssertJUnit.assertEquals("multiply", result, 0x0000007400000000l); }
@Test
public void test04683() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffff18l; AssertJUnit.assertEquals("multiply", result, 0xfffffe4e325e7438l); }
@Test
public void test04684() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffff18l; AssertJUnit.assertEquals("multiply", result, 0x0000001e325e7438l); }
@Test
public void test04685() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffff18l; AssertJUnit.assertEquals("multiply", result, 0x00000000000000e8l); }
@Test
public void test04686() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffff18l; AssertJUnit.assertEquals("multiply", result, 0x00000074000000e8l); }
@Test
public void test04687() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffff18l; AssertJUnit.assertEquals("multiply", result, 0x0000007400000000l); }
@Test
public void test04688() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffff18l; AssertJUnit.assertEquals("multiply", result, 0x0000001e325e7438l); }
@Test
public void test04689() { x = 0x8000000000000000l; long result = x * 0xffffffffffffff18l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04690() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffff18l; AssertJUnit.assertEquals("multiply", result, 0x00000000000000e8l); }
@Test
public void test04691() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffff18l; AssertJUnit.assertEquals("multiply", result, 0x00000000000001d0l); }
@Test
public void test04692() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffff18l; AssertJUnit.assertEquals("multiply", result, 0x80000000000000e8l); }
@Test
public void test04693() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffff18l; AssertJUnit.assertEquals("multiply", result, 0x325e736e325e7438l); }
@Test
public void test04694() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffe300l; AssertJUnit.assertEquals("multiply", result, 0xfffff18000001d00l); }
@Test
public void test04695() { x = 0x0000000080000000l; long result = x * 0xffffffffffffe300l; AssertJUnit.assertEquals("multiply", result, 0xfffff18000000000l); }
@Test
public void test04696() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffe300l; AssertJUnit.assertEquals("multiply", result, 0xffffe30000001d00l); }
@Test
public void test04697() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffe300l; AssertJUnit.assertEquals("multiply", result, 0xffffd48000001d00l); }
@Test
public void test04698() { x = 0x0000000180000000l; long result = x * 0xffffffffffffe300l; AssertJUnit.assertEquals("multiply", result, 0xffffd48000000000l); }
@Test
public void test04699() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffe300l; AssertJUnit.assertEquals("multiply", result, 0xffffc60000001d00l); }
@Test
public void test04700() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffe300l; AssertJUnit.assertEquals("multiply", result, 0x00000e8000001d00l); }
@Test
public void test04701() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffe300l; AssertJUnit.assertEquals("multiply", result, 0x00000e8000000000l); }
@Test
public void test04702() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffe300l; AssertJUnit.assertEquals("multiply", result, 0xffffc9c64bce8700l); }
@Test
public void test04703() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffe300l; AssertJUnit.assertEquals("multiply", result, 0x000003c64bce8700l); }
@Test
public void test04704() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffe300l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001d00l); }
@Test
public void test04705() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffe300l; AssertJUnit.assertEquals("multiply", result, 0x00000e8000001d00l); }
@Test
public void test04706() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffe300l; AssertJUnit.assertEquals("multiply", result, 0x00000e8000000000l); }
@Test
public void test04707() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffe300l; AssertJUnit.assertEquals("multiply", result, 0x000003c64bce8700l); }
@Test
public void test04708() { x = 0x8000000000000000l; long result = x * 0xffffffffffffe300l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04709() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffe300l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001d00l); }
@Test
public void test04710() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffe300l; AssertJUnit.assertEquals("multiply", result, 0x0000000000003a00l); }
@Test
public void test04711() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffe300l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001d00l); }
@Test
public void test04712() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffe300l; AssertJUnit.assertEquals("multiply", result, 0x4bce6dc64bce8700l); }
@Test
public void test04713() { x = 0x000000007fffffffl; long result = x * 0xffffffe300000000l; AssertJUnit.assertEquals("multiply", result, 0x8000001d00000000l); }
@Test
public void test04714() { x = 0x0000000080000000l; long result = x * 0xffffffe300000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test04715() { x = 0x00000000ffffffffl; long result = x * 0xffffffe300000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001d00000000l); }
@Test
public void test04716() { x = 0x000000017fffffffl; long result = x * 0xffffffe300000000l; AssertJUnit.assertEquals("multiply", result, 0x8000001d00000000l); }
@Test
public void test04717() { x = 0x0000000180000000l; long result = x * 0xffffffe300000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test04718() { x = 0x00000001ffffffffl; long result = x * 0xffffffe300000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001d00000000l); }
@Test
public void test04719() { x = 0xffffffff7fffffffl; long result = x * 0xffffffe300000000l; AssertJUnit.assertEquals("multiply", result, 0x8000001d00000000l); }
@Test
public void test04720() { x = 0xffffffff80000000l; long result = x * 0xffffffe300000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test04721() { x = 0x00000001deadf00dl; long result = x * 0xffffffe300000000l; AssertJUnit.assertEquals("multiply", result, 0xc64bce8700000000l); }
@Test
public void test04722() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffe300000000l; AssertJUnit.assertEquals("multiply", result, 0xc64bce8700000000l); }
@Test
public void test04723() { x = 0x7fffffffffffffffl; long result = x * 0xffffffe300000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001d00000000l); }
@Test
public void test04724() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffe300000000l; AssertJUnit.assertEquals("multiply", result, 0x8000001d00000000l); }
@Test
public void test04725() { x = 0x7fffffff80000000l; long result = x * 0xffffffe300000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test04726() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffe300000000l; AssertJUnit.assertEquals("multiply", result, 0xc64bce8700000000l); }
@Test
public void test04727() { x = 0x8000000000000000l; long result = x * 0xffffffe300000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04728() { x = 0xffffffffffffffffl; long result = x * 0xffffffe300000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001d00000000l); }
@Test
public void test04729() { x = 0xfffffffffffffffel; long result = x * 0xffffffe300000000l; AssertJUnit.assertEquals("multiply", result, 0x0000003a00000000l); }
@Test
public void test04730() { x = 0xefffffffffffffffl; long result = x * 0xffffffe300000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001d00000000l); }
@Test
public void test04731() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffe300000000l; AssertJUnit.assertEquals("multiply", result, 0xc64bce8700000000l); }
@Test
public void test04732() { x = 0x000000007fffffffl; long result = x * 0xffffff1800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000e800000000l); }
@Test
public void test04733() { x = 0x0000000080000000l; long result = x * 0xffffff1800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04734() { x = 0x00000000ffffffffl; long result = x * 0xffffff1800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000e800000000l); }
@Test
public void test04735() { x = 0x000000017fffffffl; long result = x * 0xffffff1800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000e800000000l); }
@Test
public void test04736() { x = 0x0000000180000000l; long result = x * 0xffffff1800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04737() { x = 0x00000001ffffffffl; long result = x * 0xffffff1800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000e800000000l); }
@Test
public void test04738() { x = 0xffffffff7fffffffl; long result = x * 0xffffff1800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000e800000000l); }
@Test
public void test04739() { x = 0xffffffff80000000l; long result = x * 0xffffff1800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04740() { x = 0x00000001deadf00dl; long result = x * 0xffffff1800000000l; AssertJUnit.assertEquals("multiply", result, 0x325e743800000000l); }
@Test
public void test04741() { x = 0xffffffffdeadf00dl; long result = x * 0xffffff1800000000l; AssertJUnit.assertEquals("multiply", result, 0x325e743800000000l); }
@Test
public void test04742() { x = 0x7fffffffffffffffl; long result = x * 0xffffff1800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000e800000000l); }
@Test
public void test04743() { x = 0x7fffffff7fffffffl; long result = x * 0xffffff1800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000e800000000l); }
@Test
public void test04744() { x = 0x7fffffff80000000l; long result = x * 0xffffff1800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04745() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffff1800000000l; AssertJUnit.assertEquals("multiply", result, 0x325e743800000000l); }
@Test
public void test04746() { x = 0x8000000000000000l; long result = x * 0xffffff1800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04747() { x = 0xffffffffffffffffl; long result = x * 0xffffff1800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000e800000000l); }
@Test
public void test04748() { x = 0xfffffffffffffffel; long result = x * 0xffffff1800000000l; AssertJUnit.assertEquals("multiply", result, 0x000001d000000000l); }
@Test
public void test04749() { x = 0xefffffffffffffffl; long result = x * 0xffffff1800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000e800000000l); }
@Test
public void test04750() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffff1800000000l; AssertJUnit.assertEquals("multiply", result, 0x325e743800000000l); }
@Test
public void test04751() { x = 0x000000007fffffffl; long result = x * 0x1el; AssertJUnit.assertEquals("multiply", result, 0x0000000effffffe2l); }
@Test
public void test04752() { x = 0x0000000080000000l; long result = x * 0x1el; AssertJUnit.assertEquals("multiply", result, 0x0000000f00000000l); }
@Test
public void test04753() { x = 0x00000000ffffffffl; long result = x * 0x1el; AssertJUnit.assertEquals("multiply", result, 0x0000001dffffffe2l); }
@Test
public void test04754() { x = 0x000000017fffffffl; long result = x * 0x1el; AssertJUnit.assertEquals("multiply", result, 0x0000002cffffffe2l); }
@Test
public void test04755() { x = 0x0000000180000000l; long result = x * 0x1el; AssertJUnit.assertEquals("multiply", result, 0x0000002d00000000l); }
@Test
public void test04756() { x = 0x00000001ffffffffl; long result = x * 0x1el; AssertJUnit.assertEquals("multiply", result, 0x0000003bffffffe2l); }
@Test
public void test04757() { x = 0xffffffff7fffffffl; long result = x * 0x1el; AssertJUnit.assertEquals("multiply", result, 0xfffffff0ffffffe2l); }
@Test
public void test04758() { x = 0xffffffff80000000l; long result = x * 0x1el; AssertJUnit.assertEquals("multiply", result, 0xfffffff100000000l); }
@Test
public void test04759() { x = 0x00000001deadf00dl; long result = x * 0x1el; AssertJUnit.assertEquals("multiply", result, 0x0000003818622186l); }
@Test
public void test04760() { x = 0xffffffffdeadf00dl; long result = x * 0x1el; AssertJUnit.assertEquals("multiply", result, 0xfffffffc18622186l); }
@Test
public void test04761() { x = 0x7fffffffffffffffl; long result = x * 0x1el; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffe2l); }
@Test
public void test04762() { x = 0x7fffffff7fffffffl; long result = x * 0x1el; AssertJUnit.assertEquals("multiply", result, 0xfffffff0ffffffe2l); }
@Test
public void test04763() { x = 0x7fffffff80000000l; long result = x * 0x1el; AssertJUnit.assertEquals("multiply", result, 0xfffffff100000000l); }
@Test
public void test04764() { x = 0x7fffffffdeadf00dl; long result = x * 0x1el; AssertJUnit.assertEquals("multiply", result, 0xfffffffc18622186l); }
@Test
public void test04765() { x = 0x8000000000000000l; long result = x * 0x1el; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04766() { x = 0xffffffffffffffffl; long result = x * 0x1el; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffe2l); }
@Test
public void test04767() { x = 0xfffffffffffffffel; long result = x * 0x1el; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffc4l); }
@Test
public void test04768() { x = 0xefffffffffffffffl; long result = x * 0x1el; AssertJUnit.assertEquals("multiply", result, 0x1fffffffffffffe2l); }
@Test
public void test04769() { x = 0xdeadf00ddeadf00dl; long result = x * 0x1el; AssertJUnit.assertEquals("multiply", result, 0x186221a018622186l); }
@Test
public void test04770() { x = 0x000000007fffffffl; long result = x * 0xf0l; AssertJUnit.assertEquals("multiply", result, 0x00000077ffffff10l); }
@Test
public void test04771() { x = 0x0000000080000000l; long result = x * 0xf0l; AssertJUnit.assertEquals("multiply", result, 0x0000007800000000l); }
@Test
public void test04772() { x = 0x00000000ffffffffl; long result = x * 0xf0l; AssertJUnit.assertEquals("multiply", result, 0x000000efffffff10l); }
@Test
public void test04773() { x = 0x000000017fffffffl; long result = x * 0xf0l; AssertJUnit.assertEquals("multiply", result, 0x00000167ffffff10l); }
@Test
public void test04774() { x = 0x0000000180000000l; long result = x * 0xf0l; AssertJUnit.assertEquals("multiply", result, 0x0000016800000000l); }
@Test
public void test04775() { x = 0x00000001ffffffffl; long result = x * 0xf0l; AssertJUnit.assertEquals("multiply", result, 0x000001dfffffff10l); }
@Test
public void test04776() { x = 0xffffffff7fffffffl; long result = x * 0xf0l; AssertJUnit.assertEquals("multiply", result, 0xffffff87ffffff10l); }
@Test
public void test04777() { x = 0xffffffff80000000l; long result = x * 0xf0l; AssertJUnit.assertEquals("multiply", result, 0xffffff8800000000l); }
@Test
public void test04778() { x = 0x00000001deadf00dl; long result = x * 0xf0l; AssertJUnit.assertEquals("multiply", result, 0x000001c0c3110c30l); }
@Test
public void test04779() { x = 0xffffffffdeadf00dl; long result = x * 0xf0l; AssertJUnit.assertEquals("multiply", result, 0xffffffe0c3110c30l); }
@Test
public void test04780() { x = 0x7fffffffffffffffl; long result = x * 0xf0l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff10l); }
@Test
public void test04781() { x = 0x7fffffff7fffffffl; long result = x * 0xf0l; AssertJUnit.assertEquals("multiply", result, 0xffffff87ffffff10l); }
@Test
public void test04782() { x = 0x7fffffff80000000l; long result = x * 0xf0l; AssertJUnit.assertEquals("multiply", result, 0xffffff8800000000l); }
@Test
public void test04783() { x = 0x7fffffffdeadf00dl; long result = x * 0xf0l; AssertJUnit.assertEquals("multiply", result, 0xffffffe0c3110c30l); }
@Test
public void test04784() { x = 0x8000000000000000l; long result = x * 0xf0l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04785() { x = 0xffffffffffffffffl; long result = x * 0xf0l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff10l); }
@Test
public void test04786() { x = 0xfffffffffffffffel; long result = x * 0xf0l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffe20l); }
@Test
public void test04787() { x = 0xefffffffffffffffl; long result = x * 0xf0l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff10l); }
@Test
public void test04788() { x = 0xdeadf00ddeadf00dl; long result = x * 0xf0l; AssertJUnit.assertEquals("multiply", result, 0xc3110d00c3110c30l); }
@Test
public void test04789() { x = 0x000000007fffffffl; long result = x * 0x1e00l; AssertJUnit.assertEquals("multiply", result, 0x00000effffffe200l); }
@Test
public void test04790() { x = 0x0000000080000000l; long result = x * 0x1e00l; AssertJUnit.assertEquals("multiply", result, 0x00000f0000000000l); }
@Test
public void test04791() { x = 0x00000000ffffffffl; long result = x * 0x1e00l; AssertJUnit.assertEquals("multiply", result, 0x00001dffffffe200l); }
@Test
public void test04792() { x = 0x000000017fffffffl; long result = x * 0x1e00l; AssertJUnit.assertEquals("multiply", result, 0x00002cffffffe200l); }
@Test
public void test04793() { x = 0x0000000180000000l; long result = x * 0x1e00l; AssertJUnit.assertEquals("multiply", result, 0x00002d0000000000l); }
@Test
public void test04794() { x = 0x00000001ffffffffl; long result = x * 0x1e00l; AssertJUnit.assertEquals("multiply", result, 0x00003bffffffe200l); }
@Test
public void test04795() { x = 0xffffffff7fffffffl; long result = x * 0x1e00l; AssertJUnit.assertEquals("multiply", result, 0xfffff0ffffffe200l); }
@Test
public void test04796() { x = 0xffffffff80000000l; long result = x * 0x1e00l; AssertJUnit.assertEquals("multiply", result, 0xfffff10000000000l); }
@Test
public void test04797() { x = 0x00000001deadf00dl; long result = x * 0x1e00l; AssertJUnit.assertEquals("multiply", result, 0x0000381862218600l); }
@Test
public void test04798() { x = 0xffffffffdeadf00dl; long result = x * 0x1e00l; AssertJUnit.assertEquals("multiply", result, 0xfffffc1862218600l); }
@Test
public void test04799() { x = 0x7fffffffffffffffl; long result = x * 0x1e00l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffe200l); }
@Test
public void test04800() { x = 0x7fffffff7fffffffl; long result = x * 0x1e00l; AssertJUnit.assertEquals("multiply", result, 0xfffff0ffffffe200l); }
@Test
public void test04801() { x = 0x7fffffff80000000l; long result = x * 0x1e00l; AssertJUnit.assertEquals("multiply", result, 0xfffff10000000000l); }
@Test
public void test04802() { x = 0x7fffffffdeadf00dl; long result = x * 0x1e00l; AssertJUnit.assertEquals("multiply", result, 0xfffffc1862218600l); }
@Test
public void test04803() { x = 0x8000000000000000l; long result = x * 0x1e00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04804() { x = 0xffffffffffffffffl; long result = x * 0x1e00l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffe200l); }
@Test
public void test04805() { x = 0xfffffffffffffffel; long result = x * 0x1e00l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffc400l); }
@Test
public void test04806() { x = 0xefffffffffffffffl; long result = x * 0x1e00l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffe200l); }
@Test
public void test04807() { x = 0xdeadf00ddeadf00dl; long result = x * 0x1e00l; AssertJUnit.assertEquals("multiply", result, 0x6221a01862218600l); }
@Test
public void test04808() { x = 0x000000007fffffffl; long result = x * 0x1e00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe200000000l); }
@Test
public void test04809() { x = 0x0000000080000000l; long result = x * 0x1e00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04810() { x = 0x00000000ffffffffl; long result = x * 0x1e00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe200000000l); }
@Test
public void test04811() { x = 0x000000017fffffffl; long result = x * 0x1e00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe200000000l); }
@Test
public void test04812() { x = 0x0000000180000000l; long result = x * 0x1e00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04813() { x = 0x00000001ffffffffl; long result = x * 0x1e00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe200000000l); }
@Test
public void test04814() { x = 0xffffffff7fffffffl; long result = x * 0x1e00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe200000000l); }
@Test
public void test04815() { x = 0xffffffff80000000l; long result = x * 0x1e00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04816() { x = 0x00000001deadf00dl; long result = x * 0x1e00000000l; AssertJUnit.assertEquals("multiply", result, 0x1862218600000000l); }
@Test
public void test04817() { x = 0xffffffffdeadf00dl; long result = x * 0x1e00000000l; AssertJUnit.assertEquals("multiply", result, 0x1862218600000000l); }
@Test
public void test04818() { x = 0x7fffffffffffffffl; long result = x * 0x1e00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe200000000l); }
@Test
public void test04819() { x = 0x7fffffff7fffffffl; long result = x * 0x1e00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe200000000l); }
@Test
public void test04820() { x = 0x7fffffff80000000l; long result = x * 0x1e00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04821() { x = 0x7fffffffdeadf00dl; long result = x * 0x1e00000000l; AssertJUnit.assertEquals("multiply", result, 0x1862218600000000l); }
@Test
public void test04822() { x = 0x8000000000000000l; long result = x * 0x1e00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04823() { x = 0xffffffffffffffffl; long result = x * 0x1e00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe200000000l); }
@Test
public void test04824() { x = 0xfffffffffffffffel; long result = x * 0x1e00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffc400000000l); }
@Test
public void test04825() { x = 0xefffffffffffffffl; long result = x * 0x1e00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe200000000l); }
@Test
public void test04826() { x = 0xdeadf00ddeadf00dl; long result = x * 0x1e00000000l; AssertJUnit.assertEquals("multiply", result, 0x1862218600000000l); }
@Test
public void test04827() { x = 0x000000007fffffffl; long result = x * 0xf000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff1000000000l); }
@Test
public void test04828() { x = 0x0000000080000000l; long result = x * 0xf000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04829() { x = 0x00000000ffffffffl; long result = x * 0xf000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff1000000000l); }
@Test
public void test04830() { x = 0x000000017fffffffl; long result = x * 0xf000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff1000000000l); }
@Test
public void test04831() { x = 0x0000000180000000l; long result = x * 0xf000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04832() { x = 0x00000001ffffffffl; long result = x * 0xf000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff1000000000l); }
@Test
public void test04833() { x = 0xffffffff7fffffffl; long result = x * 0xf000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff1000000000l); }
@Test
public void test04834() { x = 0xffffffff80000000l; long result = x * 0xf000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04835() { x = 0x00000001deadf00dl; long result = x * 0xf000000000l; AssertJUnit.assertEquals("multiply", result, 0xc3110c3000000000l); }
@Test
public void test04836() { x = 0xffffffffdeadf00dl; long result = x * 0xf000000000l; AssertJUnit.assertEquals("multiply", result, 0xc3110c3000000000l); }
@Test
public void test04837() { x = 0x7fffffffffffffffl; long result = x * 0xf000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff1000000000l); }
@Test
public void test04838() { x = 0x7fffffff7fffffffl; long result = x * 0xf000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff1000000000l); }
@Test
public void test04839() { x = 0x7fffffff80000000l; long result = x * 0xf000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04840() { x = 0x7fffffffdeadf00dl; long result = x * 0xf000000000l; AssertJUnit.assertEquals("multiply", result, 0xc3110c3000000000l); }
@Test
public void test04841() { x = 0x8000000000000000l; long result = x * 0xf000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04842() { x = 0xffffffffffffffffl; long result = x * 0xf000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff1000000000l); }
@Test
public void test04843() { x = 0xfffffffffffffffel; long result = x * 0xf000000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffe2000000000l); }
@Test
public void test04844() { x = 0xefffffffffffffffl; long result = x * 0xf000000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff1000000000l); }
@Test
public void test04845() { x = 0xdeadf00ddeadf00dl; long result = x * 0xf000000000l; AssertJUnit.assertEquals("multiply", result, 0xc3110c3000000000l); }
@Test
public void test04846() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffffe2l; AssertJUnit.assertEquals("multiply", result, 0xfffffff10000001el); }
@Test
public void test04847() { x = 0x0000000080000000l; long result = x * 0xffffffffffffffe2l; AssertJUnit.assertEquals("multiply", result, 0xfffffff100000000l); }
@Test
public void test04848() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffffe2l; AssertJUnit.assertEquals("multiply", result, 0xffffffe20000001el); }
@Test
public void test04849() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffffe2l; AssertJUnit.assertEquals("multiply", result, 0xffffffd30000001el); }
@Test
public void test04850() { x = 0x0000000180000000l; long result = x * 0xffffffffffffffe2l; AssertJUnit.assertEquals("multiply", result, 0xffffffd300000000l); }
@Test
public void test04851() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffffe2l; AssertJUnit.assertEquals("multiply", result, 0xffffffc40000001el); }
@Test
public void test04852() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffffe2l; AssertJUnit.assertEquals("multiply", result, 0x0000000f0000001el); }
@Test
public void test04853() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffffe2l; AssertJUnit.assertEquals("multiply", result, 0x0000000f00000000l); }
@Test
public void test04854() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffffe2l; AssertJUnit.assertEquals("multiply", result, 0xffffffc7e79dde7al); }
@Test
public void test04855() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffffe2l; AssertJUnit.assertEquals("multiply", result, 0x00000003e79dde7al); }
@Test
public void test04856() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffffe2l; AssertJUnit.assertEquals("multiply", result, 0x000000000000001el); }
@Test
public void test04857() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffffe2l; AssertJUnit.assertEquals("multiply", result, 0x0000000f0000001el); }
@Test
public void test04858() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffffe2l; AssertJUnit.assertEquals("multiply", result, 0x0000000f00000000l); }
@Test
public void test04859() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffffe2l; AssertJUnit.assertEquals("multiply", result, 0x00000003e79dde7al); }
@Test
public void test04860() { x = 0x8000000000000000l; long result = x * 0xffffffffffffffe2l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04861() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffffe2l; AssertJUnit.assertEquals("multiply", result, 0x000000000000001el); }
@Test
public void test04862() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffffe2l; AssertJUnit.assertEquals("multiply", result, 0x000000000000003cl); }
@Test
public void test04863() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffffe2l; AssertJUnit.assertEquals("multiply", result, 0xe00000000000001el); }
@Test
public void test04864() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffffe2l; AssertJUnit.assertEquals("multiply", result, 0xe79dde5fe79dde7al); }
@Test
public void test04865() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffff10l; AssertJUnit.assertEquals("multiply", result, 0xffffff88000000f0l); }
@Test
public void test04866() { x = 0x0000000080000000l; long result = x * 0xffffffffffffff10l; AssertJUnit.assertEquals("multiply", result, 0xffffff8800000000l); }
@Test
public void test04867() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffff10l; AssertJUnit.assertEquals("multiply", result, 0xffffff10000000f0l); }
@Test
public void test04868() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffff10l; AssertJUnit.assertEquals("multiply", result, 0xfffffe98000000f0l); }
@Test
public void test04869() { x = 0x0000000180000000l; long result = x * 0xffffffffffffff10l; AssertJUnit.assertEquals("multiply", result, 0xfffffe9800000000l); }
@Test
public void test04870() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffff10l; AssertJUnit.assertEquals("multiply", result, 0xfffffe20000000f0l); }
@Test
public void test04871() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffff10l; AssertJUnit.assertEquals("multiply", result, 0x00000078000000f0l); }
@Test
public void test04872() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffff10l; AssertJUnit.assertEquals("multiply", result, 0x0000007800000000l); }
@Test
public void test04873() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffff10l; AssertJUnit.assertEquals("multiply", result, 0xfffffe3f3ceef3d0l); }
@Test
public void test04874() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffff10l; AssertJUnit.assertEquals("multiply", result, 0x0000001f3ceef3d0l); }
@Test
public void test04875() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffff10l; AssertJUnit.assertEquals("multiply", result, 0x00000000000000f0l); }
@Test
public void test04876() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffff10l; AssertJUnit.assertEquals("multiply", result, 0x00000078000000f0l); }
@Test
public void test04877() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffff10l; AssertJUnit.assertEquals("multiply", result, 0x0000007800000000l); }
@Test
public void test04878() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffff10l; AssertJUnit.assertEquals("multiply", result, 0x0000001f3ceef3d0l); }
@Test
public void test04879() { x = 0x8000000000000000l; long result = x * 0xffffffffffffff10l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04880() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffff10l; AssertJUnit.assertEquals("multiply", result, 0x00000000000000f0l); }
@Test
public void test04881() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffff10l; AssertJUnit.assertEquals("multiply", result, 0x00000000000001e0l); }
@Test
public void test04882() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffff10l; AssertJUnit.assertEquals("multiply", result, 0x00000000000000f0l); }
@Test
public void test04883() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffff10l; AssertJUnit.assertEquals("multiply", result, 0x3ceef2ff3ceef3d0l); }
@Test
public void test04884() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffe200l; AssertJUnit.assertEquals("multiply", result, 0xfffff10000001e00l); }
@Test
public void test04885() { x = 0x0000000080000000l; long result = x * 0xffffffffffffe200l; AssertJUnit.assertEquals("multiply", result, 0xfffff10000000000l); }
@Test
public void test04886() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffe200l; AssertJUnit.assertEquals("multiply", result, 0xffffe20000001e00l); }
@Test
public void test04887() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffe200l; AssertJUnit.assertEquals("multiply", result, 0xffffd30000001e00l); }
@Test
public void test04888() { x = 0x0000000180000000l; long result = x * 0xffffffffffffe200l; AssertJUnit.assertEquals("multiply", result, 0xffffd30000000000l); }
@Test
public void test04889() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffe200l; AssertJUnit.assertEquals("multiply", result, 0xffffc40000001e00l); }
@Test
public void test04890() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffe200l; AssertJUnit.assertEquals("multiply", result, 0x00000f0000001e00l); }
@Test
public void test04891() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffe200l; AssertJUnit.assertEquals("multiply", result, 0x00000f0000000000l); }
@Test
public void test04892() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffe200l; AssertJUnit.assertEquals("multiply", result, 0xffffc7e79dde7a00l); }
@Test
public void test04893() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffe200l; AssertJUnit.assertEquals("multiply", result, 0x000003e79dde7a00l); }
@Test
public void test04894() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffe200l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001e00l); }
@Test
public void test04895() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffe200l; AssertJUnit.assertEquals("multiply", result, 0x00000f0000001e00l); }
@Test
public void test04896() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffe200l; AssertJUnit.assertEquals("multiply", result, 0x00000f0000000000l); }
@Test
public void test04897() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffe200l; AssertJUnit.assertEquals("multiply", result, 0x000003e79dde7a00l); }
@Test
public void test04898() { x = 0x8000000000000000l; long result = x * 0xffffffffffffe200l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04899() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffe200l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001e00l); }
@Test
public void test04900() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffe200l; AssertJUnit.assertEquals("multiply", result, 0x0000000000003c00l); }
@Test
public void test04901() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffe200l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001e00l); }
@Test
public void test04902() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffe200l; AssertJUnit.assertEquals("multiply", result, 0x9dde5fe79dde7a00l); }
@Test
public void test04903() { x = 0x000000007fffffffl; long result = x * 0xffffffe200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001e00000000l); }
@Test
public void test04904() { x = 0x0000000080000000l; long result = x * 0xffffffe200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04905() { x = 0x00000000ffffffffl; long result = x * 0xffffffe200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001e00000000l); }
@Test
public void test04906() { x = 0x000000017fffffffl; long result = x * 0xffffffe200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001e00000000l); }
@Test
public void test04907() { x = 0x0000000180000000l; long result = x * 0xffffffe200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04908() { x = 0x00000001ffffffffl; long result = x * 0xffffffe200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001e00000000l); }
@Test
public void test04909() { x = 0xffffffff7fffffffl; long result = x * 0xffffffe200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001e00000000l); }
@Test
public void test04910() { x = 0xffffffff80000000l; long result = x * 0xffffffe200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04911() { x = 0x00000001deadf00dl; long result = x * 0xffffffe200000000l; AssertJUnit.assertEquals("multiply", result, 0xe79dde7a00000000l); }
@Test
public void test04912() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffe200000000l; AssertJUnit.assertEquals("multiply", result, 0xe79dde7a00000000l); }
@Test
public void test04913() { x = 0x7fffffffffffffffl; long result = x * 0xffffffe200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001e00000000l); }
@Test
public void test04914() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffe200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001e00000000l); }
@Test
public void test04915() { x = 0x7fffffff80000000l; long result = x * 0xffffffe200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04916() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffe200000000l; AssertJUnit.assertEquals("multiply", result, 0xe79dde7a00000000l); }
@Test
public void test04917() { x = 0x8000000000000000l; long result = x * 0xffffffe200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04918() { x = 0xffffffffffffffffl; long result = x * 0xffffffe200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001e00000000l); }
@Test
public void test04919() { x = 0xfffffffffffffffel; long result = x * 0xffffffe200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000003c00000000l); }
@Test
public void test04920() { x = 0xefffffffffffffffl; long result = x * 0xffffffe200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001e00000000l); }
@Test
public void test04921() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffe200000000l; AssertJUnit.assertEquals("multiply", result, 0xe79dde7a00000000l); }
@Test
public void test04922() { x = 0x000000007fffffffl; long result = x * 0xffffff1000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000f000000000l); }
@Test
public void test04923() { x = 0x0000000080000000l; long result = x * 0xffffff1000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04924() { x = 0x00000000ffffffffl; long result = x * 0xffffff1000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000f000000000l); }
@Test
public void test04925() { x = 0x000000017fffffffl; long result = x * 0xffffff1000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000f000000000l); }
@Test
public void test04926() { x = 0x0000000180000000l; long result = x * 0xffffff1000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04927() { x = 0x00000001ffffffffl; long result = x * 0xffffff1000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000f000000000l); }
@Test
public void test04928() { x = 0xffffffff7fffffffl; long result = x * 0xffffff1000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000f000000000l); }
@Test
public void test04929() { x = 0xffffffff80000000l; long result = x * 0xffffff1000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04930() { x = 0x00000001deadf00dl; long result = x * 0xffffff1000000000l; AssertJUnit.assertEquals("multiply", result, 0x3ceef3d000000000l); }
@Test
public void test04931() { x = 0xffffffffdeadf00dl; long result = x * 0xffffff1000000000l; AssertJUnit.assertEquals("multiply", result, 0x3ceef3d000000000l); }
@Test
public void test04932() { x = 0x7fffffffffffffffl; long result = x * 0xffffff1000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000f000000000l); }
@Test
public void test04933() { x = 0x7fffffff7fffffffl; long result = x * 0xffffff1000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000f000000000l); }
@Test
public void test04934() { x = 0x7fffffff80000000l; long result = x * 0xffffff1000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04935() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffff1000000000l; AssertJUnit.assertEquals("multiply", result, 0x3ceef3d000000000l); }
@Test
public void test04936() { x = 0x8000000000000000l; long result = x * 0xffffff1000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04937() { x = 0xffffffffffffffffl; long result = x * 0xffffff1000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000f000000000l); }
@Test
public void test04938() { x = 0xfffffffffffffffel; long result = x * 0xffffff1000000000l; AssertJUnit.assertEquals("multiply", result, 0x000001e000000000l); }
@Test
public void test04939() { x = 0xefffffffffffffffl; long result = x * 0xffffff1000000000l; AssertJUnit.assertEquals("multiply", result, 0x000000f000000000l); }
@Test
public void test04940() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffff1000000000l; AssertJUnit.assertEquals("multiply", result, 0x3ceef3d000000000l); }
@Test
public void test04941() { x = 0x000000007fffffffl; long result = x * 0x1fl; AssertJUnit.assertEquals("multiply", result, 0x0000000f7fffffe1l); }
@Test
public void test04942() { x = 0x0000000080000000l; long result = x * 0x1fl; AssertJUnit.assertEquals("multiply", result, 0x0000000f80000000l); }
@Test
public void test04943() { x = 0x00000000ffffffffl; long result = x * 0x1fl; AssertJUnit.assertEquals("multiply", result, 0x0000001effffffe1l); }
@Test
public void test04944() { x = 0x000000017fffffffl; long result = x * 0x1fl; AssertJUnit.assertEquals("multiply", result, 0x0000002e7fffffe1l); }
@Test
public void test04945() { x = 0x0000000180000000l; long result = x * 0x1fl; AssertJUnit.assertEquals("multiply", result, 0x0000002e80000000l); }
@Test
public void test04946() { x = 0x00000001ffffffffl; long result = x * 0x1fl; AssertJUnit.assertEquals("multiply", result, 0x0000003dffffffe1l); }
@Test
public void test04947() { x = 0xffffffff7fffffffl; long result = x * 0x1fl; AssertJUnit.assertEquals("multiply", result, 0xfffffff07fffffe1l); }
@Test
public void test04948() { x = 0xffffffff80000000l; long result = x * 0x1fl; AssertJUnit.assertEquals("multiply", result, 0xfffffff080000000l); }
@Test
public void test04949() { x = 0x00000001deadf00dl; long result = x * 0x1fl; AssertJUnit.assertEquals("multiply", result, 0x00000039f7101193l); }
@Test
public void test04950() { x = 0xffffffffdeadf00dl; long result = x * 0x1fl; AssertJUnit.assertEquals("multiply", result, 0xfffffffbf7101193l); }
@Test
public void test04951() { x = 0x7fffffffffffffffl; long result = x * 0x1fl; AssertJUnit.assertEquals("multiply", result, 0x7fffffffffffffe1l); }
@Test
public void test04952() { x = 0x7fffffff7fffffffl; long result = x * 0x1fl; AssertJUnit.assertEquals("multiply", result, 0x7ffffff07fffffe1l); }
@Test
public void test04953() { x = 0x7fffffff80000000l; long result = x * 0x1fl; AssertJUnit.assertEquals("multiply", result, 0x7ffffff080000000l); }
@Test
public void test04954() { x = 0x7fffffffdeadf00dl; long result = x * 0x1fl; AssertJUnit.assertEquals("multiply", result, 0x7ffffffbf7101193l); }
@Test
public void test04955() { x = 0x8000000000000000l; long result = x * 0x1fl; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test04956() { x = 0xffffffffffffffffl; long result = x * 0x1fl; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffe1l); }
@Test
public void test04957() { x = 0xfffffffffffffffel; long result = x * 0x1fl; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffc2l); }
@Test
public void test04958() { x = 0xefffffffffffffffl; long result = x * 0x1fl; AssertJUnit.assertEquals("multiply", result, 0x0fffffffffffffe1l); }
@Test
public void test04959() { x = 0xdeadf00ddeadf00dl; long result = x * 0x1fl; AssertJUnit.assertEquals("multiply", result, 0xf71011adf7101193l); }
@Test
public void test04960() { x = 0x000000007fffffffl; long result = x * 0xf8l; AssertJUnit.assertEquals("multiply", result, 0x0000007bffffff08l); }
@Test
public void test04961() { x = 0x0000000080000000l; long result = x * 0xf8l; AssertJUnit.assertEquals("multiply", result, 0x0000007c00000000l); }
@Test
public void test04962() { x = 0x00000000ffffffffl; long result = x * 0xf8l; AssertJUnit.assertEquals("multiply", result, 0x000000f7ffffff08l); }
@Test
public void test04963() { x = 0x000000017fffffffl; long result = x * 0xf8l; AssertJUnit.assertEquals("multiply", result, 0x00000173ffffff08l); }
@Test
public void test04964() { x = 0x0000000180000000l; long result = x * 0xf8l; AssertJUnit.assertEquals("multiply", result, 0x0000017400000000l); }
@Test
public void test04965() { x = 0x00000001ffffffffl; long result = x * 0xf8l; AssertJUnit.assertEquals("multiply", result, 0x000001efffffff08l); }
@Test
public void test04966() { x = 0xffffffff7fffffffl; long result = x * 0xf8l; AssertJUnit.assertEquals("multiply", result, 0xffffff83ffffff08l); }
@Test
public void test04967() { x = 0xffffffff80000000l; long result = x * 0xf8l; AssertJUnit.assertEquals("multiply", result, 0xffffff8400000000l); }
@Test
public void test04968() { x = 0x00000001deadf00dl; long result = x * 0xf8l; AssertJUnit.assertEquals("multiply", result, 0x000001cfb8808c98l); }
@Test
public void test04969() { x = 0xffffffffdeadf00dl; long result = x * 0xf8l; AssertJUnit.assertEquals("multiply", result, 0xffffffdfb8808c98l); }
@Test
public void test04970() { x = 0x7fffffffffffffffl; long result = x * 0xf8l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff08l); }
@Test
public void test04971() { x = 0x7fffffff7fffffffl; long result = x * 0xf8l; AssertJUnit.assertEquals("multiply", result, 0xffffff83ffffff08l); }
@Test
public void test04972() { x = 0x7fffffff80000000l; long result = x * 0xf8l; AssertJUnit.assertEquals("multiply", result, 0xffffff8400000000l); }
@Test
public void test04973() { x = 0x7fffffffdeadf00dl; long result = x * 0xf8l; AssertJUnit.assertEquals("multiply", result, 0xffffffdfb8808c98l); }
@Test
public void test04974() { x = 0x8000000000000000l; long result = x * 0xf8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04975() { x = 0xffffffffffffffffl; long result = x * 0xf8l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffff08l); }
@Test
public void test04976() { x = 0xfffffffffffffffel; long result = x * 0xf8l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffe10l); }
@Test
public void test04977() { x = 0xefffffffffffffffl; long result = x * 0xf8l; AssertJUnit.assertEquals("multiply", result, 0x7fffffffffffff08l); }
@Test
public void test04978() { x = 0xdeadf00ddeadf00dl; long result = x * 0xf8l; AssertJUnit.assertEquals("multiply", result, 0xb8808d6fb8808c98l); }
@Test
public void test04979() { x = 0x000000007fffffffl; long result = x * 0x1f00l; AssertJUnit.assertEquals("multiply", result, 0x00000f7fffffe100l); }
@Test
public void test04980() { x = 0x0000000080000000l; long result = x * 0x1f00l; AssertJUnit.assertEquals("multiply", result, 0x00000f8000000000l); }
@Test
public void test04981() { x = 0x00000000ffffffffl; long result = x * 0x1f00l; AssertJUnit.assertEquals("multiply", result, 0x00001effffffe100l); }
@Test
public void test04982() { x = 0x000000017fffffffl; long result = x * 0x1f00l; AssertJUnit.assertEquals("multiply", result, 0x00002e7fffffe100l); }
@Test
public void test04983() { x = 0x0000000180000000l; long result = x * 0x1f00l; AssertJUnit.assertEquals("multiply", result, 0x00002e8000000000l); }
@Test
public void test04984() { x = 0x00000001ffffffffl; long result = x * 0x1f00l; AssertJUnit.assertEquals("multiply", result, 0x00003dffffffe100l); }
@Test
public void test04985() { x = 0xffffffff7fffffffl; long result = x * 0x1f00l; AssertJUnit.assertEquals("multiply", result, 0xfffff07fffffe100l); }
@Test
public void test04986() { x = 0xffffffff80000000l; long result = x * 0x1f00l; AssertJUnit.assertEquals("multiply", result, 0xfffff08000000000l); }
@Test
public void test04987() { x = 0x00000001deadf00dl; long result = x * 0x1f00l; AssertJUnit.assertEquals("multiply", result, 0x000039f710119300l); }
@Test
public void test04988() { x = 0xffffffffdeadf00dl; long result = x * 0x1f00l; AssertJUnit.assertEquals("multiply", result, 0xfffffbf710119300l); }
@Test
public void test04989() { x = 0x7fffffffffffffffl; long result = x * 0x1f00l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffe100l); }
@Test
public void test04990() { x = 0x7fffffff7fffffffl; long result = x * 0x1f00l; AssertJUnit.assertEquals("multiply", result, 0xfffff07fffffe100l); }
@Test
public void test04991() { x = 0x7fffffff80000000l; long result = x * 0x1f00l; AssertJUnit.assertEquals("multiply", result, 0xfffff08000000000l); }
@Test
public void test04992() { x = 0x7fffffffdeadf00dl; long result = x * 0x1f00l; AssertJUnit.assertEquals("multiply", result, 0xfffffbf710119300l); }
@Test
public void test04993() { x = 0x8000000000000000l; long result = x * 0x1f00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test04994() { x = 0xffffffffffffffffl; long result = x * 0x1f00l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffe100l); }
@Test
public void test04995() { x = 0xfffffffffffffffel; long result = x * 0x1f00l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffc200l); }
@Test
public void test04996() { x = 0xefffffffffffffffl; long result = x * 0x1f00l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffe100l); }
@Test
public void test04997() { x = 0xdeadf00ddeadf00dl; long result = x * 0x1f00l; AssertJUnit.assertEquals("multiply", result, 0x1011adf710119300l); }
@Test
public void test04998() { x = 0x000000007fffffffl; long result = x * 0x1f00000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffe100000000l); }
@Test
public void test04999() { x = 0x0000000080000000l; long result = x * 0x1f00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test05000() { x = 0x00000000ffffffffl; long result = x * 0x1f00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe100000000l); }
@Test
public void test05001() { x = 0x000000017fffffffl; long result = x * 0x1f00000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffe100000000l); }
@Test
public void test05002() { x = 0x0000000180000000l; long result = x * 0x1f00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test05003() { x = 0x00000001ffffffffl; long result = x * 0x1f00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe100000000l); }
@Test
public void test05004() { x = 0xffffffff7fffffffl; long result = x * 0x1f00000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffe100000000l); }
@Test
public void test05005() { x = 0xffffffff80000000l; long result = x * 0x1f00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test05006() { x = 0x00000001deadf00dl; long result = x * 0x1f00000000l; AssertJUnit.assertEquals("multiply", result, 0xf710119300000000l); }
@Test
public void test05007() { x = 0xffffffffdeadf00dl; long result = x * 0x1f00000000l; AssertJUnit.assertEquals("multiply", result, 0xf710119300000000l); }
@Test
public void test05008() { x = 0x7fffffffffffffffl; long result = x * 0x1f00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe100000000l); }
@Test
public void test05009() { x = 0x7fffffff7fffffffl; long result = x * 0x1f00000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffe100000000l); }
@Test
public void test05010() { x = 0x7fffffff80000000l; long result = x * 0x1f00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test05011() { x = 0x7fffffffdeadf00dl; long result = x * 0x1f00000000l; AssertJUnit.assertEquals("multiply", result, 0xf710119300000000l); }
@Test
public void test05012() { x = 0x8000000000000000l; long result = x * 0x1f00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05013() { x = 0xffffffffffffffffl; long result = x * 0x1f00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe100000000l); }
@Test
public void test05014() { x = 0xfffffffffffffffel; long result = x * 0x1f00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffc200000000l); }
@Test
public void test05015() { x = 0xefffffffffffffffl; long result = x * 0x1f00000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffe100000000l); }
@Test
public void test05016() { x = 0xdeadf00ddeadf00dl; long result = x * 0x1f00000000l; AssertJUnit.assertEquals("multiply", result, 0xf710119300000000l); }
@Test
public void test05017() { x = 0x000000007fffffffl; long result = x * 0xf800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff0800000000l); }
@Test
public void test05018() { x = 0x0000000080000000l; long result = x * 0xf800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05019() { x = 0x00000000ffffffffl; long result = x * 0xf800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff0800000000l); }
@Test
public void test05020() { x = 0x000000017fffffffl; long result = x * 0xf800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff0800000000l); }
@Test
public void test05021() { x = 0x0000000180000000l; long result = x * 0xf800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05022() { x = 0x00000001ffffffffl; long result = x * 0xf800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff0800000000l); }
@Test
public void test05023() { x = 0xffffffff7fffffffl; long result = x * 0xf800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff0800000000l); }
@Test
public void test05024() { x = 0xffffffff80000000l; long result = x * 0xf800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05025() { x = 0x00000001deadf00dl; long result = x * 0xf800000000l; AssertJUnit.assertEquals("multiply", result, 0xb8808c9800000000l); }
@Test
public void test05026() { x = 0xffffffffdeadf00dl; long result = x * 0xf800000000l; AssertJUnit.assertEquals("multiply", result, 0xb8808c9800000000l); }
@Test
public void test05027() { x = 0x7fffffffffffffffl; long result = x * 0xf800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff0800000000l); }
@Test
public void test05028() { x = 0x7fffffff7fffffffl; long result = x * 0xf800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff0800000000l); }
@Test
public void test05029() { x = 0x7fffffff80000000l; long result = x * 0xf800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05030() { x = 0x7fffffffdeadf00dl; long result = x * 0xf800000000l; AssertJUnit.assertEquals("multiply", result, 0xb8808c9800000000l); }
@Test
public void test05031() { x = 0x8000000000000000l; long result = x * 0xf800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05032() { x = 0xffffffffffffffffl; long result = x * 0xf800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff0800000000l); }
@Test
public void test05033() { x = 0xfffffffffffffffel; long result = x * 0xf800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffe1000000000l); }
@Test
public void test05034() { x = 0xefffffffffffffffl; long result = x * 0xf800000000l; AssertJUnit.assertEquals("multiply", result, 0xffffff0800000000l); }
@Test
public void test05035() { x = 0xdeadf00ddeadf00dl; long result = x * 0xf800000000l; AssertJUnit.assertEquals("multiply", result, 0xb8808c9800000000l); }
@Test
public void test05036() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffffe1l; AssertJUnit.assertEquals("multiply", result, 0xfffffff08000001fl); }
@Test
public void test05037() { x = 0x0000000080000000l; long result = x * 0xffffffffffffffe1l; AssertJUnit.assertEquals("multiply", result, 0xfffffff080000000l); }
@Test
public void test05038() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffffe1l; AssertJUnit.assertEquals("multiply", result, 0xffffffe10000001fl); }
@Test
public void test05039() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffffe1l; AssertJUnit.assertEquals("multiply", result, 0xffffffd18000001fl); }
@Test
public void test05040() { x = 0x0000000180000000l; long result = x * 0xffffffffffffffe1l; AssertJUnit.assertEquals("multiply", result, 0xffffffd180000000l); }
@Test
public void test05041() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffffe1l; AssertJUnit.assertEquals("multiply", result, 0xffffffc20000001fl); }
@Test
public void test05042() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffffe1l; AssertJUnit.assertEquals("multiply", result, 0x0000000f8000001fl); }
@Test
public void test05043() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffffe1l; AssertJUnit.assertEquals("multiply", result, 0x0000000f80000000l); }
@Test
public void test05044() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffffe1l; AssertJUnit.assertEquals("multiply", result, 0xffffffc608efee6dl); }
@Test
public void test05045() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffffe1l; AssertJUnit.assertEquals("multiply", result, 0x0000000408efee6dl); }
@Test
public void test05046() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffffe1l; AssertJUnit.assertEquals("multiply", result, 0x800000000000001fl); }
@Test
public void test05047() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffffe1l; AssertJUnit.assertEquals("multiply", result, 0x8000000f8000001fl); }
@Test
public void test05048() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffffe1l; AssertJUnit.assertEquals("multiply", result, 0x8000000f80000000l); }
@Test
public void test05049() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffffe1l; AssertJUnit.assertEquals("multiply", result, 0x8000000408efee6dl); }
@Test
public void test05050() { x = 0x8000000000000000l; long result = x * 0xffffffffffffffe1l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test05051() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffffe1l; AssertJUnit.assertEquals("multiply", result, 0x000000000000001fl); }
@Test
public void test05052() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffffe1l; AssertJUnit.assertEquals("multiply", result, 0x000000000000003el); }
@Test
public void test05053() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffffe1l; AssertJUnit.assertEquals("multiply", result, 0xf00000000000001fl); }
@Test
public void test05054() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffffe1l; AssertJUnit.assertEquals("multiply", result, 0x08efee5208efee6dl); }
@Test
public void test05055() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffff08l; AssertJUnit.assertEquals("multiply", result, 0xffffff84000000f8l); }
@Test
public void test05056() { x = 0x0000000080000000l; long result = x * 0xffffffffffffff08l; AssertJUnit.assertEquals("multiply", result, 0xffffff8400000000l); }
@Test
public void test05057() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffff08l; AssertJUnit.assertEquals("multiply", result, 0xffffff08000000f8l); }
@Test
public void test05058() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffff08l; AssertJUnit.assertEquals("multiply", result, 0xfffffe8c000000f8l); }
@Test
public void test05059() { x = 0x0000000180000000l; long result = x * 0xffffffffffffff08l; AssertJUnit.assertEquals("multiply", result, 0xfffffe8c00000000l); }
@Test
public void test05060() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffff08l; AssertJUnit.assertEquals("multiply", result, 0xfffffe10000000f8l); }
@Test
public void test05061() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffff08l; AssertJUnit.assertEquals("multiply", result, 0x0000007c000000f8l); }
@Test
public void test05062() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffff08l; AssertJUnit.assertEquals("multiply", result, 0x0000007c00000000l); }
@Test
public void test05063() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffff08l; AssertJUnit.assertEquals("multiply", result, 0xfffffe30477f7368l); }
@Test
public void test05064() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffff08l; AssertJUnit.assertEquals("multiply", result, 0x00000020477f7368l); }
@Test
public void test05065() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffff08l; AssertJUnit.assertEquals("multiply", result, 0x00000000000000f8l); }
@Test
public void test05066() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffff08l; AssertJUnit.assertEquals("multiply", result, 0x0000007c000000f8l); }
@Test
public void test05067() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffff08l; AssertJUnit.assertEquals("multiply", result, 0x0000007c00000000l); }
@Test
public void test05068() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffff08l; AssertJUnit.assertEquals("multiply", result, 0x00000020477f7368l); }
@Test
public void test05069() { x = 0x8000000000000000l; long result = x * 0xffffffffffffff08l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05070() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffff08l; AssertJUnit.assertEquals("multiply", result, 0x00000000000000f8l); }
@Test
public void test05071() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffff08l; AssertJUnit.assertEquals("multiply", result, 0x00000000000001f0l); }
@Test
public void test05072() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffff08l; AssertJUnit.assertEquals("multiply", result, 0x80000000000000f8l); }
@Test
public void test05073() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffff08l; AssertJUnit.assertEquals("multiply", result, 0x477f7290477f7368l); }
@Test
public void test05074() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffe100l; AssertJUnit.assertEquals("multiply", result, 0xfffff08000001f00l); }
@Test
public void test05075() { x = 0x0000000080000000l; long result = x * 0xffffffffffffe100l; AssertJUnit.assertEquals("multiply", result, 0xfffff08000000000l); }
@Test
public void test05076() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffe100l; AssertJUnit.assertEquals("multiply", result, 0xffffe10000001f00l); }
@Test
public void test05077() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffe100l; AssertJUnit.assertEquals("multiply", result, 0xffffd18000001f00l); }
@Test
public void test05078() { x = 0x0000000180000000l; long result = x * 0xffffffffffffe100l; AssertJUnit.assertEquals("multiply", result, 0xffffd18000000000l); }
@Test
public void test05079() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffe100l; AssertJUnit.assertEquals("multiply", result, 0xffffc20000001f00l); }
@Test
public void test05080() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffe100l; AssertJUnit.assertEquals("multiply", result, 0x00000f8000001f00l); }
@Test
public void test05081() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffe100l; AssertJUnit.assertEquals("multiply", result, 0x00000f8000000000l); }
@Test
public void test05082() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffe100l; AssertJUnit.assertEquals("multiply", result, 0xffffc608efee6d00l); }
@Test
public void test05083() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffe100l; AssertJUnit.assertEquals("multiply", result, 0x00000408efee6d00l); }
@Test
public void test05084() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffe100l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001f00l); }
@Test
public void test05085() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffe100l; AssertJUnit.assertEquals("multiply", result, 0x00000f8000001f00l); }
@Test
public void test05086() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffe100l; AssertJUnit.assertEquals("multiply", result, 0x00000f8000000000l); }
@Test
public void test05087() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffe100l; AssertJUnit.assertEquals("multiply", result, 0x00000408efee6d00l); }
@Test
public void test05088() { x = 0x8000000000000000l; long result = x * 0xffffffffffffe100l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05089() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffe100l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001f00l); }
@Test
public void test05090() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffe100l; AssertJUnit.assertEquals("multiply", result, 0x0000000000003e00l); }
@Test
public void test05091() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffe100l; AssertJUnit.assertEquals("multiply", result, 0x0000000000001f00l); }
@Test
public void test05092() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffe100l; AssertJUnit.assertEquals("multiply", result, 0xefee5208efee6d00l); }
@Test
public void test05093() { x = 0x000000007fffffffl; long result = x * 0xffffffe100000000l; AssertJUnit.assertEquals("multiply", result, 0x8000001f00000000l); }
@Test
public void test05094() { x = 0x0000000080000000l; long result = x * 0xffffffe100000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test05095() { x = 0x00000000ffffffffl; long result = x * 0xffffffe100000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001f00000000l); }
@Test
public void test05096() { x = 0x000000017fffffffl; long result = x * 0xffffffe100000000l; AssertJUnit.assertEquals("multiply", result, 0x8000001f00000000l); }
@Test
public void test05097() { x = 0x0000000180000000l; long result = x * 0xffffffe100000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test05098() { x = 0x00000001ffffffffl; long result = x * 0xffffffe100000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001f00000000l); }
@Test
public void test05099() { x = 0xffffffff7fffffffl; long result = x * 0xffffffe100000000l; AssertJUnit.assertEquals("multiply", result, 0x8000001f00000000l); }
@Test
public void test05100() { x = 0xffffffff80000000l; long result = x * 0xffffffe100000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test05101() { x = 0x00000001deadf00dl; long result = x * 0xffffffe100000000l; AssertJUnit.assertEquals("multiply", result, 0x08efee6d00000000l); }
@Test
public void test05102() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffe100000000l; AssertJUnit.assertEquals("multiply", result, 0x08efee6d00000000l); }
@Test
public void test05103() { x = 0x7fffffffffffffffl; long result = x * 0xffffffe100000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001f00000000l); }
@Test
public void test05104() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffe100000000l; AssertJUnit.assertEquals("multiply", result, 0x8000001f00000000l); }
@Test
public void test05105() { x = 0x7fffffff80000000l; long result = x * 0xffffffe100000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test05106() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffe100000000l; AssertJUnit.assertEquals("multiply", result, 0x08efee6d00000000l); }
@Test
public void test05107() { x = 0x8000000000000000l; long result = x * 0xffffffe100000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05108() { x = 0xffffffffffffffffl; long result = x * 0xffffffe100000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001f00000000l); }
@Test
public void test05109() { x = 0xfffffffffffffffel; long result = x * 0xffffffe100000000l; AssertJUnit.assertEquals("multiply", result, 0x0000003e00000000l); }
@Test
public void test05110() { x = 0xefffffffffffffffl; long result = x * 0xffffffe100000000l; AssertJUnit.assertEquals("multiply", result, 0x0000001f00000000l); }
@Test
public void test05111() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffe100000000l; AssertJUnit.assertEquals("multiply", result, 0x08efee6d00000000l); }
@Test
public void test05112() { x = 0x000000007fffffffl; long result = x * 0xffffff0800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000f800000000l); }
@Test
public void test05113() { x = 0x0000000080000000l; long result = x * 0xffffff0800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05114() { x = 0x00000000ffffffffl; long result = x * 0xffffff0800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000f800000000l); }
@Test
public void test05115() { x = 0x000000017fffffffl; long result = x * 0xffffff0800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000f800000000l); }
@Test
public void test05116() { x = 0x0000000180000000l; long result = x * 0xffffff0800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05117() { x = 0x00000001ffffffffl; long result = x * 0xffffff0800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000f800000000l); }
@Test
public void test05118() { x = 0xffffffff7fffffffl; long result = x * 0xffffff0800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000f800000000l); }
@Test
public void test05119() { x = 0xffffffff80000000l; long result = x * 0xffffff0800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05120() { x = 0x00000001deadf00dl; long result = x * 0xffffff0800000000l; AssertJUnit.assertEquals("multiply", result, 0x477f736800000000l); }
@Test
public void test05121() { x = 0xffffffffdeadf00dl; long result = x * 0xffffff0800000000l; AssertJUnit.assertEquals("multiply", result, 0x477f736800000000l); }
@Test
public void test05122() { x = 0x7fffffffffffffffl; long result = x * 0xffffff0800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000f800000000l); }
@Test
public void test05123() { x = 0x7fffffff7fffffffl; long result = x * 0xffffff0800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000f800000000l); }
@Test
public void test05124() { x = 0x7fffffff80000000l; long result = x * 0xffffff0800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05125() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffff0800000000l; AssertJUnit.assertEquals("multiply", result, 0x477f736800000000l); }
@Test
public void test05126() { x = 0x8000000000000000l; long result = x * 0xffffff0800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05127() { x = 0xffffffffffffffffl; long result = x * 0xffffff0800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000f800000000l); }
@Test
public void test05128() { x = 0xfffffffffffffffel; long result = x * 0xffffff0800000000l; AssertJUnit.assertEquals("multiply", result, 0x000001f000000000l); }
@Test
public void test05129() { x = 0xefffffffffffffffl; long result = x * 0xffffff0800000000l; AssertJUnit.assertEquals("multiply", result, 0x000000f800000000l); }
@Test
public void test05130() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffff0800000000l; AssertJUnit.assertEquals("multiply", result, 0x477f736800000000l); }
@Test
public void test05131() { x = 0x000000007fffffffl; long result = x * 0x21l; AssertJUnit.assertEquals("multiply", result, 0x000000107fffffdfl); }
@Test
public void test05132() { x = 0x0000000080000000l; long result = x * 0x21l; AssertJUnit.assertEquals("multiply", result, 0x0000001080000000l); }
@Test
public void test05133() { x = 0x00000000ffffffffl; long result = x * 0x21l; AssertJUnit.assertEquals("multiply", result, 0x00000020ffffffdfl); }
@Test
public void test05134() { x = 0x000000017fffffffl; long result = x * 0x21l; AssertJUnit.assertEquals("multiply", result, 0x000000317fffffdfl); }
@Test
public void test05135() { x = 0x0000000180000000l; long result = x * 0x21l; AssertJUnit.assertEquals("multiply", result, 0x0000003180000000l); }
@Test
public void test05136() { x = 0x00000001ffffffffl; long result = x * 0x21l; AssertJUnit.assertEquals("multiply", result, 0x00000041ffffffdfl); }
@Test
public void test05137() { x = 0xffffffff7fffffffl; long result = x * 0x21l; AssertJUnit.assertEquals("multiply", result, 0xffffffef7fffffdfl); }
@Test
public void test05138() { x = 0xffffffff80000000l; long result = x * 0x21l; AssertJUnit.assertEquals("multiply", result, 0xffffffef80000000l); }
@Test
public void test05139() { x = 0x00000001deadf00dl; long result = x * 0x21l; AssertJUnit.assertEquals("multiply", result, 0x0000003db46bf1adl); }
@Test
public void test05140() { x = 0xffffffffdeadf00dl; long result = x * 0x21l; AssertJUnit.assertEquals("multiply", result, 0xfffffffbb46bf1adl); }
@Test
public void test05141() { x = 0x7fffffffffffffffl; long result = x * 0x21l; AssertJUnit.assertEquals("multiply", result, 0x7fffffffffffffdfl); }
@Test
public void test05142() { x = 0x7fffffff7fffffffl; long result = x * 0x21l; AssertJUnit.assertEquals("multiply", result, 0x7fffffef7fffffdfl); }
@Test
public void test05143() { x = 0x7fffffff80000000l; long result = x * 0x21l; AssertJUnit.assertEquals("multiply", result, 0x7fffffef80000000l); }
@Test
public void test05144() { x = 0x7fffffffdeadf00dl; long result = x * 0x21l; AssertJUnit.assertEquals("multiply", result, 0x7ffffffbb46bf1adl); }
@Test
public void test05145() { x = 0x8000000000000000l; long result = x * 0x21l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test05146() { x = 0xffffffffffffffffl; long result = x * 0x21l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffdfl); }
@Test
public void test05147() { x = 0xfffffffffffffffel; long result = x * 0x21l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffbel); }
@Test
public void test05148() { x = 0xefffffffffffffffl; long result = x * 0x21l; AssertJUnit.assertEquals("multiply", result, 0xefffffffffffffdfl); }
@Test
public void test05149() { x = 0xdeadf00ddeadf00dl; long result = x * 0x21l; AssertJUnit.assertEquals("multiply", result, 0xb46bf1c9b46bf1adl); }
@Test
public void test05150() { x = 0x000000007fffffffl; long result = x * 0x108l; AssertJUnit.assertEquals("multiply", result, 0x00000083fffffef8l); }
@Test
public void test05151() { x = 0x0000000080000000l; long result = x * 0x108l; AssertJUnit.assertEquals("multiply", result, 0x0000008400000000l); }
@Test
public void test05152() { x = 0x00000000ffffffffl; long result = x * 0x108l; AssertJUnit.assertEquals("multiply", result, 0x00000107fffffef8l); }
@Test
public void test05153() { x = 0x000000017fffffffl; long result = x * 0x108l; AssertJUnit.assertEquals("multiply", result, 0x0000018bfffffef8l); }
@Test
public void test05154() { x = 0x0000000180000000l; long result = x * 0x108l; AssertJUnit.assertEquals("multiply", result, 0x0000018c00000000l); }
@Test
public void test05155() { x = 0x00000001ffffffffl; long result = x * 0x108l; AssertJUnit.assertEquals("multiply", result, 0x0000020ffffffef8l); }
@Test
public void test05156() { x = 0xffffffff7fffffffl; long result = x * 0x108l; AssertJUnit.assertEquals("multiply", result, 0xffffff7bfffffef8l); }
@Test
public void test05157() { x = 0xffffffff80000000l; long result = x * 0x108l; AssertJUnit.assertEquals("multiply", result, 0xffffff7c00000000l); }
@Test
public void test05158() { x = 0x00000001deadf00dl; long result = x * 0x108l; AssertJUnit.assertEquals("multiply", result, 0x000001eda35f8d68l); }
@Test
public void test05159() { x = 0xffffffffdeadf00dl; long result = x * 0x108l; AssertJUnit.assertEquals("multiply", result, 0xffffffdda35f8d68l); }
@Test
public void test05160() { x = 0x7fffffffffffffffl; long result = x * 0x108l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffef8l); }
@Test
public void test05161() { x = 0x7fffffff7fffffffl; long result = x * 0x108l; AssertJUnit.assertEquals("multiply", result, 0xffffff7bfffffef8l); }
@Test
public void test05162() { x = 0x7fffffff80000000l; long result = x * 0x108l; AssertJUnit.assertEquals("multiply", result, 0xffffff7c00000000l); }
@Test
public void test05163() { x = 0x7fffffffdeadf00dl; long result = x * 0x108l; AssertJUnit.assertEquals("multiply", result, 0xffffffdda35f8d68l); }
@Test
public void test05164() { x = 0x8000000000000000l; long result = x * 0x108l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05165() { x = 0xffffffffffffffffl; long result = x * 0x108l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffef8l); }
@Test
public void test05166() { x = 0xfffffffffffffffel; long result = x * 0x108l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffdf0l); }
@Test
public void test05167() { x = 0xefffffffffffffffl; long result = x * 0x108l; AssertJUnit.assertEquals("multiply", result, 0x7ffffffffffffef8l); }
@Test
public void test05168() { x = 0xdeadf00ddeadf00dl; long result = x * 0x108l; AssertJUnit.assertEquals("multiply", result, 0xa35f8e4da35f8d68l); }
@Test
public void test05169() { x = 0x000000007fffffffl; long result = x * 0x2100l; AssertJUnit.assertEquals("multiply", result, 0x0000107fffffdf00l); }
@Test
public void test05170() { x = 0x0000000080000000l; long result = x * 0x2100l; AssertJUnit.assertEquals("multiply", result, 0x0000108000000000l); }
@Test
public void test05171() { x = 0x00000000ffffffffl; long result = x * 0x2100l; AssertJUnit.assertEquals("multiply", result, 0x000020ffffffdf00l); }
@Test
public void test05172() { x = 0x000000017fffffffl; long result = x * 0x2100l; AssertJUnit.assertEquals("multiply", result, 0x0000317fffffdf00l); }
@Test
public void test05173() { x = 0x0000000180000000l; long result = x * 0x2100l; AssertJUnit.assertEquals("multiply", result, 0x0000318000000000l); }
@Test
public void test05174() { x = 0x00000001ffffffffl; long result = x * 0x2100l; AssertJUnit.assertEquals("multiply", result, 0x000041ffffffdf00l); }
@Test
public void test05175() { x = 0xffffffff7fffffffl; long result = x * 0x2100l; AssertJUnit.assertEquals("multiply", result, 0xffffef7fffffdf00l); }
@Test
public void test05176() { x = 0xffffffff80000000l; long result = x * 0x2100l; AssertJUnit.assertEquals("multiply", result, 0xffffef8000000000l); }
@Test
public void test05177() { x = 0x00000001deadf00dl; long result = x * 0x2100l; AssertJUnit.assertEquals("multiply", result, 0x00003db46bf1ad00l); }
@Test
public void test05178() { x = 0xffffffffdeadf00dl; long result = x * 0x2100l; AssertJUnit.assertEquals("multiply", result, 0xfffffbb46bf1ad00l); }
@Test
public void test05179() { x = 0x7fffffffffffffffl; long result = x * 0x2100l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffdf00l); }
@Test
public void test05180() { x = 0x7fffffff7fffffffl; long result = x * 0x2100l; AssertJUnit.assertEquals("multiply", result, 0xffffef7fffffdf00l); }
@Test
public void test05181() { x = 0x7fffffff80000000l; long result = x * 0x2100l; AssertJUnit.assertEquals("multiply", result, 0xffffef8000000000l); }
@Test
public void test05182() { x = 0x7fffffffdeadf00dl; long result = x * 0x2100l; AssertJUnit.assertEquals("multiply", result, 0xfffffbb46bf1ad00l); }
@Test
public void test05183() { x = 0x8000000000000000l; long result = x * 0x2100l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05184() { x = 0xffffffffffffffffl; long result = x * 0x2100l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffdf00l); }
@Test
public void test05185() { x = 0xfffffffffffffffel; long result = x * 0x2100l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffbe00l); }
@Test
public void test05186() { x = 0xefffffffffffffffl; long result = x * 0x2100l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffdf00l); }
@Test
public void test05187() { x = 0xdeadf00ddeadf00dl; long result = x * 0x2100l; AssertJUnit.assertEquals("multiply", result, 0x6bf1c9b46bf1ad00l); }
@Test
public void test05188() { x = 0x000000007fffffffl; long result = x * 0x2100000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffdf00000000l); }
@Test
public void test05189() { x = 0x0000000080000000l; long result = x * 0x2100000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test05190() { x = 0x00000000ffffffffl; long result = x * 0x2100000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffdf00000000l); }
@Test
public void test05191() { x = 0x000000017fffffffl; long result = x * 0x2100000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffdf00000000l); }
@Test
public void test05192() { x = 0x0000000180000000l; long result = x * 0x2100000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test05193() { x = 0x00000001ffffffffl; long result = x * 0x2100000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffdf00000000l); }
@Test
public void test05194() { x = 0xffffffff7fffffffl; long result = x * 0x2100000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffdf00000000l); }
@Test
public void test05195() { x = 0xffffffff80000000l; long result = x * 0x2100000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test05196() { x = 0x00000001deadf00dl; long result = x * 0x2100000000l; AssertJUnit.assertEquals("multiply", result, 0xb46bf1ad00000000l); }
@Test
public void test05197() { x = 0xffffffffdeadf00dl; long result = x * 0x2100000000l; AssertJUnit.assertEquals("multiply", result, 0xb46bf1ad00000000l); }
@Test
public void test05198() { x = 0x7fffffffffffffffl; long result = x * 0x2100000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffdf00000000l); }
@Test
public void test05199() { x = 0x7fffffff7fffffffl; long result = x * 0x2100000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffdf00000000l); }
@Test
public void test05200() { x = 0x7fffffff80000000l; long result = x * 0x2100000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test05201() { x = 0x7fffffffdeadf00dl; long result = x * 0x2100000000l; AssertJUnit.assertEquals("multiply", result, 0xb46bf1ad00000000l); }
@Test
public void test05202() { x = 0x8000000000000000l; long result = x * 0x2100000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05203() { x = 0xffffffffffffffffl; long result = x * 0x2100000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffdf00000000l); }
@Test
public void test05204() { x = 0xfffffffffffffffel; long result = x * 0x2100000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffbe00000000l); }
@Test
public void test05205() { x = 0xefffffffffffffffl; long result = x * 0x2100000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffdf00000000l); }
@Test
public void test05206() { x = 0xdeadf00ddeadf00dl; long result = x * 0x2100000000l; AssertJUnit.assertEquals("multiply", result, 0xb46bf1ad00000000l); }
@Test
public void test05207() { x = 0x000000007fffffffl; long result = x * 0x10800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffef800000000l); }
@Test
public void test05208() { x = 0x0000000080000000l; long result = x * 0x10800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05209() { x = 0x00000000ffffffffl; long result = x * 0x10800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffef800000000l); }
@Test
public void test05210() { x = 0x000000017fffffffl; long result = x * 0x10800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffef800000000l); }
@Test
public void test05211() { x = 0x0000000180000000l; long result = x * 0x10800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05212() { x = 0x00000001ffffffffl; long result = x * 0x10800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffef800000000l); }
@Test
public void test05213() { x = 0xffffffff7fffffffl; long result = x * 0x10800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffef800000000l); }
@Test
public void test05214() { x = 0xffffffff80000000l; long result = x * 0x10800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05215() { x = 0x00000001deadf00dl; long result = x * 0x10800000000l; AssertJUnit.assertEquals("multiply", result, 0xa35f8d6800000000l); }
@Test
public void test05216() { x = 0xffffffffdeadf00dl; long result = x * 0x10800000000l; AssertJUnit.assertEquals("multiply", result, 0xa35f8d6800000000l); }
@Test
public void test05217() { x = 0x7fffffffffffffffl; long result = x * 0x10800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffef800000000l); }
@Test
public void test05218() { x = 0x7fffffff7fffffffl; long result = x * 0x10800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffef800000000l); }
@Test
public void test05219() { x = 0x7fffffff80000000l; long result = x * 0x10800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05220() { x = 0x7fffffffdeadf00dl; long result = x * 0x10800000000l; AssertJUnit.assertEquals("multiply", result, 0xa35f8d6800000000l); }
@Test
public void test05221() { x = 0x8000000000000000l; long result = x * 0x10800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05222() { x = 0xffffffffffffffffl; long result = x * 0x10800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffef800000000l); }
@Test
public void test05223() { x = 0xfffffffffffffffel; long result = x * 0x10800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffdf000000000l); }
@Test
public void test05224() { x = 0xefffffffffffffffl; long result = x * 0x10800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffef800000000l); }
@Test
public void test05225() { x = 0xdeadf00ddeadf00dl; long result = x * 0x10800000000l; AssertJUnit.assertEquals("multiply", result, 0xa35f8d6800000000l); }
@Test
public void test05226() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffffdfl; AssertJUnit.assertEquals("multiply", result, 0xffffffef80000021l); }
@Test
public void test05227() { x = 0x0000000080000000l; long result = x * 0xffffffffffffffdfl; AssertJUnit.assertEquals("multiply", result, 0xffffffef80000000l); }
@Test
public void test05228() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffffdfl; AssertJUnit.assertEquals("multiply", result, 0xffffffdf00000021l); }
@Test
public void test05229() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffffdfl; AssertJUnit.assertEquals("multiply", result, 0xffffffce80000021l); }
@Test
public void test05230() { x = 0x0000000180000000l; long result = x * 0xffffffffffffffdfl; AssertJUnit.assertEquals("multiply", result, 0xffffffce80000000l); }
@Test
public void test05231() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffffdfl; AssertJUnit.assertEquals("multiply", result, 0xffffffbe00000021l); }
@Test
public void test05232() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffffdfl; AssertJUnit.assertEquals("multiply", result, 0x0000001080000021l); }
@Test
public void test05233() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffffdfl; AssertJUnit.assertEquals("multiply", result, 0x0000001080000000l); }
@Test
public void test05234() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffffdfl; AssertJUnit.assertEquals("multiply", result, 0xffffffc24b940e53l); }
@Test
public void test05235() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffffdfl; AssertJUnit.assertEquals("multiply", result, 0x000000044b940e53l); }
@Test
public void test05236() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffffdfl; AssertJUnit.assertEquals("multiply", result, 0x8000000000000021l); }
@Test
public void test05237() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffffdfl; AssertJUnit.assertEquals("multiply", result, 0x8000001080000021l); }
@Test
public void test05238() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffffdfl; AssertJUnit.assertEquals("multiply", result, 0x8000001080000000l); }
@Test
public void test05239() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffffdfl; AssertJUnit.assertEquals("multiply", result, 0x800000044b940e53l); }
@Test
public void test05240() { x = 0x8000000000000000l; long result = x * 0xffffffffffffffdfl; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test05241() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffffdfl; AssertJUnit.assertEquals("multiply", result, 0x0000000000000021l); }
@Test
public void test05242() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffffdfl; AssertJUnit.assertEquals("multiply", result, 0x0000000000000042l); }
@Test
public void test05243() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffffdfl; AssertJUnit.assertEquals("multiply", result, 0x1000000000000021l); }
@Test
public void test05244() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffffdfl; AssertJUnit.assertEquals("multiply", result, 0x4b940e364b940e53l); }
@Test
public void test05245() { x = 0x000000007fffffffl; long result = x * 0xfffffffffffffef8l; AssertJUnit.assertEquals("multiply", result, 0xffffff7c00000108l); }
@Test
public void test05246() { x = 0x0000000080000000l; long result = x * 0xfffffffffffffef8l; AssertJUnit.assertEquals("multiply", result, 0xffffff7c00000000l); }
@Test
public void test05247() { x = 0x00000000ffffffffl; long result = x * 0xfffffffffffffef8l; AssertJUnit.assertEquals("multiply", result, 0xfffffef800000108l); }
@Test
public void test05248() { x = 0x000000017fffffffl; long result = x * 0xfffffffffffffef8l; AssertJUnit.assertEquals("multiply", result, 0xfffffe7400000108l); }
@Test
public void test05249() { x = 0x0000000180000000l; long result = x * 0xfffffffffffffef8l; AssertJUnit.assertEquals("multiply", result, 0xfffffe7400000000l); }
@Test
public void test05250() { x = 0x00000001ffffffffl; long result = x * 0xfffffffffffffef8l; AssertJUnit.assertEquals("multiply", result, 0xfffffdf000000108l); }
@Test
public void test05251() { x = 0xffffffff7fffffffl; long result = x * 0xfffffffffffffef8l; AssertJUnit.assertEquals("multiply", result, 0x0000008400000108l); }
@Test
public void test05252() { x = 0xffffffff80000000l; long result = x * 0xfffffffffffffef8l; AssertJUnit.assertEquals("multiply", result, 0x0000008400000000l); }
@Test
public void test05253() { x = 0x00000001deadf00dl; long result = x * 0xfffffffffffffef8l; AssertJUnit.assertEquals("multiply", result, 0xfffffe125ca07298l); }
@Test
public void test05254() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffffffffffef8l; AssertJUnit.assertEquals("multiply", result, 0x000000225ca07298l); }
@Test
public void test05255() { x = 0x7fffffffffffffffl; long result = x * 0xfffffffffffffef8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000108l); }
@Test
public void test05256() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffffffffffef8l; AssertJUnit.assertEquals("multiply", result, 0x0000008400000108l); }
@Test
public void test05257() { x = 0x7fffffff80000000l; long result = x * 0xfffffffffffffef8l; AssertJUnit.assertEquals("multiply", result, 0x0000008400000000l); }
@Test
public void test05258() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffffffffffef8l; AssertJUnit.assertEquals("multiply", result, 0x000000225ca07298l); }
@Test
public void test05259() { x = 0x8000000000000000l; long result = x * 0xfffffffffffffef8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05260() { x = 0xffffffffffffffffl; long result = x * 0xfffffffffffffef8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000108l); }
@Test
public void test05261() { x = 0xfffffffffffffffel; long result = x * 0xfffffffffffffef8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000210l); }
@Test
public void test05262() { x = 0xefffffffffffffffl; long result = x * 0xfffffffffffffef8l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000108l); }
@Test
public void test05263() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffffffffffef8l; AssertJUnit.assertEquals("multiply", result, 0x5ca071b25ca07298l); }
@Test
public void test05264() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffdf00l; AssertJUnit.assertEquals("multiply", result, 0xffffef8000002100l); }
@Test
public void test05265() { x = 0x0000000080000000l; long result = x * 0xffffffffffffdf00l; AssertJUnit.assertEquals("multiply", result, 0xffffef8000000000l); }
@Test
public void test05266() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffdf00l; AssertJUnit.assertEquals("multiply", result, 0xffffdf0000002100l); }
@Test
public void test05267() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffdf00l; AssertJUnit.assertEquals("multiply", result, 0xffffce8000002100l); }
@Test
public void test05268() { x = 0x0000000180000000l; long result = x * 0xffffffffffffdf00l; AssertJUnit.assertEquals("multiply", result, 0xffffce8000000000l); }
@Test
public void test05269() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffdf00l; AssertJUnit.assertEquals("multiply", result, 0xffffbe0000002100l); }
@Test
public void test05270() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffdf00l; AssertJUnit.assertEquals("multiply", result, 0x0000108000002100l); }
@Test
public void test05271() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffdf00l; AssertJUnit.assertEquals("multiply", result, 0x0000108000000000l); }
@Test
public void test05272() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffdf00l; AssertJUnit.assertEquals("multiply", result, 0xffffc24b940e5300l); }
@Test
public void test05273() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffdf00l; AssertJUnit.assertEquals("multiply", result, 0x0000044b940e5300l); }
@Test
public void test05274() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffdf00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000002100l); }
@Test
public void test05275() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffdf00l; AssertJUnit.assertEquals("multiply", result, 0x0000108000002100l); }
@Test
public void test05276() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffdf00l; AssertJUnit.assertEquals("multiply", result, 0x0000108000000000l); }
@Test
public void test05277() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffdf00l; AssertJUnit.assertEquals("multiply", result, 0x0000044b940e5300l); }
@Test
public void test05278() { x = 0x8000000000000000l; long result = x * 0xffffffffffffdf00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05279() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffdf00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000002100l); }
@Test
public void test05280() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffdf00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000004200l); }
@Test
public void test05281() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffdf00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000002100l); }
@Test
public void test05282() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffdf00l; AssertJUnit.assertEquals("multiply", result, 0x940e364b940e5300l); }
@Test
public void test05283() { x = 0x000000007fffffffl; long result = x * 0xffffffdf00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000002100000000l); }
@Test
public void test05284() { x = 0x0000000080000000l; long result = x * 0xffffffdf00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test05285() { x = 0x00000000ffffffffl; long result = x * 0xffffffdf00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002100000000l); }
@Test
public void test05286() { x = 0x000000017fffffffl; long result = x * 0xffffffdf00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000002100000000l); }
@Test
public void test05287() { x = 0x0000000180000000l; long result = x * 0xffffffdf00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test05288() { x = 0x00000001ffffffffl; long result = x * 0xffffffdf00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002100000000l); }
@Test
public void test05289() { x = 0xffffffff7fffffffl; long result = x * 0xffffffdf00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000002100000000l); }
@Test
public void test05290() { x = 0xffffffff80000000l; long result = x * 0xffffffdf00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test05291() { x = 0x00000001deadf00dl; long result = x * 0xffffffdf00000000l; AssertJUnit.assertEquals("multiply", result, 0x4b940e5300000000l); }
@Test
public void test05292() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffdf00000000l; AssertJUnit.assertEquals("multiply", result, 0x4b940e5300000000l); }
@Test
public void test05293() { x = 0x7fffffffffffffffl; long result = x * 0xffffffdf00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002100000000l); }
@Test
public void test05294() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffdf00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000002100000000l); }
@Test
public void test05295() { x = 0x7fffffff80000000l; long result = x * 0xffffffdf00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test05296() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffdf00000000l; AssertJUnit.assertEquals("multiply", result, 0x4b940e5300000000l); }
@Test
public void test05297() { x = 0x8000000000000000l; long result = x * 0xffffffdf00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05298() { x = 0xffffffffffffffffl; long result = x * 0xffffffdf00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002100000000l); }
@Test
public void test05299() { x = 0xfffffffffffffffel; long result = x * 0xffffffdf00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000004200000000l); }
@Test
public void test05300() { x = 0xefffffffffffffffl; long result = x * 0xffffffdf00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002100000000l); }
@Test
public void test05301() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffdf00000000l; AssertJUnit.assertEquals("multiply", result, 0x4b940e5300000000l); }
@Test
public void test05302() { x = 0x000000007fffffffl; long result = x * 0xfffffef800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000010800000000l); }
@Test
public void test05303() { x = 0x0000000080000000l; long result = x * 0xfffffef800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05304() { x = 0x00000000ffffffffl; long result = x * 0xfffffef800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000010800000000l); }
@Test
public void test05305() { x = 0x000000017fffffffl; long result = x * 0xfffffef800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000010800000000l); }
@Test
public void test05306() { x = 0x0000000180000000l; long result = x * 0xfffffef800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05307() { x = 0x00000001ffffffffl; long result = x * 0xfffffef800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000010800000000l); }
@Test
public void test05308() { x = 0xffffffff7fffffffl; long result = x * 0xfffffef800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000010800000000l); }
@Test
public void test05309() { x = 0xffffffff80000000l; long result = x * 0xfffffef800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05310() { x = 0x00000001deadf00dl; long result = x * 0xfffffef800000000l; AssertJUnit.assertEquals("multiply", result, 0x5ca0729800000000l); }
@Test
public void test05311() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffef800000000l; AssertJUnit.assertEquals("multiply", result, 0x5ca0729800000000l); }
@Test
public void test05312() { x = 0x7fffffffffffffffl; long result = x * 0xfffffef800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000010800000000l); }
@Test
public void test05313() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffef800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000010800000000l); }
@Test
public void test05314() { x = 0x7fffffff80000000l; long result = x * 0xfffffef800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05315() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffef800000000l; AssertJUnit.assertEquals("multiply", result, 0x5ca0729800000000l); }
@Test
public void test05316() { x = 0x8000000000000000l; long result = x * 0xfffffef800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05317() { x = 0xffffffffffffffffl; long result = x * 0xfffffef800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000010800000000l); }
@Test
public void test05318() { x = 0xfffffffffffffffel; long result = x * 0xfffffef800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000021000000000l); }
@Test
public void test05319() { x = 0xefffffffffffffffl; long result = x * 0xfffffef800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000010800000000l); }
@Test
public void test05320() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffef800000000l; AssertJUnit.assertEquals("multiply", result, 0x5ca0729800000000l); }
@Test
public void test05321() { x = 0x000000007fffffffl; long result = x * 0x22l; AssertJUnit.assertEquals("multiply", result, 0x00000010ffffffdel); }
@Test
public void test05322() { x = 0x0000000080000000l; long result = x * 0x22l; AssertJUnit.assertEquals("multiply", result, 0x0000001100000000l); }
@Test
public void test05323() { x = 0x00000000ffffffffl; long result = x * 0x22l; AssertJUnit.assertEquals("multiply", result, 0x00000021ffffffdel); }
@Test
public void test05324() { x = 0x000000017fffffffl; long result = x * 0x22l; AssertJUnit.assertEquals("multiply", result, 0x00000032ffffffdel); }
@Test
public void test05325() { x = 0x0000000180000000l; long result = x * 0x22l; AssertJUnit.assertEquals("multiply", result, 0x0000003300000000l); }
@Test
public void test05326() { x = 0x00000001ffffffffl; long result = x * 0x22l; AssertJUnit.assertEquals("multiply", result, 0x00000043ffffffdel); }
@Test
public void test05327() { x = 0xffffffff7fffffffl; long result = x * 0x22l; AssertJUnit.assertEquals("multiply", result, 0xffffffeeffffffdel); }
@Test
public void test05328() { x = 0xffffffff80000000l; long result = x * 0x22l; AssertJUnit.assertEquals("multiply", result, 0xffffffef00000000l); }
@Test
public void test05329() { x = 0x00000001deadf00dl; long result = x * 0x22l; AssertJUnit.assertEquals("multiply", result, 0x0000003f9319e1bal); }
@Test
public void test05330() { x = 0xffffffffdeadf00dl; long result = x * 0x22l; AssertJUnit.assertEquals("multiply", result, 0xfffffffb9319e1bal); }
@Test
public void test05331() { x = 0x7fffffffffffffffl; long result = x * 0x22l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffdel); }
@Test
public void test05332() { x = 0x7fffffff7fffffffl; long result = x * 0x22l; AssertJUnit.assertEquals("multiply", result, 0xffffffeeffffffdel); }
@Test
public void test05333() { x = 0x7fffffff80000000l; long result = x * 0x22l; AssertJUnit.assertEquals("multiply", result, 0xffffffef00000000l); }
@Test
public void test05334() { x = 0x7fffffffdeadf00dl; long result = x * 0x22l; AssertJUnit.assertEquals("multiply", result, 0xfffffffb9319e1bal); }
@Test
public void test05335() { x = 0x8000000000000000l; long result = x * 0x22l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05336() { x = 0xffffffffffffffffl; long result = x * 0x22l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffdel); }
@Test
public void test05337() { x = 0xfffffffffffffffel; long result = x * 0x22l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffbcl); }
@Test
public void test05338() { x = 0xefffffffffffffffl; long result = x * 0x22l; AssertJUnit.assertEquals("multiply", result, 0xdfffffffffffffdel); }
@Test
public void test05339() { x = 0xdeadf00ddeadf00dl; long result = x * 0x22l; AssertJUnit.assertEquals("multiply", result, 0x9319e1d79319e1bal); }
@Test
public void test05340() { x = 0x000000007fffffffl; long result = x * 0x110l; AssertJUnit.assertEquals("multiply", result, 0x00000087fffffef0l); }
@Test
public void test05341() { x = 0x0000000080000000l; long result = x * 0x110l; AssertJUnit.assertEquals("multiply", result, 0x0000008800000000l); }
@Test
public void test05342() { x = 0x00000000ffffffffl; long result = x * 0x110l; AssertJUnit.assertEquals("multiply", result, 0x0000010ffffffef0l); }
@Test
public void test05343() { x = 0x000000017fffffffl; long result = x * 0x110l; AssertJUnit.assertEquals("multiply", result, 0x00000197fffffef0l); }
@Test
public void test05344() { x = 0x0000000180000000l; long result = x * 0x110l; AssertJUnit.assertEquals("multiply", result, 0x0000019800000000l); }
@Test
public void test05345() { x = 0x00000001ffffffffl; long result = x * 0x110l; AssertJUnit.assertEquals("multiply", result, 0x0000021ffffffef0l); }
@Test
public void test05346() { x = 0xffffffff7fffffffl; long result = x * 0x110l; AssertJUnit.assertEquals("multiply", result, 0xffffff77fffffef0l); }
@Test
public void test05347() { x = 0xffffffff80000000l; long result = x * 0x110l; AssertJUnit.assertEquals("multiply", result, 0xffffff7800000000l); }
@Test
public void test05348() { x = 0x00000001deadf00dl; long result = x * 0x110l; AssertJUnit.assertEquals("multiply", result, 0x000001fc98cf0dd0l); }
@Test
public void test05349() { x = 0xffffffffdeadf00dl; long result = x * 0x110l; AssertJUnit.assertEquals("multiply", result, 0xffffffdc98cf0dd0l); }
@Test
public void test05350() { x = 0x7fffffffffffffffl; long result = x * 0x110l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffef0l); }
@Test
public void test05351() { x = 0x7fffffff7fffffffl; long result = x * 0x110l; AssertJUnit.assertEquals("multiply", result, 0xffffff77fffffef0l); }
@Test
public void test05352() { x = 0x7fffffff80000000l; long result = x * 0x110l; AssertJUnit.assertEquals("multiply", result, 0xffffff7800000000l); }
@Test
public void test05353() { x = 0x7fffffffdeadf00dl; long result = x * 0x110l; AssertJUnit.assertEquals("multiply", result, 0xffffffdc98cf0dd0l); }
@Test
public void test05354() { x = 0x8000000000000000l; long result = x * 0x110l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05355() { x = 0xffffffffffffffffl; long result = x * 0x110l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffef0l); }
@Test
public void test05356() { x = 0xfffffffffffffffel; long result = x * 0x110l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffde0l); }
@Test
public void test05357() { x = 0xefffffffffffffffl; long result = x * 0x110l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffef0l); }
@Test
public void test05358() { x = 0xdeadf00ddeadf00dl; long result = x * 0x110l; AssertJUnit.assertEquals("multiply", result, 0x98cf0ebc98cf0dd0l); }
@Test
public void test05359() { x = 0x000000007fffffffl; long result = x * 0x2200l; AssertJUnit.assertEquals("multiply", result, 0x000010ffffffde00l); }
@Test
public void test05360() { x = 0x0000000080000000l; long result = x * 0x2200l; AssertJUnit.assertEquals("multiply", result, 0x0000110000000000l); }
@Test
public void test05361() { x = 0x00000000ffffffffl; long result = x * 0x2200l; AssertJUnit.assertEquals("multiply", result, 0x000021ffffffde00l); }
@Test
public void test05362() { x = 0x000000017fffffffl; long result = x * 0x2200l; AssertJUnit.assertEquals("multiply", result, 0x000032ffffffde00l); }
@Test
public void test05363() { x = 0x0000000180000000l; long result = x * 0x2200l; AssertJUnit.assertEquals("multiply", result, 0x0000330000000000l); }
@Test
public void test05364() { x = 0x00000001ffffffffl; long result = x * 0x2200l; AssertJUnit.assertEquals("multiply", result, 0x000043ffffffde00l); }
@Test
public void test05365() { x = 0xffffffff7fffffffl; long result = x * 0x2200l; AssertJUnit.assertEquals("multiply", result, 0xffffeeffffffde00l); }
@Test
public void test05366() { x = 0xffffffff80000000l; long result = x * 0x2200l; AssertJUnit.assertEquals("multiply", result, 0xffffef0000000000l); }
@Test
public void test05367() { x = 0x00000001deadf00dl; long result = x * 0x2200l; AssertJUnit.assertEquals("multiply", result, 0x00003f9319e1ba00l); }
@Test
public void test05368() { x = 0xffffffffdeadf00dl; long result = x * 0x2200l; AssertJUnit.assertEquals("multiply", result, 0xfffffb9319e1ba00l); }
@Test
public void test05369() { x = 0x7fffffffffffffffl; long result = x * 0x2200l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffde00l); }
@Test
public void test05370() { x = 0x7fffffff7fffffffl; long result = x * 0x2200l; AssertJUnit.assertEquals("multiply", result, 0xffffeeffffffde00l); }
@Test
public void test05371() { x = 0x7fffffff80000000l; long result = x * 0x2200l; AssertJUnit.assertEquals("multiply", result, 0xffffef0000000000l); }
@Test
public void test05372() { x = 0x7fffffffdeadf00dl; long result = x * 0x2200l; AssertJUnit.assertEquals("multiply", result, 0xfffffb9319e1ba00l); }
@Test
public void test05373() { x = 0x8000000000000000l; long result = x * 0x2200l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05374() { x = 0xffffffffffffffffl; long result = x * 0x2200l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffde00l); }
@Test
public void test05375() { x = 0xfffffffffffffffel; long result = x * 0x2200l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffbc00l); }
@Test
public void test05376() { x = 0xefffffffffffffffl; long result = x * 0x2200l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffde00l); }
@Test
public void test05377() { x = 0xdeadf00ddeadf00dl; long result = x * 0x2200l; AssertJUnit.assertEquals("multiply", result, 0x19e1d79319e1ba00l); }
@Test
public void test05378() { x = 0x000000007fffffffl; long result = x * 0x2200000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffde00000000l); }
@Test
public void test05379() { x = 0x0000000080000000l; long result = x * 0x2200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05380() { x = 0x00000000ffffffffl; long result = x * 0x2200000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffde00000000l); }
@Test
public void test05381() { x = 0x000000017fffffffl; long result = x * 0x2200000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffde00000000l); }
@Test
public void test05382() { x = 0x0000000180000000l; long result = x * 0x2200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05383() { x = 0x00000001ffffffffl; long result = x * 0x2200000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffde00000000l); }
@Test
public void test05384() { x = 0xffffffff7fffffffl; long result = x * 0x2200000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffde00000000l); }
@Test
public void test05385() { x = 0xffffffff80000000l; long result = x * 0x2200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05386() { x = 0x00000001deadf00dl; long result = x * 0x2200000000l; AssertJUnit.assertEquals("multiply", result, 0x9319e1ba00000000l); }
@Test
public void test05387() { x = 0xffffffffdeadf00dl; long result = x * 0x2200000000l; AssertJUnit.assertEquals("multiply", result, 0x9319e1ba00000000l); }
@Test
public void test05388() { x = 0x7fffffffffffffffl; long result = x * 0x2200000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffde00000000l); }
@Test
public void test05389() { x = 0x7fffffff7fffffffl; long result = x * 0x2200000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffde00000000l); }
@Test
public void test05390() { x = 0x7fffffff80000000l; long result = x * 0x2200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05391() { x = 0x7fffffffdeadf00dl; long result = x * 0x2200000000l; AssertJUnit.assertEquals("multiply", result, 0x9319e1ba00000000l); }
@Test
public void test05392() { x = 0x8000000000000000l; long result = x * 0x2200000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05393() { x = 0xffffffffffffffffl; long result = x * 0x2200000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffde00000000l); }
@Test
public void test05394() { x = 0xfffffffffffffffel; long result = x * 0x2200000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffbc00000000l); }
@Test
public void test05395() { x = 0xefffffffffffffffl; long result = x * 0x2200000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffde00000000l); }
@Test
public void test05396() { x = 0xdeadf00ddeadf00dl; long result = x * 0x2200000000l; AssertJUnit.assertEquals("multiply", result, 0x9319e1ba00000000l); }
@Test
public void test05397() { x = 0x000000007fffffffl; long result = x * 0x11000000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffef000000000l); }
@Test
public void test05398() { x = 0x0000000080000000l; long result = x * 0x11000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05399() { x = 0x00000000ffffffffl; long result = x * 0x11000000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffef000000000l); }
@Test
public void test05400() { x = 0x000000017fffffffl; long result = x * 0x11000000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffef000000000l); }
@Test
public void test05401() { x = 0x0000000180000000l; long result = x * 0x11000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05402() { x = 0x00000001ffffffffl; long result = x * 0x11000000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffef000000000l); }
@Test
public void test05403() { x = 0xffffffff7fffffffl; long result = x * 0x11000000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffef000000000l); }
@Test
public void test05404() { x = 0xffffffff80000000l; long result = x * 0x11000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05405() { x = 0x00000001deadf00dl; long result = x * 0x11000000000l; AssertJUnit.assertEquals("multiply", result, 0x98cf0dd000000000l); }
@Test
public void test05406() { x = 0xffffffffdeadf00dl; long result = x * 0x11000000000l; AssertJUnit.assertEquals("multiply", result, 0x98cf0dd000000000l); }
@Test
public void test05407() { x = 0x7fffffffffffffffl; long result = x * 0x11000000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffef000000000l); }
@Test
public void test05408() { x = 0x7fffffff7fffffffl; long result = x * 0x11000000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffef000000000l); }
@Test
public void test05409() { x = 0x7fffffff80000000l; long result = x * 0x11000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05410() { x = 0x7fffffffdeadf00dl; long result = x * 0x11000000000l; AssertJUnit.assertEquals("multiply", result, 0x98cf0dd000000000l); }
@Test
public void test05411() { x = 0x8000000000000000l; long result = x * 0x11000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05412() { x = 0xffffffffffffffffl; long result = x * 0x11000000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffef000000000l); }
@Test
public void test05413() { x = 0xfffffffffffffffel; long result = x * 0x11000000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffde000000000l); }
@Test
public void test05414() { x = 0xefffffffffffffffl; long result = x * 0x11000000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffef000000000l); }
@Test
public void test05415() { x = 0xdeadf00ddeadf00dl; long result = x * 0x11000000000l; AssertJUnit.assertEquals("multiply", result, 0x98cf0dd000000000l); }
@Test
public void test05416() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffffdel; AssertJUnit.assertEquals("multiply", result, 0xffffffef00000022l); }
@Test
public void test05417() { x = 0x0000000080000000l; long result = x * 0xffffffffffffffdel; AssertJUnit.assertEquals("multiply", result, 0xffffffef00000000l); }
@Test
public void test05418() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffffdel; AssertJUnit.assertEquals("multiply", result, 0xffffffde00000022l); }
@Test
public void test05419() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffffdel; AssertJUnit.assertEquals("multiply", result, 0xffffffcd00000022l); }
@Test
public void test05420() { x = 0x0000000180000000l; long result = x * 0xffffffffffffffdel; AssertJUnit.assertEquals("multiply", result, 0xffffffcd00000000l); }
@Test
public void test05421() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffffdel; AssertJUnit.assertEquals("multiply", result, 0xffffffbc00000022l); }
@Test
public void test05422() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffffdel; AssertJUnit.assertEquals("multiply", result, 0x0000001100000022l); }
@Test
public void test05423() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffffdel; AssertJUnit.assertEquals("multiply", result, 0x0000001100000000l); }
@Test
public void test05424() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffffdel; AssertJUnit.assertEquals("multiply", result, 0xffffffc06ce61e46l); }
@Test
public void test05425() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffffdel; AssertJUnit.assertEquals("multiply", result, 0x000000046ce61e46l); }
@Test
public void test05426() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffffdel; AssertJUnit.assertEquals("multiply", result, 0x0000000000000022l); }
@Test
public void test05427() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffffdel; AssertJUnit.assertEquals("multiply", result, 0x0000001100000022l); }
@Test
public void test05428() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffffdel; AssertJUnit.assertEquals("multiply", result, 0x0000001100000000l); }
@Test
public void test05429() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffffdel; AssertJUnit.assertEquals("multiply", result, 0x000000046ce61e46l); }
@Test
public void test05430() { x = 0x8000000000000000l; long result = x * 0xffffffffffffffdel; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05431() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffffdel; AssertJUnit.assertEquals("multiply", result, 0x0000000000000022l); }
@Test
public void test05432() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffffdel; AssertJUnit.assertEquals("multiply", result, 0x0000000000000044l); }
@Test
public void test05433() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffffdel; AssertJUnit.assertEquals("multiply", result, 0x2000000000000022l); }
@Test
public void test05434() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffffdel; AssertJUnit.assertEquals("multiply", result, 0x6ce61e286ce61e46l); }
@Test
public void test05435() { x = 0x000000007fffffffl; long result = x * 0xfffffffffffffef0l; AssertJUnit.assertEquals("multiply", result, 0xffffff7800000110l); }
@Test
public void test05436() { x = 0x0000000080000000l; long result = x * 0xfffffffffffffef0l; AssertJUnit.assertEquals("multiply", result, 0xffffff7800000000l); }
@Test
public void test05437() { x = 0x00000000ffffffffl; long result = x * 0xfffffffffffffef0l; AssertJUnit.assertEquals("multiply", result, 0xfffffef000000110l); }
@Test
public void test05438() { x = 0x000000017fffffffl; long result = x * 0xfffffffffffffef0l; AssertJUnit.assertEquals("multiply", result, 0xfffffe6800000110l); }
@Test
public void test05439() { x = 0x0000000180000000l; long result = x * 0xfffffffffffffef0l; AssertJUnit.assertEquals("multiply", result, 0xfffffe6800000000l); }
@Test
public void test05440() { x = 0x00000001ffffffffl; long result = x * 0xfffffffffffffef0l; AssertJUnit.assertEquals("multiply", result, 0xfffffde000000110l); }
@Test
public void test05441() { x = 0xffffffff7fffffffl; long result = x * 0xfffffffffffffef0l; AssertJUnit.assertEquals("multiply", result, 0x0000008800000110l); }
@Test
public void test05442() { x = 0xffffffff80000000l; long result = x * 0xfffffffffffffef0l; AssertJUnit.assertEquals("multiply", result, 0x0000008800000000l); }
@Test
public void test05443() { x = 0x00000001deadf00dl; long result = x * 0xfffffffffffffef0l; AssertJUnit.assertEquals("multiply", result, 0xfffffe036730f230l); }
@Test
public void test05444() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffffffffffef0l; AssertJUnit.assertEquals("multiply", result, 0x000000236730f230l); }
@Test
public void test05445() { x = 0x7fffffffffffffffl; long result = x * 0xfffffffffffffef0l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000110l); }
@Test
public void test05446() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffffffffffef0l; AssertJUnit.assertEquals("multiply", result, 0x0000008800000110l); }
@Test
public void test05447() { x = 0x7fffffff80000000l; long result = x * 0xfffffffffffffef0l; AssertJUnit.assertEquals("multiply", result, 0x0000008800000000l); }
@Test
public void test05448() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffffffffffef0l; AssertJUnit.assertEquals("multiply", result, 0x000000236730f230l); }
@Test
public void test05449() { x = 0x8000000000000000l; long result = x * 0xfffffffffffffef0l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05450() { x = 0xffffffffffffffffl; long result = x * 0xfffffffffffffef0l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000110l); }
@Test
public void test05451() { x = 0xfffffffffffffffel; long result = x * 0xfffffffffffffef0l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000220l); }
@Test
public void test05452() { x = 0xefffffffffffffffl; long result = x * 0xfffffffffffffef0l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000110l); }
@Test
public void test05453() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffffffffffef0l; AssertJUnit.assertEquals("multiply", result, 0x6730f1436730f230l); }
@Test
public void test05454() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffde00l; AssertJUnit.assertEquals("multiply", result, 0xffffef0000002200l); }
@Test
public void test05455() { x = 0x0000000080000000l; long result = x * 0xffffffffffffde00l; AssertJUnit.assertEquals("multiply", result, 0xffffef0000000000l); }
@Test
public void test05456() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffde00l; AssertJUnit.assertEquals("multiply", result, 0xffffde0000002200l); }
@Test
public void test05457() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffde00l; AssertJUnit.assertEquals("multiply", result, 0xffffcd0000002200l); }
@Test
public void test05458() { x = 0x0000000180000000l; long result = x * 0xffffffffffffde00l; AssertJUnit.assertEquals("multiply", result, 0xffffcd0000000000l); }
@Test
public void test05459() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffde00l; AssertJUnit.assertEquals("multiply", result, 0xffffbc0000002200l); }
@Test
public void test05460() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffde00l; AssertJUnit.assertEquals("multiply", result, 0x0000110000002200l); }
@Test
public void test05461() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffde00l; AssertJUnit.assertEquals("multiply", result, 0x0000110000000000l); }
@Test
public void test05462() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffde00l; AssertJUnit.assertEquals("multiply", result, 0xffffc06ce61e4600l); }
@Test
public void test05463() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffde00l; AssertJUnit.assertEquals("multiply", result, 0x0000046ce61e4600l); }
@Test
public void test05464() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffde00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000002200l); }
@Test
public void test05465() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffde00l; AssertJUnit.assertEquals("multiply", result, 0x0000110000002200l); }
@Test
public void test05466() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffde00l; AssertJUnit.assertEquals("multiply", result, 0x0000110000000000l); }
@Test
public void test05467() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffde00l; AssertJUnit.assertEquals("multiply", result, 0x0000046ce61e4600l); }
@Test
public void test05468() { x = 0x8000000000000000l; long result = x * 0xffffffffffffde00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05469() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffde00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000002200l); }
@Test
public void test05470() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffde00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000004400l); }
@Test
public void test05471() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffde00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000002200l); }
@Test
public void test05472() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffde00l; AssertJUnit.assertEquals("multiply", result, 0xe61e286ce61e4600l); }
@Test
public void test05473() { x = 0x000000007fffffffl; long result = x * 0xffffffde00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002200000000l); }
@Test
public void test05474() { x = 0x0000000080000000l; long result = x * 0xffffffde00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05475() { x = 0x00000000ffffffffl; long result = x * 0xffffffde00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002200000000l); }
@Test
public void test05476() { x = 0x000000017fffffffl; long result = x * 0xffffffde00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002200000000l); }
@Test
public void test05477() { x = 0x0000000180000000l; long result = x * 0xffffffde00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05478() { x = 0x00000001ffffffffl; long result = x * 0xffffffde00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002200000000l); }
@Test
public void test05479() { x = 0xffffffff7fffffffl; long result = x * 0xffffffde00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002200000000l); }
@Test
public void test05480() { x = 0xffffffff80000000l; long result = x * 0xffffffde00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05481() { x = 0x00000001deadf00dl; long result = x * 0xffffffde00000000l; AssertJUnit.assertEquals("multiply", result, 0x6ce61e4600000000l); }
@Test
public void test05482() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffde00000000l; AssertJUnit.assertEquals("multiply", result, 0x6ce61e4600000000l); }
@Test
public void test05483() { x = 0x7fffffffffffffffl; long result = x * 0xffffffde00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002200000000l); }
@Test
public void test05484() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffde00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002200000000l); }
@Test
public void test05485() { x = 0x7fffffff80000000l; long result = x * 0xffffffde00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05486() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffde00000000l; AssertJUnit.assertEquals("multiply", result, 0x6ce61e4600000000l); }
@Test
public void test05487() { x = 0x8000000000000000l; long result = x * 0xffffffde00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05488() { x = 0xffffffffffffffffl; long result = x * 0xffffffde00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002200000000l); }
@Test
public void test05489() { x = 0xfffffffffffffffel; long result = x * 0xffffffde00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000004400000000l); }
@Test
public void test05490() { x = 0xefffffffffffffffl; long result = x * 0xffffffde00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002200000000l); }
@Test
public void test05491() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffde00000000l; AssertJUnit.assertEquals("multiply", result, 0x6ce61e4600000000l); }
@Test
public void test05492() { x = 0x000000007fffffffl; long result = x * 0xfffffef000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000011000000000l); }
@Test
public void test05493() { x = 0x0000000080000000l; long result = x * 0xfffffef000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05494() { x = 0x00000000ffffffffl; long result = x * 0xfffffef000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000011000000000l); }
@Test
public void test05495() { x = 0x000000017fffffffl; long result = x * 0xfffffef000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000011000000000l); }
@Test
public void test05496() { x = 0x0000000180000000l; long result = x * 0xfffffef000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05497() { x = 0x00000001ffffffffl; long result = x * 0xfffffef000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000011000000000l); }
@Test
public void test05498() { x = 0xffffffff7fffffffl; long result = x * 0xfffffef000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000011000000000l); }
@Test
public void test05499() { x = 0xffffffff80000000l; long result = x * 0xfffffef000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05500() { x = 0x00000001deadf00dl; long result = x * 0xfffffef000000000l; AssertJUnit.assertEquals("multiply", result, 0x6730f23000000000l); }
@Test
public void test05501() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffef000000000l; AssertJUnit.assertEquals("multiply", result, 0x6730f23000000000l); }
@Test
public void test05502() { x = 0x7fffffffffffffffl; long result = x * 0xfffffef000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000011000000000l); }
@Test
public void test05503() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffef000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000011000000000l); }
@Test
public void test05504() { x = 0x7fffffff80000000l; long result = x * 0xfffffef000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05505() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffef000000000l; AssertJUnit.assertEquals("multiply", result, 0x6730f23000000000l); }
@Test
public void test05506() { x = 0x8000000000000000l; long result = x * 0xfffffef000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05507() { x = 0xffffffffffffffffl; long result = x * 0xfffffef000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000011000000000l); }
@Test
public void test05508() { x = 0xfffffffffffffffel; long result = x * 0xfffffef000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000022000000000l); }
@Test
public void test05509() { x = 0xefffffffffffffffl; long result = x * 0xfffffef000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000011000000000l); }
@Test
public void test05510() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffef000000000l; AssertJUnit.assertEquals("multiply", result, 0x6730f23000000000l); }
@Test
public void test05511() { x = 0x000000007fffffffl; long result = x * 0x23l; AssertJUnit.assertEquals("multiply", result, 0x000000117fffffddl); }
@Test
public void test05512() { x = 0x0000000080000000l; long result = x * 0x23l; AssertJUnit.assertEquals("multiply", result, 0x0000001180000000l); }
@Test
public void test05513() { x = 0x00000000ffffffffl; long result = x * 0x23l; AssertJUnit.assertEquals("multiply", result, 0x00000022ffffffddl); }
@Test
public void test05514() { x = 0x000000017fffffffl; long result = x * 0x23l; AssertJUnit.assertEquals("multiply", result, 0x000000347fffffddl); }
@Test
public void test05515() { x = 0x0000000180000000l; long result = x * 0x23l; AssertJUnit.assertEquals("multiply", result, 0x0000003480000000l); }
@Test
public void test05516() { x = 0x00000001ffffffffl; long result = x * 0x23l; AssertJUnit.assertEquals("multiply", result, 0x00000045ffffffddl); }
@Test
public void test05517() { x = 0xffffffff7fffffffl; long result = x * 0x23l; AssertJUnit.assertEquals("multiply", result, 0xffffffee7fffffddl); }
@Test
public void test05518() { x = 0xffffffff80000000l; long result = x * 0x23l; AssertJUnit.assertEquals("multiply", result, 0xffffffee80000000l); }
@Test
public void test05519() { x = 0x00000001deadf00dl; long result = x * 0x23l; AssertJUnit.assertEquals("multiply", result, 0x0000004171c7d1c7l); }
@Test
public void test05520() { x = 0xffffffffdeadf00dl; long result = x * 0x23l; AssertJUnit.assertEquals("multiply", result, 0xfffffffb71c7d1c7l); }
@Test
public void test05521() { x = 0x7fffffffffffffffl; long result = x * 0x23l; AssertJUnit.assertEquals("multiply", result, 0x7fffffffffffffddl); }
@Test
public void test05522() { x = 0x7fffffff7fffffffl; long result = x * 0x23l; AssertJUnit.assertEquals("multiply", result, 0x7fffffee7fffffddl); }
@Test
public void test05523() { x = 0x7fffffff80000000l; long result = x * 0x23l; AssertJUnit.assertEquals("multiply", result, 0x7fffffee80000000l); }
@Test
public void test05524() { x = 0x7fffffffdeadf00dl; long result = x * 0x23l; AssertJUnit.assertEquals("multiply", result, 0x7ffffffb71c7d1c7l); }
@Test
public void test05525() { x = 0x8000000000000000l; long result = x * 0x23l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test05526() { x = 0xffffffffffffffffl; long result = x * 0x23l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffddl); }
@Test
public void test05527() { x = 0xfffffffffffffffel; long result = x * 0x23l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffbal); }
@Test
public void test05528() { x = 0xefffffffffffffffl; long result = x * 0x23l; AssertJUnit.assertEquals("multiply", result, 0xcfffffffffffffddl); }
@Test
public void test05529() { x = 0xdeadf00ddeadf00dl; long result = x * 0x23l; AssertJUnit.assertEquals("multiply", result, 0x71c7d1e571c7d1c7l); }
@Test
public void test05530() { x = 0x000000007fffffffl; long result = x * 0x118l; AssertJUnit.assertEquals("multiply", result, 0x0000008bfffffee8l); }
@Test
public void test05531() { x = 0x0000000080000000l; long result = x * 0x118l; AssertJUnit.assertEquals("multiply", result, 0x0000008c00000000l); }
@Test
public void test05532() { x = 0x00000000ffffffffl; long result = x * 0x118l; AssertJUnit.assertEquals("multiply", result, 0x00000117fffffee8l); }
@Test
public void test05533() { x = 0x000000017fffffffl; long result = x * 0x118l; AssertJUnit.assertEquals("multiply", result, 0x000001a3fffffee8l); }
@Test
public void test05534() { x = 0x0000000180000000l; long result = x * 0x118l; AssertJUnit.assertEquals("multiply", result, 0x000001a400000000l); }
@Test
public void test05535() { x = 0x00000001ffffffffl; long result = x * 0x118l; AssertJUnit.assertEquals("multiply", result, 0x0000022ffffffee8l); }
@Test
public void test05536() { x = 0xffffffff7fffffffl; long result = x * 0x118l; AssertJUnit.assertEquals("multiply", result, 0xffffff73fffffee8l); }
@Test
public void test05537() { x = 0xffffffff80000000l; long result = x * 0x118l; AssertJUnit.assertEquals("multiply", result, 0xffffff7400000000l); }
@Test
public void test05538() { x = 0x00000001deadf00dl; long result = x * 0x118l; AssertJUnit.assertEquals("multiply", result, 0x0000020b8e3e8e38l); }
@Test
public void test05539() { x = 0xffffffffdeadf00dl; long result = x * 0x118l; AssertJUnit.assertEquals("multiply", result, 0xffffffdb8e3e8e38l); }
@Test
public void test05540() { x = 0x7fffffffffffffffl; long result = x * 0x118l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffee8l); }
@Test
public void test05541() { x = 0x7fffffff7fffffffl; long result = x * 0x118l; AssertJUnit.assertEquals("multiply", result, 0xffffff73fffffee8l); }
@Test
public void test05542() { x = 0x7fffffff80000000l; long result = x * 0x118l; AssertJUnit.assertEquals("multiply", result, 0xffffff7400000000l); }
@Test
public void test05543() { x = 0x7fffffffdeadf00dl; long result = x * 0x118l; AssertJUnit.assertEquals("multiply", result, 0xffffffdb8e3e8e38l); }
@Test
public void test05544() { x = 0x8000000000000000l; long result = x * 0x118l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05545() { x = 0xffffffffffffffffl; long result = x * 0x118l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffee8l); }
@Test
public void test05546() { x = 0xfffffffffffffffel; long result = x * 0x118l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffdd0l); }
@Test
public void test05547() { x = 0xefffffffffffffffl; long result = x * 0x118l; AssertJUnit.assertEquals("multiply", result, 0x7ffffffffffffee8l); }
@Test
public void test05548() { x = 0xdeadf00ddeadf00dl; long result = x * 0x118l; AssertJUnit.assertEquals("multiply", result, 0x8e3e8f2b8e3e8e38l); }
@Test
public void test05549() { x = 0x000000007fffffffl; long result = x * 0x2300l; AssertJUnit.assertEquals("multiply", result, 0x0000117fffffdd00l); }
@Test
public void test05550() { x = 0x0000000080000000l; long result = x * 0x2300l; AssertJUnit.assertEquals("multiply", result, 0x0000118000000000l); }
@Test
public void test05551() { x = 0x00000000ffffffffl; long result = x * 0x2300l; AssertJUnit.assertEquals("multiply", result, 0x000022ffffffdd00l); }
@Test
public void test05552() { x = 0x000000017fffffffl; long result = x * 0x2300l; AssertJUnit.assertEquals("multiply", result, 0x0000347fffffdd00l); }
@Test
public void test05553() { x = 0x0000000180000000l; long result = x * 0x2300l; AssertJUnit.assertEquals("multiply", result, 0x0000348000000000l); }
@Test
public void test05554() { x = 0x00000001ffffffffl; long result = x * 0x2300l; AssertJUnit.assertEquals("multiply", result, 0x000045ffffffdd00l); }
@Test
public void test05555() { x = 0xffffffff7fffffffl; long result = x * 0x2300l; AssertJUnit.assertEquals("multiply", result, 0xffffee7fffffdd00l); }
@Test
public void test05556() { x = 0xffffffff80000000l; long result = x * 0x2300l; AssertJUnit.assertEquals("multiply", result, 0xffffee8000000000l); }
@Test
public void test05557() { x = 0x00000001deadf00dl; long result = x * 0x2300l; AssertJUnit.assertEquals("multiply", result, 0x00004171c7d1c700l); }
@Test
public void test05558() { x = 0xffffffffdeadf00dl; long result = x * 0x2300l; AssertJUnit.assertEquals("multiply", result, 0xfffffb71c7d1c700l); }
@Test
public void test05559() { x = 0x7fffffffffffffffl; long result = x * 0x2300l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffdd00l); }
@Test
public void test05560() { x = 0x7fffffff7fffffffl; long result = x * 0x2300l; AssertJUnit.assertEquals("multiply", result, 0xffffee7fffffdd00l); }
@Test
public void test05561() { x = 0x7fffffff80000000l; long result = x * 0x2300l; AssertJUnit.assertEquals("multiply", result, 0xffffee8000000000l); }
@Test
public void test05562() { x = 0x7fffffffdeadf00dl; long result = x * 0x2300l; AssertJUnit.assertEquals("multiply", result, 0xfffffb71c7d1c700l); }
@Test
public void test05563() { x = 0x8000000000000000l; long result = x * 0x2300l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05564() { x = 0xffffffffffffffffl; long result = x * 0x2300l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffdd00l); }
@Test
public void test05565() { x = 0xfffffffffffffffel; long result = x * 0x2300l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffba00l); }
@Test
public void test05566() { x = 0xefffffffffffffffl; long result = x * 0x2300l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffdd00l); }
@Test
public void test05567() { x = 0xdeadf00ddeadf00dl; long result = x * 0x2300l; AssertJUnit.assertEquals("multiply", result, 0xc7d1e571c7d1c700l); }
@Test
public void test05568() { x = 0x000000007fffffffl; long result = x * 0x2300000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffdd00000000l); }
@Test
public void test05569() { x = 0x0000000080000000l; long result = x * 0x2300000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test05570() { x = 0x00000000ffffffffl; long result = x * 0x2300000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffdd00000000l); }
@Test
public void test05571() { x = 0x000000017fffffffl; long result = x * 0x2300000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffdd00000000l); }
@Test
public void test05572() { x = 0x0000000180000000l; long result = x * 0x2300000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test05573() { x = 0x00000001ffffffffl; long result = x * 0x2300000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffdd00000000l); }
@Test
public void test05574() { x = 0xffffffff7fffffffl; long result = x * 0x2300000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffdd00000000l); }
@Test
public void test05575() { x = 0xffffffff80000000l; long result = x * 0x2300000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test05576() { x = 0x00000001deadf00dl; long result = x * 0x2300000000l; AssertJUnit.assertEquals("multiply", result, 0x71c7d1c700000000l); }
@Test
public void test05577() { x = 0xffffffffdeadf00dl; long result = x * 0x2300000000l; AssertJUnit.assertEquals("multiply", result, 0x71c7d1c700000000l); }
@Test
public void test05578() { x = 0x7fffffffffffffffl; long result = x * 0x2300000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffdd00000000l); }
@Test
public void test05579() { x = 0x7fffffff7fffffffl; long result = x * 0x2300000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffdd00000000l); }
@Test
public void test05580() { x = 0x7fffffff80000000l; long result = x * 0x2300000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test05581() { x = 0x7fffffffdeadf00dl; long result = x * 0x2300000000l; AssertJUnit.assertEquals("multiply", result, 0x71c7d1c700000000l); }
@Test
public void test05582() { x = 0x8000000000000000l; long result = x * 0x2300000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05583() { x = 0xffffffffffffffffl; long result = x * 0x2300000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffdd00000000l); }
@Test
public void test05584() { x = 0xfffffffffffffffel; long result = x * 0x2300000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffba00000000l); }
@Test
public void test05585() { x = 0xefffffffffffffffl; long result = x * 0x2300000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffdd00000000l); }
@Test
public void test05586() { x = 0xdeadf00ddeadf00dl; long result = x * 0x2300000000l; AssertJUnit.assertEquals("multiply", result, 0x71c7d1c700000000l); }
@Test
public void test05587() { x = 0x000000007fffffffl; long result = x * 0x11800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffee800000000l); }
@Test
public void test05588() { x = 0x0000000080000000l; long result = x * 0x11800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05589() { x = 0x00000000ffffffffl; long result = x * 0x11800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffee800000000l); }
@Test
public void test05590() { x = 0x000000017fffffffl; long result = x * 0x11800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffee800000000l); }
@Test
public void test05591() { x = 0x0000000180000000l; long result = x * 0x11800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05592() { x = 0x00000001ffffffffl; long result = x * 0x11800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffee800000000l); }
@Test
public void test05593() { x = 0xffffffff7fffffffl; long result = x * 0x11800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffee800000000l); }
@Test
public void test05594() { x = 0xffffffff80000000l; long result = x * 0x11800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05595() { x = 0x00000001deadf00dl; long result = x * 0x11800000000l; AssertJUnit.assertEquals("multiply", result, 0x8e3e8e3800000000l); }
@Test
public void test05596() { x = 0xffffffffdeadf00dl; long result = x * 0x11800000000l; AssertJUnit.assertEquals("multiply", result, 0x8e3e8e3800000000l); }
@Test
public void test05597() { x = 0x7fffffffffffffffl; long result = x * 0x11800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffee800000000l); }
@Test
public void test05598() { x = 0x7fffffff7fffffffl; long result = x * 0x11800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffee800000000l); }
@Test
public void test05599() { x = 0x7fffffff80000000l; long result = x * 0x11800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05600() { x = 0x7fffffffdeadf00dl; long result = x * 0x11800000000l; AssertJUnit.assertEquals("multiply", result, 0x8e3e8e3800000000l); }
@Test
public void test05601() { x = 0x8000000000000000l; long result = x * 0x11800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05602() { x = 0xffffffffffffffffl; long result = x * 0x11800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffee800000000l); }
@Test
public void test05603() { x = 0xfffffffffffffffel; long result = x * 0x11800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffdd000000000l); }
@Test
public void test05604() { x = 0xefffffffffffffffl; long result = x * 0x11800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffee800000000l); }
@Test
public void test05605() { x = 0xdeadf00ddeadf00dl; long result = x * 0x11800000000l; AssertJUnit.assertEquals("multiply", result, 0x8e3e8e3800000000l); }
@Test
public void test05606() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffffddl; AssertJUnit.assertEquals("multiply", result, 0xffffffee80000023l); }
@Test
public void test05607() { x = 0x0000000080000000l; long result = x * 0xffffffffffffffddl; AssertJUnit.assertEquals("multiply", result, 0xffffffee80000000l); }
@Test
public void test05608() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffffddl; AssertJUnit.assertEquals("multiply", result, 0xffffffdd00000023l); }
@Test
public void test05609() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffffddl; AssertJUnit.assertEquals("multiply", result, 0xffffffcb80000023l); }
@Test
public void test05610() { x = 0x0000000180000000l; long result = x * 0xffffffffffffffddl; AssertJUnit.assertEquals("multiply", result, 0xffffffcb80000000l); }
@Test
public void test05611() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffffddl; AssertJUnit.assertEquals("multiply", result, 0xffffffba00000023l); }
@Test
public void test05612() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffffddl; AssertJUnit.assertEquals("multiply", result, 0x0000001180000023l); }
@Test
public void test05613() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffffddl; AssertJUnit.assertEquals("multiply", result, 0x0000001180000000l); }
@Test
public void test05614() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffffddl; AssertJUnit.assertEquals("multiply", result, 0xffffffbe8e382e39l); }
@Test
public void test05615() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffffddl; AssertJUnit.assertEquals("multiply", result, 0x000000048e382e39l); }
@Test
public void test05616() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffffddl; AssertJUnit.assertEquals("multiply", result, 0x8000000000000023l); }
@Test
public void test05617() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffffddl; AssertJUnit.assertEquals("multiply", result, 0x8000001180000023l); }
@Test
public void test05618() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffffddl; AssertJUnit.assertEquals("multiply", result, 0x8000001180000000l); }
@Test
public void test05619() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffffddl; AssertJUnit.assertEquals("multiply", result, 0x800000048e382e39l); }
@Test
public void test05620() { x = 0x8000000000000000l; long result = x * 0xffffffffffffffddl; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test05621() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffffddl; AssertJUnit.assertEquals("multiply", result, 0x0000000000000023l); }
@Test
public void test05622() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffffddl; AssertJUnit.assertEquals("multiply", result, 0x0000000000000046l); }
@Test
public void test05623() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffffddl; AssertJUnit.assertEquals("multiply", result, 0x3000000000000023l); }
@Test
public void test05624() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffffddl; AssertJUnit.assertEquals("multiply", result, 0x8e382e1a8e382e39l); }
@Test
public void test05625() { x = 0x000000007fffffffl; long result = x * 0xfffffffffffffee8l; AssertJUnit.assertEquals("multiply", result, 0xffffff7400000118l); }
@Test
public void test05626() { x = 0x0000000080000000l; long result = x * 0xfffffffffffffee8l; AssertJUnit.assertEquals("multiply", result, 0xffffff7400000000l); }
@Test
public void test05627() { x = 0x00000000ffffffffl; long result = x * 0xfffffffffffffee8l; AssertJUnit.assertEquals("multiply", result, 0xfffffee800000118l); }
@Test
public void test05628() { x = 0x000000017fffffffl; long result = x * 0xfffffffffffffee8l; AssertJUnit.assertEquals("multiply", result, 0xfffffe5c00000118l); }
@Test
public void test05629() { x = 0x0000000180000000l; long result = x * 0xfffffffffffffee8l; AssertJUnit.assertEquals("multiply", result, 0xfffffe5c00000000l); }
@Test
public void test05630() { x = 0x00000001ffffffffl; long result = x * 0xfffffffffffffee8l; AssertJUnit.assertEquals("multiply", result, 0xfffffdd000000118l); }
@Test
public void test05631() { x = 0xffffffff7fffffffl; long result = x * 0xfffffffffffffee8l; AssertJUnit.assertEquals("multiply", result, 0x0000008c00000118l); }
@Test
public void test05632() { x = 0xffffffff80000000l; long result = x * 0xfffffffffffffee8l; AssertJUnit.assertEquals("multiply", result, 0x0000008c00000000l); }
@Test
public void test05633() { x = 0x00000001deadf00dl; long result = x * 0xfffffffffffffee8l; AssertJUnit.assertEquals("multiply", result, 0xfffffdf471c171c8l); }
@Test
public void test05634() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffffffffffee8l; AssertJUnit.assertEquals("multiply", result, 0x0000002471c171c8l); }
@Test
public void test05635() { x = 0x7fffffffffffffffl; long result = x * 0xfffffffffffffee8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000118l); }
@Test
public void test05636() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffffffffffee8l; AssertJUnit.assertEquals("multiply", result, 0x0000008c00000118l); }
@Test
public void test05637() { x = 0x7fffffff80000000l; long result = x * 0xfffffffffffffee8l; AssertJUnit.assertEquals("multiply", result, 0x0000008c00000000l); }
@Test
public void test05638() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffffffffffee8l; AssertJUnit.assertEquals("multiply", result, 0x0000002471c171c8l); }
@Test
public void test05639() { x = 0x8000000000000000l; long result = x * 0xfffffffffffffee8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05640() { x = 0xffffffffffffffffl; long result = x * 0xfffffffffffffee8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000118l); }
@Test
public void test05641() { x = 0xfffffffffffffffel; long result = x * 0xfffffffffffffee8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000230l); }
@Test
public void test05642() { x = 0xefffffffffffffffl; long result = x * 0xfffffffffffffee8l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000118l); }
@Test
public void test05643() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffffffffffee8l; AssertJUnit.assertEquals("multiply", result, 0x71c170d471c171c8l); }
@Test
public void test05644() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffdd00l; AssertJUnit.assertEquals("multiply", result, 0xffffee8000002300l); }
@Test
public void test05645() { x = 0x0000000080000000l; long result = x * 0xffffffffffffdd00l; AssertJUnit.assertEquals("multiply", result, 0xffffee8000000000l); }
@Test
public void test05646() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffdd00l; AssertJUnit.assertEquals("multiply", result, 0xffffdd0000002300l); }
@Test
public void test05647() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffdd00l; AssertJUnit.assertEquals("multiply", result, 0xffffcb8000002300l); }
@Test
public void test05648() { x = 0x0000000180000000l; long result = x * 0xffffffffffffdd00l; AssertJUnit.assertEquals("multiply", result, 0xffffcb8000000000l); }
@Test
public void test05649() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffdd00l; AssertJUnit.assertEquals("multiply", result, 0xffffba0000002300l); }
@Test
public void test05650() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffdd00l; AssertJUnit.assertEquals("multiply", result, 0x0000118000002300l); }
@Test
public void test05651() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffdd00l; AssertJUnit.assertEquals("multiply", result, 0x0000118000000000l); }
@Test
public void test05652() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffdd00l; AssertJUnit.assertEquals("multiply", result, 0xffffbe8e382e3900l); }
@Test
public void test05653() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffdd00l; AssertJUnit.assertEquals("multiply", result, 0x0000048e382e3900l); }
@Test
public void test05654() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffdd00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000002300l); }
@Test
public void test05655() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffdd00l; AssertJUnit.assertEquals("multiply", result, 0x0000118000002300l); }
@Test
public void test05656() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffdd00l; AssertJUnit.assertEquals("multiply", result, 0x0000118000000000l); }
@Test
public void test05657() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffdd00l; AssertJUnit.assertEquals("multiply", result, 0x0000048e382e3900l); }
@Test
public void test05658() { x = 0x8000000000000000l; long result = x * 0xffffffffffffdd00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05659() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffdd00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000002300l); }
@Test
public void test05660() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffdd00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000004600l); }
@Test
public void test05661() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffdd00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000002300l); }
@Test
public void test05662() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffdd00l; AssertJUnit.assertEquals("multiply", result, 0x382e1a8e382e3900l); }
@Test
public void test05663() { x = 0x000000007fffffffl; long result = x * 0xffffffdd00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000002300000000l); }
@Test
public void test05664() { x = 0x0000000080000000l; long result = x * 0xffffffdd00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test05665() { x = 0x00000000ffffffffl; long result = x * 0xffffffdd00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002300000000l); }
@Test
public void test05666() { x = 0x000000017fffffffl; long result = x * 0xffffffdd00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000002300000000l); }
@Test
public void test05667() { x = 0x0000000180000000l; long result = x * 0xffffffdd00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test05668() { x = 0x00000001ffffffffl; long result = x * 0xffffffdd00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002300000000l); }
@Test
public void test05669() { x = 0xffffffff7fffffffl; long result = x * 0xffffffdd00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000002300000000l); }
@Test
public void test05670() { x = 0xffffffff80000000l; long result = x * 0xffffffdd00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test05671() { x = 0x00000001deadf00dl; long result = x * 0xffffffdd00000000l; AssertJUnit.assertEquals("multiply", result, 0x8e382e3900000000l); }
@Test
public void test05672() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffdd00000000l; AssertJUnit.assertEquals("multiply", result, 0x8e382e3900000000l); }
@Test
public void test05673() { x = 0x7fffffffffffffffl; long result = x * 0xffffffdd00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002300000000l); }
@Test
public void test05674() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffdd00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000002300000000l); }
@Test
public void test05675() { x = 0x7fffffff80000000l; long result = x * 0xffffffdd00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test05676() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffdd00000000l; AssertJUnit.assertEquals("multiply", result, 0x8e382e3900000000l); }
@Test
public void test05677() { x = 0x8000000000000000l; long result = x * 0xffffffdd00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05678() { x = 0xffffffffffffffffl; long result = x * 0xffffffdd00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002300000000l); }
@Test
public void test05679() { x = 0xfffffffffffffffel; long result = x * 0xffffffdd00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000004600000000l); }
@Test
public void test05680() { x = 0xefffffffffffffffl; long result = x * 0xffffffdd00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002300000000l); }
@Test
public void test05681() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffdd00000000l; AssertJUnit.assertEquals("multiply", result, 0x8e382e3900000000l); }
@Test
public void test05682() { x = 0x000000007fffffffl; long result = x * 0xfffffee800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000011800000000l); }
@Test
public void test05683() { x = 0x0000000080000000l; long result = x * 0xfffffee800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05684() { x = 0x00000000ffffffffl; long result = x * 0xfffffee800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000011800000000l); }
@Test
public void test05685() { x = 0x000000017fffffffl; long result = x * 0xfffffee800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000011800000000l); }
@Test
public void test05686() { x = 0x0000000180000000l; long result = x * 0xfffffee800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05687() { x = 0x00000001ffffffffl; long result = x * 0xfffffee800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000011800000000l); }
@Test
public void test05688() { x = 0xffffffff7fffffffl; long result = x * 0xfffffee800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000011800000000l); }
@Test
public void test05689() { x = 0xffffffff80000000l; long result = x * 0xfffffee800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05690() { x = 0x00000001deadf00dl; long result = x * 0xfffffee800000000l; AssertJUnit.assertEquals("multiply", result, 0x71c171c800000000l); }
@Test
public void test05691() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffee800000000l; AssertJUnit.assertEquals("multiply", result, 0x71c171c800000000l); }
@Test
public void test05692() { x = 0x7fffffffffffffffl; long result = x * 0xfffffee800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000011800000000l); }
@Test
public void test05693() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffee800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000011800000000l); }
@Test
public void test05694() { x = 0x7fffffff80000000l; long result = x * 0xfffffee800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05695() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffee800000000l; AssertJUnit.assertEquals("multiply", result, 0x71c171c800000000l); }
@Test
public void test05696() { x = 0x8000000000000000l; long result = x * 0xfffffee800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05697() { x = 0xffffffffffffffffl; long result = x * 0xfffffee800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000011800000000l); }
@Test
public void test05698() { x = 0xfffffffffffffffel; long result = x * 0xfffffee800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000023000000000l); }
@Test
public void test05699() { x = 0xefffffffffffffffl; long result = x * 0xfffffee800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000011800000000l); }
@Test
public void test05700() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffee800000000l; AssertJUnit.assertEquals("multiply", result, 0x71c171c800000000l); }
@Test
public void test05701() { x = 0x000000007fffffffl; long result = x * 0x24l; AssertJUnit.assertEquals("multiply", result, 0x00000011ffffffdcl); }
@Test
public void test05702() { x = 0x0000000080000000l; long result = x * 0x24l; AssertJUnit.assertEquals("multiply", result, 0x0000001200000000l); }
@Test
public void test05703() { x = 0x00000000ffffffffl; long result = x * 0x24l; AssertJUnit.assertEquals("multiply", result, 0x00000023ffffffdcl); }
@Test
public void test05704() { x = 0x000000017fffffffl; long result = x * 0x24l; AssertJUnit.assertEquals("multiply", result, 0x00000035ffffffdcl); }
@Test
public void test05705() { x = 0x0000000180000000l; long result = x * 0x24l; AssertJUnit.assertEquals("multiply", result, 0x0000003600000000l); }
@Test
public void test05706() { x = 0x00000001ffffffffl; long result = x * 0x24l; AssertJUnit.assertEquals("multiply", result, 0x00000047ffffffdcl); }
@Test
public void test05707() { x = 0xffffffff7fffffffl; long result = x * 0x24l; AssertJUnit.assertEquals("multiply", result, 0xffffffedffffffdcl); }
@Test
public void test05708() { x = 0xffffffff80000000l; long result = x * 0x24l; AssertJUnit.assertEquals("multiply", result, 0xffffffee00000000l); }
@Test
public void test05709() { x = 0x00000001deadf00dl; long result = x * 0x24l; AssertJUnit.assertEquals("multiply", result, 0x000000435075c1d4l); }
@Test
public void test05710() { x = 0xffffffffdeadf00dl; long result = x * 0x24l; AssertJUnit.assertEquals("multiply", result, 0xfffffffb5075c1d4l); }
@Test
public void test05711() { x = 0x7fffffffffffffffl; long result = x * 0x24l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffdcl); }
@Test
public void test05712() { x = 0x7fffffff7fffffffl; long result = x * 0x24l; AssertJUnit.assertEquals("multiply", result, 0xffffffedffffffdcl); }
@Test
public void test05713() { x = 0x7fffffff80000000l; long result = x * 0x24l; AssertJUnit.assertEquals("multiply", result, 0xffffffee00000000l); }
@Test
public void test05714() { x = 0x7fffffffdeadf00dl; long result = x * 0x24l; AssertJUnit.assertEquals("multiply", result, 0xfffffffb5075c1d4l); }
@Test
public void test05715() { x = 0x8000000000000000l; long result = x * 0x24l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05716() { x = 0xffffffffffffffffl; long result = x * 0x24l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffdcl); }
@Test
public void test05717() { x = 0xfffffffffffffffel; long result = x * 0x24l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffb8l); }
@Test
public void test05718() { x = 0xefffffffffffffffl; long result = x * 0x24l; AssertJUnit.assertEquals("multiply", result, 0xbfffffffffffffdcl); }
@Test
public void test05719() { x = 0xdeadf00ddeadf00dl; long result = x * 0x24l; AssertJUnit.assertEquals("multiply", result, 0x5075c1f35075c1d4l); }
@Test
public void test05720() { x = 0x000000007fffffffl; long result = x * 0x120l; AssertJUnit.assertEquals("multiply", result, 0x0000008ffffffee0l); }
@Test
public void test05721() { x = 0x0000000080000000l; long result = x * 0x120l; AssertJUnit.assertEquals("multiply", result, 0x0000009000000000l); }
@Test
public void test05722() { x = 0x00000000ffffffffl; long result = x * 0x120l; AssertJUnit.assertEquals("multiply", result, 0x0000011ffffffee0l); }
@Test
public void test05723() { x = 0x000000017fffffffl; long result = x * 0x120l; AssertJUnit.assertEquals("multiply", result, 0x000001affffffee0l); }
@Test
public void test05724() { x = 0x0000000180000000l; long result = x * 0x120l; AssertJUnit.assertEquals("multiply", result, 0x000001b000000000l); }
@Test
public void test05725() { x = 0x00000001ffffffffl; long result = x * 0x120l; AssertJUnit.assertEquals("multiply", result, 0x0000023ffffffee0l); }
@Test
public void test05726() { x = 0xffffffff7fffffffl; long result = x * 0x120l; AssertJUnit.assertEquals("multiply", result, 0xffffff6ffffffee0l); }
@Test
public void test05727() { x = 0xffffffff80000000l; long result = x * 0x120l; AssertJUnit.assertEquals("multiply", result, 0xffffff7000000000l); }
@Test
public void test05728() { x = 0x00000001deadf00dl; long result = x * 0x120l; AssertJUnit.assertEquals("multiply", result, 0x0000021a83ae0ea0l); }
@Test
public void test05729() { x = 0xffffffffdeadf00dl; long result = x * 0x120l; AssertJUnit.assertEquals("multiply", result, 0xffffffda83ae0ea0l); }
@Test
public void test05730() { x = 0x7fffffffffffffffl; long result = x * 0x120l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffee0l); }
@Test
public void test05731() { x = 0x7fffffff7fffffffl; long result = x * 0x120l; AssertJUnit.assertEquals("multiply", result, 0xffffff6ffffffee0l); }
@Test
public void test05732() { x = 0x7fffffff80000000l; long result = x * 0x120l; AssertJUnit.assertEquals("multiply", result, 0xffffff7000000000l); }
@Test
public void test05733() { x = 0x7fffffffdeadf00dl; long result = x * 0x120l; AssertJUnit.assertEquals("multiply", result, 0xffffffda83ae0ea0l); }
@Test
public void test05734() { x = 0x8000000000000000l; long result = x * 0x120l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05735() { x = 0xffffffffffffffffl; long result = x * 0x120l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffee0l); }
@Test
public void test05736() { x = 0xfffffffffffffffel; long result = x * 0x120l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffdc0l); }
@Test
public void test05737() { x = 0xefffffffffffffffl; long result = x * 0x120l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffee0l); }
@Test
public void test05738() { x = 0xdeadf00ddeadf00dl; long result = x * 0x120l; AssertJUnit.assertEquals("multiply", result, 0x83ae0f9a83ae0ea0l); }
@Test
public void test05739() { x = 0x000000007fffffffl; long result = x * 0x2400l; AssertJUnit.assertEquals("multiply", result, 0x000011ffffffdc00l); }
@Test
public void test05740() { x = 0x0000000080000000l; long result = x * 0x2400l; AssertJUnit.assertEquals("multiply", result, 0x0000120000000000l); }
@Test
public void test05741() { x = 0x00000000ffffffffl; long result = x * 0x2400l; AssertJUnit.assertEquals("multiply", result, 0x000023ffffffdc00l); }
@Test
public void test05742() { x = 0x000000017fffffffl; long result = x * 0x2400l; AssertJUnit.assertEquals("multiply", result, 0x000035ffffffdc00l); }
@Test
public void test05743() { x = 0x0000000180000000l; long result = x * 0x2400l; AssertJUnit.assertEquals("multiply", result, 0x0000360000000000l); }
@Test
public void test05744() { x = 0x00000001ffffffffl; long result = x * 0x2400l; AssertJUnit.assertEquals("multiply", result, 0x000047ffffffdc00l); }
@Test
public void test05745() { x = 0xffffffff7fffffffl; long result = x * 0x2400l; AssertJUnit.assertEquals("multiply", result, 0xffffedffffffdc00l); }
@Test
public void test05746() { x = 0xffffffff80000000l; long result = x * 0x2400l; AssertJUnit.assertEquals("multiply", result, 0xffffee0000000000l); }
@Test
public void test05747() { x = 0x00000001deadf00dl; long result = x * 0x2400l; AssertJUnit.assertEquals("multiply", result, 0x0000435075c1d400l); }
@Test
public void test05748() { x = 0xffffffffdeadf00dl; long result = x * 0x2400l; AssertJUnit.assertEquals("multiply", result, 0xfffffb5075c1d400l); }
@Test
public void test05749() { x = 0x7fffffffffffffffl; long result = x * 0x2400l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffdc00l); }
@Test
public void test05750() { x = 0x7fffffff7fffffffl; long result = x * 0x2400l; AssertJUnit.assertEquals("multiply", result, 0xffffedffffffdc00l); }
@Test
public void test05751() { x = 0x7fffffff80000000l; long result = x * 0x2400l; AssertJUnit.assertEquals("multiply", result, 0xffffee0000000000l); }
@Test
public void test05752() { x = 0x7fffffffdeadf00dl; long result = x * 0x2400l; AssertJUnit.assertEquals("multiply", result, 0xfffffb5075c1d400l); }
@Test
public void test05753() { x = 0x8000000000000000l; long result = x * 0x2400l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05754() { x = 0xffffffffffffffffl; long result = x * 0x2400l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffdc00l); }
@Test
public void test05755() { x = 0xfffffffffffffffel; long result = x * 0x2400l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffb800l); }
@Test
public void test05756() { x = 0xefffffffffffffffl; long result = x * 0x2400l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffdc00l); }
@Test
public void test05757() { x = 0xdeadf00ddeadf00dl; long result = x * 0x2400l; AssertJUnit.assertEquals("multiply", result, 0x75c1f35075c1d400l); }
@Test
public void test05758() { x = 0x000000007fffffffl; long result = x * 0x2400000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffdc00000000l); }
@Test
public void test05759() { x = 0x0000000080000000l; long result = x * 0x2400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05760() { x = 0x00000000ffffffffl; long result = x * 0x2400000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffdc00000000l); }
@Test
public void test05761() { x = 0x000000017fffffffl; long result = x * 0x2400000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffdc00000000l); }
@Test
public void test05762() { x = 0x0000000180000000l; long result = x * 0x2400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05763() { x = 0x00000001ffffffffl; long result = x * 0x2400000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffdc00000000l); }
@Test
public void test05764() { x = 0xffffffff7fffffffl; long result = x * 0x2400000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffdc00000000l); }
@Test
public void test05765() { x = 0xffffffff80000000l; long result = x * 0x2400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05766() { x = 0x00000001deadf00dl; long result = x * 0x2400000000l; AssertJUnit.assertEquals("multiply", result, 0x5075c1d400000000l); }
@Test
public void test05767() { x = 0xffffffffdeadf00dl; long result = x * 0x2400000000l; AssertJUnit.assertEquals("multiply", result, 0x5075c1d400000000l); }
@Test
public void test05768() { x = 0x7fffffffffffffffl; long result = x * 0x2400000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffdc00000000l); }
@Test
public void test05769() { x = 0x7fffffff7fffffffl; long result = x * 0x2400000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffdc00000000l); }
@Test
public void test05770() { x = 0x7fffffff80000000l; long result = x * 0x2400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05771() { x = 0x7fffffffdeadf00dl; long result = x * 0x2400000000l; AssertJUnit.assertEquals("multiply", result, 0x5075c1d400000000l); }
@Test
public void test05772() { x = 0x8000000000000000l; long result = x * 0x2400000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05773() { x = 0xffffffffffffffffl; long result = x * 0x2400000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffdc00000000l); }
@Test
public void test05774() { x = 0xfffffffffffffffel; long result = x * 0x2400000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffb800000000l); }
@Test
public void test05775() { x = 0xefffffffffffffffl; long result = x * 0x2400000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffdc00000000l); }
@Test
public void test05776() { x = 0xdeadf00ddeadf00dl; long result = x * 0x2400000000l; AssertJUnit.assertEquals("multiply", result, 0x5075c1d400000000l); }
@Test
public void test05777() { x = 0x000000007fffffffl; long result = x * 0x12000000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffee000000000l); }
@Test
public void test05778() { x = 0x0000000080000000l; long result = x * 0x12000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05779() { x = 0x00000000ffffffffl; long result = x * 0x12000000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffee000000000l); }
@Test
public void test05780() { x = 0x000000017fffffffl; long result = x * 0x12000000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffee000000000l); }
@Test
public void test05781() { x = 0x0000000180000000l; long result = x * 0x12000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05782() { x = 0x00000001ffffffffl; long result = x * 0x12000000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffee000000000l); }
@Test
public void test05783() { x = 0xffffffff7fffffffl; long result = x * 0x12000000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffee000000000l); }
@Test
public void test05784() { x = 0xffffffff80000000l; long result = x * 0x12000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05785() { x = 0x00000001deadf00dl; long result = x * 0x12000000000l; AssertJUnit.assertEquals("multiply", result, 0x83ae0ea000000000l); }
@Test
public void test05786() { x = 0xffffffffdeadf00dl; long result = x * 0x12000000000l; AssertJUnit.assertEquals("multiply", result, 0x83ae0ea000000000l); }
@Test
public void test05787() { x = 0x7fffffffffffffffl; long result = x * 0x12000000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffee000000000l); }
@Test
public void test05788() { x = 0x7fffffff7fffffffl; long result = x * 0x12000000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffee000000000l); }
@Test
public void test05789() { x = 0x7fffffff80000000l; long result = x * 0x12000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05790() { x = 0x7fffffffdeadf00dl; long result = x * 0x12000000000l; AssertJUnit.assertEquals("multiply", result, 0x83ae0ea000000000l); }
@Test
public void test05791() { x = 0x8000000000000000l; long result = x * 0x12000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05792() { x = 0xffffffffffffffffl; long result = x * 0x12000000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffee000000000l); }
@Test
public void test05793() { x = 0xfffffffffffffffel; long result = x * 0x12000000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffdc000000000l); }
@Test
public void test05794() { x = 0xefffffffffffffffl; long result = x * 0x12000000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffee000000000l); }
@Test
public void test05795() { x = 0xdeadf00ddeadf00dl; long result = x * 0x12000000000l; AssertJUnit.assertEquals("multiply", result, 0x83ae0ea000000000l); }
@Test
public void test05796() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffffdcl; AssertJUnit.assertEquals("multiply", result, 0xffffffee00000024l); }
@Test
public void test05797() { x = 0x0000000080000000l; long result = x * 0xffffffffffffffdcl; AssertJUnit.assertEquals("multiply", result, 0xffffffee00000000l); }
@Test
public void test05798() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffffdcl; AssertJUnit.assertEquals("multiply", result, 0xffffffdc00000024l); }
@Test
public void test05799() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffffdcl; AssertJUnit.assertEquals("multiply", result, 0xffffffca00000024l); }
@Test
public void test05800() { x = 0x0000000180000000l; long result = x * 0xffffffffffffffdcl; AssertJUnit.assertEquals("multiply", result, 0xffffffca00000000l); }
@Test
public void test05801() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffffdcl; AssertJUnit.assertEquals("multiply", result, 0xffffffb800000024l); }
@Test
public void test05802() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffffdcl; AssertJUnit.assertEquals("multiply", result, 0x0000001200000024l); }
@Test
public void test05803() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffffdcl; AssertJUnit.assertEquals("multiply", result, 0x0000001200000000l); }
@Test
public void test05804() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffffdcl; AssertJUnit.assertEquals("multiply", result, 0xffffffbcaf8a3e2cl); }
@Test
public void test05805() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffffdcl; AssertJUnit.assertEquals("multiply", result, 0x00000004af8a3e2cl); }
@Test
public void test05806() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffffdcl; AssertJUnit.assertEquals("multiply", result, 0x0000000000000024l); }
@Test
public void test05807() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffffdcl; AssertJUnit.assertEquals("multiply", result, 0x0000001200000024l); }
@Test
public void test05808() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffffdcl; AssertJUnit.assertEquals("multiply", result, 0x0000001200000000l); }
@Test
public void test05809() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffffdcl; AssertJUnit.assertEquals("multiply", result, 0x00000004af8a3e2cl); }
@Test
public void test05810() { x = 0x8000000000000000l; long result = x * 0xffffffffffffffdcl; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05811() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffffdcl; AssertJUnit.assertEquals("multiply", result, 0x0000000000000024l); }
@Test
public void test05812() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffffdcl; AssertJUnit.assertEquals("multiply", result, 0x0000000000000048l); }
@Test
public void test05813() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffffdcl; AssertJUnit.assertEquals("multiply", result, 0x4000000000000024l); }
@Test
public void test05814() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffffdcl; AssertJUnit.assertEquals("multiply", result, 0xaf8a3e0caf8a3e2cl); }
@Test
public void test05815() { x = 0x000000007fffffffl; long result = x * 0xfffffffffffffee0l; AssertJUnit.assertEquals("multiply", result, 0xffffff7000000120l); }
@Test
public void test05816() { x = 0x0000000080000000l; long result = x * 0xfffffffffffffee0l; AssertJUnit.assertEquals("multiply", result, 0xffffff7000000000l); }
@Test
public void test05817() { x = 0x00000000ffffffffl; long result = x * 0xfffffffffffffee0l; AssertJUnit.assertEquals("multiply", result, 0xfffffee000000120l); }
@Test
public void test05818() { x = 0x000000017fffffffl; long result = x * 0xfffffffffffffee0l; AssertJUnit.assertEquals("multiply", result, 0xfffffe5000000120l); }
@Test
public void test05819() { x = 0x0000000180000000l; long result = x * 0xfffffffffffffee0l; AssertJUnit.assertEquals("multiply", result, 0xfffffe5000000000l); }
@Test
public void test05820() { x = 0x00000001ffffffffl; long result = x * 0xfffffffffffffee0l; AssertJUnit.assertEquals("multiply", result, 0xfffffdc000000120l); }
@Test
public void test05821() { x = 0xffffffff7fffffffl; long result = x * 0xfffffffffffffee0l; AssertJUnit.assertEquals("multiply", result, 0x0000009000000120l); }
@Test
public void test05822() { x = 0xffffffff80000000l; long result = x * 0xfffffffffffffee0l; AssertJUnit.assertEquals("multiply", result, 0x0000009000000000l); }
@Test
public void test05823() { x = 0x00000001deadf00dl; long result = x * 0xfffffffffffffee0l; AssertJUnit.assertEquals("multiply", result, 0xfffffde57c51f160l); }
@Test
public void test05824() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffffffffffee0l; AssertJUnit.assertEquals("multiply", result, 0x000000257c51f160l); }
@Test
public void test05825() { x = 0x7fffffffffffffffl; long result = x * 0xfffffffffffffee0l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000120l); }
@Test
public void test05826() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffffffffffee0l; AssertJUnit.assertEquals("multiply", result, 0x0000009000000120l); }
@Test
public void test05827() { x = 0x7fffffff80000000l; long result = x * 0xfffffffffffffee0l; AssertJUnit.assertEquals("multiply", result, 0x0000009000000000l); }
@Test
public void test05828() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffffffffffee0l; AssertJUnit.assertEquals("multiply", result, 0x000000257c51f160l); }
@Test
public void test05829() { x = 0x8000000000000000l; long result = x * 0xfffffffffffffee0l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05830() { x = 0xffffffffffffffffl; long result = x * 0xfffffffffffffee0l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000120l); }
@Test
public void test05831() { x = 0xfffffffffffffffel; long result = x * 0xfffffffffffffee0l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000240l); }
@Test
public void test05832() { x = 0xefffffffffffffffl; long result = x * 0xfffffffffffffee0l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000120l); }
@Test
public void test05833() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffffffffffee0l; AssertJUnit.assertEquals("multiply", result, 0x7c51f0657c51f160l); }
@Test
public void test05834() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffdc00l; AssertJUnit.assertEquals("multiply", result, 0xffffee0000002400l); }
@Test
public void test05835() { x = 0x0000000080000000l; long result = x * 0xffffffffffffdc00l; AssertJUnit.assertEquals("multiply", result, 0xffffee0000000000l); }
@Test
public void test05836() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffdc00l; AssertJUnit.assertEquals("multiply", result, 0xffffdc0000002400l); }
@Test
public void test05837() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffdc00l; AssertJUnit.assertEquals("multiply", result, 0xffffca0000002400l); }
@Test
public void test05838() { x = 0x0000000180000000l; long result = x * 0xffffffffffffdc00l; AssertJUnit.assertEquals("multiply", result, 0xffffca0000000000l); }
@Test
public void test05839() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffdc00l; AssertJUnit.assertEquals("multiply", result, 0xffffb80000002400l); }
@Test
public void test05840() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffdc00l; AssertJUnit.assertEquals("multiply", result, 0x0000120000002400l); }
@Test
public void test05841() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffdc00l; AssertJUnit.assertEquals("multiply", result, 0x0000120000000000l); }
@Test
public void test05842() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffdc00l; AssertJUnit.assertEquals("multiply", result, 0xffffbcaf8a3e2c00l); }
@Test
public void test05843() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffdc00l; AssertJUnit.assertEquals("multiply", result, 0x000004af8a3e2c00l); }
@Test
public void test05844() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffdc00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000002400l); }
@Test
public void test05845() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffdc00l; AssertJUnit.assertEquals("multiply", result, 0x0000120000002400l); }
@Test
public void test05846() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffdc00l; AssertJUnit.assertEquals("multiply", result, 0x0000120000000000l); }
@Test
public void test05847() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffdc00l; AssertJUnit.assertEquals("multiply", result, 0x000004af8a3e2c00l); }
@Test
public void test05848() { x = 0x8000000000000000l; long result = x * 0xffffffffffffdc00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05849() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffdc00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000002400l); }
@Test
public void test05850() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffdc00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000004800l); }
@Test
public void test05851() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffdc00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000002400l); }
@Test
public void test05852() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffdc00l; AssertJUnit.assertEquals("multiply", result, 0x8a3e0caf8a3e2c00l); }
@Test
public void test05853() { x = 0x000000007fffffffl; long result = x * 0xffffffdc00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002400000000l); }
@Test
public void test05854() { x = 0x0000000080000000l; long result = x * 0xffffffdc00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05855() { x = 0x00000000ffffffffl; long result = x * 0xffffffdc00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002400000000l); }
@Test
public void test05856() { x = 0x000000017fffffffl; long result = x * 0xffffffdc00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002400000000l); }
@Test
public void test05857() { x = 0x0000000180000000l; long result = x * 0xffffffdc00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05858() { x = 0x00000001ffffffffl; long result = x * 0xffffffdc00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002400000000l); }
@Test
public void test05859() { x = 0xffffffff7fffffffl; long result = x * 0xffffffdc00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002400000000l); }
@Test
public void test05860() { x = 0xffffffff80000000l; long result = x * 0xffffffdc00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05861() { x = 0x00000001deadf00dl; long result = x * 0xffffffdc00000000l; AssertJUnit.assertEquals("multiply", result, 0xaf8a3e2c00000000l); }
@Test
public void test05862() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffdc00000000l; AssertJUnit.assertEquals("multiply", result, 0xaf8a3e2c00000000l); }
@Test
public void test05863() { x = 0x7fffffffffffffffl; long result = x * 0xffffffdc00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002400000000l); }
@Test
public void test05864() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffdc00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002400000000l); }
@Test
public void test05865() { x = 0x7fffffff80000000l; long result = x * 0xffffffdc00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05866() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffdc00000000l; AssertJUnit.assertEquals("multiply", result, 0xaf8a3e2c00000000l); }
@Test
public void test05867() { x = 0x8000000000000000l; long result = x * 0xffffffdc00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05868() { x = 0xffffffffffffffffl; long result = x * 0xffffffdc00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002400000000l); }
@Test
public void test05869() { x = 0xfffffffffffffffel; long result = x * 0xffffffdc00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000004800000000l); }
@Test
public void test05870() { x = 0xefffffffffffffffl; long result = x * 0xffffffdc00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002400000000l); }
@Test
public void test05871() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffdc00000000l; AssertJUnit.assertEquals("multiply", result, 0xaf8a3e2c00000000l); }
@Test
public void test05872() { x = 0x000000007fffffffl; long result = x * 0xfffffee000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000012000000000l); }
@Test
public void test05873() { x = 0x0000000080000000l; long result = x * 0xfffffee000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05874() { x = 0x00000000ffffffffl; long result = x * 0xfffffee000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000012000000000l); }
@Test
public void test05875() { x = 0x000000017fffffffl; long result = x * 0xfffffee000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000012000000000l); }
@Test
public void test05876() { x = 0x0000000180000000l; long result = x * 0xfffffee000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05877() { x = 0x00000001ffffffffl; long result = x * 0xfffffee000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000012000000000l); }
@Test
public void test05878() { x = 0xffffffff7fffffffl; long result = x * 0xfffffee000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000012000000000l); }
@Test
public void test05879() { x = 0xffffffff80000000l; long result = x * 0xfffffee000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05880() { x = 0x00000001deadf00dl; long result = x * 0xfffffee000000000l; AssertJUnit.assertEquals("multiply", result, 0x7c51f16000000000l); }
@Test
public void test05881() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffee000000000l; AssertJUnit.assertEquals("multiply", result, 0x7c51f16000000000l); }
@Test
public void test05882() { x = 0x7fffffffffffffffl; long result = x * 0xfffffee000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000012000000000l); }
@Test
public void test05883() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffee000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000012000000000l); }
@Test
public void test05884() { x = 0x7fffffff80000000l; long result = x * 0xfffffee000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05885() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffee000000000l; AssertJUnit.assertEquals("multiply", result, 0x7c51f16000000000l); }
@Test
public void test05886() { x = 0x8000000000000000l; long result = x * 0xfffffee000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05887() { x = 0xffffffffffffffffl; long result = x * 0xfffffee000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000012000000000l); }
@Test
public void test05888() { x = 0xfffffffffffffffel; long result = x * 0xfffffee000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000024000000000l); }
@Test
public void test05889() { x = 0xefffffffffffffffl; long result = x * 0xfffffee000000000l; AssertJUnit.assertEquals("multiply", result, 0x0000012000000000l); }
@Test
public void test05890() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffee000000000l; AssertJUnit.assertEquals("multiply", result, 0x7c51f16000000000l); }
@Test
public void test05891() { x = 0x000000007fffffffl; long result = x * 0x25l; AssertJUnit.assertEquals("multiply", result, 0x000000127fffffdbl); }
@Test
public void test05892() { x = 0x0000000080000000l; long result = x * 0x25l; AssertJUnit.assertEquals("multiply", result, 0x0000001280000000l); }
@Test
public void test05893() { x = 0x00000000ffffffffl; long result = x * 0x25l; AssertJUnit.assertEquals("multiply", result, 0x00000024ffffffdbl); }
@Test
public void test05894() { x = 0x000000017fffffffl; long result = x * 0x25l; AssertJUnit.assertEquals("multiply", result, 0x000000377fffffdbl); }
@Test
public void test05895() { x = 0x0000000180000000l; long result = x * 0x25l; AssertJUnit.assertEquals("multiply", result, 0x0000003780000000l); }
@Test
public void test05896() { x = 0x00000001ffffffffl; long result = x * 0x25l; AssertJUnit.assertEquals("multiply", result, 0x00000049ffffffdbl); }
@Test
public void test05897() { x = 0xffffffff7fffffffl; long result = x * 0x25l; AssertJUnit.assertEquals("multiply", result, 0xffffffed7fffffdbl); }
@Test
public void test05898() { x = 0xffffffff80000000l; long result = x * 0x25l; AssertJUnit.assertEquals("multiply", result, 0xffffffed80000000l); }
@Test
public void test05899() { x = 0x00000001deadf00dl; long result = x * 0x25l; AssertJUnit.assertEquals("multiply", result, 0x000000452f23b1e1l); }
@Test
public void test05900() { x = 0xffffffffdeadf00dl; long result = x * 0x25l; AssertJUnit.assertEquals("multiply", result, 0xfffffffb2f23b1e1l); }
@Test
public void test05901() { x = 0x7fffffffffffffffl; long result = x * 0x25l; AssertJUnit.assertEquals("multiply", result, 0x7fffffffffffffdbl); }
@Test
public void test05902() { x = 0x7fffffff7fffffffl; long result = x * 0x25l; AssertJUnit.assertEquals("multiply", result, 0x7fffffed7fffffdbl); }
@Test
public void test05903() { x = 0x7fffffff80000000l; long result = x * 0x25l; AssertJUnit.assertEquals("multiply", result, 0x7fffffed80000000l); }
@Test
public void test05904() { x = 0x7fffffffdeadf00dl; long result = x * 0x25l; AssertJUnit.assertEquals("multiply", result, 0x7ffffffb2f23b1e1l); }
@Test
public void test05905() { x = 0x8000000000000000l; long result = x * 0x25l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test05906() { x = 0xffffffffffffffffl; long result = x * 0x25l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffdbl); }
@Test
public void test05907() { x = 0xfffffffffffffffel; long result = x * 0x25l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffb6l); }
@Test
public void test05908() { x = 0xefffffffffffffffl; long result = x * 0x25l; AssertJUnit.assertEquals("multiply", result, 0xafffffffffffffdbl); }
@Test
public void test05909() { x = 0xdeadf00ddeadf00dl; long result = x * 0x25l; AssertJUnit.assertEquals("multiply", result, 0x2f23b2012f23b1e1l); }
@Test
public void test05910() { x = 0x000000007fffffffl; long result = x * 0x128l; AssertJUnit.assertEquals("multiply", result, 0x00000093fffffed8l); }
@Test
public void test05911() { x = 0x0000000080000000l; long result = x * 0x128l; AssertJUnit.assertEquals("multiply", result, 0x0000009400000000l); }
@Test
public void test05912() { x = 0x00000000ffffffffl; long result = x * 0x128l; AssertJUnit.assertEquals("multiply", result, 0x00000127fffffed8l); }
@Test
public void test05913() { x = 0x000000017fffffffl; long result = x * 0x128l; AssertJUnit.assertEquals("multiply", result, 0x000001bbfffffed8l); }
@Test
public void test05914() { x = 0x0000000180000000l; long result = x * 0x128l; AssertJUnit.assertEquals("multiply", result, 0x000001bc00000000l); }
@Test
public void test05915() { x = 0x00000001ffffffffl; long result = x * 0x128l; AssertJUnit.assertEquals("multiply", result, 0x0000024ffffffed8l); }
@Test
public void test05916() { x = 0xffffffff7fffffffl; long result = x * 0x128l; AssertJUnit.assertEquals("multiply", result, 0xffffff6bfffffed8l); }
@Test
public void test05917() { x = 0xffffffff80000000l; long result = x * 0x128l; AssertJUnit.assertEquals("multiply", result, 0xffffff6c00000000l); }
@Test
public void test05918() { x = 0x00000001deadf00dl; long result = x * 0x128l; AssertJUnit.assertEquals("multiply", result, 0x00000229791d8f08l); }
@Test
public void test05919() { x = 0xffffffffdeadf00dl; long result = x * 0x128l; AssertJUnit.assertEquals("multiply", result, 0xffffffd9791d8f08l); }
@Test
public void test05920() { x = 0x7fffffffffffffffl; long result = x * 0x128l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffed8l); }
@Test
public void test05921() { x = 0x7fffffff7fffffffl; long result = x * 0x128l; AssertJUnit.assertEquals("multiply", result, 0xffffff6bfffffed8l); }
@Test
public void test05922() { x = 0x7fffffff80000000l; long result = x * 0x128l; AssertJUnit.assertEquals("multiply", result, 0xffffff6c00000000l); }
@Test
public void test05923() { x = 0x7fffffffdeadf00dl; long result = x * 0x128l; AssertJUnit.assertEquals("multiply", result, 0xffffffd9791d8f08l); }
@Test
public void test05924() { x = 0x8000000000000000l; long result = x * 0x128l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05925() { x = 0xffffffffffffffffl; long result = x * 0x128l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffed8l); }
@Test
public void test05926() { x = 0xfffffffffffffffel; long result = x * 0x128l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffdb0l); }
@Test
public void test05927() { x = 0xefffffffffffffffl; long result = x * 0x128l; AssertJUnit.assertEquals("multiply", result, 0x7ffffffffffffed8l); }
@Test
public void test05928() { x = 0xdeadf00ddeadf00dl; long result = x * 0x128l; AssertJUnit.assertEquals("multiply", result, 0x791d9009791d8f08l); }
@Test
public void test05929() { x = 0x000000007fffffffl; long result = x * 0x2500l; AssertJUnit.assertEquals("multiply", result, 0x0000127fffffdb00l); }
@Test
public void test05930() { x = 0x0000000080000000l; long result = x * 0x2500l; AssertJUnit.assertEquals("multiply", result, 0x0000128000000000l); }
@Test
public void test05931() { x = 0x00000000ffffffffl; long result = x * 0x2500l; AssertJUnit.assertEquals("multiply", result, 0x000024ffffffdb00l); }
@Test
public void test05932() { x = 0x000000017fffffffl; long result = x * 0x2500l; AssertJUnit.assertEquals("multiply", result, 0x0000377fffffdb00l); }
@Test
public void test05933() { x = 0x0000000180000000l; long result = x * 0x2500l; AssertJUnit.assertEquals("multiply", result, 0x0000378000000000l); }
@Test
public void test05934() { x = 0x00000001ffffffffl; long result = x * 0x2500l; AssertJUnit.assertEquals("multiply", result, 0x000049ffffffdb00l); }
@Test
public void test05935() { x = 0xffffffff7fffffffl; long result = x * 0x2500l; AssertJUnit.assertEquals("multiply", result, 0xffffed7fffffdb00l); }
@Test
public void test05936() { x = 0xffffffff80000000l; long result = x * 0x2500l; AssertJUnit.assertEquals("multiply", result, 0xffffed8000000000l); }
@Test
public void test05937() { x = 0x00000001deadf00dl; long result = x * 0x2500l; AssertJUnit.assertEquals("multiply", result, 0x0000452f23b1e100l); }
@Test
public void test05938() { x = 0xffffffffdeadf00dl; long result = x * 0x2500l; AssertJUnit.assertEquals("multiply", result, 0xfffffb2f23b1e100l); }
@Test
public void test05939() { x = 0x7fffffffffffffffl; long result = x * 0x2500l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffdb00l); }
@Test
public void test05940() { x = 0x7fffffff7fffffffl; long result = x * 0x2500l; AssertJUnit.assertEquals("multiply", result, 0xffffed7fffffdb00l); }
@Test
public void test05941() { x = 0x7fffffff80000000l; long result = x * 0x2500l; AssertJUnit.assertEquals("multiply", result, 0xffffed8000000000l); }
@Test
public void test05942() { x = 0x7fffffffdeadf00dl; long result = x * 0x2500l; AssertJUnit.assertEquals("multiply", result, 0xfffffb2f23b1e100l); }
@Test
public void test05943() { x = 0x8000000000000000l; long result = x * 0x2500l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05944() { x = 0xffffffffffffffffl; long result = x * 0x2500l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffdb00l); }
@Test
public void test05945() { x = 0xfffffffffffffffel; long result = x * 0x2500l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffb600l); }
@Test
public void test05946() { x = 0xefffffffffffffffl; long result = x * 0x2500l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffdb00l); }
@Test
public void test05947() { x = 0xdeadf00ddeadf00dl; long result = x * 0x2500l; AssertJUnit.assertEquals("multiply", result, 0x23b2012f23b1e100l); }
@Test
public void test05948() { x = 0x000000007fffffffl; long result = x * 0x2500000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffdb00000000l); }
@Test
public void test05949() { x = 0x0000000080000000l; long result = x * 0x2500000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test05950() { x = 0x00000000ffffffffl; long result = x * 0x2500000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffdb00000000l); }
@Test
public void test05951() { x = 0x000000017fffffffl; long result = x * 0x2500000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffdb00000000l); }
@Test
public void test05952() { x = 0x0000000180000000l; long result = x * 0x2500000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test05953() { x = 0x00000001ffffffffl; long result = x * 0x2500000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffdb00000000l); }
@Test
public void test05954() { x = 0xffffffff7fffffffl; long result = x * 0x2500000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffdb00000000l); }
@Test
public void test05955() { x = 0xffffffff80000000l; long result = x * 0x2500000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test05956() { x = 0x00000001deadf00dl; long result = x * 0x2500000000l; AssertJUnit.assertEquals("multiply", result, 0x2f23b1e100000000l); }
@Test
public void test05957() { x = 0xffffffffdeadf00dl; long result = x * 0x2500000000l; AssertJUnit.assertEquals("multiply", result, 0x2f23b1e100000000l); }
@Test
public void test05958() { x = 0x7fffffffffffffffl; long result = x * 0x2500000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffdb00000000l); }
@Test
public void test05959() { x = 0x7fffffff7fffffffl; long result = x * 0x2500000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffdb00000000l); }
@Test
public void test05960() { x = 0x7fffffff80000000l; long result = x * 0x2500000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test05961() { x = 0x7fffffffdeadf00dl; long result = x * 0x2500000000l; AssertJUnit.assertEquals("multiply", result, 0x2f23b1e100000000l); }
@Test
public void test05962() { x = 0x8000000000000000l; long result = x * 0x2500000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05963() { x = 0xffffffffffffffffl; long result = x * 0x2500000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffdb00000000l); }
@Test
public void test05964() { x = 0xfffffffffffffffel; long result = x * 0x2500000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffb600000000l); }
@Test
public void test05965() { x = 0xefffffffffffffffl; long result = x * 0x2500000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffdb00000000l); }
@Test
public void test05966() { x = 0xdeadf00ddeadf00dl; long result = x * 0x2500000000l; AssertJUnit.assertEquals("multiply", result, 0x2f23b1e100000000l); }
@Test
public void test05967() { x = 0x000000007fffffffl; long result = x * 0x12800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffed800000000l); }
@Test
public void test05968() { x = 0x0000000080000000l; long result = x * 0x12800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05969() { x = 0x00000000ffffffffl; long result = x * 0x12800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffed800000000l); }
@Test
public void test05970() { x = 0x000000017fffffffl; long result = x * 0x12800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffed800000000l); }
@Test
public void test05971() { x = 0x0000000180000000l; long result = x * 0x12800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05972() { x = 0x00000001ffffffffl; long result = x * 0x12800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffed800000000l); }
@Test
public void test05973() { x = 0xffffffff7fffffffl; long result = x * 0x12800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffed800000000l); }
@Test
public void test05974() { x = 0xffffffff80000000l; long result = x * 0x12800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05975() { x = 0x00000001deadf00dl; long result = x * 0x12800000000l; AssertJUnit.assertEquals("multiply", result, 0x791d8f0800000000l); }
@Test
public void test05976() { x = 0xffffffffdeadf00dl; long result = x * 0x12800000000l; AssertJUnit.assertEquals("multiply", result, 0x791d8f0800000000l); }
@Test
public void test05977() { x = 0x7fffffffffffffffl; long result = x * 0x12800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffed800000000l); }
@Test
public void test05978() { x = 0x7fffffff7fffffffl; long result = x * 0x12800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffed800000000l); }
@Test
public void test05979() { x = 0x7fffffff80000000l; long result = x * 0x12800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05980() { x = 0x7fffffffdeadf00dl; long result = x * 0x12800000000l; AssertJUnit.assertEquals("multiply", result, 0x791d8f0800000000l); }
@Test
public void test05981() { x = 0x8000000000000000l; long result = x * 0x12800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test05982() { x = 0xffffffffffffffffl; long result = x * 0x12800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffed800000000l); }
@Test
public void test05983() { x = 0xfffffffffffffffel; long result = x * 0x12800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffdb000000000l); }
@Test
public void test05984() { x = 0xefffffffffffffffl; long result = x * 0x12800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffed800000000l); }
@Test
public void test05985() { x = 0xdeadf00ddeadf00dl; long result = x * 0x12800000000l; AssertJUnit.assertEquals("multiply", result, 0x791d8f0800000000l); }
@Test
public void test05986() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffffdbl; AssertJUnit.assertEquals("multiply", result, 0xffffffed80000025l); }
@Test
public void test05987() { x = 0x0000000080000000l; long result = x * 0xffffffffffffffdbl; AssertJUnit.assertEquals("multiply", result, 0xffffffed80000000l); }
@Test
public void test05988() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffffdbl; AssertJUnit.assertEquals("multiply", result, 0xffffffdb00000025l); }
@Test
public void test05989() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffffdbl; AssertJUnit.assertEquals("multiply", result, 0xffffffc880000025l); }
@Test
public void test05990() { x = 0x0000000180000000l; long result = x * 0xffffffffffffffdbl; AssertJUnit.assertEquals("multiply", result, 0xffffffc880000000l); }
@Test
public void test05991() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffffdbl; AssertJUnit.assertEquals("multiply", result, 0xffffffb600000025l); }
@Test
public void test05992() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffffdbl; AssertJUnit.assertEquals("multiply", result, 0x0000001280000025l); }
@Test
public void test05993() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffffdbl; AssertJUnit.assertEquals("multiply", result, 0x0000001280000000l); }
@Test
public void test05994() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffffdbl; AssertJUnit.assertEquals("multiply", result, 0xffffffbad0dc4e1fl); }
@Test
public void test05995() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffffdbl; AssertJUnit.assertEquals("multiply", result, 0x00000004d0dc4e1fl); }
@Test
public void test05996() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffffdbl; AssertJUnit.assertEquals("multiply", result, 0x8000000000000025l); }
@Test
public void test05997() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffffdbl; AssertJUnit.assertEquals("multiply", result, 0x8000001280000025l); }
@Test
public void test05998() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffffdbl; AssertJUnit.assertEquals("multiply", result, 0x8000001280000000l); }
@Test
public void test05999() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffffdbl; AssertJUnit.assertEquals("multiply", result, 0x80000004d0dc4e1fl); }
@Test
public void test06000() { x = 0x8000000000000000l; long result = x * 0xffffffffffffffdbl; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test06001() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffffdbl; AssertJUnit.assertEquals("multiply", result, 0x0000000000000025l); }
@Test
public void test06002() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffffdbl; AssertJUnit.assertEquals("multiply", result, 0x000000000000004al); }
@Test
public void test06003() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffffdbl; AssertJUnit.assertEquals("multiply", result, 0x5000000000000025l); }
@Test
public void test06004() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffffdbl; AssertJUnit.assertEquals("multiply", result, 0xd0dc4dfed0dc4e1fl); }
@Test
public void test06005() { x = 0x000000007fffffffl; long result = x * 0xfffffffffffffed8l; AssertJUnit.assertEquals("multiply", result, 0xffffff6c00000128l); }
@Test
public void test06006() { x = 0x0000000080000000l; long result = x * 0xfffffffffffffed8l; AssertJUnit.assertEquals("multiply", result, 0xffffff6c00000000l); }
@Test
public void test06007() { x = 0x00000000ffffffffl; long result = x * 0xfffffffffffffed8l; AssertJUnit.assertEquals("multiply", result, 0xfffffed800000128l); }
@Test
public void test06008() { x = 0x000000017fffffffl; long result = x * 0xfffffffffffffed8l; AssertJUnit.assertEquals("multiply", result, 0xfffffe4400000128l); }
@Test
public void test06009() { x = 0x0000000180000000l; long result = x * 0xfffffffffffffed8l; AssertJUnit.assertEquals("multiply", result, 0xfffffe4400000000l); }
@Test
public void test06010() { x = 0x00000001ffffffffl; long result = x * 0xfffffffffffffed8l; AssertJUnit.assertEquals("multiply", result, 0xfffffdb000000128l); }
@Test
public void test06011() { x = 0xffffffff7fffffffl; long result = x * 0xfffffffffffffed8l; AssertJUnit.assertEquals("multiply", result, 0x0000009400000128l); }
@Test
public void test06012() { x = 0xffffffff80000000l; long result = x * 0xfffffffffffffed8l; AssertJUnit.assertEquals("multiply", result, 0x0000009400000000l); }
@Test
public void test06013() { x = 0x00000001deadf00dl; long result = x * 0xfffffffffffffed8l; AssertJUnit.assertEquals("multiply", result, 0xfffffdd686e270f8l); }
@Test
public void test06014() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffffffffffed8l; AssertJUnit.assertEquals("multiply", result, 0x0000002686e270f8l); }
@Test
public void test06015() { x = 0x7fffffffffffffffl; long result = x * 0xfffffffffffffed8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000128l); }
@Test
public void test06016() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffffffffffed8l; AssertJUnit.assertEquals("multiply", result, 0x0000009400000128l); }
@Test
public void test06017() { x = 0x7fffffff80000000l; long result = x * 0xfffffffffffffed8l; AssertJUnit.assertEquals("multiply", result, 0x0000009400000000l); }
@Test
public void test06018() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffffffffffed8l; AssertJUnit.assertEquals("multiply", result, 0x0000002686e270f8l); }
@Test
public void test06019() { x = 0x8000000000000000l; long result = x * 0xfffffffffffffed8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test06020() { x = 0xffffffffffffffffl; long result = x * 0xfffffffffffffed8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000128l); }
@Test
public void test06021() { x = 0xfffffffffffffffel; long result = x * 0xfffffffffffffed8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000250l); }
@Test
public void test06022() { x = 0xefffffffffffffffl; long result = x * 0xfffffffffffffed8l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000128l); }
@Test
public void test06023() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffffffffffed8l; AssertJUnit.assertEquals("multiply", result, 0x86e26ff686e270f8l); }
@Test
public void test06024() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffdb00l; AssertJUnit.assertEquals("multiply", result, 0xffffed8000002500l); }
@Test
public void test06025() { x = 0x0000000080000000l; long result = x * 0xffffffffffffdb00l; AssertJUnit.assertEquals("multiply", result, 0xffffed8000000000l); }
@Test
public void test06026() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffdb00l; AssertJUnit.assertEquals("multiply", result, 0xffffdb0000002500l); }
@Test
public void test06027() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffdb00l; AssertJUnit.assertEquals("multiply", result, 0xffffc88000002500l); }
@Test
public void test06028() { x = 0x0000000180000000l; long result = x * 0xffffffffffffdb00l; AssertJUnit.assertEquals("multiply", result, 0xffffc88000000000l); }
@Test
public void test06029() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffdb00l; AssertJUnit.assertEquals("multiply", result, 0xffffb60000002500l); }
@Test
public void test06030() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffdb00l; AssertJUnit.assertEquals("multiply", result, 0x0000128000002500l); }
@Test
public void test06031() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffdb00l; AssertJUnit.assertEquals("multiply", result, 0x0000128000000000l); }
@Test
public void test06032() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffdb00l; AssertJUnit.assertEquals("multiply", result, 0xffffbad0dc4e1f00l); }
@Test
public void test06033() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffdb00l; AssertJUnit.assertEquals("multiply", result, 0x000004d0dc4e1f00l); }
@Test
public void test06034() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffdb00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000002500l); }
@Test
public void test06035() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffdb00l; AssertJUnit.assertEquals("multiply", result, 0x0000128000002500l); }
@Test
public void test06036() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffdb00l; AssertJUnit.assertEquals("multiply", result, 0x0000128000000000l); }
@Test
public void test06037() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffdb00l; AssertJUnit.assertEquals("multiply", result, 0x000004d0dc4e1f00l); }
@Test
public void test06038() { x = 0x8000000000000000l; long result = x * 0xffffffffffffdb00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test06039() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffdb00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000002500l); }
@Test
public void test06040() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffdb00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000004a00l); }
@Test
public void test06041() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffdb00l; AssertJUnit.assertEquals("multiply", result, 0x0000000000002500l); }
@Test
public void test06042() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffdb00l; AssertJUnit.assertEquals("multiply", result, 0xdc4dfed0dc4e1f00l); }
@Test
public void test06043() { x = 0x000000007fffffffl; long result = x * 0xffffffdb00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000002500000000l); }
@Test
public void test06044() { x = 0x0000000080000000l; long result = x * 0xffffffdb00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test06045() { x = 0x00000000ffffffffl; long result = x * 0xffffffdb00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002500000000l); }
@Test
public void test06046() { x = 0x000000017fffffffl; long result = x * 0xffffffdb00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000002500000000l); }
@Test
public void test06047() { x = 0x0000000180000000l; long result = x * 0xffffffdb00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test06048() { x = 0x00000001ffffffffl; long result = x * 0xffffffdb00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002500000000l); }
@Test
public void test06049() { x = 0xffffffff7fffffffl; long result = x * 0xffffffdb00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000002500000000l); }
@Test
public void test06050() { x = 0xffffffff80000000l; long result = x * 0xffffffdb00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test06051() { x = 0x00000001deadf00dl; long result = x * 0xffffffdb00000000l; AssertJUnit.assertEquals("multiply", result, 0xd0dc4e1f00000000l); }
@Test
public void test06052() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffdb00000000l; AssertJUnit.assertEquals("multiply", result, 0xd0dc4e1f00000000l); }
@Test
public void test06053() { x = 0x7fffffffffffffffl; long result = x * 0xffffffdb00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002500000000l); }
@Test
public void test06054() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffdb00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000002500000000l); }
@Test
public void test06055() { x = 0x7fffffff80000000l; long result = x * 0xffffffdb00000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test06056() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffdb00000000l; AssertJUnit.assertEquals("multiply", result, 0xd0dc4e1f00000000l); }
@Test
public void test06057() { x = 0x8000000000000000l; long result = x * 0xffffffdb00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test06058() { x = 0xffffffffffffffffl; long result = x * 0xffffffdb00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002500000000l); }
@Test
public void test06059() { x = 0xfffffffffffffffel; long result = x * 0xffffffdb00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000004a00000000l); }
@Test
public void test06060() { x = 0xefffffffffffffffl; long result = x * 0xffffffdb00000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002500000000l); }
@Test
public void test06061() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffdb00000000l; AssertJUnit.assertEquals("multiply", result, 0xd0dc4e1f00000000l); }
@Test
public void test06062() { x = 0x000000007fffffffl; long result = x * 0xfffffed800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000012800000000l); }
@Test
public void test06063() { x = 0x0000000080000000l; long result = x * 0xfffffed800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test06064() { x = 0x00000000ffffffffl; long result = x * 0xfffffed800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000012800000000l); }
@Test
public void test06065() { x = 0x000000017fffffffl; long result = x * 0xfffffed800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000012800000000l); }
@Test
public void test06066() { x = 0x0000000180000000l; long result = x * 0xfffffed800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test06067() { x = 0x00000001ffffffffl; long result = x * 0xfffffed800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000012800000000l); }
@Test
public void test06068() { x = 0xffffffff7fffffffl; long result = x * 0xfffffed800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000012800000000l); }
@Test
public void test06069() { x = 0xffffffff80000000l; long result = x * 0xfffffed800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test06070() { x = 0x00000001deadf00dl; long result = x * 0xfffffed800000000l; AssertJUnit.assertEquals("multiply", result, 0x86e270f800000000l); }
@Test
public void test06071() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffed800000000l; AssertJUnit.assertEquals("multiply", result, 0x86e270f800000000l); }
@Test
public void test06072() { x = 0x7fffffffffffffffl; long result = x * 0xfffffed800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000012800000000l); }
@Test
public void test06073() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffed800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000012800000000l); }
@Test
public void test06074() { x = 0x7fffffff80000000l; long result = x * 0xfffffed800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test06075() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffed800000000l; AssertJUnit.assertEquals("multiply", result, 0x86e270f800000000l); }
@Test
public void test06076() { x = 0x8000000000000000l; long result = x * 0xfffffed800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test06077() { x = 0xffffffffffffffffl; long result = x * 0xfffffed800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000012800000000l); }
@Test
public void test06078() { x = 0xfffffffffffffffel; long result = x * 0xfffffed800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000025000000000l); }
@Test
public void test06079() { x = 0xefffffffffffffffl; long result = x * 0xfffffed800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000012800000000l); }
@Test
public void test06080() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffed800000000l; AssertJUnit.assertEquals("multiply", result, 0x86e270f800000000l); }
@Test
public void test06081() { x = 0x000000007fffffffl; long result = x * 0x29l; AssertJUnit.assertEquals("multiply", result, 0x000000147fffffd7l); }
@Test
public void test06082() { x = 0x0000000080000000l; long result = x * 0x29l; AssertJUnit.assertEquals("multiply", result, 0x0000001480000000l); }
@Test
public void test06083() { x = 0x00000000ffffffffl; long result = x * 0x29l; AssertJUnit.assertEquals("multiply", result, 0x00000028ffffffd7l); }
@Test
public void test06084() { x = 0x000000017fffffffl; long result = x * 0x29l; AssertJUnit.assertEquals("multiply", result, 0x0000003d7fffffd7l); }
@Test
public void test06085() { x = 0x0000000180000000l; long result = x * 0x29l; AssertJUnit.assertEquals("multiply", result, 0x0000003d80000000l); }
@Test
public void test06086() { x = 0x00000001ffffffffl; long result = x * 0x29l; AssertJUnit.assertEquals("multiply", result, 0x00000051ffffffd7l); }
@Test
public void test06087() { x = 0xffffffff7fffffffl; long result = x * 0x29l; AssertJUnit.assertEquals("multiply", result, 0xffffffeb7fffffd7l); }
@Test
public void test06088() { x = 0xffffffff80000000l; long result = x * 0x29l; AssertJUnit.assertEquals("multiply", result, 0xffffffeb80000000l); }
@Test
public void test06089() { x = 0x00000001deadf00dl; long result = x * 0x29l; AssertJUnit.assertEquals("multiply", result, 0x0000004ca9db7215l); }
@Test
public void test06090() { x = 0xffffffffdeadf00dl; long result = x * 0x29l; AssertJUnit.assertEquals("multiply", result, 0xfffffffaa9db7215l); }
@Test
public void test06091() { x = 0x7fffffffffffffffl; long result = x * 0x29l; AssertJUnit.assertEquals("multiply", result, 0x7fffffffffffffd7l); }
@Test
public void test06092() { x = 0x7fffffff7fffffffl; long result = x * 0x29l; AssertJUnit.assertEquals("multiply", result, 0x7fffffeb7fffffd7l); }
@Test
public void test06093() { x = 0x7fffffff80000000l; long result = x * 0x29l; AssertJUnit.assertEquals("multiply", result, 0x7fffffeb80000000l); }
@Test
public void test06094() { x = 0x7fffffffdeadf00dl; long result = x * 0x29l; AssertJUnit.assertEquals("multiply", result, 0x7ffffffaa9db7215l); }
@Test
public void test06095() { x = 0x8000000000000000l; long result = x * 0x29l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test06096() { x = 0xffffffffffffffffl; long result = x * 0x29l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffd7l); }
@Test
public void test06097() { x = 0xfffffffffffffffel; long result = x * 0x29l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffffael); }
@Test
public void test06098() { x = 0xefffffffffffffffl; long result = x * 0x29l; AssertJUnit.assertEquals("multiply", result, 0x6fffffffffffffd7l); }
@Test
public void test06099() { x = 0xdeadf00ddeadf00dl; long result = x * 0x29l; AssertJUnit.assertEquals("multiply", result, 0xa9db7238a9db7215l); }
@Test
public void test06100() { x = 0x000000007fffffffl; long result = x * 0x148l; AssertJUnit.assertEquals("multiply", result, 0x000000a3fffffeb8l); }
@Test
public void test06101() { x = 0x0000000080000000l; long result = x * 0x148l; AssertJUnit.assertEquals("multiply", result, 0x000000a400000000l); }
@Test
public void test06102() { x = 0x00000000ffffffffl; long result = x * 0x148l; AssertJUnit.assertEquals("multiply", result, 0x00000147fffffeb8l); }
@Test
public void test06103() { x = 0x000000017fffffffl; long result = x * 0x148l; AssertJUnit.assertEquals("multiply", result, 0x000001ebfffffeb8l); }
@Test
public void test06104() { x = 0x0000000180000000l; long result = x * 0x148l; AssertJUnit.assertEquals("multiply", result, 0x000001ec00000000l); }
@Test
public void test06105() { x = 0x00000001ffffffffl; long result = x * 0x148l; AssertJUnit.assertEquals("multiply", result, 0x0000028ffffffeb8l); }
@Test
public void test06106() { x = 0xffffffff7fffffffl; long result = x * 0x148l; AssertJUnit.assertEquals("multiply", result, 0xffffff5bfffffeb8l); }
@Test
public void test06107() { x = 0xffffffff80000000l; long result = x * 0x148l; AssertJUnit.assertEquals("multiply", result, 0xffffff5c00000000l); }
@Test
public void test06108() { x = 0x00000001deadf00dl; long result = x * 0x148l; AssertJUnit.assertEquals("multiply", result, 0x000002654edb90a8l); }
@Test
public void test06109() { x = 0xffffffffdeadf00dl; long result = x * 0x148l; AssertJUnit.assertEquals("multiply", result, 0xffffffd54edb90a8l); }
@Test
public void test06110() { x = 0x7fffffffffffffffl; long result = x * 0x148l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffeb8l); }
@Test
public void test06111() { x = 0x7fffffff7fffffffl; long result = x * 0x148l; AssertJUnit.assertEquals("multiply", result, 0xffffff5bfffffeb8l); }
@Test
public void test06112() { x = 0x7fffffff80000000l; long result = x * 0x148l; AssertJUnit.assertEquals("multiply", result, 0xffffff5c00000000l); }
@Test
public void test06113() { x = 0x7fffffffdeadf00dl; long result = x * 0x148l; AssertJUnit.assertEquals("multiply", result, 0xffffffd54edb90a8l); }
@Test
public void test06114() { x = 0x8000000000000000l; long result = x * 0x148l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test06115() { x = 0xffffffffffffffffl; long result = x * 0x148l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffeb8l); }
@Test
public void test06116() { x = 0xfffffffffffffffel; long result = x * 0x148l; AssertJUnit.assertEquals("multiply", result, 0xfffffffffffffd70l); }
@Test
public void test06117() { x = 0xefffffffffffffffl; long result = x * 0x148l; AssertJUnit.assertEquals("multiply", result, 0x7ffffffffffffeb8l); }
@Test
public void test06118() { x = 0xdeadf00ddeadf00dl; long result = x * 0x148l; AssertJUnit.assertEquals("multiply", result, 0x4edb91c54edb90a8l); }
@Test
public void test06119() { x = 0x000000007fffffffl; long result = x * 0x2900l; AssertJUnit.assertEquals("multiply", result, 0x0000147fffffd700l); }
@Test
public void test06120() { x = 0x0000000080000000l; long result = x * 0x2900l; AssertJUnit.assertEquals("multiply", result, 0x0000148000000000l); }
@Test
public void test06121() { x = 0x00000000ffffffffl; long result = x * 0x2900l; AssertJUnit.assertEquals("multiply", result, 0x000028ffffffd700l); }
@Test
public void test06122() { x = 0x000000017fffffffl; long result = x * 0x2900l; AssertJUnit.assertEquals("multiply", result, 0x00003d7fffffd700l); }
@Test
public void test06123() { x = 0x0000000180000000l; long result = x * 0x2900l; AssertJUnit.assertEquals("multiply", result, 0x00003d8000000000l); }
@Test
public void test06124() { x = 0x00000001ffffffffl; long result = x * 0x2900l; AssertJUnit.assertEquals("multiply", result, 0x000051ffffffd700l); }
@Test
public void test06125() { x = 0xffffffff7fffffffl; long result = x * 0x2900l; AssertJUnit.assertEquals("multiply", result, 0xffffeb7fffffd700l); }
@Test
public void test06126() { x = 0xffffffff80000000l; long result = x * 0x2900l; AssertJUnit.assertEquals("multiply", result, 0xffffeb8000000000l); }
@Test
public void test06127() { x = 0x00000001deadf00dl; long result = x * 0x2900l; AssertJUnit.assertEquals("multiply", result, 0x00004ca9db721500l); }
@Test
public void test06128() { x = 0xffffffffdeadf00dl; long result = x * 0x2900l; AssertJUnit.assertEquals("multiply", result, 0xfffffaa9db721500l); }
@Test
public void test06129() { x = 0x7fffffffffffffffl; long result = x * 0x2900l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffd700l); }
@Test
public void test06130() { x = 0x7fffffff7fffffffl; long result = x * 0x2900l; AssertJUnit.assertEquals("multiply", result, 0xffffeb7fffffd700l); }
@Test
public void test06131() { x = 0x7fffffff80000000l; long result = x * 0x2900l; AssertJUnit.assertEquals("multiply", result, 0xffffeb8000000000l); }
@Test
public void test06132() { x = 0x7fffffffdeadf00dl; long result = x * 0x2900l; AssertJUnit.assertEquals("multiply", result, 0xfffffaa9db721500l); }
@Test
public void test06133() { x = 0x8000000000000000l; long result = x * 0x2900l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test06134() { x = 0xffffffffffffffffl; long result = x * 0x2900l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffd700l); }
@Test
public void test06135() { x = 0xfffffffffffffffel; long result = x * 0x2900l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffae00l); }
@Test
public void test06136() { x = 0xefffffffffffffffl; long result = x * 0x2900l; AssertJUnit.assertEquals("multiply", result, 0xffffffffffffd700l); }
@Test
public void test06137() { x = 0xdeadf00ddeadf00dl; long result = x * 0x2900l; AssertJUnit.assertEquals("multiply", result, 0xdb7238a9db721500l); }
@Test
public void test06138() { x = 0x000000007fffffffl; long result = x * 0x2900000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffd700000000l); }
@Test
public void test06139() { x = 0x0000000080000000l; long result = x * 0x2900000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test06140() { x = 0x00000000ffffffffl; long result = x * 0x2900000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffd700000000l); }
@Test
public void test06141() { x = 0x000000017fffffffl; long result = x * 0x2900000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffd700000000l); }
@Test
public void test06142() { x = 0x0000000180000000l; long result = x * 0x2900000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test06143() { x = 0x00000001ffffffffl; long result = x * 0x2900000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffd700000000l); }
@Test
public void test06144() { x = 0xffffffff7fffffffl; long result = x * 0x2900000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffd700000000l); }
@Test
public void test06145() { x = 0xffffffff80000000l; long result = x * 0x2900000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test06146() { x = 0x00000001deadf00dl; long result = x * 0x2900000000l; AssertJUnit.assertEquals("multiply", result, 0xa9db721500000000l); }
@Test
public void test06147() { x = 0xffffffffdeadf00dl; long result = x * 0x2900000000l; AssertJUnit.assertEquals("multiply", result, 0xa9db721500000000l); }
@Test
public void test06148() { x = 0x7fffffffffffffffl; long result = x * 0x2900000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffd700000000l); }
@Test
public void test06149() { x = 0x7fffffff7fffffffl; long result = x * 0x2900000000l; AssertJUnit.assertEquals("multiply", result, 0x7fffffd700000000l); }
@Test
public void test06150() { x = 0x7fffffff80000000l; long result = x * 0x2900000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test06151() { x = 0x7fffffffdeadf00dl; long result = x * 0x2900000000l; AssertJUnit.assertEquals("multiply", result, 0xa9db721500000000l); }
@Test
public void test06152() { x = 0x8000000000000000l; long result = x * 0x2900000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test06153() { x = 0xffffffffffffffffl; long result = x * 0x2900000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffd700000000l); }
@Test
public void test06154() { x = 0xfffffffffffffffel; long result = x * 0x2900000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffae00000000l); }
@Test
public void test06155() { x = 0xefffffffffffffffl; long result = x * 0x2900000000l; AssertJUnit.assertEquals("multiply", result, 0xffffffd700000000l); }
@Test
public void test06156() { x = 0xdeadf00ddeadf00dl; long result = x * 0x2900000000l; AssertJUnit.assertEquals("multiply", result, 0xa9db721500000000l); }
@Test
public void test06157() { x = 0x000000007fffffffl; long result = x * 0x14800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffeb800000000l); }
@Test
public void test06158() { x = 0x0000000080000000l; long result = x * 0x14800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test06159() { x = 0x00000000ffffffffl; long result = x * 0x14800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffeb800000000l); }
@Test
public void test06160() { x = 0x000000017fffffffl; long result = x * 0x14800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffeb800000000l); }
@Test
public void test06161() { x = 0x0000000180000000l; long result = x * 0x14800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test06162() { x = 0x00000001ffffffffl; long result = x * 0x14800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffeb800000000l); }
@Test
public void test06163() { x = 0xffffffff7fffffffl; long result = x * 0x14800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffeb800000000l); }
@Test
public void test06164() { x = 0xffffffff80000000l; long result = x * 0x14800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test06165() { x = 0x00000001deadf00dl; long result = x * 0x14800000000l; AssertJUnit.assertEquals("multiply", result, 0x4edb90a800000000l); }
@Test
public void test06166() { x = 0xffffffffdeadf00dl; long result = x * 0x14800000000l; AssertJUnit.assertEquals("multiply", result, 0x4edb90a800000000l); }
@Test
public void test06167() { x = 0x7fffffffffffffffl; long result = x * 0x14800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffeb800000000l); }
@Test
public void test06168() { x = 0x7fffffff7fffffffl; long result = x * 0x14800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffeb800000000l); }
@Test
public void test06169() { x = 0x7fffffff80000000l; long result = x * 0x14800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test06170() { x = 0x7fffffffdeadf00dl; long result = x * 0x14800000000l; AssertJUnit.assertEquals("multiply", result, 0x4edb90a800000000l); }
@Test
public void test06171() { x = 0x8000000000000000l; long result = x * 0x14800000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test06172() { x = 0xffffffffffffffffl; long result = x * 0x14800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffeb800000000l); }
@Test
public void test06173() { x = 0xfffffffffffffffel; long result = x * 0x14800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffd7000000000l); }
@Test
public void test06174() { x = 0xefffffffffffffffl; long result = x * 0x14800000000l; AssertJUnit.assertEquals("multiply", result, 0xfffffeb800000000l); }
@Test
public void test06175() { x = 0xdeadf00ddeadf00dl; long result = x * 0x14800000000l; AssertJUnit.assertEquals("multiply", result, 0x4edb90a800000000l); }
@Test
public void test06176() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffffd7l; AssertJUnit.assertEquals("multiply", result, 0xffffffeb80000029l); }
@Test
public void test06177() { x = 0x0000000080000000l; long result = x * 0xffffffffffffffd7l; AssertJUnit.assertEquals("multiply", result, 0xffffffeb80000000l); }
@Test
public void test06178() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffffd7l; AssertJUnit.assertEquals("multiply", result, 0xffffffd700000029l); }
@Test
public void test06179() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffffd7l; AssertJUnit.assertEquals("multiply", result, 0xffffffc280000029l); }
@Test
public void test06180() { x = 0x0000000180000000l; long result = x * 0xffffffffffffffd7l; AssertJUnit.assertEquals("multiply", result, 0xffffffc280000000l); }
@Test
public void test06181() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffffd7l; AssertJUnit.assertEquals("multiply", result, 0xffffffae00000029l); }
@Test
public void test06182() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffffd7l; AssertJUnit.assertEquals("multiply", result, 0x0000001480000029l); }
@Test
public void test06183() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffffd7l; AssertJUnit.assertEquals("multiply", result, 0x0000001480000000l); }
@Test
public void test06184() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffffd7l; AssertJUnit.assertEquals("multiply", result, 0xffffffb356248debl); }
@Test
public void test06185() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffffd7l; AssertJUnit.assertEquals("multiply", result, 0x0000000556248debl); }
@Test
public void test06186() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffffd7l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000029l); }
@Test
public void test06187() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffffd7l; AssertJUnit.assertEquals("multiply", result, 0x8000001480000029l); }
@Test
public void test06188() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffffd7l; AssertJUnit.assertEquals("multiply", result, 0x8000001480000000l); }
@Test
public void test06189() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffffd7l; AssertJUnit.assertEquals("multiply", result, 0x8000000556248debl); }
@Test
public void test06190() { x = 0x8000000000000000l; long result = x * 0xffffffffffffffd7l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test06191() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffffd7l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000029l); }
@Test
public void test06192() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffffd7l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000052l); }
@Test
public void test06193() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffffd7l; AssertJUnit.assertEquals("multiply", result, 0x9000000000000029l); }
@Test
public void test06194() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffffd7l; AssertJUnit.assertEquals("multiply", result, 0x56248dc756248debl); }
@Test
public void test06195() { x = 0x000000007fffffffl; long result = x * 0xfffffffffffffeb8l; AssertJUnit.assertEquals("multiply", result, 0xffffff5c00000148l); }
@Test
public void test06196() { x = 0x0000000080000000l; long result = x * 0xfffffffffffffeb8l; AssertJUnit.assertEquals("multiply", result, 0xffffff5c00000000l); }
@Test
public void test06197() { x = 0x00000000ffffffffl; long result = x * 0xfffffffffffffeb8l; AssertJUnit.assertEquals("multiply", result, 0xfffffeb800000148l); }
@Test
public void test06198() { x = 0x000000017fffffffl; long result = x * 0xfffffffffffffeb8l; AssertJUnit.assertEquals("multiply", result, 0xfffffe1400000148l); }
@Test
public void test06199() { x = 0x0000000180000000l; long result = x * 0xfffffffffffffeb8l; AssertJUnit.assertEquals("multiply", result, 0xfffffe1400000000l); }
@Test
public void test06200() { x = 0x00000001ffffffffl; long result = x * 0xfffffffffffffeb8l; AssertJUnit.assertEquals("multiply", result, 0xfffffd7000000148l); }
@Test
public void test06201() { x = 0xffffffff7fffffffl; long result = x * 0xfffffffffffffeb8l; AssertJUnit.assertEquals("multiply", result, 0x000000a400000148l); }
@Test
public void test06202() { x = 0xffffffff80000000l; long result = x * 0xfffffffffffffeb8l; AssertJUnit.assertEquals("multiply", result, 0x000000a400000000l); }
@Test
public void test06203() { x = 0x00000001deadf00dl; long result = x * 0xfffffffffffffeb8l; AssertJUnit.assertEquals("multiply", result, 0xfffffd9ab1246f58l); }
@Test
public void test06204() { x = 0xffffffffdeadf00dl; long result = x * 0xfffffffffffffeb8l; AssertJUnit.assertEquals("multiply", result, 0x0000002ab1246f58l); }
@Test
public void test06205() { x = 0x7fffffffffffffffl; long result = x * 0xfffffffffffffeb8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000148l); }
@Test
public void test06206() { x = 0x7fffffff7fffffffl; long result = x * 0xfffffffffffffeb8l; AssertJUnit.assertEquals("multiply", result, 0x000000a400000148l); }
@Test
public void test06207() { x = 0x7fffffff80000000l; long result = x * 0xfffffffffffffeb8l; AssertJUnit.assertEquals("multiply", result, 0x000000a400000000l); }
@Test
public void test06208() { x = 0x7fffffffdeadf00dl; long result = x * 0xfffffffffffffeb8l; AssertJUnit.assertEquals("multiply", result, 0x0000002ab1246f58l); }
@Test
public void test06209() { x = 0x8000000000000000l; long result = x * 0xfffffffffffffeb8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test06210() { x = 0xffffffffffffffffl; long result = x * 0xfffffffffffffeb8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000148l); }
@Test
public void test06211() { x = 0xfffffffffffffffel; long result = x * 0xfffffffffffffeb8l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000290l); }
@Test
public void test06212() { x = 0xefffffffffffffffl; long result = x * 0xfffffffffffffeb8l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000148l); }
@Test
public void test06213() { x = 0xdeadf00ddeadf00dl; long result = x * 0xfffffffffffffeb8l; AssertJUnit.assertEquals("multiply", result, 0xb1246e3ab1246f58l); }
@Test
public void test06214() { x = 0x000000007fffffffl; long result = x * 0xffffffffffffd700l; AssertJUnit.assertEquals("multiply", result, 0xffffeb8000002900l); }
@Test
public void test06215() { x = 0x0000000080000000l; long result = x * 0xffffffffffffd700l; AssertJUnit.assertEquals("multiply", result, 0xffffeb8000000000l); }
@Test
public void test06216() { x = 0x00000000ffffffffl; long result = x * 0xffffffffffffd700l; AssertJUnit.assertEquals("multiply", result, 0xffffd70000002900l); }
@Test
public void test06217() { x = 0x000000017fffffffl; long result = x * 0xffffffffffffd700l; AssertJUnit.assertEquals("multiply", result, 0xffffc28000002900l); }
@Test
public void test06218() { x = 0x0000000180000000l; long result = x * 0xffffffffffffd700l; AssertJUnit.assertEquals("multiply", result, 0xffffc28000000000l); }
@Test
public void test06219() { x = 0x00000001ffffffffl; long result = x * 0xffffffffffffd700l; AssertJUnit.assertEquals("multiply", result, 0xffffae0000002900l); }
@Test
public void test06220() { x = 0xffffffff7fffffffl; long result = x * 0xffffffffffffd700l; AssertJUnit.assertEquals("multiply", result, 0x0000148000002900l); }
@Test
public void test06221() { x = 0xffffffff80000000l; long result = x * 0xffffffffffffd700l; AssertJUnit.assertEquals("multiply", result, 0x0000148000000000l); }
@Test
public void test06222() { x = 0x00000001deadf00dl; long result = x * 0xffffffffffffd700l; AssertJUnit.assertEquals("multiply", result, 0xffffb356248deb00l); }
@Test
public void test06223() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffffffffd700l; AssertJUnit.assertEquals("multiply", result, 0x00000556248deb00l); }
@Test
public void test06224() { x = 0x7fffffffffffffffl; long result = x * 0xffffffffffffd700l; AssertJUnit.assertEquals("multiply", result, 0x0000000000002900l); }
@Test
public void test06225() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffffffffd700l; AssertJUnit.assertEquals("multiply", result, 0x0000148000002900l); }
@Test
public void test06226() { x = 0x7fffffff80000000l; long result = x * 0xffffffffffffd700l; AssertJUnit.assertEquals("multiply", result, 0x0000148000000000l); }
@Test
public void test06227() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffffffffd700l; AssertJUnit.assertEquals("multiply", result, 0x00000556248deb00l); }
@Test
public void test06228() { x = 0x8000000000000000l; long result = x * 0xffffffffffffd700l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test06229() { x = 0xffffffffffffffffl; long result = x * 0xffffffffffffd700l; AssertJUnit.assertEquals("multiply", result, 0x0000000000002900l); }
@Test
public void test06230() { x = 0xfffffffffffffffel; long result = x * 0xffffffffffffd700l; AssertJUnit.assertEquals("multiply", result, 0x0000000000005200l); }
@Test
public void test06231() { x = 0xefffffffffffffffl; long result = x * 0xffffffffffffd700l; AssertJUnit.assertEquals("multiply", result, 0x0000000000002900l); }
@Test
public void test06232() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffffffffd700l; AssertJUnit.assertEquals("multiply", result, 0x248dc756248deb00l); }
@Test
public void test06233() { x = 0x000000007fffffffl; long result = x * 0xffffffd700000000l; AssertJUnit.assertEquals("multiply", result, 0x8000002900000000l); }
@Test
public void test06234() { x = 0x0000000080000000l; long result = x * 0xffffffd700000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test06235() { x = 0x00000000ffffffffl; long result = x * 0xffffffd700000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002900000000l); }
@Test
public void test06236() { x = 0x000000017fffffffl; long result = x * 0xffffffd700000000l; AssertJUnit.assertEquals("multiply", result, 0x8000002900000000l); }
@Test
public void test06237() { x = 0x0000000180000000l; long result = x * 0xffffffd700000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test06238() { x = 0x00000001ffffffffl; long result = x * 0xffffffd700000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002900000000l); }
@Test
public void test06239() { x = 0xffffffff7fffffffl; long result = x * 0xffffffd700000000l; AssertJUnit.assertEquals("multiply", result, 0x8000002900000000l); }
@Test
public void test06240() { x = 0xffffffff80000000l; long result = x * 0xffffffd700000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test06241() { x = 0x00000001deadf00dl; long result = x * 0xffffffd700000000l; AssertJUnit.assertEquals("multiply", result, 0x56248deb00000000l); }
@Test
public void test06242() { x = 0xffffffffdeadf00dl; long result = x * 0xffffffd700000000l; AssertJUnit.assertEquals("multiply", result, 0x56248deb00000000l); }
@Test
public void test06243() { x = 0x7fffffffffffffffl; long result = x * 0xffffffd700000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002900000000l); }
@Test
public void test06244() { x = 0x7fffffff7fffffffl; long result = x * 0xffffffd700000000l; AssertJUnit.assertEquals("multiply", result, 0x8000002900000000l); }
@Test
public void test06245() { x = 0x7fffffff80000000l; long result = x * 0xffffffd700000000l; AssertJUnit.assertEquals("multiply", result, 0x8000000000000000l); }
@Test
public void test06246() { x = 0x7fffffffdeadf00dl; long result = x * 0xffffffd700000000l; AssertJUnit.assertEquals("multiply", result, 0x56248deb00000000l); }
@Test
public void test06247() { x = 0x8000000000000000l; long result = x * 0xffffffd700000000l; AssertJUnit.assertEquals("multiply", result, 0x0000000000000000l); }
@Test
public void test06248() { x = 0xffffffffffffffffl; long result = x * 0xffffffd700000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002900000000l); }
@Test
public void test06249() { x = 0xfffffffffffffffel; long result = x * 0xffffffd700000000l; AssertJUnit.assertEquals("multiply", result, 0x0000005200000000l); }
@Test
public void test06250() { x = 0xefffffffffffffffl; long result = x * 0xffffffd700000000l; AssertJUnit.assertEquals("multiply", result, 0x0000002900000000l); }
@Test
public void test06251() { x = 0xdeadf00ddeadf00dl; long result = x * 0xffffffd700000000l; AssertJUnit.assertEquals("multiply", result, 0x56248deb00000000l); }
@Tes