/*******************************************************************************
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution and
 * is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 *******************************************************************************/

#include "jnitest_internal.h"

/* *** LONG NAME (''Java_jit_test_vich_JNI_nativeJNI'' ''Java_jit_test_vich_JNI_nativeJNI__III'') */void JNICALL Java_jit_test_vich_JNI_nativeJNI__III(JNIEnv *env, jobject recv, int arg1, int arg2, int arg3)
{
/*	printf ("In JNI MethodStub -> Java_jit_test_vich_JNI_nativeJNI__III");  */
	return ;
}


/* *** LONG NAME (''Java_jit_test_vich_JNI_nativeJNI'' ''Java_jit_test_vich_JNI_nativeJNI__IIIII'') */void JNICALL Java_jit_test_vich_JNI_nativeJNI__IIIII(JNIEnv *env, jobject recv, int arg1, int arg2, int arg3, int arg4, int arg5)
{
/*	printf ("In JNI MethodStub -> Java_jit_test_vich_JNI_nativeJNI__IIIII");  */
	return ;
}


/* *** LONG NAME (''Java_jit_test_vich_JNI_nativeJNI'' ''Java_jit_test_vich_JNI_nativeJNI__II'') */void JNICALL Java_jit_test_vich_JNI_nativeJNI__II(JNIEnv *env, jobject recv, int arg1, int arg2)
{
/*	printf ("In JNI MethodStub -> Java_jit_test_vich_JNI_nativeJNI__II");  */
	return ;
}


/* *** LONG NAME (''Java_jit_test_vich_JNI_nativeJNI'' ''Java_jit_test_vich_JNI_nativeJNI__I'') */void JNICALL Java_jit_test_vich_JNI_nativeJNI__I(JNIEnv *env, jobject recv, int arg1)
{
/*	printf ("In JNI MethodStub -> Java_jit_test_vich_JNI_nativeJNI__I");  */
	return ;
}


/* *** LONG NAME (''Java_jit_test_vich_JNI_nativeJNI'' ''Java_jit_test_vich_JNI_nativeJNI__IIII'') */void JNICALL Java_jit_test_vich_JNI_nativeJNI__IIII(JNIEnv *env, jobject recv, int arg1, int arg2, int arg3, int arg4)
{
/*	printf ("In JNI MethodStub -> Java_jit_test_vich_JNI_nativeJNI__IIII");  */
	return ;
}


/* *** LONG NAME (''Java_jit_test_vich_JNI_nativeJNI'' ''Java_jit_test_vich_JNI_nativeJNI__Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2'') */void JNICALL Java_jit_test_vich_JNI_nativeJNI__Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2(JNIEnv *env, jobject recv, jobject arg1, jobject arg2, jobject arg3, jobject arg4)
{
/*	printf ("In JNI MethodStub -> Java_jit_test_vich_JNI_nativeJNI__Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2");  */
	return ;
}


/* *** LONG NAME (''Java_jit_test_vich_JNI_nativeJNI'' ''Java_jit_test_vich_JNI_nativeJNI__Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2'') */void JNICALL Java_jit_test_vich_JNI_nativeJNI__Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2(JNIEnv *env, jobject recv, jobject arg1, jobject arg2, jobject arg3, jobject arg4, jobject arg5, jobject arg6, jobject arg7, jobject arg8)
{
/*	printf ("In JNI MethodStub -> Java_jit_test_vich_JNI_nativeJNI__Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2");  */
	return ;
}


/* *** LONG NAME (''Java_jit_test_vich_JNI_nativeJNI'' ''Java_jit_test_vich_JNI_nativeJNI__Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2'') */void JNICALL Java_jit_test_vich_JNI_nativeJNI__Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2(JNIEnv *env, jobject recv, jobject arg1, jobject arg2, jobject arg3, jobject arg4, jobject arg5)
{
/*	printf ("In JNI MethodStub -> Java_jit_test_vich_JNI_nativeJNI__Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2");  */
	return ;
}


/* *** LONG NAME (''Java_jit_test_vich_JNI_nativeJNI'' ''Java_jit_test_vich_JNI_nativeJNI__IIIIIIII'') */void JNICALL Java_jit_test_vich_JNI_nativeJNI__IIIIIIII(JNIEnv *env, jobject recv, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8)
{
/*	printf ("In JNI MethodStub -> Java_jit_test_vich_JNI_nativeJNI__IIIIIIII");  */
	return ;
}


/* *** LONG NAME (''Java_jit_test_vich_JNI_nativeJNI'' ''Java_jit_test_vich_JNI_nativeJNI__IIIIIII'') */void JNICALL Java_jit_test_vich_JNI_nativeJNI__IIIIIII(JNIEnv *env, jobject recv, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7)
{
/*	printf ("In JNI MethodStub -> Java_jit_test_vich_JNI_nativeJNI__IIIIIII");  */
	return ;
}


/* *** LONG NAME (''Java_jit_test_vich_JNI_nativeJNI'' ''Java_jit_test_vich_JNI_nativeJNI__IIIIII'') */void JNICALL Java_jit_test_vich_JNI_nativeJNI__IIIIII(JNIEnv *env, jobject recv, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6)
{
/*	printf ("In JNI MethodStub -> Java_jit_test_vich_JNI_nativeJNI__IIIIII");  */
	return ;
}


/* *** LONG NAME (''Java_jit_test_vich_JNI_nativeJNI'' ''Java_jit_test_vich_JNI_nativeJNI__Ljava_lang_Object_2'') */void JNICALL Java_jit_test_vich_JNI_nativeJNI__Ljava_lang_Object_2(JNIEnv *env, jobject recv, jobject arg1)
{
/*	printf ("In JNI MethodStub -> Java_jit_test_vich_JNI_nativeJNI__Ljava_lang_Object_2");  */
	return ;
}


/* *** LONG NAME (''Java_jit_test_vich_JNI_nativeJNI'' ''Java_jit_test_vich_JNI_nativeJNI__Ljava_lang_Object_2Ljava_lang_Object_2'') */void JNICALL Java_jit_test_vich_JNI_nativeJNI__Ljava_lang_Object_2Ljava_lang_Object_2(JNIEnv *env, jobject recv, jobject arg1, jobject arg2)
{
/*	printf ("In JNI MethodStub -> Java_jit_test_vich_JNI_nativeJNI__Ljava_lang_Object_2Ljava_lang_Object_2");  */
	return ;
}


/* *** LONG NAME (''Java_jit_test_vich_JNI_nativeJNI'' ''Java_jit_test_vich_JNI_nativeJNI__Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2'') */void JNICALL Java_jit_test_vich_JNI_nativeJNI__Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2(JNIEnv *env, jobject recv, jobject arg1, jobject arg2, jobject arg3, jobject arg4, jobject arg5, jobject arg6)
{
/*	printf ("In JNI MethodStub -> Java_jit_test_vich_JNI_nativeJNI__Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2");  */
	return ;
}


/* *** LONG NAME (''Java_jit_test_vich_JNI_nativeJNI'' ''Java_jit_test_vich_JNI_nativeJNI__Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2'') */void JNICALL Java_jit_test_vich_JNI_nativeJNI__Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2(JNIEnv *env, jobject recv, jobject arg1, jobject arg2, jobject arg3)
{
/*	printf ("In JNI MethodStub -> Java_jit_test_vich_JNI_nativeJNI__Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2");  */
	return ;
}


/* *** LONG NAME (''Java_jit_test_vich_JNI_nativeJNI'' ''Java_jit_test_vich_JNI_nativeJNI__Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2'') */void JNICALL Java_jit_test_vich_JNI_nativeJNI__Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2(JNIEnv *env, jobject recv, jobject arg1, jobject arg2, jobject arg3, jobject arg4, jobject arg5, jobject arg6, jobject arg7)
{
/*	printf ("In JNI MethodStub -> Java_jit_test_vich_JNI_nativeJNI__Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_Object_2");  */
	return ;
}


/* *** LONG NAME (''Java_jit_test_vich_JNI_nativeJNI'' ''Java_jit_test_vich_JNI_nativeJNI__'') */void JNICALL Java_jit_test_vich_JNI_nativeJNI__(JNIEnv *env, jobject recv)
{
/*	printf ("In JNI MethodStub -> Java_jit_test_vich_JNI_nativeJNI__");  */
	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInVirtualVoid(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"virtualVoid",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)V");
		if (mid == NULL) return;

		{
			(*env)->CallVoidMethod(env, recv, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0);
			
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallVoidMethod(env, recv, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInVirtualBoolean(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"virtualBoolean",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)Z");
		if (mid == NULL) return;

		{
			jboolean rc = (*env)->CallBooleanMethod(env, recv, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0);
			if (rc != 0)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallBooleanMethod(env, recv, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInVirtualByte(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"virtualByte",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)B");
		if (mid == NULL) return;

		{
			jbyte rc = (*env)->CallByteMethod(env, recv, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0);
			if (rc != 1)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallByteMethod(env, recv, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInVirtualShort(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"virtualShort",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)S");
		if (mid == NULL) return;

		{
			jshort rc = (*env)->CallShortMethod(env, recv, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0);
			if (rc != 3)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallShortMethod(env, recv, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInVirtualChar(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"virtualChar",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)C");
		if (mid == NULL) return;

		{
			jchar rc = (*env)->CallCharMethod(env, recv, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0);
			if (rc != 2)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallCharMethod(env, recv, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInVirtualInt(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"virtualInt",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)I");
		if (mid == NULL) return;

		{
			jint rc = (*env)->CallIntMethod(env, recv, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0);
			if (rc != 4)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallIntMethod(env, recv, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInVirtualLong(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"virtualLong",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)J");
		if (mid == NULL) return;

		{
			jlong rc = (*env)->CallLongMethod(env, recv, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0);
			if (rc != 5)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallLongMethod(env, recv, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInVirtualDouble(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"virtualDouble",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)D");
		if (mid == NULL) return;

		{
			jdouble rc = (*env)->CallDoubleMethod(env, recv, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0);
			if (rc != 6.0)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallDoubleMethod(env, recv, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInVirtualFloat(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"virtualFloat",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)F");
		if (mid == NULL) return;

		{
			jfloat rc = (*env)->CallFloatMethod(env, recv, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0);
			if (rc != 7.0)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallFloatMethod(env, recv, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInNonvirtualVoid(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"nonvirtualVoid",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)V");
		if (mid == NULL) return;

		{
			(*env)->CallNonvirtualVoidMethod(env, recv, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0);
			
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallNonvirtualVoidMethod(env, recv, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInNonvirtualBoolean(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"nonvirtualBoolean",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)Z");
		if (mid == NULL) return;

		{
			jboolean rc = (*env)->CallNonvirtualBooleanMethod(env, recv, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0);
			if (rc != 0)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallNonvirtualBooleanMethod(env, recv, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInNonvirtualByte(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"nonvirtualByte",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)B");
		if (mid == NULL) return;

		{
			jbyte rc = (*env)->CallNonvirtualByteMethod(env, recv, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0);
			if (rc != 1)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallNonvirtualByteMethod(env, recv, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInNonvirtualShort(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"nonvirtualShort",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)S");
		if (mid == NULL) return;

		{
			jshort rc = (*env)->CallNonvirtualShortMethod(env, recv, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0);
			if (rc != 3)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallNonvirtualShortMethod(env, recv, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInNonvirtualChar(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"nonvirtualChar",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)C");
		if (mid == NULL) return;

		{
			jchar rc = (*env)->CallNonvirtualCharMethod(env, recv, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0);
			if (rc != 2)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallNonvirtualCharMethod(env, recv, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInNonvirtualInt(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"nonvirtualInt",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)I");
		if (mid == NULL) return;

		{
			jint rc = (*env)->CallNonvirtualIntMethod(env, recv, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0);
			if (rc != 4)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallNonvirtualIntMethod(env, recv, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInNonvirtualLong(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"nonvirtualLong",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)J");
		if (mid == NULL) return;

		{
			jlong rc = (*env)->CallNonvirtualLongMethod(env, recv, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0);
			if (rc != 5)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallNonvirtualLongMethod(env, recv, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInNonvirtualDouble(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"nonvirtualDouble",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)D");
		if (mid == NULL) return;

		{
			jdouble rc = (*env)->CallNonvirtualDoubleMethod(env, recv, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0);
			if (rc != 6.0)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallNonvirtualDoubleMethod(env, recv, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInNonvirtualFloat(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"nonvirtualFloat",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)F");
		if (mid == NULL) return;

		{
			jfloat rc = (*env)->CallNonvirtualFloatMethod(env, recv, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0);
			if (rc != 7.0)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallNonvirtualFloatMethod(env, recv, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInStaticVoid(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetStaticMethodID(
			env,
			clazz,
			"staticVoid",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)V");
		if (mid == NULL) return;

		{
			(*env)->CallStaticVoidMethod(env, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0);
			
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallStaticVoidMethod(env, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInStaticBoolean(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetStaticMethodID(
			env,
			clazz,
			"staticBoolean",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)Z");
		if (mid == NULL) return;

		{
			jboolean rc = (*env)->CallStaticBooleanMethod(env, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0);
			if (rc != 0)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallStaticBooleanMethod(env, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInStaticByte(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetStaticMethodID(
			env,
			clazz,
			"staticByte",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)B");
		if (mid == NULL) return;

		{
			jbyte rc = (*env)->CallStaticByteMethod(env, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0);
			if (rc != 1)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallStaticByteMethod(env, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInStaticShort(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetStaticMethodID(
			env,
			clazz,
			"staticShort",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)S");
		if (mid == NULL) return;

		{
			jshort rc = (*env)->CallStaticShortMethod(env, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0);
			if (rc != 3)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallStaticShortMethod(env, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInStaticChar(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetStaticMethodID(
			env,
			clazz,
			"staticChar",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)C");
		if (mid == NULL) return;

		{
			jchar rc = (*env)->CallStaticCharMethod(env, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0);
			if (rc != 2)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallStaticCharMethod(env, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInStaticInt(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetStaticMethodID(
			env,
			clazz,
			"staticInt",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)I");
		if (mid == NULL) return;

		{
			jint rc = (*env)->CallStaticIntMethod(env, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0);
			if (rc != 4)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallStaticIntMethod(env, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInStaticLong(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetStaticMethodID(
			env,
			clazz,
			"staticLong",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)J");
		if (mid == NULL) return;

		{
			jlong rc = (*env)->CallStaticLongMethod(env, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0);
			if (rc != 5)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallStaticLongMethod(env, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInStaticDouble(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetStaticMethodID(
			env,
			clazz,
			"staticDouble",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)D");
		if (mid == NULL) return;

		{
			jdouble rc = (*env)->CallStaticDoubleMethod(env, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0);
			if (rc != 6.0)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallStaticDoubleMethod(env, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInStaticFloat(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetStaticMethodID(
			env,
			clazz,
			"staticFloat",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)F");
		if (mid == NULL) return;

		{
			jfloat rc = (*env)->CallStaticFloatMethod(env, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0);
			if (rc != 7.0)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallStaticFloatMethod(env, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInVirtualObject(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"virtualObject",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)Ljava/lang/Object;");
		if (mid == NULL) return;

		{
			jobject rc = (*env)->CallObjectMethod(env, recv, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0);
			if (!(*env)->IsSameObject(env, rc, recv))  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		(*env)->DeleteLocalRef(env, (*env)->CallObjectMethod(env, recv, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInNonvirtualObject(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"nonvirtualObject",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)Ljava/lang/Object;");
		if (mid == NULL) return;

		{
			jobject rc = (*env)->CallNonvirtualObjectMethod(env, recv, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0);
			if (!(*env)->IsSameObject(env, rc, recv))  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		(*env)->DeleteLocalRef(env, (*env)->CallNonvirtualObjectMethod(env, recv, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInStaticObject(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetStaticMethodID(
			env,
			clazz,
			"staticObject",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)Ljava/lang/Object;");
		if (mid == NULL) return;

		{
			jobject rc = (*env)->CallStaticObjectMethod(env, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0);
			if (!(*env)->IsSameObject(env, rc, recv))  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		(*env)->DeleteLocalRef(env, (*env)->CallStaticObjectMethod(env, clazz, mid, recv, NULL, intArray, objArray, (jboolean)0, (jbyte)1, (jchar)2, (jshort)3, (jint)4, (jlong)5, (jdouble)6.0, (jfloat)7.0));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInVirtualVoidA(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;
	static jvalue args[12];

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"virtualVoid",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)V");
		if (mid == NULL) return;

		args[0].l = (*env)->NewGlobalRef(env, recv);
		args[1].l = (*env)->NewGlobalRef(env, NULL);
		args[2].l = (*env)->NewGlobalRef(env, intArray);
		args[3].l = (*env)->NewGlobalRef(env, objArray);
		args[4].z = 0;
		args[5].b = 1;
		args[6].c = 2;
		args[7].s = 3;
		args[8].i = 4;
		args[9].j = 5;
		args[10].d = 6.0;
		args[11].f = 7.0;

		{
			(*env)->CallVoidMethodA(env, recv, mid, args);
			
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallVoidMethodA(env, recv, mid, args));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInVirtualBooleanA(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;
	static jvalue args[12];

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"virtualBoolean",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)Z");
		if (mid == NULL) return;

		args[0].l = (*env)->NewGlobalRef(env, recv);
		args[1].l = (*env)->NewGlobalRef(env, NULL);
		args[2].l = (*env)->NewGlobalRef(env, intArray);
		args[3].l = (*env)->NewGlobalRef(env, objArray);
		args[4].z = 0;
		args[5].b = 1;
		args[6].c = 2;
		args[7].s = 3;
		args[8].i = 4;
		args[9].j = 5;
		args[10].d = 6.0;
		args[11].f = 7.0;

		{
			jboolean rc = (*env)->CallBooleanMethodA(env, recv, mid, args);
			if (rc != 0)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallBooleanMethodA(env, recv, mid, args));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInVirtualByteA(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;
	static jvalue args[12];

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"virtualByte",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)B");
		if (mid == NULL) return;

		args[0].l = (*env)->NewGlobalRef(env, recv);
		args[1].l = (*env)->NewGlobalRef(env, NULL);
		args[2].l = (*env)->NewGlobalRef(env, intArray);
		args[3].l = (*env)->NewGlobalRef(env, objArray);
		args[4].z = 0;
		args[5].b = 1;
		args[6].c = 2;
		args[7].s = 3;
		args[8].i = 4;
		args[9].j = 5;
		args[10].d = 6.0;
		args[11].f = 7.0;

		{
			jbyte rc = (*env)->CallByteMethodA(env, recv, mid, args);
			if (rc != 1)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallByteMethodA(env, recv, mid, args));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInVirtualShortA(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;
	static jvalue args[12];

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"virtualShort",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)S");
		if (mid == NULL) return;

		args[0].l = (*env)->NewGlobalRef(env, recv);
		args[1].l = (*env)->NewGlobalRef(env, NULL);
		args[2].l = (*env)->NewGlobalRef(env, intArray);
		args[3].l = (*env)->NewGlobalRef(env, objArray);
		args[4].z = 0;
		args[5].b = 1;
		args[6].c = 2;
		args[7].s = 3;
		args[8].i = 4;
		args[9].j = 5;
		args[10].d = 6.0;
		args[11].f = 7.0;

		{
			jshort rc = (*env)->CallShortMethodA(env, recv, mid, args);
			if (rc != 3)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallShortMethodA(env, recv, mid, args));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInVirtualCharA(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;
	static jvalue args[12];

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"virtualChar",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)C");
		if (mid == NULL) return;

		args[0].l = (*env)->NewGlobalRef(env, recv);
		args[1].l = (*env)->NewGlobalRef(env, NULL);
		args[2].l = (*env)->NewGlobalRef(env, intArray);
		args[3].l = (*env)->NewGlobalRef(env, objArray);
		args[4].z = 0;
		args[5].b = 1;
		args[6].c = 2;
		args[7].s = 3;
		args[8].i = 4;
		args[9].j = 5;
		args[10].d = 6.0;
		args[11].f = 7.0;

		{
			jchar rc = (*env)->CallCharMethodA(env, recv, mid, args);
			if (rc != 2)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallCharMethodA(env, recv, mid, args));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInVirtualIntA(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;
	static jvalue args[12];

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"virtualInt",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)I");
		if (mid == NULL) return;

		args[0].l = (*env)->NewGlobalRef(env, recv);
		args[1].l = (*env)->NewGlobalRef(env, NULL);
		args[2].l = (*env)->NewGlobalRef(env, intArray);
		args[3].l = (*env)->NewGlobalRef(env, objArray);
		args[4].z = 0;
		args[5].b = 1;
		args[6].c = 2;
		args[7].s = 3;
		args[8].i = 4;
		args[9].j = 5;
		args[10].d = 6.0;
		args[11].f = 7.0;

		{
			jint rc = (*env)->CallIntMethodA(env, recv, mid, args);
			if (rc != 4)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallIntMethodA(env, recv, mid, args));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInVirtualLongA(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;
	static jvalue args[12];

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"virtualLong",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)J");
		if (mid == NULL) return;

		args[0].l = (*env)->NewGlobalRef(env, recv);
		args[1].l = (*env)->NewGlobalRef(env, NULL);
		args[2].l = (*env)->NewGlobalRef(env, intArray);
		args[3].l = (*env)->NewGlobalRef(env, objArray);
		args[4].z = 0;
		args[5].b = 1;
		args[6].c = 2;
		args[7].s = 3;
		args[8].i = 4;
		args[9].j = 5;
		args[10].d = 6.0;
		args[11].f = 7.0;

		{
			jlong rc = (*env)->CallLongMethodA(env, recv, mid, args);
			if (rc != 5)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallLongMethodA(env, recv, mid, args));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInVirtualDoubleA(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;
	static jvalue args[12];

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"virtualDouble",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)D");
		if (mid == NULL) return;

		args[0].l = (*env)->NewGlobalRef(env, recv);
		args[1].l = (*env)->NewGlobalRef(env, NULL);
		args[2].l = (*env)->NewGlobalRef(env, intArray);
		args[3].l = (*env)->NewGlobalRef(env, objArray);
		args[4].z = 0;
		args[5].b = 1;
		args[6].c = 2;
		args[7].s = 3;
		args[8].i = 4;
		args[9].j = 5;
		args[10].d = 6.0;
		args[11].f = 7.0;

		{
			jdouble rc = (*env)->CallDoubleMethodA(env, recv, mid, args);
			if (rc != 6.0)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallDoubleMethodA(env, recv, mid, args));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInVirtualFloatA(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;
	static jvalue args[12];

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"virtualFloat",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)F");
		if (mid == NULL) return;

		args[0].l = (*env)->NewGlobalRef(env, recv);
		args[1].l = (*env)->NewGlobalRef(env, NULL);
		args[2].l = (*env)->NewGlobalRef(env, intArray);
		args[3].l = (*env)->NewGlobalRef(env, objArray);
		args[4].z = 0;
		args[5].b = 1;
		args[6].c = 2;
		args[7].s = 3;
		args[8].i = 4;
		args[9].j = 5;
		args[10].d = 6.0;
		args[11].f = 7.0;

		{
			jfloat rc = (*env)->CallFloatMethodA(env, recv, mid, args);
			if (rc != 7.0)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallFloatMethodA(env, recv, mid, args));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInVirtualObjectA(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;
	static jvalue args[12];

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"virtualObject",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)Ljava/lang/Object;");
		if (mid == NULL) return;

		args[0].l = (*env)->NewGlobalRef(env, recv);
		args[1].l = (*env)->NewGlobalRef(env, NULL);
		args[2].l = (*env)->NewGlobalRef(env, intArray);
		args[3].l = (*env)->NewGlobalRef(env, objArray);
		args[4].z = 0;
		args[5].b = 1;
		args[6].c = 2;
		args[7].s = 3;
		args[8].i = 4;
		args[9].j = 5;
		args[10].d = 6.0;
		args[11].f = 7.0;

		{
			jobject rc = (*env)->CallObjectMethodA(env, recv, mid, args);
			if (!(*env)->IsSameObject(env, rc, recv))  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		(*env)->DeleteLocalRef(env, (*env)->CallObjectMethodA(env, recv, mid, args));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInNonvirtualVoidA(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;
	static jvalue args[12];

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"nonvirtualVoid",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)V");
		if (mid == NULL) return;

		args[0].l = (*env)->NewGlobalRef(env, recv);
		args[1].l = (*env)->NewGlobalRef(env, NULL);
		args[2].l = (*env)->NewGlobalRef(env, intArray);
		args[3].l = (*env)->NewGlobalRef(env, objArray);
		args[4].z = 0;
		args[5].b = 1;
		args[6].c = 2;
		args[7].s = 3;
		args[8].i = 4;
		args[9].j = 5;
		args[10].d = 6.0;
		args[11].f = 7.0;

		{
			(*env)->CallNonvirtualVoidMethodA(env, recv, clazz, mid, args);
			
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallNonvirtualVoidMethodA(env, recv, clazz, mid, args));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInNonvirtualBooleanA(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;
	static jvalue args[12];

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"nonvirtualBoolean",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)Z");
		if (mid == NULL) return;

		args[0].l = (*env)->NewGlobalRef(env, recv);
		args[1].l = (*env)->NewGlobalRef(env, NULL);
		args[2].l = (*env)->NewGlobalRef(env, intArray);
		args[3].l = (*env)->NewGlobalRef(env, objArray);
		args[4].z = 0;
		args[5].b = 1;
		args[6].c = 2;
		args[7].s = 3;
		args[8].i = 4;
		args[9].j = 5;
		args[10].d = 6.0;
		args[11].f = 7.0;

		{
			jboolean rc = (*env)->CallNonvirtualBooleanMethodA(env, recv, clazz, mid, args);
			if (rc != 0)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallNonvirtualBooleanMethodA(env, recv, clazz, mid, args));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInNonvirtualByteA(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;
	static jvalue args[12];

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"nonvirtualByte",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)B");
		if (mid == NULL) return;

		args[0].l = (*env)->NewGlobalRef(env, recv);
		args[1].l = (*env)->NewGlobalRef(env, NULL);
		args[2].l = (*env)->NewGlobalRef(env, intArray);
		args[3].l = (*env)->NewGlobalRef(env, objArray);
		args[4].z = 0;
		args[5].b = 1;
		args[6].c = 2;
		args[7].s = 3;
		args[8].i = 4;
		args[9].j = 5;
		args[10].d = 6.0;
		args[11].f = 7.0;

		{
			jbyte rc = (*env)->CallNonvirtualByteMethodA(env, recv, clazz, mid, args);
			if (rc != 1)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallNonvirtualByteMethodA(env, recv, clazz, mid, args));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInNonvirtualShortA(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;
	static jvalue args[12];

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"nonvirtualShort",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)S");
		if (mid == NULL) return;

		args[0].l = (*env)->NewGlobalRef(env, recv);
		args[1].l = (*env)->NewGlobalRef(env, NULL);
		args[2].l = (*env)->NewGlobalRef(env, intArray);
		args[3].l = (*env)->NewGlobalRef(env, objArray);
		args[4].z = 0;
		args[5].b = 1;
		args[6].c = 2;
		args[7].s = 3;
		args[8].i = 4;
		args[9].j = 5;
		args[10].d = 6.0;
		args[11].f = 7.0;

		{
			jshort rc = (*env)->CallNonvirtualShortMethodA(env, recv, clazz, mid, args);
			if (rc != 3)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallNonvirtualShortMethodA(env, recv, clazz, mid, args));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInNonvirtualCharA(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;
	static jvalue args[12];

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"nonvirtualChar",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)C");
		if (mid == NULL) return;

		args[0].l = (*env)->NewGlobalRef(env, recv);
		args[1].l = (*env)->NewGlobalRef(env, NULL);
		args[2].l = (*env)->NewGlobalRef(env, intArray);
		args[3].l = (*env)->NewGlobalRef(env, objArray);
		args[4].z = 0;
		args[5].b = 1;
		args[6].c = 2;
		args[7].s = 3;
		args[8].i = 4;
		args[9].j = 5;
		args[10].d = 6.0;
		args[11].f = 7.0;

		{
			jchar rc = (*env)->CallNonvirtualCharMethodA(env, recv, clazz, mid, args);
			if (rc != 2)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallNonvirtualCharMethodA(env, recv, clazz, mid, args));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInNonvirtualIntA(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;
	static jvalue args[12];

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"nonvirtualInt",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)I");
		if (mid == NULL) return;

		args[0].l = (*env)->NewGlobalRef(env, recv);
		args[1].l = (*env)->NewGlobalRef(env, NULL);
		args[2].l = (*env)->NewGlobalRef(env, intArray);
		args[3].l = (*env)->NewGlobalRef(env, objArray);
		args[4].z = 0;
		args[5].b = 1;
		args[6].c = 2;
		args[7].s = 3;
		args[8].i = 4;
		args[9].j = 5;
		args[10].d = 6.0;
		args[11].f = 7.0;

		{
			jint rc = (*env)->CallNonvirtualIntMethodA(env, recv, clazz, mid, args);
			if (rc != 4)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallNonvirtualIntMethodA(env, recv, clazz, mid, args));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInNonvirtualLongA(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;
	static jvalue args[12];

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"nonvirtualLong",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)J");
		if (mid == NULL) return;

		args[0].l = (*env)->NewGlobalRef(env, recv);
		args[1].l = (*env)->NewGlobalRef(env, NULL);
		args[2].l = (*env)->NewGlobalRef(env, intArray);
		args[3].l = (*env)->NewGlobalRef(env, objArray);
		args[4].z = 0;
		args[5].b = 1;
		args[6].c = 2;
		args[7].s = 3;
		args[8].i = 4;
		args[9].j = 5;
		args[10].d = 6.0;
		args[11].f = 7.0;

		{
			jlong rc = (*env)->CallNonvirtualLongMethodA(env, recv, clazz, mid, args);
			if (rc != 5)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallNonvirtualLongMethodA(env, recv, clazz, mid, args));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInNonvirtualDoubleA(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;
	static jvalue args[12];

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"nonvirtualDouble",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)D");
		if (mid == NULL) return;

		args[0].l = (*env)->NewGlobalRef(env, recv);
		args[1].l = (*env)->NewGlobalRef(env, NULL);
		args[2].l = (*env)->NewGlobalRef(env, intArray);
		args[3].l = (*env)->NewGlobalRef(env, objArray);
		args[4].z = 0;
		args[5].b = 1;
		args[6].c = 2;
		args[7].s = 3;
		args[8].i = 4;
		args[9].j = 5;
		args[10].d = 6.0;
		args[11].f = 7.0;

		{
			jdouble rc = (*env)->CallNonvirtualDoubleMethodA(env, recv, clazz, mid, args);
			if (rc != 6.0)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallNonvirtualDoubleMethodA(env, recv, clazz, mid, args));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInNonvirtualFloatA(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;
	static jvalue args[12];

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"nonvirtualFloat",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)F");
		if (mid == NULL) return;

		args[0].l = (*env)->NewGlobalRef(env, recv);
		args[1].l = (*env)->NewGlobalRef(env, NULL);
		args[2].l = (*env)->NewGlobalRef(env, intArray);
		args[3].l = (*env)->NewGlobalRef(env, objArray);
		args[4].z = 0;
		args[5].b = 1;
		args[6].c = 2;
		args[7].s = 3;
		args[8].i = 4;
		args[9].j = 5;
		args[10].d = 6.0;
		args[11].f = 7.0;

		{
			jfloat rc = (*env)->CallNonvirtualFloatMethodA(env, recv, clazz, mid, args);
			if (rc != 7.0)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallNonvirtualFloatMethodA(env, recv, clazz, mid, args));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInNonvirtualObjectA(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;
	static jvalue args[12];

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetMethodID(
			env,
			clazz,
			"nonvirtualObject",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)Ljava/lang/Object;");
		if (mid == NULL) return;

		args[0].l = (*env)->NewGlobalRef(env, recv);
		args[1].l = (*env)->NewGlobalRef(env, NULL);
		args[2].l = (*env)->NewGlobalRef(env, intArray);
		args[3].l = (*env)->NewGlobalRef(env, objArray);
		args[4].z = 0;
		args[5].b = 1;
		args[6].c = 2;
		args[7].s = 3;
		args[8].i = 4;
		args[9].j = 5;
		args[10].d = 6.0;
		args[11].f = 7.0;

		{
			jobject rc = (*env)->CallNonvirtualObjectMethodA(env, recv, clazz, mid, args);
			if (!(*env)->IsSameObject(env, rc, recv))  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		(*env)->DeleteLocalRef(env, (*env)->CallNonvirtualObjectMethodA(env, recv, clazz, mid, args));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInStaticVoidA(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;
	static jvalue args[12];

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetStaticMethodID(
			env,
			clazz,
			"staticVoid",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)V");
		if (mid == NULL) return;

		args[0].l = (*env)->NewGlobalRef(env, recv);
		args[1].l = (*env)->NewGlobalRef(env, NULL);
		args[2].l = (*env)->NewGlobalRef(env, intArray);
		args[3].l = (*env)->NewGlobalRef(env, objArray);
		args[4].z = 0;
		args[5].b = 1;
		args[6].c = 2;
		args[7].s = 3;
		args[8].i = 4;
		args[9].j = 5;
		args[10].d = 6.0;
		args[11].f = 7.0;

		{
			(*env)->CallStaticVoidMethodA(env, clazz, mid, args);
			
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallStaticVoidMethodA(env, clazz, mid, args));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInStaticBooleanA(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;
	static jvalue args[12];

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetStaticMethodID(
			env,
			clazz,
			"staticBoolean",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)Z");
		if (mid == NULL) return;

		args[0].l = (*env)->NewGlobalRef(env, recv);
		args[1].l = (*env)->NewGlobalRef(env, NULL);
		args[2].l = (*env)->NewGlobalRef(env, intArray);
		args[3].l = (*env)->NewGlobalRef(env, objArray);
		args[4].z = 0;
		args[5].b = 1;
		args[6].c = 2;
		args[7].s = 3;
		args[8].i = 4;
		args[9].j = 5;
		args[10].d = 6.0;
		args[11].f = 7.0;

		{
			jboolean rc = (*env)->CallStaticBooleanMethodA(env, clazz, mid, args);
			if (rc != 0)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallStaticBooleanMethodA(env, clazz, mid, args));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInStaticByteA(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;
	static jvalue args[12];

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetStaticMethodID(
			env,
			clazz,
			"staticByte",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)B");
		if (mid == NULL) return;

		args[0].l = (*env)->NewGlobalRef(env, recv);
		args[1].l = (*env)->NewGlobalRef(env, NULL);
		args[2].l = (*env)->NewGlobalRef(env, intArray);
		args[3].l = (*env)->NewGlobalRef(env, objArray);
		args[4].z = 0;
		args[5].b = 1;
		args[6].c = 2;
		args[7].s = 3;
		args[8].i = 4;
		args[9].j = 5;
		args[10].d = 6.0;
		args[11].f = 7.0;

		{
			jbyte rc = (*env)->CallStaticByteMethodA(env, clazz, mid, args);
			if (rc != 1)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallStaticByteMethodA(env, clazz, mid, args));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInStaticShortA(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;
	static jvalue args[12];

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetStaticMethodID(
			env,
			clazz,
			"staticShort",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)S");
		if (mid == NULL) return;

		args[0].l = (*env)->NewGlobalRef(env, recv);
		args[1].l = (*env)->NewGlobalRef(env, NULL);
		args[2].l = (*env)->NewGlobalRef(env, intArray);
		args[3].l = (*env)->NewGlobalRef(env, objArray);
		args[4].z = 0;
		args[5].b = 1;
		args[6].c = 2;
		args[7].s = 3;
		args[8].i = 4;
		args[9].j = 5;
		args[10].d = 6.0;
		args[11].f = 7.0;

		{
			jshort rc = (*env)->CallStaticShortMethodA(env, clazz, mid, args);
			if (rc != 3)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallStaticShortMethodA(env, clazz, mid, args));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInStaticCharA(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;
	static jvalue args[12];

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetStaticMethodID(
			env,
			clazz,
			"staticChar",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)C");
		if (mid == NULL) return;

		args[0].l = (*env)->NewGlobalRef(env, recv);
		args[1].l = (*env)->NewGlobalRef(env, NULL);
		args[2].l = (*env)->NewGlobalRef(env, intArray);
		args[3].l = (*env)->NewGlobalRef(env, objArray);
		args[4].z = 0;
		args[5].b = 1;
		args[6].c = 2;
		args[7].s = 3;
		args[8].i = 4;
		args[9].j = 5;
		args[10].d = 6.0;
		args[11].f = 7.0;

		{
			jchar rc = (*env)->CallStaticCharMethodA(env, clazz, mid, args);
			if (rc != 2)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallStaticCharMethodA(env, clazz, mid, args));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInStaticIntA(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;
	static jvalue args[12];

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetStaticMethodID(
			env,
			clazz,
			"staticInt",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)I");
		if (mid == NULL) return;

		args[0].l = (*env)->NewGlobalRef(env, recv);
		args[1].l = (*env)->NewGlobalRef(env, NULL);
		args[2].l = (*env)->NewGlobalRef(env, intArray);
		args[3].l = (*env)->NewGlobalRef(env, objArray);
		args[4].z = 0;
		args[5].b = 1;
		args[6].c = 2;
		args[7].s = 3;
		args[8].i = 4;
		args[9].j = 5;
		args[10].d = 6.0;
		args[11].f = 7.0;

		{
			jint rc = (*env)->CallStaticIntMethodA(env, clazz, mid, args);
			if (rc != 4)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallStaticIntMethodA(env, clazz, mid, args));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInStaticLongA(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;
	static jvalue args[12];

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetStaticMethodID(
			env,
			clazz,
			"staticLong",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)J");
		if (mid == NULL) return;

		args[0].l = (*env)->NewGlobalRef(env, recv);
		args[1].l = (*env)->NewGlobalRef(env, NULL);
		args[2].l = (*env)->NewGlobalRef(env, intArray);
		args[3].l = (*env)->NewGlobalRef(env, objArray);
		args[4].z = 0;
		args[5].b = 1;
		args[6].c = 2;
		args[7].s = 3;
		args[8].i = 4;
		args[9].j = 5;
		args[10].d = 6.0;
		args[11].f = 7.0;

		{
			jlong rc = (*env)->CallStaticLongMethodA(env, clazz, mid, args);
			if (rc != 5)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallStaticLongMethodA(env, clazz, mid, args));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInStaticDoubleA(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;
	static jvalue args[12];

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetStaticMethodID(
			env,
			clazz,
			"staticDouble",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)D");
		if (mid == NULL) return;

		args[0].l = (*env)->NewGlobalRef(env, recv);
		args[1].l = (*env)->NewGlobalRef(env, NULL);
		args[2].l = (*env)->NewGlobalRef(env, intArray);
		args[3].l = (*env)->NewGlobalRef(env, objArray);
		args[4].z = 0;
		args[5].b = 1;
		args[6].c = 2;
		args[7].s = 3;
		args[8].i = 4;
		args[9].j = 5;
		args[10].d = 6.0;
		args[11].f = 7.0;

		{
			jdouble rc = (*env)->CallStaticDoubleMethodA(env, clazz, mid, args);
			if (rc != 6.0)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallStaticDoubleMethodA(env, clazz, mid, args));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInStaticFloatA(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;
	static jvalue args[12];

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetStaticMethodID(
			env,
			clazz,
			"staticFloat",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)F");
		if (mid == NULL) return;

		args[0].l = (*env)->NewGlobalRef(env, recv);
		args[1].l = (*env)->NewGlobalRef(env, NULL);
		args[2].l = (*env)->NewGlobalRef(env, intArray);
		args[3].l = (*env)->NewGlobalRef(env, objArray);
		args[4].z = 0;
		args[5].b = 1;
		args[6].c = 2;
		args[7].s = 3;
		args[8].i = 4;
		args[9].j = 5;
		args[10].d = 6.0;
		args[11].f = 7.0;

		{
			jfloat rc = (*env)->CallStaticFloatMethodA(env, clazz, mid, args);
			if (rc != 7.0)  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		((*env)->CallStaticFloatMethodA(env, clazz, mid, args));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNICallIn_callInStaticObjectA(JNIEnv *env, jobject recv, jint loopCount, jobject objArray, jobject intArray)
{
	jint i;
	static jclass clazz = NULL;
	static jmethodID mid = NULL;
	static jvalue args[12];

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		mid = (*env)->GetStaticMethodID(
			env,
			clazz,
			"staticObject",
			"(Ljava/lang/Object;Ljava/lang/Object;[I[Ljava/lang/Object;ZBCSIJDF)Ljava/lang/Object;");
		if (mid == NULL) return;

		args[0].l = (*env)->NewGlobalRef(env, recv);
		args[1].l = (*env)->NewGlobalRef(env, NULL);
		args[2].l = (*env)->NewGlobalRef(env, intArray);
		args[3].l = (*env)->NewGlobalRef(env, objArray);
		args[4].z = 0;
		args[5].b = 1;
		args[6].c = 2;
		args[7].s = 3;
		args[8].i = 4;
		args[9].j = 5;
		args[10].d = 6.0;
		args[11].f = 7.0;

		{
			jobject rc = (*env)->CallStaticObjectMethodA(env, clazz, mid, args);
			if (!(*env)->IsSameObject(env, rc, recv))  {
				jclass throwable = (*env)->FindClass(env, "vich/bench/JNICallIn$JNIFailure");
				if (throwable == NULL) (*env)->FatalError(env, "missing class: vich/bench/JNICallIn$JNIFailure");
				(*env)->ThrowNew(env, throwable, "return value incorrect");
				return;
			}
		}
	}

	for (i = 0; i < loopCount; i++) {
		(*env)->DeleteLocalRef(env, (*env)->CallStaticObjectMethodA(env, clazz, mid, args));
	}

	return ;
}


void JNICALL Java_jit_test_vich_JNIFields_setStaticBoolean(JNIEnv *env, jobject recv, jint loopCount, jboolean value)
{
	jint i;
	static jclass clazz = NULL;
	static jfieldID fid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		fid = (*env)->GetStaticFieldID(env, clazz, "staticBoolean", "Z");

		if (fid == NULL) (*env)->FatalError(env, "Missing field");
		(*env)->SetStaticBooleanField(env, clazz, fid, value);
	}

	for (i = 0; i < loopCount; i++) {
		(*env)->SetStaticBooleanField(env, clazz, fid, value);
	}
}


void JNICALL Java_jit_test_vich_JNIFields_setStaticByte(JNIEnv *env, jobject recv, jint loopCount, jbyte value)
{
	jint i;
	static jclass clazz = NULL;
	static jfieldID fid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		fid = (*env)->GetStaticFieldID(env, clazz, "staticByte", "B");

		if (fid == NULL) (*env)->FatalError(env, "Missing field");
		(*env)->SetStaticByteField(env, clazz, fid, value);
	}

	for (i = 0; i < loopCount; i++) {
		(*env)->SetStaticByteField(env, clazz, fid, value);
	}
}


void JNICALL Java_jit_test_vich_JNIFields_setStaticShort(JNIEnv *env, jobject recv, jint loopCount, jshort value)
{
	jint i;
	static jclass clazz = NULL;
	static jfieldID fid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		fid = (*env)->GetStaticFieldID(env, clazz, "staticShort", "S");

		if (fid == NULL) (*env)->FatalError(env, "Missing field");
		(*env)->SetStaticShortField(env, clazz, fid, value);
	}

	for (i = 0; i < loopCount; i++) {
		(*env)->SetStaticShortField(env, clazz, fid, value);
	}
}


void JNICALL Java_jit_test_vich_JNIFields_setStaticChar(JNIEnv *env, jobject recv, jint loopCount, jchar value)
{
	jint i;
	static jclass clazz = NULL;
	static jfieldID fid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		fid = (*env)->GetStaticFieldID(env, clazz, "staticChar", "C");

		if (fid == NULL) (*env)->FatalError(env, "Missing field");
		(*env)->SetStaticCharField(env, clazz, fid, value);
	}

	for (i = 0; i < loopCount; i++) {
		(*env)->SetStaticCharField(env, clazz, fid, value);
	}
}


void JNICALL Java_jit_test_vich_JNIFields_setStaticInt(JNIEnv *env, jobject recv, jint loopCount, jint value)
{
	jint i;
	static jclass clazz = NULL;
	static jfieldID fid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		fid = (*env)->GetStaticFieldID(env, clazz, "staticInt", "I");

		if (fid == NULL) (*env)->FatalError(env, "Missing field");
		(*env)->SetStaticIntField(env, clazz, fid, value);
	}

	for (i = 0; i < loopCount; i++) {
		(*env)->SetStaticIntField(env, clazz, fid, value);
	}
}


void JNICALL Java_jit_test_vich_JNIFields_setStaticLong(JNIEnv *env, jobject recv, jint loopCount, jlong value)
{
	jint i;
	static jclass clazz = NULL;
	static jfieldID fid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		fid = (*env)->GetStaticFieldID(env, clazz, "staticLong", "J");

		if (fid == NULL) (*env)->FatalError(env, "Missing field");
		(*env)->SetStaticLongField(env, clazz, fid, value);
	}

	for (i = 0; i < loopCount; i++) {
		(*env)->SetStaticLongField(env, clazz, fid, value);
	}
}


void JNICALL Java_jit_test_vich_JNIFields_setStaticDouble(JNIEnv *env, jobject recv, jint loopCount, jdouble value)
{
	jint i;
	static jclass clazz = NULL;
	static jfieldID fid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		fid = (*env)->GetStaticFieldID(env, clazz, "staticDouble", "D");

		if (fid == NULL) (*env)->FatalError(env, "Missing field");
		(*env)->SetStaticDoubleField(env, clazz, fid, value);
	}

	for (i = 0; i < loopCount; i++) {
		(*env)->SetStaticDoubleField(env, clazz, fid, value);
	}
}


void JNICALL Java_jit_test_vich_JNIFields_setStaticFloat(JNIEnv *env, jobject recv, jint loopCount, jfloat value)
{
	jint i;
	static jclass clazz = NULL;
	static jfieldID fid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		fid = (*env)->GetStaticFieldID(env, clazz, "staticFloat", "F");

		if (fid == NULL) (*env)->FatalError(env, "Missing field");
		(*env)->SetStaticFloatField(env, clazz, fid, value);
	}

	for (i = 0; i < loopCount; i++) {
		(*env)->SetStaticFloatField(env, clazz, fid, value);
	}
}


void JNICALL Java_jit_test_vich_JNIFields_setStaticObject(JNIEnv *env, jobject recv, jint loopCount, jobject value)
{
	jint i;
	static jclass clazz = NULL;
	static jfieldID fid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		fid = (*env)->GetStaticFieldID(env, clazz, "staticObject", "Ljava/lang/Object;");

		if (fid == NULL) (*env)->FatalError(env, "Missing field");
		(*env)->SetStaticObjectField(env, clazz, fid, value);
	}

	for (i = 0; i < loopCount; i++) {
		(*env)->SetStaticObjectField(env, clazz, fid, value);
	}
}


void JNICALL Java_jit_test_vich_JNIFields_setInstanceBoolean(JNIEnv *env, jobject recv, jint loopCount, jboolean value)
{
	jint i;
	static jclass clazz = NULL;
	static jfieldID fid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		fid = (*env)->GetFieldID(env, clazz, "instanceBoolean", "Z");

		if (fid == NULL) (*env)->FatalError(env, "Missing field");
		(*env)->SetBooleanField(env, recv, fid, value);
	}

	for (i = 0; i < loopCount; i++) {
		(*env)->SetBooleanField(env, recv, fid, value);
	}
}


void JNICALL Java_jit_test_vich_JNIFields_setInstanceByte(JNIEnv *env, jobject recv, jint loopCount, jbyte value)
{
	jint i;
	static jclass clazz = NULL;
	static jfieldID fid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		fid = (*env)->GetFieldID(env, clazz, "instanceByte", "B");

		if (fid == NULL) (*env)->FatalError(env, "Missing field");
		(*env)->SetByteField(env, recv, fid, value);
	}

	for (i = 0; i < loopCount; i++) {
		(*env)->SetByteField(env, recv, fid, value);
	}
}


void JNICALL Java_jit_test_vich_JNIFields_setInstanceShort(JNIEnv *env, jobject recv, jint loopCount, jshort value)
{
	jint i;
	static jclass clazz = NULL;
	static jfieldID fid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		fid = (*env)->GetFieldID(env, clazz, "instanceShort", "S");

		if (fid == NULL) (*env)->FatalError(env, "Missing field");
		(*env)->SetShortField(env, recv, fid, value);
	}

	for (i = 0; i < loopCount; i++) {
		(*env)->SetShortField(env, recv, fid, value);
	}
}


void JNICALL Java_jit_test_vich_JNIFields_setInstanceChar(JNIEnv *env, jobject recv, jint loopCount, jchar value)
{
	jint i;
	static jclass clazz = NULL;
	static jfieldID fid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		fid = (*env)->GetFieldID(env, clazz, "instanceChar", "C");

		if (fid == NULL) (*env)->FatalError(env, "Missing field");
		(*env)->SetCharField(env, recv, fid, value);
	}

	for (i = 0; i < loopCount; i++) {
		(*env)->SetCharField(env, recv, fid, value);
	}
}


void JNICALL Java_jit_test_vich_JNIFields_setInstanceInt(JNIEnv *env, jobject recv, jint loopCount, jint value)
{
	jint i;
	static jclass clazz = NULL;
	static jfieldID fid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		fid = (*env)->GetFieldID(env, clazz, "instanceInt", "I");

		if (fid == NULL) (*env)->FatalError(env, "Missing field");
		(*env)->SetIntField(env, recv, fid, value);
	}

	for (i = 0; i < loopCount; i++) {
		(*env)->SetIntField(env, recv, fid, value);
	}
}


void JNICALL Java_jit_test_vich_JNIFields_setInstanceLong(JNIEnv *env, jobject recv, jint loopCount, jlong value)
{
	jint i;
	static jclass clazz = NULL;
	static jfieldID fid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		fid = (*env)->GetFieldID(env, clazz, "instanceLong", "J");

		if (fid == NULL) (*env)->FatalError(env, "Missing field");
		(*env)->SetLongField(env, recv, fid, value);
	}

	for (i = 0; i < loopCount; i++) {
		(*env)->SetLongField(env, recv, fid, value);
	}
}


void JNICALL Java_jit_test_vich_JNIFields_setInstanceDouble(JNIEnv *env, jobject recv, jint loopCount, jdouble value)
{
	jint i;
	static jclass clazz = NULL;
	static jfieldID fid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		fid = (*env)->GetFieldID(env, clazz, "instanceDouble", "D");

		if (fid == NULL) (*env)->FatalError(env, "Missing field");
		(*env)->SetDoubleField(env, recv, fid, value);
	}

	for (i = 0; i < loopCount; i++) {
		(*env)->SetDoubleField(env, recv, fid, value);
	}
}


void JNICALL Java_jit_test_vich_JNIFields_setInstanceFloat(JNIEnv *env, jobject recv, jint loopCount, jfloat value)
{
	jint i;
	static jclass clazz = NULL;
	static jfieldID fid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		fid = (*env)->GetFieldID(env, clazz, "instanceFloat", "F");

		if (fid == NULL) (*env)->FatalError(env, "Missing field");
		(*env)->SetFloatField(env, recv, fid, value);
	}

	for (i = 0; i < loopCount; i++) {
		(*env)->SetFloatField(env, recv, fid, value);
	}
}


void JNICALL Java_jit_test_vich_JNIFields_setInstanceObject(JNIEnv *env, jobject recv, jint loopCount, jobject value)
{
	jint i;
	static jclass clazz = NULL;
	static jfieldID fid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		fid = (*env)->GetFieldID(env, clazz, "instanceObject", "Ljava/lang/Object;");

		if (fid == NULL) (*env)->FatalError(env, "Missing field");
		(*env)->SetObjectField(env, recv, fid, value);
	}

	for (i = 0; i < loopCount; i++) {
		(*env)->SetObjectField(env, recv, fid, value);
	}
}


jboolean JNICALL Java_jit_test_vich_JNIFields_getStaticBoolean(JNIEnv *env, jobject recv, jint loopCount)
{
	jboolean answer = 0;
	jint i;
	static jclass clazz = NULL;
	static jfieldID fid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		fid = (*env)->GetStaticFieldID(env, clazz, "staticBoolean", "Z");

		if (fid == NULL) (*env)->FatalError(env, "Missing field");
		answer = (*env)->GetStaticBooleanField(env, clazz, fid);
	}

	for (i = 0; i < loopCount; i++) {
		
		answer = (*env)->GetStaticBooleanField(env, clazz, fid);
	}

	return answer;
}


jbyte JNICALL Java_jit_test_vich_JNIFields_getStaticByte(JNIEnv *env, jobject recv, jint loopCount)
{
	jbyte answer = 0;
	jint i;
	static jclass clazz = NULL;
	static jfieldID fid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		fid = (*env)->GetStaticFieldID(env, clazz, "staticByte", "B");

		if (fid == NULL) (*env)->FatalError(env, "Missing field");
		answer = (*env)->GetStaticByteField(env, clazz, fid);
	}

	for (i = 0; i < loopCount; i++) {
		
		answer = (*env)->GetStaticByteField(env, clazz, fid);
	}

	return answer;
}


jshort JNICALL Java_jit_test_vich_JNIFields_getStaticShort(JNIEnv *env, jobject recv, jint loopCount)
{
	jshort answer = 0;
	jint i;
	static jclass clazz = NULL;
	static jfieldID fid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		fid = (*env)->GetStaticFieldID(env, clazz, "staticShort", "S");

		if (fid == NULL) (*env)->FatalError(env, "Missing field");
		answer = (*env)->GetStaticShortField(env, clazz, fid);
	}

	for (i = 0; i < loopCount; i++) {
		
		answer = (*env)->GetStaticShortField(env, clazz, fid);
	}

	return answer;
}


jchar JNICALL Java_jit_test_vich_JNIFields_getStaticChar(JNIEnv *env, jobject recv, jint loopCount)
{
	jchar answer = 0;
	jint i;
	static jclass clazz = NULL;
	static jfieldID fid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		fid = (*env)->GetStaticFieldID(env, clazz, "staticChar", "C");

		if (fid == NULL) (*env)->FatalError(env, "Missing field");
		answer = (*env)->GetStaticCharField(env, clazz, fid);
	}

	for (i = 0; i < loopCount; i++) {
		
		answer = (*env)->GetStaticCharField(env, clazz, fid);
	}

	return answer;
}


jint JNICALL Java_jit_test_vich_JNIFields_getStaticInt(JNIEnv *env, jobject recv, jint loopCount)
{
	jint answer = 0;
	jint i;
	static jclass clazz = NULL;
	static jfieldID fid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		fid = (*env)->GetStaticFieldID(env, clazz, "staticInt", "I");

		if (fid == NULL) (*env)->FatalError(env, "Missing field");
		answer = (*env)->GetStaticIntField(env, clazz, fid);
	}

	for (i = 0; i < loopCount; i++) {
		
		answer = (*env)->GetStaticIntField(env, clazz, fid);
	}

	return answer;
}


jlong JNICALL Java_jit_test_vich_JNIFields_getStaticLong(JNIEnv *env, jobject recv, jint loopCount)
{
	jlong answer = 0;
	jint i;
	static jclass clazz = NULL;
	static jfieldID fid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		fid = (*env)->GetStaticFieldID(env, clazz, "staticLong", "J");

		if (fid == NULL) (*env)->FatalError(env, "Missing field");
		answer = (*env)->GetStaticLongField(env, clazz, fid);
	}

	for (i = 0; i < loopCount; i++) {
		
		answer = (*env)->GetStaticLongField(env, clazz, fid);
	}

	return answer;
}


jdouble JNICALL Java_jit_test_vich_JNIFields_getStaticDouble(JNIEnv *env, jobject recv, jint loopCount)
{
	jdouble answer = 0;
	jint i;
	static jclass clazz = NULL;
	static jfieldID fid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		fid = (*env)->GetStaticFieldID(env, clazz, "staticDouble", "D");

		if (fid == NULL) (*env)->FatalError(env, "Missing field");
		answer = (*env)->GetStaticDoubleField(env, clazz, fid);
	}

	for (i = 0; i < loopCount; i++) {
		
		answer = (*env)->GetStaticDoubleField(env, clazz, fid);
	}

	return answer;
}


jfloat JNICALL Java_jit_test_vich_JNIFields_getStaticFloat(JNIEnv *env, jobject recv, jint loopCount)
{
	jfloat answer = 0;
	jint i;
	static jclass clazz = NULL;
	static jfieldID fid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		fid = (*env)->GetStaticFieldID(env, clazz, "staticFloat", "F");

		if (fid == NULL) (*env)->FatalError(env, "Missing field");
		answer = (*env)->GetStaticFloatField(env, clazz, fid);
	}

	for (i = 0; i < loopCount; i++) {
		
		answer = (*env)->GetStaticFloatField(env, clazz, fid);
	}

	return answer;
}


jobject JNICALL Java_jit_test_vich_JNIFields_getStaticObject(JNIEnv *env, jobject recv, jint loopCount)
{
	jobject answer = 0;
	jint i;
	static jclass clazz = NULL;
	static jfieldID fid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		fid = (*env)->GetStaticFieldID(env, clazz, "staticObject", "Ljava/lang/Object;");

		if (fid == NULL) (*env)->FatalError(env, "Missing field");
		answer = (*env)->GetStaticObjectField(env, clazz, fid);
	}

	for (i = 0; i < loopCount; i++) {
		if (answer) (*env)->DeleteLocalRef(env, answer);
		answer = (*env)->GetStaticObjectField(env, clazz, fid);
	}

	return answer;
}


jboolean JNICALL Java_jit_test_vich_JNIFields_getInstanceBoolean(JNIEnv *env, jobject recv, jint loopCount)
{
	jboolean answer = 0;
	jint i;
	static jclass clazz = NULL;
	static jfieldID fid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		fid = (*env)->GetFieldID(env, clazz, "instanceBoolean", "Z");

		if (fid == NULL) (*env)->FatalError(env, "Missing field");
		answer = (*env)->GetBooleanField(env, recv, fid);
	}

	for (i = 0; i < loopCount; i++) {
		
		answer = (*env)->GetBooleanField(env, recv, fid);
	}

	return answer;
}


jbyte JNICALL Java_jit_test_vich_JNIFields_getInstanceByte(JNIEnv *env, jobject recv, jint loopCount)
{
	jbyte answer = 0;
	jint i;
	static jclass clazz = NULL;
	static jfieldID fid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		fid = (*env)->GetFieldID(env, clazz, "instanceByte", "B");

		if (fid == NULL) (*env)->FatalError(env, "Missing field");
		answer = (*env)->GetByteField(env, recv, fid);
	}

	for (i = 0; i < loopCount; i++) {
		
		answer = (*env)->GetByteField(env, recv, fid);
	}

	return answer;
}


jshort JNICALL Java_jit_test_vich_JNIFields_getInstanceShort(JNIEnv *env, jobject recv, jint loopCount)
{
	jshort answer = 0;
	jint i;
	static jclass clazz = NULL;
	static jfieldID fid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		fid = (*env)->GetFieldID(env, clazz, "instanceShort", "S");

		if (fid == NULL) (*env)->FatalError(env, "Missing field");
		answer = (*env)->GetShortField(env, recv, fid);
	}

	for (i = 0; i < loopCount; i++) {
		
		answer = (*env)->GetShortField(env, recv, fid);
	}

	return answer;
}


jchar JNICALL Java_jit_test_vich_JNIFields_getInstanceChar(JNIEnv *env, jobject recv, jint loopCount)
{
	jchar answer = 0;
	jint i;
	static jclass clazz = NULL;
	static jfieldID fid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		fid = (*env)->GetFieldID(env, clazz, "instanceChar", "C");

		if (fid == NULL) (*env)->FatalError(env, "Missing field");
		answer = (*env)->GetCharField(env, recv, fid);
	}

	for (i = 0; i < loopCount; i++) {
		
		answer = (*env)->GetCharField(env, recv, fid);
	}

	return answer;
}


jint JNICALL Java_jit_test_vich_JNIFields_getInstanceInt(JNIEnv *env, jobject recv, jint loopCount)
{
	jint answer = 0;
	jint i;
	static jclass clazz = NULL;
	static jfieldID fid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		fid = (*env)->GetFieldID(env, clazz, "instanceInt", "I");

		if (fid == NULL) (*env)->FatalError(env, "Missing field");
		answer = (*env)->GetIntField(env, recv, fid);
	}

	for (i = 0; i < loopCount; i++) {
		
		answer = (*env)->GetIntField(env, recv, fid);
	}

	return answer;
}


jlong JNICALL Java_jit_test_vich_JNIFields_getInstanceLong(JNIEnv *env, jobject recv, jint loopCount)
{
	jlong answer = 0;
	jint i;
	static jclass clazz = NULL;
	static jfieldID fid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		fid = (*env)->GetFieldID(env, clazz, "instanceLong", "J");

		if (fid == NULL) (*env)->FatalError(env, "Missing field");
		answer = (*env)->GetLongField(env, recv, fid);
	}

	for (i = 0; i < loopCount; i++) {
		
		answer = (*env)->GetLongField(env, recv, fid);
	}

	return answer;
}


jdouble JNICALL Java_jit_test_vich_JNIFields_getInstanceDouble(JNIEnv *env, jobject recv, jint loopCount)
{
	jdouble answer = 0;
	jint i;
	static jclass clazz = NULL;
	static jfieldID fid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		fid = (*env)->GetFieldID(env, clazz, "instanceDouble", "D");

		if (fid == NULL) (*env)->FatalError(env, "Missing field");
		answer = (*env)->GetDoubleField(env, recv, fid);
	}

	for (i = 0; i < loopCount; i++) {
		
		answer = (*env)->GetDoubleField(env, recv, fid);
	}

	return answer;
}


jfloat JNICALL Java_jit_test_vich_JNIFields_getInstanceFloat(JNIEnv *env, jobject recv, jint loopCount)
{
	jfloat answer = 0;
	jint i;
	static jclass clazz = NULL;
	static jfieldID fid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		fid = (*env)->GetFieldID(env, clazz, "instanceFloat", "F");

		if (fid == NULL) (*env)->FatalError(env, "Missing field");
		answer = (*env)->GetFloatField(env, recv, fid);
	}

	for (i = 0; i < loopCount; i++) {
		
		answer = (*env)->GetFloatField(env, recv, fid);
	}

	return answer;
}


jobject JNICALL Java_jit_test_vich_JNIFields_getInstanceObject(JNIEnv *env, jobject recv, jint loopCount)
{
	jobject answer = 0;
	jint i;
	static jclass clazz = NULL;
	static jfieldID fid = NULL;

	if (clazz == NULL) {
		clazz = (*env)->NewGlobalRef(env, (*env)->GetObjectClass(env, recv));
		fid = (*env)->GetFieldID(env, clazz, "instanceObject", "Ljava/lang/Object;");

		if (fid == NULL) (*env)->FatalError(env, "Missing field");
		answer = (*env)->GetObjectField(env, recv, fid);
	}

	for (i = 0; i < loopCount; i++) {
		if (answer) (*env)->DeleteLocalRef(env, answer);
		answer = (*env)->GetObjectField(env, recv, fid);
	}

	return answer;
}


void JNICALL Java_jit_test_vich_JNIArray_getIntArrayElements(JNIEnv *env, jobject obj, jintArray array, jint loopCount)
{
	jint i;
	jint *elems;

	for (i = 0; i < loopCount; i++)
	{	
		elems = (*env)->GetIntArrayElements(env, array, NULL);
		if (!elems) {
			jthrowable throwable = (*env)->ExceptionOccurred(env);
			if (!throwable) (*env)->FatalError(env, "GetIntArrayElements failed without exception");
			(*env)->Throw(env, throwable);
			return;
		}
		elems[0] += 1; /* suppress jnichk warnings */
		(*env)->ReleaseIntArrayElements(env, array, elems, JNI_ABORT);
	}
	return;
}


void JNICALL Java_jit_test_vich_JNIArray_getByteArrayElements(JNIEnv *env, jobject obj, jbyteArray array, jint loopCount)
{
	jint i;
	jbyte *elems;

	for (i = 0; i < loopCount; i++)
	{	
		elems = (*env)->GetByteArrayElements(env, array, NULL);
		if (!elems) {
			jthrowable throwable = (*env)->ExceptionOccurred(env);
			if (!throwable) (*env)->FatalError(env, "GetByteArrayElements failed without exception");
			(*env)->Throw(env, throwable);
			return;
		}

		elems[0] += 1; /* suppress jnichk warnings */
		(*env)->ReleaseByteArrayElements(env, array, elems, JNI_ABORT);
	}
	return;
}


void JNICALL Java_jit_test_vich_JNIArray_getLongArrayElements(JNIEnv *env, jobject obj, jlongArray array, jint loopCount)
{
	jint i;
	jlong *elems;

	for (i = 0; i < loopCount; i++)
	{	
		elems = (*env)->GetLongArrayElements(env, array, NULL);
		if (!elems) {
			jthrowable throwable = (*env)->ExceptionOccurred(env);
			if (!throwable) (*env)->FatalError(env, "GetLongArrayElements failed without exception");
			(*env)->Throw(env, throwable);
			return;
		}
		elems[0] += 1; /* suppress jnichk warnings */
		(*env)->ReleaseLongArrayElements(env, array, elems, JNI_ABORT);
	}
	return;
}


void JNICALL Java_jit_test_vich_JNIArray_getFloatArrayElements(JNIEnv *env, jobject obj, jfloatArray array, jint loopCount)
{
	jint i;
	jfloat *elems;

	for (i = 0; i < loopCount; i++)
	{	
		elems = (*env)->GetFloatArrayElements(env, array, NULL);
		if (!elems) {
			jthrowable throwable = (*env)->ExceptionOccurred(env);
			if (!throwable) (*env)->FatalError(env, "GetFloatArrayElements failed without exception");
			(*env)->Throw(env, throwable);
			return;
		}
		elems[0] += 1.0; /* suppress jnichk warnings */
		(*env)->ReleaseFloatArrayElements(env, array, elems, JNI_ABORT);
	}
	return;
}


void JNICALL Java_jit_test_vich_JNIArray_getDoubleArrayElements(JNIEnv *env, jobject obj, jdoubleArray array, jint loopCount)
{
	jint i;
	jdouble *elems;

	for (i = 0; i < loopCount; i++)
	{	
		elems = (*env)->GetDoubleArrayElements(env, array, NULL);
		if (!elems) {
			jthrowable throwable = (*env)->ExceptionOccurred(env);
			if (!throwable) (*env)->FatalError(env, "GetDoubleArrayElements failed without exception");
			(*env)->Throw(env, throwable);
			return;
		}
		elems[0] += 1.0; /* suppress jnichk warnings */
		(*env)->ReleaseDoubleArrayElements(env, array, elems, JNI_ABORT);
	}
	return;
}


void JNICALL Java_jit_test_vich_JNIArray_getPrimitiveArrayCritical(JNIEnv *env, jobject obj, jintArray array, jint loopCount)
{
	jint i;
	jint *elems;
	for (i = 0; i < loopCount; i++)
	{	
		elems = (*env)->GetPrimitiveArrayCritical(env, array, NULL);
		if (!elems) {
			jthrowable throwable = (*env)->ExceptionOccurred(env);
			if (!throwable) (*env)->FatalError(env, "GetPrimitiveArrayCritical failed without exception");
			(*env)->Throw(env, throwable);
			return;
		}
		(*env)->ReleasePrimitiveArrayCritical(env, array, elems, JNI_ABORT);
	}
	return;
}


void JNICALL Java_jit_test_vich_JNILocalRef_localReference8(JNIEnv *env, jobject obj, jobject o1, jobject o2, jobject o3, jobject o4, jobject o5, jobject o6, jobject o7, jobject o8, jint loopCount)
{
	jint i;
	jobject obj1, obj2, obj3, obj4, obj5, obj6, obj7, obj8;
	jobject objb1, objb2, objb3, objb4, objb5, objb6, objb7, objb8;

	for (i = 0; i < loopCount; i++)
	{	
		obj1 = (*env)->NewLocalRef(env, o1);
		obj2 = (*env)->NewLocalRef(env, o2);
		obj3 = (*env)->NewLocalRef(env, o3);
		obj4 = (*env)->NewLocalRef(env, o4);
		obj5 = (*env)->NewLocalRef(env, o5);
		obj6 = (*env)->NewLocalRef(env, o6);
		obj7 = (*env)->NewLocalRef(env, o7);
		obj8 = (*env)->NewLocalRef(env, o8);
		objb1 = (*env)->NewLocalRef(env, o1);
		objb2 = (*env)->NewLocalRef(env, o2);
		objb3 = (*env)->NewLocalRef(env, o3);
		objb4 = (*env)->NewLocalRef(env, o4);
		objb5 = (*env)->NewLocalRef(env, o5);
		objb6 = (*env)->NewLocalRef(env, o6);
		objb7 = (*env)->NewLocalRef(env, o7);
		objb8 = (*env)->NewLocalRef(env, o8);
	
		(*env)->DeleteLocalRef(env, obj1);
		(*env)->DeleteLocalRef(env, obj2);
		(*env)->DeleteLocalRef(env, obj3);
		(*env)->DeleteLocalRef(env, obj4);
		(*env)->DeleteLocalRef(env, obj5);
		(*env)->DeleteLocalRef(env, obj6);
		(*env)->DeleteLocalRef(env, obj7);
		(*env)->DeleteLocalRef(env, obj8);

		obj1 = (*env)->NewLocalRef(env, o1);
		obj2 = (*env)->NewLocalRef(env, o2);
		obj3 = (*env)->NewLocalRef(env, o3);
		obj4 = (*env)->NewLocalRef(env, o4);
		obj5 = (*env)->NewLocalRef(env, o5);
		obj6 = (*env)->NewLocalRef(env, o6);
		obj7 = (*env)->NewLocalRef(env, o7);
		obj8 = (*env)->NewLocalRef(env, o8);

		(*env)->DeleteLocalRef(env, obj1);
		(*env)->DeleteLocalRef(env, obj2);
		(*env)->DeleteLocalRef(env, obj3);
		(*env)->DeleteLocalRef(env, obj4);
		(*env)->DeleteLocalRef(env, obj5);
		(*env)->DeleteLocalRef(env, obj6);
		(*env)->DeleteLocalRef(env, obj7);
		(*env)->DeleteLocalRef(env, obj8);

		(*env)->DeleteLocalRef(env, objb1);
		(*env)->DeleteLocalRef(env, objb2);
		(*env)->DeleteLocalRef(env, objb3);
		(*env)->DeleteLocalRef(env, objb4);
		(*env)->DeleteLocalRef(env, objb5);
		(*env)->DeleteLocalRef(env, objb6);
		(*env)->DeleteLocalRef(env, objb7);
		(*env)->DeleteLocalRef(env, objb8);
	}
	return;
}


void JNICALL Java_jit_test_vich_JNILocalRef_localReference32(JNIEnv *env, jobject obj, jobject o1, jobject o2, jobject o3, jobject o4, jobject o5, jobject o6, jobject o7, jobject o8, jobject o9, jobject o10, jobject o11, jobject o12, jobject o13, jobject o14, jobject o15, jobject o16, jobject o17, jobject o18, jobject o19, jobject o20, jobject o21, jobject o22, jobject o23, jobject o24, jobject o25, jobject o26, jobject o27, jobject o28, jobject o29, jobject o30, jobject o31, jobject o32, jint loopCount)
{
	jint i;
	jobject obj1, obj2, obj3, obj4, obj5, obj6, obj7, obj8,  obj9, obj10, obj11, obj12, obj13, obj14, obj15, obj16,  obj17, obj18, obj19, obj20, obj21, obj22, obj23, obj24,  obj25, obj26, obj27, obj28, obj29, obj30, obj31, obj32;
	jobject objb1, objb2, objb3, objb4, objb5, objb6, objb7, objb8,  objb9, objb10, objb11, objb12, objb13, objb14, objb15, objb16,  objb17, objb18, objb19, objb20, objb21, objb22, objb23, objb24,  objb25, objb26, objb27, objb28, objb29, objb30, objb31, objb32;

	if ((*env)->EnsureLocalCapacity(env, 32)) {
		return;
	}

	for (i = 0; i < loopCount; i++)
	{	
		obj1 = (*env)->NewLocalRef(env, o1);
		obj2 = (*env)->NewLocalRef(env, o2);
		obj3 = (*env)->NewLocalRef(env, o3);
		obj4 = (*env)->NewLocalRef(env, o4);
		obj5 = (*env)->NewLocalRef(env, o5);
		obj6 = (*env)->NewLocalRef(env, o6);
		obj7 = (*env)->NewLocalRef(env, o7);
		obj8 = (*env)->NewLocalRef(env, o8);
		obj9 = (*env)->NewLocalRef(env, o9);
		obj10 = (*env)->NewLocalRef(env, o10);
		obj11 = (*env)->NewLocalRef(env, o11);
		obj12 = (*env)->NewLocalRef(env, o12);
		obj13 = (*env)->NewLocalRef(env, o13);
		obj14 = (*env)->NewLocalRef(env, o14);
		obj15 = (*env)->NewLocalRef(env, o15);
		obj16 = (*env)->NewLocalRef(env, o16);
		obj17 = (*env)->NewLocalRef(env, o17);
		obj18 = (*env)->NewLocalRef(env, o18);
		obj19 = (*env)->NewLocalRef(env, o19);
		obj20 = (*env)->NewLocalRef(env, o20);
		obj21 = (*env)->NewLocalRef(env, o21);
		obj22 = (*env)->NewLocalRef(env, o22);
		obj23 = (*env)->NewLocalRef(env, o23);
		obj24 = (*env)->NewLocalRef(env, o24);
		obj25 = (*env)->NewLocalRef(env, o25);
		obj26 = (*env)->NewLocalRef(env, o26);
		obj27 = (*env)->NewLocalRef(env, o27);
		obj28 = (*env)->NewLocalRef(env, o28);
		obj29 = (*env)->NewLocalRef(env, o29);
		obj30 = (*env)->NewLocalRef(env, o30);
		obj31 = (*env)->NewLocalRef(env, o31);
		obj32 = (*env)->NewLocalRef(env, o32);

		objb1 = (*env)->NewLocalRef(env, o1);
		objb2 = (*env)->NewLocalRef(env, o2);
		objb3 = (*env)->NewLocalRef(env, o3);
		objb4 = (*env)->NewLocalRef(env, o4);
		objb5 = (*env)->NewLocalRef(env, o5);
		objb6 = (*env)->NewLocalRef(env, o6);
		objb7 = (*env)->NewLocalRef(env, o7);
		objb8 = (*env)->NewLocalRef(env, o8);
		objb9 = (*env)->NewLocalRef(env, o9);
		objb10 = (*env)->NewLocalRef(env, o10);
		objb11 = (*env)->NewLocalRef(env, o11);
		objb12 = (*env)->NewLocalRef(env, o12);
		objb13 = (*env)->NewLocalRef(env, o13);
		objb14 = (*env)->NewLocalRef(env, o14);
		objb15 = (*env)->NewLocalRef(env, o15);
		objb16 = (*env)->NewLocalRef(env, o16);
		objb17 = (*env)->NewLocalRef(env, o17);
		objb18 = (*env)->NewLocalRef(env, o18);
		objb19 = (*env)->NewLocalRef(env, o19);
		objb20 = (*env)->NewLocalRef(env, o20);
		objb21 = (*env)->NewLocalRef(env, o21);
		objb22 = (*env)->NewLocalRef(env, o22);
		objb23 = (*env)->NewLocalRef(env, o23);
		objb24 = (*env)->NewLocalRef(env, o24);
		objb25 = (*env)->NewLocalRef(env, o25);
		objb26 = (*env)->NewLocalRef(env, o26);
		objb27 = (*env)->NewLocalRef(env, o27);
		objb28 = (*env)->NewLocalRef(env, o28);
		objb29 = (*env)->NewLocalRef(env, o29);
		objb30 = (*env)->NewLocalRef(env, o30);
		objb31 = (*env)->NewLocalRef(env, o31);
		objb32 = (*env)->NewLocalRef(env, o32);
	
		(*env)->DeleteLocalRef(env, objb1);
		(*env)->DeleteLocalRef(env, objb2);
		(*env)->DeleteLocalRef(env, objb3);
		(*env)->DeleteLocalRef(env, objb4);
		(*env)->DeleteLocalRef(env, objb5);
		(*env)->DeleteLocalRef(env, objb6);
		(*env)->DeleteLocalRef(env, objb7);
		(*env)->DeleteLocalRef(env, objb8);
		(*env)->DeleteLocalRef(env, objb9);
		(*env)->DeleteLocalRef(env, objb10);
		(*env)->DeleteLocalRef(env, objb11);
		(*env)->DeleteLocalRef(env, objb12);
		(*env)->DeleteLocalRef(env, objb13);
		(*env)->DeleteLocalRef(env, objb14);
		(*env)->DeleteLocalRef(env, objb15);
		(*env)->DeleteLocalRef(env, objb16);
		(*env)->DeleteLocalRef(env, objb17);
		(*env)->DeleteLocalRef(env, objb18);
		(*env)->DeleteLocalRef(env, objb19);
		(*env)->DeleteLocalRef(env, objb20);
		(*env)->DeleteLocalRef(env, objb21);
		(*env)->DeleteLocalRef(env, objb22);
		(*env)->DeleteLocalRef(env, objb23);
		(*env)->DeleteLocalRef(env, objb24);
		(*env)->DeleteLocalRef(env, objb25);
		(*env)->DeleteLocalRef(env, objb26);
		(*env)->DeleteLocalRef(env, objb27);
		(*env)->DeleteLocalRef(env, objb28);
		(*env)->DeleteLocalRef(env, objb29);
		(*env)->DeleteLocalRef(env, objb30);
		(*env)->DeleteLocalRef(env, objb31);
		(*env)->DeleteLocalRef(env, objb32);		

		(*env)->DeleteLocalRef(env, obj1);
		(*env)->DeleteLocalRef(env, obj2);
		(*env)->DeleteLocalRef(env, obj3);
		(*env)->DeleteLocalRef(env, obj4);
		(*env)->DeleteLocalRef(env, obj5);
		(*env)->DeleteLocalRef(env, obj6);
		(*env)->DeleteLocalRef(env, obj7);
		(*env)->DeleteLocalRef(env, obj8);
		(*env)->DeleteLocalRef(env, obj9);
		(*env)->DeleteLocalRef(env, obj10);
		(*env)->DeleteLocalRef(env, obj11);
		(*env)->DeleteLocalRef(env, obj12);
		(*env)->DeleteLocalRef(env, obj13);
		(*env)->DeleteLocalRef(env, obj14);
		(*env)->DeleteLocalRef(env, obj15);
		(*env)->DeleteLocalRef(env, obj16);
		(*env)->DeleteLocalRef(env, obj17);
		(*env)->DeleteLocalRef(env, obj18);
		(*env)->DeleteLocalRef(env, obj19);
		(*env)->DeleteLocalRef(env, obj20);
		(*env)->DeleteLocalRef(env, obj21);
		(*env)->DeleteLocalRef(env, obj22);
		(*env)->DeleteLocalRef(env, obj23);
		(*env)->DeleteLocalRef(env, obj24);
		(*env)->DeleteLocalRef(env, obj25);
		(*env)->DeleteLocalRef(env, obj26);
		(*env)->DeleteLocalRef(env, obj27);
		(*env)->DeleteLocalRef(env, obj28);
		(*env)->DeleteLocalRef(env, obj29);
		(*env)->DeleteLocalRef(env, obj30);
		(*env)->DeleteLocalRef(env, obj31);
		(*env)->DeleteLocalRef(env, obj32);
	}
	return;
}


void JNICALL Java_jit_test_vich_JNIObjectArray_getObjectArrayElement(JNIEnv *env, jobject obj, jobjectArray array, jobjectArray blankArray, jint arraySize, jint loopCount)
{
	jint i, j;

#if 0
	/* hack to force the local refs to overflow before calling EnsureLocalCapacity. This tests a different path through the function */
	for (i = 0; i < 20; i++) {
		(*env)->GetObjectArrayElement(env, array, i);
	}
#endif 

	if ((*env)->EnsureLocalCapacity(env, loopCount * arraySize)) {
		return;
	}

	for (i = 0; i < loopCount; i++)
	{	
		for (j = 0; j < arraySize; j++)
		{
			(*env)->SetObjectArrayElement(env, blankArray, j, (*env)->GetObjectArrayElement(env, array, j));
		}
	}
	return;
}



