/*******************************************************************************
 * Copyright IBM Corp. and others 2001
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution and
 * is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 *******************************************************************************/
#ifndef HEAPITERATORAPIROOTITERATOR_HPP_
#define HEAPITERATORAPIROOTITERATOR_HPP_

#include "HeapRootScanner.hpp"
#include "HeapIteratorAPI.h"

class HeapIteratorAPI_RootIterator : public MM_HeapRootScanner
{
private:
	rootIteratorCallBackFunc _func;
	UDATA _flags;
	void *_userData;
	
public:
	HeapIteratorAPI_RootIterator(J9JavaVM* javaVM, rootIteratorCallBackFunc callBackFunc, UDATA flags, void *userData ) :
		MM_HeapRootScanner(javaVM),
		_func(callBackFunc),
		_flags(flags),
		_userData(userData)
	{
		_typeId = __FUNCTION__;
	}
	
	void scanAllSlots();
	
	virtual void doSlot(J9Object** slotPtr);	
	virtual void doClass(J9Class *clazz);
	virtual void doObject(J9Object* slotPtr);
};

#endif /*HEAPITERATORAPIROOTITERATOR_HPP_*/

