/*[INCLUDE-IF Sidecar18-SE]*/
/*
 * Copyright IBM Corp. and others 2007
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution and
 * is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.dtfj.java.javacore;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.java.JavaVMOption;

/**
 * A javacore-based implementation of DTFJ JavaVMOption. Both the option string
 * and the extraInfo pointer value are available in the ENVINFO section of the
 * javacore, e.g.
 *         2CIUSERARG   _port_library 0x002A04F8
 *
 * @see com.ibm.dtfj.java.JavaRuntime
 */
public class JCJavaVMOption implements JavaVMOption {

	private String fOptionString;
	private ImagePointer fExtraInfo;

	public JCJavaVMOption(String optionString, ImagePointer extraInfo)
					throws JCInvalidArgumentsException {

		if (optionString == null) {
			throw new JCInvalidArgumentsException("Must pass a valid option string");
		}
		fOptionString = optionString;
		fExtraInfo = extraInfo;
	}

	public String getOptionString() throws DataUnavailable, CorruptDataException {
		return fOptionString;
	}

	public ImagePointer getExtraInfo() throws DataUnavailable, CorruptDataException {
		return fExtraInfo;
	}

}
