<!--
* Copyright IBM Corp. and others 2017
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which accompanies this distribution and is available at
* https://www.eclipse.org/legal/epl-2.0/ or the Apache
* License, Version 2.0 which accompanies this distribution and
* is available at https://www.apache.org/licenses/LICENSE-2.0.
*
* This Source Code may also be made available under the
* following Secondary Licenses when the conditions for such
* availability set forth in the Eclipse Public License, v. 2.0
* are satisfied: GNU General Public License, version 2 with
* the GNU Classpath Exception [1] and GNU General Public
* License, version 2 with the OpenJDK Assembly Exception [2].
*
* [1] https://www.gnu.org/software/classpath/license.html
* [2] https://openjdk.org/legal/assembly-exception.html
*
* SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
-->

# Eclipse OpenJ9 version 0.9.0 release notes

These release notes support the [Eclipse OpenJ9 0.9.0 release plan](https://projects.eclipse.org/projects/technology.openj9/releases/0.9.0/plan).



## Binaries and supported environments

The following additional OpenJDK binaries that contain the OpenJ9 VM are now available from the AdoptOpenJDK community:

- [OpenJDK version 10](https://adoptopenjdk.net/archive.html?variant=openjdk10&jvmVariant=openj9)
- [OpenJDK version 8 32-bit Windows](https://adoptopenjdk.net/archive.html?variant=openjdk8&jvmVariant=openj9)
- [OpenJDK version 8 x86-64 Linux (non-compressed references VM for large heaps)](https://adoptopenjdk.net/nightly.html?variant=openjdk8&jvmVariant=openj9)

Builds are tested against the OpenJ9 functional verification (FV) test suite, the OpenJDK test suites, and additional tests at AdoptOpenJDK.
Not all tests are complete for AIX and Windows platforms.

For a full OpenJ9 support statement, see [Supported environments](https://eclipse.org/openj9/docs/openj9_support/index.html).


## Notable changes in this release

The following table covers notable changes in v0.9.0. Further information about these changes can be found in the [user documentation](https://eclipse.dev/openj9/docs/version0.9/).

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1"><thead align="left">
<tr valign="bottom">
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Platform</th>
<th valign="bottom">Impact</th>
</tr>
</thead>
<tbody>
<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/1288">#1288</a></td>
<td valign="top"><code>SharedClassCacheInfo</code> no longer contains a <code>JVMLEVEL</code> constant</td>
<td valign="top">OpenJDK10 and later: All platforms</td>
<td valign="top"><code>SharedClassCacheInfo.getCacheJVMLevel()</code> used to return the <code>JVMLEVEL</code> constant that maps to a Java version number, for example <code>JVMLEVEL_JAVA8</code>. This call now returns only the Java version number, for example <code>10</code> for Java 10.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/1370">#1370</a>
<!-- (<a href="https://openjdk.org/jeps/318">JEP318</a>) --></td>
<td valign="top">New <code>nogc</code> GC policy</td>
<td valign="top">All platforms</td>
<td valign="top">Under this policy, no memory is reclaimed through garbage collection. The Java object heap is expanded until an <code>OutOfMemory</code> error is generated and the VM shuts down.<br/>Enable this policy with the <b>-Xgcpolicy:nogc</b> or <b>-XX:+UseNoGC</b> options.<br/>You might use this mode for testing or for short-lived applications. </td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/378">#378</a></td>
<td valign="top">DDR support is now available</td>
<td valign="top">Linux, Windows</td>
<td valign="top">Ability to diagnose problems with the VM, garbage collector, or JIT.</td>
</tr>
<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/1699">#1699</a></td>
<td valign="top">Specify heap limits as a percentage of total memory</td>
<td valign="top">All platforms</td>
<td valign="top">Ability to easily set heap limits with the <b>-XX:MaxRAMPercentage</b> and <b>-XX:InitialRAMPercentage</b> options instead of statically setting them with the <b>-Xmx</b> and <b>-Xms</b> options.</td>
</tr>
<!-- Remove? Confirm.<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/1776">#1776</a></td>
<td valign="top">Extra page of memory no longer required when specifying an object heap size that is a multiple of the page size</td>
<td valign="top">Linux on Z and z/OS</td>
<td valign="top">This change avoids wasting memory or calculating a heap size that is 16 bytes less than the page size.</td>
</tr>-->
<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/1668">#1668</a></td>
<td valign="top">Idle tuning feature enabled</td>
<td valign="top">Linux on Z, Linux on Power systems</td>
<td valign="top">In addition to the support already available, there is the ability to maintain a minimal memory footprint during the life time of an application. See:<br/>
<b>-XX:[+|-]IdleTuningCompactOnIdle</b>,<br/>
<b>-XX:[+|-]IdleTuningGcOnIdle</b>,<br/>
<b>-XX:IdleTuningMinIdleWaitTime</b>, and<br/>
<b>-XX:IdleTuningMinFreeHeapOnIdle</b>
</td>
</tr>
<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/1517">#1517</a></td>
<td valign="top">Changes to the default Java heap size for applications that run inside a container</td>
<td valign="top">Linux</td>
<td valign="top">By default, 75% of the physical memory is allocated for the maximum Java heap setting when the <b>-XX:+UseContainerSupport</b> option is set.</td>
</tr>
<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/1500">#1500</a></td>
<td valign="top">Support for nested jar files</td>
<td valign="top">All platforms</td>
<td valign="top">Improvements to the <code>com.ibm.oti.shared</code> API for manipulating nested jar files, such as used by Spring.</td>
</tr>
<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/1786">#1786</a></td>
<td valign="top">Changes to OpenJ9 <code>java.lang.String</code> class and use of OpenJDK <code>StringBuffer</code> and <code>StringBuilder</code></td>
<td valign="top">OpenJDK 9+, all platforms</td>
<td valign="top">To match the behavior of OpenJDK, <code>java.lang.String</code> no longer has a count field, which changes the way that <code>String.subString()</code> works compared to Java 8. Similarly <code>StringBuffer</code> and <code>StringBuilder</code> do not share the value array with any <code>String</code> created by <code>toString()</code>.</td>
</tr>

<tr><td valign="top">
<a href="https://github.com/eclipse-openj9/openj9/issues/1603">#1603</a>,
<a href="https://github.com/eclipse-openj9/openj9/issues/1642">#1642</a>,
<a href="https://github.com//eclipse-omr/omr/issues/2494">eclipse-omr/omr#2494</a>,
<a href="https://github.com//eclipse-omr/omr/issues/2524">eclipse-omr/omr#2524</a>
</td>
<td valign="top">Full support for shutdown signals</td>
<td valign="top">All Linux variants, AIX</td>
<td valign="top">For shutdown signals (<code>SIGINT</code>, <code>SIGTERM</code> and <code>SIGHUP</code>), a Java signal handler can be registered. The default Java shutdown handler is properly registered for shutdown signals. Similarly, a Java signal handler can be registered for <code>SIGCONT</code>.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/1816">#1816</a></td>
<td valign="top">Temporary solution to support shutdown signal handlers on Windows</td>
<td valign="top">Windows</td>
<td valign="top">A native shutdown handler is registered for shutdown signals (<code>Ctrl+C</code>, <code>SIGINT</code> and <code>SIGTERM</code>). A shutdown handler is responsible for invoking <code>java.lang.Shutdown.exit</code>.</td>
</tr>
</table>


## Known Issues

The v0.9.0 release contains the following known issues and limitations:

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1">
<thead align="left">
<tr valign="bottom">
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Platform</th>
<th valign="bottom">Impact</th>
<th valign="bottom">Workaround</th>
</tr>
</thead>
<tbody>
<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/378">#378</a></td>
<td valign="top">DDR support</td>
<td valign="top">AIX</td>
<td valign="top">Inability to diagnose problems with the VM, garbage collector, or JIT.</td>
<td valign="top">None</td>
</tr>

<!--
<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/54">#54</a></td>
<td valign="top">Signal handling</td>
<td valign="top">All platforms</td>
<td valign="top">Some signals not being handled correctly by the VM.</td>
<td valign="top">None</td>
</tr>
-->

<tr><td valign="top"><a href="https://github.com/ibmruntimes/openj9-openjdk-jdk8/issues/54">#54</a></td>
<td valign="top">Signal handling</td>
<td valign="top">All platforms</td>
<td valign="top">Currently, shutdown signals (<code>SIGINT</code>, <code>SIGHUP</code> and <code>SIGTERM</code>) and <code>SIGCONT</code> are fully supported on Unix platforms (pLinux, zLinux, xLinux, AIX and zOS). Full support for shutdown signals is pending on Windows; signal handlers cannot be registered by using <code>sun.misc.Signal</code> or <code>dk.internal.misc.Signal</code>. Also, support for other POSIX signals is pending. See <code>SunMiscSignalTest.java</code> for the list of signals that need to be supported.</td>
<td valign="top">None</td>
</tr>

<!--
<tr><td valign="top"><a href="https://github.com/ibmruntimes/openj9-openjdk-jdk8/issues/1984">#1984</a></td>
<td valign="top">Incorrect old signal handler</td>
<td valign="top">All platforms</td>
<td valign="top"><code>sun.misc.Signal.handle(...)</code> returns an incorrect old signal handler. The custom signal handler in Apache Kafka reuses the old signal handler returned by <code>sun.misc.Signal.handle(...)</code> but because the old handler is incorrect, the custom signal handler in Apache Kafka malfunctions.</td>
<td valign="top">The custom handlers reuse the JVM default shutdown handler. Avoid registering a custom signal handler for shutdown signals so that the default shutdown handler is properly invoked. Then, Apache Kafka will shutdown properly while invoking the shutdown hooks.</td>
</tr>
-->

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/479">#479</a></td>
<td valign="top">Non-compressed references VM builds not available</td>
<td valign="top">AIX, Windows, Linux on Z, Linux on Power</td>
<td valign="top">Heaps larger than 57GB are not supported.</td>
<td valign="top">Manual builds are possible by following our <a href="https://github.com/eclipse-openj9/openj9/blob/master/buildenv/Build_Instructions_V8.md">detailed build instructions</a>.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/1938">#1938</a></td>
<td valign="top">Default shared classes cache size (16MB) is too small on Java 8 64-bit binaries.</td>
<td valign="top">All platforms</td>
<td valign="top">Poorer performance for applications that could benefit from a larger cache size.</td>
<td valign="top">Manually set the shared cache size to at least 60 MB when you start your application (<code>-Xscmx60m</code>).</td>
</tr>

<!--
<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/1252">#1252</a></td>
<td valign="top">File <code>ibmjvmti.h</code> not found in OpenJ9 JDK</td>
<td valign="top">All platforms</td>
<td valign="top">JVMTI extensions cannot be compiled.</td>
<td valign="top">None</td>
</tr>
<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/1252">#1252</a></td>
<td valign="top">GPU acceleration with <code>java.util.Array.sort()</code> is not supported</td>
<td valign="top">Linux and Windows platforms</td>
<td valign="top">GPU acceleration on <code>sort()</code> operations is not available.</td>
<td valign="top">None !-- , although <code>com.ibm.gpu.Maths</code> can be used directly. -- </td>
</tr>
-->
<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/897">#897</a></td>
<td valign="top">Javadoc not building some OpenJ9 extensions.</td>
<td valign="top">All platforms</td>
<td valign="top">Some API documentation is missing in the <code>build/&lt;platform&gt;/docs</code> directory.</td>
<td valign="top">None</td>
</tr>
<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/898">#898</a></td>
<td valign="top">Javadoc building some unsupported OpenJ9 extensions.</td>
<td valign="top">All platforms</td>
<td valign="top">Some API documentation in <code>build/&lt;platform&gt;/docs</code> is not supported with OpenJ9.</td>
<td valign="top">None</td>
</tr>
<tr><td valign="top"><a href="https://github.com/ibmruntimes/openj9-openjdk-jdk8/issues/17">#17</a></td>
<td valign="top">Builds contain extra shared libraries.</td>
<td valign="top">All platforms</td>
<td valign="top">Shared libraries must not be used in production.</td>
<td valign="top">None</td>
</tr>
</tbody>
</table>


## Functional verification tests
The following issues (in numerical order) relate to test failures:

[#244 ](https://github.com/eclipse-openj9/openj9/issues/244 )  testCrNocr in VmArgumentTests failed - java.lang.AssertionError: Target process failed
<br/>[#366 ](https://github.com/eclipse-openj9/openj9/issues/366 )  cmdLineTest: cmdLineTester_jep178_staticLinking_SE90 failed due to  cannot find `/lib/amd64/compressedrefs/testjep178_static`
<br/>[#480 ](https://github.com/eclipse-openj9/openj9/issues/480 )  j9vm.test.softmx.SoftmxRemoteTest.setUp server is not ready after 120 seconds
<br/>[#1127](https://github.com/eclipse-openj9/openj9/issues/1127)  jdk_io test error
<br/>[#1128](https://github.com/eclipse-openj9/openj9/issues/1128)  jdk_lang test failures
<br/>[#1129](https://github.com/eclipse-openj9/openj9/issues/1129)  jdk_net test failure
<br/>[#1130](https://github.com/eclipse-openj9/openj9/issues/1130)  jdk_nio test failures
<br/>[#1131](https://github.com/eclipse-openj9/openj9/issues/1131)  jdk_util test failures
<br/>[#1144](https://github.com/eclipse-openj9/openj9/issues/1144)  jdk_rmi test failures
<br/>[#1151](https://github.com/eclipse-openj9/openj9/issues/1151)  ARM Hang while compiling test/Jsr292
<br/>[#1203](https://github.com/eclipse-openj9/openj9/issues/1203)  TestUTF8 fails with assertion Unsafe_copySwapMemory0 is unimplemented
<br/>[#1205](https://github.com/eclipse-openj9/openj9/issues/1205)  ARM sigbus from initialiseAOTRelocationHeader
<br/>[#1209](https://github.com/eclipse-openj9/openj9/issues/1209)  ARM Assertion in J9TransformUtil.cpp
<br/>[#1212](https://github.com/eclipse-openj9/openj9/issues/1212)  ARM JVM_GetVmArguments not implemented
<br/>[#1430](https://github.com/eclipse-openj9/openj9/issues/1430)  openjdk9-openj9 jdk_lang test failures
<br/>[#1431](https://github.com/eclipse-openj9/openj9/issues/1431)  openjdk9-openj9 jdk_io test failures
<br/>[#1432](https://github.com/eclipse-openj9/openj9/issues/1432)  openjdk9-openj9 jdk_net  test failures
<br/>[#1433](https://github.com/eclipse-openj9/openj9/issues/1433)  openjdk9-openj9 jdk_nio test failures
<br/>[#1434](https://github.com/eclipse-openj9/openj9/issues/1434)  openjdk9-openj9 jdk_util test failures
<br/>[#1435](https://github.com/eclipse-openj9/openj9/issues/1435)  openjdk9-openj9 jdk_rmi test failures
<br/>[#1566](https://github.com/eclipse-openj9/openj9/issues/1566)  java.lang.IllegalArgumentException: argument type mismatch received in JMX Bean test in Hotspot, but none in OpenJ9
<br/>[#1626](https://github.com/eclipse-openj9/openj9/issues/1626)  JDK10 JLM_Tests_interface FAILED
<br/>[#1765](https://github.com/eclipse-openj9/openj9/issues/1765)  Annotation testing failures
<br/>[#1796](https://github.com/eclipse-openj9/openj9/issues/1796)  ARM: Hang in SharedClassesSysVTesting_0
<br/>[#1814](https://github.com/eclipse-openj9/openj9/issues/1814)  SCCommandLineOptionTests/SCURLClassLoaderNPTest failed on JDK10-win_x86-64_cmprssptrs
<br/>[#2019](https://github.com/eclipse-openj9/openj9/issues/2019)  Test-Extended-JDK8-linux_ppc-64_cmprssptrs_le TestAttachErrorHandling OOM in attach API
<br/>[#2047](https://github.com/eclipse-openj9/openj9/issues/2047)  Intermittent NullPointerException in TestAttachErrorHandling.deleteIpcDirectories
<br/>[#2114](https://github.com/eclipse-openj9/openj9/issues/2114)  cmdLineTester_jvmtitests_hcr_3 functional sanity rc010 gpf
<br/>[#2129](https://github.com/eclipse-openj9/openj9/issues/2129)  Windows JDK8 jvmti tests failed with &quot;NPT ERROR: Cannot open library&quot;
<br/>[#2141](https://github.com/eclipse-openj9/openj9/issues/2141)  Test-Extended-JDK8-aix_ppc-64_cmprssptrs startupShutdownRobustness IOException: Error deleting
<br/>[#2213](https://github.com/eclipse-openj9/openj9/issues/2213)  Test-Extended-JDK8-win_x86 testOpenJ9DiagnosticsMXBean_0 hangs
<br/>[#2227](https://github.com/eclipse-openj9/openj9/issues/2227)  Test-sanity.system-JDK10-linux_ppc-64_cmprssptrs_le Jlink directory count not be found
<br/>[#2363](https://github.com/eclipse-openj9/openj9/issues/2363)  systemtest failed to build Test-sanity.system-JDK8-linux_390-64_cmprssptrs
<br/>[#2385](https://github.com/eclipse-openj9/openj9/issues/2385)  DaaLoadTest_daa1_0 Test-sanity.system-JDK10-linux_x86-64 Segmentation error vmState=0x000507ff
<br/>[#2472](https://github.com/eclipse-openj9/openj9/issues/2472)  cmdLineTester_jvmtitests_hcr_OSRG_nongold_1 Test-extended.functional-JDK10-linux_x86-64 rc004 gpf



Because some tests are not yet enabled, functional problems might not be exposed. In addition, some IBM authored functional verification testing is not yet contributed to Eclipse, such as issue  [#724](https://github.com/eclipse-openj9/openj9/issues/724).

## Other changes

The issues addressed in this release are listed at [Eclipse OpenJ9 v0.9.0](https://github.com/eclipse-openj9/openj9/releases/tag/openj9-0.9.0).
