<!--
* Copyright (c) 2025 IBM Corp. and others
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which accompanies this distribution and is available at
* https://www.eclipse.org/legal/epl-2.0/ or the Apache
* License, Version 2.0 which accompanies this distribution and
* is available at https://www.apache.org/licenses/LICENSE-2.0.
*
* This Source Code may also be made available under the
* following Secondary Licenses when the conditions for such
* availability set forth in the Eclipse Public License, v. 2.0
* are satisfied: GNU General Public License, version 2 with
* the GNU Classpath Exception [1] and GNU General Public
* License, version 2 with the OpenJDK Assembly Exception [2].
*
* [1] https://www.gnu.org/software/classpath/license.html
* [2] https://openjdk.org/legal/assembly-exception.html
*
* SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
-->

# Eclipse OpenJ9 version 0.56.0 release notes

These release notes support the [Eclipse OpenJ9&trade; 0.56.0 release plan](https://projects.eclipse.org/projects/technology.openj9/releases/0.56.0/plan).

## Supported environments

OpenJ9 release 0.56.0 supports OpenJDK 8, 11, 17, 21, and 25.

All releases are tested against the OpenJ9 functional verification (FV) test suite, the OpenJDK test suites, and additional tests provided by Adoptium.

To learn more about support for OpenJ9 releases, including OpenJDK levels and platform support, see [Supported environments](https://eclipse.org/openj9/docs/openj9_support/index.html).

## Notable changes in this release

The following table covers notable changes in v0.56.0. Further information about these changes can be found in the [user documentation](https://eclipse.dev/openj9/docs/version0.56/).

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1"><thead align="left">
<tr>
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Version / Platform</th>
<th valign="bottom">Impact</th>
</tr>
</thead>
<tbody>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/22258">#22258</a></td>
<td valign="top">The <tt>getCpuLoad()</tt> method now collects two internal samples so that a valid CPU usage value can be returned instead of <tt>0</tt> return value on the first call.</td>
<td valign="top">All versions (All operating systems except z/OS&reg;)</td>
<td valign="top">The change in the <tt>getCpuLoad()</tt> method return value is applicable on all platforms except z/OS. On z/OS, the CPU load that is reported by the <tt>getCpuLoad</tt> method is obtained directly from the system control blocks, without the need to collect samples. The <tt>-XX:[+|-]CpuLoadCompatibility</tt> option has no effect on z/OS, and a valid CPU usage value is always returned whatever the setting of this option.
</td>
</tr>
<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/22321">#22321</a></td>
<td valign="top">New <tt>-Xgc</tt> parameters related to macro fragmentation are added.</td>
<td valign="top">All versions</td>
<td valign="top">New parameters, <tt>enableEstimateFragmentation</tt> and <tt>disableEstimateFragmentation</tt> are added to the <tt>-Xgc</tt> option to control the calculating and reporting of the estimates of the macro fragmentation.
</td>
</tr>
<tr>
<td valign="top"><a href="https://github.com/eclipse-omr/omr/pull/7743">#7743</a>, <a href="https://github.com/eclipse-omr/omr/pull/7759">#7759</a>, <a href="https://github.com/eclipse-omr/omr/pull/7772">#7772</a>, <a href="https://github.com/eclipse-omr/omr/pull/7793">#7793</a>, <a href="https://github.com/eclipse-omr/omr/pull/7808">#7808</a>, <a href="https://github.com/eclipse-omr/omr/pull/7810">#7810</a>, <a href="https://github.com/eclipse-omr/omr/pull/7845">#7845</a></td>
<td valign="top">The NativeLibrary and SystemProcess JFR events are supported in all platforms except z/OS.</td>
<td valign="top">OpenJDK 11 and later (All operating systems except z/OS)</td>
<td valign="top">Earlier, these JFR events were supported only in Linux&reg;. 
To record and analyze the SystemProcess JFR event on z/OS (2.5 and 3.1), you must install <a href="https://www.ibm.com/support/pages/apar/OA62757">APAR OA62757</a>.
</td>
</tr>
<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/22626">#22626</a></td>
<td valign="top">The format of the <tt>java.vm.version</tt> system property value is updated to be compatible with the Runtime.Version parser.</td>
<td valign="top">All versions</td>
<td valign="top">Earlier, the format of the <tt>java.vm.version</tt> system property value was not standardized and structured and was not parse-able by the <tt>java.lang.Runtime.Version</tt> class.<br>With the new structured format, the <tt>java.lang.Runtime.Version</tt> class parses the value and you can extract specific information such as the information related to the VM version. This modification also changes the <tt>-version</tt> output. For example, <tt>build openj9-0.56.0</tt> changes to <tt>build 11.0.29+7-openj9-0.56.0</tt>.<br>This change was initiated in the 0.55.0 release and it affects 0.56.0 and all future releases.</td>
</tr>
</tbody>
</table>

## Known issues

The v0.56.0 release contains the following known issues and limitations:

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1">
<thead align="left">
<tr>
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Platform</th>
<th valign="bottom">Impact</th>
<th valign="bottom">Workaround</th>
</tr>
</thead>

<tbody>
<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/15011">#15011</a></td>
<td valign="top">The default stack size for the main thread is a smaller platform-dependent value.</td>
<td valign="top">All</td>
<td valign="top">The main thread stack size was 1 MB in releases before 0.32. In the 0.32 release and later it was modified to a smaller
platform-dependent value, the same value as the <tt>-Xmso</tt> setting. The 0.33 release increased the default <tt>-Xmso</tt> stack size
on x64 platforms, but builds with OpenJDK 17 and later also require more stack space to run. These changes might result in a
<tt>java.lang.StackOverflowError: operating system stack overflow</tt>.</td>
<td valign="top">Use <tt>-Xmso</tt> to set the default stack size. See the default value by using <tt>-verbose:sizes</tt>.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/13767">#13767</a></td>
<td valign="top">Compressed references mode is not available.</td>
<td valign="top">Apple silicon macOS</td>
<td valign="top">You can use only the large heap (non-compressed references) mode.</td>
<td valign="top">None</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/14803">#14803</a></td>
<td valign="top">Using the <tt>-XX:+ShowHiddenFrames</tt> option in an OpenJ9 release that is built with OpenJDK 18 and later causes errors.</td>
<td valign="top">All platforms</td>
<td valign="top">Wrong exception might be thrown when using the Reflection API.</td>
<td valign="top">Avoid using the <tt>-XX:+ShowHiddenFrames</tt> option with OpenJDK 18 and later.</td>
</tr>

</tbody>
</table>

## Other changes

A full commit history for 0.56.0 release is available at [Eclipse OpenJ9 v0.56.0](https://github.com/eclipse-openj9/openj9/releases/tag/openj9-0.56.0).
