<!--
* Copyright (c) 2025 IBM Corp. and others
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which accompanies this distribution and is available at
* https://www.eclipse.org/legal/epl-2.0/ or the Apache
* License, Version 2.0 which accompanies this distribution and
* is available at https://www.apache.org/licenses/LICENSE-2.0.
*
* This Source Code may also be made available under the
* following Secondary Licenses when the conditions for such
* availability set forth in the Eclipse Public License, v. 2.0
* are satisfied: GNU General Public License, version 2 with
* the GNU Classpath Exception [1] and GNU General Public
* License, version 2 with the OpenJDK Assembly Exception [2].
*
* [1] https://www.gnu.org/software/classpath/license.html
* [2] https://openjdk.org/legal/assembly-exception.html
*
* SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
-->

# Eclipse OpenJ9 version 0.53.0 release notes

These release notes support the [Eclipse OpenJ9&trade; 0.53.0 release plan](https://projects.eclipse.org/projects/technology.openj9/releases/0.53.0/plan).

## Supported environments

OpenJ9 release 0.53.0 supports OpenJDK 8, 11, 17, and 21.

All releases are tested against the OpenJ9 functional verification (FV) test suite, the OpenJDK test suites, and additional tests provided by Adoptium.

To learn more about support for OpenJ9 releases, including OpenJDK levels and platform support, see [Supported environments](https://eclipse.org/openj9/docs/openj9_support/index.html).

## Notable changes in this release

The following table covers notable changes in v0.53.0. Further information about these changes can be found in the [user documentation](https://eclipse.dev/openj9/docs/version0.53/).

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1"><thead align="left">
<tr>
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Version / Platform</th>
<th valign="bottom">Impact</th>
</tr>
</thead>
<tbody>

<tr>
<td valign="top">
<a href="https://github.com/ibmruntimes/openj9-openjdk-jdk/pull/1015">#1015
</td>
<td valign="top">OpenSSL support is added for PBKDF2 algorithm.</td>
<td valign="top">All versions</td>
<td valign="top">OpenSSL native cryptographic support is added for the Password based key derivation (PBKDF2) algorithm, providing improved cryptographic performance. OpenSSL support is enabled by default for the PBKDF2 algorithm.</td>
</tr>

<tr>
<td valign="top">N/A </td>
<td valign="top">RHEL 8.8 and 9.2 are out of support and are removed from the list of supported platforms.</td>
<td valign="top">All versions (RHEL 8.8, RHEL 9.2) </td>
<td valign="top">RHEL 8.10 and 9.4 are the new minimum operating system levels.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/21060">#21060, <a href="https://github.com/eclipse-openj9/openj9/pull/21896">#21896
 </td>
<td valign="top">OpenSSL 3.5.1 is bundled on all platforms.</td>
<td valign="top">All versions </td>
<td valign="top">OpenSSL 3.5.1 is now supported and bundled on all platforms. You can use the <tt>jdk.native.openssl.skipBundled</tt> property to specify whether to load the pre-packaged OpenSSL library or the library available on the system path.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/21659">#21659</td>
<td valign="top">Offheap support is added for the <tt>balanced</tt> GC policy.</td>
<td valign="top">All versions (All platforms except z/TPF)</td>
<td valign="top">Before the 0.53.0 release, the <tt>balanced</tt> GC policy used an arraylet representation in the heap to support large arrays that cannot be contained in a region. Now, if the array's data are larger than a region size, the array's data are stored into a separate area, Offheap.</td>
</tr>

<tr>
<td valign="top"></td>
<td valign="top">The following new JDK Flight Recorder (JFR) events are added in this release:

- NativeLibrary (Linux&reg; only)
- SystemGC
- SystemProcess (Linux only)
- YoungGenerationConfiguration</td>
<td valign="top">OpenJDK 11 and later</td>
<td valign="top"></td>
</tr>
</tbody>
</table>

## Known issues

The v0.53.0 release contains the following known issues and limitations:

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1">
<thead align="left">
<tr>
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Platform</th>
<th valign="bottom">Impact</th>
<th valign="bottom">Workaround</th>
</tr>
</thead>

<tbody>
<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/15011">#15011</a></td>
<td valign="top">The default stack size for the main thread is a smaller platform-dependent value.</td>
<td valign="top">All</td>
<td valign="top">The main thread stack size was 1 MB in releases before 0.32. In the 0.32 release and later it was modified to a smaller
platform-dependent value, the same value as the <tt>-Xmso</tt> setting. The 0.33 release increased the default <tt>-Xmso</tt> stack size
on x64 platforms, but builds with OpenJDK 17 and later also require more stack space to run. These changes might result in a
<tt>java.lang.StackOverflowError: operating system stack overflow</tt>.</td>
<td valign="top">Use <tt>-Xmso</tt> to set the default stack size. See the default value by using <tt>-verbose:sizes</tt>.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/13767">#13767</a></td>
<td valign="top">Compressed references mode is not available.</td>
<td valign="top">Apple silicon macOS</td>
<td valign="top">You can use only the large heap (non-compressed references) mode.</td>
<td valign="top">None</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/14803">#14803</a></td>
<td valign="top">Using the <tt>-XX:+ShowHiddenFrames</tt> option in an OpenJ9 release that is built with OpenJDK 18 and later causes errors.</td>
<td valign="top">All platforms</td>
<td valign="top">Wrong exception might be thrown when using the Reflection API.</td>
<td valign="top">Avoid using the <tt>-XX:+ShowHiddenFrames</tt> option with OpenJDK 18 and later.</td>
</tr>

</tbody>
</table>

## Other changes

A full commit history for 0.53.0 release is available at [Eclipse OpenJ9 v0.53.0](https://github.com/eclipse-openj9/openj9/releases/tag/openj9-0.53.0).
