<!--
* Copyright (c) 2024 IBM Corp. and others
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which accompanies this distribution and is available at
* https://www.eclipse.org/legal/epl-2.0/ or the Apache
* License, Version 2.0 which accompanies this distribution and
* is available at https://www.apache.org/licenses/LICENSE-2.0.
*
* This Source Code may also be made available under the
* following Secondary Licenses when the conditions for such
* availability set forth in the Eclipse Public License, v. 2.0
* are satisfied: GNU General Public License, version 2 with
* the GNU Classpath Exception [1] and GNU General Public
* License, version 2 with the OpenJDK Assembly Exception [2].
*
* [1] https://www.gnu.org/software/classpath/license.html
* [2] https://openjdk.org/legal/assembly-exception.html
*
* SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
-->

# Eclipse OpenJ9 version 0.43.0 release notes

These release notes support the [Eclipse OpenJ9&trade; 0.43.0 release plan](https://projects.eclipse.org/projects/technology.openj9/releases/0.43.0/plan).

## Supported environments

OpenJ9 release 0.43.0 supports OpenJDK 8, 11, 17, and 21.

All releases are tested against the OpenJ9 functional verification (FV) test suite, the OpenJDK test suites, and additional tests provided by Adoptium.

To learn more about support for OpenJ9 releases, including OpenJDK levels and platform support, see [Supported environments](https://eclipse.org/openj9/docs/openj9_support/index.html).

## Notable changes in this release

The following table covers notable changes in v0.43.0. Further information about these changes can be found in the [user documentation](https://eclipse.dev/openj9/docs/version0.42/).

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1"><thead align="left">
<tr>
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Version / Platform</th>
<th valign="bottom">Impact</th>
</tr>
</thead>
<tbody>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/18135">#18135</a>, <a href="https://github.com/eclipse-openj9/openj9/issues/18408">#18408</a>, and <a href="https://github.com/eclipse-openj9/openj9/issues/18498">#18498</a> </td>
<td valign="top">Linux&reg; reference compiler on OpenJDK 8, 11, and 17 is updated.</td>
<td valign="top">OpenJDK 8, 11, and 17 (Linux)</td>
<td valign="top">Linux x86 64-bit, Linux on POWER&reg; LE 64-bit, and Linux on IBM Z&reg; 64-bit builds on OpenJDK 8, 11, and 17 now use gcc 11.2 compiler. Linux AArch64 64-bit moved to gcc 10.3 compiler from gcc 7.5 compiler on OpenJDK 8 and 11.

On OpenJDK 19 and later, the Linux reference compiler was already updated to gcc 11.2 in [release 0.37.0](version0.37.md).</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/18135">#18135</a></td>
<td valign="top">OpenJ9 Windows&reg; OpenJDK 8, 11, and 17 builds now compile with Microsoft&reg; Visual Studio 2022.</td>
<td valign="top">OpenJDK 8, 11, and 17 (Windows)</td>
<td valign="top">The Visual Studio redistributable files included with the build are updated to match.

OpenJ9 Windows OpenJDK 19 and later builds already compile with Microsoft Visual Studio 2022 from [release 0.37.0](version0.37.md) onwards.
</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/18342">#18342</a></td>
<td valign="top">The large page memory allocation behavior is changed.</td>
<td valign="top">All versions</td>
<td valign="top">Earlier, the JIT code cache was allocated memory as a multiple of the available page size even if the configured large page size was greater than the total JIT code cache size.
Now, if the configured large page size is greater than the size of the total code cache for JIT, then the page size that is used for code cache allocation is recalculated. The next available lower page size on the platform is used for the code cache allocation.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/18354">#18354</a></td>
<td valign="top">The <tt>-XX:[+|-]CRIUSecProvider</tt> option is added to control the use of <tt>CRIUSECProvider</tt> during the checkpoint phase.</td>
<td valign="top">OpenJDK 11 and later (Linux)</td>
<td valign="top">When you enable CRIU support, all the existing security providers are removed from the security provider list during the checkpoint phase and <tt>CRIUSECProvider</tt> is added by default. Therefore, you can use only those security algorithms that are available in <tt>CRIUSECProvider</tt>. You can now choose to disable the use of <tt>CRIUSECProvider</tt> with the <tt>-XX:-CRIUSecProvider</tt> option and continue to use all the existing security providers during the checkpoint and restore phase.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/18265">#18265</a></td>
<td valign="top">The <tt>-XX:Compatibility</tt> option is added to enable a compatibility mode that OpenJ9 can run in to support applications that require specific capabilities.</td>
<td valign="top">All versions</td>
<td valign="top">The Elasticsearch application was facing incompatibility issues when it was running on OpenJ9 and required many workarounds. With the <tt>-XX:Compatibility</tt> option, you can enable a compatibility mode that OpenJ9 can run in to support applications that require specific capabilities.

In release 0.43.0, the compatibility mode is provided for the Elasticsearch application only.

Although this option is available in all OpenJDK versions, the Elasticsearch application requires OpenJDK version 17 or later.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/18636">#18636</a></td>
<td valign="top">The <tt>-XX:[+|-]CpuLoadCompatibility</tt> option is added to enable the OpenJDK behavior of the <tt>getProcessCpuLoad()</tt> and <tt>getSystemCpuLoad()</tt> methods in OpenJ9 so that these methods return <tt>0</tt> when called in OpenJ9 for the first time.</td>
<td valign="top">All versions</td>
<td valign="top">The <tt>getProcessCpuLoad()</tt> and <tt>getSystemCpuLoad()</tt> methods were returning <tt>-1</tt> to indicate that the recent CPU usage is not available when these methods were called in OpenJ9 for the first time. It was difficult to identify whether the reason for the <tt>-1</tt> value was an error or because the call was the first call and therefore, no recent CPU usage was available.

In OpenJDK, these methods return <tt>0</tt> value in the case of the first call, which makes it easier to differentiate between the first call behavior and an error that needs further investigation.

The <tt>-XX:+CpuLoadCompatibility</tt> option is used to enable the OpenJDK behavior of the <tt>getProcessCpuLoad()</tt> and <tt>getSystemCpuLoad()</tt> methods in OpenJ9 so that these methods return <tt>0</tt> when called in OpenJ9 for the first time.
</td>
</tr>
<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/18202">#18202</a></td>
<td valign="top">Support is added for the <tt>com.sun.management.ThreadMXBean.getThreadAllocatedBytes()</tt> API on z/OS&reg; platforms.</td>
<td valign="top">All versions (z/OS)</td>
<td valign="top">In the earlier release, support for the <tt>com.sun.management.ThreadMXBean.getThreadAllocatedBytes()</tt> API was added on all operating systems except z/OS platforms. In this release, the support for this API is added on z/OS platforms as well.</td>
</tr>

</tbody>
</table>

## Known issues

The v0.43.0 release contains the following known issues and limitations:

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1">
<thead align="left">
<tr>
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Platform</th>
<th valign="bottom">Impact</th>
<th valign="bottom">Workaround</th>
</tr>
</thead>

<tbody>
<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/15011">#15011</a></td>
<td valign="top">The default stack size for the main thread is a smaller platform-dependent value.</td>
<td valign="top">All</td>
<td valign="top">The main thread stack size was 1 MB in releases before 0.32. In the 0.32 release and later it was modified to a smaller
platform-dependent value, the same value as the <tt>-Xmso</tt> setting. The 0.33 release increased the default <tt>-Xmso</tt> stack size
on x64 platforms, but builds with OpenJDK 17 and later also require more stack space to run. These changes might result in a
<tt>java.lang.StackOverflowError: operating system stack overflow</tt>.</td>
<td valign="top">Use <tt>-Xmso</tt> to set the default stack size. See the default value by using <tt>-verbose:sizes</tt>.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/13767">#13767</a></td>
<td valign="top">Compressed references mode is not available.</td>
<td valign="top">Apple silicon macOS</td>
<td valign="top">You can use only the large heap (non-compressed references) mode.</td>
<td valign="top">None</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/14803">#14803</a></td>
<td valign="top">Using the <tt>-XX:+ShowHiddenFrames</tt> option in an OpenJ9 release that is built with OpenJDK 18 and later causes errors.</td>
<td valign="top">All platforms</td>
<td valign="top">Wrong exception might be thrown when using the Reflection API.</td>
<td valign="top">Avoid using the <tt>-XX:+ShowHiddenFrames</tt> option with OpenJDK 18 and later.</td>
</tr>

</tbody>
</table>

## Other changes

A full commit history for 0.43.0 release is available at [Eclipse OpenJ9 v0.43.0](https://github.com/eclipse-openj9/openj9/releases/tag/openj9-0.43.0).
