<!--
* Copyright (c) 2023 IBM Corp. and others
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which accompanies this distribution and is available at
* https://www.eclipse.org/legal/epl-2.0/ or the Apache
* License, Version 2.0 which accompanies this distribution and
* is available at https://www.apache.org/licenses/LICENSE-2.0.
*
* This Source Code may also be made available under the
* following Secondary Licenses when the conditions for such
* availability set forth in the Eclipse Public License, v. 2.0
* are satisfied: GNU General Public License, version 2 with
* the GNU Classpath Exception [1] and GNU General Public
* License, version 2 with the OpenJDK Assembly Exception [2].
*
* [1] https://www.gnu.org/software/classpath/license.html
* [2] https://openjdk.org/legal/assembly-exception.html
*
* SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
-->

# Eclipse OpenJ9 version 0.42.0 release notes

These release notes support the [Eclipse OpenJ9&trade; 0.42.0 release plan](https://projects.eclipse.org/projects/technology.openj9/releases/0.42.0/plan).

## Supported environments

OpenJ9 release 0.42.0 supports OpenJDK 21.

All releases are tested against the OpenJ9 functional verification (FV) test suite, the OpenJDK test suites, and additional tests provided by Adoptium.

To learn more about support for OpenJ9 releases, including OpenJDK levels and platform support, see [Supported environments](https://eclipse.org/openj9/docs/openj9_support/index.html).

## Notable changes in this release

The following table covers notable changes in v0.42.0. Further information about these changes can be found in the [user documentation](https://eclipse.dev/openj9/docs/version0.42/).

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1"><thead align="left">
<tr>
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Version / Platform</th>
<th valign="bottom">Impact</th>
</tr>
</thead>
<tbody>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/18193">#18193</a></td>
<td valign="top">The dump extractor tool, OpenJ9 <tt>jextract</tt>, is removed.</td>
<td valign="top">OpenJDK 21 and later</td>
<td valign="top">The dump extractor tool, OpenJ9 <tt>jextract</tt>, that was deprecated since the 0.26.0 release is now removed from Java 21 and later. The <tt>jpackcore</tt> tool replaced the OpenJ9 <tt>jextract</tt> tool after its deprecation. </td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/18044">#18044</a></td>
<td valign="top">The <tt>System.gc()</tt> call behavior is changed.</td>
<td valign="top">All versions</td>
<td valign="top">Earlier, the <tt>System.gc()</tt> call had to be called twice explicitly to ensure that all unreachable objects are identified and cleared. Now, the <tt>System.gc()</tt> call triggers the GC cycle twice internally to clear the unreachable objects that were not identified during the first GC cycle. The call also triggers finalization of the objects in the Finalization queues.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/18381">#18381</a></td>
<td valign="top">The <tt>-XX:[+|-]IProfileDuringStartupPhase</tt> option is added to control the collection of the profiling information during the startup phase.</td>
<td valign="top">All versions</td>
<td valign="top">The VM uses heuristics to decide whether to collect interpreter profiling information during the VM startup. You can now overrule the heuristics and control the collection of the profiling information during the startup phase by using the <tt>-XX:[+|-]IProfileDuringStartupPhase</tt> option.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/18354">#18354</a></td>
<td valign="top">The <tt>-XX:[+|-]CRIUSecProvider</tt> option is added to control the use of <tt>CRIUSECProvider</tt> during the checkpoint phase.</td>
<td valign="top">OpenJDK 21 (Linux&reg;)</td>
<td valign="top">When you enable CRIU support, all the existing security providers are removed from the security provider list during the checkpoint phase and <tt>CRIUSECProvider</tt> is added by default. Therefore, you can use only those security algorithms that are available in <tt>CRIUSECProvider</tt>. You can now choose to disable the use of <tt>CRIUSECProvider</tt> with the <tt>-XX:-CRIUSecProvider</tt> option and continue to use all the existing security providers during the checkpoint and restore phase.</td>
</tr>
</tbody>
</table>

## Known issues

The v0.42.0 release contains the following known issues and limitations:

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1">
<thead align="left">
<tr>
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Platform</th>
<th valign="bottom">Impact</th>
<th valign="bottom">Workaround</th>
</tr>
</thead>

<tbody>
<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/15011">#15011</a></td>
<td valign="top">The default stack size for the main thread is a smaller platform-dependent value.</td>
<td valign="top">All</td>
<td valign="top">The main thread stack size was 1 MB in releases before 0.32. In the 0.32 release and later it was modified to a smaller
platform-dependent value, the same value as the <tt>-Xmso</tt> setting. The 0.33 release increased the default <tt>-Xmso</tt> stack size
on x64 platforms, but builds with OpenJDK 17 and later also require more stack space to run. These changes might result in a
<tt>java.lang.StackOverflowError: operating system stack overflow</tt>.</td>
<td valign="top">Use <tt>-Xmso</tt> to set the default stack size. See the default value by using <tt>-verbose:sizes</tt>.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/13767">#13767</a></td>
<td valign="top">Compressed references mode is not available.</td>
<td valign="top">Apple silicon macOS</td>
<td valign="top">You can use only the large heap (non-compressed references) mode.</td>
<td valign="top">None</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/14803">#14803</a></td>
<td valign="top">Using the <tt>-XX:+ShowHiddenFrames</tt> option in an OpenJ9 release that is built with OpenJDK 18 and later causes errors.</td>
<td valign="top">All platforms</td>
<td valign="top">Wrong exception might be thrown when using the Reflection API.</td>
<td valign="top">Avoid using the <tt>-XX:+ShowHiddenFrames</tt> option with OpenJDK 18 and later.</td>
</tr>

</tbody>
</table>

## Other changes

A full commit history for 0.42.0 release is available at [Eclipse OpenJ9 v0.42.0](https://github.com/eclipse-openj9/openj9/releases/tag/openj9-0.42.0).
