<!--
* Copyright (c) 2023 IBM Corp. and others
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which accompanies this distribution and is available at
* https://www.eclipse.org/legal/epl-2.0/ or the Apache
* License, Version 2.0 which accompanies this distribution and
* is available at https://www.apache.org/licenses/LICENSE-2.0.
*
* This Source Code may also be made available under the
* following Secondary Licenses when the conditions for such
* availability set forth in the Eclipse Public License, v. 2.0
* are satisfied: GNU General Public License, version 2 with
* the GNU Classpath Exception [1] and GNU General Public
* License, version 2 with the OpenJDK Assembly Exception [2].
*
* [1] https://www.gnu.org/software/classpath/license.html
* [2] https://openjdk.org/legal/assembly-exception.html
*
* SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
-->

# Eclipse OpenJ9 version 0.41.0 release notes

These release notes support the [Eclipse OpenJ9&trade; 0.41.0 release plan](https://projects.eclipse.org/projects/technology.openj9/releases/0.41.0/plan).

## Supported environments

OpenJ9 release 0.41.0 supports OpenJDK 8, 11 and 17.

All releases are tested against the OpenJ9 functional verification (FV) test suite, the OpenJDK test suites, and additional tests provided by Adoptium.

To learn more about support for OpenJ9 releases, including OpenJDK levels and platform support, see [Supported environments](https://eclipse.org/openj9/docs/openj9_support/index.html).

## Notable changes in this release

The following table covers notable changes in v0.41.0. Further information about these changes can be found in the [user documentation](https://eclipse.dev/openj9/docs/version0.41/).

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1"><thead align="left">
<tr>
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Version / Platform</th>
<th valign="bottom">Impact</th>
</tr>
</thead>
<tbody>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/16724">#16724</a></td>
<td valign="top">The <tt>-XX:[+|-]ShowCarrierFrames</tt> option is available to add the stack trace of the carrier thread in addition to the virtual thread stack trace to the <tt>Throwable.getStackTrace()</tt> method, if an exception occurs.</td>
<td valign="top">OpenJDK 21 and later</td>
<td valign="top">A VM maintains multiple platform threads that are used as carrier threads to run the virtual threads. Earlier, if an exception occurred on running the virtual threads, the thread dumps did not include stack frames from the carrier thread's stack. You can use the <tt>-XX:+ShowCarrierFrames</tt> option to add the stack trace of the carrier thread in addition to the virtual thread stack trace to the <tt>Throwable.getStackTrace()</tt> method, if an exception occurs. </td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/16452">#16452</a></td>
<td valign="top">The <tt>-XX:+CompactStrings</tt> option is now enabled by default</td>
<td valign="top">OpenJDK 11 and later</td>
<td valign="top">Like HotSpot, the <tt>-XX:+CompactStrings</tt> option is now enabled by default on Java&trade; 11 and later. In the earlier versions, this option is disabled by default.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/17945">#17945</a></td>
<td valign="top">Change in behavior of <tt>-Xshareclasses:readonly</tt></td>
<td valign="top">All versions (Linux&reg;)</td>
<td valign="top">In the earlier releases, if the <tt>-Xshareclasses:readonly</tt> option and the JITServer AOT cache feature were both enabled at the same time at a JITServer client, the client could not use the JITServer AOT cache because the cache for storing data that the JITServer AOT cache needed was read-only.
Now, with the change in behavior of the <tt>-Xshareclasses:readonly</tt> option, the shared class cache startup creates a temporary new (writable) top layer that the JITServer AOT cache can use to store data that it needs to function.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/18401">#18401</a>, <a href="https://github.com/eclipse-openj9/openj9/issues/18402">#18402</a></td>
<td valign="top">Change in behavior of the <tt>-Djava.security.manager</tt> system property for OpenJDK version 11.</td>
<td valign="top">OpenJDK 11</td>
<td valign="top">

In OpenJDK versions before version 18, the runtime attempts to load a <tt>SecurityManager</tt> with the class name <tt>allow</tt> or <tt>disallow</tt> resulted in an error and the application was not starting.

To resolve this issue, OpenJDK version 17 ignores these options. With this release, OpenJDK version 11 also ignores these options. 
</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/17215">#17215</a></td>
<td valign="top">The <tt>-XX:[+|-]EnableDynamicAgentLoading</tt> option is added to enable or disable the dynamic loading of agents into a running VM.</tt></td>
<td valign="top">All versions</td>
<td valign="top">With the Attach API, your application can load an agent dynamically into a running VM to run tasks. You can disable the dynamic loading of the agents into a VM after startup with the <tt>-XX:-EnableDynamicAgentLoading</tt> option to prevent the misuse of the Attach API to dynamically load an agent without the approval of the application owner.<br>For Java 21 and later, warnings are issued when the agents are loaded dynamically without specifying the <tt>-XX:+EnableDynamicAgentLoading</tt> option and the same agents were not loaded before.</td>
</tr>
<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/17643">#17643</a></td>
<td valign="top">The <tt>-XX:ContinuationCache</tt> option is added to tune the continuation tier 1 and 2 cache size.</tt></td>
<td valign="top">OpenJDK 21 and later</td>
<td valign="top">New continuations can reuse the cached structure instead of allocating new memory for it. The continuation cache is implemented in two tiers, tier 1 and tier 2. You can set the maximum size for the two tiers with the <tt>-XX:ContinuationCache</tt> option. If an application uses more than 10000 virtual threads, setting a larger cache size might improve performance.</td>
</tr>
<tr>
<td valign="top"><a href="https://github.com/ibmruntimes/openj9-openjdk-jdk17/pull/265">#265</a></td>
<td valign="top">The <tt>-XX:[+|-]UseZlibNX</tt> is added to control the loading of the <tt>zlibnx</tt> library in the <tt>LIBPATH</tt> environment variable.</td>
<td valign="top">All versions (AIX&reg;)</td>
<td valign="top">The AIX system adds the <tt>zlibNX</tt> library location, if available, to the <tt>LIBPATH</tt> variable by default. But, having the <tt>zlibNX</tt> library directory location in the <tt>LIBPATH</tt> variable might cause some issues. You can disable adding of the <tt>zlibNX</tt> library location to that variable with the <tt>-XX:-UseZlibNX</tt> option.</td>
</tr>
<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/13686">#13686</a></td>
<td valign="top">OpenSSL 3.x is now supported on all operating systems.</td>
<td valign="top">All versions</td>
<td valign="top">In the earlier releases, OpenSSL 3.x was supported only on Linux. Now, OpenSSL 3.x is supported on all operating systems.</td>
</tr>
<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/18202">#18202</a></td>
<td valign="top">Support is added for the <tt>com.sun.management.ThreadMXBean.getThreadAllocatedBytes()</tt> API.</td>
<td valign="top">All versions (All operating systems except z/OS&reg;)</td>
<td valign="top">In the earlier releases, thread memory allocation measurement was not supported. With this release, the OpenJ9 VM implementation supports thread memory allocation measurement (<tt>com.sun.management.ThreadMXBean.getThreadAllocatedBytes()</tt> API). The <tt>isThreadAllocatedMemorySupported()</tt> method now returns true instead of false. The <tt>setThreadAllocatedMemoryEnabled()</tt> and <tt>isThreadAllocatedMemoryEnabled()</tt> methods do not throw the "UnsupportedOperationException" error now and are enabled by default.</td>
</tr>
<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/18717">#18717</td>
<td valign="top">JITServer technology is now a supported feature for Linux on AArch64.

 Linux on IBM Z&reg; systems are supported since version 0.32.0 and Linux on x86-64 and Linux on Power&reg; (Little Endian) are supported since version 0.29.0.</td>
<td valign="top">All versions (Linux on AArch64)</td>
<td valign="top">JITServer decouples the JIT compiler from the OpenJ9 VM, freeing up CPU and memory for an application. JITServer then runs in its own process, either locally or on a remote machine, where resources can be separately managed.</td>
</tr>

</tbody>
</table>

## Known issues

The v0.41.0 release contains the following known issues and limitations:

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1">
<thead align="left">
<tr>
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Platform</th>
<th valign="bottom">Impact</th>
<th valign="bottom">Workaround</th>
</tr>
</thead>

<tbody>
<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/15011">#15011</a></td>
<td valign="top">The default stack size for the main thread is a smaller platform-dependent value.</td>
<td valign="top">All</td>
<td valign="top">The main thread stack size was 1 MB in releases before 0.32. In the 0.32 release and later it was modified to a smaller
platform-dependent value, the same value as the <tt>-Xmso</tt> setting. The 0.33 release increased the default <tt>-Xmso</tt> stack size
on x64 platforms, but builds with OpenJDK 17 and later also require more stack space to run. These changes might result in a
<tt>java.lang.StackOverflowError: operating system stack overflow</tt>.</td>
<td valign="top">Use <tt>-Xmso</tt> to set the default stack size. See the default value by using <tt>-verbose:sizes</tt>.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/13767">#13767</a></td>
<td valign="top">Compressed references mode is not available.</td>
<td valign="top">Apple silicon macOS</td>
<td valign="top">You can use only the large heap (non-compressed references) mode.</td>
<td valign="top">None</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/14803">#14803</a></td>
<td valign="top">Using the <tt>-XX:+ShowHiddenFrames</tt> option in an OpenJ9 release that is built with OpenJDK 18 and later causes errors.</td>
<td valign="top">All platforms</td>
<td valign="top">Wrong exception might be thrown when using the Reflection API.</td>
<td valign="top">Avoid using the <tt>-XX:+ShowHiddenFrames</tt> option with OpenJDK 18 and later.</td>
</tr>

</tbody>
</table>

## Other changes

A full commit history for 0.41.0 release is available at [Eclipse OpenJ9 v0.41.0](https://github.com/eclipse-openj9/openj9/releases/tag/openj9-0.41.0).
