<!--
* Copyright (c) 2023 IBM Corp. and others
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which accompanies this distribution and is available at
* https://www.eclipse.org/legal/epl-2.0/ or the Apache
* License, Version 2.0 which accompanies this distribution and
* is available at https://www.apache.org/licenses/LICENSE-2.0.
*
* This Source Code may also be made available under the
* following Secondary Licenses when the conditions for such
* availability set forth in the Eclipse Public License, v. 2.0
* are satisfied: GNU General Public License, version 2 with
* the GNU Classpath Exception [1] and GNU General Public
* License, version 2 with the OpenJDK Assembly Exception [2].
*
* [1] https://www.gnu.org/software/classpath/license.html
* [2] https://openjdk.org/legal/assembly-exception.html
*
* SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
-->

# Eclipse OpenJ9 version 0.38.0 release notes

These release notes support the [Eclipse OpenJ9&trade; 0.38.0 release plan](https://projects.eclipse.org/projects/technology.openj9/releases/0.38.0/plan).

## Supported environments

OpenJ9 release 0.38.0 supports OpenJDK 8, 11, and 17.

All releases are tested against the OpenJ9 functional verification (FV) test suite, the OpenJDK test suites, and additional tests provided by Adoptium.

To learn more about support for OpenJ9 releases, including OpenJDK levels and platform support, see [Supported environments](https://eclipse.org/openj9/docs/openj9_support/index.html).

## Notable changes in this release

The following table covers notable changes in v0.38.0. Further information about these changes can be found in the [user documentation](https://eclipse.dev/openj9/docs/version0.38/).

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1"><thead align="left">
<tr>
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Version / Platform</th>
<th valign="bottom">Impact</th>
</tr>
</thead>
<tbody>


<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/16706">#16706</a></td>
<td valign="top">OpenJ9 Windows&reg; OpenJDK 8 builds now compile with Microsoft&reg; Visual Studio 2019.</td>
<td valign="top">OpenJDK 8 (Windows)</td>
<td valign="top">The Visual Studio redistributable files included with the build are updated to match.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/16532">#16532</a></td>
<td valign="top">Support for running OpenJDK 8 and OpenJDK 11 on CentOS 6.10 is deprecated and might be removed in a future release.</td>
<td valign="top">OpenJDK 8 and 11 (CentOS 6.10)</td>
<td valign="top">OpenJ9 no longer tests OpenJDK 11 on CentOS 6.10 after 0.36.1 release and might stop testing OpenJDK 8 in the future.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/16974">#16974</a></td>
<td valign="top">New <tt>-XX:[+|-]HandleSIGUSR2</tt> option is added to control the handling of the <tt>SIGUSR2</tt> signal by the VM signal handler.</td>
<td valign="top">All versions (All operating systems except Windows)</td>
<td valign="top">In the absence of signal chaining, the VM does not allow application signal handlers for certain signals that are used internally by the VM, including the <tt>SIGUSR2</tt> signal. You can use the <tt>-XX:-HandleSIGUSR2</tt> option instead, whereby the VM signal handler is not installed on VM startup. Therefore, the application signal handler, if available, takes over the handling of the <tt>SIGUSR2</tt> signal.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/orgs/eclipse-openj9/projects/1">Project 1</a></td>
<td valign="top">Checkpoint/Restore In Userspace (CRIU) support preview is available.</td>
<td valign="top">OpenJDK 11 and later (Linux&reg; x86, Linux on POWER&reg; (Little Endian), and Linux on IBM Z&reg;)</td>
<td valign="top">In OpenJ9, the CRIU support includes an API that you can use to stop the VM at a checkpoint, save its state, and then run the VM from the point where it was stopped instead of restarting from the beginning. The use of CRIU capabilities improves the VM startup time and hence, improves performance.</td>
</tr>

</tbody>
</table>

## Known issues

The v0.38.0 release contains the following known issues and limitations:

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1">
<thead align="left">
<tr>
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Platform</th>
<th valign="bottom">Impact</th>
<th valign="bottom">Workaround</th>
</tr>
</thead>

<tbody>
<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/15011">#15011</a></td>
<td valign="top">The default stack size is modified for the main thread.</td>
<td valign="top">All</td>
<td valign="top">The main thread stack size was 1 MB in releases prior to 0.32. In the 0.32 release and later it's modified to a smaller
platform-dependent value, the same value as the <tt>-Xmso</tt> setting. The 0.33 release increases the default <tt>-Xmso</tt> stack size
on x64 platforms, but builds with OpenJDK 17 and later also require more stack space to run. These changes might result in a
<tt>java.lang.StackOverflowError: operating system stack overflow</tt>.</td>
<td valign="top">Use <tt>-Xmso</tt> to set the default stack size. See the default value by using <tt>-verbose:sizes</tt>.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/13767">#13767</a></td>
<td valign="top">Compressed references mode is not available.</td>
<td valign="top">Apple silicon macOS</td>
<td valign="top">You can use only the large heap (non-compressed references) mode.</td>
<td valign="top">None</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/14803">#14803</a></td>
<td valign="top">Using the <tt>-XX:+ShowHiddenFrames</tt> option in an OpenJ9 release that is built with OpenJDK 18 and later causes errors.</td>
<td valign="top">All platforms</td>
<td valign="top">Wrong exception might be thrown when using the Reflection API.</td>
<td valign="top">Avoid using the <tt>-XX:+ShowHiddenFrames</tt> option with OpenJDK 18 and later.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-omr/omr/pull/6432">#6432</a></td>
<td valign="top">If you mount the <tt>/proc</tt> file system with the <tt>hidepid=2</tt> option on Linux systems and the VM does not have root privileges, it cannot access the <tt>/proc/1/cgroup</tt> file and the container detection fails.</td>
<td valign="top">All versions (Linux)</td>
<td valign="top">The VM fails to start when the container detection code cannot access the <tt>/proc/1/cgroup</tt> file.</td>
<td valign="top">Remount the <tt>/proc</tt> file system with the <tt>hidepid=0</tt> option or remount the <tt>/proc</tt> file system with the <tt>gid</tt> option to allow users in a certain group to access the <tt>/proc</tt> file system.</td>
</tr>

</tbody>
</table>

## Other changes

A full commit history for 0.38.0 release is available at [Eclipse OpenJ9 v0.38.0](https://github.com/eclipse-openj9/openj9/releases/tag/openj9-0.38.0).
