<!--
* Copyright IBM Corp. and others 2023
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which accompanies this distribution and is available at
* https://www.eclipse.org/legal/epl-2.0/ or the Apache
* License, Version 2.0 which accompanies this distribution and
* is available at https://www.apache.org/licenses/LICENSE-2.0.
*
* This Source Code may also be made available under the
* following Secondary Licenses when the conditions for such
* availability set forth in the Eclipse Public License, v. 2.0
* are satisfied: GNU General Public License, version 2 with
* the GNU Classpath Exception [1] and GNU General Public
* License, version 2 with the OpenJDK Assembly Exception [2].
*
* [1] https://www.gnu.org/software/classpath/license.html
* [2] https://openjdk.org/legal/assembly-exception.html
*
* SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
-->

# Eclipse OpenJ9 version 0.37.0 release notes

These release notes support the [Eclipse OpenJ9&trade; 0.37.0 release plan](https://projects.eclipse.org/projects/technology.openj9/releases/0.37.0/plan).

## Supported environments

OpenJ9 release 0.37.0 works with OpenJDK 19. OpenJDK 19 is out of support at the time of the 0.37.0 release. Builds of 0.37.0 should not be used in production and might contain known security vulnerabilities as of 18 April 2023.

All releases are tested against the OpenJ9 functional verification (FV) test suite, the OpenJDK test suites, and additional tests provided by Adoptium.

For a list of JDK Enhancement Proposals (JEP) that are supported by or implemented in OpenJ9, see the [release topic](https://eclipse.org/openj9/docs/version0.37/#new-jdk-19-features) in the user documentation.

To learn more about support for OpenJ9 releases, including OpenJDK levels and platform support, see [Supported environments](https://eclipse.org/openj9/docs/openj9_support/index.html).

## Notable changes in this release

The following table covers notable changes in v0.37.0. Further information about these changes can be found in the [user documentation](https://eclipse.dev/openj9/docs/version0.37/).

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1"><thead align="left">
<tr>
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Version / Platform</th>
<th valign="bottom">Impact</th>
</tr>
</thead>
<tbody>


<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/16581">#16581</a></td>
<td valign="top">AIX&reg; is now built on AIX 7.2 TL5.</td>
<td valign="top">All versions (AIX)</td>
<td valign="top">All AIX compiles are now moved from AIX 7.1 TL5 to AIX 7.2 TL5.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/16703">#16703</a></td>
<td valign="top">Linux&reg; reference compiler is updated to gcc 11.2.</td>
<td valign="top">OpenJDK 19 and later (Linux x86 64-bit, Linux on POWER LE 64-bit, and Linux on IBM Z 64-bit)</td>
<td valign="top"> Linux builds for platforms Linux x86 64-bit, Linux on POWER LE 64-bit, and Linux on IBM Z 64-bit now use gcc 11.2 instead of gcc 10.3. Linux AArch64 64-bit continues to use the gcc 10.3 compiler.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/16698">#16698</a></td>
<td valign="top">Support is added for the <tt>com.sun.management.ThreadMXBean</tt> interface.</td>
<td valign="top">All versions</td>
<td valign="top">The OpenJ9 <a href="https://eclipse.dev/openj9/docs/api-langmgmt/"><tt>ThreadMXbean</tt></a> interface (<tt>com.ibm.lang.management.ThreadMXBean</tt>) was extending the <a href="https://docs.oracle.com/javase/8/docs/api/java/lang/management/ThreadMXBean.html"><tt>java.lang.management.ThreadMXBean</tt></a> interface. With this release, the OpenJ9 <tt>ThreadMXBean</tt> interface extends the <a href="https://docs.oracle.com/javase/8/docs/jre/api/management/extension/com/sun/management/ThreadMXBean.html"><tt>com.sun.management.ThreadMXBean</tt></a> interface, whereby it now contains all the methods of the <tt>java.lang.management.ThreadMXBean</tt> interface with additional methods from the <tt>com.sun.management.ThreadMXBean</tt> interface.</td>
</tr>
<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/16705">#16705</a></td>
<td valign="top">OpenJ9 Windows&reg; builds for OpenJDK 19 and later are now compiled with Microsoft&reg; Visual Studio 2022.</td>
<td valign="top">OpenJDK 19 and later (Windows)</td>
<td valign="top">The Visual Studio redistributable files included with the build are updated to match.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/ibmruntimes/openj9-openjdk-jdk/pull/547">#547</a></td>
<td valign="top">Support for PKCS#11 token labels is added on Linux on IBM Z&reg;.</td>
<td valign="top">OpenJDK 11 and later (Linux on IBM Z)</td>
<td valign="top">On restarting an application, or creating or removing of tokens, the token might move to a different slot. An application that uses the <tt>slot</tt> or <tt>slotListIndex</tt> attributes might fail if it doesn’t first check which slot the token is in.

 OpenJ9 now supports the use of an extra attribute, <tt>tokenlabel</tt>, in the SunPKCS11 configuration file on Linux on IBM Z, which helps to avoid this issue.</td>
</tr>

</tbody>
</table>

## Known issues

The v0.37.0 release contains the following known issues and limitations:

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1">
<thead align="left">
<tr>
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Platform</th>
<th valign="bottom">Impact</th>
<th valign="bottom">Workaround</th>
</tr>
</thead>

<tbody>
<tr>
<td valign="top">N/A</td>
<td valign="top">OpenJDK 19 is out of support at the time of the 0.37.0 release.</td>
<td valign="top">All</td>
<td valign="top">Builds of 0.37.0 should not be used in production and might contain known security vulnerabilities as of 18 April 2023. Known and reported problems will be resolved in builds supporting OpenJDK 20 or later.</td>
<td valign="top">Use builds supporting OpenJDK 20 or later when they are available.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/15011">#15011</a></td>
<td valign="top">The default stack size is modified for the main thread.</td>
<td valign="top">All</td>
<td valign="top">The main thread stack size was 1 MB in releases prior to 0.32. In the 0.32 release and later it's modified to a smaller
platform-dependent value, the same value as the <tt>-Xmso</tt> setting. The 0.33 release increases the default <tt>-Xmso</tt> stack size
on x64 platforms, but builds with OpenJDK 17 and later also require more stack space to run. These changes might result in a
<tt>java.lang.StackOverflowError: operating system stack overflow</tt>.</td>
<td valign="top">Use <tt>-Xmso</tt> to set the default stack size. See the default value by using <tt>-verbose:sizes</tt>.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/13767">#13767</a></td>
<td valign="top">Compressed references mode is not available.</td>
<td valign="top">Apple silicon macOS</td>
<td valign="top">You can use only the large heap (non-compressed references) mode.</td>
<td valign="top">None</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/14803">#14803</a></td>
<td valign="top">Using the <tt>-XX:+ShowHiddenFrames</tt> option in an OpenJ9 release that is built with OpenJDK 18 and later causes errors.</td>
<td valign="top">All platforms</td>
<td valign="top">Wrong exception might be thrown when using the Reflection API.</td>
<td valign="top">Avoid using the <tt>-XX:+ShowHiddenFrames</tt> option with OpenJDK 18 and later.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/16728">#16728</a></td>
<td valign="top">Virtual threads might cause slowness and an error under heavy workloads.</td>
<td valign="top">All platforms</td>
<td valign="top">Native OOM error, heap OOM error and performance regression might be seen when an application is scaled to 1 million or more virtual threads.</td>
<td valign="top">Use <tt>-Xnocompressedrefs</tt> to mitigate the native OOM error. Increase <tt>-Xmx</tt> to mitigate the heap OOM error. Both options will also help mitigate the slowness.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/17163">#17163</a>, <a href=https://github.com/eclipse-openj9/openj9/issues/17181>#17181</a></td>
<td valign="top">Virtual threads might trigger an error under heavy workloads.</td>
<td valign="top">All platforms</td>
<td valign="top">The error might manifest either as an assertion or hang under heavy workload of virtual threads.</td>
<td valign="top">Use a different GC policy to mitigate these errors.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/17119">#17119</a>, <a href=https://github.com/eclipse-openj9/openj9/issues/17120>#17120</a></td>
<td valign="top">Virtual threads might trigger an exception.</td>
<td valign="top">All platforms</td>
<td valign="top">IllegalMonitorStateException might be thrown while trying to release a ReentrantLock.</td>
<td valign="top">Disable JIT inlining to mitigate this exception.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/16756">#16756</a></td>
<td valign="top">Virtual threads might trigger a failure.</td>
<td valign="top">All platforms</td>
<td valign="top">A rare segmentation fault might occur due to corruption in the Java stack of a virtual thread's carrier thread.</td>
<td valign="top">None.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-omr/omr/pull/6432">#6432</a></td>
<td valign="top">If you mount the <tt>/proc</tt> file system with the <tt>hidepid=2</tt> option on Linux systems and the VM does not have root privileges, it cannot access the <tt>/proc/1/cgroup</tt> file and the container detection fails.</td>
<td valign="top">All versions (Linux)</td>
<td valign="top">The VM fails to start when the container detection code cannot access the <tt>/proc/1/cgroup</tt> file.</td>
<td valign="top">Remount the <tt>/proc</tt> file system with the <tt>hidepid=0</tt> option or remount the <tt>/proc</tt> file system with the <tt>gid</tt> option to allow users in a certain group to access the <tt>/proc</tt> file system.</td>
</tr>

</tbody>
</table>

## Other changes

A full commit history for 0.37.0 release is available at [Eclipse OpenJ9 v0.37.0](https://github.com/eclipse-openj9/openj9/releases/tag/openj9-0.37.0).
