<!--
* Copyright IBM Corp. and others 2022
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which accompanies this distribution and is available at
* https://www.eclipse.org/legal/epl-2.0/ or the Apache
* License, Version 2.0 which accompanies this distribution and
* is available at https://www.apache.org/licenses/LICENSE-2.0.
*
* This Source Code may also be made available under the
* following Secondary Licenses when the conditions for such
* availability set forth in the Eclipse Public License, v. 2.0
* are satisfied: GNU General Public License, version 2 with
* the GNU Classpath Exception [1] and GNU General Public
* License, version 2 with the OpenJDK Assembly Exception [2].
*
* [1] https://www.gnu.org/software/classpath/license.html
* [2] https://openjdk.org/legal/assembly-exception.html
*
* SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
-->

# Eclipse OpenJ9 version 0.35.0 release notes

These release notes support the [Eclipse OpenJ9 0.35.0 release plan](https://projects.eclipse.org/projects/technology.openj9/releases/0.35.0/plan).

## Supported environments

OpenJ9 release 0.35.0 supports OpenJDK 8, 11, 17.

All releases are tested against the OpenJ9 functional verification (FV) test suite, the OpenJDK test suites, and additional tests provided by Adoptium.

To learn more about support for OpenJ9 releases, including OpenJDK levels and platform support, see [Supported environments](https://eclipse.org/openj9/docs/openj9_support/index.html).

## Notable changes in this release

The following table covers notable changes in v0.35.0. Further information about these changes can be found in the [user documentation](https://eclipse.dev/openj9/docs/version0.35/).

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1"><thead align="left">
<tr>
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Version / Platform</th>
<th valign="bottom">Impact</th>
</tr>
</thead>
<tbody>

<tr><td valign="top">N/A</td>
<td valign="top">Apple silicon macOS&reg; is now a fully supported, production-ready target</td>
<td valign="top">OpenJDK 11 and later (Apple silicon macOS) </td>
<td valign="top">The remaining features, performance items, and bug fixes are implemented, making AArch64 (Apple silicon) macOS a production-ready target.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/15555">#15555</a></td>
<td valign="top"> Java&trade; dump output contains a new <tt>Initializing thread: &ltthread_name&gt</tt> string in the existing <tt>3XMTHREADBLOCK</tt> line.</td>
<td valign="top">All versions</td>
<td valign="top">For threads that are waiting for a class initialization lock, the Java dump output now shows the thread that is currently working to progress the initialization of the class.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/15636">#15636</a></td>
<td valign="top"> New <tt>user2</tt> event added for the <tt>-Xdump</tt> option</td>
<td valign="top">All versions (All operating systems except Windows&trade;)</td>
<td valign="top">On operating systems other than Windows, you can now use the <tt>user2</tt> event for the <tt>-Xdump</tt> option. The <tt>user2</tt> event is commonly used for taking system dump files with exclusive access without overriding the <tt>user</tt> event, which is generally left for taking Java dump files for performance investigations. </td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/14157">#14157</a></td>
<td valign="top">New <tt>-XX:[+|-]PerfTool</tt> option added</td>
<td valign="top">All versions (Linux&reg;)</td>
<td valign="top">This option enables or disables the JIT support for the <tt>perf</tt> tool without affecting the existing <tt>-Xjit</tt> options.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/15444">#15444</a></td>
<td valign="top">New default options added in the <tt>options.default</tt> file</td>
<td valign="top">All versions</td>
<td valign="top">Objects that are created from classes <tt>Thread</tt> and <tt>Class</tt> are allocated in the tenure region directly and therefore, do not get moved by the garbage collector often. It takes time for such pre-tenured objects to get hashed and extended with a slot. To pre-hash those objects from the start and hence, improve performance, <tt>-XX:+EnsureHashed:java/lang/Class,java/lang/Thread</tt> is added to the list of default options in the <tt>options.default</tt> file.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/15217">#15217</a></td>
<td valign="top"> New options, <tt>-XX:JITServerMetricsSSLKey</tt> and <tt>-XX:JITServerMetricsSSLCert</tt>, added for encrypting the custom metrics with SSL or TLS</td>
<td valign="top">All versions (Linux)</td>
<td valign="top">These options specify the names of the files that contain the private TLS or SSL key and certificate that are used for authentication and encryption of the custom metrics.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/15505">#15505</a></td>
<td valign="top"><tt>-XX:[+|-]JITServerLocalSyncCompiles</tt> enabled </td>
<td valign="top">All versions (Linux)</td>
<td valign="top">This option is now enabled in most cases to reduce the latency of the compilations that are performed synchronously. The option remains disabled when you specify <tt>-Xjit:count=0</tt> and in a few advanced use cases such as running the JVM in debug mode.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-omr/omr/pull/6432">#6432</a></td>
<td valign="top">If you mount the <tt>/proc</tt> file system with the <tt>hidepid=2</tt> option on Linux systems and the VM does not have root privileges, it cannot access the <tt>/proc/1/cgroup</tt> file and the container detection fails.</td>
<td valign="top">All versions (Linux)</td>
<td valign="top">The VM fails to start when the container detection code cannot access the <tt>/proc/1/cgroup</tt> file.</td>
<td valign="top">Remount the <tt>/proc</tt> file system with the <tt>hidepid=0</tt> option or remount the <tt>/proc</tt> file system with the <tt>gid</tt> option to allow users in a certain group to access the <tt>/proc</tt> file system.</td>
</tr>

</tbody>
</table>

## Known issues

The v0.35.0 release contains the following known issues and limitations:

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1">
<thead align="left">
<tr>
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Platform</th>
<th valign="bottom">Impact</th>
<th valign="bottom">Workaround</th>
</tr>
</thead>

<tbody>
<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/15011">#15011</a></td>
<td valign="top">The default stack size is modified for the main thread</td>
<td valign="top">All</td>
<td valign="top">The main thread stack size was 1 MB in releases prior to 0.32. In the 0.32 release and later it's modified to a smaller
platform-dependent value, the same value as the <tt>-Xmso</tt> setting. The 0.33 release increases the default <tt>-Xmso</tt> stack size
on x64 platforms, but builds with OpenJDK 17 and later also require more stack space to run. These changes might result in a
<tt>java.lang.StackOverflowError: operating system stack overflow</tt>.</td>
<td valign="top">Use <tt>-Xmso</tt> to set the default stack size. See the default value by using <tt>-verbose:sizes</tt>.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/13767">#13767</a></td>
<td valign="top">Compressed references mode is not available</td>
<td valign="top">Apple silicon macOS</td>
<td valign="top">You can use only the large heap (non-compressed references) mode.</td>
<td valign="top">None</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/14803">#14803</a></td>
<td valign="top">Using the <tt>-XX:+ShowHiddenFrames</tt> option in an OpenJ9 release that is built with OpenJDK 18 and later causes errors due to underlying problems in OpenJDK</td>
<td valign="top">All platforms</td>
<td valign="top">Wrong exception might be thrown when using the Reflection API.</td>
<td valign="top">Avoid using the <tt>-XX:+ShowHiddenFrames</tt> option with OpenJDK 18 and later.</td>
</tr>

</tbody>
</table>

## Other changes

A full commit history for this release is available at [Eclipse OpenJ9 v0.35.0](https://github.com/eclipse-openj9/openj9/releases/tag/openj9-0.35.0).
