<!--
* Copyright IBM Corp. and others 2021
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which accompanies this distribution and is available at
* https://www.eclipse.org/legal/epl-2.0/ or the Apache
* License, Version 2.0 which accompanies this distribution and
* is available at https://www.apache.org/licenses/LICENSE-2.0.
*
* This Source Code may also be made available under the
* following Secondary Licenses when the conditions for such
* availability set forth in the Eclipse Public License, v. 2.0
* are satisfied: GNU General Public License, version 2 with
* the GNU Classpath Exception [1] and GNU General Public
* License, version 2 with the OpenJDK Assembly Exception [2].
*
* [1] https://www.gnu.org/software/classpath/license.html
* [2] https://openjdk.org/legal/assembly-exception.html
*
* SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
-->

# Eclipse OpenJ9 version 0.27.0 release notes

These release notes support the [Eclipse OpenJ9 0.27.0 release plan](https://projects.eclipse.org/projects/technology.openj9/releases/0.27.0/plan).

## Supported environments

OpenJ9 release 0.27.0 supports OpenJDK 8, 11, and 16.

All releases are tested against the OpenJ9 functional verification (FV) test suite, the OpenJDK test suites, and additional tests at AdoptOpenJDK.

To learn more about support for OpenJ9 releases, including OpenJDK levels and platform support, see [Supported environments](https://eclipse.org/openj9/docs/openj9_support/index.html).

## Notable changes in this release

The following table covers notable changes in v0.27.0. Further information about these changes can be found in the [user documentation](https://eclipse.dev/openj9/docs/version0.27/).

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1"><thead align="left">
<tr valign="bottom">
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Version / Platform</th>
<th valign="bottom">Impact</th>
</tr>
</thead>
<tbody>

<tr><td valign="top">
<a href="https://github.com/eclipse-openj9/openj9/issues/11999">#11999</a></td>
<td valign="top">New <strong>-XX:[+|-]AdaptiveGCThreading</strong> option added</td>
<td valign="top">All versions</td>
<td valign="top">Adaptive threading is enabled by default, which automatically tunes the number of active parallel garbage collection (GC) threads.</td>
</tr>

<tr><td valign="top">
<a href="https://github.com/eclipse-openj9/openj9/pull/12437">#12437</a></td>
<td valign="top">Improved time zone information added to Java dump files</td>
<td valign="top">All versions</td>
<td valign="top">Two new fields are included, the date and time in UTC (<strong>1TIDATETIMEUTC</strong>) and the time zone according to the local system (<strong>1TITIMEZONE</strong>).</td>
</tr>

<tr><td valign="top">
<a href="https://github.com/eclipse-openj9/openj9/issues/7552">#7552</a></td>
<td valign="top">New default garbage collection (GC) scan ordering mode for the <tt>balanced</tt> policy</td>
<td valign="top">All versions</td>
<td valign="top">For performance improvements, GC copy forward operations in the <tt>balanced</tt> policy now use <i>dynamic breadth first scan mode</i>. To revert to the behavior in earlier releases, set <tt>-Xgc:breadthFirstScanOrdering</tt> on the command line when you start your application.</td>
</tr>

<tr><td valign="top">
<a href="https://github.com/eclipse-openj9/openj9/pull/12810">#12810</a></td>
<td valign="top">Stop parsing the <tt>JAVA_OPTIONS</tt> environment variable</td>
<td valign="top">All versions</td>
<td valign="top">The 0.24 release started parsing the <tt>JAVA_OPTIONS</tt> environment variable. This variable was added in error and has been removed.
The <tt>_JAVA_OPTIONS</tt> environment variable (with different behavior) is added for compatibility.</td>
</tr>

<tr><td valign="top">
<a href="https://github.com/eclipse-openj9/openj9/pull/12501">#12501</a></td>
<td valign="top">Increase operating system stack size on PPC64 platforms</td>
<td valign="top">All JDK versions, AIX and Linux PPC64</td>
<td valign="top">The increased stack size leaves more room to store vector registers for internal linkage conventions. Note: This change increases the overall memory usage of the VM. You can change the stack size by using the -Xmso option.</td>
</tr>

<tr><td valign="top">
<a href="https://github.com/eclipse-openj9/openj9/issues/12125">#12125</a></td>
<td valign="top">Global lock reservation is now enabled by default on Power</td>
<td valign="top">AIX and Linux on Power</td>
<td valign="top">Global lock reservation is now enabled by default on Power. This is an optimization targeted towards more efficient handling of locking and unlocking Java&trade; objects. The older locking behavior can be restored via the <tt>-XX:-GlobalLockReservation</tt> option.</td>
</tr>

<tr><td valign="top">
<a href="https://github.com/eclipse-openj9/openj9/issues/13194">#13194</a></td>
<td valign="top">New option recognized by <tt>jpackcore</tt> / <tt>jextract</tt></td>
<td valign="top">All versions</td>
<td valign="top">The new option, <tt>-x</tt>, causes the system dump to be omitted from the archive created. In its place, the file <tt>excluded-files.txt</tt> is added which names the excluded file.</td>
</tr>

</tbody>
</table>

## Known Issues

The v0.27.0 release contains the following known issues and limitations:

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1">
<thead align="left">
<tr valign="bottom">
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Platform</th>
<th valign="bottom">Impact</th>
<th valign="bottom">Workaround</th>
</tr>
</thead>
<tbody>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/8034">#8034</a></td>
<td valign="top">Balanced garbage collection policy not supported</td>
<td valign="top">Linux on 64-bit ARM (AArch64)</td>
<td valign="top">The Balanced GC policy cannot be used. </td>
<td valign="top">Use an alternative GC policy, such as <tt>gencon</tt>.</td>
</tr>

</tbody>
</table>

## Other changes

A full commit history for this release is available at [Eclipse OpenJ9 v0.27.0](https://github.com/eclipse-openj9/openj9/releases/tag/openj9-0.27.0).
