<!--
* Copyright IBM Corp. and others 2020
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which accompanies this distribution and is available at
* https://www.eclipse.org/legal/epl-2.0/ or the Apache
* License, Version 2.0 which accompanies this distribution and
* is available at https://www.apache.org/licenses/LICENSE-2.0.
*
* This Source Code may also be made available under the
* following Secondary Licenses when the conditions for such
* availability set forth in the Eclipse Public License, v. 2.0
* are satisfied: GNU General Public License, version 2 with
* the GNU Classpath Exception [1] and GNU General Public
* License, version 2 with the OpenJDK Assembly Exception [2].
*
* [1] https://www.gnu.org/software/classpath/license.html
* [2] https://openjdk.org/legal/assembly-exception.html
*
* SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
-->

# Eclipse OpenJ9 version 0.26.0 release notes

These release notes support the [Eclipse OpenJ9 0.26.0 release plan](https://projects.eclipse.org/projects/technology.openj9/releases/0.26.0/plan).

## Supported environments

OpenJ9 release 0.26.0 supports OpenJDK 8, 11, and 16.

All releases are tested against the OpenJ9 functional verification (FV) test suite, the OpenJDK test suites, and additional tests at AdoptOpenJDK.

To learn more about support for OpenJ9 releases, including OpenJDK levels and platform support, see [Supported environments](https://eclipse.org/openj9/docs/openj9_support/index.html).


## Notable changes in this release

The following table covers notable changes in v0.26.0. Further information about these changes can be found in the [user documentation](https://eclipse.dev/openj9/docs/version0.26/).

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1"><thead align="left">
<tr valign="bottom">
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Version / Platform</th>
<th valign="bottom">Impact</th>
</tr>
</thead>
<tbody>

<tr><td valign="top">
<a href="https://github.com/eclipse-openj9/openj9/issues/11278">#11278</a></td>
<td valign="top">The <strong>jextract</strong> tool is deprecated</td>
<td valign="top">All versions</td>
<td valign="top">The dump extractor tool, <strong>jextract</strong>, is deprecated in this release and is replaced by the <strong>jpackcore</strong> tool. The <strong>jpackcore</strong> tool uses the same syntax and takes the same parameters.</td>
</tr>

</table>

**Note:** Eclipse OpenJ9 v0.25.0 supports OpenJDK 16. However, changes introduced in this release might also affect OpenJDK 8 and OpenJDK 11. To learn more about these changes see the [OpenJ9 V0.25.0 release notes](https://github.com/eclipse-openj9/openj9/blob/master/doc/release-notes/0.25/0.25.md).

## Known Issues

The v0.26.0 release contains the following known issues and limitations:

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1">
<thead align="left">
<tr valign="bottom">
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Platform</th>
<th valign="bottom">Impact</th>
<th valign="bottom">Workaround</th>
</tr>
</thead>
<tbody>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/8034">#8034</a></td>
<td valign="top">Balanced garbage collection policy not supported</td>
<td valign="top">Linux on 64-bit ARM (AArch64)</td>
<td valign="top">The Balanced GC policy cannot be used. </td>
<td valign="top">Use an alternative GC policy, such as <tt>gencon</tt>.</td>
</tr>

</tbody>
</table>

## Other changes

A full commit history for this release is available at [Eclipse OpenJ9 v0.26.0](https://github.com/eclipse-openj9/openj9/releases/tag/openj9-0.26.0).
