<!--
* Copyright IBM Corp. and others 2020
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which accompanies this distribution and is available at
* https://www.eclipse.org/legal/epl-2.0/ or the Apache
* License, Version 2.0 which accompanies this distribution and
* is available at https://www.apache.org/licenses/LICENSE-2.0.
*
* This Source Code may also be made available under the
* following Secondary Licenses when the conditions for such
* availability set forth in the Eclipse Public License, v. 2.0
* are satisfied: GNU General Public License, version 2 with
* the GNU Classpath Exception [1] and GNU General Public
* License, version 2 with the OpenJDK Assembly Exception [2].
*
* [1] https://www.gnu.org/software/classpath/license.html
* [2] https://openjdk.org/legal/assembly-exception.html
*
* SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
-->

# Eclipse OpenJ9 version 0.21.0 release notes

These release notes support the [Eclipse OpenJ9 0.21.0 release plan](https://projects.eclipse.org/projects/technology.openj9/releases/0.21.0/plan).

## Binaries and supported environments

OpenJ9 release 0.21.0 supports OpenJDK 8, 11, and 14.

Binaries are available at the AdoptOpenJDK project:

- [OpenJDK 8 with OpenJ9](https://adoptopenjdk.net/archive.html?variant=openjdk8&jvmVariant=openj9)
- [OpenJDK 11 with OpenJ9](https://adoptopenjdk.net/archive.html?variant=openjdk11&jvmVariant=openj9)
- [OpenJDK 14 with OpenJ9](https://adoptopenjdk.net/archive.html?variant=openjdk14&jvmVariant=openj9)

All builds are tested against the OpenJ9 functional verification (FV) test suite, the OpenJDK test suites, and additional tests at AdoptOpenJDK.

To learn more about support for OpenJ9 releases, including OpenJDK levels and platform support, see [Supported environments](https://eclipse.org/openj9/docs/openj9_support/index.html).


## Notable changes in this release

The following table covers notable changes in v0.21.0. Further information about these changes can be found in the [user documentation](https://eclipse.dev/openj9/docs/version0.21/).

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1"><thead align="left">
<tr valign="bottom">
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Version / Platform</th>
<th valign="bottom">Impact</th>
</tr>
</thead>
<tbody>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/9610">#9610</a></td>
<td valign="top">New option that affects the handling of the SIGABRT signal</td>
<td valign="top">OpenJDK8 and later</td>
<td valign="top">By default, the OpenJ9 VM handles SIGABRT signals and generates dump files. A new option is available to force OpenJ9 to match the
reference implementation, where the signal is handled by the default operating system handler. To match the reference implementation, set <tt>-XX:-HandleSIGABRT</tt>.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/9567">#9567</a></td>
<td valign="top">New option <tt>-XX:[+|-]PrintFlagsFinal</tt> for compatibility with the reference implementation</td>
<td valign="top">OpenJDK8 and later</td>
<td valign="top">This option provides output that lists configuration parameters for the OpenJ9 VM, such as the maximum heap size setting. The
implementation is currently incomplete and provides output on only a subset of configuration parameters.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/9676">#9676</a></td>
<td valign="top">macOS shared libraries version updated</td>
<td valign="top">OpenJDK8 and later (macOS&reg; only)</td>
<td valign="top">The version information for shared libraries on macOS has been updated from 0.0.0 to 1.0.0. If an application has linked against a shared library from a previous OpenJ9 release, it needs to be re-linked against the new release.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/9588">#9588</a></td>
<td valign="top">Change to the output of the <tt>NoClassDefFoundError</tt> exception message to match the reference implementation</td>
<td valign="top">OpenJDK8 and later</td>
<td valign="top">The order in which class names are printed now matches the reference implementation.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9-docs/pull/583">#583</a></td>
<td valign="top">API reference documentation</td>
<td valign="top">OpenJDK8 and OpenJDK 11</td>
<td valign="top">API reference documentation for the OpenJ9 VM is now available in the <a href="https://eclipse.dev/openj9/docs/api-overview/">user documentation</a>.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/8762">#8762</a> <a href="https://github.com/eclipse-openj9/openj9/issues/5917">#5917</a> <a href="https://github.com/eclipse-openj9/openj9/issues/6607">#6607</a> <a href="https://github.com/eclipse-openj9/openj9/issues/8966">#8966</a> <a href="https://github.com/eclipse-openj9/openj9/issues/9003">#9003</a> <a href="https://github.com/eclipse-openj9/openj9/issues/9251">#9251</a></td>
<td valign="top">Issue resolution</td>
<td valign="top">OpenJDK 11 (Linux on 64-bit ARM (AArch64))</td>
<td valign="top">The following issues that were recorded for this platform in earlier release notes are fixed: Concurrent Scavenge mode is supported,
JIT dynamic loop transfer and recompilation are supported, AOT is now used by default, and problems reading system dumps are now resolved.</td>
</tr>

</table>


## Known Issues

The v0.21.0 release contains the following known issues and limitations:

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1">
<thead align="left">
<tr valign="bottom">
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Platform</th>
<th valign="bottom">Impact</th>
<th valign="bottom">Workaround</th>
</tr>
</thead>
<tbody>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/8034">#8034</a></td>
<td valign="top">Balanced garbage collection policy not supported</td>
<td valign="top">Linux on 64-bit ARM (AArch64)</td>
<td valign="top">The Balanced GC policy cannot be used. </td>
<td valign="top">Use an alternative GC policy, such as <tt>gencon</tt>.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/479">#479</a></td>
<td valign="top">Non-compressed references VM builds not available</td>
<td valign="top">AIX</td>
<td valign="top">Non-compressed references VM builds, which support heaps larger than 57GB, are built on Linux, Windows, and macOS. </td>
<td valign="top">Manual builds on other platforms are possible by following our <a href="https://github.com/eclipse-openj9/openj9/blob/master/buildenv/Build_Instructions_V8.md">detailed build instructions</a>.</td>
</tr>

</tbody>
</table>


## Other changes

A full commit history for this release is available at [Eclipse OpenJ9 v0.21.0](https://github.com/eclipse-openj9/openj9/releases/tag/openj9-0.21.0).
