<!--
* Copyright IBM Corp. and others 2019
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which accompanies this distribution and is available at
* https://www.eclipse.org/legal/epl-2.0/ or the Apache
* License, Version 2.0 which accompanies this distribution and
* is available at https://www.apache.org/licenses/LICENSE-2.0.
*
* This Source Code may also be made available under the
* following Secondary Licenses when the conditions for such
* availability set forth in the Eclipse Public License, v. 2.0
* are satisfied: GNU General Public License, version 2 with
* the GNU Classpath Exception [1] and GNU General Public
* License, version 2 with the OpenJDK Assembly Exception [2].
*
* [1] https://www.gnu.org/software/classpath/license.html
* [2] https://openjdk.org/legal/assembly-exception.html
*
* SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
-->

# Eclipse OpenJ9 version 0.18.0 release notes

These release notes support the [Eclipse OpenJ9 0.18.0 release plan](https://projects.eclipse.org/projects/technology.openj9/releases/0.18.0/plan).

## Binaries and supported environments

OpenJ9 release 0.18.0 supports OpenJDK 8, 11, and 13.

Binaries are available at the AdoptOpenJDK project:

- [OpenJDK 8 with OpenJ9](https://adoptopenjdk.net/archive.html?variant=openjdk8&jvmVariant=openj9)
- [OpenJDK 11 with OpenJ9](https://adoptopenjdk.net/archive.html?variant=openjdk11&jvmVariant=openj9)
- [OpenJDK 13 with OpenJ9](https://adoptopenjdk.net/archive.html?variant=openjdk13&jvmVariant=openj9)

All builds are tested against the OpenJ9 functional verification (FV) test suite, the OpenJDK test suites, and additional tests at AdoptOpenJDK.

To learn more about support for OpenJ9 releases, including OpenJDK levels and platform support, see [Supported environments](https://eclipse.org/openj9/docs/openj9_support/index.html).


## Notable changes in this release

The following table covers notable changes in v0.18.0. Further information about these changes can be found in the [user documentation](https://eclipse.dev/openj9/docs/version0.18/).

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1"><thead align="left">
<tr valign="bottom">
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Version / Platform</th>
<th valign="bottom">Impact</th>
</tr>
</thead>
<tbody>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/7841">#7841</a></td>
<td valign="top">JITServer technology preview available</td>
<td valign="top">OpenJDK8 and 11 (Linux x86-64 only)</td>
<td valign="top">JITServer decouples the JIT compiler from the OpenJ9 VM, freeing up CPU and memory for an application. JITServer then runs in its own process, either locally or on a remote machine where resources can be separately managed.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/7197">#7197</a></td>
<td valign="top"><tt>jextract</tt> is now available on macOS systems</td>
<td valign="top">OpenJDK8 and later</td>
<td valign="top">Support for the <tt>jextract tool</tt> is now available on macOS platforms in addition to AIX and Linux.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/7575">#7575</a></td>
<td valign="top">Timestamp checking of shared classes can be turned off</td>
<td valign="top">OpenJDK8 and later</td>
<td valign="top">The <tt>-Xshareclasses:noTimestampChecks</tt> suboption instructs the VM not to check the timestamps of shared classes, which can improve performance. This option is previously undocumented.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/7304">#7304</a></td>
<td valign="top">New minimum value for the <tt>-Xmso</tt> option</td>
<td valign="top">OpenJDK8 and later (64-bit z/OS only)</td>
<td valign="top">To match the minimum stack space provided by z/OS, the minimum value for the <tt>-Xmso</tt> option is now 1 MB. A value lower than 1 MB is ignored.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/7240">#7240</a></td>
<td valign="top">New <tt>jstat</tt> tool for monitoring Java statistics</td>
<td valign="top">OpenJDK8 and later</td>
<td valign="top">For compatibility with the HotSpot implementation, OpenJ9 now includes an independent implementation of the <tt>jstat</tt> tool for retrieving statistics on a VM.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/7665">#7665</a></td>
<td valign="top">Extended platform support for the <tt>-XX:+TransparentHugePage</tt> option</td>
<td valign="top">OpenJDK8 and later (Linux on POWER and IBM Z)</td>
<td valign="top">Platform support for the <tt>-XX:+TransparentHugePage</tt> option is now extended to Linux on POWER and Linux on IBM Z. This option takes affect only when Transparent Huge Pages (THP) is set to <tt>madvise</tt> on your system and might increase your application footprint.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/7406">#7406</a></td>
<td valign="top">New <tt>exit</tt> dump agent and <tt>-XX:[+|-]ExitOnOutOfMemoryError</tt> option</td>
<td valign="top">OpenJDK8 and later</td>
<td valign="top">The new <tt>exit</tt> dump agent saves information on the state of the VM when the VM shuts down, which can help you diagnose problems. For compatibility, OpenJ9 also supports the HotSpot option <tt>-XX:[+|-]ExitOnOutOfMemoryError</tt>. This option shuts down the VM when a <tt>java.lang.OutOfMemory</tt> error occurs by calling the <tt>exit</tt> dump agent.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/7332">#7332</a></td>
<td valign="top">LUDCL caching enabled by default</td>
<td valign="top">OpenJDK8 and later</td>
<td valign="top">This feature was disabled by default in Eclipse OpenJ9 0.17.0 due to issue <a href="https://github.com/eclipse-openj9/openj9/issues/7332">#7332</a>. This issue is resolved and the option is reenabled.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/7427">#7427</a></td>
<td valign="top">Support for Terabyte suffixes for <tt>-X</tt> and <tt>-XX</tt> options</td>
<td valign="top">OpenJDK8 and later</td>
<td valign="top">OpenJ9 now supports 't' and 'T' suffixes (indicating terabytes) for <tt>-X</tt> and <tt>-XX</tt> options that take a <tt>&lt;size&gt;</tt> parameter.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/7728">#7728</a></td>
<td valign="top">Extended platform support for pause-less garbage collection</td>
<td valign="top">OpenJDK8 and later (macOS)</td>
<td valign="top">Support for pause-less garbage collection (<tt>-Xgc:concurrentScavenge</tt>) is now extended to macOS systems.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/7955">#7955</a></td>
<td valign="top">Remove restriction on multi-layer shared cache</td>
<td valign="top">OpenJDK8 and later</td>
<td valign="top">In the previous release, there is a restriction that the <tt>jvmtiSharedCacheInfo.isCorrupt</tt> field and the  <tt>SharedClassCacheInfo.isCacheCorrupt()</tt> method cannot detect a corrupted cache that has a layer number other than zero. This restriction is now removed.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/7723">#7723</a></td>
<td valign="top">Support for OpenJDK HotSpot Garbage Collection options</td>
<td valign="top">OpenJDK8 and later</td>
<td valign="top">For compatibility, the following HotSpot options are now supported by OpenJ9: <tt>-XX:ParallelGCThreads</tt>, <tt>-XX:ConcGCThreads</tt>, and <tt>-XX:ParallelCMSThreads</tt>.</td>
</tr>

</table>


## Known Issues

The v0.18.0 release contains the following known issues and limitations:

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1">
<thead align="left">
<tr valign="bottom">
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Platform</th>
<th valign="bottom">Impact</th>
<th valign="bottom">Workaround</th>
</tr>
</thead>
<tbody>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/479">#479</a></td>
<td valign="top">Non-compressed references VM builds not available</td>
<td valign="top">AIX</td>
<td valign="top">Non-compressed references VM builds, which support heaps larger than 57GB, are built on Linux, Windows, and macOS. </td>
<td valign="top">Manual builds on other platforms are possible by following our <a href="https://github.com/eclipse-openj9/openj9/blob/master/buildenv/Build_Instructions_V8.md">detailed build instructions</a>.</td>
</tr>

</tbody>
</table>


## Other changes

A full commit history for this release is available at [Eclipse OpenJ9 v0.18.0](https://github.com/eclipse-openj9/openj9/releases/tag/openj9-0.18.0).
