<!--
* Copyright IBM Corp. and others 2019
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which accompanies this distribution and is available at
* https://www.eclipse.org/legal/epl-2.0/ or the Apache
* License, Version 2.0 which accompanies this distribution and
* is available at https://www.apache.org/licenses/LICENSE-2.0.
*
* This Source Code may also be made available under the
* following Secondary Licenses when the conditions for such
* availability set forth in the Eclipse Public License, v. 2.0
* are satisfied: GNU General Public License, version 2 with
* the GNU Classpath Exception [1] and GNU General Public
* License, version 2 with the OpenJDK Assembly Exception [2].
*
* [1] https://www.gnu.org/software/classpath/license.html
* [2] https://openjdk.org/legal/assembly-exception.html
*
* SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
-->

# Eclipse OpenJ9 version 0.15 release notes

These release notes support the [Eclipse OpenJ9 0.15 release plan](https://projects.eclipse.org/projects/technology.openj9/releases/0.15/plan).

## Binaries and supported environments

OpenJ9 release 0.15 supports OpenJDK 8, 11, and 12. Binaries are available at the AdoptOpenJDK project:

- [OpenJDK 8 with OpenJ9](https://adoptopenjdk.net/archive.html?variant=openjdk8&jvmVariant=openj9)
- [OpenJDK 11 with OpenJ9](https://adoptopenjdk.net/archive.html?variant=openjdk11&jvmVariant=openj9)
- [OpenJDK 12 with OpenJ9](https://adoptopenjdk.net/archive.html?variant=openjdk12&jvmVariant=openj9)

All builds are tested against the OpenJ9 functional verification (FV) test suite, the OpenJDK test suites, and additional tests at AdoptOpenJDK.

To learn more about support for OpenJ9 releases, including OpenJDK levels and platform support, see [Supported environments](https://eclipse.org/openj9/docs/openj9_support/index.html).


## Notable changes in this release

The following table covers notable changes in v0.15. Further information about these changes can be found in the [user documentation](https://eclipse.dev/openj9/docs/version0.15/).

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1"><thead align="left">
<tr valign="bottom">
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Version / Platform</th>
<th valign="bottom">Impact</th>
</tr>
</thead>
<tbody>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/5598">#5598</a></td>
<td valign="top">Performance improvements for JVMTI watched fields by default</td>
<td valign="top">OpenJDK8 and later (x86, Linux on Z, and z/OS only)</td>
<td valign="top">Following successful results, the experimental <tt>-XX:[+|-]JITInlineWatches</tt> option is now enabled by default, providing
performance improvements for JVMTI watched fields on x86 systems. Support is also extended from x86 to Linux on Z, and z/OS. </td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/5183">#5183</a></td>
<td valign="top">Extended platform support for software-based pause-less garbage collection</td>
<td valign="top">OpenJDK8 and later (IBM Z systems)</td>
<td valign="top">Reduced garbage collection pause times when using <tt>-Xgc:concurrentScavenge</tt> with the <tt>gencon</tt> GC policy for Linux on Z systems. </td>
</tr>

<tr><td valign="top"><a href="https://github.com/ibmruntimes/openj9-openjdk-jdk11/pull/164">#164</a></td>
<td valign="top">ChaCha20 algorithm support </td>
<td valign="top">OpenJDK11 only</td>
<td valign="top">On Java 11, ChaCha20 and ChaCha20-Poly1305 algorithms can now use OpenSSL. </td>
</tr>

<tr><td valign="top"><a href="https://github.com/ibmruntimes/openj9-openjdk-jdk12/pull/59">#59</a></td>
<td valign="top">System property <tt>jdk.nativeDigest</tt> has no effect</td>
<td valign="top">OpenJDK8 and later</td>
<td valign="top">The Digest algorithm is now disabled for JDK 12 due to <a href="https://github.com/eclipse-openj9/openj9/issues/5611">#5611</a>. The algorithm was disabled in JDK 8 and 11 in Eclipse OpenJ9 release 0.14.2. The system property <tt>jdk.nativeDigest</tt> cannot be used to enable the use of the Digest algorithm with OpenSSL. </td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/54">#54</a></td>
<td valign="top">OpenJ9 now supports all POSIX signals listed in <a href="https://github.com/ibmruntimes/openj9-openjdk-jdk/blob/openj9/test/jdk/sun/misc/SunMiscSignalTest.java"><tt>SunMiscSignalTest.java</tt></a>.</td>
<td valign="top">OpenJDK8 and later</td>
<td valign="top">Earlier release notes reported gaps in signal handling support, which are now resolved in this release. </td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/5239">#5293</a></td>
<td valign="top">Compatibility support for <tt>-XX:OnOutOfMemoryError</tt></td>
<td valign="top">OpenJDK8 and later</td>
<td valign="top">For compatibility with HotSpot, this option can now be used to run a command or list of commands when a
<tt>java.lang.OutOfMemoryError</tt> exception occurs. </td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/6013">#6013</a></td>
<td valign="top">Support for Transparent HugePage allocation</td>
<td valign="top">OpenJDK8 and later</td>
<td valign="top">The VM now supports Transparent HugePage on Linux when you use the <tt>madvise</tt> (<tt>/sys/kernel/mm/transparent_hugepage/enabled</tt>) setting. </td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/5538">#5538</a></td>
<td valign="top">New <tt>jmap</tt> tool</td>
<td valign="top">OpenJDK8 and later</td>
<td valign="top">For compatibility, OpenJ9 includes an independent implementation of the <tt>jmap</tt> tool, which
prints statistics about classes on the heap, including number of objects and aggregate size.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/2679">#2679</a></td>
<td valign="top">JEP 331 is implemented</td>
<td valign="top">OpenJDK11 and later</td>
<td valign="top">An implementation of <a href="https://openjdk.org/jeps/331">JEP 331</a> (Low-Overhead Heap Profiling) is now available. Restrictions are detailed in the <a href="https://eclipse.dev/openj9/docs/version0.15/">user documentation</a>. </td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/5882">#5882</a></td>
<td valign="top"><tt>-Xdiagnosticscollector</tt> option removed</td>
<td valign="top">OpenJDK8 and later</td>
<td valign="top">No impact. Redundant option removed.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/5374">#5374</a></td>
<td valign="top">New heuristics to implement compaction during idle garbage collection</td>
<td valign="top">OpenJDK8 and later</td>
<td valign="top">Heuristics are added to automatically compact the heap during idle garbage collection (GC) processing. Therefore, if
<tt>-XX:+IdleTuningGCOnIdle</tt> is enabled, compaction might occur. To force compaction every time idle GC operations take place,
<tt>-XX:+IdleTuningCompactOnIdle</tt> must be enabled. </td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/5374">#5374</a></td>
<td valign="top">Change in shared classes behavior for checking timestamps of jar or zip files</td>
<td valign="top">OpenJDK8 and later</td>
<td valign="top">In earlier releases, the shared classes cache checks timestamps of jar or zip files every time a class is loaded and reloads a class if the timestamp has changed. This behavior is now changed; timestamps are checked only when zip or jar files are added to class loaders and used for the first time to look for a class.
To revert to the behavior of earlier releases, set the <tt>-Xshareclasses:checkURLTimestamps</tt> option on the command line when you start your application. </td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/6059">#6059</a></td>
<td valign="top">Automatically setting an initial heap size</td>
<td valign="top">OpenJDK8 and later</td>
<td valign="top">OpenJ9 can now learn and set an appropriate initial heap size for an application as an alternative to a user manually sizing and setting an <tt>-Xms</tt> value. The VM records the size of the heap when startup processing ends, writing this data to the shared classes cache. An average value is set over a few restarts, helping to ensure that the value used for the initial heap size is as accurate as possible. See the <tt>-XX:[+|-]useGCStartupHints</tt> option (disabled by default). The hint
recorded is specific to the application command line.</td>
</tr>

</table>


## Known Issues

The v0.15.1 release contains the following known issues and limitations:

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1">
<thead align="left">
<tr valign="bottom">
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Platform</th>
<th valign="bottom">Impact</th>
<th valign="bottom">Workaround</th>
</tr>
</thead>
<tbody>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/5533">#5533</a></td>
<td valign="top">Attach API internal interfaces have changed slightly, affecting both the JDK's internal class library and <tt>tools.jar</tt></td>
<td valign="top">Java 8: all platforms</td>
<td valign="top">If an application uses a private copy of <tt>tools.jar</tt>, the application might be unable to use the attach API if it is using a newer JDK, because the Java classes will not match.</td>
<td valign="top">Use the <tt>tools.jar</tt> from the newer JDK.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/2507">#2507</a></td>
<td valign="top">Restriction analyzing system (core) dumps</td>
<td valign="top">Linux and Windows</td>
<td valign="top">You must use a 32-bit JVM to look at a 32-bit core, and a 64-bit JVM to look at a 64-bit core. This restriction will be fixed in a later version of OpenJ9.</td>
<td valign="top">None</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/479">#479</a></td>
<td valign="top">Non-compressed references VM builds not available</td>
<td valign="top">AIX, Linux on Z, Linux on Power</td>
<td valign="top">Non-compressed references VM builds, which support heaps larger than 57GB, are built on Linux on x86, Windows, and macOS. </td>
<td valign="top">Manual builds on other platforms are possible by following our <a href="https://github.com/eclipse-openj9/openj9/blob/master/buildenv/Build_Instructions_V8.md">detailed build instructions</a>.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/897">#897</a></td>
<td valign="top">Javadoc not building some OpenJ9 extensions.</td>
<td valign="top">All platforms</td>
<td valign="top">Some API documentation is missing in the <code>build/&lt;platform&gt;/docs</code> directory.</td>
<td valign="top">None</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/898">#898</a></td>
<td valign="top">Javadoc building some unsupported OpenJ9 extensions.</td>
<td valign="top">All platforms</td>
<td valign="top">Some API documentation in <code>build/&lt;platform&gt;/docs</code> is not supported with OpenJ9.</td>
<td valign="top">None</td>
</tr>

</tbody>
</table>


## Other changes

A full commit history for this release is available at [Eclipse OpenJ9 v0.15.1](https://github.com/eclipse-openj9/openj9/releases/tag/openj9-0.15.1).
