<!--
* Copyright IBM Corp. and others 2019
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which accompanies this distribution and is available at
* https://www.eclipse.org/legal/epl-2.0/ or the Apache
* License, Version 2.0 which accompanies this distribution and
* is available at https://www.apache.org/licenses/LICENSE-2.0.
*
* This Source Code may also be made available under the
* following Secondary Licenses when the conditions for such
* availability set forth in the Eclipse Public License, v. 2.0
* are satisfied: GNU General Public License, version 2 with
* the GNU Classpath Exception [1] and GNU General Public
* License, version 2 with the OpenJDK Assembly Exception [2].
*
* [1] https://www.gnu.org/software/classpath/license.html
* [2] https://openjdk.org/legal/assembly-exception.html
*
* SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
-->

# Eclipse OpenJ9 version 0.14 release notes

These release notes support the [Eclipse OpenJ9 0.14 release plan](https://projects.eclipse.org/projects/technology.openj9/releases/0.14/plan).


## Binaries and supported environments

OpenJ9 release 0.14 supports OpenJDK 8, 11, and 12. Binaries are available at the AdoptOpenJDK project:

- [OpenJDK 8 with OpenJ9](https://adoptopenjdk.net/archive.html?variant=openjdk8&jvmVariant=openj9)
- [OpenJDK 11 with OpenJ9](https://adoptopenjdk.net/archive.html?variant=openjdk11&jvmVariant=openj9)
- [OpenJDK 12 with OpenJ9](https://adoptopenjdk.net/archive.html?variant=openjdk12&jvmVariant=openj9)

All builds are tested against the OpenJ9 functional verification (FV) test suite, the OpenJDK test suites, and additional tests at AdoptOpenJDK.

:pencil: On Linux&reg; and AIX&reg; platforms, the OpenSSL 1.0.2 or 1.1.X library is expected to be found on the system path. If you use a package manager to install OpenSSL, the system path will be updated automatically. On other platforms, the OpenSSL 1.1.X library is currently bundled with the binaries from AdoptOpenJDK.

To learn more about support for OpenJ9 releases, including OpenJDK levels and platform support, see [Supported environments](https://eclipse.org/openj9/docs/openj9_support/index.html).


## Notable changes in this release

The following table covers notable changes in v0.14. Further information about these changes can be found in the [user documentation](https://eclipse.dev/openj9/docs/version0.14/).

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1"><thead align="left">
<tr valign="bottom">
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Version / Platform</th>
<th valign="bottom">Impact</th>
</tr>
</thead>
<tbody>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/5023">#5023</a></td>
<td valign="top">Extended platform support for software-based pause-less garbage collection</td>
<td valign="top">OpenJDK8 and later (Linux on POWER BE)</td>
<td valign="top">Reduced garbage collection pause times when using -Xgc:concurrentScavenge with the gencon GC policy for Linux on POWER BE. </td>
</tr>

<tr><td valign="top"><a href="https://github.com/ibmruntimes/openj9-openjdk-jdk8/pull/275">#275</a> <a href="https://github.com/ibmruntimes/openj9-openjdk-jdk11/pull/135">#135</a></td>
<td valign="top">OpenSSL 1.0.2 support</td>
<td valign="top">OpenJDK8 and OpenJDK11 (All platforms)</td>
<td valign="top">Improved cryptographic performance for the Digest, CBC, GCM, and RSA algorithms. </td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/4435">#4435</a></td>
<td valign="top">New -XX:[+|-]IgnoreUnrecognizedXXColonOptions command-line option</td>
<td valign="top">OpenJDK8 and later (All platforms)</td>
<td valign="top">Ability to discover -XX: options that the VM does not recognize on the command line. </td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/4988">#4988</a></td>
<td valign="top">New -XX:[+|-]ReadIPInfoForRAS command-line option</td>
<td valign="top">OpenJDK8 and later (All platforms)</td>
<td valign="top">Ability to skip a nameserver request to avoid the situation where hostname and IP address cannot be resolved and an application pauses for up to 60 seconds until the request times out.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/3483">#3483</a></td>
<td valign="top">DDR support enabled on macOS&reg; platforms</td>
<td valign="top">OpenJDK8 and later (macOS platform)</td>
<td valign="top">In earlier releases, DDR support was not available on the macOS platform, which affected problem diagnosis for the VM, garbage collector, and JIT compiler.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/4858">#4858</a></td>
<td valign="top">New Java stack tool (jstack)</td>
<td valign="top">OpenJDK8 and later (All platforms)</td>
<td valign="top">This tool can be used to obtain Java stack traces and thread information for Java processes.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/4655">#4655</a></td>
<td valign="top">New Java process status tool (jps)</td>
<td valign="top">OpenJDK8 and 11 (All platforms)</td>
<td valign="top">This tool can be used to query running Java processes. This tool is already available with OpenJDK 12. </td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/1831">#1831</a></td>
<td valign="top">Changes to the shared classes cache generation number</td>
<td valign="top">OpenJDK8 and later (All platforms)</td>
<td valign="top">The shared cache generation number is changed, which causes the JVM to create a new shared classes cache, rather than re-creating or reusing an existing cache. To save space, all existing shared caches can be removed unless they are in use by an earlier release. For more
information, see <a href="https://eclipse.dev/openj9/docs/xshareclasses/">-Xshareclasses</a>. </td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/3153">#3153</a></td>
<td valign="top">Optimizations to support JVMTI field watches</td>
<td valign="top">OpenJDK8 and later (Windows and Linux on x86  only)</td>
<td valign="top">A new option is available to turn on experimental performance improvements for JVMTI watched fields. For more
information, see <a href="https://eclipse.dev/openj9/docs/xxjitinlinewatches/">-XX:[+|-]JITInlineWatches</a>. </td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/5156">#5156</a></td>
<td valign="top">Change to the default native stack size (set by -Xmso)</td>
<td valign="top">OpenJDK8 and later (64-bit z/OS&reg; only)</td>
<td valign="top">The default size is changed from 384 KB to 1 MB, see <a href="https://eclipse.dev/openj9/docs/openj9_defaults/">Default settings for the OpenJ9 VM</a>. </td>
</tr>

</table>


## Known Issues

The v0.14.0 release contains the following known issues and limitations:

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1">
<thead align="left">
<tr valign="bottom">
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Platform</th>
<th valign="bottom">Impact</th>
<th valign="bottom">Workaround</th>
</tr>
</thead>
<tbody>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/54">#54</a></td>
<td valign="top">Signal handling</td>
<td valign="top">All platforms</td>
<td valign="top">Currently, shutdown signals (<code>SIGINT</code>, <code>SIGHUP</code> and <code>SIGTERM</code>) and <code>SIGCONT</code> are fully supported on Unix platforms (pLinux, zLinux, xLinux, AIX, and z/OS). Support for other POSIX signals is pending. See <code>SunMiscSignalTest.java</code> for the list of signals that need to be supported.</td>
<td valign="top">None</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/2507">#2507</a></td>
<td valign="top">Restriction analyzing system (core) dumps</td>
<td valign="top">Linux and Windows</td>
<td valign="top">You must use a 32-bit JVM to look at a 32-bit core, and a 64-bit JVM to look at a 64-bit core. This restriction will be fixed in a later version of OpenJ9.</td>
<td valign="top">None</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/479">#479</a></td>
<td valign="top">Non-compressed references VM builds not available</td>
<td valign="top">AIX, Windows, Linux on Z, Linux on Power</td>
<td valign="top">Non-compressed references VM builds, which support heaps larger than 57GB, are built on Linux on x86. </td>
<td valign="top">Manual builds on other platforms are possible by following our <a href="https://github.com/eclipse-openj9/openj9/blob/master/buildenv/Build_Instructions_V8.md">detailed build instructions</a>.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/897">#897</a></td>
<td valign="top">Javadoc not building some OpenJ9 extensions.</td>
<td valign="top">All platforms</td>
<td valign="top">Some API documentation is missing in the <code>build/&lt;platform&gt;/docs</code> directory.</td>
<td valign="top">None</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/898">#898</a></td>
<td valign="top">Javadoc building some unsupported OpenJ9 extensions.</td>
<td valign="top">All platforms</td>
<td valign="top">Some API documentation in <code>build/&lt;platform&gt;/docs</code> is not supported with OpenJ9.</td>
<td valign="top">None</td>
</tr>

</tbody>
</table>

## Other changes

A full commit history for this release is available at [Eclipse OpenJ9 v0.14.0](https://github.com/eclipse-openj9/openj9/releases/tag/openj9-0.14.0).
