<!--
* Copyright IBM Corp. and others 2019
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which accompanies this distribution and is available at
* https://www.eclipse.org/legal/epl-2.0/ or the Apache
* License, Version 2.0 which accompanies this distribution and
* is available at https://www.apache.org/licenses/LICENSE-2.0.
*
* This Source Code may also be made available under the
* following Secondary Licenses when the conditions for such
* availability set forth in the Eclipse Public License, v. 2.0
* are satisfied: GNU General Public License, version 2 with
* the GNU Classpath Exception [1] and GNU General Public
* License, version 2 with the OpenJDK Assembly Exception [2].
*
* [1] https://www.gnu.org/software/classpath/license.html
* [2] https://openjdk.org/legal/assembly-exception.html
*
* SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
-->

# Eclipse OpenJ9 version 0.12.1 release notes

These release notes support the [Eclipse OpenJ9 0.12.1 release plan](https://projects.eclipse.org/projects/technology.openj9/releases/0.12.1/plan).


## Binaries and supported environments

OpenJ9 release 0.12.1 supports OpenJDK 8 and OpenJDK 11. Binaries are available at the AdoptOpenJDK project:

- [OpenJDK with OpenJ9 version 8](https://adoptopenjdk.net/archive.html?variant=openjdk8&jvmVariant=openj9)
- [OpenJDK with OpenJ9 version 11](https://adoptopenjdk.net/archive.html?variant=openjdk11&jvmVariant=openj9)

All builds are tested against the OpenJ9 functional verification (FV) test suite, the OpenJDK test suites, and additional tests at AdoptOpenJDK.

To learn more about support for OpenJ9 releases, including OpenJDK levels and platform support, see [Supported environments](https://eclipse.org/openj9/docs/openj9_support/index.html).


## Notable changes in this release

The following table covers notable changes in v0.12.1. Further information about these changes can be found in the [user documentation](https://eclipse.dev/openj9/docs/version0.12.1/).

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1"><thead align="left">
<tr valign="bottom">
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Version / Platform</th>
<th valign="bottom">Impact</th>
</tr>
</thead>
<tbody>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/4530">#4530</a></td>
<td valign="top">OpenSSL acceleration of the Digest algorithm is disabled by default.</td>
<td valign="top">OpenJDK8 and later (All platforms)</td>
<td valign="top">Intermittent segmentation problems are observed when accelerating the Digest algorithm. This algorithm is now
disabled by default. The <b>-Djdk.nativeDigest</b> system property no longer has any effect. </td>
</tr>


</table>


## Known Issues

The v0.12.0 release contains the following known issues and limitations:

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1">
<thead align="left">
<tr valign="bottom">
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Platform</th>
<th valign="bottom">Impact</th>
<th valign="bottom">Workaround</th>
</tr>
</thead>
<tbody>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/3483">#3483</a></td>
<td valign="top">DDR support</td>
<td valign="top">macOS</td>
<td valign="top">Inability to diagnose problems with the VM, garbage collector, or JIT.</td>
<td valign="top">None</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/4222">#4222</a></td>
<td valign="top">Shared classes no longer enabled by default</td>
<td valign="top">All platforms</td>
<td valign="top">In milestone 1, shared classes were enabled by default. This change has been reverted due to a performance regression.</td>
<td valign="top">None</td>
</tr>

<tr><td valign="top"><a href="https://github.com/ibmruntimes/openj9-openjdk-jdk8/issues/129">#129</a></td>
<td valign="top">OpenSSL support</td>
<td valign="top">AIX</td>
<td valign="top">Bundling OpenSSL on AIX can result in problems like https://github.com/ibmruntimes/openj9-openjdk-jdk8/issues/129.</td>
<td valign="top">None</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/54">#54</a></td>
<td valign="top">Signal handling</td>
<td valign="top">All platforms</td>
<td valign="top">Currently, shutdown signals (<code>SIGINT</code>, <code>SIGHUP</code> and <code>SIGTERM</code>) and <code>SIGCONT</code> are fully supported on Unix platforms (pLinux, zLinux, xLinux, AIX, and z/OS). Support for other POSIX signals is pending. See <code>SunMiscSignalTest.java</code> for the list of signals that need to be supported.</td>
<td valign="top">None</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/2507">#2507</a></td>
<td valign="top">Restriction analyzing system (core) dumps</td>
<td valign="top">Linux and Windows</td>
<td valign="top">You must use a 32-bit JVM to look at a 32-bit core, and a 64-bit JVM to look at a 64-bit core. This restriction will be fixed in a later version of OpenJ9.</td>
<td valign="top">None</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/479">#479</a></td>
<td valign="top">Non-compressed references VM builds not available</td>
<td valign="top">AIX, Windows, Linux on Z, Linux on Power</td>
<td valign="top">Non-compressed references VM builds, which support heaps larger than 57GB, are built on Linux on x86. </td>
<td valign="top">Manual builds on other platforms are possible by following our <a href="https://github.com/eclipse-openj9/openj9/blob/master/buildenv/Build_Instructions_V8.md">detailed build instructions</a>.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/897">#897</a></td>
<td valign="top">Javadoc not building some OpenJ9 extensions.</td>
<td valign="top">All platforms</td>
<td valign="top">Some API documentation is missing in the <code>build/&lt;platform&gt;/docs</code> directory.</td>
<td valign="top">None</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/898">#898</a></td>
<td valign="top">Javadoc building some unsupported OpenJ9 extensions.</td>
<td valign="top">All platforms</td>
<td valign="top">Some API documentation in <code>build/&lt;platform&gt;/docs</code> is not supported with OpenJ9.</td>
<td valign="top">None</td>
</tr>

</tbody>
</table>

## Other changes

A full commit history for this release is available at [Eclipse OpenJ9 v0.12.1](https://github.com/eclipse-openj9/openj9/releases/tag/openj9-0.12.1).
