<!--
Copyright IBM Corp. and others 2017

This program and the accompanying materials are made available under
the terms of the Eclipse Public License 2.0 which accompanies this
distribution and is available at https://www.eclipse.org/legal/epl-2.0/
or the Apache License, Version 2.0 which accompanies this distribution and
is available at https://www.apache.org/licenses/LICENSE-2.0.

This Source Code may also be made available under the following
Secondary Licenses when the conditions for such availability set
forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
General Public License, version 2 with the GNU Classpath
Exception [1] and GNU General Public License, version 2 with the
OpenJDK Assembly Exception [2].

[1] https://www.gnu.org/software/classpath/license.html
[2] https://openjdk.org/legal/assembly-exception.html

SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
-->


Documentation
=============

This directory contains the following types of documentation:

| Directory            |    Contents                                                                  |
|----------------------|------------------------------------------------------------------------------|
| `build-instructions` | Build instructions for compiling OpenJDK with OpenJ9.                        |
| `compiler`           | Developer documentation about the compiler technology, codenamed Testarossa. |
| `diagnostics`        | Developer documentation about the diagnostic component of OpenJ9.            |
| `processes`          | Process documentation for the OpenJ9 project.                                |
| `release-notes`      | OpenJ9 release notes.                                                        |

:pencil: Developer documentation about OpenJ9 technology or components is best considered in tandem with the [documentation from Eclipse OMR](https://github.com/eclipse-omr/omr/tree/master/doc), as OpenJ9 is built upon the foundational technologies provided by OMR.

:pencil: User documentation for OpenJ9 is published at the [OpenJ9 website](https://eclipse.dev/openj9/docs/)
