/*
 * Copyright 2012-2026 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.assertj.core.api.bigdecimal;

import static org.assertj.core.data.Offset.offset;
import static org.mockito.Mockito.verify;

import java.math.BigDecimal;

import org.assertj.core.api.BigDecimalAssert;
import org.assertj.core.api.BigDecimalAssertBaseTest;
import org.assertj.core.data.Offset;

/**
 * Tests for <code>{@link org.assertj.core.api.BigDecimalAssert#isCloseTo(java.math.BigDecimal, org.assertj.core.data.Offset)}</code>.
 *
 * @author Joel Costigliola
 */
class BigDecimalAssert_isCloseTo_Test extends BigDecimalAssertBaseTest {

  private final BigDecimal other = new BigDecimal(6);
  private final Offset<BigDecimal> offset = offset(BigDecimal.ONE);

  @Override
  protected BigDecimalAssert invoke_api_method() {
    return assertions.isCloseTo(other, offset);
  }

  @Override
  protected void verify_internal_effects() {
    verify(bigDecimals).assertIsCloseTo(getInfo(assertions), getActual(assertions), other, offset);
  }
}
