/*
 * Copyright 2012-2026 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.assertj.core.api.abstract_;

import static org.mockito.Mockito.verify;

import java.io.File;

import org.assertj.core.api.AbstractAssertBaseTest;
import org.assertj.core.api.ConcreteAssert;
import org.assertj.core.api.ObjectAssert;

/**
 * Tests for <code>{@link ObjectAssert#isOfAnyClassIn(Class...)}</code>.
 * 
 * @author Nicolas François
 */
class AbstractAssert_isOfAnyClassIn_Test extends AbstractAssertBaseTest {

  @Override
  protected ConcreteAssert invoke_api_method() {
    return assertions.isOfAnyClassIn(String.class, File.class);
  }

  @Override
  protected void verify_internal_effects() {
    verify(objects).assertIsOfAnyClassIn(getInfo(assertions), getActual(assertions), new Class[] { String.class, File.class });
  }
}
