/*
 * Copyright 2012-2026 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.assertj.core.api.abstract_;

import static org.assertj.core.api.Assertions.assertThat;
import static org.assertj.core.testkit.TestData.someDescription;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.ConcreteAssert;
import org.assertj.core.description.Description;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

/**
 * Tests for <code>{@link AbstractAssert#as(Description)}</code>
 *
 * @author Alex Ruiz
 */
class AbstractAssert_as_with_description_Test {

  private ConcreteAssert assertions;
  private Description d;

  @BeforeEach
  void setUp() {
    assertions = new ConcreteAssert(6L);
    d = someDescription();
  }

  @Test
  void should_set_description() {
    assertions.as(d);
    assertThat(assertions.descriptionText()).isEqualTo(d.value());
  }

  @Test
  void should_return_this() {
    ConcreteAssert descriptable = assertions.as(d);
    assertThat(descriptable).isSameAs(assertions);
  }

  @Test
  void should_replace_null_description_by_an_empty_one() {
    String description = null;
    ConcreteAssert concreteAssert = assertions.as(description);
    assertThat(concreteAssert.info.descriptionText()).isEmpty();
  }
}
