// Code generated by go-swagger; DO NOT EDIT.

package legacy_alerts

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// NewTestAlertParams creates a new TestAlertParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewTestAlertParams() *TestAlertParams {
	return &TestAlertParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewTestAlertParamsWithTimeout creates a new TestAlertParams object
// with the ability to set a timeout on a request.
func NewTestAlertParamsWithTimeout(timeout time.Duration) *TestAlertParams {
	return &TestAlertParams{
		timeout: timeout,
	}
}

// NewTestAlertParamsWithContext creates a new TestAlertParams object
// with the ability to set a context for a request.
func NewTestAlertParamsWithContext(ctx context.Context) *TestAlertParams {
	return &TestAlertParams{
		Context: ctx,
	}
}

// NewTestAlertParamsWithHTTPClient creates a new TestAlertParams object
// with the ability to set a custom HTTPClient for a request.
func NewTestAlertParamsWithHTTPClient(client *http.Client) *TestAlertParams {
	return &TestAlertParams{
		HTTPClient: client,
	}
}

/*
TestAlertParams contains all the parameters to send to the API endpoint

	for the test alert operation.

	Typically these are written to a http.Request.
*/
type TestAlertParams struct {

	// Body.
	Body *models.AlertTestCommand

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the test alert params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *TestAlertParams) WithDefaults() *TestAlertParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the test alert params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *TestAlertParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the test alert params
func (o *TestAlertParams) WithTimeout(timeout time.Duration) *TestAlertParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the test alert params
func (o *TestAlertParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the test alert params
func (o *TestAlertParams) WithContext(ctx context.Context) *TestAlertParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the test alert params
func (o *TestAlertParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the test alert params
func (o *TestAlertParams) WithHTTPClient(client *http.Client) *TestAlertParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the test alert params
func (o *TestAlertParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the test alert params
func (o *TestAlertParams) WithBody(body *models.AlertTestCommand) *TestAlertParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the test alert params
func (o *TestAlertParams) SetBody(body *models.AlertTestCommand) {
	o.Body = body
}

// WriteToRequest writes these params to a swagger request
func (o *TestAlertParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
