/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.utils;

import com.ibm.java.diagnostics.healthcenter.agent.mbean.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class HeadlessZipUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void packFiles(String folderName, String hcdFileName) {
        byte[] buf = new byte[1024];
        boolean entriesWritten = false;
        FileOutputStream fos = null;
        ZipOutputStream out = null;
        try {
            File[] filesToZip;
            File zipFile = new File(hcdFileName);
            fos = new FileOutputStream(zipFile);
            out = new ZipOutputStream(fos);
            File folderToZip = new File(folderName);
            if (folderToZip != null && (filesToZip = folderToZip.listFiles()) != null && filesToZip.length > 0) {
                for (File sourceFileToZip : filesToZip) {
                    String message;
                    if (sourceFileToZip == null || !sourceFileToZip.isFile()) continue;
                    if (!sourceFileToZip.canRead()) {
                        entriesWritten = true;
                    }
                    if (!sourceFileToZip.exists()) continue;
                    FileInputStream in = null;
                    try {
                        int len;
                        if (sourceFileToZip.length() < 0L) continue;
                        in = new FileInputStream(sourceFileToZip);
                        out.putNextEntry(new ZipEntry(sourceFileToZip.getName()));
                        while ((len = in.read(buf)) > 0) {
                            out.write(buf, 0, len);
                        }
                        out.closeEntry();
                        in.close();
                        entriesWritten = true;
                    }
                    catch (IOException e) {
                        message = Messages.getString("Headless.agent.write.file.error");
                    }
                    finally {
                        if (in != null) {
                            try {
                                in.close();
                                out.closeEntry();
                            }
                            catch (IOException e) {
                                message = Messages.getString("Headless.agent.write.file.error");
                            }
                        }
                    }
                }
            }
            if (entriesWritten) {
                out.close();
            }
        }
        catch (IOException ioe) {
        }
        finally {
            if (out != null && entriesWritten) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    String message = Messages.getString("Headless.agent.write.file.error");
                }
            }
        }
    }
}

