/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.mbean;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public class HCSslSocketFactory {
    private static HCSslSocketFactory defaultSocketFactory = null;
    private static String keystoreName = "";
    private static String keystorePassword = "";
    private static String certificatePassword = "";

    public static void setSSLValues(String keystoreName, String keystorePassword, String certificatePassword) {
        HCSslSocketFactory.keystoreName = keystoreName;
        HCSslSocketFactory.keystorePassword = keystorePassword;
        HCSslSocketFactory.certificatePassword = certificatePassword;
    }

    public static synchronized HCSslSocketFactory getDefaultSocketFactory() {
        if (defaultSocketFactory == null) {
            defaultSocketFactory = new HCSslSocketFactory();
        }
        return defaultSocketFactory;
    }

    public Socket createSocket(String host, int port) throws IOException {
        SSLSocket socket = null;
        FileInputStream keystoreStream = new FileInputStream(new File(keystoreName));
        try {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("IBMX509");
            KeyStore keystore = KeyStore.getInstance("JKS");
            keystore.load(keystoreStream, keystorePassword.toCharArray());
            kmf.init(keystore, certificatePassword.toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("IBMX509");
            tmf.init(keystore);
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(kmf.getKeyManagers(), tmf.getTrustManagers(), new SecureRandom());
            SSLSocketFactory sslSocketFactory = context.getSocketFactory();
            socket = (SSLSocket)sslSocketFactory.createSocket(host, port);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        catch (KeyStoreException e) {
            throw new IOException(e);
        }
        catch (CertificateException e) {
            throw new IOException(e);
        }
        catch (UnrecoverableKeyException e) {
            throw new IOException(e);
        }
        catch (KeyManagementException e) {
            throw new IOException(e);
        }
        finally {
            ((InputStream)keystoreStream).close();
        }
        return socket;
    }
}

