/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import java.security.spec.AlgorithmParameterSpec;

public class PKCS11RSAKeyPairParameterSpec
implements AlgorithmParameterSpec {
    private int strength;
    private String id = null;
    private String subject = null;
    private String label = null;
    private Boolean isToken = null;
    private Boolean isSensitive = null;
    private Boolean sign = null;
    private Boolean encrypt = null;
    private Boolean wrapping = null;
    private Boolean extractable = null;

    public PKCS11RSAKeyPairParameterSpec(int strength, String keyIdentifier, String subject, String label, Boolean isToken, Boolean isSensitive, Boolean signing, Boolean encryption, Boolean wrapping, Boolean extractable) {
        this.strength = strength;
        this.id = keyIdentifier;
        this.subject = subject;
        this.label = label;
        if (isToken != null) {
            this.isToken = new Boolean(isToken);
        }
        if (isSensitive != null) {
            this.isSensitive = new Boolean(isSensitive);
        }
        if (signing != null) {
            this.sign = new Boolean(signing);
        }
        if (encryption != null) {
            this.encrypt = new Boolean(encryption);
        }
        if (wrapping != null) {
            this.wrapping = new Boolean(wrapping);
        }
        if (extractable != null) {
            this.extractable = new Boolean(extractable);
        }
    }

    public PKCS11RSAKeyPairParameterSpec(int strength, String keyIdentifier, String subject, String label) {
        this(strength, keyIdentifier, subject, label, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, null);
    }

    public int getStrength() {
        return this.strength;
    }

    public String getKeyID() {
        return this.id;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getLabel() {
        return this.label;
    }

    public Boolean getSensitive() {
        if (this.isSensitive != null) {
            return new Boolean(this.isSensitive);
        }
        return this.isSensitive;
    }

    public Boolean getToken() {
        if (this.isToken != null) {
            return new Boolean(this.isToken);
        }
        return this.isToken;
    }

    public Boolean getSign() {
        if (this.sign != null) {
            return new Boolean(this.sign);
        }
        return this.sign;
    }

    public Boolean getEncrypt() {
        if (this.encrypt != null) {
            return new Boolean(this.encrypt);
        }
        return this.encrypt;
    }

    public Boolean getWrap() {
        if (this.wrapping != null) {
            return new Boolean(this.wrapping);
        }
        return this.wrapping;
    }

    public Boolean getExtractable() {
        if (this.extractable != null) {
            return new Boolean(this.extractable);
        }
        return this.extractable;
    }
}

