/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.utils;

import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandParser;
import com.ibm.java.diagnostics.utils.commands.ICommand;
import com.ibm.java.diagnostics.utils.commands.PluginCommand;
import com.ibm.java.diagnostics.utils.commands.QuitCommand;
import com.ibm.java.diagnostics.utils.plugins.PluginManager;
import java.io.PrintStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Context
implements IContext {
    protected final ArrayList<ICommand> globalCommands = new ArrayList();
    protected final ArrayList<ICommand> commands = new ArrayList();
    protected ICommand lastExecutedCommand = null;
    protected Exception lastException = null;
    public static final Logger logger = Logger.getLogger("com.ibm.java.diagnostics.plugins");
    protected PluginManager loader;

    public Context() {
        this.globalCommands.add(new QuitCommand());
        this.globalCommands.add(new PluginCommand());
    }

    public PluginManager getPluginManager() {
        return this.loader;
    }

    @Override
    public boolean isCommandRecognised(String command) {
        for (ICommand thisCommand : this.commands) {
            if (!thisCommand.recognises(command, this)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void execute(String command, String[] arguments, PrintStream out) {
        try {
            this.execute(new CommandParser(command, arguments), out);
        }
        catch (ParseException e) {
            out.println("Error executing command: " + e.getMessage());
        }
    }

    @Override
    public void execute(CommandParser commandParser, PrintStream out) {
        for (ICommand thisCommand : this.commands) {
            if (!this.tryCommand(commandParser, thisCommand, out)) continue;
            return;
        }
        out.println("Unrecognised command: " + commandParser.getCommand());
    }

    @Override
    public void execute(String line, PrintStream out) {
        line = line.trim();
        try {
            this.execute(new CommandParser(line), out);
        }
        catch (ParseException e) {
            out.println("Error executing command: " + e.getMessage());
        }
    }

    private boolean tryCommand(CommandParser commandParser, ICommand thisCommand, PrintStream defaultOut) {
        this.lastExecutedCommand = null;
        this.lastException = null;
        if (thisCommand.recognises(commandParser.getCommand(), this)) {
            PrintStream fileOut = null;
            this.lastExecutedCommand = thisCommand;
            try {
                if (commandParser.isRedirectedToFile()) {
                    fileOut = commandParser.getOutputFile();
                    thisCommand.run(commandParser.getCommand(), commandParser.getArguments(), this, fileOut);
                    fileOut.flush();
                    fileOut.close();
                } else {
                    thisCommand.run(commandParser.getCommand(), commandParser.getArguments(), this, defaultOut);
                }
            }
            catch (Exception e) {
                this.lastException = e;
                logger.log(Level.FINE, "Problem running command: ", e);
                defaultOut.println("Problem running command: ");
                defaultOut.println(e.getMessage());
            }
            defaultOut.flush();
            if (fileOut != null) {
                fileOut.flush();
                fileOut.close();
            }
            return true;
        }
        return false;
    }

    public Vector<String> getCommandNames() {
        Vector<String> commandNames = new Vector<String>();
        for (ICommand thisCommand : this.commands) {
            if (thisCommand.getCommandNames() == null) continue;
            commandNames.addAll(thisCommand.getCommandNames());
        }
        return commandNames;
    }

    @Override
    public List<ICommand> getCommands() {
        return Collections.unmodifiableList(this.commands);
    }

    protected void addGlobalCommandsToContext() {
        for (ICommand cmd : this.globalCommands) {
            this.commands.add(cmd);
        }
    }

    @Override
    public ICommand getLastExecutedCommand() {
        return this.lastExecutedCommand;
    }

    @Override
    public Exception getLastCommandException() {
        return this.lastException;
    }
}

