/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders.zos.le;

import com.ibm.dtfj.corereaders.zos.dumpreader.AddressSpace;
import com.ibm.dtfj.corereaders.zos.dumpreader.AddressSpaceImageInputStream;
import com.ibm.dtfj.corereaders.zos.le.Caa;
import com.ibm.dtfj.corereaders.zos.le.Ceexedb32Template;
import com.ibm.dtfj.corereaders.zos.le.Ceexedb64Template;
import com.ibm.dtfj.corereaders.zos.le.CeexedbTemplate;
import com.ibm.dtfj.corereaders.zos.le.Dll;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;

public class Edb {
    private long address;
    private AddressSpace space;
    private AddressSpaceImageInputStream inputStream;
    private Properties envVars;
    CeexedbTemplate ceexedbTemplate;
    private static Logger log = Logger.getLogger(Edb.class.getName());

    public Edb(long address, AddressSpace space) {
        this.address = address;
        this.space = space;
        this.inputStream = space.getImageInputStream();
        this.createTemplates(space);
    }

    void createTemplates(AddressSpace space) {
        if (this.ceexedbTemplate == null) {
            this.ceexedbTemplate = space.is64bit() ? new Ceexedb64Template() : new Ceexedb32Template();
        }
    }

    public long address() {
        return this.address;
    }

    public long ceeedb_ceeosigr() throws IOException {
        return this.ceexedbTemplate.getCeeedb_ceeosigr(this.inputStream, this.address);
    }

    public long ceeedbdba() throws IOException {
        return this.ceexedbTemplate.getCeeedbdba(this.inputStream, this.address);
    }

    public static Edb getSampleEdb(AddressSpace space) {
        Caa[] caas = Caa.getCaas(space);
        for (int i = 0; i < caas.length; ++i) {
            Edb edb = caas[i].getEdb();
            log.fine("found edb " + edb + " for caa " + caas[i]);
            try {
                if (edb.getFirstDll() == null) continue;
                log.fine("edb has a dll: " + edb.getFirstDll());
                return edb;
            }
            catch (IOException e) {
                log.fine("caught exception: " + e);
            }
        }
        log.fine("no sample edb found");
        return null;
    }

    public Dll getFirstDll() throws IOException {
        long ceeedb_dlcb_first = this.ceexedbTemplate.getCeeedb_dlcb_first(this.inputStream, this.address);
        log.fine("ceeedb_dlcb_first = " + Edb.hex(ceeedb_dlcb_first));
        return ceeedb_dlcb_first == 0L ? null : new Dll(ceeedb_dlcb_first, this.space);
    }

    public Properties getEnvVars() throws IOException {
        if (this.envVars != null) {
            return this.envVars;
        }
        this.envVars = new Properties();
        long ceeedbenvar = this.ceexedbTemplate.getCeeedbenvar(this.inputStream, this.address);
        long env = 0L;
        while ((env = this.space.readWord(ceeedbenvar)) != 0L) {
            String name = this.space.readEbcdicCString(env);
            int eq = name.indexOf(61);
            if (eq > 0) {
                String key = name.substring(0, eq);
                String value = name.substring(eq + 1);
                this.envVars.put(key, value);
            } else {
                this.envVars.put(name, "");
            }
            ceeedbenvar += (long)this.space.getWordLength();
        }
        return this.envVars;
    }

    private static String hex(long i) {
        return Long.toHexString(i);
    }

    private static String hex(int i) {
        return Integer.toHexString(i);
    }

    public String toString() {
        return Edb.hex(this.address);
    }
}

