/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.addressspace;

import com.ibm.dtfj.addressspace.CommonAddressSpace;
import com.ibm.dtfj.corereaders.ClosingFileReader;
import com.ibm.dtfj.corereaders.MemoryAccessException;
import com.ibm.dtfj.corereaders.MemoryRange;
import java.io.IOException;

public class SimpleAddressSpace
extends CommonAddressSpace {
    private ClosingFileReader _backing;

    public SimpleAddressSpace(MemoryRange[] deprecatedMemoryRanges, ClosingFileReader file, boolean isLittleEndian, boolean is64Bit) {
        super(deprecatedMemoryRanges, isLittleEndian, is64Bit);
        this._backing = file;
    }

    @Override
    public boolean isExecutable(int asid, long address) throws MemoryAccessException {
        return false;
    }

    @Override
    public boolean isReadOnly(int asid, long address) throws MemoryAccessException {
        return false;
    }

    @Override
    public boolean isShared(int asid, long address) throws MemoryAccessException {
        return false;
    }

    @Override
    public int getBytesAt(int asid, long address, byte[] buffer) throws MemoryAccessException {
        MemoryRange resident = this._residentRange(asid, address);
        long readLocation = resident.getFileOffset() + (address - resident.getVirtualAddress());
        try {
            this._backing.seek(readLocation);
            this._backing.readFully(buffer);
        }
        catch (IOException e) {
            throw new MemoryAccessException(asid, address);
        }
        return buffer.length;
    }
}

