/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.plus.provider;

import com.ibm.crypto.plus.provider.IBMJCEPlusProvider;
import com.ibm.crypto.plus.provider.JCEPlusKeyRep;
import com.ibm.crypto.plus.provider.JCEPlusKeyRep$Type;
import com.ibm.crypto.plus.provider.XDHPrivateKeyImpl;
import com.ibm.crypto.plus.provider.icc.XECKey;
import com.ibm.security.util.BitArray;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.X509Key;
import ibm.security.internal.interfaces.XECPublicKey;
import ibm.security.internal.spec.NamedParameterSpec;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

final class XDHPublicKeyImpl
extends X509Key
implements XECPublicKey,
Destroyable,
Serializable {
    private static final long serialVersionUID = 7187392471159151072L;
    private IBMJCEPlusProvider provider = null;
    private NamedParameterSpec params;
    private BigInteger u;
    private BigInteger bi1;
    private BigInteger bi2;
    private BigInteger bi3;
    private transient boolean destroyed = false;
    private transient XECKey xecKey = null;
    private static final byte TAG_PARAMETERS_ATTRS = 0;
    private static final String[] z;

    private void a(NamedParameterSpec.CURVE cURVE) throws Exception {
        byte[] byArray = this.xecKey.getPublicKeyBytes();
        this.params = new NamedParameterSpec(cURVE);
        this.setKey(new BitArray(byArray.length * 8, byArray));
        XDHPublicKeyImpl.c(byArray);
        int n2 = byArray.length * 8 % 8;
        if (n2 != 0) {
            int n3 = (1 << n2) - 1;
            byArray[0] = (byte)(byArray[0] & n3);
        }
        this.u = new BigInteger(1, byArray);
    }

    public XDHPublicKeyImpl(IBMJCEPlusProvider iBMJCEPlusProvider, XECKey xECKey, NamedParameterSpec.CURVE cURVE) throws InvalidKeyException {
        if (iBMJCEPlusProvider == null) {
            throw new InvalidKeyException(z[13]);
        }
        if (xECKey == null) {
            throw new InvalidKeyException(z[14]);
        }
        this.provider = iBMJCEPlusProvider;
        this.xecKey = xECKey;
        try {
            this.algid = XECKey.getAlgId(cURVE);
            this.a(cURVE);
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[12]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    public XDHPublicKeyImpl(IBMJCEPlusProvider iBMJCEPlusProvider, byte[] byArray) throws InvalidKeyException {
        if (iBMJCEPlusProvider == null) {
            throw new InvalidKeyException(z[9]);
        }
        if (byArray == null) {
            throw new InvalidKeyException(z[11]);
        }
        this.provider = iBMJCEPlusProvider;
        this.decode(byArray);
        try {
            byte[] byArray2 = (byte[])this.key.clone();
            if (!XECKey.isEd(this.params.getCurve())) {
                XDHPublicKeyImpl.c(byArray2);
            }
            int n2 = byArray2.length * 8 % 8;
            if (n2 != 0) {
                int n3 = (1 << n2) - 1;
                byArray2[0] = (byte)(byArray2[0] & n3);
            }
            this.u = new BigInteger(1, byArray2);
            byte[] byArray3 = this.a(byArray);
            this.xecKey = XECKey.createPublicKey(iBMJCEPlusProvider.a(), byArray3);
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[10]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    public XDHPublicKeyImpl(IBMJCEPlusProvider iBMJCEPlusProvider, AlgorithmParameterSpec algorithmParameterSpec, BigInteger bigInteger) throws InvalidParameterException, InvalidKeyException {
        if (iBMJCEPlusProvider == null) {
            throw new InvalidParameterException(z[3]);
        }
        if (!(algorithmParameterSpec instanceof NamedParameterSpec)) {
            throw new InvalidParameterException(z[5]);
        }
        this.params = (NamedParameterSpec)algorithmParameterSpec;
        try {
            if (XECKey.isFFDHE(this.params.getCurve())) {
                throw new InvalidParameterException(z[4]);
            }
        }
        catch (Exception exception) {
            throw new InvalidParameterException(exception.getMessage());
        }
        this.provider = iBMJCEPlusProvider;
        try {
            if (bigInteger == null) {
                this.xecKey = XECKey.generateKeyPair(iBMJCEPlusProvider.a(), this.params.getCurve());
                this.a(this.params.getCurve());
            } else {
                Object object;
                byte[] byArray = null;
                if (!XECKey.isEd(this.params.getCurve())) {
                    BigInteger bigInteger2 = BigInteger.valueOf(2L);
                    object = this.params.getName().equals(z[1]) ? bigInteger2.pow(448).subtract(bigInteger2.pow(224)).subtract(BigInteger.ONE) : bigInteger2.pow(255).subtract(BigInteger.valueOf(19L));
                    this.u = bigInteger.mod((BigInteger)object);
                    byArray = this.u.toByteArray();
                    XDHPublicKeyImpl.c(byArray);
                }
                byArray = Arrays.copyOf(byArray, NamedParameterSpec.getPublicCurveSize((NamedParameterSpec.CURVE)this.params.getCurve()));
                this.setKey(new BitArray(byArray.length * 8, byArray));
                this.algid = XECKey.getAlgId(this.params.getCurve());
                object = this.b();
                this.a();
                this.xecKey = XECKey.createPublicKey(iBMJCEPlusProvider.a(), (byte[])object);
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            throw invalidKeyException;
        }
        catch (Exception exception) {
            InvalidParameterException invalidParameterException = new InvalidParameterException(z[2]);
            iBMJCEPlusProvider.a(invalidParameterException, (Throwable)exception);
            throw invalidParameterException;
        }
    }

    private void a() throws InvalidKeyException {
        if (NamedParameterSpec.getPublicCurveSize((NamedParameterSpec.CURVE)this.params.getCurve()) * 8 != this.getKey().length()) {
            throw new InvalidKeyException(z[7] + NamedParameterSpec.getPublicCurveSize((NamedParameterSpec.CURVE)this.params.getCurve()));
        }
    }

    private byte[] b() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.putOID(this.algid.getOID());
        if (XECKey.isFFDHE(this.params.getCurve())) {
            XDHPrivateKeyImpl.putFFDHEIntegers(derOutputStream2, this.bi1, this.bi2, this.bi3);
        }
        derOutputStream2.write((byte)48, derOutputStream3.toByteArray());
        derOutputStream2.putBitString(this.key);
        derOutputStream.write((byte)48, derOutputStream2);
        return derOutputStream.toByteArray();
    }

    private ObjectIdentifier a(DerInputStream derInputStream, DerOutputStream derOutputStream) throws IOException {
        NamedParameterSpec.CURVE cURVE;
        ObjectIdentifier objectIdentifier;
        block5: {
            DerOutputStream derOutputStream2;
            objectIdentifier = derInputStream.getOID();
            XECKey.checkOid(objectIdentifier);
            try {
                derOutputStream2 = derInputStream.getSequence(3);
                if (((DerValue[])derOutputStream2).length < 3) {
                    throw new IOException(z[8]);
                }
                this.bi1 = derOutputStream2[0].getInteger();
                this.bi2 = derOutputStream2[1].getInteger();
                this.bi3 = derOutputStream2[2].getInteger();
                int n2 = this.bi1.bitLength();
                cURVE = XECKey.getCurve(objectIdentifier, n2);
            }
            catch (IOException iOException) {
                cURVE = XECKey.getCurve(objectIdentifier, null);
            }
            if (derOutputStream == null) break block5;
            derOutputStream.putOID(objectIdentifier);
            if (!XECKey.isFFDHE(cURVE)) break block5;
            derOutputStream2 = new DerOutputStream();
            derOutputStream2.putInteger(this.bi1);
            derOutputStream2.putInteger(this.bi2);
            derOutputStream2.putInteger(this.bi3);
            derOutputStream.write((byte)48, derOutputStream2.toByteArray());
        }
        this.params = new NamedParameterSpec(cURVE);
        return objectIdentifier;
    }

    private byte[] a(byte[] byArray) throws IOException {
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream.getSequence(2);
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        ObjectIdentifier objectIdentifier = this.a(derValueArray[0].toDerInputStream(), derOutputStream2);
        derOutputStream.write((byte)48, derOutputStream2.toByteArray());
        if (derValueArray.length <= 1) {
            throw new IOException(z[0]);
        }
        Object object = derValueArray[1].getBitString();
        derOutputStream.putBitString(object);
        object = new DerOutputStream();
        object.write((byte)48, derOutputStream);
        return object.toByteArray();
    }

    private byte[] b(byte[] byArray) throws IOException {
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream.getSequence(2);
        if (derValueArray.length < 2) {
            throw new IOException(z[16]);
        }
        DerInputStream derInputStream2 = null;
        derInputStream2 = derValueArray[0].getData();
        if (derInputStream2.tag != 0) {
            throw new IOException(z[15]);
        }
        this.a(derInputStream2, null);
        DerInputStream derInputStream3 = new DerInputStream(derValueArray[1].getBitString());
        return derInputStream3.getInteger().toByteArray();
    }

    private static void c(byte[] byArray) throws IOException {
        for (int i2 = 0; i2 < byArray.length / 2; ++i2) {
            byte by = byArray[i2];
            byArray[i2] = byArray[byArray.length - 1 - i2];
            byArray[byArray.length - 1 - i2] = by;
        }
    }

    XECKey c() {
        return this.xecKey;
    }

    public BigInteger getU() {
        return this.u;
    }

    public AlgorithmParameterSpec getParams() {
        return this.params;
    }

    public byte[] getEncoded() {
        try {
            NamedParameterSpec.CURVE cURVE = this.params.getCurve();
            if (XECKey.isXEC(cURVE)) {
                return this.key;
            }
            if (this.encodedKey == null) {
                DerOutputStream derOutputStream;
                DerOutputStream derOutputStream2;
                block13: {
                    block12: {
                        DerOutputStream derOutputStream3;
                        block11: {
                            block10: {
                                derOutputStream2 = new DerOutputStream();
                                DerOutputStream derOutputStream4 = null;
                                if (XECKey.isFFDHE(cURVE)) {
                                    derOutputStream4 = new DerOutputStream();
                                    derOutputStream4.putInteger(this.bi1);
                                    derOutputStream4.putInteger(this.bi2);
                                    derOutputStream4.putInteger(this.bi3);
                                }
                                derOutputStream3 = new DerOutputStream();
                                derOutputStream3.putOID(this.algid.getOID());
                                if (derOutputStream4 == null) break block10;
                                derOutputStream3.write((byte)48, derOutputStream4);
                                break block11;
                            }
                            derOutputStream3.putNull();
                        }
                        DerOutputStream derOutputStream5 = null;
                        if (XECKey.isFFDHE(cURVE)) {
                            derOutputStream5 = new DerOutputStream();
                            derOutputStream5.putInteger(new BigInteger(this.key));
                        }
                        derOutputStream = new DerOutputStream();
                        derOutputStream.write((byte)48, derOutputStream3);
                        if (derOutputStream5 == null) break block12;
                        derOutputStream.putBitString(derOutputStream5.toByteArray());
                        break block13;
                    }
                    derOutputStream.putBitString(this.key);
                }
                derOutputStream2.write((byte)48, derOutputStream.toByteArray());
                this.encodedKey = derOutputStream2.toByteArray();
            }
            return (byte[])this.encodedKey.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void decode(byte[] byArray) throws InvalidKeyException {
        try {
            this.encodedKey = (byte[])byArray.clone();
            DerInputStream derInputStream = new DerInputStream(byArray);
            DerValue[] derValueArray = derInputStream.getSequence(2);
            if (derValueArray.length < 2) {
                throw new InvalidKeyException(z[17]);
            }
            DerInputStream derInputStream2 = derValueArray[0].toDerInputStream();
            ObjectIdentifier objectIdentifier = this.a(derInputStream2, null);
            this.algid = XECKey.getAlgId(this.params.getCurve());
            if (XECKey.isFFDHE(this.params.getCurve())) {
                DerInputStream derInputStream3 = new DerInputStream(derValueArray[1].getBitString());
                this.key = derInputStream3.getBigInteger().toByteArray();
            } else {
                this.key = derValueArray[1].getBitString();
            }
        }
        catch (Exception exception) {
            throw new InvalidKeyException(z[18]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void destroy() throws DestroyFailedException {
        if (!this.destroyed) {
            this.destroyed = true;
            if (this.key != null) {
                Arrays.fill(this.key, (byte)0);
            }
            this.xecKey = null;
            this.u = null;
            this.params = null;
        }
    }

    private void d() {
        if (this.destroyed) {
            throw new IllegalStateException(z[6]);
        }
    }

    protected Object writeReplace() throws ObjectStreamException {
        this.d();
        return new JCEPlusKeyRep(JCEPlusKeyRep$Type.PUBLIC, this.getAlgorithm(), this.getFormat(), this.getEncoded(), this.provider.getName());
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[19];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u007f+tMQ^\u001fS\bLX\u000b\u0006\tM^\u001d\u0006\u0003MONE\u0002LO\u000fO\u0003\u0002K\u001bD\u0001KXNM\b[";
        int n3 = -1;
        block26: while (true) {
            char[] cArray;
            block30: {
                int n4;
                int n5;
                block29: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block29;
                    n5 = n5;
                    if (n5 <= n4) break block30;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 59;
                            break;
                        }
                        case 1: {
                            n6 = 110;
                            break;
                        }
                        case 2: {
                            n6 = 38;
                            break;
                        }
                        case 3: {
                            n6 = 109;
                            break;
                        }
                        default: {
                            n6 = 34;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "cZ\u0012U";
                    n3 = 0;
                    continue block26;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "}\u000fO\u0001G_NR\u0002\u0002X\u001cC\fV^N~(a\u001b\u001eS\u000fNR\r\u0006\u0006GB";
                    n3 = 1;
                    continue block26;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "K\u001cI\u001bK_\u000bTMON\u001dRMLT\u001a\u0006\u000fG\u001b\u0000S\u0001N";
                    n3 = 2;
                    continue block26;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "}(b%g\u001b\u000fJ\nMI\u0007R\u0005OHNG\u001fG\u001b\u0000I\u0019\u0002H\u001bV\u001dM^\u001cR\bF";
                    n3 = 3;
                    continue block26;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "K\u000fT\fOHNK\u0018QOND\b\u0002T\b\u0006\u0019[K\u000b\u0006#CV\u000bB=CI\u000fK\bV^\u001cu\u001dGX";
                    n3 = 4;
                    continue block26;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "o\u0006O\u001e\u0002P\u000b_MKHNH\u0002\u0002W\u0001H\nGINP\fNR\n";
                    n3 = 5;
                    continue block26;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "P\u000b_MN^\u0000A\u0019J\u001b\u0003S\u001eV\u001b\fCM";
                    n3 = 6;
                    continue block26;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "o\u0006O\u001e\u0002X\u001bT\u001bG\u001b\nI\bQ\u001b\u0000I\u0019\u0002H\u000bC\u0000\u0002O\u0001\u0006\u000fG\u001b\u000f\u0006\u001bCW\u0007BMz~-\t+d\u007f&cMAN\u001cP\b";
                    n3 = 7;
                    continue block26;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "K\u001cI\u001bK_\u000bTMAZ\u0000H\u0002V\u001b\fCMLN\u0002J";
                    n3 = 8;
                    continue block26;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "}\u000fO\u0001G_NR\u0002\u0002X\u001cC\fV^N~(a\u001b\u001eS\u000fNR\r\u0006\u0006GB";
                    n3 = 9;
                    continue block26;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "^\u0000E\u0002F^\n\u0006\u0006GBNE\fLU\u0001RM@^NH\u0018NW";
                    n3 = 10;
                    continue block26;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "}\u000fO\u0001G_NR\u0002\u0002X\u001cC\fV^N~(a\u001b\u001eS\u000fNR\r\u0006\u0006GB";
                    n3 = 11;
                    continue block26;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "K\u001cI\u001bK_\u000bTMAZ\u0000H\u0002V\u001b\fCMLN\u0002J";
                    n3 = 12;
                    continue block26;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "C\u000bE&GBNE\fLU\u0001RM@^NH\u0018NW";
                    n3 = 13;
                    continue block26;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "\u001b:N\b\u0002U\u000b^\u0019\u0002^\u0000E\u0002F^\n\u0006\u001eVI\u001bE\u0019WI\u000b\u0006\u0000WH\u001a\u0006\u000fG\u001b\u000f\u0006\u000eMU\u001aC\u0015V\u001b\rI\u0003QO\u001cS\u000eV^\n\u0006\"k\u007f";
                    n3 = 14;
                    continue block26;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "o\u0006O\u001e\u0002X\u001bT\u001bG\u001b\nI\bQ\u001b\u0000I\u0019\u0002H\u000bC\u0000\u0002O\u0001\u0006\u000fG\u001b\u000f\u0006\u001bCW\u0007BMd}*n(\u0002X\u001bT\u001bG";
                    n3 = 15;
                    continue block26;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "p\u000b_MFT\u000bUMLT\u001a\u0006\fRK\u000bG\u001f\u0002O\u0001\u0006\u000fG\u001b\u000f\u00065gxA`+fs+\u0006\u0006GB";
                    n3 = 16;
                    continue block26;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "p\u000b_MFT\u000bUMLT\u001a\u0006\fRK\u000bG\u001f\u0002O\u0001\u0006\u000fG\u001b\u000f\u00065gxA`+fs+\u0006\u0006GB";
                    n3 = 17;
                    continue block26;
                }
                case 17: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

