/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.ECNamedCurve;
import com.ibm.crypto.hdwrCCA.provider.d;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.AlgorithmParametersSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECField;
import java.security.spec.ECFieldFp;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidParameterSpecException;

public final class ECParameters
extends AlgorithmParametersSpi {
    private int a;
    private EllipticCurve b;
    private ECPoint c;
    private BigInteger d;
    private static Debug e;
    private static String f;
    private static final String[] g;

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        try {
            if (e != null) {
                e.entry(Debug.TYPE_FINE, f, g[51]);
            }
        }
        catch (IOException iOException) {
            throw ECParameters.b(iOException);
        }
        EllipticCurve ellipticCurve = this.b;
        ECPoint eCPoint = this.c;
        BigInteger bigInteger = this.d;
        int n2 = this.a;
        ECParameterSpec eCParameterSpec = new ECParameterSpec(ellipticCurve, eCPoint, bigInteger, n2);
        ObjectIdentifier objectIdentifier = ECNamedCurve.a(eCParameterSpec);
        if (objectIdentifier != null) {
            byte[] byArray = ECNamedCurve.a(objectIdentifier);
            try {
                if (e != null) {
                    e.text(Debug.TYPE_PUBLIC, f, g[33], g[24]);
                    e.exit(Debug.TYPE_FINE, (Object)f, g[33], byArray);
                }
            }
            catch (IOException iOException) {
                throw ECParameters.b(iOException);
            }
            return byArray;
        }
        try {
            if (e != null) {
                e.text(Debug.TYPE_PUBLIC, f, g[33], g[54]);
            }
        }
        catch (IOException iOException) {
            throw ECParameters.b(iOException);
        }
        ECField eCField = ellipticCurve.getField();
        DerOutputStream derOutputStream = new DerOutputStream();
        try {
            derOutputStream.putInteger(1);
            if (!(eCField instanceof ECFieldFp)) {
                String[] stringArray = g;
                IOException iOException = new IOException(stringArray[63]);
                try {
                    if (e != null) {
                        e.exception(Debug.TYPE_PUBLIC, f, stringArray[33], iOException);
                        e.exit(Debug.TYPE_FINE, f, stringArray[33]);
                    }
                }
                catch (IOException iOException2) {
                    throw ECParameters.b(iOException2);
                }
                throw iOException;
            }
            DerValue derValue = ECParameters.a((ECFieldFp)eCField);
            derOutputStream.putDerValue(derValue);
            derValue = ECParameters.a(ellipticCurve);
            derOutputStream.putDerValue(derValue);
            byte[] byArray = ECParameters.a(eCPoint, ellipticCurve);
            derOutputStream.putOctetString(byArray);
            derOutputStream.putInteger(bigInteger);
            derOutputStream.putInteger(n2);
            DerValue derValue2 = new DerValue(48, derOutputStream.toByteArray());
            byte[] byArray2 = derValue2.toByteArray();
            try {
                if (e != null) {
                    e.exit(Debug.TYPE_FINE, (Object)f, g[33], byArray2);
                }
            }
            catch (IOException iOException) {
                throw ECParameters.b(iOException);
            }
            return byArray2;
        }
        catch (IOException iOException) {
            String[] stringArray = g;
            IOException iOException3 = new IOException(stringArray[3] + iOException.getMessage(), iOException);
            try {
                if (e != null) {
                    e.exception(Debug.TYPE_PUBLIC, f, stringArray[33], iOException);
                    e.exception(Debug.TYPE_PUBLIC, f, stringArray[33], iOException3);
                    e.exit(Debug.TYPE_FINE, f, stringArray[33]);
                }
            }
            catch (IOException iOException4) {
                throw ECParameters.b(iOException4);
            }
            throw iOException3;
        }
    }

    @Override
    protected byte[] engineGetEncoded(String string) throws IOException {
        try {
            if (e != null) {
                e.entry(Debug.TYPE_FINE, (Object)f, g[33], string);
                e.text(Debug.TYPE_PUBLIC, f, g[33], g[20] + string + g[72]);
            }
        }
        catch (IOException iOException) {
            throw ECParameters.b(iOException);
        }
        byte[] byArray = this.engineGetEncoded();
        try {
            if (e != null) {
                e.exit(Debug.TYPE_FINE, (Object)f, g[33], byArray);
            }
        }
        catch (IOException iOException) {
            throw ECParameters.b(iOException);
        }
        return byArray;
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> clazz) throws InvalidParameterSpecException {
        block27: {
            block28: {
                try {
                    if (e != null) {
                        e.entry(Debug.TYPE_FINE, (Object)f, g[19], clazz);
                    }
                }
                catch (InvalidParameterSpecException invalidParameterSpecException) {
                    throw ECParameters.b(invalidParameterSpecException);
                }
                if (clazz == null) {
                    String[] stringArray = g;
                    NullPointerException nullPointerException = new NullPointerException(stringArray[62]);
                    try {
                        if (e != null) {
                            e.exception(Debug.TYPE_PUBLIC, f, stringArray[27], nullPointerException);
                            e.exit(Debug.TYPE_FINE, f, stringArray[27]);
                        }
                    }
                    catch (InvalidParameterSpecException invalidParameterSpecException) {
                        throw ECParameters.b(invalidParameterSpecException);
                    }
                    throw nullPointerException;
                }
                if (clazz.isAssignableFrom(ECParameterSpec.class)) {
                    ECParameterSpec eCParameterSpec = new ECParameterSpec(this.b, this.c, this.d, this.a);
                    try {
                        if (e != null) {
                            e.exit(Debug.TYPE_FINE, (Object)f, g[27], eCParameterSpec);
                        }
                    }
                    catch (InvalidParameterSpecException invalidParameterSpecException) {
                        throw ECParameters.b(invalidParameterSpecException);
                    }
                    return (T)((AlgorithmParameterSpec)clazz.cast(eCParameterSpec));
                }
                try {
                    try {
                        if (!clazz.isAssignableFrom(ECGenParameterSpec.class)) break block27;
                        if (e == null) break block28;
                    }
                    catch (InvalidParameterSpecException invalidParameterSpecException) {
                        throw ECParameters.b(invalidParameterSpecException);
                    }
                    e.text(Debug.TYPE_PUBLIC, g[16], g[27], g[49]);
                }
                catch (InvalidParameterSpecException invalidParameterSpecException) {
                    throw ECParameters.b(invalidParameterSpecException);
                }
            }
            ECParameterSpec eCParameterSpec = new ECParameterSpec(this.b, this.c, this.d, this.a);
            try {
                if (e != null) {
                    e.text(Debug.TYPE_PUBLIC, g[35], g[27], g[15] + eCParameterSpec);
                }
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw ECParameters.b(invalidParameterSpecException);
            }
            String string = ECNamedCurve.b(eCParameterSpec);
            try {
                if (e != null) {
                    e.text(Debug.TYPE_PUBLIC, g[35], g[27], g[17] + string);
                }
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw ECParameters.b(invalidParameterSpecException);
            }
            ECGenParameterSpec eCGenParameterSpec = new ECGenParameterSpec(string);
            try {
                if (e != null) {
                    e.exit(Debug.TYPE_PUBLIC, (Object)g[35], g[27], eCGenParameterSpec);
                }
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw ECParameters.b(invalidParameterSpecException);
            }
            return (T)((AlgorithmParameterSpec)clazz.cast(eCGenParameterSpec));
        }
        String[] stringArray = g;
        InvalidParameterSpecException invalidParameterSpecException = new InvalidParameterSpecException(stringArray[2]);
        try {
            if (e != null) {
                e.exception(Debug.TYPE_PUBLIC, f, stringArray[27], invalidParameterSpecException);
                e.exit(Debug.TYPE_FINE, f, stringArray[27]);
            }
        }
        catch (InvalidParameterSpecException invalidParameterSpecException2) {
            throw ECParameters.b(invalidParameterSpecException2);
        }
        throw invalidParameterSpecException;
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        block17: {
            try {
                if (e != null) {
                    e.entry(Debug.TYPE_FINE, (Object)f, g[5], algorithmParameterSpec);
                }
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw ECParameters.b(invalidParameterSpecException);
            }
            try {
                if (algorithmParameterSpec instanceof ECParameterSpec || algorithmParameterSpec instanceof ECGenParameterSpec) break block17;
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw ECParameters.b(invalidParameterSpecException);
            }
            String[] stringArray = g;
            InvalidParameterSpecException invalidParameterSpecException = new InvalidParameterSpecException(stringArray[45]);
            try {
                if (e != null) {
                    e.text(Debug.TYPE_PUBLIC, f, stringArray[5], stringArray[8]);
                    e.exception(Debug.TYPE_PUBLIC, f, stringArray[5], invalidParameterSpecException);
                    e.exit(Debug.TYPE_FINE, f, stringArray[5]);
                }
            }
            catch (InvalidParameterSpecException invalidParameterSpecException2) {
                throw ECParameters.b(invalidParameterSpecException2);
            }
            throw invalidParameterSpecException;
        }
        ECParameterSpec eCParameterSpec = null;
        if (algorithmParameterSpec instanceof ECParameterSpec) {
            eCParameterSpec = (ECParameterSpec)algorithmParameterSpec;
        } else {
            String string = ((ECGenParameterSpec)algorithmParameterSpec).getName();
            eCParameterSpec = ECNamedCurve.c(string);
            if (eCParameterSpec == null) {
                String[] stringArray = g;
                InvalidParameterSpecException invalidParameterSpecException = new InvalidParameterSpecException(stringArray[31] + string);
                try {
                    if (e != null) {
                        e.exception(Debug.TYPE_PUBLIC, f, stringArray[5], invalidParameterSpecException);
                        e.exit(Debug.TYPE_FINE, f, stringArray[5]);
                    }
                }
                catch (InvalidParameterSpecException invalidParameterSpecException3) {
                    throw ECParameters.b(invalidParameterSpecException3);
                }
                throw invalidParameterSpecException;
            }
        }
        try {
            this.b = eCParameterSpec.getCurve();
            this.c = eCParameterSpec.getGenerator();
            this.d = eCParameterSpec.getOrder();
            this.a = eCParameterSpec.getCofactor();
            if (e != null) {
                e.exit(Debug.TYPE_FINE, f, g[5]);
            }
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw ECParameters.b(invalidParameterSpecException);
        }
    }

    @Override
    protected void engineInit(byte[] byArray) throws IOException {
        ECParameterSpec eCParameterSpec;
        block26: {
            eCParameterSpec = null;
            try {
                if (e != null) {
                    e.entry(Debug.TYPE_FINE, (Object)f, g[5], (Object)byArray);
                }
            }
            catch (IOException iOException) {
                throw ECParameters.b(iOException);
            }
            if (byArray == null) {
                String[] stringArray = g;
                NullPointerException nullPointerException = new NullPointerException(stringArray[70]);
                try {
                    if (e != null) {
                        e.exception(Debug.TYPE_PUBLIC, f, stringArray[5], nullPointerException);
                        e.exit(Debug.TYPE_FINE, f, stringArray[5]);
                    }
                }
                catch (IOException iOException) {
                    throw ECParameters.b(iOException);
                }
                throw nullPointerException;
            }
            try {
                DerValue derValue;
                block24: {
                    block25: {
                        DerInputStream derInputStream = new DerInputStream(byArray);
                        derValue = derInputStream.getDerValue();
                        try {
                            if (derValue.getTag() == 48) break block24;
                            if (derValue.getTag() != 6) break block25;
                        }
                        catch (IOException iOException) {
                            throw ECParameters.b(iOException);
                        }
                        String string = derValue.getOID().toString();
                        eCParameterSpec = ECNamedCurve.c(string);
                        if (eCParameterSpec != null) break block26;
                        String[] stringArray = g;
                        IOException iOException = new IOException(stringArray[45]);
                        try {
                            if (e != null) {
                                e.exception(Debug.TYPE_PUBLIC, f, stringArray[5], iOException);
                                e.exit(Debug.TYPE_FINE, f, stringArray[5]);
                            }
                        }
                        catch (IOException iOException2) {
                            throw ECParameters.b(iOException2);
                        }
                        throw iOException;
                    }
                    String[] stringArray = g;
                    IOException iOException = new IOException(stringArray[9]);
                    try {
                        if (e != null) {
                            e.exception(Debug.TYPE_PUBLIC, f, stringArray[5], iOException);
                            e.exit(Debug.TYPE_FINE, f, stringArray[5]);
                        }
                    }
                    catch (IOException iOException3) {
                        throw ECParameters.b(iOException3);
                    }
                    throw iOException;
                }
                DerInputStream derInputStream = derValue.getData();
                derInputStream.getInteger();
                DerValue derValue2 = derInputStream.getDerValue();
                ECFieldFp eCFieldFp = ECParameters.a(derValue2);
                DerValue derValue3 = derInputStream.getDerValue();
                EllipticCurve ellipticCurve = ECParameters.a(derValue3, eCFieldFp);
                byte[] byArray2 = derInputStream.getOctetString();
                ECPoint eCPoint = ECParameters.a(byArray2, ellipticCurve);
                BigInteger bigInteger = derInputStream.getBigInteger();
                int n2 = 0;
                boolean bl = false;
                if (derInputStream.available() != 0) {
                    bl = true;
                    n2 = derInputStream.getInteger().intValue();
                }
                eCParameterSpec = bl ? new ECParameterSpec(ellipticCurve, eCPoint, bigInteger, n2) : new ECParameterSpec(ellipticCurve, eCPoint, bigInteger, 0);
            }
            catch (IOException iOException) {
                String[] stringArray = g;
                IOException iOException4 = new IOException(stringArray[60], iOException);
                try {
                    if (e != null) {
                        e.exception(Debug.TYPE_PUBLIC, f, stringArray[5], iOException);
                        e.exception(Debug.TYPE_PUBLIC, f, stringArray[5], iOException4);
                        e.exit(Debug.TYPE_FINE, f, stringArray[5]);
                    }
                }
                catch (IOException iOException5) {
                    throw ECParameters.b(iOException5);
                }
                throw iOException4;
            }
        }
        try {
            this.b = eCParameterSpec.getCurve();
            this.c = eCParameterSpec.getGenerator();
            this.d = eCParameterSpec.getOrder();
            this.a = eCParameterSpec.getCofactor();
            if (e != null) {
                e.exit(Debug.TYPE_FINE, f, g[5]);
            }
        }
        catch (IOException iOException) {
            throw ECParameters.b(iOException);
        }
    }

    @Override
    protected void engineInit(byte[] byArray, String string) throws IOException {
        try {
            if (e != null) {
                e.entry(Debug.TYPE_FINE, f, g[39], byArray, string);
                e.text(Debug.TYPE_PUBLIC, f, g[5], g[67] + string + g[68]);
            }
        }
        catch (IOException iOException) {
            throw ECParameters.b(iOException);
        }
        try {
            this.engineInit(byArray);
            if (e != null) {
                e.exit(Debug.TYPE_FINE, f, g[5]);
            }
        }
        catch (IOException iOException) {
            throw ECParameters.b(iOException);
        }
    }

    @Override
    protected String engineToString() {
        try {
            if (e != null) {
                e.entry(Debug.TYPE_FINE, f, g[29]);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw ECParameters.b(nullPointerException);
        }
        String[] stringArray = g;
        String string = stringArray[55] + this.b.getA() + stringArray[1] + this.b.getB() + stringArray[0] + this.b.getField().getFieldSize() + stringArray[65] + com.ibm.crypto.hdwrCCA.provider.d.a(this.c) + stringArray[42] + this.d.toString() + stringArray[71] + this.a + "\n";
        try {
            if (e != null) {
                e.exit(Debug.TYPE_FINE, (Object)f, stringArray[69], string);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw ECParameters.b(nullPointerException);
        }
        return string;
    }

    static byte[] a(ECPoint eCPoint, EllipticCurve ellipticCurve) throws IOException {
        byte[] byArray;
        byte[] byArray2;
        int n2;
        block17: {
            block16: {
                try {
                    if (e != null) {
                        e.entry(Debug.TYPE_FINE, f, g[74], eCPoint, ellipticCurve);
                    }
                }
                catch (IOException iOException) {
                    throw ECParameters.b(iOException);
                }
                try {
                    if (eCPoint != null && ellipticCurve != null) break block16;
                }
                catch (IOException iOException) {
                    throw ECParameters.b(iOException);
                }
                String[] stringArray = g;
                NullPointerException nullPointerException = new NullPointerException(stringArray[47]);
                try {
                    if (e != null) {
                        e.exception(Debug.TYPE_PUBLIC, f, stringArray[22], nullPointerException);
                        e.exit(Debug.TYPE_FINE, f, stringArray[22]);
                    }
                }
                catch (IOException iOException) {
                    throw ECParameters.b(iOException);
                }
                throw nullPointerException;
            }
            n2 = ellipticCurve.getField().getFieldSize() + 7 >> 3;
            byArray2 = ECParameters.a(eCPoint.getAffineX().toByteArray());
            byArray = ECParameters.a(eCPoint.getAffineY().toByteArray());
            try {
                if (byArray2.length <= n2 && byArray.length <= n2) break block17;
            }
            catch (IOException iOException) {
                throw ECParameters.b(iOException);
            }
            String[] stringArray = g;
            IOException iOException = new IOException(stringArray[40]);
            try {
                if (e != null) {
                    e.exception(Debug.TYPE_PUBLIC, f, stringArray[22], iOException);
                    e.exit(Debug.TYPE_FINE, f, stringArray[22]);
                }
            }
            catch (IOException iOException2) {
                throw ECParameters.b(iOException2);
            }
            throw iOException;
        }
        byte[] byArray3 = new byte[1 + (n2 << 1)];
        try {
            byArray3[0] = 4;
            System.arraycopy(byArray2, 0, byArray3, n2 - byArray2.length + 1, byArray2.length);
            System.arraycopy(byArray, 0, byArray3, byArray3.length - byArray.length, byArray.length);
            if (e != null) {
                e.exit(Debug.TYPE_FINE, (Object)f, g[22], byArray3);
            }
        }
        catch (IOException iOException) {
            throw ECParameters.b(iOException);
        }
        return byArray3;
    }

    static ECPoint a(byte[] byArray, EllipticCurve ellipticCurve) throws IOException {
        block21: {
            block20: {
                try {
                    if (e != null) {
                        e.entry(Debug.TYPE_FINE, f, g[48], byArray, ellipticCurve);
                    }
                }
                catch (IOException iOException) {
                    throw ECParameters.b(iOException);
                }
                try {
                    if (byArray != null && ellipticCurve != null) break block20;
                }
                catch (IOException iOException) {
                    throw ECParameters.b(iOException);
                }
                String[] stringArray = g;
                NullPointerException nullPointerException = new NullPointerException(stringArray[58]);
                try {
                    if (e != null) {
                        e.exception(Debug.TYPE_PUBLIC, f, stringArray[25], nullPointerException);
                        e.exit(Debug.TYPE_FINE, f, stringArray[25]);
                    }
                }
                catch (IOException iOException) {
                    throw ECParameters.b(iOException);
                }
                throw nullPointerException;
            }
            try {
                if (byArray.length != 0 && byArray[0] == 4) break block21;
            }
            catch (IOException iOException) {
                throw ECParameters.b(iOException);
            }
            String[] stringArray = g;
            IOException iOException = new IOException(stringArray[26]);
            try {
                if (e != null) {
                    e.exception(Debug.TYPE_PUBLIC, f, stringArray[25], iOException);
                    e.exit(Debug.TYPE_FINE, f, stringArray[25]);
                }
            }
            catch (IOException iOException2) {
                throw ECParameters.b(iOException2);
            }
            throw iOException;
        }
        int n2 = ellipticCurve.getField().getFieldSize() + 7 >> 3;
        if (byArray.length != n2 * 2 + 1) {
            String[] stringArray = g;
            IOException iOException = new IOException(stringArray[66]);
            try {
                if (e != null) {
                    e.exception(Debug.TYPE_PUBLIC, f, stringArray[25], iOException);
                    e.exit(Debug.TYPE_FINE, f, stringArray[25]);
                }
            }
            catch (IOException iOException3) {
                throw ECParameters.b(iOException3);
            }
            throw iOException;
        }
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, 1, byArray2, 0, n2);
        System.arraycopy(byArray, n2 + 1, byArray3, 0, n2);
        ECPoint eCPoint = new ECPoint(new BigInteger(1, byArray2), new BigInteger(1, byArray3));
        try {
            if (e != null) {
                e.exit(Debug.TYPE_FINE, (Object)f, g[25], eCPoint);
            }
        }
        catch (IOException iOException) {
            throw ECParameters.b(iOException);
        }
        return eCPoint;
    }

    private static byte[] a(byte[] byArray) {
        int n2;
        block22: {
            block23: {
                block19: {
                    block20: {
                        n2 = 0;
                        try {
                            if (e != null) {
                                e.entry(Debug.TYPE_FINE, (Object)f, g[18], (Object)byArray);
                            }
                        }
                        catch (NullPointerException nullPointerException) {
                            throw ECParameters.b(nullPointerException);
                        }
                        try {
                            try {
                                if (byArray != null) break block19;
                                if (e == null) break block20;
                            }
                            catch (NullPointerException nullPointerException) {
                                throw ECParameters.b(nullPointerException);
                            }
                            e.text(8192L, f, g[52], g[56]);
                            e.exit(Debug.TYPE_FINE, (Object)f, g[52], null);
                        }
                        catch (NullPointerException nullPointerException) {
                            throw ECParameters.b(nullPointerException);
                        }
                    }
                    return null;
                }
                try {
                    while (true) {
                        try {
                            if (n2 >= byArray.length - 1 || byArray[n2] != 0) break;
                        }
                        catch (NullPointerException nullPointerException) {
                            throw ECParameters.b(nullPointerException);
                        }
                        ++n2;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    throw ECParameters.b(nullPointerException);
                }
                try {
                    try {
                        if (n2 != 0) break block22;
                        if (e == null) break block23;
                    }
                    catch (NullPointerException nullPointerException) {
                        throw ECParameters.b(nullPointerException);
                    }
                    e.text(8192L, f, g[52], g[43]);
                    e.exit(Debug.TYPE_FINE, (Object)f, g[52], byArray);
                }
                catch (NullPointerException nullPointerException) {
                    throw ECParameters.b(nullPointerException);
                }
            }
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length - n2];
        try {
            System.arraycopy(byArray, n2, byArray2, 0, byArray2.length);
            if (e != null) {
                e.exit(Debug.TYPE_FINE, (Object)f, g[52], byArray2);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw ECParameters.b(nullPointerException);
        }
        return byArray2;
    }

    private static DerValue a(EllipticCurve ellipticCurve) throws IOException {
        try {
            if (e != null) {
                e.entry(Debug.TYPE_FINE, (Object)f, g[13], ellipticCurve);
            }
        }
        catch (IOException iOException) {
            throw ECParameters.b(iOException);
        }
        if (ellipticCurve == null) {
            String[] stringArray = g;
            NullPointerException nullPointerException = new NullPointerException(stringArray[7]);
            try {
                if (e != null) {
                    e.exception(8192L, f, stringArray[41], nullPointerException);
                    e.exit(Debug.TYPE_FINE, f, stringArray[41]);
                }
            }
            catch (IOException iOException) {
                throw ECParameters.b(iOException);
            }
            throw nullPointerException;
        }
        try {
            byte[] byArray = ECParameters.a(ellipticCurve.getA().toByteArray());
            byte[] byArray2 = ECParameters.a(ellipticCurve.getB().toByteArray());
            byte[] byArray3 = ellipticCurve.getSeed();
            DerOutputStream derOutputStream = new DerOutputStream();
            try {
                derOutputStream.putOctetString(byArray);
                derOutputStream.putOctetString(byArray2);
                if (byArray3 != null) {
                    derOutputStream.putBitString(byArray3);
                }
            }
            catch (IOException iOException) {
                throw ECParameters.b(iOException);
            }
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            try {
                if (e != null) {
                    e.exit(Debug.TYPE_FINE, (Object)f, g[41], derValue);
                }
            }
            catch (IOException iOException) {
                throw ECParameters.b(iOException);
            }
            return derValue;
        }
        catch (IOException iOException) {
            String[] stringArray = g;
            IOException iOException2 = new IOException(stringArray[37] + iOException.getMessage(), iOException);
            try {
                if (e != null) {
                    e.exception(8192L, f, stringArray[41], iOException);
                    e.exception(8192L, f, stringArray[41], iOException2);
                    e.exit(Debug.TYPE_FINE, f, stringArray[41]);
                }
            }
            catch (IOException iOException3) {
                throw ECParameters.b(iOException3);
            }
            throw iOException2;
        }
    }

    private static EllipticCurve a(DerValue derValue, ECField eCField) throws IOException {
        block21: {
            try {
                if (e != null) {
                    e.entry(Debug.TYPE_FINE, f, g[28], derValue, eCField);
                }
            }
            catch (IOException iOException) {
                throw ECParameters.b(iOException);
            }
            try {
                if (derValue != null && eCField != null) break block21;
            }
            catch (IOException iOException) {
                throw ECParameters.b(iOException);
            }
            String[] stringArray = g;
            NullPointerException nullPointerException = new NullPointerException(stringArray[6]);
            try {
                if (e != null) {
                    e.exception(8192L, f, stringArray[73], nullPointerException);
                    e.exit(Debug.TYPE_FINE, f, stringArray[73]);
                }
            }
            catch (IOException iOException) {
                throw ECParameters.b(iOException);
            }
            throw nullPointerException;
        }
        try {
            if (derValue.getTag() != 48) {
                String[] stringArray = g;
                IOException iOException = new IOException(stringArray[59]);
                try {
                    if (e != null) {
                        e.exception(8192L, f, stringArray[73], iOException);
                        e.exit(Debug.TYPE_FINE, f, stringArray[73]);
                    }
                }
                catch (IOException iOException2) {
                    throw ECParameters.b(iOException2);
                }
                throw iOException;
            }
            DerInputStream derInputStream = derValue.getData();
            byte[] byArray = derInputStream.getOctetString();
            BigInteger bigInteger = new BigInteger(1, byArray);
            byte[] byArray2 = derInputStream.getOctetString();
            BigInteger bigInteger2 = new BigInteger(1, byArray2);
            byte[] byArray3 = null;
            if (derInputStream.available() != 0) {
                byArray3 = derInputStream.getBitString();
            }
            EllipticCurve ellipticCurve = null;
            ellipticCurve = byArray3 == null ? new EllipticCurve(eCField, bigInteger, bigInteger2) : new EllipticCurve(eCField, bigInteger, bigInteger2, byArray3);
            try {
                if (e != null) {
                    e.exit(Debug.TYPE_FINE, (Object)f, g[73], ellipticCurve);
                }
            }
            catch (IOException iOException) {
                throw ECParameters.b(iOException);
            }
            return ellipticCurve;
        }
        catch (IOException iOException) {
            String[] stringArray = g;
            IOException iOException3 = new IOException(stringArray[53] + iOException.getMessage(), iOException);
            try {
                if (e != null) {
                    e.exception(8192L, f, stringArray[73], iOException);
                    e.exception(8192L, f, stringArray[73], iOException3);
                    e.exit(Debug.TYPE_FINE, f, stringArray[73]);
                }
            }
            catch (IOException iOException4) {
                throw ECParameters.b(iOException4);
            }
            throw iOException3;
        }
    }

    private static DerValue a(ECFieldFp eCFieldFp) throws IOException {
        try {
            if (e != null) {
                e.entry(Debug.TYPE_FINE, (Object)f, g[36], eCFieldFp);
            }
        }
        catch (IOException iOException) {
            throw ECParameters.b(iOException);
        }
        if (eCFieldFp == null) {
            String[] stringArray = g;
            NullPointerException nullPointerException = new NullPointerException(stringArray[12]);
            try {
                if (e != null) {
                    e.exception(8192L, f, stringArray[4], nullPointerException);
                    e.exit(Debug.TYPE_FINE, f, stringArray[4]);
                }
            }
            catch (IOException iOException) {
                throw ECParameters.b(iOException);
            }
            throw nullPointerException;
        }
        try {
            int[] nArray = new int[]{1, 2, 840, 10045, 1, 1};
            ObjectIdentifier objectIdentifier = new ObjectIdentifier(nArray);
            BigInteger bigInteger = eCFieldFp.getP();
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putOID(objectIdentifier);
            derOutputStream.putInteger(bigInteger);
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            try {
                if (e != null) {
                    e.exit(Debug.TYPE_FINE, (Object)f, g[4], derValue);
                }
            }
            catch (IOException iOException) {
                throw ECParameters.b(iOException);
            }
            return derValue;
        }
        catch (IOException iOException) {
            String[] stringArray = g;
            IOException iOException2 = new IOException(stringArray[50] + iOException.getMessage(), iOException);
            try {
                if (e != null) {
                    e.exception(8192L, f, stringArray[4], iOException);
                    e.exception(8192L, f, stringArray[4], iOException2);
                    e.exit(Debug.TYPE_FINE, f, stringArray[4]);
                }
            }
            catch (IOException iOException3) {
                throw ECParameters.b(iOException3);
            }
            throw iOException2;
        }
    }

    private static ECFieldFp a(DerValue derValue) throws IOException {
        try {
            if (e != null) {
                e.entry(Debug.TYPE_FINE, (Object)f, g[57], derValue);
            }
        }
        catch (IOException iOException) {
            throw ECParameters.b(iOException);
        }
        if (derValue == null) {
            String[] stringArray = g;
            NullPointerException nullPointerException = new NullPointerException(stringArray[11]);
            try {
                if (e != null) {
                    e.exception(8192L, f, stringArray[46], nullPointerException);
                    e.exit(Debug.TYPE_FINE, f, stringArray[46]);
                }
            }
            catch (IOException iOException) {
                throw ECParameters.b(iOException);
            }
            throw nullPointerException;
        }
        int[] nArray = new int[]{1, 2, 840, 10045, 1, 1};
        ObjectIdentifier objectIdentifier = new ObjectIdentifier(nArray);
        try {
            if (derValue.getTag() != 48) {
                String[] stringArray = g;
                IOException iOException = new IOException(stringArray[21]);
                try {
                    if (e != null) {
                        e.exception(8192L, f, stringArray[46], iOException);
                        e.exit(Debug.TYPE_FINE, f, stringArray[46]);
                    }
                }
                catch (IOException iOException2) {
                    throw ECParameters.b(iOException2);
                }
                throw iOException;
            }
            DerInputStream derInputStream = derValue.getData();
            ObjectIdentifier objectIdentifier2 = derInputStream.getOID();
            if (!objectIdentifier2.equals(objectIdentifier)) {
                String[] stringArray = g;
                IOException iOException = new IOException(stringArray[30]);
                try {
                    if (e != null) {
                        e.exception(8192L, f, stringArray[46], iOException);
                        e.exit(Debug.TYPE_FINE, f, stringArray[46]);
                    }
                }
                catch (IOException iOException3) {
                    throw ECParameters.b(iOException3);
                }
                throw iOException;
            }
            BigInteger bigInteger = derInputStream.getInteger();
            ECFieldFp eCFieldFp = new ECFieldFp(bigInteger);
            try {
                if (e != null) {
                    e.exit(Debug.TYPE_FINE, (Object)f, g[46], eCFieldFp);
                }
            }
            catch (IOException iOException) {
                throw ECParameters.b(iOException);
            }
            return eCFieldFp;
        }
        catch (IOException iOException) {
            String[] stringArray = g;
            IOException iOException4 = new IOException(stringArray[38] + iOException.getMessage(), iOException);
            try {
                if (e != null) {
                    e.exception(8192L, f, stringArray[46], iOException);
                    e.exception(8192L, f, stringArray[46], iOException4);
                    e.exit(Debug.TYPE_FINE, f, stringArray[46]);
                }
            }
            catch (IOException iOException5) {
                throw ECParameters.b(iOException5);
            }
            throw iOException4;
        }
    }

    static AlgorithmParameters a(ECParameterSpec eCParameterSpec) throws InvalidParameterSpecException {
        try {
            if (e != null) {
                e.entry(Debug.TYPE_FINE, (Object)f, g[14], eCParameterSpec);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw ECParameters.b(noSuchAlgorithmException);
        }
        AlgorithmParameters algorithmParameters = null;
        try {
            String[] stringArray = g;
            algorithmParameters = AlgorithmParameters.getInstance(stringArray[64], stringArray[44]);
            algorithmParameters.init(eCParameterSpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            String[] stringArray = g;
            RuntimeException runtimeException = new RuntimeException(stringArray[23], noSuchAlgorithmException);
            try {
                if (e != null) {
                    e.exception(Debug.TYPE_PUBLIC, f, stringArray[10], noSuchAlgorithmException);
                    e.exception(Debug.TYPE_PUBLIC, f, stringArray[10], runtimeException);
                    e.exit(Debug.TYPE_FINE, f, stringArray[10]);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                throw ECParameters.b(noSuchAlgorithmException2);
            }
            throw runtimeException;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            String[] stringArray = g;
            RuntimeException runtimeException = new RuntimeException(stringArray[61], noSuchProviderException);
            try {
                if (e != null) {
                    e.exception(Debug.TYPE_PUBLIC, f, stringArray[10], noSuchProviderException);
                    e.exception(Debug.TYPE_PUBLIC, f, stringArray[10], runtimeException);
                    e.exit(Debug.TYPE_FINE, f, stringArray[10]);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw ECParameters.b(noSuchAlgorithmException);
            }
            throw runtimeException;
        }
        try {
            if (e != null) {
                e.exit(Debug.TYPE_FINE, (Object)f, g[10], algorithmParameters);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw ECParameters.b(noSuchAlgorithmException);
        }
        return algorithmParameters;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[75];
                var3_1 = 0;
                var2_2 = "@P/x+U\u0010py\u0006@P/ix\u000f%\u00037G{2]\u001a:+Oj6JU:8Tj/J\u0001/+\u0006x2J\u0016#?Oh#[\u001c%7\u001f\u000f!En2[\u001c%7\u0006b,\u000f\u0010$>Oe'h\u0010>\u001cHh-K\u0010.c\u0006\u0014/7Ed&J%80Kn\u0004F\u0010&=rr2J\n/7Ab,J<$0RM\u001f7Gi.JU>6\u0006o'L\u001a.<\u0006i'L\u0014?*C+'F\u0001\"<T+6G\u0010j<Hh-K\u0010.yE~0Y\u0010j6T+6G\u0010j?Oe+[\u0010j?On.KU#*\u0006e7C\u00199\u001f7Gi.JU>6\u0006n,L\u001a.<\u0006N.C\u001c:-Ohbl\u00008/C+ J\u0016+,Unb[\u001d/yE~0Y\u0010j0U+,Z\u0019&J:8Tj/|\u0005/:\u0006b1\u000f\u001b/0Rc']U+7\u0006b,\\\u0001+7Enb@\u0013j\u001ce[#]\u0014'<Rn0|\u0005/:\u0006e-]U\u000f\u001aan,\u007f\u001488Kn6J\u0007\u0019)Ch\u0018\u00046R+#\u000f&\u000f\bsN\fl0j6T+#AU\u0005\u0010b\u0016-<RJ.H\u001a80Rc/\u007f\u001488Kn6J\u00079N\u001f7Gi.JU>6\u0006o'L\u001a.<\u0006i'L\u0014?*C+6G\u0010j<Hh-K\u0010.ycg.F\u0005>0E+\u0001Z\u0007<<\u0006{0F\u0018/y@b,F\u0001/y@b'C\u0011j0U+,Z\u0019&F\u001f7Gi.JU>6\u0006n,L\u001a.<\u0006i'L\u0014?*C+6G\u0010j\u001cJg+_\u0001#:\u0006H7]\u0003/yVy+B\u0010j?Oe+[\u0010j?On.KU#*\u0006e7C\u0019\u0013/7Ed&J0&5O{6F\u0016\t,T}'\u0016-<RJ.H\u001a80Rc/\u007f\u001488Kn6J\u00079\u001b\r<Hn0N\u0001/=\u0006N\u0001\u007f\u001488Kn6J\u0007\u0019)Chx\u000f\t)5Gx1a\u0014'<\f\t,T}'\u000f;+4C1b\n>+Of\u0018J\u0007%<U\u0016/7Ab,J2/-vj0N\u0018/-Cy\u0011_\u0010)\u001f\u001e1C+1_\u0010)0@b'KU/7Ed&F\u001b-y@d0B\u0014>y\u0001\u000e\u00046R+#\u000f&\u000f\bsN\fl0\u000b/7Ed&J%%0H\u007f\u001f\u00037Rn0A\u0014&yCy0@\u0007fyHdbj6j8Jl-]\u001c>1KJ\u001e1Oxb\\\u0010>yImbj\u0019&0V\u007f+LU\t,T}'\u000f\u0005++Gf'[\u00108*\u0006h#AU(<\u0006n,L\u001a.<B+#\\U+yUb,H\u0019/yiB\u0006\u000f\u0003+5Sn\u000b.<Ed&J%%0H\u007f(\u00057JrbZ\u001b)6K{0J\u00069<B+2@\u001c$-\u0006m-]\u0018+-\u0006x7_\u0005%+Rn&\u0016/7Ab,J2/-vj0N\u0018/-Cy\u0011_\u0010)\u0013.<Ed&J0&5O{6F\u0016\t,T}'\u000e/7Ab,J!%\nRy+A\u00125\u00037Ed0]\u0010)-\u0006D\u000bkU/7Ed7A\u0001/+CobK\u000080HlbK\u0010)6Bn\u0012]\u001c'<`b'C\u0011\u001e Vn'\u00037G{2]\u001a:+Oj6JU:8Tj/J\u0001/+\u0006x2J\u0016#?Oh#[\u001c%7\u001c+\t#;Ka!J\u0016)8\u0010/7Ab,J2/-ce!@\u0011/=,)6K%+M\u0018d:Tr2[\u001ad1B|0l6\u000bwVy-Y\u001c.<T%\u0007l%++Gf'[\u00108*\t)5Gx1a\u0014'<\u0014/7Ed&J%80Kn\u0004F\u0010&=rr2J%\u000f+Td0\u000f\u0002\"0JnbJ\u001b)6Bb,HU\u000f5Jb2[\u001c)ye~0Y\u0010py\u001f\u000f+Td0\u000f\u0011/:Io+A\u0012j\tTb/J3#<Jo\u0016V\u0005/c\u0006\n/7Ab,J<$0R)\u001a6Oe6\u000f\u0016%6To+A\u0014><U+&@U$6R+/N\u0001)1\u0006m+J\u0019.yUb8J\u0013/7Ed&J0&5O{6F\u0016\t,T}'\f@PIy&J\u0007py,\u0002K\u0010\u00046\u0006g'N\u0011#7A+8J\u0007%*\t\u0003\u001bkA\u0001j6\t\u0018%\u00037G{2]\u001a:+Oj6JU:8Tj/J\u0001/+\u0006x2J\u0016#?Oh#[\u001c%7\u0014.<Ed&J%80Kn\u0004F\u0010&=rr2JC\u001e1C+1Z\u0005:5On&\u000f0&5O{6F\u0016j\u001aSy4JU:6Oe6\u000f\u0014$=\u0006h7]\u0003/yPj.Z\u00109yK~1[U$6R+ JU$,Jg\u000b.<Ed&J%%0H\u007f)9)ChbF\u0006j\u001ceL'A%++Gf'[\u00108\nVn!\u000fXj.Og.\u000f\u00168<G\u007f'\u0001\u001f\u000f+Td0\u000f\u0010$:Io+A\u0012j\tTb/J3#<Jo\u0016V\u0005/c\u0006\u0010/7Ab,J2/-ce!@\u0011/=\n>+Of\u0018J\u0007%<U$\u000f+Td0\u000f\u0002\"0JnbJ\u001b)6Bb,HU\u000f5Jb2[\u001c)\u001aSy4JOj3\u000f7Ed&F\u001b-yOe&F\u0003#=Sj.\u000f0&5O{6F\u0016j\u001aSy4JU:8Tj/J\u0001/+\u0006{+J\u0016/*\u000f@PE~0Y\u0010py,\u0002KNOj \u001e1C+1_\u0010)0@b'KU( RnbN\u000788_++\\U$,Jg\u0014.<Ed&J%80Kn\u0004F\u0010&=rr2JJ\u001e1C+1Z\u0005:5On&\u000f0&5O{6F\u0016j\u001aSy4JU/7Ed&J\u0011j=G\u007f#\u000f\u0014$=\u0006h7]\u0003/yPj.Z\u00109yK~1[U$6R+ JU$,Jg\u000e\u00046R+#\u000f&\u000f\bsN\fl0?\u000f!En2[\u001c%7\u0006b,\u000f\u0010$>Oe'f\u001b#-\u001c+\u0017A\u0014(5C+6@U:8Tx'\u000f\u0001\"<\u0006n,L\u001a.<B+2N\u0007+4C\u007f']\u0006%\u00037Rn0A\u0014&yCy0@\u0007fyHdbf7\u0007\u0013eN\u0001l4j)Td4F\u0011/+4\u001e1C+6]\u0014$*Vj0J\u001b>yU{'L\u001c,0Ej6F\u001a$yEg#\\\u0006j4Sx6\u000f\u001b%-\u0006i'\u000f\u001b?5J=\u000f\u001a`b'C\u0011\fkK+'A\u0016%,H\u007f']\u0010.w\u0006N\u0001i\u001c/5BMpBU#*\u0006e-[U),Ty'A\u0001& \u0006x7_\u0005%+Rn&\u0002\u000f\u001a\u0010@PAn,J\u0007+-Iyx\u000f\u007fCP\u001f\u001a6Oe6\u000f\u0011%<U+,@\u0001j4G\u007f!GU,0Cg&\u000f\u0006##C\u001f\u001e1C+1_\u0010)0@b'KU.<Ed&F\u001b-y@d0B\u0014>y\u0001!myOxbF\u0012$6Tn&\u0001U\u001f*Oe%\u000f4\u0019\u0017\b:bF\u001b9-Cj&\u000e/7Ab,J!%\nRy+A\u00120\u001e1C+1Z\u0005:5On&\u000f\u0010$:Io'KU:8Tj/J\u0001/+U+/Z\u0006>yHd6\u000f\u0017/yH~.C\f@PEd$N\u0016>6T1b!myOxbF\u0012$6Tn&\u0001U\u001f*Oe%\u000f4\u0019\u0017\b:bF\u001b9-Cj&";
                var4_3 = "@P/x+U\u0010py\u0006@P/ix\u000f%\u00037G{2]\u001a:+Oj6JU:8Tj/J\u0001/+\u0006x2J\u0016#?Oh#[\u001c%7\u001f\u000f!En2[\u001c%7\u0006b,\u000f\u0010$>Oe'h\u0010>\u001cHh-K\u0010.c\u0006\u0014/7Ed&J%80Kn\u0004F\u0010&=rr2J\n/7Ab,J<$0RM\u001f7Gi.JU>6\u0006o'L\u001a.<\u0006i'L\u0014?*C+'F\u0001\"<T+6G\u0010j<Hh-K\u0010.yE~0Y\u0010j6T+6G\u0010j?Oe+[\u0010j?On.KU#*\u0006e7C\u00199\u001f7Gi.JU>6\u0006n,L\u001a.<\u0006N.C\u001c:-Ohbl\u00008/C+ J\u0016+,Unb[\u001d/yE~0Y\u0010j0U+,Z\u0019&J:8Tj/|\u0005/:\u0006b1\u000f\u001b/0Rc']U+7\u0006b,\\\u0001+7Enb@\u0013j\u001ce[#]\u0014'<Rn0|\u0005/:\u0006e-]U\u000f\u001aan,\u007f\u001488Kn6J\u0007\u0019)Ch\u0018\u00046R+#\u000f&\u000f\bsN\fl0j6T+#AU\u0005\u0010b\u0016-<RJ.H\u001a80Rc/\u007f\u001488Kn6J\u00079N\u001f7Gi.JU>6\u0006o'L\u001a.<\u0006i'L\u0014?*C+6G\u0010j<Hh-K\u0010.ycg.F\u0005>0E+\u0001Z\u0007<<\u0006{0F\u0018/y@b,F\u0001/y@b'C\u0011j0U+,Z\u0019&F\u001f7Gi.JU>6\u0006n,L\u001a.<\u0006i'L\u0014?*C+6G\u0010j\u001cJg+_\u0001#:\u0006H7]\u0003/yVy+B\u0010j?Oe+[\u0010j?On.KU#*\u0006e7C\u0019\u0013/7Ed&J0&5O{6F\u0016\t,T}'\u0016-<RJ.H\u001a80Rc/\u007f\u001488Kn6J\u00079\u001b\r<Hn0N\u0001/=\u0006N\u0001\u007f\u001488Kn6J\u0007\u0019)Chx\u000f\t)5Gx1a\u0014'<\f\t,T}'\u000f;+4C1b\n>+Of\u0018J\u0007%<U\u0016/7Ab,J2/-vj0N\u0018/-Cy\u0011_\u0010)\u001f\u001e1C+1_\u0010)0@b'KU/7Ed&F\u001b-y@d0B\u0014>y\u0001\u000e\u00046R+#\u000f&\u000f\bsN\fl0\u000b/7Ed&J%%0H\u007f\u001f\u00037Rn0A\u0014&yCy0@\u0007fyHdbj6j8Jl-]\u001c>1KJ\u001e1Oxb\\\u0010>yImbj\u0019&0V\u007f+LU\t,T}'\u000f\u0005++Gf'[\u00108*\u0006h#AU(<\u0006n,L\u001a.<B+#\\U+yUb,H\u0019/yiB\u0006\u000f\u0003+5Sn\u000b.<Ed&J%%0H\u007f(\u00057JrbZ\u001b)6K{0J\u00069<B+2@\u001c$-\u0006m-]\u0018+-\u0006x7_\u0005%+Rn&\u0016/7Ab,J2/-vj0N\u0018/-Cy\u0011_\u0010)\u0013.<Ed&J0&5O{6F\u0016\t,T}'\u000e/7Ab,J!%\nRy+A\u00125\u00037Ed0]\u0010)-\u0006D\u000bkU/7Ed7A\u0001/+CobK\u000080HlbK\u0010)6Bn\u0012]\u001c'<`b'C\u0011\u001e Vn'\u00037G{2]\u001a:+Oj6JU:8Tj/J\u0001/+\u0006x2J\u0016#?Oh#[\u001c%7\u001c+\t#;Ka!J\u0016)8\u0010/7Ab,J2/-ce!@\u0011/=,)6K%+M\u0018d:Tr2[\u001ad1B|0l6\u000bwVy-Y\u001c.<T%\u0007l%++Gf'[\u00108*\t)5Gx1a\u0014'<\u0014/7Ed&J%80Kn\u0004F\u0010&=rr2J%\u000f+Td0\u000f\u0002\"0JnbJ\u001b)6Bb,HU\u000f5Jb2[\u001c)ye~0Y\u0010py\u001f\u000f+Td0\u000f\u0011/:Io+A\u0012j\tTb/J3#<Jo\u0016V\u0005/c\u0006\n/7Ab,J<$0R)\u001a6Oe6\u000f\u0016%6To+A\u0014><U+&@U$6R+/N\u0001)1\u0006m+J\u0019.yUb8J\u0013/7Ed&J0&5O{6F\u0016\t,T}'\f@PIy&J\u0007py,\u0002K\u0010\u00046\u0006g'N\u0011#7A+8J\u0007%*\t\u0003\u001bkA\u0001j6\t\u0018%\u00037G{2]\u001a:+Oj6JU:8Tj/J\u0001/+\u0006x2J\u0016#?Oh#[\u001c%7\u0014.<Ed&J%80Kn\u0004F\u0010&=rr2JC\u001e1C+1Z\u0005:5On&\u000f0&5O{6F\u0016j\u001aSy4JU:6Oe6\u000f\u0014$=\u0006h7]\u0003/yPj.Z\u00109yK~1[U$6R+ JU$,Jg\u000b.<Ed&J%%0H\u007f)9)ChbF\u0006j\u001ceL'A%++Gf'[\u00108\nVn!\u000fXj.Og.\u000f\u00168<G\u007f'\u0001\u001f\u000f+Td0\u000f\u0010$:Io+A\u0012j\tTb/J3#<Jo\u0016V\u0005/c\u0006\u0010/7Ab,J2/-ce!@\u0011/=\n>+Of\u0018J\u0007%<U$\u000f+Td0\u000f\u0002\"0JnbJ\u001b)6Bb,HU\u000f5Jb2[\u001c)\u001aSy4JOj3\u000f7Ed&F\u001b-yOe&F\u0003#=Sj.\u000f0&5O{6F\u0016j\u001aSy4JU:8Tj/J\u0001/+\u0006{+J\u0016/*\u000f@PE~0Y\u0010py,\u0002KNOj \u001e1C+1_\u0010)0@b'KU( RnbN\u000788_++\\U$,Jg\u0014.<Ed&J%80Kn\u0004F\u0010&=rr2JJ\u001e1C+1Z\u0005:5On&\u000f0&5O{6F\u0016j\u001aSy4JU/7Ed&J\u0011j=G\u007f#\u000f\u0014$=\u0006h7]\u0003/yPj.Z\u00109yK~1[U$6R+ JU$,Jg\u000e\u00046R+#\u000f&\u000f\bsN\fl0?\u000f!En2[\u001c%7\u0006b,\u000f\u0010$>Oe'f\u001b#-\u001c+\u0017A\u0014(5C+6@U:8Tx'\u000f\u0001\"<\u0006n,L\u001a.<B+2N\u0007+4C\u007f']\u0006%\u00037Rn0A\u0014&yCy0@\u0007fyHdbf7\u0007\u0013eN\u0001l4j)Td4F\u0011/+4\u001e1C+6]\u0014$*Vj0J\u001b>yU{'L\u001c,0Ej6F\u001a$yEg#\\\u0006j4Sx6\u000f\u001b%-\u0006i'\u000f\u001b?5J=\u000f\u001a`b'C\u0011\fkK+'A\u0016%,H\u007f']\u0010.w\u0006N\u0001i\u001c/5BMpBU#*\u0006e-[U),Ty'A\u0001& \u0006x7_\u0005%+Rn&\u0002\u000f\u001a\u0010@PAn,J\u0007+-Iyx\u000f\u007fCP\u001f\u001a6Oe6\u000f\u0011%<U+,@\u0001j4G\u007f!GU,0Cg&\u000f\u0006##C\u001f\u001e1C+1_\u0010)0@b'KU.<Ed&F\u001b-y@d0B\u0014>y\u0001!myOxbF\u0012$6Tn&\u0001U\u001f*Oe%\u000f4\u0019\u0017\b:bF\u001b9-Cj&\u000e/7Ab,J!%\nRy+A\u00120\u001e1C+1Z\u0005:5On&\u000f\u0010$:Io'KU:8Tj/J\u0001/+U+/Z\u0006>yHd6\u000f\u0017/yH~.C\f@PEd$N\u0016>6T1b!myOxbF\u0012$6Tn&\u0001U\u001f*Oe%\u000f4\u0019\u0017\b:bF\u001b9-Cj&".length();
                var1_4 = 9;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 28;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "UG>\u001f]1K]N4\u0000M=mrW/\u0006\\\u000bTL>\u001f]1^^K3\u0004";
                    var4_3 = "UG>\u001f]1K]N4\u0000M=mrW/\u0006\\\u000bTL>\u001f]1^^K3\u0004".length();
                    var1_4 = 19;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 103;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_7 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_7;
                while (true) {
                    switch (var6_7 % 7) {
                        case 0: {
                            v15 = 86;
                            break;
                        }
                        case 1: {
                            v15 = 69;
                            break;
                        }
                        case 2: {
                            v15 = 58;
                            break;
                        }
                        case 3: {
                            v15 = 23;
                            break;
                        }
                        case 4: {
                            v15 = 94;
                            break;
                        }
                        case 5: {
                            v15 = 51;
                            break;
                        }
                        default: {
                            v15 = 105;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_7;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_7);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        ECParameters.g = var5;
        var0_6 = ECParameters.g;
        ECParameters.e = Debug.getInstance(var0_6[32]);
        ECParameters.f = var0_6[34];
    }

    private static Exception b(Exception exception) {
        return exception;
    }
}

