/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.Arrays;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileAttributes;
import sun.nio.fs.UnixFileSystem;
import sun.nio.fs.UnixPath;
import sun.security.action.GetPropertyAction;

class UnixUriUtils {
    private static String jnuEncoding;
    private static String UTF8;
    private static final long L_DIGIT;
    private static final long H_DIGIT = 0L;
    private static final long L_UPALPHA = 0L;
    private static final long H_UPALPHA;
    private static final long L_LOWALPHA = 0L;
    private static final long H_LOWALPHA;
    private static final long L_ALPHA = 0L;
    private static final long H_ALPHA;
    private static final long L_ALPHANUM;
    private static final long H_ALPHANUM;
    private static final long L_MARK;
    private static final long H_MARK;
    private static final long L_UNRESERVED;
    private static final long H_UNRESERVED;
    private static final long L_PCHAR;
    private static final long H_PCHAR;
    private static final long L_PATH;
    private static final long H_PATH;
    private static final char[] hexDigits;

    private UnixUriUtils() {
    }

    static Path fromUri(UnixFileSystem unixFileSystem, URI uRI) {
        if (!uRI.isAbsolute()) {
            throw new IllegalArgumentException("URI is not absolute");
        }
        if (uRI.isOpaque()) {
            throw new IllegalArgumentException("URI is not hierarchical");
        }
        String string = uRI.getScheme();
        if (string == null || !string.equalsIgnoreCase("file")) {
            throw new IllegalArgumentException("URI scheme is not \"file\"");
        }
        if (uRI.getAuthority() != null) {
            throw new IllegalArgumentException("URI has an authority component");
        }
        if (uRI.getFragment() != null) {
            throw new IllegalArgumentException("URI has a fragment component");
        }
        if (uRI.getQuery() != null) {
            throw new IllegalArgumentException("URI has a query component");
        }
        if (!uRI.toString().startsWith("file:///")) {
            return new File(uRI).toPath();
        }
        String string2 = uRI.getRawPath();
        int n = string2.length();
        if (n == 0) {
            throw new IllegalArgumentException("URI path component is empty");
        }
        if (string2.endsWith("/") && n > 1) {
            --n;
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            byte by;
            char c;
            if ((c = string2.charAt(n3++)) == '%') {
                assert (n3 + 2 <= n);
                char c2 = string2.charAt(n3++);
                char c3 = string2.charAt(n3++);
                by = (byte)(UnixUriUtils.decode(c2) << 4 | UnixUriUtils.decode(c3));
                if (by == 0) {
                    throw new IllegalArgumentException("Nul character not allowed");
                }
            } else {
                if (c == '\u0000' || c >= '\u0080') {
                    throw new IllegalArgumentException("Bad escape");
                }
                by = (byte)c;
            }
            if (by == 47 && n2 > 0 && byArray[n2 - 1] == 47) continue;
            byArray[n2++] = by;
        }
        if (n2 != byArray.length) {
            byArray = Arrays.copyOf(byArray, n2);
        }
        if (!jnuEncoding.equals(UTF8)) {
            byArray = UnixUriUtils.convert(UTF8, jnuEncoding, byArray);
        }
        return new UnixPath(unixFileSystem, byArray);
    }

    static URI toUri(UnixPath unixPath) {
        byte[] byArray = unixPath.toAbsolutePath().asByteArray();
        if (!jnuEncoding.equals(UTF8)) {
            byArray = UnixUriUtils.convert(jnuEncoding, UTF8, byArray);
        }
        StringBuilder stringBuilder = new StringBuilder("file:///");
        assert (byArray[0] == 47);
        for (int i = 1; i < byArray.length; ++i) {
            char c = (char)(byArray[i] & 0xFF);
            if (UnixUriUtils.match(c, L_PATH, H_PATH)) {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append('%');
            stringBuilder.append(hexDigits[c >> 4 & 0xF]);
            stringBuilder.append(hexDigits[c & 0xF]);
        }
        if (stringBuilder.charAt(stringBuilder.length() - 1) != '/') {
            try {
                unixPath.checkRead();
                if (UnixFileAttributes.get(unixPath, true).isDirectory()) {
                    stringBuilder.append('/');
                }
            }
            catch (SecurityException | UnixException exception) {
                // empty catch block
            }
        }
        try {
            return new URI(stringBuilder.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new AssertionError((Object)uRISyntaxException);
        }
    }

    private static byte[] convert(String string, String string2, byte[] byArray) {
        CharBuffer charBuffer;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        CharsetDecoder charsetDecoder = Charset.forName(string).newDecoder();
        CoderResult coderResult = charsetDecoder.decode(byteBuffer, charBuffer = CharBuffer.allocate((int)Math.ceil(charsetDecoder.maxCharsPerByte() * (float)byteBuffer.limit())), true);
        if (coderResult.isError()) {
            throw new IllegalArgumentException("Invalid URI");
        }
        if (coderResult.isOverflow()) {
            throw new IllegalArgumentException("Internal buffer error");
        }
        coderResult = charsetDecoder.flush(charBuffer);
        if (coderResult.isError()) {
            throw new IllegalArgumentException("Invalid URI");
        }
        if (coderResult.isOverflow()) {
            throw new IllegalArgumentException("Internal buffer error");
        }
        CharsetEncoder charsetEncoder = Charset.forName(string2).newEncoder();
        ByteBuffer byteBuffer2 = ByteBuffer.allocate((int)Math.ceil(charsetEncoder.maxBytesPerChar() * (float)charBuffer.position()));
        charBuffer.flip();
        coderResult = charsetEncoder.encode(charBuffer, byteBuffer2, true);
        if (coderResult.isError()) {
            throw new IllegalArgumentException("Invalid URI");
        }
        if (coderResult.isOverflow()) {
            throw new IllegalArgumentException("Internal buffer error");
        }
        coderResult = charsetEncoder.flush(byteBuffer2);
        if (coderResult.isError()) {
            throw new IllegalArgumentException("Invalid URI");
        }
        if (coderResult.isOverflow()) {
            throw new IllegalArgumentException("Internal buffer error");
        }
        return Arrays.copyOf(byteBuffer2.array(), byteBuffer2.position());
    }

    private static long lowMask(String string) {
        int n = string.length();
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '@') continue;
            l |= 1L << c;
        }
        return l;
    }

    private static long highMask(String string) {
        int n = string.length();
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < '@' || c >= '\u0080') continue;
            l |= 1L << c - 64;
        }
        return l;
    }

    private static long lowMask(char c, char c2) {
        long l = 0L;
        int n = Math.max(Math.min(c, 63), 0);
        int n2 = Math.max(Math.min(c2, 63), 0);
        for (int i = n; i <= n2; ++i) {
            l |= 1L << i;
        }
        return l;
    }

    private static long highMask(char c, char c2) {
        long l = 0L;
        int n = Math.max(Math.min(c, 127), 64) - 64;
        int n2 = Math.max(Math.min(c2, 127), 64) - 64;
        for (int i = n; i <= n2; ++i) {
            l |= 1L << i;
        }
        return l;
    }

    private static boolean match(char c, long l, long l2) {
        if (c < '@') {
            return (1L << c & l) != 0L;
        }
        if (c < '\u0080') {
            return (1L << c - 64 & l2) != 0L;
        }
        return false;
    }

    private static int decode(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        throw new AssertionError();
    }

    static {
        UTF8 = "UTF-8";
        jnuEncoding = AccessController.doPrivileged(new GetPropertyAction("sun.jnu.encoding"));
        L_DIGIT = UnixUriUtils.lowMask('0', '9');
        H_UPALPHA = UnixUriUtils.highMask('A', 'Z');
        H_LOWALPHA = UnixUriUtils.highMask('a', 'z');
        H_ALPHA = H_LOWALPHA | H_UPALPHA;
        L_ALPHANUM = L_DIGIT | 0L;
        H_ALPHANUM = 0L | H_ALPHA;
        L_MARK = UnixUriUtils.lowMask("-_.!~*'()");
        H_MARK = UnixUriUtils.highMask("-_.!~*'()");
        L_UNRESERVED = L_ALPHANUM | L_MARK;
        H_UNRESERVED = H_ALPHANUM | H_MARK;
        L_PCHAR = L_UNRESERVED | UnixUriUtils.lowMask(":@&=+$,");
        H_PCHAR = H_UNRESERVED | UnixUriUtils.highMask(":@&=+$,");
        L_PATH = L_PCHAR | UnixUriUtils.lowMask(";/");
        H_PATH = H_PCHAR | UnixUriUtils.highMask(";/");
        hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

