/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import sun.font.CMap;
import sun.text.normalizer.NormalizerImpl;

public abstract class CharToGlyphMapper {
    public static final int HI_SURROGATE_START = 55296;
    public static final int HI_SURROGATE_END = 56319;
    public static final int LO_SURROGATE_START = 56320;
    public static final int LO_SURROGATE_END = 57343;
    public static final int UNINITIALIZED_GLYPH = -1;
    public static final int INVISIBLE_GLYPH_ID = 65535;
    public static final int INVISIBLE_GLYPHS = 65534;
    protected int missingGlyph = -1;

    public int getMissingGlyphCode() {
        return this.missingGlyph;
    }

    public boolean canDisplay(char c) {
        int n = this.charToGlyph(c);
        return n != this.missingGlyph;
    }

    public boolean canDisplay(int n) {
        int n2 = this.charToGlyph(n);
        return n2 != this.missingGlyph;
    }

    public int charToGlyph(char c) {
        char[] cArray = new char[1];
        int[] nArray = new int[1];
        cArray[0] = c;
        this.charsToGlyphs(1, cArray, nArray);
        return nArray[0];
    }

    public int charToGlyph(int n) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        nArray[0] = n;
        this.charsToGlyphs(1, nArray, nArray2);
        return nArray2[0];
    }

    public abstract int getNumGlyphs();

    public abstract void charsToGlyphs(int var1, char[] var2, int[] var3);

    public abstract boolean charsToGlyphsNS(int var1, char[] var2, int[] var3);

    public abstract void charsToGlyphs(int var1, int[] var2, int[] var3);

    public static boolean isBaseChar(int n) {
        long l = 0L;
        int n2 = Character.getType(n);
        if (n2 == 0 || n2 == 15 || n2 == 16) {
            return false;
        }
        if (n > 65535) {
            char c = (char)((n - 65536) / 1024 + 55296);
            char c2 = (char)((n - 65536) % 1024 + 56320);
            l = NormalizerImpl.getNorm32(c);
            l = NormalizerImpl.getNorm32FromSurrogatePair(l, c2);
        } else {
            l = NormalizerImpl.getNorm32((char)n);
        }
        return (l & 0xFF04L) == 0L;
    }

    public static boolean isVariationSelectorSupported() {
        return CMap.isVariationSelectorSupported();
    }

    public static boolean isVariationSelector(int n) {
        return n >= 917760 && n <= 918015 || n >= 65024 && n <= 65039 || n >= 6155 && n <= 6157;
    }

    public static boolean isVariationSelectorInBMP(char c) {
        return c >= '\ufe00' && c <= '\ufe0f' || c >= '\u180b' && c <= '\u180d';
    }

    public static boolean isVariationSelectorInSupplementary(char c, char c2) {
        return c == '\udb40' && c2 >= '\udd00' && c2 <= '\uddef';
    }
}

