/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.screencast;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import sun.awt.screencast.ScreencastHelper;

final class TokenItem {
    final String token;
    final List<Rectangle> allowedScreensBounds;
    private static final int MAX_SIZE = 50000;
    private static final int MIN_SIZE = 1;

    public TokenItem(String string, int[] nArray) {
        if (string == null || string.isEmpty()) {
            throw new RuntimeException("empty or null tokens are not allowed");
        }
        if (nArray.length % 4 != 0) {
            throw new RuntimeException("array with incorrect length provided");
        }
        this.token = string;
        this.allowedScreensBounds = IntStream.iterate(0, n -> n + 4).limit(nArray.length / 4).mapToObj(n -> new Rectangle(nArray[n], nArray[n + 1], nArray[n + 2], nArray[n + 3])).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public boolean hasAllScreensWithExactMatch(List<Rectangle> list) {
        return this.allowedScreensBounds.containsAll(list);
    }

    public boolean hasAllScreensOfSameSize(List<Dimension> list) {
        List list2 = this.allowedScreensBounds.stream().map(rectangle -> new Dimension(rectangle.width, rectangle.height)).collect(Collectors.toCollection(ArrayList::new));
        return (long)list.size() == list.stream().filter(list2::remove).count();
    }

    public boolean hasValidBounds() {
        for (Rectangle rectangle : this.allowedScreensBounds) {
            if (rectangle.x >= -50000 && rectangle.x <= 50000 && rectangle.y >= -50000 && rectangle.y <= 50000 && rectangle.width >= 1 && rectangle.width <= 50000 && rectangle.height >= 1 && rectangle.height <= 50000) continue;
            return false;
        }
        return true;
    }

    public String dump() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Rectangle rectangle : this.allowedScreensBounds) {
            stringBuilder.append(String.format("_%d_%d_%d_%d", rectangle.x, rectangle.y, rectangle.width, rectangle.height));
        }
        return stringBuilder.toString();
    }

    public static TokenItem parse(String string2, Object object) {
        if (string2 == null || object == null) {
            return null;
        }
        try {
            TokenItem tokenItem;
            int[] nArray = Arrays.stream(String.valueOf(object).split("_")).filter(string -> !string.trim().isEmpty()).mapToInt(Integer::parseInt).toArray();
            if (nArray.length % 4 == 0 && (tokenItem = new TokenItem(string2, nArray)).hasValidBounds()) {
                return tokenItem;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (ScreencastHelper.SCREENCAST_DEBUG) {
            System.err.printf("Malformed record for token %s: %s\n", string2, object);
        }
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Token: " + this.token + "\n");
        for (Rectangle rectangle : this.allowedScreensBounds) {
            stringBuilder.append("\t").append(rectangle).append("\n");
        }
        return stringBuilder.toString();
    }
}

