/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.peer.RobotPeer;
import sun.awt.AWTAccessor;
import sun.awt.SunToolkit;
import sun.awt.X11GraphicsConfig;
import sun.awt.screencast.ScreencastHelper;
import sun.awt.screencast.XdgDesktopPortal;

class XRobotPeer
implements RobotPeer {
    private X11GraphicsConfig xgc = null;
    static Object robotLock;

    XRobotPeer(GraphicsConfiguration graphicsConfiguration) {
        this.xgc = (X11GraphicsConfig)graphicsConfiguration;
        SunToolkit sunToolkit = (SunToolkit)Toolkit.getDefaultToolkit();
        XRobotPeer.setup(sunToolkit.getNumberOfButtons(), AWTAccessor.getInputEventAccessor().getButtonDownMasks());
    }

    @Override
    public void dispose() {
    }

    @Override
    public void mouseMove(int n, int n2) {
        XRobotPeer.mouseMoveImpl(this.xgc, n, n2);
        if (XdgDesktopPortal.isRemoteDesktop() && ScreencastHelper.isAvailable()) {
            ScreencastHelper.remoteDesktopMouseMove(n, n2);
        }
    }

    @Override
    public void mousePress(int n) {
        if (XdgDesktopPortal.isRemoteDesktop() && ScreencastHelper.isAvailable()) {
            ScreencastHelper.remoteDesktopMouseButton(true, n);
        } else {
            XRobotPeer.mousePressImpl(n);
        }
    }

    @Override
    public void mouseRelease(int n) {
        if (XdgDesktopPortal.isRemoteDesktop() && ScreencastHelper.isAvailable()) {
            ScreencastHelper.remoteDesktopMouseButton(false, n);
        } else {
            XRobotPeer.mouseReleaseImpl(n);
        }
    }

    @Override
    public void mouseWheel(int n) {
        if (XdgDesktopPortal.isRemoteDesktop() && ScreencastHelper.isAvailable()) {
            ScreencastHelper.remoteDesktopMouseWheel(n);
        } else {
            XRobotPeer.mouseWheelImpl(n);
        }
    }

    @Override
    public void keyPress(int n) {
        if (XdgDesktopPortal.isRemoteDesktop() && ScreencastHelper.isAvailable()) {
            ScreencastHelper.remoteDesktopKey(true, n);
        } else {
            XRobotPeer.keyPressImpl(n);
        }
    }

    @Override
    public void keyRelease(int n) {
        if (XdgDesktopPortal.isRemoteDesktop() && ScreencastHelper.isAvailable()) {
            ScreencastHelper.remoteDesktopKey(false, n);
        } else {
            XRobotPeer.keyReleaseImpl(n);
        }
    }

    @Override
    public int getRGBPixel(int n, int n2) {
        int[] nArray = new int[1];
        if ((XdgDesktopPortal.isScreencast() || XdgDesktopPortal.isRemoteDesktop()) && ScreencastHelper.isAvailable()) {
            ScreencastHelper.getRGBPixels(n, n2, 1, 1, nArray);
        } else {
            XRobotPeer.getRGBPixelsImpl(this.xgc, n, n2, 1, 1, nArray);
        }
        return nArray[0];
    }

    @Override
    public int[] getRGBPixels(Rectangle rectangle) {
        int[] nArray = new int[rectangle.width * rectangle.height];
        if ((XdgDesktopPortal.isScreencast() || XdgDesktopPortal.isRemoteDesktop()) && ScreencastHelper.isAvailable()) {
            ScreencastHelper.getRGBPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, nArray);
        } else {
            XRobotPeer.getRGBPixelsImpl(this.xgc, rectangle.x, rectangle.y, rectangle.width, rectangle.height, nArray);
        }
        return nArray;
    }

    private static synchronized native void setup(int var0, int[] var1);

    private static synchronized native void mouseMoveImpl(X11GraphicsConfig var0, int var1, int var2);

    private static synchronized native void mousePressImpl(int var0);

    private static synchronized native void mouseReleaseImpl(int var0);

    private static synchronized native void mouseWheelImpl(int var0);

    private static synchronized native void keyPressImpl(int var0);

    private static synchronized native void keyReleaseImpl(int var0);

    private static synchronized native void getRGBPixelsImpl(X11GraphicsConfig var0, int var1, int var2, int var3, int var4, int[] var5);

    private static native void loadNativeLibraries();

    static {
        XRobotPeer.loadNativeLibraries();
        robotLock = new Object();
    }
}

