/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.SecureRandomSpi;
import java.security.Security;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.security.jca.GetInstance;
import sun.security.jca.Providers;
import sun.security.util.Debug;

public class SecureRandom
extends Random {
    private static final Debug pdebug = Debug.getInstance("provider", "Provider");
    private static final boolean skipDebug = Debug.isOn("engine=") && !Debug.isOn("securerandom");
    private Provider provider = null;
    private SecureRandomSpi secureRandomSpi = null;
    private String algorithm;
    private static volatile SecureRandom seedGenerator = null;
    static final long serialVersionUID = 4940670005562187L;
    private byte[] state;
    private MessageDigest digest = null;
    private byte[] randomBytes;
    private int randomBytesUsed;
    private long counter;

    public SecureRandom() {
        super(0L);
        this.getDefaultPRNG(false, null);
    }

    public SecureRandom(byte[] byArray) {
        super(0L);
        this.getDefaultPRNG(true, byArray);
    }

    private void getDefaultPRNG(boolean bl, byte[] byArray) {
        String string = SecureRandom.getPrngAlgorithm();
        if (string != null) {
            try {
                SecureRandom secureRandom = SecureRandom.getInstance(string);
                this.secureRandomSpi = secureRandom.getSecureRandomSpi();
                this.provider = secureRandom.getProvider();
                if (bl) {
                    this.secureRandomSpi.engineSetSeed(byArray);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException(noSuchAlgorithmException);
            }
        }
        if (this.getClass() == SecureRandom.class) {
            this.algorithm = string;
        }
    }

    protected SecureRandom(SecureRandomSpi secureRandomSpi, Provider provider) {
        this(secureRandomSpi, provider, null);
    }

    private SecureRandom(SecureRandomSpi secureRandomSpi, Provider provider, String string) {
        super(0L);
        this.secureRandomSpi = secureRandomSpi;
        this.provider = provider;
        this.algorithm = string;
        if (!skipDebug && pdebug != null) {
            pdebug.println("SecureRandom." + string + " algorithm from: " + this.getProviderName());
        }
    }

    private String getProviderName() {
        return this.provider == null ? "(no provider)" : this.provider.getName();
    }

    public static SecureRandom getInstance(String string) throws NoSuchAlgorithmException {
        GetInstance.Instance instance = GetInstance.getInstance("SecureRandom", SecureRandomSpi.class, string);
        return new SecureRandom((SecureRandomSpi)instance.impl, instance.provider, string);
    }

    public static SecureRandom getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        GetInstance.Instance instance = GetInstance.getInstance("SecureRandom", SecureRandomSpi.class, string, string2);
        return new SecureRandom((SecureRandomSpi)instance.impl, instance.provider, string);
    }

    public static SecureRandom getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        GetInstance.Instance instance = GetInstance.getInstance("SecureRandom", SecureRandomSpi.class, string, provider);
        return new SecureRandom((SecureRandomSpi)instance.impl, instance.provider, string);
    }

    SecureRandomSpi getSecureRandomSpi() {
        return this.secureRandomSpi;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public String getAlgorithm() {
        return this.algorithm != null ? this.algorithm : "unknown";
    }

    public synchronized void setSeed(byte[] byArray) {
        this.secureRandomSpi.engineSetSeed(byArray);
    }

    @Override
    public void setSeed(long l) {
        if (l != 0L) {
            this.secureRandomSpi.engineSetSeed(SecureRandom.longToByteArray(l));
        }
    }

    @Override
    public synchronized void nextBytes(byte[] byArray) {
        this.secureRandomSpi.engineNextBytes(byArray);
    }

    @Override
    protected final int next(int n) {
        int n2 = (n + 7) / 8;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        this.nextBytes(byArray);
        for (int i = 0; i < n2; ++i) {
            n3 = (n3 << 8) + (byArray[i] & 0xFF);
        }
        return n3 >>> n2 * 8 - n;
    }

    public static byte[] getSeed(int n) {
        if (seedGenerator == null) {
            seedGenerator = new SecureRandom();
        }
        return seedGenerator.generateSeed(n);
    }

    public byte[] generateSeed(int n) {
        if (n < 0) {
            throw new NegativeArraySizeException("numBytes cannot be negative");
        }
        return this.secureRandomSpi.engineGenerateSeed(n);
    }

    private static byte[] longToByteArray(long l) {
        byte[] byArray = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray[i] = (byte)l;
            l >>= 8;
        }
        return byArray;
    }

    private static String getPrngAlgorithm() {
        String string = null;
        Provider.Service service = null;
        for (Provider provider : Providers.getProviderList().providers()) {
            if ("IBMJCEFIPS".equals(provider.getName()) && (service = provider.getService("SecureRandom", "SHA2DRBG")) != null && (string = service.getAlgorithm()) != null) {
                return string;
            }
            for (Provider.Service service2 : provider.getServices()) {
                if (!service2.getType().equals("SecureRandom")) continue;
                return service2.getAlgorithm();
            }
        }
        return null;
    }

    public static SecureRandom getInstanceStrong() throws NoSuchAlgorithmException {
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return Security.getProperty("securerandom.strongAlgorithms");
            }
        });
        if (string == null || string.length() == 0) {
            throw new NoSuchAlgorithmException("Null/empty securerandom.strongAlgorithms Security Property");
        }
        String string2 = string;
        while (string2 != null) {
            Matcher matcher = StrongPatternHolder.pattern.matcher(string2);
            if (matcher.matches()) {
                String string3 = matcher.group(1);
                String string4 = matcher.group(3);
                try {
                    if (string4 == null) {
                        return SecureRandom.getInstance(string3);
                    }
                    return SecureRandom.getInstance(string3, string4);
                }
                catch (NoSuchAlgorithmException | NoSuchProviderException generalSecurityException) {
                    string2 = matcher.group(5);
                    continue;
                }
            }
            string2 = null;
        }
        throw new NoSuchAlgorithmException("No strong SecureRandom impls available: " + string);
    }

    private static final class StrongPatternHolder {
        private static Pattern pattern = Pattern.compile("\\s*([\\S&&[^:,]]*)(\\:([\\S&&[^,]]*))?\\s*(\\,(.*))?");

        private StrongPatternHolder() {
        }
    }
}

