/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaConversionException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleInfo;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import sun.invoke.util.Wrapper;

abstract class AbstractValidatingLambdaMetafactory {
    final Class<?> targetClass;
    final MethodType invokedType;
    final Class<?> samBase;
    final String samMethodName;
    final MethodType samMethodType;
    final MethodHandle implMethod;
    final MethodHandleInfo implInfo;
    final int implKind;
    final boolean implIsInstanceMethod;
    final Class<?> implDefiningClass;
    final MethodType implMethodType;
    final MethodType instantiatedMethodType;
    final boolean isSerializable;
    final Class<?>[] markerInterfaces;
    final MethodType[] additionalBridges;

    AbstractValidatingLambdaMetafactory(MethodHandles.Lookup lookup, MethodType methodType, String string, MethodType methodType2, MethodHandle methodHandle, MethodType methodType3, boolean bl, Class<?>[] classArray, MethodType[] methodTypeArray) throws LambdaConversionException {
        if ((lookup.lookupModes() & 2) == 0) {
            throw new LambdaConversionException(String.format("Invalid caller: %s", lookup.lookupClass().getName()));
        }
        this.targetClass = lookup.lookupClass();
        this.invokedType = methodType;
        this.samBase = methodType.returnType();
        this.samMethodName = string;
        this.samMethodType = methodType2;
        this.implMethod = methodHandle;
        this.implInfo = lookup.revealDirect(methodHandle);
        this.implKind = this.implInfo.getReferenceKind();
        this.implIsInstanceMethod = this.implKind == 5 || this.implKind == 7 || this.implKind == 9;
        this.implDefiningClass = this.implInfo.getDeclaringClass();
        this.implMethodType = this.implInfo.getMethodType();
        this.instantiatedMethodType = methodType3;
        this.isSerializable = bl;
        this.markerInterfaces = classArray;
        this.additionalBridges = methodTypeArray;
        if (!this.samBase.isInterface()) {
            throw new LambdaConversionException(String.format("Functional interface %s is not an interface", this.samBase.getName()));
        }
        for (Class<?> clazz : classArray) {
            if (clazz.isInterface()) continue;
            throw new LambdaConversionException(String.format("Marker interface %s is not an interface", clazz.getName()));
        }
    }

    abstract CallSite buildCallSite() throws LambdaConversionException;

    /*
     * WARNING - void declaration
     */
    void validateMetafactoryArgs() throws LambdaConversionException {
        TypeDescriptor.OfField ofField;
        Class<?> clazz;
        void var9_16;
        int n2;
        int n3;
        switch (this.implKind) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            default: {
                throw new LambdaConversionException(String.format("Unsupported MethodHandle kind: %s", this.implInfo));
            }
        }
        int n4 = this.implMethodType.parameterCount();
        int n5 = this.implIsInstanceMethod ? 1 : 0;
        int n6 = this.invokedType.parameterCount();
        int n7 = this.samMethodType.parameterCount();
        int n8 = this.instantiatedMethodType.parameterCount();
        if (n4 + n5 != n6 + n7) {
            throw new LambdaConversionException(String.format("Incorrect number of parameters for %s method %s; %d captured parameters, %d functional interface method parameters, %d implementation parameters", this.implIsInstanceMethod ? "instance" : "static", this.implInfo, n6, n7, n4));
        }
        if (n8 != n7) {
            throw new LambdaConversionException(String.format("Incorrect number of parameters for %s method %s; %d instantiated parameters, %d functional interface method parameters", this.implIsInstanceMethod ? "instance" : "static", this.implInfo, n8, n7));
        }
        for (MethodType typeDescriptor : this.additionalBridges) {
            if (typeDescriptor.parameterCount() == n7) continue;
            throw new LambdaConversionException(String.format("Incorrect number of parameters for bridge signature %s; incompatible with %s", typeDescriptor, this.samMethodType));
        }
        if (this.implIsInstanceMethod) {
            TypeDescriptor.OfField ofField2;
            if (n6 == 0) {
                n3 = 0;
                n2 = 1;
                ofField2 = this.instantiatedMethodType.parameterType(0);
            } else {
                n3 = 1;
                n2 = 0;
                ofField2 = this.invokedType.parameterType(0);
            }
            if (!this.implDefiningClass.isAssignableFrom((Class<?>)ofField2)) {
                throw new LambdaConversionException(String.format("Invalid receiver type %s; not a subtype of implementation type %s", ofField2, this.implDefiningClass));
            }
            TypeDescriptor.OfField n = this.implMethod.type().parameterType(0);
            if (n != this.implDefiningClass && !((Class)n).isAssignableFrom((Class<?>)ofField2)) {
                throw new LambdaConversionException(String.format("Invalid receiver type %s; not a subtype of implementation receiver type %s", ofField2, n));
            }
        } else {
            n3 = 0;
            n2 = 0;
        }
        int n9 = n6 - n3;
        boolean bl = false;
        while (var9_16 < n9) {
            TypeDescriptor.OfField ofField2 = this.implMethodType.parameterType((int)var9_16);
            clazz = this.invokedType.parameterType((int)(var9_16 + n3));
            if (!clazz.equals(ofField2)) {
                throw new LambdaConversionException(String.format("Type mismatch in captured lambda parameter %d: expecting %s, found %s", (int)var9_16, clazz, ofField2));
            }
            ++var9_16;
        }
        int n = n2 - n9;
        for (int i = n9; i < n4; ++i) {
            clazz = this.implMethodType.parameterType(i);
            ofField = this.instantiatedMethodType.parameterType(i + n);
            if (this.isAdaptableTo((Class<?>)ofField, clazz, true)) continue;
            throw new LambdaConversionException(String.format("Type mismatch for lambda argument %d: %s is not convertible to %s", i, ofField, clazz));
        }
        TypeDescriptor.OfField ofField3 = this.instantiatedMethodType.returnType();
        clazz = this.implKind == 8 ? this.implDefiningClass : this.implMethodType.returnType();
        ofField = this.samMethodType.returnType();
        if (!this.isAdaptableToAsReturn(clazz, (Class<?>)ofField3)) {
            throw new LambdaConversionException(String.format("Type mismatch for lambda return: %s is not convertible to %s", clazz, ofField3));
        }
        if (!this.isAdaptableToAsReturnStrict((Class<?>)ofField3, (Class<?>)ofField)) {
            throw new LambdaConversionException(String.format("Type mismatch for lambda expected return: %s is not convertible to %s", ofField3, ofField));
        }
        for (MethodType methodType : this.additionalBridges) {
            if (this.isAdaptableToAsReturnStrict((Class<?>)ofField3, (Class<?>)methodType.returnType())) continue;
            throw new LambdaConversionException(String.format("Type mismatch for lambda expected return: %s is not convertible to %s", ofField3, methodType.returnType()));
        }
    }

    private boolean isAdaptableTo(Class<?> clazz, Class<?> clazz2, boolean bl) {
        if (clazz.equals(clazz2)) {
            return true;
        }
        if (clazz.isPrimitive()) {
            Wrapper wrapper = Wrapper.forPrimitiveType(clazz);
            if (clazz2.isPrimitive()) {
                Wrapper wrapper2 = Wrapper.forPrimitiveType(clazz2);
                return wrapper2.isConvertibleFrom(wrapper);
            }
            return clazz2.isAssignableFrom(wrapper.wrapperType());
        }
        if (clazz2.isPrimitive()) {
            Wrapper wrapper;
            if (Wrapper.isWrapperType(clazz) && (wrapper = Wrapper.forWrapperType(clazz)).primitiveType().isPrimitive()) {
                Wrapper wrapper3 = Wrapper.forPrimitiveType(clazz2);
                return wrapper3.isConvertibleFrom(wrapper);
            }
            return !bl;
        }
        return !bl || clazz2.isAssignableFrom(clazz);
    }

    private boolean isAdaptableToAsReturn(Class<?> clazz, Class<?> clazz2) {
        return clazz2.equals(Void.TYPE) || !clazz.equals(Void.TYPE) && this.isAdaptableTo(clazz, clazz2, false);
    }

    private boolean isAdaptableToAsReturnStrict(Class<?> clazz, Class<?> clazz2) {
        if (clazz.equals(Void.TYPE)) {
            return clazz2.equals(Void.TYPE);
        }
        return this.isAdaptableTo(clazz, clazz2, true);
    }
}

