/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.Ber;
import com.sun.jndi.ldap.BerDecoder;
import com.sun.jndi.ldap.BerEncoder;
import com.sun.jndi.ldap.LdapClient;
import com.sun.jndi.ldap.LdapRequest;
import com.sun.jndi.ldap.Obj;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import javax.naming.CommunicationException;
import javax.naming.InterruptedNamingException;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import javax.naming.ldap.Control;
import javax.net.SocketFactory;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import sun.misc.IOUtils;

public final class Connection
implements Runnable {
    private static final boolean debug = false;
    private static final int dump = 0;
    private final Thread worker;
    private boolean v3 = true;
    public final String host;
    public final int port;
    private boolean bound = false;
    private OutputStream traceFile = null;
    private String traceTagIn = null;
    private String traceTagOut = null;
    public InputStream inStream;
    public OutputStream outStream;
    public Socket sock;
    private final LdapClient parent;
    private int outMsgId = 0;
    private LdapRequest pendingRequests = null;
    volatile IOException closureReason = null;
    volatile boolean useable = true;
    int readTimeout;
    int connectTimeout;
    private volatile boolean isUpgradedToStartTls;
    final Object startTlsLock = new Object();
    private static final boolean IS_HOSTNAME_VERIFICATION_DISABLED = Connection.hostnameVerificationDisabledValue();
    private final Object pauseLock = new Object();
    private boolean paused = false;

    private static boolean hostnameVerificationDisabledValue() {
        PrivilegedAction<String> privilegedAction = () -> System.getProperty("com.sun.jndi.ldap.object.disableEndpointIdentification");
        String string = AccessController.doPrivileged(privilegedAction);
        if (string == null) {
            return false;
        }
        return string.isEmpty() ? true : Boolean.parseBoolean(string);
    }

    void setV3(boolean bl) {
        this.v3 = bl;
    }

    void setBound() {
        this.bound = true;
    }

    Connection(LdapClient ldapClient, String string, int n, String string2, int n2, int n3, OutputStream outputStream) throws NamingException {
        this.host = string;
        this.port = n;
        this.parent = ldapClient;
        this.readTimeout = n3;
        this.connectTimeout = n2;
        if (outputStream != null) {
            this.traceFile = outputStream;
            this.traceTagIn = "<- " + string + ":" + n + "\n\n";
            this.traceTagOut = "-> " + string + ":" + n + "\n\n";
        }
        try {
            this.sock = this.createSocket(string, n, string2, n2);
            this.inStream = new BufferedInputStream(this.sock.getInputStream());
            this.outStream = new BufferedOutputStream(this.sock.getOutputStream());
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            CommunicationException communicationException = new CommunicationException(string + ":" + n);
            communicationException.setRootCause(throwable);
            throw communicationException;
        }
        catch (Exception exception) {
            CommunicationException communicationException = new CommunicationException(string + ":" + n);
            communicationException.setRootCause(exception);
            throw communicationException;
        }
        this.worker = Obj.helper.createThread(this);
        this.worker.setDaemon(true);
        this.worker.start();
    }

    private Socket createSocket(String string, int n, String string2, int n2) throws Exception {
        SocketFactory socketFactory = this.getSocketFactory(string2);
        assert (socketFactory != null);
        Socket socket = this.createConnectionSocket(string, n, socketFactory, n2);
        if (socket instanceof SSLSocket) {
            try {
                SSLSocket sSLSocket = (SSLSocket)socket;
                this.initialSSLHandshake(sSLSocket, n2);
            }
            catch (Exception exception) {
                this.closeOpenedSocket(socket);
                throw exception;
            }
        }
        return socket;
    }

    private SocketFactory getSocketFactory(String string) throws Exception {
        if (string == null) {
            return SocketFactory.getDefault();
        }
        Class<?> clazz = Obj.helper.loadClass(string);
        Method method = clazz.getMethod("getDefault", new Class[0]);
        Object object = method.invoke(null, new Object[0]);
        if (object instanceof SocketFactory) {
            return (SocketFactory)object;
        }
        return new ProxySocketFactory(clazz, object);
    }

    private Socket createConnectionSocket(String string, int n, SocketFactory socketFactory, int n2) throws Exception {
        Socket socket = null;
        if (n2 > 0) {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
            try {
                socket = socketFactory.createSocket();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (socket != null) {
                socket.connect(inetSocketAddress, n2);
            }
        }
        if (socket == null) {
            socket = socketFactory.createSocket(string, n);
        }
        return socket;
    }

    private void initialSSLHandshake(SSLSocket sSLSocket, int n) throws Exception {
        if (!IS_HOSTNAME_VERIFICATION_DISABLED) {
            SSLParameters sSLParameters = sSLSocket.getSSLParameters();
            sSLParameters.setEndpointIdentificationAlgorithm("LDAPS");
            sSLSocket.setSSLParameters(sSLParameters);
        }
        if (n > 0) {
            int n2 = sSLSocket.getSoTimeout();
            sSLSocket.setSoTimeout(n);
            sSLSocket.startHandshake();
            sSLSocket.setSoTimeout(n2);
        }
    }

    synchronized int getMsgId() {
        return ++this.outMsgId;
    }

    LdapRequest writeRequest(BerEncoder berEncoder, int n) throws IOException {
        return this.writeRequest(berEncoder, n, false, -1);
    }

    LdapRequest writeRequest(BerEncoder berEncoder, int n, boolean bl) throws IOException {
        return this.writeRequest(berEncoder, n, bl, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LdapRequest writeRequest(BerEncoder berEncoder, int n, boolean bl, int n2) throws IOException {
        LdapRequest ldapRequest = new LdapRequest(n, bl, n2);
        this.addRequest(ldapRequest);
        if (this.traceFile != null) {
            Ber.dumpBER(this.traceFile, this.traceTagOut, berEncoder.getBuf(), 0, berEncoder.getDataLen());
        }
        this.unpauseReader();
        try {
            Connection connection = this;
            synchronized (connection) {
                this.outStream.write(berEncoder.getBuf(), 0, berEncoder.getDataLen());
                this.outStream.flush();
            }
        }
        catch (IOException iOException) {
            this.cleanup(null, true);
            this.closureReason = iOException;
            throw this.closureReason;
        }
        return ldapRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BerDecoder readReply(LdapRequest ldapRequest) throws IOException, NamingException {
        BerDecoder berDecoder;
        Object object = this;
        synchronized (object) {
            if (this.sock == null) {
                throw new ServiceUnavailableException(this.host + ":" + this.port + "; socket closed");
            }
        }
        object = null;
        try {
            berDecoder = ldapRequest.getReplyBer(this.readTimeout);
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedNamingException("Interrupted during LDAP operation");
        }
        catch (CommunicationException communicationException) {
            throw communicationException;
        }
        catch (NamingException namingException) {
            object = namingException;
            berDecoder = null;
        }
        if (berDecoder == null) {
            this.abandonRequest(ldapRequest, null);
        }
        if (object != null) {
            throw object;
        }
        return berDecoder;
    }

    private synchronized void addRequest(LdapRequest ldapRequest) {
        LdapRequest ldapRequest2 = this.pendingRequests;
        if (ldapRequest2 == null) {
            this.pendingRequests = ldapRequest;
            ldapRequest.next = null;
        } else {
            ldapRequest.next = this.pendingRequests;
            this.pendingRequests = ldapRequest;
        }
    }

    synchronized LdapRequest findRequest(int n) {
        LdapRequest ldapRequest = this.pendingRequests;
        while (ldapRequest != null) {
            if (ldapRequest.msgId == n) {
                return ldapRequest;
            }
            ldapRequest = ldapRequest.next;
        }
        return null;
    }

    synchronized void removeRequest(LdapRequest ldapRequest) {
        LdapRequest ldapRequest2 = this.pendingRequests;
        LdapRequest ldapRequest3 = null;
        while (ldapRequest2 != null) {
            if (ldapRequest2 == ldapRequest) {
                ldapRequest2.cancel();
                if (ldapRequest3 != null) {
                    ldapRequest3.next = ldapRequest2.next;
                } else {
                    this.pendingRequests = ldapRequest2.next;
                }
                ldapRequest2.next = null;
            }
            ldapRequest3 = ldapRequest2;
            ldapRequest2 = ldapRequest2.next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abandonRequest(LdapRequest ldapRequest, Control[] controlArray) {
        this.removeRequest(ldapRequest);
        BerEncoder berEncoder = new BerEncoder(256);
        int n = this.getMsgId();
        try {
            berEncoder.beginSeq(48);
            berEncoder.encodeInt(n);
            berEncoder.encodeInt(ldapRequest.msgId, 80);
            if (this.v3) {
                LdapClient.encodeControls(berEncoder, controlArray);
            }
            berEncoder.endSeq();
            if (this.traceFile != null) {
                Ber.dumpBER(this.traceFile, this.traceTagOut, berEncoder.getBuf(), 0, berEncoder.getDataLen());
            }
            Connection connection = this;
            synchronized (connection) {
                this.outStream.write(berEncoder.getBuf(), 0, berEncoder.getDataLen());
                this.outStream.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    synchronized void abandonOutstandingReqs(Control[] controlArray) {
        LdapRequest ldapRequest = this.pendingRequests;
        while (ldapRequest != null) {
            this.abandonRequest(ldapRequest, controlArray);
            this.pendingRequests = ldapRequest = ldapRequest.next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ldapUnbind(Control[] controlArray) {
        BerEncoder berEncoder = new BerEncoder(256);
        int n = this.getMsgId();
        try {
            berEncoder.beginSeq(48);
            berEncoder.encodeInt(n);
            berEncoder.encodeByte(66);
            berEncoder.encodeByte(0);
            if (this.v3) {
                LdapClient.encodeControls(berEncoder, controlArray);
            }
            berEncoder.endSeq();
            if (this.traceFile != null) {
                Ber.dumpBER(this.traceFile, this.traceTagOut, berEncoder.getBuf(), 0, berEncoder.getDataLen());
            }
            Connection connection = this;
            synchronized (connection) {
                this.outStream.write(berEncoder.getBuf(), 0, berEncoder.getDataLen());
                this.outStream.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanup(Control[] controlArray, boolean bl) {
        boolean bl2 = false;
        Connection connection = this;
        synchronized (connection) {
            LdapRequest ldapRequest;
            block14: {
                block13: {
                    this.useable = false;
                    if (this.sock == null) break block14;
                    try {
                        if (!bl) {
                            this.abandonOutstandingReqs(controlArray);
                        }
                        if (this.bound) {
                            this.ldapUnbind(controlArray);
                        }
                        this.flushAndCloseOutputStream();
                        this.closeOpenedSocket(this.sock);
                        this.tryUnpauseReader();
                        if (bl) break block13;
                        ldapRequest = this.pendingRequests;
                    }
                    catch (Throwable throwable) {
                        this.flushAndCloseOutputStream();
                        this.closeOpenedSocket(this.sock);
                        this.tryUnpauseReader();
                        if (!bl) {
                            LdapRequest ldapRequest2 = this.pendingRequests;
                            while (ldapRequest2 != null) {
                                ldapRequest2.cancel();
                                ldapRequest2 = ldapRequest2.next;
                            }
                        }
                        this.sock = null;
                        throw throwable;
                    }
                    while (ldapRequest != null) {
                        ldapRequest.cancel();
                        ldapRequest = ldapRequest.next;
                    }
                }
                this.sock = null;
                bl2 = bl;
            }
            if (bl2) {
                ldapRequest = this.pendingRequests;
                while (ldapRequest != null) {
                    ldapRequest.close();
                    ldapRequest = ldapRequest.next;
                }
            }
        }
        if (bl2) {
            this.parent.processConnectionClosure();
        }
    }

    private void flushAndCloseOutputStream() {
        try {
            this.outStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.outStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void closeOpenedSocket(Socket socket) {
        try {
            if (socket != null && !socket.isClosed()) {
                socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void tryUnpauseReader() {
        try {
            this.unpauseReader();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void replaceStreams(InputStream inputStream, OutputStream outputStream) {
        this.inStream = inputStream;
        try {
            this.outStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.outStream = outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void replaceStreams(InputStream inputStream, OutputStream outputStream, boolean bl) {
        Object object = this.startTlsLock;
        synchronized (object) {
            this.replaceStreams(inputStream, outputStream);
            this.isUpgradedToStartTls = bl;
        }
    }

    public boolean isUpgradedToStartTls() {
        return this.isUpgradedToStartTls;
    }

    private synchronized InputStream getInputStream() {
        return this.inStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpauseReader() throws IOException {
        Object object = this.pauseLock;
        synchronized (object) {
            if (this.paused) {
                this.paused = false;
                this.pauseLock.notify();
            }
        }
    }

    private void pauseReader() throws IOException {
        this.paused = true;
        try {
            while (this.paused) {
                this.pauseLock.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException("Pause/unpause reader has problems.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block28: {
            InputStream inputStream = null;
            block12: while (true) {
                try {
                    while (true) {
                        try {
                            while (true) {
                                byte[] byArray = new byte[129];
                                int n = 0;
                                int n2 = 0;
                                int n3 = 0;
                                inputStream = this.getInputStream();
                                int n4 = inputStream.read(byArray, n, 1);
                                if (n4 < 0) {
                                    if (inputStream != this.getInputStream()) {
                                        continue;
                                    }
                                    break block28;
                                }
                                if (byArray[n++] != 48) continue;
                                n4 = inputStream.read(byArray, n, 1);
                                if (n4 < 0) {
                                    break block28;
                                }
                                if (((n2 = byArray[n++]) & 0x80) == 128) {
                                    int n5;
                                    n3 = n2 & 0x7F;
                                    if (n3 > 4) {
                                        throw new IOException("Length coded with too many bytes: " + n3);
                                    }
                                    boolean bl = false;
                                    for (n4 = 0; n4 < n3; n4 += n5) {
                                        n5 = inputStream.read(byArray, n + n4, n3 - n4);
                                        if (n5 >= 0) continue;
                                        bl = true;
                                        break;
                                    }
                                    if (bl) {
                                        break block28;
                                    }
                                    n2 = 0;
                                    for (int i = 0; i < n3; ++i) {
                                        n2 = (n2 << 8) + (byArray[n + i] & 0xFF);
                                    }
                                    n += n4;
                                }
                                if (n3 > n4) {
                                    throw new IOException("Unexpected EOF while reading length");
                                }
                                if (n2 < 0) {
                                    throw new IOException("Length too big: " + ((long)n2 & 0xFFFFFFFFL));
                                }
                                byte[] byArray2 = IOUtils.readFully(inputStream, n2, false);
                                byArray = Arrays.copyOf(byArray, n + byArray2.length);
                                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                                n += byArray2.length;
                                try {
                                    BerDecoder berDecoder = new BerDecoder(byArray, 0, n);
                                    if (this.traceFile != null) {
                                        Ber.dumpBER(this.traceFile, this.traceTagIn, byArray, 0, n);
                                    }
                                    berDecoder.parseSeq(null);
                                    int n6 = berDecoder.parseInt();
                                    berDecoder.reset();
                                    boolean bl = false;
                                    if (n6 == 0) {
                                        this.parent.processUnsolicited(berDecoder);
                                        continue block12;
                                    }
                                    LdapRequest ldapRequest = this.findRequest(n6);
                                    if (ldapRequest == null) continue block12;
                                    Object object = this.pauseLock;
                                    synchronized (object) {
                                        bl = ldapRequest.addReplyBer(berDecoder);
                                        if (bl) {
                                            this.pauseReader();
                                        }
                                        continue block12;
                                    }
                                }
                                catch (Ber.DecodeException decodeException) {
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (IOException iOException) {
                            if (inputStream != this.getInputStream()) continue;
                            throw iOException;
                        }
                        break;
                    }
                }
                catch (IOException iOException) {
                    this.closureReason = iOException;
                    break block28;
                }
            }
            finally {
                this.cleanup(null, true);
            }
        }
    }

    static final class ProxySocketFactory
    extends SocketFactory {
        final Class<?> socketFactoryClass;
        final Object factory;

        ProxySocketFactory(Class<?> clazz, Object object) {
            this.socketFactoryClass = clazz;
            this.factory = object;
        }

        @Override
        public Socket createSocket() throws IOException {
            try {
                Method method = this.socketFactoryClass.getMethod("createSocket", new Class[0]);
                return (Socket)method.invoke(this.factory, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                throw new IOException(reflectiveOperationException.getMessage(), reflectiveOperationException);
            }
        }

        @Override
        public Socket createSocket(String string, int n) throws IOException {
            try {
                Method method = this.socketFactoryClass.getMethod("createSocket", String.class, Integer.TYPE);
                return (Socket)method.invoke(this.factory, string, n);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                throw new IOException(reflectiveOperationException.getMessage(), reflectiveOperationException);
            }
        }

        @Override
        public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
            throw new RuntimeException("Shouldn't be called");
        }

        @Override
        public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
            throw new RuntimeException("Shouldn't be called");
        }

        @Override
        public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
            throw new RuntimeException("Shouldn't be called");
        }
    }
}

